!#############################################################
SUBROUTINE INIT_TEB_SOIL_PGD_n(TM, GDM, KI, PPGD_CLAY, PPGD_SAND)
!#############################################################
!
!!****  *INIT_TEB_SOIL_PGD_n* - routine to initialize thermal and hydrological
!!                              characteristics of road and building soil columns
!!
!!    PURPOSE
!!    -------
!!
!!**  METHOD
!!    ------
!!
!!    EXTERNAL
!!    --------
!!
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!
!!    AUTHOR
!!    ------
!!	A. Lemonsu  *Meteo France*	
!!
!!    MODIFICATIONS
!!    -------------
!!
!-------------------------------------------------------------------------------
!
!*       0.    DECLARATIONS
!              ------------
!
USE MODD_SURFEX_n, ONLY : TEB_MODEL_t, TEB_GARDEN_MODEL_t
USE MODD_SURF_PAR, ONLY : XUNDEF
USE MODD_TEB_VEG,  ONLY : NTEB_ROAD1,NTEB_ROAD2,             & 
                          NTEB_SOIL1,NTEB_SOIL2,             &
                          XTEB_SOILGRID1,XTEB_SOILGRID2
!
USE MODE_SOIL
!
USE MODI_HEATCAPZ
USE MODI_THRMCONDZ
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*       0.1   Declarations of arguments
!              -------------------------
!
TYPE(TEB_MODEL_t)       , INTENT(INOUT) :: TM
TYPE(TEB_GARDEN_MODEL_t), INTENT(INOUT) :: GDM
INTEGER                 , INTENT(IN)    :: KI             ! Number of grid points
REAL, DIMENSION(:),       INTENT(IN)    :: PPGD_CLAY      ! Clay fraction read in PGD file
REAL, DIMENSION(:),       INTENT(IN)    :: PPGD_SAND      ! Clay fraction read in PGD file
!
!
!*       0.2   Declarations of local variables
!              -------------------------------
!
 CHARACTER(LEN=4)     :: HPEDOTF
 CHARACTER(LEN=12)    :: YRECFM         ! Name of the article to be read
INTEGER               :: JI             ! loop increment
INTEGER               :: JLAYER         ! loop increment
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!-------------------------------------------------------------------------------
!
!               Initialisation for IO
!
IF (LHOOK) CALL DR_HOOK('INIT_TEB_SOIL_PGD_n',0,ZHOOK_HANDLE)
!
!-------------------------------------------------------------------------------
!
!*       1.     Definition of soil vertical discretization for roads
!               ----------------------------------------------------
!
! Now, users define in namelist only the characteristics of structural roads as well as 
! the minimum number of vertical layers required for computation. The final vertical grid
! including structural roads + natural soils below is re-defined here (according to the 
! ISBA option and the level of vertical resolution asked by users)
!
!               1.a   CROAD_GRID='MEDIUM' : medium-resolution for structural-road vertical grid
!                     -------------------------------------------------------------------------
!
  IF (TM%TOP%CROAD_GRID=='LOW   ') THEN 
    IF (GDM%TVG%CISBA=='3-L') THEN
      TM%T%CUR%NTEB_SOIL     = NTEB_SOIL1
      GDM%TGDO%NGROUND_LAYER = 3
      ALLOCATE(TM%T%CUR%XTEB_SOILGRID(TM%T%CUR%NTEB_SOIL))
      TM%T%CUR%XTEB_SOILGRID(1:TM%T%CUR%NTEB_ROAD)   = XTEB_SOILGRID1(1:TM%T%CUR%NTEB_ROAD)
      TM%T%CUR%XTEB_SOILGRID(1:TM%T%CUR%NTEB_ROAD+1) = 1.5
      TM%T%CUR%XTEB_SOILGRID(1:TM%T%CUR%NTEB_ROAD+2) = 3.0
    ELSE IF (GDM%TVG%CISBA=='DIF') THEN
      TM%T%CUR%NTEB_SOIL     = NTEB_SOIL1
      GDM%TGDO%NGROUND_LAYER = NTEB_SOIL1
      ALLOCATE(TM%T%CUR%XTEB_SOILGRID(TM%T%CUR%NTEB_SOIL))
      TM%T%CUR%XTEB_SOILGRID(:) = XTEB_SOILGRID1(:)
    ENDIF
!
!               1.b   CROAD_GRID='MEDIUM' : medium-resolution for structural-road vertical grid
!                     -------------------------------------------------------------------------
!
  ELSE IF (TM%TOP%CROAD_GRID=='MEDIUM') THEN 
!
    IF (GDM%TVG%CISBA=='3-L') THEN
      TM%T%CUR%NTEB_SOIL     = NTEB_SOIL1
      GDM%TGDO%NGROUND_LAYER = 3
      ALLOCATE(TM%T%CUR%XTEB_SOILGRID(TM%T%CUR%NTEB_SOIL))
      TM%T%CUR%XTEB_SOILGRID(1:TM%T%CUR%NTEB_ROAD)   = XTEB_SOILGRID1(1:TM%T%CUR%NTEB_ROAD)
      TM%T%CUR%XTEB_SOILGRID(1:TM%T%CUR%NTEB_ROAD+1) = 1.5
      TM%T%CUR%XTEB_SOILGRID(1:TM%T%CUR%NTEB_ROAD+2) = 3.0
    ELSE IF (GDM%TVG%CISBA=='DIF') THEN
      TM%T%CUR%NTEB_SOIL     = NTEB_SOIL1
      GDM%TGDO%NGROUND_LAYER = NTEB_SOIL1
      ALLOCATE(TM%T%CUR%XTEB_SOILGRID(TM%T%CUR%NTEB_SOIL))
      TM%T%CUR%XTEB_SOILGRID(:) = XTEB_SOILGRID1(:)
    ENDIF
!
!               3.c   CROAD_GRID='HIGH  ' : high-resolution for structural-road vertical grid
!                     -------------------------------------------------------------------------
!
  ELSE IF (TM%TOP%CROAD_GRID=='HIGH  ') THEN
    IF (GDM%TVG%CISBA=='3-L') THEN
      TM%T%CUR%NTEB_SOIL     = NTEB_SOIL2
      GDM%TGDO%NGROUND_LAYER = 3
      ALLOCATE(TM%T%CUR%XTEB_SOILGRID(TM%T%CUR%NTEB_SOIL))
      TM%T%CUR%XTEB_SOILGRID(1:TM%T%CUR%NTEB_ROAD)   = XTEB_SOILGRID2(1:TM%T%CUR%NTEB_ROAD)
      TM%T%CUR%XTEB_SOILGRID(1:TM%T%CUR%NTEB_ROAD+1) = 1.5
      TM%T%CUR%XTEB_SOILGRID(1:TM%T%CUR%NTEB_ROAD+2) = 3.0
    ELSE IF (GDM%TVG%CISBA=='DIF') THEN
      TM%T%CUR%NTEB_SOIL     = NTEB_SOIL2
      GDM%TGDO%NGROUND_LAYER = TM%T%CUR%NTEB_SOIL
      ALLOCATE(TM%T%CUR%XTEB_SOILGRID(TM%T%CUR%NTEB_SOIL))
      TM%T%CUR%XTEB_SOILGRID(:) = XTEB_SOILGRID2(:)
    ENDIF
!
  ENDIF
!
!-------------------------------------------------------------------------------
!
!*       2.      General soil characteristics
!                ----------------------------
!
ALLOCATE(TM%T%CUR%XCLAY_ROAD    (KI,TM%T%CUR%NTEB_SOIL))
ALLOCATE(TM%T%CUR%XSAND_ROAD    (KI,TM%T%CUR%NTEB_SOIL))
ALLOCATE(TM%T%CUR%XCLAY_BLD     (KI,TM%T%CUR%NTEB_SOIL))
ALLOCATE(TM%T%CUR%XSAND_BLD     (KI,TM%T%CUR%NTEB_SOIL))
ALLOCATE(TM%T%CUR%XDG_ROAD      (KI,TM%T%CUR%NTEB_SOIL))
ALLOCATE(TM%T%CUR%XDG_BLD       (KI,TM%T%CUR%NTEB_SOIL))
!
!
!* clay and sand fractions are read in PGD.txt
!  (only 1 level is defined in PGD.txt)
!
DO JLAYER=1,TM%T%CUR%NTEB_SOIL
  TM%T%CUR%XCLAY_ROAD(:,JLAYER) = PPGD_CLAY(:)
  TM%T%CUR%XSAND_ROAD(:,JLAYER) = PPGD_SAND(:)
  TM%T%CUR%XCLAY_BLD (:,JLAYER) = PPGD_CLAY(:)
  TM%T%CUR%XSAND_BLD (:,JLAYER) = PPGD_SAND(:)
ENDDO
!
DO JI=1,KI
 TM%T%CUR%XDG_ROAD(JI,:) = TM%T%CUR%XTEB_SOILGRID
 TM%T%CUR%XDG_BLD (JI,:) = TM%T%CUR%XTEB_SOILGRID
ENDDO
!
!-------------------------------------------------------------------------------
!
!*       3.      Soil hydraulic characteristics for soil under roads/buildings
!                -------------------------------------------------------------
!
ALLOCATE(TM%T%CUR%XCONDSAT_ROAD (KI,TM%T%CUR%NTEB_SOIL))
ALLOCATE(TM%T%CUR%XMPOTSAT_ROAD (KI,TM%T%CUR%NTEB_SOIL))
ALLOCATE(TM%T%CUR%XBCOEF_ROAD   (KI,TM%T%CUR%NTEB_SOIL))
ALLOCATE(TM%T%CUR%XWWILT_ROAD   (KI,TM%T%CUR%NTEB_SOIL)) ! wilting point
ALLOCATE(TM%T%CUR%XWFC_ROAD     (KI,TM%T%CUR%NTEB_SOIL)) ! field capacity
ALLOCATE(TM%T%CUR%XWSAT_ROAD    (KI,TM%T%CUR%NTEB_SOIL)) ! saturation
!
ALLOCATE(TM%T%CUR%XCONDSAT_BLD  (KI,TM%T%CUR%NTEB_SOIL))
ALLOCATE(TM%T%CUR%XMPOTSAT_BLD  (KI,TM%T%CUR%NTEB_SOIL))
ALLOCATE(TM%T%CUR%XBCOEF_BLD    (KI,TM%T%CUR%NTEB_SOIL))
ALLOCATE(TM%T%CUR%XWWILT_BLD    (KI,TM%T%CUR%NTEB_SOIL)) ! wilting point
ALLOCATE(TM%T%CUR%XWFC_BLD      (KI,TM%T%CUR%NTEB_SOIL)) ! field capacity
ALLOCATE(TM%T%CUR%XWSAT_BLD     (KI,TM%T%CUR%NTEB_SOIL)) ! saturation
!
IF (GDM%TVG%CPEDOTF=='CH78'.OR.GDM%TVG%CPEDOTF=='CO84'.OR.GDM%TVG%CPEDOTF=='CP88'.OR.GDM%TVG%CPEDOTF=='WO99') THEN
  HPEDOTF = GDM%TVG%CPEDOTF
ELSE
  HPEDOTF = 'CH78'
ENDIF
!
DO JLAYER=1,TM%T%CUR%NTEB_SOIL
  TM%T%CUR%XBCOEF_ROAD  (:,JLAYER) = BCOEF_FUNC     (TM%T%CUR%XCLAY_ROAD(:,JLAYER),TM%T%CUR%XSAND_ROAD(:,JLAYER),HPEDOTF)
  TM%T%CUR%XMPOTSAT_ROAD(:,JLAYER) = MATPOTSAT_FUNC (TM%T%CUR%XCLAY_ROAD(:,JLAYER),TM%T%CUR%XSAND_ROAD(:,JLAYER),HPEDOTF)
  TM%T%CUR%XCONDSAT_ROAD(:,JLAYER) = HYDCONDSAT_FUNC(TM%T%CUR%XCLAY_ROAD(:,JLAYER),TM%T%CUR%XSAND_ROAD(:,JLAYER),HPEDOTF)
  TM%T%CUR%XWSAT_ROAD   (:,JLAYER) = WSAT_FUNC      (TM%T%CUR%XCLAY_ROAD(:,JLAYER),TM%T%CUR%XSAND_ROAD(:,JLAYER),HPEDOTF)
  TM%T%CUR%XWWILT_ROAD  (:,JLAYER) = WWILT_FUNC     (TM%T%CUR%XCLAY_ROAD(:,JLAYER),TM%T%CUR%XSAND_ROAD(:,JLAYER),HPEDOTF)
  TM%T%CUR%XBCOEF_BLD   (:,JLAYER) = BCOEF_FUNC     (TM%T%CUR%XCLAY_BLD (:,JLAYER),TM%T%CUR%XSAND_BLD (:,JLAYER),HPEDOTF)
  TM%T%CUR%XMPOTSAT_BLD (:,JLAYER) = MATPOTSAT_FUNC (TM%T%CUR%XCLAY_BLD (:,JLAYER),TM%T%CUR%XSAND_BLD (:,JLAYER),HPEDOTF)
  TM%T%CUR%XCONDSAT_BLD (:,JLAYER) = HYDCONDSAT_FUNC(TM%T%CUR%XCLAY_BLD (:,JLAYER),TM%T%CUR%XSAND_BLD (:,JLAYER),HPEDOTF)
  TM%T%CUR%XWSAT_BLD    (:,JLAYER) = WSAT_FUNC      (TM%T%CUR%XCLAY_BLD (:,JLAYER),TM%T%CUR%XSAND_BLD (:,JLAYER),HPEDOTF)
  TM%T%CUR%XWWILT_BLD   (:,JLAYER) = WWILT_FUNC     (TM%T%CUR%XCLAY_BLD (:,JLAYER),TM%T%CUR%XSAND_BLD (:,JLAYER),HPEDOTF)
END DO
!
TM%T%CUR%XWFC_ROAD(:,:) = W33_FUNC(TM%T%CUR%XCLAY_ROAD(:,:),TM%T%CUR%XSAND_ROAD(:,:),HPEDOTF)
TM%T%CUR%XWFC_BLD (:,:) = W33_FUNC(TM%T%CUR%XCLAY_BLD (:,:),TM%T%CUR%XSAND_BLD (:,:),HPEDOTF)
!
!-------------------------------------------------------------------------------
!
!*       4.      Soil thermal characteristics for soil under buildings and roads
!                ---------------------------------------------------------------
!
ALLOCATE(TM%T%CUR%XCONDDRY_ROAD (KI,TM%T%CUR%NTEB_SOIL))
ALLOCATE(TM%T%CUR%XCONDSLD_ROAD (KI,TM%T%CUR%NTEB_SOIL))
ALLOCATE(TM%T%CUR%XHCAPSOIL_ROAD(KI,TM%T%CUR%NTEB_SOIL))
ALLOCATE(TM%T%CUR%XCONDDRY_BLD  (KI,TM%T%CUR%NTEB_SOIL))
ALLOCATE(TM%T%CUR%XCONDSLD_BLD  (KI,TM%T%CUR%NTEB_SOIL))
ALLOCATE(TM%T%CUR%XHCAPSOIL_BLD (KI,TM%T%CUR%NTEB_SOIL))
!
CALL THRMCONDZ(TM%T%CUR%XSAND_ROAD,TM%T%CUR%XWSAT_ROAD,TM%T%CUR%XCONDDRY_ROAD,TM%T%CUR%XCONDSLD_ROAD)
CALL THRMCONDZ(TM%T%CUR%XSAND_BLD ,TM%T%CUR%XWSAT_BLD ,TM%T%CUR%XCONDDRY_BLD ,TM%T%CUR%XCONDSLD_BLD )
CALL HEATCAPZ (TM%T%CUR%XSAND_ROAD,TM%T%CUR%XHCAPSOIL_ROAD)
CALL HEATCAPZ (TM%T%CUR%XSAND_BLD ,TM%T%CUR%XHCAPSOIL_BLD )
!
!-------------------------------------------------------------------------------
!
IF (LHOOK) CALL DR_HOOK('INIT_TEB_SOIL_PGD_n',1,ZHOOK_HANDLE)
!
END SUBROUTINE INIT_TEB_SOIL_PGD_n
