!#############################################################
SUBROUTINE INIT_TEB_HYDRO_n(DTCO,U,HM,                      &
                            KPATCH, KTEB_SOIL, PD_ROAD,     &
                            HPROGRAM,HINIT,KI)
!#############################################################
!
!!****  *INIT_TEB_HYDRO_n* - routine to initialize ISBA for urban hydrology
!!
!!    PURPOSE
!!    -------
!!
!!**  METHOD
!!    ------
!!
!!    EXTERNAL
!!    --------
!!
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!
!!    AUTHOR
!!    ------
!!	A. Lemonsu  *Meteo France*	
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    02/2013
!-------------------------------------------------------------------------------
!
!*       0.    DECLARATIONS
!              ------------
!
!USE MODD_TYPE_DATE_SURF
!USE MODD_TYPE_SNOW
!
USE MODD_DATA_COVER_n, ONLY : DATA_COVER_t
USE MODD_SURF_ATM_n,   ONLY : SURF_ATM_t
USE MODD_SURFEX_n,     ONLY : TEB_HYDRO_MODEL_t
!
USE MODI_GET_LUOUT
USE MODI_ALLOCATE_TEB_HYDRO
USE MODI_READ_TEB_HYDRO_n
USE MODI_OPEN_FILE
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*       0.1   Declarations of arguments
!              -------------------------
!
TYPE(DATA_COVER_t),      INTENT(INOUT) :: DTCO
TYPE(SURF_ATM_t),        INTENT(INOUT) :: U
TYPE(TEB_HYDRO_MODEL_t), INTENT(INOUT) :: HM
INTEGER,                 INTENT(IN)    :: KPATCH      !
INTEGER,                 INTENT(IN)    :: KTEB_SOIL   !
REAL, DIMENSION(:,:),    INTENT(IN)    :: PD_ROAD     ! soil layer thickness (m)
CHARACTER(LEN=6),        INTENT(IN)    :: HPROGRAM    ! program calling surf. schemes
CHARACTER(LEN=3),        INTENT(IN)    :: HINIT       ! choice of fields to initialize
INTEGER,                 INTENT(IN)    :: KI          ! number of points
!
!
!
!*       0.2   Declarations of local variables
!              -------------------------------
!
INTEGER                       :: ILUOUT      ! unit of output listing file
INTEGER                       :: JTEB_PATCH  ! loop counter on TEB patches
CHARACTER(LEN=3)              :: YPATCH      ! patch identificator
!
!KC
REAL, DIMENSION(KI)           :: ZLSEW_TOT
REAL                          :: ZDEPTH
INTEGER                       :: IUNIT,JI
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!-------------------------------------------------------------------------------
!
!               Initialisation for IO
!
IF (LHOOK) CALL DR_HOOK('INIT_TEB_HYDRO_N',0,ZHOOK_HANDLE)
CALL GET_LUOUT(HPROGRAM,ILUOUT)
!
!-------------------------------------------------------------------------------
!
CALL ALLOCATE_TEB_HYDRO(HM, KI, KTEB_SOIL)  
!
!-------------------------------------------------------------------------------
!
IF (HINIT/='ALL') THEN
  IF (LHOOK) CALL DR_HOOK('INIT_TEB_HYDRO_N',1,ZHOOK_HANDLE)      
  RETURN
ENDIF
!
!! TEST pour pas de temps de sortie et pas de temps de calcul à mettre dans
!routine de calcul des diagnostics
!IF (MOD(XTSTEP_OUTPUT,XTSTEP_SURF)==0) THEN 
!   HM%THP%NSTEP_OUT  = XTSTEP_OUTPUT/XTSTEP_SURF              
!   HM%THP%NSTEP_SURF = 0
!ELSE
!   PRINT*,'ATTENTION, PAS DE TEMPS DES SORTIES=',XTSTEP_OUTPUT,' ET PAS DE TEMPS MODELE=',XTSTEP_SURF,' NON COMPATIBLES'
!   STOP
!ENDIF
!
!-------------------------------------------------------------------------------
!
!*   1       Allocations
!
ALLOCATE(HM%THP%XDENSITY_SEW(KI))
ALLOCATE(HM%THP%NLAYER_SEWER(KI))
!
HM%TH%CUR%XNOC(:)      = 0.0
HM%THP%XDENSITY_SEW(:) = 0.0
HM%THP%NLAYER_SEWER(:) = 1
!
!*   2.1      Sewer density
!
ZLSEW_TOT(:)           = HM%THP%XLSEWER(:) + HM%THP%XLSTORM(:)
HM%THP%XDENSITY_SEW(:) = ZLSEW_TOT(:)/MAXVAL(ZLSEW_TOT(:))
!
!*   2.2      Sewer layer
!
DO JI=1,KI
  ZDEPTH    = PD_ROAD(JI,HM%THP%NLAYER_SEWER(JI))
  DO WHILE (ZDEPTH.LT.HM%THP%XDSEWER(JI).AND.(HM%THP%NLAYER_SEWER(JI).LT.KTEB_SOIL))
    HM%THP%NLAYER_SEWER(JI) = HM%THP%NLAYER_SEWER(JI) + 1
    ZDEPTH    = ZDEPTH + PD_ROAD(JI,HM%THP%NLAYER_SEWER(JI))
  ENDDO
ENDDO
!
WHERE (HM%THP%XLSEWER==0.0)
  HM%THP%NLAYER_SEWER=0
ENDWHERE
!
!-------------------------------------------------------------------------------
!
!*      3.      Prognostic and semi-prognostic fields
!               -------------------------------------
!
!* allocation of urban green area variables
!
  YPATCH='   '
    IF (KPATCH>1) WRITE(YPATCH,FMT='(A,I1,A)') 'T',KPATCH,'_'
!
  CALL READ_TEB_HYDRO_n(DTCO,U,HM,HPROGRAM,YPATCH,KTEB_SOIL)
!
!-------------------------------------------------------------------------------
!
IF (LHOOK) CALL DR_HOOK('INIT_TEB_HYDRO_N',1,ZHOOK_HANDLE)
!
!-------------------------------------------------------------------------------
!
END SUBROUTINE INIT_TEB_HYDRO_n
