!#############################################################
        SUBROUTINE INIT_TEB_GARDEN_PGD_n (DTCO, U, CHI, DTI, I, DST, SLT, TM, GDM, HM,               &
                                          KTEB_SOIL, PTEB_SOILGRID,                                  &
                                          PCONDDRY_ROAD, PHCAPSOIL_ROAD,                             &
                                          HPROGRAM,HINIT, OREAD_PGD,KI, KSV, HSV, KVERSION, KBUGFIX, &
                                          PCO2, PRHOA)
        !#############################################################
        !
        !!****  *INIT_TEB_GARDEN_PGD_n* - routine to initialize ISBA
        !!
        !!    PURPOSE
        !!    -------
        !!
        !!**  METHOD
        !!    ------
        !!
        !!    EXTERNAL
        !!    --------
        !!
        !!
        !!    IMPLICIT ARGUMENTS
        !!    ------------------
        !!
        !!    REFERENCE
        !!    ---------
        !!
        !!
        !!    AUTHOR
        !!    ------
        !!      A. Lemonsu  *Meteo France*
        !!
        !!    MODIFICATIONS
        !!    -------------
        !!      Original    09/2009
        !!                  11/2013 (B. Decharme) No exp profile with DIF
        !!                  01/2016 (E Redon/A Lemonsu) New fields for urban trees
        !!                  01/2016 (K Chancibault/A Lemonsu) New fields for urban hydrology
        !-------------------------------------------------------------------------------
        !
        !*       0.    DECLARATIONS
        !              ------------
        !
        !
        USE MODD_DATA_COVER_n, ONLY : DATA_COVER_t
        USE MODD_SURF_ATM_n, ONLY : SURF_ATM_t
        USE MODD_CH_ISBA_n, ONLY : CH_ISBA_t
        USE MODD_DATA_ISBA_n, ONLY : DATA_ISBA_t
        USE MODD_ISBA_n, ONLY : ISBA_t
        USE MODD_DST_n, ONLY : DST_t
        USE MODD_SLT_n, ONLY : SLT_t
        USE MODD_SURFEX_n, ONLY : TEB_MODEL_t, TEB_GARDEN_MODEL_t, TEB_HYDRO_MODEL_t
        !
        USE MODD_TYPE_DATE_SURF
        USE MODD_TYPE_SNOW
        !
                                        
        USE MODD_DATA_COVER_PAR,  ONLY: NVEGTYPE
        USE MODD_SURF_PAR,        ONLY: XUNDEF, NUNDEF

        USE MODD_SGH_PAR,         ONLY: NDIMTAB, XF_DECAY
        !
        USE MODI_GET_LUOUT
        USE MODI_ALLOCATE_TEB_GARDEN_PGD
        USE MODI_READ_PGD_TEB_GARDEN_n
        USE MODI_CONVERT_PATCH_GARDEN
        USE MODI_INIT_FROM_DATA_GRDN_n
        USE MODI_INIT_VEG_PGD_GARDEN_n
        USE MODI_EXP_DECAY_SOIL_FR
        USE MODI_ABOR1_SFX
        !
        USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
        USE PARKIND1  ,ONLY : JPRB
        !
        IMPLICIT NONE
        !
        !*       0.1   Declarations of arguments
        !              -------------------------
        !
        !
        TYPE(DATA_COVER_t), INTENT(INOUT) :: DTCO
        TYPE(SURF_ATM_t), INTENT(INOUT) :: U
        TYPE(CH_ISBA_t), INTENT(INOUT) :: CHI
        TYPE(DATA_ISBA_t), INTENT(INOUT) :: DTI
        TYPE(ISBA_t), INTENT(INOUT) :: I
        TYPE(DST_t), INTENT(INOUT) :: DST
        TYPE(SLT_t), INTENT(INOUT) :: SLT
        TYPE(TEB_MODEL_t), INTENT(INOUT) :: TM
        TYPE(TEB_GARDEN_MODEL_t), INTENT(INOUT) :: GDM
        TYPE(TEB_HYDRO_MODEL_t), INTENT(INOUT) :: HM
        !
        INTEGER                         , INTENT(IN) :: KTEB_SOIL
        REAL,             DIMENSION(:)  , INTENT(IN) :: PTEB_SOILGRID
        REAL,             DIMENSION(:,:), INTENT(IN) :: PCONDDRY_ROAD
        REAL,             DIMENSION(:,:), INTENT(IN) :: PHCAPSOIL_ROAD
         CHARACTER(LEN=6),                INTENT(IN) :: HPROGRAM  ! program calling surf. schemes
         CHARACTER(LEN=3),                INTENT(IN) :: HINIT     ! choice of fields to initialize
        LOGICAL,                          INTENT(IN) :: OREAD_PGD ! flag to read PGD fields in the file
        INTEGER,                          INTENT(IN) :: KI        ! number of points
        INTEGER,                          INTENT(IN) :: KSV       ! number of scalars
         CHARACTER(LEN=6),DIMENSION(KSV), INTENT(IN) :: HSV       ! name of all scalar variables
        INTEGER,                          INTENT(IN) :: KVERSION  ! version number of the file being read
        INTEGER,                          INTENT(IN) :: KBUGFIX
        REAL,             DIMENSION(KI),  INTENT(IN) :: PCO2        ! CO2 concentration (kg/m3)
        REAL,             DIMENSION(KI),  INTENT(IN) :: PRHOA       ! air density
        !
        !
        !
        !*       0.2   Declarations of local variables
        !              -------------------------------
        !
        INTEGER           :: JILU     ! loop increment
        INTEGER           :: ILUOUT   ! unit of output listing file
        !
        INTEGER           :: IDECADE  ! decade of simulation
        !
        INTEGER :: JVEGTYPE, JLAYER  ! loop counter on vegtypes
        !
        REAL, DIMENSION(KI)               :: ZF
        REAL, DIMENSION(KI)               :: ZWORK
        REAL, DIMENSION(KI)               :: ZFRAC_HVEG,ZHTRUNK_HVEG,ZWCROWN_HVEG
        REAL, DIMENSION(KI)               :: ZLAI_HVEG,ZLAI_LVEG,ZALB_HVEG,ZALB_LVEG
        REAL, DIMENSION(KI)               :: ZLSEWER, ZLSTORM, ZDSEWER
        REAL                              :: ZWS_ROOF_MAX, ZWS_ROAD_MAX
        REAL                              :: ZIP_SEWER, ZCONNEX, ZINFIL_ROAD
        REAL(KIND=JPRB) :: ZHOOK_HANDLE
        !
        !-------------------------------------------------------------------------------
        !
        !               Initialisation for IO
        !
        IF (LHOOK) CALL DR_HOOK('INIT_TEB_GARDEN_PGD_n',0,ZHOOK_HANDLE)
         CALL GET_LUOUT(HPROGRAM,ILUOUT)
        !
        !-------------------------------------------------------------------------------
        !
        !*       2.     Physiographic fields
        !               --------------------
        !
        !* allocation of urban green area variables
        !
         CALL ALLOCATE_TEB_GARDEN_PGD(GDM%TGDPE, GDM%TGDP, HM%THP,                            &
                                      OREAD_PGD, KI, NVEGTYPE, GDM%TGDO%NGROUND_LAYER, NDIMTAB)  
        !
        !
        !*       2.1    Cover, soil and orographic fields:
        !               ---------------------------------
        !
        IF (OREAD_PGD) &
         CALL READ_PGD_TEB_GARDEN_n(TM%CHT, DTCO, GDM%DTGD, HM%DTH,                  &
                                    GDM%GBGD, U, GDM%TGDO, GDM%TGDP, TM%TG, TM%TOP,  &
                                    HPROGRAM,KVERSION,KBUGFIX)
        !
        !
        !*       2.3    Physiographic data fields from land cover:
        !               -----------------------------------------
        !
        IF (TM%TOP%TTIME%TDATE%MONTH /= NUNDEF) THEN
          IDECADE = 3 * ( TM%TOP%TTIME%TDATE%MONTH - 1 ) + MIN(TM%TOP%TTIME%TDATE%DAY-1,29) / 10 + 1
        ELSE
          IDECADE = 1
        END IF
        !
        !
        IF (.NOT. GDM%TGDO%LPAR_GARDEN) THEN
          CALL CONVERT_PATCH_GARDEN(TM%BDD, TM%DTB, DTCO, TM%DTT, TM%TOP, GDM%DTGD, HM%DTH, &
                                    DTI, I, GDM%TGDO, GDM%TGDPE, GDM%TGDP, HM%THP, GDM%TVG, &
                                    KI, IDECADE,                                            &
                                    KTEB_SOIL, PTEB_SOILGRID,                               &
                                    PCONDDRY_ROAD, PHCAPSOIL_ROAD                           )
        ELSE
          CALL INIT_FROM_DATA_GRDN_n(GDM%DTGD, HM%DTH,                                                       &
                                    IDECADE,GDM%TVG%CPHOTO, GDM%TGDPE%CUR%XVEG,                              &
                                    GDM%TGDPE%CUR%XLAI,GDM%TGDP%XRSMIN,GDM%TGDP%XGAMMA,                      &
                                    GDM%TGDP%XWRMAX_CF, GDM%TGDP%XRGL,GDM%TGDP%XCV,GDM%TGDP%XDG,             &
                                    GDM%TGDP%XD_ICE,GDM%TGDPE%CUR%XZ0,GDM%TGDP%XZ0_O_Z0H,                    &
                                    GDM%TGDP%XALBNIR_VEG,GDM%TGDP%XALBVIS_VEG,                               &
                                    GDM%TGDP%XALBUV_VEG,GDM%TGDPE%CUR%XEMIS,                                 &
                                    GDM%TGDP%XVEGTYPE,GDM%TGDP%XROOTFRAC,GDM%TGDP%XGMES,                     &
                                    GDM%TGDP%XBSLAI,GDM%TGDP%XLAIMIN,GDM%TGDP%XSEFOLD,GDM%TGDP%XGC,          &
                                    GDM%TGDP%XDMAX, GDM%TGDP%XF2I, GDM%TGDP%LSTRESS, GDM%TGDP%XH_TREE,       &
                                    GDM%TGDP%XRE25,GDM%TGDP%XCE_NITRO,GDM%TGDP%XCF_NITRO,GDM%TGDP%XCNA_NITRO )
          !
          ! Case of urban high vegetation
          IF (TM%TOP%CURBTREE=='TREE'.OR.TM%TOP%CURBTREE=='GRWL') THEN
            CALL INIT_FROM_DATA_GRDN_n(GDM%DTGD, HM%DTH,                                                     &
                                       IDECADE,GDM%TVG%CPHOTO,                                               &
                                       PFRAC_HVEG=ZFRAC_HVEG,                                                & 
                                       PHTRUNK_HVEG=ZHTRUNK_HVEG, PWCROWN_HVEG=ZWCROWN_HVEG,                 &
                                       PLAI_HVEG=ZLAI_HVEG, PLAI_LVEG=ZLAI_LVEG,                             &
                                       PALB_HVEG=ZALB_HVEG, PALB_LVEG=ZALB_LVEG                              )
            GDM%TGDP%XFRAC_HVEG   = ZFRAC_HVEG
            GDM%TGDP%XHTRUNK_HVEG = ZHTRUNK_HVEG
            GDM%TGDP%XWCROWN_HVEG = ZWCROWN_HVEG
            GDM%TGDP%XLAI_HVEG    = ZLAI_HVEG
            GDM%TGDP%XLAI_LVEG    = ZLAI_LVEG
            GDM%TGDP%XALB_HVEG    = ZALB_HVEG
            GDM%TGDP%XALB_LVEG    = ZALB_LVEG
          ENDIF 
          !
          ! Case of urban hydrology
          IF (TM%TOP%LURBHYDRO) THEN
            CALL INIT_FROM_DATA_GRDN_n(GDM%DTGD, HM%DTH,                                                     &
                                       IDECADE,GDM%TVG%CPHOTO,                                               &
                                       PLSEWER=ZLSEWER, PLSTORM=ZLSTORM, PDSEWER=ZDSEWER,                    & 
                                       PWS_ROOF_MAX=ZWS_ROOF_MAX, PWS_ROAD_MAX=ZWS_ROAD_MAX,                 &
                                       PIP_SEWER=ZIP_SEWER, PCONNEX=ZCONNEX, PINFIL_ROAD=ZINFIL_ROAD         )
            HM%THP%XLSEWER      = ZLSEWER
            HM%THP%XLSTORM      = ZLSTORM
            HM%THP%XDSEWER      = ZDSEWER
            HM%THP%XWS_ROOF_MAX = ZWS_ROOF_MAX
            HM%THP%XWS_ROAD_MAX = ZWS_ROAD_MAX
            HM%THP%XIP_SEWER    = ZIP_SEWER
            HM%THP%XCONNEX      = ZCONNEX
            HM%THP%XINFIL_ROAD  = ZINFIL_ROAD
          ENDIF 
          !
          IF (GDM%TVG%CISBA=='DIF') THEN
            WHERE(TM%T%CUR%XGARDEN(:)/=0.)
              GDM%TGDP%NWG_LAYER(:)=GDM%TGDO%NGROUND_LAYER 
              GDM%TGDP%XDG2  (:)=0.0
              GDM%TGDP%XDROOT(:)=0.0
            ENDWHERE
            DO JLAYER=GDM%TGDO%NGROUND_LAYER,1,-1
              DO JILU=1,KI
                IF(TM%T%CUR%XGARDEN(JILU)/=0..AND.GDM%TGDP%XROOTFRAC(JILU,JLAYER)>=1.0)THEN
                  GDM%TGDP%XDG2  (JILU)=GDM%TGDP%XDG(JILU,JLAYER)
                  GDM%TGDP%XDROOT(JILU)=GDM%TGDP%XDG(JILU,JLAYER)
                ENDIF
              ENDDO
            ENDDO
          ENDIF

        END IF
        !
        WHERE (TM%T%CUR%XGARDEN(:)==0.)
          GDM%TGDPE%CUR%XVEG(:)=0.
          GDM%TGDPE%CUR%XLAI(:)=0.
          GDM%TGDP%XRSMIN(:)=40.
          GDM%TGDP%XGAMMA(:)=0.
          GDM%TGDP%XWRMAX_CF(:)=0.2
          GDM%TGDP%XRGL(:)=100.
          GDM%TGDP%XCV(:)=2.E-5
          GDM%TGDPE%CUR%XZ0(:)=0.013
          GDM%TGDP%XZ0_O_Z0H(:)=10.
          GDM%TGDP%XALBNIR_VEG(:)=0.30
          GDM%TGDP%XALBVIS_VEG(:)=0.30
          GDM%TGDP%XALBUV_VEG(:)=0.06
          GDM%TGDPE%CUR%XEMIS(:)=0.94
        ENDWHERE  
        !
        IF (GDM%TVG%CPHOTO/='NON') THEN
          WHERE (TM%T%CUR%XGARDEN(:)==0.)
            GDM%TGDP%XGMES(:)=0.020
            GDM%TGDP%XBSLAI(:)=0.36
            GDM%TGDP%XLAIMIN(:)=0.3
            GDM%TGDP%XSEFOLD(:)=90*86400.
            GDM%TGDP%XH_TREE(:)=0.
            GDM%TGDP%XRE25(:)=3.6E-7
            GDM%TGDP%XGC(:)=0.00025
          END WHERE
          IF (GDM%TVG%CPHOTO/='AGS' .AND. GDM%TVG%CPHOTO/='LAI') THEN
            WHERE (TM%T%CUR%XGARDEN(:)==0.) 
              GDM%TGDP%XDMAX(:)=0.1
              GDM%TGDP%XF2I(:)=0.3
            END WHERE
            IF (GDM%TVG%CPHOTO=='NIT' .OR. GDM%TVG%CPHOTO=='NCB') THEN
              WHERE (TM%T%CUR%XGARDEN(:)==0.)      
                GDM%TGDP%XCE_NITRO(:)=7.68
                GDM%TGDP%XCF_NITRO(:)=-4.33
                GDM%TGDP%XCNA_NITRO(:)=1.3
              END WHERE
            ENDIF
          ENDIF
        ENDIF
        IF(GDM%TVG%CISBA/='DIF')THEN
          DO JLAYER=1,GDM%TGDO%NGROUND_LAYER
            WHERE (TM%T%CUR%XGARDEN(:)==0.)
              GDM%TGDP%XDG(:,JLAYER)=0.2*JLAYER
            END WHERE
          ENDDO
        ELSE
          WHERE (TM%T%CUR%XGARDEN(:)==0.) 
            GDM%TGDP%XDG(:,1)=0.01
            GDM%TGDP%XDG(:,2)=0.04
            GDM%TGDP%XROOTFRAC(:,1)=0.
            GDM%TGDP%XROOTFRAC(:,2)=0.
          END WHERE        
          DO JLAYER=3,GDM%TGDO%NGROUND_LAYER
            WHERE (TM%T%CUR%XGARDEN(:)==0.)
              GDM%TGDP%XDG(:,JLAYER)=0.1*(JLAYER-2)
              GDM%TGDP%XROOTFRAC(:,JLAYER)=0.
            END WHERE
          ENDDO               
          WHERE (TM%T%CUR%XGARDEN(:)==0.) 
            GDM%TGDP%NWG_LAYER(:)=GDM%TGDO%NGROUND_LAYER
            GDM%TGDP%XDROOT   (:)=0.0
            GDM%TGDP%XDG2     (:)=GDM%TGDP%XDG(:,GDM%TGDO%NGROUND_LAYER-1)
          ENDWHERE    
        ENDIF  
        WHERE (TM%T%CUR%XGARDEN(:)==0.) 
          GDM%TGDP%XD_ICE(:)=0.8*GDM%TGDP%XDG(:,2)
        END WHERE  
        DO JVEGTYPE=1,NVEGTYPE
          WHERE (TM%T%CUR%XGARDEN(:)==0.)
            GDM%TGDP%XVEGTYPE(:,JVEGTYPE)=0.
            GDM%TGDP%XVEGTYPE(:,1)=1.
          END WHERE
        ENDDO
        !
         CALL INIT_VEG_PGD_GARDEN_n(CHI, DTCO, DST, I, SLT, U, &
                            HPROGRAM, ILUOUT, KI, GDM%TGDO%NGROUND_LAYER, TM%TOP%TTIME%TDATE%MONTH,    &
                        GDM%TGDP%XVEGTYPE, GDM%TGDP%XTDEEP, GDM%TGDP%XGAMMAT, GDM%TVG%CPHOTO, HINIT, &
                        GDM%TVG%LTR_ML, GDM%TVG%CRUNOFF, GDM%TVG%NNBIOMASS, PCO2, PRHOA, &
                        GDM%TGDP%XABC, GDM%TGDP%XPOI, GDM%TGDP%XGMES, GDM%TGDP%XGC, GDM%TGDP%XDMAX, &
                        GDM%TGDP%XANMAX, GDM%TGDP%XFZERO, GDM%TGDP%XEPSO, GDM%TGDP%XGAMM, GDM%TGDP%XQDGAMM,   &
                        GDM%TGDP%XQDGMES, GDM%TGDP%XT1GMES, GDM%TGDP%XT2GMES, GDM%TGDP%XAMAX, GDM%TGDP%XQDAMAX, &
                        GDM%TGDP%XT1AMAX, GDM%TGDP%XT2AMAX,GDM%TGDP%XAH, GDM%TGDP%XBH,            &
                        KSV, HSV, TM%CHT%SVT, TM%CHT%CCH_NAMES, TM%CHT%CAER_NAMES,TM%CHT%CDSTNAMES, TM%CHT%CSLTNAMES, &
                        TM%CHT%CCHEM_SURF_FILE, GDM%TGDP%XCLAY, GDM%TGDP%XSAND, GDM%TVG%CPEDOTF,      &
                        GDM%TGDP%XCONDSAT, GDM%TGDP%XMPOTSAT, GDM%TGDP%XBCOEF, GDM%TGDP%XWWILT, &
                        GDM%TGDP%XWFC, GDM%TGDP%XWSAT, GDM%TGDP%XTAUICE, GDM%TGDP%XCGSAT, GDM%TGDP%XC1SAT, &
                        GDM%TGDP%XC2REF, GDM%TGDP%XC3, GDM%TGDP%XC4B, GDM%TGDP%XACOEF, GDM%TGDP%XPCOEF, &
                        GDM%TGDP%XC4REF, GDM%TGDP%XPCPS, GDM%TGDP%XPLVTT, GDM%TGDP%XPLSTT,        &
                        GDM%TVG%CSCOND, GDM%TVG%CISBA, GDM%TGDP%XHCAPSOIL, GDM%TGDP%XCONDDRY, &
                        GDM%TGDP%XCONDSLD, GDM%TVG%CCPSURF, GDM%TGDP%XDG, GDM%TGDP%XDROOT, GDM%TGDP%XDG2, &
                        GDM%TGDP%XROOTFRAC, GDM%TGDP%XRUNOFFD, GDM%TGDP%XDZG, GDM%TGDP%XDZDIF,       &
                        GDM%TGDP%XSOILWGHT, GDM%TGDP%NWG_LAYER, GDM%TGDO%NLAYER_HORT, &
                        GDM%TGDO%NLAYER_DUN, GDM%TGDP%XD_ICE,  &
                        GDM%TGDP%XKSAT_ICE, GDM%TGDP%XALBNIR_DRY, GDM%TGDP%XALBVIS_DRY, GDM%TGDP%XALBUV_DRY,   &
                        GDM%TGDP%XALBNIR_WET, GDM%TGDP%XALBVIS_WET, GDM%TGDP%XALBUV_WET, GDM%TGDP%XBSLAI_NITRO, &
                        GDM%TGDP%XCE_NITRO, GDM%TGDP%XCNA_NITRO, GDM%TGDP%XCF_NITRO                            )
!
!-------------------------------------------------------------------------------
!
IF(GDM%TVG%CISBA=='DIF'.AND.GDM%TVG%LSOC)THEN
  CALL ABOR1_SFX('INIT_TEB_GARDEN_PGDn: SUBGRID Soil organic matter'//&
                 ' effect (LSOC) NOT YET IMPLEMENTED FOR GARDEN')
ELSEIF (GDM%TVG%CISBA=='3-L'.AND.GDM%TVG%CKSAT=='EXP') THEN 
  CALL ABOR1_SFX('INIT_TEB_GARDEN_PGDn: topmodel exponential decay not implemented for garden')
ENDIF
!
IF(GDM%TVG%CKSAT=='SGH' .AND. GDM%TVG%CISBA/='DIF' .AND. HINIT/='PRE')THEN 
  ZF(:)=MIN(4.0/GDM%TGDP%XDG(:,2),XF_DECAY)
  CALL EXP_DECAY_SOIL_FR(GDM%TVG%CISBA, ZF(:),GDM%TGDP%XC1SAT(:),GDM%TGDP%XC2REF(:),&
                         GDM%TGDP%XDG(:,:),GDM%TGDP%XD_ICE(:),GDM%TGDP%XC4REF(:),&
                         GDM%TGDP%XC3(:,:),GDM%TGDP%XCONDSAT(:,:),GDM%TGDP%XKSAT_ICE(:))
ENDIF
!
!-------------------------------------------------------------------------------
!
IF (LHOOK) CALL DR_HOOK('INIT_TEB_GARDEN_PGD_n',1,ZHOOK_HANDLE)
!
!-------------------------------------------------------------------------------
!
!
END SUBROUTINE INIT_TEB_GARDEN_PGD_n
