!     #########
      SUBROUTINE INIT_OUTPUT_NC_n (BDD, CHE, CHN, CHU, DTS, DTT, DTZ, I, UG, U, DGU)
!     ######################
!
!!****  *INIT_OUTPUT_NC* Keep in memory the netcdf ID of the output files
!!
!!    PURPOSE
!!    -------
!
!!
!!**  IMPLICIT ARGUMENTS
!!    ------------------
!!      None 
!!
!!    REFERENCE
!!    ---------
!!
!!    AUTHOR
!!    ------
!!      F. Habets   *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      modified 05/04 by P. LeMoigne *Meteo France*
!!      modified 06/10 by S. Faroux *Meteo France*
!!=================================================================
!
!*       0.   DECLARATIONS
!             ------------
!
USE MODD_DIAG_SURF_ATM_n, ONLY : DIAG_SURF_ATM_t
USE MODD_BLD_DESCRIPTION_n, ONLY : BLD_DESC_t
USE MODD_CH_EMIS_FIELD_n, ONLY : CH_EMIS_FIELD_t
USE MODD_CH_SNAP_n, ONLY : CH_EMIS_SNAP_t
USE MODD_CH_SURF_n, ONLY : CH_SURF_t
USE MODD_DATA_SEAFLUX_n, ONLY : DATA_SEAFLUX_t
USE MODD_DATA_TEB_n, ONLY : DATA_TEB_t
USE MODD_DATA_TSZ0_n, ONLY : DATA_TSZ0_t
USE MODD_ISBA_n, ONLY : ISBA_t
USE MODD_SURF_ATM_GRID_n, ONLY : SURF_ATM_GRID_t
USE MODD_SURF_ATM_n, ONLY : SURF_ATM_t
!
USE MODD_SURF_CONF,      ONLY : CSOFTWARE
!
USE MODD_SURFEX_MPI, ONLY : NPIO, NRANK
!
USE MODD_OL_FILEID, ONLY : XVAR_TO_FILEOUT, XID, XOUT
!
USE MODD_DATA_COVER, ONLY : LDATA_IRRIG
USE MODD_DATA_COVER_PAR, ONLY : NVEGTYPE, JPCOVER
!
!
!
!
USE MODD_IO_SURF_NC, ONLY : CFILEOUT_NC, NID_NC, &
                            LCREATED, CFILEOUT_NC_SAVE, LDEF
!
USE MODN_IO_OFFLINE, ONLY : LRESTART, LWRITE_COORD
!
USE MODE_GRIDTYPE_GAUSS
!
USE MODI_GET_BLD_CONF_n
USE MODI_GET_DATA_SEAFLUX_CONF_n
USE MODI_GET_ISBA_CONF_n
USE MODI_OL_DEFINE_DIM
USE MODI_CREATE_FILE
!
USE MODI_GET_DIM_FULL_n
USE MODI_DEF_VAR_NETCDF
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
INCLUDE "netcdf.inc"
!
!
TYPE(BLD_DESC_t), INTENT(INOUT) :: BDD
TYPE(CH_EMIS_FIELD_t), INTENT(INOUT) :: CHE
TYPE(CH_EMIS_SNAP_t), INTENT(INOUT) :: CHN
TYPE(CH_SURF_t), INTENT(INOUT) :: CHU
TYPE(DATA_SEAFLUX_t), INTENT(INOUT) :: DTS
TYPE(DATA_TEB_t), INTENT(INOUT) :: DTT
TYPE(DATA_TSZ0_t), INTENT(INOUT) :: DTZ
TYPE(ISBA_t), INTENT(INOUT) :: I
TYPE(SURF_ATM_GRID_t), INTENT(INOUT) :: UG
TYPE(SURF_ATM_t), INTENT(INOUT) :: U
TYPE(DIAG_SURF_ATM_t), INTENT(INOUT) :: DGU
!
 CHARACTER(LEN=100), DIMENSION(:), POINTER :: YNAME_DIM
 CHARACTER(LEN=100), DIMENSION(1) :: YATT_TITLE, YATT
 CHARACTER(LEN=13),DIMENSION(1)  :: YUNIT1, YUNIT2
 CHARACTER(LEN=3)                 :: YISBA 
!
REAL,DIMENSION(:), POINTER       :: ZX, ZY
!
INTEGER, DIMENSION(:), POINTER   :: IDIMS, IDDIM
INTEGER           :: IDIM1, INDIMS
INTEGER          :: INI, INPATCH, INLVLD, INLVLS, INBIOMASS, &
                    INLITTER, INLITTLEVS, INSOILCARB
INTEGER          :: IDESC_ROOF_LAYER, IDESC_ROAD_LAYER, IDESC_WALL_LAYER, &
                    IDESC_FLOOR_LAYER, IDESC_CODE, IDESC_USE, IDESC_AGE, IDESC_BLD
INTEGER          :: IRET, IL, IFULL, ISNAP, INLATI
INTEGER          :: ILUOUT, IDIMID, ITIME, ITOT
INTEGER          :: ID0
!
LOGICAL          :: GEXIST, GOPENED, GSST_DATA
LOGICAL          :: GDATA_BLDTYPE, GDATA_IND_BLD_AGE, GDATA_COL_BLD_AGE, GDATA_USETYPE
!
REAL(KIND=JPRB)  :: ZHOOK_HANDLE
!------------------------------------------------------------------------------ 
IF (LHOOK) CALL DR_HOOK('INIT_OUTPUT_NC_N',0,ZHOOK_HANDLE)
!
CALL GET_DIM_FULL_n(U, &
                    IFULL)

IF (NRANK==NPIO) THEN
  INQUIRE(FILE=CFILEOUT_NC,EXIST=GEXIST)
  INQUIRE(FILE=CFILEOUT_NC,OPENED=GOPENED)
  IF (.NOT.GOPENED) THEN
    IRET = NF_OPEN(CFILEOUT_NC,NF_WRITE,NID_NC)
  ENDIF
  IF (.NOT.GEXIST .OR. .NOT.LCREATED .OR. CFILEOUT_NC/=CFILEOUT_NC_SAVE) THEN
    IF (CSOFTWARE=='PREP' .OR. CSOFTWARE=='OFFLINE' .OR. CSOFTWARE=='SODA') THEN
      CALL GET_ISBA_CONF_n(I, &
                           YISBA, INPATCH, INLVLD, INLVLS, INBIOMASS, &
                           INLITTER, INLITTLEVS, INSOILCARB)
    ELSEIF (CSOFTWARE=='PGD') THEN
      INPATCH = NVEGTYPE
    ENDIF
    IF (UG%CGRID=='IGN') LWRITE_COORD = .TRUE.
    CALL OL_DEFINE_DIM(UG, U, &
                         'NOTIME ', ILUOUT, IFULL, IDIM1, YUNIT1, YUNIT2, &
                     ZX, ZY, IDIMS, IDDIM, YNAME_DIM, KNPATCH=INPATCH)
    IF (ALLOCATED(XVAR_TO_FILEOUT)) DEALLOCATE(XVAR_TO_FILEOUT)
    IF (ALLOCATED(XID)) DEALLOCATE(XID)
    ALLOCATE(XID(0))
    XOUT=0
    CALL CREATE_FILE(CFILEOUT_NC,IDIMS,YNAME_DIM,NID_NC,IDDIM) 
    IF (UG%CGRID=='IGN') THEN
      YATT_TITLE(1) = "comment"
      YATT(1) = "longitude"
      CALL DEF_VAR_NETCDF(DGU,NID_NC,'XLON','XLON',IDDIM(1:1),YATT_TITLE,YATT,ID0,NF_DOUBLE)
      YATT(1) = "latitude"
      CALL DEF_VAR_NETCDF(DGU,NID_NC,'XLAT','XLAT',IDDIM(1:1),YATT_TITLE,YATT,ID0,NF_DOUBLE)
    ENDIF      
    CFILEOUT_NC_SAVE = CFILEOUT_NC
    LCREATED = .TRUE.
    IF (CSOFTWARE=='PGD' .OR. ( CSOFTWARE=='OFFLINE' .AND. LRESTART ) ) THEN
      IRET = NF_DEF_DIM(NID_NC,"Number_of_covers",JPCOVER,IDIMID)
      IF (LDATA_IRRIG) IRET = NF_DEF_DIM(NID_NC,"Irrig_parameters",6,IDIMID)
      CALL GET_ISBA_CONF_n(I, &
                           YISBA, INPATCH, INLVLD, INLVLS, INBIOMASS, &
                           INLITTER, INLITTLEVS, INSOILCARB)
      IF (YISBA=='DIF') IRET = NF_DEF_DIM(NID_NC,"Nground_layers",INLVLD,IDIMID)
      CALL GET_DATA_SEAFLUX_CONF_n(DTS, &
                                   GSST_DATA,ITIME)
      IF (GSST_DATA) IRET = NF_DEF_DIM(NID_NC,"Number_of_dates",ITIME,IDIMID)
      CALL GET_BLD_CONF_n(BDD, DTT, &
                          GDATA_BLDTYPE, GDATA_IND_BLD_AGE, GDATA_COL_BLD_AGE, GDATA_USETYPE, &
                 IDESC_ROOF_LAYER, IDESC_ROAD_LAYER, IDESC_WALL_LAYER, &
                 IDESC_FLOOR_LAYER, IDESC_CODE, IDESC_USE, IDESC_AGE, IDESC_BLD)
      IF (GDATA_BLDTYPE .OR. GDATA_IND_BLD_AGE .OR. GDATA_COL_BLD_AGE .OR. GDATA_USETYPE) THEN
        ITOT = (21+3*IDESC_ROOF_LAYER+3*IDESC_ROAD_LAYER+3*IDESC_WALL_LAYER+3*IDESC_FLOOR_LAYER)&
                *IDESC_CODE + 9*IDESC_USE+2*IDESC_AGE+IDESC_BLD
        IRET = NF_DEF_DIM(NID_NC,"Bld_dimensions  ",7,IDIMID)
        IRET = NF_DEF_DIM(NID_NC,"Bld_parameters  ",ITOT,IDIMID)
      ENDIF
      IF (CHU%LCH_EMIS) THEN
        IF (CHU%CCH_EMIS=='AGGR') THEN
          IF (CHE%NEMIS_NBR/=0) IRET = NF_DEF_DIM(NID_NC,"Temporal_emiss  ",CHE%NTIME_MAX,IDIMID)
        ELSE IF (CHU%CCH_EMIS=='SNAP') THEN
          ISNAP = MAX(CHN%NSNAP_M,CHN%NSNAP_D,CHN%NSNAP_H)
          IF (ISNAP/=0 .AND. CHN%NEMIS_SNAP/=0) THEN
            IRET = NF_DEF_DIM(NID_NC,"Nemis_snap",CHN%NEMIS_SNAP,IDIMID)
            IRET = NF_DEF_DIM(NID_NC,"Nsnap_temp",ISNAP,IDIMID)
          ENDIF
        ENDIF
      ENDIF
      IF (ASSOCIATED(DTZ%XDATA_DTS)) THEN
        ITIME = SIZE(DTZ%XDATA_DTS) 
        IF (ITIME/=0) IRET = NF_DEF_DIM(NID_NC,"Nforc_tsz0",ITIME,IDIMID)
      ENDIF
    ENDIF
    IF (UG%CGRID=='GAUSS') THEN
      CALL GET_GRIDTYPE_GAUSS(UG%XGRID_PAR,INLATI)
      IRET = NF_DEF_DIM(NID_NC,"Nlati",INLATI,IDIMID)
    ENDIF
  ELSE
    IF (LDEF) IRET = NF_REDEF(NID_NC)
  ENDIF
  IF (LDEF) IRET = NF_ENDDEF(NID_NC)
  IRET = NF_CLOSE(NID_NC)
ENDIF
!
!------------------------------------------------------------------------------
IF (LHOOK) CALL DR_HOOK('INIT_OUTPUT_NC_N',1,ZHOOK_HANDLE)
!------------------------------------------------------------------------------
!
END SUBROUTINE INIT_OUTPUT_NC_n
