!     #############################################################
      SUBROUTINE INIT_BEM_n ( DGU, DTCO, UG, U, TM, GDM, HM,      &
                             KTEB_SOIL, PTEB_SOILGRID,            &
                             PCONDDRY_ROAD, PHCAPSOIL_ROAD,       &
                             KLUOUT,HINIT)
!     #############################################################
!
!!****  *INIT_BEM_n* - routine to initialize Building Energy Model
!!
!!    PURPOSE
!!    -------
!!
!!**  METHOD
!!    ------
!!
!!    EXTERNAL
!!    --------
!!
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!
!!    AUTHOR
!!    ------
!!      G. Pigeon   *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    04/2012
!-------------------------------------------------------------------------------
!
!*       0.    DECLARATIONS
!              ------------
!
!
USE MODD_DIAG_SURF_ATM_n, ONLY : DIAG_SURF_ATM_t
USE MODD_DATA_COVER_n, ONLY : DATA_COVER_t
USE MODD_SURF_ATM_GRID_n, ONLY : SURF_ATM_GRID_t
USE MODD_SURF_ATM_n, ONLY : SURF_ATM_t
USE MODD_SURFEX_n, ONLY : TEB_MODEL_t
USE MODD_SURFEX_n, ONLY : TEB_GARDEN_MODEL_t
USE MODD_SURFEX_n, ONLY : TEB_HYDRO_MODEL_t
USE MODD_SURF_PAR, ONLY:  XUNDEF, NUNDEF
USE MODD_TEB_PAR,  ONLY : XD_FLOOR_DEF, XHC_FLOOR_DEF, XTC_FLOOR_DEF, XTS_FLOOR
!
USE MODI_CONVERT_PATCH_TEB
USE MODI_WINDOW_DATA
USE MODI_HVAC_AUTOSIZE
USE MODI_BEM_MORPHO
USE MODI_STORES_HVAC_AUTOSIZE
!
USE MODI_ABOR1_SFX
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*       0.1   Declarations of arguments
!              -------------------------
!
!
TYPE(DIAG_SURF_ATM_t), INTENT(INOUT) :: DGU
TYPE(DATA_COVER_t), INTENT(INOUT) :: DTCO
TYPE(SURF_ATM_GRID_t), INTENT(INOUT) :: UG
TYPE(SURF_ATM_t), INTENT(INOUT) :: U
TYPE(TEB_MODEL_t), INTENT(INOUT) :: TM
TYPE(TEB_GARDEN_MODEL_t), INTENT(INOUT) :: GDM
TYPE(TEB_HYDRO_MODEL_t), INTENT(INOUT) :: HM
!
CHARACTER(LEN=3)    , INTENT(IN) :: HINIT       ! choice of fields to initialize
INTEGER             , INTENT(IN) :: KTEB_SOIL
REAL, DIMENSION(:)  , INTENT(IN) :: PTEB_SOILGRID
REAL, DIMENSION(:,:), INTENT(IN) :: PCONDDRY_ROAD
REAL, DIMENSION(:,:), INTENT(IN) :: PHCAPSOIL_ROAD
INTEGER,              INTENT(IN) :: KLUOUT ! logical unit of output listing
!
!*       0.2   Declarations of local variables
!              -------------------------------
!
INTEGER                         :: JJ               ! counter
INTEGER                         :: JLAYER           ! counter
INTEGER                         :: JCOMP            ! counter
INTEGER                         :: ILU              ! sizes of TEB arrays
INTEGER                         :: NDAY_SCHED       ! Number of schedules for day of week
INTEGER                         :: NCRE_SCHED       ! Number of schedules per day
INTEGER                         :: NHOLIDAY         ! Number of schedules per day
INTEGER                         :: NFVSHO           ! Number of short-term window openings per day
LOGICAL                         :: GPRINT           ! flag for warning prints in output file
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!-------------------------------------------------------------------------------
!
!         Initialisation for IO
!
IF (LHOOK) CALL DR_HOOK('INIT_BEM_N',0,ZHOOK_HANDLE)
!
NFVSHO=TM%BOP%NFVSHO
!
!
!*       3.     Physiographic data fields from land cover:
!               -----------------------------------------
!
ILU = SIZE(TM%TOP%XCOVER,1)
IF (TM%TOP%CBEM=='DEF') ILU=0
!
! Robert: hardcoded values for schedules
!
NDAY_SCHED = 3
NCRE_SCHED = 4
NHOLIDAY   = 1
!
ALLOCATE(TM%B%CUR%XHC_FLOOR    (ILU,TM%BOP%NFLOOR_LAYER))
ALLOCATE(TM%B%CUR%XTC_FLOOR    (ILU,TM%BOP%NFLOOR_LAYER))
ALLOCATE(TM%B%CUR%XD_FLOOR     (ILU,TM%BOP%NFLOOR_LAYER))
!
ALLOCATE(TM%B%CUR%XHC_MASS    (ILU,TM%BOP%NMASS_LAYER))
ALLOCATE(TM%B%CUR%XTC_MASS    (ILU,TM%BOP%NMASS_LAYER))
ALLOCATE(TM%B%CUR%XD_MASS     (ILU,TM%BOP%NMASS_LAYER))
ALLOCATE(TM%B%CUR%XISMASS     (ILU))
!
ALLOCATE(TM%B%CUR%XSHGC        (ILU))
ALLOCATE(TM%B%CUR%XQIN         (ILU,TM%BOP%NBEMCOMP))
ALLOCATE(TM%B%CUR%XQIN_FRAD    (ILU))
ALLOCATE(TM%B%CUR%XSHGC_SH     (ILU))
ALLOCATE(TM%B%CUR%XU_WIN       (ILU))
ALLOCATE(TM%B%CUR%XTRAN_WIN    (ILU))
ALLOCATE(TM%B%CUR%XFLOOR_HEIGHT(ILU))
ALLOCATE(TM%B%CUR%XN50         (ILU))
ALLOCATE(TM%B%CUR%XEFF_HEAT    (ILU))
!
ALLOCATE(TM%B%CUR%XQIN_FLAT    (ILU))
ALLOCATE(TM%B%CUR%XHR_TARGET   (ILU))
ALLOCATE(TM%B%CUR%XCAP_SYS_HEAT(ILU))
ALLOCATE(TM%B%CUR%XCAP_SYS_RAT (ILU))
ALLOCATE(TM%B%CUR%XT_ADP       (ILU))
ALLOCATE(TM%B%CUR%XM_SYS_RAT   (ILU))
ALLOCATE(TM%B%CUR%XCOP_RAT     (ILU))
ALLOCATE(TM%B%CUR%XT_SIZE_MAX  (ILU))
ALLOCATE(TM%B%CUR%XT_SIZE_MIN  (ILU))
ALLOCATE(TM%B%CUR%XF_WATER_COND(ILU))
!
ALLOCATE(TM%B%CUR%CNATVENT     (ILU,TM%BOP%NBEMCOMP))
ALLOCATE(TM%B%CUR%XNATVENT     (ILU,TM%BOP%NBEMCOMP))
!
ALLOCATE(TM%B%CUR%XISMECH      (ILU))
ALLOCATE(TM%B%CUR%XMECHRATE(ILU))
ALLOCATE(TM%B%CUR%XSHADEARCHI(ILU))
!
ALLOCATE(TM%B%CUR%XABS_WIN (ILU))
ALLOCATE(TM%B%CUR%XUGG_WIN (ILU))
ALLOCATE(TM%B%CUR%XAUX_MAX    (ILU))
ALLOCATE(TM%B%CUR%XN_FLOOR(ILU))
ALLOCATE(TM%B%CUR%XGLAZ_O_BLD(ILU))
ALLOCATE(TM%B%CUR%XMASS_O_BLD(ILU))
ALLOCATE(TM%B%CUR%XFLOOR_HW_RATIO(ILU))
ALLOCATE(TM%B%CUR%XF_FLOOR_MASS(ILU))
ALLOCATE(TM%B%CUR%XF_FLOOR_WALL(ILU))
ALLOCATE(TM%B%CUR%XF_FLOOR_WIN(ILU))
ALLOCATE(TM%B%CUR%XF_FLOOR_ROOF(ILU))
ALLOCATE(TM%B%CUR%XF_WALL_FLOOR(ILU))
ALLOCATE(TM%B%CUR%XF_WALL_MASS(ILU))
ALLOCATE(TM%B%CUR%XF_WALL_WIN(ILU))
ALLOCATE(TM%B%CUR%XF_WIN_FLOOR(ILU))
ALLOCATE(TM%B%CUR%XF_WIN_MASS(ILU))
ALLOCATE(TM%B%CUR%XF_WIN_WALL(ILU))
ALLOCATE(TM%B%CUR%XF_WIN_WIN(ILU))
ALLOCATE(TM%B%CUR%XF_MASS_FLOOR(ILU))
ALLOCATE(TM%B%CUR%XF_MASS_WALL(ILU))
ALLOCATE(TM%B%CUR%XF_MASS_WIN(ILU))
ALLOCATE(TM%B%CUR%XF_MASS_WIN(ILU))
ALLOCATE(TM%B%CUR%XFSNIG(ILU,TM%BOP%NBEMCOMP))
ALLOCATE(TM%B%CUR%XFVNIG(ILU,TM%BOP%NBEMCOMP))
ALLOCATE(TM%B%CUR%XMODQIN_VCD(ILU,TM%BOP%NBEMCOMP))
ALLOCATE(TM%B%CUR%XMODQIN_VLD(ILU,TM%BOP%NBEMCOMP))
ALLOCATE(TM%B%CUR%XMODQIN_NIG(ILU,TM%BOP%NBEMCOMP))
ALLOCATE(TM%B%CUR%XFRACOMP   (SIZE(TM%TOP%XCOVER,1),TM%BOP%NBEMCOMP))
ALLOCATE(TM%B%CUR%XTHEAT_OCCD(ILU,TM%BOP%NBEMCOMP))
ALLOCATE(TM%B%CUR%XTHEAT_OCCN(ILU,TM%BOP%NBEMCOMP))
ALLOCATE(TM%B%CUR%XTHEAT_VCDD(ILU,TM%BOP%NBEMCOMP))
ALLOCATE(TM%B%CUR%XTHEAT_VCDN(ILU,TM%BOP%NBEMCOMP))
ALLOCATE(TM%B%CUR%XTHEAT_VCLD(ILU,TM%BOP%NBEMCOMP))
ALLOCATE(TM%B%CUR%XTCOOL_OCCD(ILU,TM%BOP%NBEMCOMP))
ALLOCATE(TM%B%CUR%XTCOOL_OCCN(ILU,TM%BOP%NBEMCOMP))
ALLOCATE(TM%B%CUR%XTCOOL_VCDD(ILU,TM%BOP%NBEMCOMP))
ALLOCATE(TM%B%CUR%XTCOOL_VCDN(ILU,TM%BOP%NBEMCOMP))
ALLOCATE(TM%B%CUR%XTCOOL_VCLD(ILU,TM%BOP%NBEMCOMP))
ALLOCATE(TM%B%CUR%XTDESV(ILU))
ALLOCATE(TM%B%CUR%XFVSHO(ILU,TM%BOP%NBEMCOMP))
ALLOCATE(TM%B%CUR%XWIN_SW_MAX(ILU))
ALLOCATE(TM%B%CUR%XFOPEN(ILU))
ALLOCATE(TM%B%CUR%XFVSUM(ILU,TM%BOP%NBEMCOMP))
ALLOCATE(TM%B%CUR%XFVVAC(ILU,TM%BOP%NBEMCOMP))
ALLOCATE(TM%B%CUR%XFSSUM(ILU,TM%BOP%NBEMCOMP))
ALLOCATE(TM%B%CUR%XFSVAC(ILU,TM%BOP%NBEMCOMP))
ALLOCATE(TM%B%CUR%XBEG_HOLIDAY(ILU,NHOLIDAY,TM%BOP%NBEMCOMP))
ALLOCATE(TM%B%CUR%XEND_HOLIDAY(ILU,NHOLIDAY,TM%BOP%NBEMCOMP))
ALLOCATE(TM%B%CUR%XMOD_HOLIDAY(ILU,TM%BOP%NBEMCOMP))
ALLOCATE(TM%B%CUR%XDAYWBEG_SCHED(ILU,NDAY_SCHED,TM%BOP%NBEMCOMP))
ALLOCATE(TM%B%CUR%XHOURBEG_SCHED(ILU,NDAY_SCHED*NCRE_SCHED,TM%BOP%NBEMCOMP))
ALLOCATE(TM%B%CUR%XPROBOCC(ILU,NDAY_SCHED*NCRE_SCHED,TM%BOP%NBEMCOMP))
!
SELECT CASE(TM%TOP%CBEM)
!----------
CASE("DEF")
!-----------
   !parameters that needs to be 0 for calculation
   TM%B%CUR%XGR  (:)         = 0.
   TM%B%CUR%XF_WASTE_CAN(:)  = 0.
   TM%B%CUR%XFRACOMP(:,:)    = 1.0
   !
!----------
CASE("BEM")
!----------
!
! Robert: Further Allocations need to be made here
!
  ALLOCATE(TM%T%CUR%XD_ALLBLD (ILU,TM%T%CUR%NTEB_SOIL+TM%BOP%NFLOOR_LAYER))
  ALLOCATE(TM%T%CUR%XHC_ALLBLD(ILU,TM%T%CUR%NTEB_SOIL+TM%BOP%NFLOOR_LAYER))
  ALLOCATE(TM%T%CUR%XTC_ALLBLD(ILU,TM%T%CUR%NTEB_SOIL+TM%BOP%NFLOOR_LAYER))
  !
  TM%B%CUR%XAUX_MAX(:)     = 5.0
  !
  CALL CONVERT_PATCH_TEB(TM%BDD, TM%DTB, DTCO, TM%DTT, TM%TOP, GDM%DTGD, HM%DTH,                      &
                         TM%TOP%XCOVER,TM%TOP%LCOVER,0.,                                              &
                      KTEB_SOIL, PTEB_SOILGRID,                                                       &
                      PCONDDRY_ROAD, PHCAPSOIL_ROAD,                                                  &
                      PHC_FLOOR=TM%B%CUR%XHC_FLOOR, PTC_FLOOR=TM%B%CUR%XTC_FLOOR,                     &
                      PD_FLOOR=TM%B%CUR%XD_FLOOR, PHC_MASS =TM%B%CUR%XHC_MASS,                        &
                      PTC_MASS =TM%B%CUR%XTC_MASS,PD_MASS=TM%B%CUR%XD_MASS,PISMASS=TM%B%CUR%XISMASS,  &
                      PF_WASTE_CAN=TM%B%CUR%XF_WASTE_CAN,PN50=TM%B%CUR%XN50,PEFF_HEAT=TM%B%CUR%XEFF_HEAT, &
                      PQIN=TM%B%CUR%XQIN, PQIN_FRAD=TM%B%CUR%XQIN_FRAD, &
                      PSHGC=TM%B%CUR%XSHGC, PU_WIN=TM%B%CUR%XU_WIN, PGR=TM%B%CUR%XGR,                 &
                      PSHGC_SH=TM%B%CUR%XSHGC_SH, PFLOOR_HEIGHT=TM%B%CUR%XFLOOR_HEIGHT,               &
                      PF_WATER_COND=TM%B%CUR%XF_WATER_COND,                       &
                      PQIN_FLAT=TM%B%CUR%XQIN_FLAT, PHR_TARGET=TM%B%CUR%XHR_TARGET,                   &
                      PCAP_SYS_HEAT=TM%B%CUR%XCAP_SYS_HEAT,                 &
                      PCAP_SYS_RAT=TM%B%CUR%XCAP_SYS_RAT, PT_ADP=TM%B%CUR%XT_ADP,                     &
                      PM_SYS_RAT=TM%B%CUR%XM_SYS_RAT, PCOP_RAT=TM%B%CUR%XCOP_RAT,                     &
                      PT_SIZE_MAX=TM%B%CUR%XT_SIZE_MAX, PT_SIZE_MIN=TM%B%CUR%XT_SIZE_MIN,             &
                      PISMECH=TM%B%CUR%XISMECH, PMECHRATE=TM%B%CUR%XMECHRATE,                         &
                      PSHADEARCHI=TM%B%CUR%XSHADEARCHI,PFSNIG=TM%B%CUR%XFSNIG,PFVNIG=TM%B%CUR%XFVNIG,            &
                      PMODQIN_VCD=TM%B%CUR%XMODQIN_VCD,                                        &
                      PMODQIN_VLD=TM%B%CUR%XMODQIN_VLD,PMODQIN_NIG=TM%B%CUR%XMODQIN_NIG,PTDESV=TM%B%CUR%XTDESV,  &
                      PFVSHO=TM%B%CUR%XFVSHO,PNATVENT=TM%B%CUR%XNATVENT,         &
                      PFRACOMP=TM%B%CUR%XFRACOMP,PTHEAT_OCCD=TM%B%CUR%XTHEAT_OCCD, &
                      PTHEAT_OCCN=TM%B%CUR%XTHEAT_OCCN, &
                      PTHEAT_VCDD=TM%B%CUR%XTHEAT_VCDD,PTHEAT_VCDN=TM%B%CUR%XTHEAT_VCDN,                &
                      PTHEAT_VCLD=TM%B%CUR%XTHEAT_VCLD,  &
                      PTCOOL_OCCD=TM%B%CUR%XTCOOL_OCCD,                                        &
                      PTCOOL_OCCN=TM%B%CUR%XTCOOL_OCCN,PTCOOL_VCDD=TM%B%CUR%XTCOOL_VCDD,                &
                      PTCOOL_VCDN=TM%B%CUR%XTCOOL_VCDN,PTCOOL_VCLD=TM%B%CUR%XTCOOL_VCLD,                &
                      PWIN_SW_MAX=TM%B%CUR%XWIN_SW_MAX,PFOPEN=TM%B%CUR%XFOPEN,PFVSUM=TM%B%CUR%XFVSUM,            &
                      PFVVAC=TM%B%CUR%XFVVAC,PFSSUM=TM%B%CUR%XFSSUM,PFSVAC=TM%B%CUR%XFSVAC,                      &
                      PDAYWBEG_SCHED=TM%B%CUR%XDAYWBEG_SCHED,PHOURBEG_SCHED=TM%B%CUR%XHOURBEG_SCHED,    &
                      PBEG_HOLIDAY=TM%B%CUR%XBEG_HOLIDAY, PEND_HOLIDAY=TM%B%CUR%XEND_HOLIDAY,   &
                      PMOD_HOLIDAY=TM%B%CUR%XMOD_HOLIDAY, PPROBOCC=TM%B%CUR%XPROBOCC                    )
   !
   ! Robert: Initialisations need to be made here
   !
   DO JLAYER=1,TM%BOP%NFLOOR_LAYER
      TM%T%CUR%XD_ALLBLD (:,JLAYER) = TM%B%CUR%XD_FLOOR (:,JLAYER)
      TM%T%CUR%XHC_ALLBLD(:,JLAYER) = TM%B%CUR%XHC_FLOOR(:,JLAYER)
      TM%T%CUR%XTC_ALLBLD(:,JLAYER) = TM%B%CUR%XTC_FLOOR(:,JLAYER)
   ENDDO
   DO JLAYER=1,TM%T%CUR%NTEB_SOIL
      TM%T%CUR%XD_ALLBLD (:,JLAYER+TM%BOP%NFLOOR_LAYER) = TM%T%CUR%XD_BLD (:,JLAYER)
      TM%T%CUR%XHC_ALLBLD(:,JLAYER+TM%BOP%NFLOOR_LAYER) = TM%T%CUR%XHC_BLD(:,JLAYER)
      TM%T%CUR%XTC_ALLBLD(:,JLAYER+TM%BOP%NFLOOR_LAYER) = TM%T%CUR%XTC_BLD(:,JLAYER)
   ENDDO
   !
   ! *.     indoor relative surf. and view factors
   !        --------------------------------------
   !
   ! Robert: If indicated by architectural information the 
   !         floor height is set to the building height
   !
   DO JJ=1,SIZE(TM%B%CUR%XISMASS,1)
      IF (TM%B%CUR%XISMASS(JJ).LT.0.5) TM%B%CUR%XFLOOR_HEIGHT(JJ)=TM%T%CUR%XBLD_HEIGHT(JJ)
   ENDDO
   !
   CALL BEM_MORPHO(TM%T%CUR%XBLD, TM%T%CUR%XWALL_O_HOR, TM%T%CUR%XBLD_HEIGHT, &
                   TM%B%CUR%XFLOOR_HEIGHT, TM%B%CUR%XGR, TM%B%CUR%XN_FLOOR, TM%T%CUR%XWALL_O_BLD, &
                   TM%B%CUR%XGLAZ_O_BLD, TM%B%CUR%XMASS_O_BLD, TM%B%CUR%XFLOOR_HW_RATIO, &
                   TM%B%CUR%XF_FLOOR_MASS, TM%B%CUR%XF_FLOOR_WALL, TM%B%CUR%XF_FLOOR_WIN, &
                   TM%B%CUR%XF_FLOOR_ROOF, TM%B%CUR%XF_WALL_FLOOR, TM%B%CUR%XF_WALL_MASS, &
                   TM%B%CUR%XF_WALL_WIN, TM%B%CUR%XF_WIN_FLOOR, TM%B%CUR%XF_WIN_MASS, &
                   TM%B%CUR%XF_WIN_WALL,  TM%B%CUR%XF_MASS_FLOOR, TM%B%CUR%XF_MASS_WALL, &
                   TM%B%CUR%XF_MASS_WIN, TM%B%CUR%XF_WASTE_CAN, TM%B%CUR%XF_WIN_WIN      )
   !
   ! *.     Window optical and thermal data
   !        -------------------------------
   !
   CALL WINDOW_DATA(ILU, TM%B%CUR%XSHGC, TM%B%CUR%XU_WIN, TM%B%CUR%XALB_WIN, &
                    TM%B%CUR%XABS_WIN, TM%B%CUR%XUGG_WIN, TM%B%CUR%XTRAN_WIN)
   !
   !GPRINT = .FALSE.
   !DO JJ=1,SIZE(TM%B%CUR%XSHADEARCHI)
   !   IF (TM%B%CUR%XSHADEARCHI(JJ) >= 0.0 .AND. TM%B%CUR%XSHADEARCHI(JJ) < 0.5) THEN
   !      TM%B%CUR%LSHADEARCHI(JJ) = .FALSE.
   !   ELSEIF (TM%B%CUR%XSHADEARCHI(JJ) >= 0.5 .AND. TM%B%CUR%XSHADEARCHI(JJ) <= 1.0) THEN
   !      TM%B%CUR%LSHADEARCHI(JJ) = .TRUE.
   !   ELSE
   !    GPRINT = .TRUE.
   !    TM%B%CUR%LSHADEARCHI(JJ) = .FALSE.
   !   ENDIF
   !ENDDO
   !IF (GPRINT) WRITE(KLUOUT,*) &
   !'TEB-BEM : Error in specifying shading devices for at least one point, no shading device for these points'
   !TM%B%CUR%LSHAD_DAY(:) = .FALSE.
   !
   ! *.     Nocturnal surventilation
   !        ------------------------
   GPRINT = .FALSE.
   DO JJ=1,SIZE(TM%B%CUR%XNATVENT,1)
      DO JCOMP=1,SIZE(TM%B%CUR%XNATVENT,2)
         IF (TM%B%CUR%XNATVENT(JJ,JCOMP) >= 0.0 .AND. TM%B%CUR%XNATVENT(JJ,JCOMP) < 0.5) THEN
            TM%B%CUR%CNATVENT(JJ,JCOMP) = 'NONE'
         ELSEIF (TM%B%CUR%XNATVENT(JJ,JCOMP) >= 0.5 .AND. TM%B%CUR%XNATVENT(JJ,JCOMP) < 1.5) THEN
            TM%B%CUR%CNATVENT(JJ,JCOMP) = 'MANU'
         ELSEIF (TM%B%CUR%XNATVENT(JJ,JCOMP) >= 1.5 .AND. TM%B%CUR%XNATVENT(JJ,JCOMP) <= 2.5) THEN
            TM%B%CUR%CNATVENT(JJ,JCOMP) = 'AUTO'        
         ELSEIF (TM%B%CUR%XNATVENT(JJ,JCOMP) >= 2.5 .AND. TM%B%CUR%XNATVENT(JJ,JCOMP) <= 3.5) THEN
            TM%B%CUR%CNATVENT(JJ,JCOMP) = 'MECH'        
         ELSE
            GPRINT = .TRUE.
            TM%B%CUR%CNATVENT(JJ,JCOMP) = 'NONE'        
         ENDIF
      ENDDO
    ENDDO
    IF (GPRINT) WRITE(KLUOUT,*) 'TEB-BEM : Chosen option for surventilation is not yet implemented; None venting is kept instead'
   !
END SELECT
!
!-------------------------------------------------------------------------------
!
!*       8.     Building HVAC automatic sizing:
!               -------------------------------  
!
IF (TM%TOP%CBEM=='BEM' .AND. TM%BOP%LAUTOSIZE .AND. ((HINIT=='ALL').OR.(HINIT=='SOD')))  THEN
  CALL HVAC_AUTOSIZE(TM%BDD, DTCO, DGU, TM%B, TM%BOP, UG, U, TM%TG, TM%T, TM%TOP, &
                     ILU,KLUOUT)
  !* stores the real systems characteristics in physiographic data 
  !  for further use
  CALL STORES_HVAC_AUTOSIZE(TM%B, TM%BOP, TM%DTB)
ENDIF
!
!-------------------------------------------------------------------------------
!
!
IF (LHOOK) CALL DR_HOOK('INIT_BEM_N',1,ZHOOK_HANDLE)
!
!
END SUBROUTINE INIT_BEM_n
