!     #########################
SUBROUTINE INI_DATA_PARAM_TEB(BDD, DTT, KTYPE, PFLOOR_HEIGHT, &
     PCAP_SYS_HEAT, PCAP_SYS_RAT, PT_ADP, PM_SYS_RAT, &
     PT_SIZE_MAX, PT_SIZE_MIN, PROUGH_ROOF, PROUGH_WALL, &
     PALB_ROOF, PEMIS_ROOF, PHC_ROOF, PTC_ROOF, PD_ROOF, &
     PALB_WALL, PEMIS_WALL, PHC_WALL, PTC_WALL, PD_WALL, &
     NISOROOFPOS, NISOWALLPOS, PALB_ROAD, PEMIS_ROAD, &
     PHC_ROAD, PTC_ROAD, PD_ROAD,                                  &
     PHC_FLOOR, PTC_FLOOR, PD_FLOOR, PISMASS, PHC_MASS, PTC_MASS,  &
     PD_MASS, PN50,PGR,PU_WIN,PSHGC,PSHGC_SH,PSHADEARCHI,          &
     PISMECH,PMECHRATE,PGREENROOF,PEMIS_PANEL,PALB_PANEL,PEFF_PANEL,       &
     PFRAC_PANEL, PTHEAT_OCCD,PTHEAT_OCCN,PTHEAT_VCDD,PTHEAT_VCDN,         &
     PTHEAT_VCLD,PFRACOMP,PTCOOL_OCCD,PTCOOL_OCCN,PTCOOL_VCDD,PTCOOL_VCDN, &
     PTCOOL_VCLD,PF_WATER_COND,PCOP_RAT,PHR_TARGET,PQIN,PQIN_FRAD,         &
     PQIN_FLAT,PMODQIN_VCD,PMODQIN_VLD,PMODQIN_NIG,PNATVENT,PFVSUM,PFVNIG,PFVSHO, &
     PTDESV,PFVVAC,PFOPEN,PFSSUM,PFSNIG,PFSVAC,PWIN_SW_MAX,PDAYWBEG_SCHED, &
     PHOURBEG_SCHED,PBEG_HOLIDAY,PEND_HOLIDAY,PMOD_HOLIDAY,PPROBOCC,PF_WASTE_CAN)
  !
  !     #########################
  !
  !!
  !!    PURPOSE
  !!    -------
  !!
  !!    METHOD
  !!    ------
  !!
  !!
  !!    EXTERNAL
  !!    --------
  !!
  !!    IMPLICIT ARGUMENTS
  !!    ------------------
  !!
  !!    REFERENCE
  !!    ---------
  !!
  !!    AUTHOR
  !!    ------
  !!
  !!    S. Faroux & V. Masson        Meteo-France
  !!
  !!    MODIFICATION
  !!    ------------
  !!
  !!    Original      05/2012 from INI_DATA_PARAM_TEB, separates urban parameters
  !!    modified      08/2012 add PROUGH_ROOF, PROUGH_WALL
  !!     V. Masson    08/2013 add solar panels
  !!     R. Schoetter 11/2015 Major changes in order to read MApUCE data
  !----------------------------------------------------------------------------
  !
  !*    0.     DECLARATION
  !            -----------
  !
  USE MODD_BLD_DESCRIPTION_n, ONLY : BLD_DESC_t
  USE MODD_DATA_TEB_n, ONLY : DATA_TEB_t
  !
  USE MODI_ABOR1_SFX
  !
  USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
  USE PARKIND1  ,ONLY : JPRB
  !
  IMPLICIT NONE
  !
  !*    0.1    Declaration of arguments
  !            ------------------------
  !
  TYPE(BLD_DESC_t), INTENT(INOUT) :: BDD
  TYPE(DATA_TEB_t), INTENT(INOUT) :: DTT
  INTEGER, DIMENSION(:), INTENT(INOUT) :: KTYPE
  !
  ! Parameters not yet read from tables
  ! TODO: default values could be entered into the table
  !
  REAL, DIMENSION(:), INTENT(OUT), OPTIONAL :: PFLOOR_HEIGHT
  REAL, DIMENSION(:), INTENT(OUT), OPTIONAL :: PCAP_SYS_HEAT
  REAL, DIMENSION(:), INTENT(OUT), OPTIONAL :: PCAP_SYS_RAT
  REAL, DIMENSION(:), INTENT(OUT), OPTIONAL :: PT_ADP
  REAL, DIMENSION(:), INTENT(OUT), OPTIONAL :: PM_SYS_RAT
  REAL, DIMENSION(:), INTENT(OUT), OPTIONAL :: PT_SIZE_MAX
  REAL, DIMENSION(:), INTENT(OUT), OPTIONAL :: PT_SIZE_MIN
  REAL, DIMENSION(:), INTENT(OUT), OPTIONAL :: PROUGH_ROOF
  REAL, DIMENSION(:), INTENT(OUT), OPTIONAL :: PROUGH_WALL
  !
  ! Building architectural characteristics
  !
  REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL :: PALB_ROOF
  REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL :: PEMIS_ROOF
  REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL :: PHC_ROOF
  REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL :: PTC_ROOF
  REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL :: PD_ROOF
  REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL :: PALB_WALL
  REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL :: PEMIS_WALL
  REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL :: PHC_WALL
  REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL :: PTC_WALL
  REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL :: PD_WALL
  INTEGER, DIMENSION(:),   INTENT(OUT), OPTIONAL :: NISOROOFPOS
  INTEGER, DIMENSION(:),   INTENT(OUT), OPTIONAL :: NISOWALLPOS
  REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL :: PALB_ROAD
  REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL :: PEMIS_ROAD
  REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL :: PHC_ROAD
  REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL :: PTC_ROAD
  REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL :: PD_ROAD
  REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL :: PHC_FLOOR
  REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL :: PTC_FLOOR
  REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL :: PD_FLOOR
  REAL, DIMENSION(:)  , INTENT(OUT), OPTIONAL :: PISMASS
  REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL :: PHC_MASS
  REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL :: PTC_MASS
  REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL :: PD_MASS
  REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL :: PN50
  REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL :: PGR
  REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL :: PU_WIN
  REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL :: PSHGC
  REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL :: PSHGC_SH
  REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL :: PSHADEARCHI
  REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL :: PISMECH
  REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL :: PMECHRATE
  REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL :: PGREENROOF
  REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL :: PEMIS_PANEL
  REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL :: PALB_PANEL
  REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL :: PEFF_PANEL
  REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL :: PFRAC_PANEL
  REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL :: PF_WASTE_CAN
  !
  ! Occupant behaviour characteristics
  ! 
  REAL, DIMENSION(:,:),   INTENT(OUT), OPTIONAL :: PTHEAT_OCCD
  REAL, DIMENSION(:,:),   INTENT(OUT), OPTIONAL :: PTHEAT_OCCN
  REAL, DIMENSION(:,:),   INTENT(OUT), OPTIONAL :: PTHEAT_VCDD
  REAL, DIMENSION(:,:),   INTENT(OUT), OPTIONAL :: PTHEAT_VCDN
  REAL, DIMENSION(:,:),   INTENT(OUT), OPTIONAL :: PTHEAT_VCLD
  REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL :: PFRACOMP
  REAL, DIMENSION(:,:),   INTENT(OUT), OPTIONAL :: PTCOOL_OCCD
  REAL, DIMENSION(:,:),   INTENT(OUT), OPTIONAL :: PTCOOL_OCCN
  REAL, DIMENSION(:,:),   INTENT(OUT), OPTIONAL :: PTCOOL_VCDD
  REAL, DIMENSION(:,:),   INTENT(OUT), OPTIONAL :: PTCOOL_VCDN
  REAL, DIMENSION(:,:),   INTENT(OUT), OPTIONAL :: PTCOOL_VCLD
  REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL :: PF_WATER_COND
  REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL :: PCOP_RAT
  REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL :: PHR_TARGET
  REAL, DIMENSION(:,:),   INTENT(OUT), OPTIONAL :: PQIN
  REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL :: PQIN_FRAD
  REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL :: PQIN_FLAT
  REAL, DIMENSION(:,:),   INTENT(OUT), OPTIONAL :: PMODQIN_VCD
  REAL, DIMENSION(:,:),   INTENT(OUT), OPTIONAL :: PMODQIN_VLD
  REAL, DIMENSION(:,:),   INTENT(OUT), OPTIONAL :: PMODQIN_NIG
  REAL, DIMENSION(:,:),   INTENT(OUT), OPTIONAL :: PNATVENT
  REAL, DIMENSION(:,:),   INTENT(OUT), OPTIONAL :: PFVSUM
  REAL, DIMENSION(:,:),   INTENT(OUT), OPTIONAL :: PFVNIG
  REAL, DIMENSION(:,:),   INTENT(OUT), OPTIONAL :: PFVSHO
  REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL :: PTDESV
  REAL, DIMENSION(:,:),   INTENT(OUT), OPTIONAL :: PFVVAC
  REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL :: PFOPEN
  REAL, DIMENSION(:,:),   INTENT(OUT), OPTIONAL :: PFSSUM
  REAL, DIMENSION(:,:),   INTENT(OUT), OPTIONAL :: PFSNIG
  REAL, DIMENSION(:,:),   INTENT(OUT), OPTIONAL :: PFSVAC
  REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL :: PWIN_SW_MAX
  REAL, DIMENSION(:,:,:), INTENT(OUT), OPTIONAL :: PBEG_HOLIDAY
  REAL, DIMENSION(:,:,:), INTENT(OUT), OPTIONAL :: PEND_HOLIDAY
  REAL, DIMENSION(:,:)  , INTENT(OUT), OPTIONAL :: PMOD_HOLIDAY
  REAL, DIMENSION(:,:,:), INTENT(OUT), OPTIONAL :: PDAYWBEG_SCHED
  REAL, DIMENSION(:,:,:), INTENT(OUT), OPTIONAL :: PHOURBEG_SCHED
  REAL, DIMENSION(:,:,:), INTENT(OUT), OPTIONAL :: PPROBOCC
  !
  !*    0.2    Declaration of local variables
  !      ------------------------------
  !
  INTEGER, DIMENSION(:), ALLOCATABLE :: ILIST ! link between urban types and indices
  REAL, DIMENSION(SIZE(KTYPE)) :: ZGARDEN
  INTEGER            :: JLOOP        ! spatial loop counter
  INTEGER            :: JLIST        ! loop counter on urban types
  INTEGER            :: KLIST        ! loop counter on urban types
  INTEGER            :: IINDEX       ! index of type for each point
  INTEGER            :: NCTL         ! Control variable
  INTEGER            :: NPOS         ! Position in vector
  INTEGER            :: NPOS_FORT_CRE! Position in vector
  INTEGER            :: NPOS_FAIB_CRE! Position in vector
  INTEGER            :: NPOS_FORT_EQI! Position in vector
  INTEGER            :: NPOS_MOYE_EQI! Position in vector
  INTEGER            :: NPOS_FAIB_EQI! Position in vector
  INTEGER            :: NPOS_COM     ! Position in vector
  INTEGER            :: NPOS_TER     ! Position in vector
  !
  REAL(KIND=JPRB) :: ZHOOK_HANDLE
  !
  !-------------------------------------------------------------------------------
  !-------------------------------------------------------------------------------
  !
  IF (LHOOK) CALL DR_HOOK('INI_DATA_PARAM_TEB',0,ZHOOK_HANDLE)
  !
  !-------------------------------------------------------------------------------
  !
  !*    1.     Builds the list of indices corresponding to the "type" field
  !      ------------------------------------------------------------------
  !
  ALLOCATE(ILIST(SIZE(KTYPE)))
  ILIST(:) = -9999
  !
  ! ##################################################################
  ! Elimination of unrealistic combinations of input data
  ! ##################################################################
  !
  DO JLIST=1,SIZE(KTYPE)
     !
     ! A) In the case the islet type is "high-rise building" and the
     !    construction period is P1, the construction period is set
     !    to P2, since there are no high-rise buildings in P1.
     !
     IF ((DTT%NPAR_BLDTYPE(JLIST).EQ.8).AND.(DTT%NPAR_COL_BLD_AGE(JLIST).EQ.1)) THEN
        !
        DTT%NPAR_COL_BLD_AGE(JLIST)=2
        !
        CALL BLDCODE(DTT%NPAR_BLDTYPE(JLIST),DTT%NPAR_COL_BLD_AGE(JLIST),DTT%NPAR_USETYPE(JLIST), &
             DTT%NPAR_PXTERRITORY(JLIST),DTT%NPAR_BLDCODE(JLIST))
        !
     ENDIF
     !
     ! B) In the case the island type is "local", the use is set to "LOCAL NON CHAUFFE"
     !
     IF ( ((DTT%NPAR_BLDTYPE(JLIST).EQ.10).AND.(DTT%NPAR_USETYPE(JLIST).NE.7)) ) THEN
        !
        DTT%NPAR_USETYPE(JLIST)=7
        !
        IF (DTT%NPAR_COL_BLD_AGE(JLIST).EQ.1) THEN
           CALL BLDCODE(DTT%NPAR_BLDTYPE(JLIST),DTT%NPAR_COL_BLD_AGE(JLIST),DTT%NPAR_USETYPE(JLIST), &
                DTT%NPAR_P1TERRITORY(JLIST),DTT%NPAR_BLDCODE(JLIST))
        ELSE
           CALL BLDCODE(DTT%NPAR_BLDTYPE(JLIST),DTT%NPAR_COL_BLD_AGE(JLIST),DTT%NPAR_USETYPE(JLIST), &
                DTT%NPAR_PXTERRITORY(JLIST),DTT%NPAR_BLDCODE(JLIST))
        ENDIF
        !
     ENDIF
     !
     ! C) In the case the building type coincides with individual housing, but the
     !    use with collective housing, the use is set to individual housing
     !    The building type is given priority
     !
     IF ( ((DTT%NPAR_BLDTYPE(JLIST).GE.1).AND.(DTT%NPAR_BLDTYPE(JLIST).LE.4)) .AND. &
          (DTT%NPAR_USETYPE(JLIST).NE.5) )  THEN
        !
        DTT%NPAR_USETYPE(JLIST)=5
        !
        IF (DTT%NPAR_IND_BLD_AGE(JLIST).EQ.1) THEN
           CALL BLDCODE(DTT%NPAR_BLDTYPE(JLIST),DTT%NPAR_IND_BLD_AGE(JLIST),DTT%NPAR_USETYPE(JLIST), &
                DTT%NPAR_P1TERRITORY(JLIST),DTT%NPAR_BLDCODE(JLIST))
        ELSE
           CALL BLDCODE(DTT%NPAR_BLDTYPE(JLIST),DTT%NPAR_IND_BLD_AGE(JLIST),DTT%NPAR_USETYPE(JLIST), &
                DTT%NPAR_PXTERRITORY(JLIST),DTT%NPAR_BLDCODE(JLIST))
        ENDIF
        !
     ENDIF
     !
     ! D) In the case the building type coincides with collective housing, but the
     !    use is INDIVIDUEL, the use is set to COLLECTIF
     !    The building type is given priority
     !    CAUTION: hardcoded position
     !
     IF ( ((DTT%NPAR_BLDTYPE(JLIST).GE.5).AND.(DTT%NPAR_BLDTYPE(JLIST).LE.8)) .AND. &
          (DTT%NPAR_USETYPE(JLIST).EQ.5) )  THEN
        !
        DTT%NPAR_USETYPE(JLIST)=4
        !
        IF (DTT%NPAR_COL_BLD_AGE(JLIST).EQ.1) THEN
           CALL BLDCODE(DTT%NPAR_BLDTYPE(JLIST),DTT%NPAR_COL_BLD_AGE(JLIST),DTT%NPAR_USETYPE(JLIST), &
                DTT%NPAR_P1TERRITORY(JLIST),DTT%NPAR_BLDCODE(JLIST))
        ELSE
           CALL BLDCODE(DTT%NPAR_BLDTYPE(JLIST),DTT%NPAR_COL_BLD_AGE(JLIST),DTT%NPAR_USETYPE(JLIST), &
                DTT%NPAR_PXTERRITORY(JLIST),DTT%NPAR_BLDCODE(JLIST))
        ENDIF
        !
     ENDIF
     !
     ! E) In the case the building type is "BATIMENT D'ACTIVITE",
     !    but the use is INDIVIDUEL or COLLECTIF it is set to INDUSTRIEL
     !    The building type is given priority
     !    CAUTION: hardcoded position
     !
     IF ( ((DTT%NPAR_USETYPE(JLIST).GE.4).AND.(DTT%NPAR_USETYPE(JLIST).LE.5)) .AND. &
          (DTT%NPAR_BLDTYPE(JLIST).EQ.9) )  THEN
        !
        DTT%NPAR_USETYPE(JLIST)=6
        !
        IF (DTT%NPAR_IND_BLD_AGE(JLIST).EQ.1) THEN
           CALL BLDCODE(DTT%NPAR_BLDTYPE(JLIST),DTT%NPAR_IND_BLD_AGE(JLIST),DTT%NPAR_USETYPE(JLIST), &
                DTT%NPAR_P1TERRITORY(JLIST),DTT%NPAR_BLDCODE(JLIST))
        ELSE
           CALL BLDCODE(DTT%NPAR_BLDTYPE(JLIST),DTT%NPAR_IND_BLD_AGE(JLIST),DTT%NPAR_USETYPE(JLIST), &
                DTT%NPAR_PXTERRITORY(JLIST),DTT%NPAR_BLDCODE(JLIST))
        ENDIF
        !
     ENDIF
     !
     ! F) In the case the use is LOCAL NON CHAUFFE, 
     !    the building type is set to "LOCAL"
     !    Here the priority is given to the use
     !    CAUTION: hardcoded position
     !
     IF ( (DTT%NPAR_USETYPE(JLIST).EQ.7).AND.(DTT%NPAR_BLDTYPE(JLIST).NE.10) )  THEN
        !
        DTT%NPAR_BLDTYPE(JLIST)=10
        !
        IF (DTT%NPAR_IND_BLD_AGE(JLIST).EQ.1) THEN
           CALL BLDCODE(DTT%NPAR_BLDTYPE(JLIST),DTT%NPAR_IND_BLD_AGE(JLIST),DTT%NPAR_USETYPE(JLIST), &
                DTT%NPAR_P1TERRITORY(JLIST),DTT%NPAR_BLDCODE(JLIST))
        ELSE
           CALL BLDCODE(DTT%NPAR_BLDTYPE(JLIST),DTT%NPAR_IND_BLD_AGE(JLIST),DTT%NPAR_USETYPE(JLIST), &
                DTT%NPAR_PXTERRITORY(JLIST),DTT%NPAR_BLDCODE(JLIST))
        ENDIF
        !
     ENDIF
     !
     ! G) For TERTIARY use, the building type must be
     !    ID/ICIO/ICIF/ for P1 and ID/ICIO/BGH for PX
     !
     IF (DTT%NPAR_USETYPE(JLIST).EQ.13) THEN
        !
        IF (DTT%NPAR_COL_BLD_AGE(JLIST).EQ.1) THEN
           !
           IF ((DTT%NPAR_BLDTYPE(JLIST).LT.5).OR.(DTT%NPAR_BLDTYPE(JLIST).GT.7)) THEN
              !
              DTT%NPAR_BLDTYPE(JLIST)=6
              !
              CALL BLDCODE(DTT%NPAR_BLDTYPE(JLIST),DTT%NPAR_COL_BLD_AGE(JLIST), &
                   DTT%NPAR_USETYPE(JLIST),DTT%NPAR_P1TERRITORY(JLIST), &
                   DTT%NPAR_BLDCODE(JLIST))
              !
           ENDIF
           !
        ELSE
           !
           IF ((DTT%NPAR_BLDTYPE(JLIST).NE.5).AND.(DTT%NPAR_BLDTYPE(JLIST).NE.6).AND. &
                (DTT%NPAR_BLDTYPE(JLIST).NE.8)) THEN
              !
              DTT%NPAR_BLDTYPE(JLIST)=6
              !
              CALL BLDCODE(DTT%NPAR_BLDTYPE(JLIST),DTT%NPAR_COL_BLD_AGE(JLIST), &
                   DTT%NPAR_USETYPE(JLIST),DTT%NPAR_PXTERRITORY(JLIST), &
                   DTT%NPAR_BLDCODE(JLIST))
              !
           ENDIF
           !
        ENDIF
        !
        WRITE(1012,*) "                                   "
        WRITE(1012,*) "In ini_data_param_teb              "
        WRITE(1012,*) "After corrections for TERTIARY use "
        WRITE(1012,*) "DTT%NPAR_BLDTYPE(JLIST)            ",DTT%NPAR_BLDTYPE(JLIST)
        WRITE(1012,*) "DTT%NPAR_USETYPE(JLIST)            ",DTT%NPAR_USETYPE(JLIST)
        WRITE(1012,*) "DTT%NPAR_COL_BLD_AGE(JLIST)        ",DTT%NPAR_COL_BLD_AGE(JLIST)
        WRITE(1012,*) "DTT%NPAR_IND_BLD_AGE(JLIST)        ",DTT%NPAR_IND_BLD_AGE(JLIST)
        WRITE(1012,*) "DTT%NPAR_PXTERRITORY(JLIST)        ",DTT%NPAR_PXTERRITORY(JLIST)
        WRITE(1012,*) "DTT%NPAR_P1TERRITORY(JLIST)        ",DTT%NPAR_P1TERRITORY(JLIST)
        CALL FLUSH(1012)
        !
     ENDIF
     !
     ! H) In the case the use is SANTE and the building type is not ICIF or ICIO
     !    the building type is set to ICIO.
     !    CAUTION: hardcoded position
     !
     IF ( (DTT%NPAR_USETYPE(JLIST).EQ.9).AND.((DTT%NPAR_BLDTYPE(JLIST).LT.6).OR.(DTT%NPAR_BLDTYPE(JLIST).GT.7)) )  THEN
        !
        DTT%NPAR_BLDTYPE(JLIST)=6
        !
        IF (DTT%NPAR_COL_BLD_AGE(JLIST).EQ.1) THEN
           CALL BLDCODE(DTT%NPAR_BLDTYPE(JLIST),DTT%NPAR_COL_BLD_AGE(JLIST),DTT%NPAR_USETYPE(JLIST), &
                DTT%NPAR_P1TERRITORY(JLIST),DTT%NPAR_BLDCODE(JLIST))
        ELSE
           CALL BLDCODE(DTT%NPAR_BLDTYPE(JLIST),DTT%NPAR_COL_BLD_AGE(JLIST),DTT%NPAR_USETYPE(JLIST), &
                DTT%NPAR_PXTERRITORY(JLIST),DTT%NPAR_BLDCODE(JLIST))
        ENDIF
        !
     ENDIF
     !
     ! I) In the case the use is ENSEIGNEMENT and the building type 
     !    is not ID/ICIO/ICIF the building type is set to ICIO.
     !
     IF ( (DTT%NPAR_USETYPE(JLIST).EQ.10).AND.((DTT%NPAR_BLDTYPE(JLIST).LT.5).OR.(DTT%NPAR_BLDTYPE(JLIST).GT.7)) )  THEN
        !
        DTT%NPAR_BLDTYPE(JLIST)=6
        !
        IF (DTT%NPAR_COL_BLD_AGE(JLIST).EQ.1) THEN
           CALL BLDCODE(DTT%NPAR_BLDTYPE(JLIST),DTT%NPAR_COL_BLD_AGE(JLIST),DTT%NPAR_USETYPE(JLIST), &
                DTT%NPAR_P1TERRITORY(JLIST),DTT%NPAR_BLDCODE(JLIST))
        ELSE
           CALL BLDCODE(DTT%NPAR_BLDTYPE(JLIST),DTT%NPAR_COL_BLD_AGE(JLIST),DTT%NPAR_USETYPE(JLIST), &
                DTT%NPAR_PXTERRITORY(JLIST),DTT%NPAR_BLDCODE(JLIST))
        ENDIF
        !
     ENDIF
     !
     ! K) In the case the use is CHATEAU the building type 
     !    must be ID and the period of construction 1.
     !
     IF (DTT%NPAR_USETYPE(JLIST).EQ.2) THEN
        !
        DTT%NPAR_BLDTYPE(JLIST)     = 5
        DTT%NPAR_COL_BLD_AGE(JLIST) = 1
        DTT%NPAR_IND_BLD_AGE(JLIST) = 1
        !
        CALL BLDCODE(DTT%NPAR_BLDTYPE(JLIST),DTT%NPAR_COL_BLD_AGE(JLIST),DTT%NPAR_USETYPE(JLIST), &
             DTT%NPAR_P1TERRITORY(JLIST),DTT%NPAR_BLDCODE(JLIST))
        !
     ENDIF
     !
     ! L) In the case the use is SPORTIF the building type must be BA
     !    CAUTION: hardcoded position
     !
     IF ( (DTT%NPAR_USETYPE(JLIST).EQ.12).AND.(DTT%NPAR_BLDTYPE(JLIST).NE.9) )  THEN
        !
        DTT%NPAR_BLDTYPE(JLIST)=9
        !
        IF (DTT%NPAR_IND_BLD_AGE(JLIST).EQ.1) THEN
           CALL BLDCODE(DTT%NPAR_BLDTYPE(JLIST),DTT%NPAR_IND_BLD_AGE(JLIST),DTT%NPAR_USETYPE(JLIST), &
                DTT%NPAR_P1TERRITORY(JLIST),DTT%NPAR_BLDCODE(JLIST))
        ELSE
           CALL BLDCODE(DTT%NPAR_BLDTYPE(JLIST),DTT%NPAR_IND_BLD_AGE(JLIST),DTT%NPAR_USETYPE(JLIST), &
                DTT%NPAR_PXTERRITORY(JLIST),DTT%NPAR_BLDCODE(JLIST))
        ENDIF
        !
     ENDIF
     !
     ! M) In the case the use is RELIGIEUX the building type must be ID/ICIF
     !    CAUTION: hardcoded position
     !
     IF ( (DTT%NPAR_USETYPE(JLIST).EQ.8) .AND. &
          ((DTT%NPAR_BLDTYPE(JLIST).NE.5).AND.(DTT%NPAR_BLDTYPE(JLIST).NE.7)) ) THEN
        !
        DTT%NPAR_BLDTYPE(JLIST)=7
        !
        IF (DTT%NPAR_COL_BLD_AGE(JLIST).EQ.1) THEN
           CALL BLDCODE(DTT%NPAR_BLDTYPE(JLIST),DTT%NPAR_COL_BLD_AGE(JLIST),DTT%NPAR_USETYPE(JLIST), &
                DTT%NPAR_P1TERRITORY(JLIST),DTT%NPAR_BLDCODE(JLIST))
        ELSE
           CALL BLDCODE(DTT%NPAR_BLDTYPE(JLIST),DTT%NPAR_COL_BLD_AGE(JLIST),DTT%NPAR_USETYPE(JLIST), &
                DTT%NPAR_PXTERRITORY(JLIST),DTT%NPAR_BLDCODE(JLIST))
        ENDIF
        !
     ENDIF
     !
     ! N) In the case the use is AGRICOLE the building type must be BA
     !    CAUTION: hardcoded position
     !
     IF ( (DTT%NPAR_USETYPE(JLIST).EQ.1).AND.(DTT%NPAR_BLDTYPE(JLIST).NE.9) )  THEN
        !
        DTT%NPAR_BLDTYPE(JLIST)=9
        !
        IF (DTT%NPAR_IND_BLD_AGE(JLIST).EQ.1) THEN
           CALL BLDCODE(DTT%NPAR_BLDTYPE(JLIST),DTT%NPAR_IND_BLD_AGE(JLIST),DTT%NPAR_USETYPE(JLIST), &
                DTT%NPAR_P1TERRITORY(JLIST),DTT%NPAR_BLDCODE(JLIST))
        ELSE
           CALL BLDCODE(DTT%NPAR_BLDTYPE(JLIST),DTT%NPAR_IND_BLD_AGE(JLIST),DTT%NPAR_USETYPE(JLIST), &
                DTT%NPAR_PXTERRITORY(JLIST),DTT%NPAR_BLDCODE(JLIST))
        ENDIF
        !
     ENDIF
     !
     ! O) In the case the use is SERRE the building type must be BA
     !    CAUTION: hardcoded position
     !
     IF ( (DTT%NPAR_USETYPE(JLIST).EQ.11).AND.(DTT%NPAR_BLDTYPE(JLIST).NE.9) )  THEN
        !
        DTT%NPAR_BLDTYPE(JLIST)=9
        !
        IF (DTT%NPAR_IND_BLD_AGE(JLIST).EQ.1) THEN
           CALL BLDCODE(DTT%NPAR_BLDTYPE(JLIST),DTT%NPAR_IND_BLD_AGE(JLIST),DTT%NPAR_USETYPE(JLIST), &
                DTT%NPAR_P1TERRITORY(JLIST),DTT%NPAR_BLDCODE(JLIST))
        ELSE
           CALL BLDCODE(DTT%NPAR_BLDTYPE(JLIST),DTT%NPAR_IND_BLD_AGE(JLIST),DTT%NPAR_USETYPE(JLIST), &
                DTT%NPAR_PXTERRITORY(JLIST),DTT%NPAR_BLDCODE(JLIST))
        ENDIF
        !
     ENDIF
     !
     ! P) In the case the use is INDUSTRIEL the building type must be BA
     !    CAUTION: hardcoded position
     !
     IF ( (DTT%NPAR_USETYPE(JLIST).EQ.6).AND.(DTT%NPAR_BLDTYPE(JLIST).NE.9) )  THEN
        !
        DTT%NPAR_BLDTYPE(JLIST)=9
        !
        IF (DTT%NPAR_IND_BLD_AGE(JLIST).EQ.1) THEN
           CALL BLDCODE(DTT%NPAR_BLDTYPE(JLIST),DTT%NPAR_IND_BLD_AGE(JLIST),DTT%NPAR_USETYPE(JLIST), &
                DTT%NPAR_P1TERRITORY(JLIST),DTT%NPAR_BLDCODE(JLIST))
        ELSE
           CALL BLDCODE(DTT%NPAR_BLDTYPE(JLIST),DTT%NPAR_IND_BLD_AGE(JLIST),DTT%NPAR_USETYPE(JLIST), &
                DTT%NPAR_PXTERRITORY(JLIST),DTT%NPAR_BLDCODE(JLIST))
        ENDIF
        !
     ENDIF
     !
     ! Q) In the case the use is COMMERCE the building type must be ID/ICIF/BA
     !    Except for historical construction period.
     !    CAUTION: hardcoded position
     !
     IF (DTT%NPAR_COL_BLD_AGE(JLIST).GT.1) THEN
        !
        IF ( (DTT%NPAR_USETYPE(JLIST).EQ.3).AND. &
             ((DTT%NPAR_BLDTYPE(JLIST).NE.5).AND.(DTT%NPAR_BLDTYPE(JLIST).NE.7).AND.(DTT%NPAR_BLDTYPE(JLIST).NE.9)) )  THEN
           !
           DTT%NPAR_BLDTYPE(JLIST)=7
           !
           IF (DTT%NPAR_COL_BLD_AGE(JLIST).EQ.1) THEN
              CALL BLDCODE(DTT%NPAR_BLDTYPE(JLIST),DTT%NPAR_COL_BLD_AGE(JLIST),DTT%NPAR_USETYPE(JLIST), &
                   DTT%NPAR_P1TERRITORY(JLIST),DTT%NPAR_BLDCODE(JLIST))
           ELSE
              CALL BLDCODE(DTT%NPAR_BLDTYPE(JLIST),DTT%NPAR_COL_BLD_AGE(JLIST),DTT%NPAR_USETYPE(JLIST), &
                   DTT%NPAR_PXTERRITORY(JLIST),DTT%NPAR_BLDCODE(JLIST))
           ENDIF
           !
        ENDIF
        !
     ENDIF
     !
     ! R) In the case the use is COLLECTIF the building type must be ID/ICIO/ICIF/BGH
     !    CAUTION: hardcoded position
     !
     IF ( (DTT%NPAR_USETYPE(JLIST).EQ.4).AND. &
          ((DTT%NPAR_BLDTYPE(JLIST).LT.5).OR.(DTT%NPAR_BLDTYPE(JLIST).GT.8)) )  THEN
        !
        DTT%NPAR_BLDTYPE(JLIST)=7
        !
        IF (DTT%NPAR_COL_BLD_AGE(JLIST).EQ.1) THEN
           CALL BLDCODE(DTT%NPAR_BLDTYPE(JLIST),DTT%NPAR_COL_BLD_AGE(JLIST),DTT%NPAR_USETYPE(JLIST), &
                DTT%NPAR_P1TERRITORY(JLIST),DTT%NPAR_BLDCODE(JLIST))
        ELSE
           CALL BLDCODE(DTT%NPAR_BLDTYPE(JLIST),DTT%NPAR_COL_BLD_AGE(JLIST),DTT%NPAR_USETYPE(JLIST), &
                DTT%NPAR_PXTERRITORY(JLIST),DTT%NPAR_BLDCODE(JLIST))
        ENDIF
        !
     ENDIF
     !
     ! S) In the case the use is INDIVIDUEL the building type must be PD/PSC/PCIO/PCIF
     !    CAUTION: hardcoded position
     !
     IF ( (DTT%NPAR_USETYPE(JLIST).EQ.5).AND.(DTT%NPAR_BLDTYPE(JLIST).GT.4) )  THEN
        !
        DTT%NPAR_BLDTYPE(JLIST)=1
        !
        IF (DTT%NPAR_IND_BLD_AGE(JLIST).EQ.1) THEN
           CALL BLDCODE(DTT%NPAR_BLDTYPE(JLIST),DTT%NPAR_IND_BLD_AGE(JLIST),DTT%NPAR_USETYPE(JLIST), &
                DTT%NPAR_P1TERRITORY(JLIST),DTT%NPAR_BLDCODE(JLIST))
        ELSE
           CALL BLDCODE(DTT%NPAR_BLDTYPE(JLIST),DTT%NPAR_IND_BLD_AGE(JLIST),DTT%NPAR_USETYPE(JLIST), &
                DTT%NPAR_PXTERRITORY(JLIST),DTT%NPAR_BLDCODE(JLIST))
        ENDIF
        !
     ENDIF
     !
  ENDDO
  !
  ! ##################################################################
  ! Treatment of missing combinations
  ! ##################################################################
  !
  DO JLIST=1,SIZE(KTYPE)
     !
     ! Test matching of initial building code
     !
     KTYPE(JLIST)=DTT%NPAR_BLDCODE(JLIST)
     !
     NCTL=0
     DO KLIST=1,BDD%NDESC_CODE
        IF (KTYPE(JLIST).EQ.BDD%NDESC_CODE_LIST(KLIST)) THEN
           ILIST(JLIST) = KLIST
           NCTL=NCTL+1
        ENDIF
     END DO
     !
     ! There must only be one line in the .csv-table corresponding
     ! to the given building code
     !
     IF (NCTL.GT.1) CALL ABOR1_SFX("More than one line in csv-file corresponds to input")
     !
     ! Treatment of missing data
     !
     WRITE(1012,*) "                            "
     WRITE(1012,*) "Start treating missing data "
     WRITE(1012,*) "DTT%NPAR_BLDTYPE(JLIST)     ",DTT%NPAR_BLDTYPE(JLIST)
     WRITE(1012,*) "DTT%NPAR_USETYPE(JLIST)     ",DTT%NPAR_USETYPE(JLIST)
     WRITE(1012,*) "DTT%NPAR_COL_BLD_AGE(JLIST) ",DTT%NPAR_COL_BLD_AGE(JLIST)
     WRITE(1012,*) "DTT%NPAR_IND_BLD_AGE(JLIST) ",DTT%NPAR_IND_BLD_AGE(JLIST)
     WRITE(1012,*) "DTT%NPAR_PXTERRITORY(JLIST) ",DTT%NPAR_PXTERRITORY(JLIST)
     WRITE(1012,*) "DTT%NPAR_P1TERRITORY(JLIST) ",DTT%NPAR_P1TERRITORY(JLIST)
     CALL FLUSH(1012)
     !
     IF (NCTL.EQ.0) THEN
        !
        ! If the construction period is larger than 1, the territory is set to default
        !
        IF ( (DTT%NPAR_BLDTYPE(JLIST).GT.4.5).AND.(DTT%NPAR_BLDTYPE(JLIST).LT.8.5) ) THEN
           !
           IF (DTT%NPAR_COL_BLD_AGE(JLIST).GT.1) THEN
              !
              DTT%NPAR_PXTERRITORY(JLIST)=1
              !
              CALL BLDCODE(DTT%NPAR_BLDTYPE(JLIST),DTT%NPAR_COL_BLD_AGE(JLIST),DTT%NPAR_USETYPE(JLIST), &
                   DTT%NPAR_PXTERRITORY(JLIST),DTT%NPAR_BLDCODE(JLIST))
              !
              KTYPE(JLIST)=DTT%NPAR_BLDCODE(JLIST)
              !
           ENDIF
           !
        ELSE
           !
           IF (DTT%NPAR_IND_BLD_AGE(JLIST).GT.1) THEN
              !
              DTT%NPAR_PXTERRITORY(JLIST)=1
              !
              CALL BLDCODE(DTT%NPAR_BLDTYPE(JLIST),DTT%NPAR_IND_BLD_AGE(JLIST),DTT%NPAR_USETYPE(JLIST), &
                   DTT%NPAR_PXTERRITORY(JLIST),DTT%NPAR_BLDCODE(JLIST))
              !
              KTYPE(JLIST)=DTT%NPAR_BLDCODE(JLIST)
              !
           ENDIF
           !
        ENDIF
        !
        ! Test matching of modified building code
        !
        NCTL=0
        DO KLIST=1,BDD%NDESC_CODE
           IF (KTYPE(JLIST).EQ.BDD%NDESC_CODE_LIST(KLIST)) THEN
              ILIST(JLIST) = KLIST
              NCTL=NCTL+1
           ENDIF
        ENDDO
        !
        IF (NCTL.GT.0) THEN
           !
        ELSE
           !
           WRITE(1012,*) "                                                "
           WRITE(1012,*) "Before start increasing the construction period "
           WRITE(1012,*) "DTT%NPAR_BLDTYPE(JLIST)     ",DTT%NPAR_BLDTYPE(JLIST)
           WRITE(1012,*) "DTT%NPAR_USETYPE(JLIST)     ",DTT%NPAR_USETYPE(JLIST)
           WRITE(1012,*) "DTT%NPAR_COL_BLD_AGE(JLIST) ",DTT%NPAR_COL_BLD_AGE(JLIST)
           WRITE(1012,*) "DTT%NPAR_IND_BLD_AGE(JLIST) ",DTT%NPAR_IND_BLD_AGE(JLIST)
           WRITE(1012,*) "DTT%NPAR_PXTERRITORY(JLIST) ",DTT%NPAR_PXTERRITORY(JLIST)
           WRITE(1012,*) "DTT%NPAR_P1TERRITORY(JLIST) ",DTT%NPAR_P1TERRITORY(JLIST)
           CALL FLUSH(1012)
           !
           ! In case of still missing combination the constuction period
           ! is increased until a match is found.
           !
           DO 
              !
              IF ( (DTT%NPAR_BLDTYPE(JLIST).GT.4.5).AND.(DTT%NPAR_BLDTYPE(JLIST).LT.8.5) ) THEN
                 !
                 IF (DTT%NPAR_COL_BLD_AGE(JLIST).LT.7) THEN
                    !
                    DTT%NPAR_COL_BLD_AGE(JLIST)=DTT%NPAR_COL_BLD_AGE(JLIST)+1
                    !
                    CALL BLDCODE(DTT%NPAR_BLDTYPE(JLIST),DTT%NPAR_COL_BLD_AGE(JLIST),DTT%NPAR_USETYPE(JLIST), &
                         DTT%NPAR_PXTERRITORY(JLIST),DTT%NPAR_BLDCODE(JLIST))
                    !
                    KTYPE(JLIST)=DTT%NPAR_BLDCODE(JLIST)
                    !
                 ELSE
                    WRITE(1012,*) "                            "
                    WRITE(1012,*) "In ini_data_param_teb       "
                    WRITE(1012,*) "DTT%NPAR_BLDTYPE(JLIST)     ",DTT%NPAR_BLDTYPE(JLIST)
                    WRITE(1012,*) "DTT%NPAR_COL_BLD_AGE(JLIST) ",DTT%NPAR_COL_BLD_AGE(JLIST)
                    WRITE(1012,*) "DTT%NPAR_USETYPE(JLIST)     ",DTT%NPAR_USETYPE(JLIST)
                    WRITE(1012,*) "DTT%NPAR_PXTERRITORY(JLIST) ",DTT%NPAR_PXTERRITORY(JLIST)
                    CALL FLUSH(1012)
                    STOP("Missing entry in table for P7")
                 ENDIF
                 !
              ELSE
                 !
                 IF (DTT%NPAR_IND_BLD_AGE(JLIST).LT.7) THEN
                    !
                    DTT%NPAR_IND_BLD_AGE(JLIST)=DTT%NPAR_IND_BLD_AGE(JLIST)+1
                    !
                    CALL BLDCODE(DTT%NPAR_BLDTYPE(JLIST),DTT%NPAR_IND_BLD_AGE(JLIST),DTT%NPAR_USETYPE(JLIST), &
                         DTT%NPAR_PXTERRITORY(JLIST),DTT%NPAR_BLDCODE(JLIST))
                    !
                    KTYPE(JLIST)=DTT%NPAR_BLDCODE(JLIST)
                    !
                 ELSE
                    WRITE(1012,*) "                            "
                    WRITE(1012,*) "In ini_data_param_teb       "
                    WRITE(1012,*) "DTT%NPAR_BLDTYPE(JLIST)     ",DTT%NPAR_BLDTYPE(JLIST)
                    WRITE(1012,*) "DTT%NPAR_IND_BLD_AGE(JLIST) ",DTT%NPAR_IND_BLD_AGE(JLIST)
                    WRITE(1012,*) "DTT%NPAR_USETYPE(JLIST)     ",DTT%NPAR_USETYPE(JLIST)
                    WRITE(1012,*) "DTT%NPAR_PXTERRITORY(JLIST) ",DTT%NPAR_PXTERRITORY(JLIST)
                    CALL FLUSH(1012)
                    STOP("Missing entry in table for P7")
                 ENDIF
                 !
              ENDIF
              !
              ! Test matching of modified building code
              !
              NCTL=0
              DO KLIST=1,BDD%NDESC_CODE
                 IF (KTYPE(JLIST).EQ.BDD%NDESC_CODE_LIST(KLIST)) THEN
                    ILIST(JLIST) = KLIST
                    NCTL=NCTL+1
                 ENDIF
              ENDDO
              !
              IF (NCTL.GT.0) THEN
                 EXIT
              ENDIF
              !
              ! Set territory to default
              !
              DTT%NPAR_PXTERRITORY(JLIST)=1
              !
              IF ( (DTT%NPAR_BLDTYPE(JLIST).GT.4.5).AND.(DTT%NPAR_BLDTYPE(JLIST).LT.8.5) ) THEN
                 CALL BLDCODE(DTT%NPAR_BLDTYPE(JLIST),DTT%NPAR_COL_BLD_AGE(JLIST),DTT%NPAR_USETYPE(JLIST), &
                      DTT%NPAR_PXTERRITORY(JLIST),DTT%NPAR_BLDCODE(JLIST))
              ELSE
                 CALL BLDCODE(DTT%NPAR_BLDTYPE(JLIST),DTT%NPAR_IND_BLD_AGE(JLIST),DTT%NPAR_USETYPE(JLIST), &
                      DTT%NPAR_PXTERRITORY(JLIST),DTT%NPAR_BLDCODE(JLIST))
              ENDIF
              !
              KTYPE(JLIST)=DTT%NPAR_BLDCODE(JLIST)
              !
              ! Test matching of modified building code
              !
              NCTL=0
              DO KLIST=1,BDD%NDESC_CODE
                 IF (KTYPE(JLIST).EQ.BDD%NDESC_CODE_LIST(KLIST)) THEN
                    ILIST(JLIST) = KLIST
                    NCTL=NCTL+1
                 ENDIF
              ENDDO
              !
              IF (NCTL.GT.0) THEN
                 EXIT
              ENDIF
              !
           ENDDO
           !
        ENDIF
        !
     ENDIF
     !
  ENDDO
  !
  ! ###########################################################
  ! Initialisation of architectural characteristics 
  ! ###########################################################
  !
  IINDEX = 0
  !
  !-------------------------------------------------------------------------------
  DO JLOOP=1,SIZE(KTYPE)
     !-------------------------------------------------------------------------------
     !
     IINDEX=ILIST(JLOOP)
     !
     ! 1.     town parameters depending on urban characteristics
     !      --------------------------------------------------------
     !
     ! Road
     !
     IF (PRESENT(PALB_ROAD)) THEN
        PALB_ROAD(JLOOP)=BDD%XDESC_ALB_ROAD(IINDEX)
     ENDIF
     IF (PRESENT(PEMIS_ROAD)) THEN
        PEMIS_ROAD(JLOOP)=BDD%XDESC_EMIS_ROAD(IINDEX)
     ENDIF
     IF (PRESENT(PHC_ROAD)) THEN
        PHC_ROAD(JLOOP,:)= BDD%XDESC_HC_ROAD(IINDEX,:)
     ENDIF
     IF (PRESENT(PTC_ROAD)) THEN
        PTC_ROAD(JLOOP,:)= BDD%XDESC_TC_ROAD(IINDEX,:)
     ENDIF
     IF (PRESENT(PD_ROAD)) THEN
        PD_ROAD(JLOOP,:)= BDD%XDESC_D_ROAD(IINDEX,:)
     ENDIF
     !
     ! Roof
     !
     IF (PRESENT(PALB_ROOF)) THEN
        PALB_ROOF(JLOOP)=BDD%XDESC_ALB_ROOF(IINDEX)
     ENDIF
     IF (PRESENT(PEMIS_ROOF)) THEN
        PEMIS_ROOF(JLOOP)=BDD%XDESC_EMIS_ROOF(IINDEX)
     ENDIF
     IF (PRESENT(PHC_ROOF)) THEN
        PHC_ROOF(JLOOP,:)= BDD%XDESC_HC_ROOF(IINDEX,:)
     ENDIF
     IF (PRESENT(PTC_ROOF)) THEN
        PTC_ROOF(JLOOP,:)= BDD%XDESC_TC_ROOF(IINDEX,:)
     ENDIF
     IF (PRESENT(PD_ROOF)) THEN
        PD_ROOF(JLOOP,:)= BDD%XDESC_D_ROOF(IINDEX,:)
     ENDIF
     !
     ! Wall
     !
     IF (PRESENT(PALB_WALL)) THEN
        PALB_WALL(JLOOP)=BDD%XDESC_ALB_WALL(IINDEX)
     ENDIF
     IF (PRESENT(PEMIS_WALL)) THEN
        PEMIS_WALL(JLOOP)=BDD%XDESC_EMIS_WALL(IINDEX)
     ENDIF
     IF (PRESENT(PHC_WALL)) THEN
        PHC_WALL(JLOOP,:)= BDD%XDESC_HC_WALL(IINDEX,:)
     ENDIF
     IF (PRESENT(PTC_WALL)) THEN
        PTC_WALL(JLOOP,:)= BDD%XDESC_TC_WALL(IINDEX,:)
     ENDIF
     IF (PRESENT(PD_WALL)) THEN
        PD_WALL(JLOOP,:)=BDD%XDESC_D_WALL(IINDEX,:)
     ENDIF
     !
     ! Position of isolation layers
     !
     IF (PRESENT(NISOROOFPOS)) THEN
        NISOROOFPOS(JLOOP) = BDD%NDESC_ISOROOFPOS(IINDEX)
     ENDIF
     IF (PRESENT(NISOWALLPOS)) THEN
        NISOWALLPOS(JLOOP) = BDD%NDESC_ISOWALLPOS(IINDEX)
     ENDIF
     !
     ! Floor
     !
     IF (PRESENT(PHC_FLOOR)) THEN
        PHC_FLOOR(JLOOP,:)= BDD%XDESC_HC_FLOOR(IINDEX,:)
     ENDIF
     IF (PRESENT(PTC_FLOOR)) THEN
        PTC_FLOOR(JLOOP,:)= BDD%XDESC_TC_FLOOR(IINDEX,:)
     ENDIF
     IF (PRESENT(PD_FLOOR)) THEN
        PD_FLOOR(JLOOP,:)= BDD%XDESC_D_FLOOR(IINDEX,:)
     ENDIF
     !
     ! Mass
     !
     IF (PRESENT(PHC_MASS)) THEN
        PHC_MASS(JLOOP,:)= BDD%XDESC_HC_MASS(IINDEX,:)
     ENDIF
     IF (PRESENT(PTC_MASS)) THEN
        PTC_MASS(JLOOP,:)= BDD%XDESC_TC_MASS(IINDEX,:)
     ENDIF
     IF (PRESENT(PD_MASS)) THEN
        PD_MASS(JLOOP,:)= BDD%XDESC_D_MASS(IINDEX,:)
     ENDIF
     IF (PRESENT(PISMASS)) THEN
        PISMASS(JLOOP) = BDD%XDESC_ISMASS(IINDEX)
     ENDIF
     !
     IF (PRESENT(PN50)) THEN
        PN50(JLOOP) = BDD%XDESC_N50(IINDEX)
     ENDIF
     !
     IF (PRESENT(PGR)) THEN
        PGR(JLOOP) = BDD%XDESC_GR(IINDEX)
     ENDIF
     !
     IF (PRESENT(PU_WIN)) THEN
        PU_WIN(JLOOP) = BDD%XDESC_U_WIN(IINDEX)
     ENDIF
     !
     IF (PRESENT(PSHGC)) THEN
        PSHGC(JLOOP) = BDD%XDESC_SHGC(IINDEX)
     ENDIF
     !
     IF (PRESENT(PSHGC_SH)) THEN
        PSHGC_SH(JLOOP) = BDD%XDESC_SHGC_SH(IINDEX)
     ENDIF
     !
     IF (PRESENT(PSHADEARCHI)) THEN
        PSHADEARCHI(JLOOP) = BDD%XDESC_SHADEARCHI(IINDEX)
     ENDIF
     !
     IF (PRESENT(PISMECH)) THEN
        PISMECH(JLOOP) = BDD%XDESC_ISMECH(IINDEX)
     ENDIF
     !
     IF (PRESENT(PMECHRATE)) THEN
        PMECHRATE(JLOOP) = BDD%XDESC_MECHRATE(IINDEX)
     ENDIF
     !
     IF (PRESENT(PGREENROOF)) THEN
        PGREENROOF(JLOOP) = BDD%XDESC_GREENROOF(IINDEX)
     ENDIF
     !
     IF (PRESENT(PEMIS_PANEL)) THEN
        PEMIS_PANEL(JLOOP) = BDD%XDESC_EMIS_PANEL(IINDEX)
     ENDIF
     !
     IF (PRESENT(PALB_PANEL)) THEN
        PALB_PANEL(JLOOP) = BDD%XDESC_ALB_PANEL(IINDEX)
     ENDIF
     !
     IF (PRESENT(PEFF_PANEL)) THEN
        PEFF_PANEL(JLOOP) = BDD%XDESC_EFF_PANEL(IINDEX)
     ENDIF
     !
     IF (PRESENT(PFRAC_PANEL)) THEN
        PFRAC_PANEL(JLOOP) = BDD%XDESC_FRAC_PANEL(IINDEX)
     ENDIF
     !
     ! ----------------------------------------------------
     ! Architectural parameters not read from table
     !  ---------------------------------------------------
     !
     IF (PRESENT(PCAP_SYS_HEAT)) THEN
        PCAP_SYS_HEAT(JLOOP) = 100.
     ENDIF
     !
     IF (PRESENT(PCAP_SYS_RAT)) THEN
        PCAP_SYS_RAT(JLOOP) = 90.
     ENDIF
     !
     IF (PRESENT(PT_ADP)) THEN
        PT_ADP(JLOOP) = 285.66
     ENDIF
     !
     IF (PRESENT(PM_SYS_RAT)) THEN
        PM_SYS_RAT(JLOOP) = 0.0067
     ENDIF
     !
     IF (PRESENT(PT_SIZE_MAX)) THEN
        PT_SIZE_MAX(JLOOP) = 301.95
     ENDIF
     !
     IF (PRESENT(PT_SIZE_MIN)) THEN
        PT_SIZE_MIN(JLOOP) = 268.96
     ENDIF
     !
     IF (PRESENT(PFLOOR_HEIGHT)) THEN
        PFLOOR_HEIGHT(JLOOP) = 2.9
     ENDIF
     !
     IF (PRESENT(PROUGH_ROOF)) THEN
        PROUGH_ROOF(JLOOP) = 1.52
     ENDIF
     !
     IF (PRESENT(PROUGH_WALL)) THEN
        PROUGH_WALL(JLOOP) = 1.52
     ENDIF
     !
  END DO
  !
  DEALLOCATE(ILIST)
  !
  ! ###########################################################
  ! Initialisation of behavioural characteristics 
  !
  ! One can simulate with 1 or 6 compartments
  ! For 6-compartments-case, the compartments are defined as follows
  ! - (1): FORT CRE   (if applicable)
  ! - (2): FAIBLE CRE (if applicable)
  ! - (3): Mean between FORT CRE and FAIBLE CRE (if applicable)
  ! - (4): non-heated fraction of the building
  ! - (5): COMMERCIAL fraction (if applicable)
  ! - (6): TERTIARE   fraction (if applicable)
  !
  ! For the 1-compartment-case, the input values are averaged
  ! to represent the variety of behaviours as good as possible
  !
  ! ###########################################################
  !
  ! Initialisation of the fraction of compartments
  !
  DO JLIST=1,SIZE(DTT%NPAR_USETYPE)
     !
     CALL GETPOS(BDD%NDESC_HEATUSEV,DTT%NPAR_USETYPE(JLIST),"HEAT","FORT",NPOS_FORT_CRE)
     CALL GETPOS(BDD%NDESC_HEATUSEV,DTT%NPAR_USETYPE(JLIST),"HEAT","FAIB",NPOS_FAIB_CRE)
     CALL GETPOS(BDD%NDESC_HEATUSEV,03,"HEAT","DUMM",NPOS_COM)
     CALL GETPOS(BDD%NDESC_HEATUSEV,13,"HEAT","DUMM",NPOS_TER)
     !
     IF (PRESENT(PFRACOMP)) THEN
        !
        IF (SIZE(PFRACOMP,2).EQ.1) THEN
           !
           PFRACOMP(JLIST,1) = 1.0
           !
        ELSEIF (SIZE(PFRACOMP,2).EQ.6) THEN
           !
           IF (DTT%NPAR_USETYPE(JLIST).EQ.4) THEN
              !
              ! For main use = COLLECTIVE housing, a non-heated fraction,
              ! a COMMERCIAL and TERTIARY fraction and 3 residential
              ! compartments with 3 different heating design temperatures are considered.
              !
              PFRACOMP(JLIST,4) = DTT%XPAR_CRE_APPT(JLIST)  * BDD%XDESC_FNOHEAT(NPOS_FORT_CRE) + &
                   (1.0-DTT%XPAR_CRE_APPT(JLIST)) * BDD%XDESC_FNOHEAT(NPOS_FAIB_CRE)
              !
              PFRACOMP(JLIST,5) = DTT%XPAR_FRACCOM(JLIST) * (1.0 - PFRACOMP(JLIST,4))
              PFRACOMP(JLIST,6) = DTT%XPAR_FRACTER(JLIST) * (1.0 - PFRACOMP(JLIST,4))
              !
              PFRACOMP(JLIST,1) = (1.0 - PFRACOMP(JLIST,4) - PFRACOMP(JLIST,5) - PFRACOMP(JLIST,6)) * &
                   (DTT%XPAR_CRE_APPT(JLIST)  * BDD%XDESC_FLDT(NPOS_FORT_CRE) + & 
                   (1.0-DTT%XPAR_CRE_APPT(JLIST)) * BDD%XDESC_FLDT(NPOS_FAIB_CRE))
              !
              PFRACOMP(JLIST,2) = (1.0 - PFRACOMP(JLIST,4) - PFRACOMP(JLIST,5) - PFRACOMP(JLIST,6)) * &
                   (DTT%XPAR_CRE_APPT(JLIST)  * BDD%XDESC_FHDT(NPOS_FORT_CRE) + &
                   (1.0-DTT%XPAR_CRE_APPT(JLIST)) * BDD%XDESC_FHDT(NPOS_FAIB_CRE))
              !
              PFRACOMP(JLIST,3) = (1.0 - PFRACOMP(JLIST,4) - PFRACOMP(JLIST,5) - PFRACOMP(JLIST,6)) * &
                   (DTT%XPAR_CRE_APPT(JLIST)  * BDD%XDESC_FIDT(NPOS_FORT_CRE) + &
                   (1.0-DTT%XPAR_CRE_APPT(JLIST)) * BDD%XDESC_FIDT(NPOS_FAIB_CRE))
              !
           ELSEIF (DTT%NPAR_USETYPE(JLIST).EQ.5) THEN
              !
              ! For main use = INDIVIDUAL housing, a non-heated fraction,
              ! a COMMERCIAL and TERTIARY fraction and 3 residential
              ! compartments with 3 different heating design temperatures are considered.
              !
              PFRACOMP(JLIST,4) = DTT%XPAR_CRE_MAIS(JLIST)  * BDD%XDESC_FNOHEAT(NPOS_FORT_CRE) + &
                   (1.0-DTT%XPAR_CRE_MAIS(JLIST)) * BDD%XDESC_FNOHEAT(NPOS_FAIB_CRE)
              !
              PFRACOMP(JLIST,5) = DTT%XPAR_FRACCOM(JLIST) * (1.0 - PFRACOMP(JLIST,4))
              PFRACOMP(JLIST,6) = DTT%XPAR_FRACTER(JLIST) * (1.0 - PFRACOMP(JLIST,4))
              !
              PFRACOMP(JLIST,1) = (1.0 - PFRACOMP(JLIST,4) - PFRACOMP(JLIST,5) - PFRACOMP(JLIST,6)) * &
                   (DTT%XPAR_CRE_MAIS(JLIST)  * BDD%XDESC_FLDT(NPOS_FORT_CRE) + &
                   (1.0-DTT%XPAR_CRE_MAIS(JLIST)) * BDD%XDESC_FLDT(NPOS_FAIB_CRE))
              !
              PFRACOMP(JLIST,2) = (1.0 - PFRACOMP(JLIST,4) - PFRACOMP(JLIST,5) - PFRACOMP(JLIST,6)) * &
                   (DTT%XPAR_CRE_MAIS(JLIST)  * BDD%XDESC_FHDT(NPOS_FORT_CRE) + &
                   (1.0-DTT%XPAR_CRE_MAIS(JLIST)) * BDD%XDESC_FHDT(NPOS_FAIB_CRE))
              !
              PFRACOMP(JLIST,3) = (1.0 - PFRACOMP(JLIST,4) - PFRACOMP(JLIST,5) - PFRACOMP(JLIST,6)) * &
                   (DTT%XPAR_CRE_MAIS(JLIST)  * BDD%XDESC_FIDT(NPOS_FORT_CRE) + &
                   (1.0-DTT%XPAR_CRE_MAIS(JLIST)) * BDD%XDESC_FIDT(NPOS_FAIB_CRE))
              !
           ELSEIF ( (DTT%NPAR_USETYPE(JLIST).EQ.03).OR.(DTT%NPAR_USETYPE(JLIST).EQ.09) .OR. &
                (DTT%NPAR_USETYPE(JLIST).EQ.10).OR.(DTT%NPAR_USETYPE(JLIST).EQ.13) ) THEN
              !
              ! For the main use = TERTIARY, COMMERCIAL, HEALTH and EDUCATION
              ! a non-heated fraction and 3 compartments with different design temperatures
              ! of heating and climatisation are considered
              !
              PFRACOMP(JLIST,4) = BDD%XDESC_FNOHEAT(NPOS_FORT_CRE)
              PFRACOMP(JLIST,5) = 0.0
              PFRACOMP(JLIST,6) = 0.0
              !
              PFRACOMP(JLIST,1) = (1.0 - PFRACOMP(JLIST,4) - PFRACOMP(JLIST,5) - PFRACOMP(JLIST,6)) * &
                   BDD%XDESC_FLDT(NPOS_FORT_CRE)
              !
              PFRACOMP(JLIST,2) = (1.0 - PFRACOMP(JLIST,4) - PFRACOMP(JLIST,5) - PFRACOMP(JLIST,6)) * &
                   BDD%XDESC_FHDT(NPOS_FORT_CRE)
              !
              PFRACOMP(JLIST,3) = (1.0 - PFRACOMP(JLIST,4) - PFRACOMP(JLIST,5) - PFRACOMP(JLIST,6)) * &
                   BDD%XDESC_FIDT(NPOS_FORT_CRE)
              !
           ELSE
              !
              ! Only a non-heated fraction is considered
              !
              PFRACOMP(JLIST,4) = BDD%XDESC_FNOHEAT(NPOS_FORT_CRE)
              PFRACOMP(JLIST,5) = 0.0
              PFRACOMP(JLIST,6) = 0.0
              PFRACOMP(JLIST,1) = 1.0 - PFRACOMP(JLIST,4) - PFRACOMP(JLIST,5) - PFRACOMP(JLIST,6)
              PFRACOMP(JLIST,2) = 0.0
              PFRACOMP(JLIST,3) = 0.0
              !
           ENDIF
           !
        ELSE 
           CALL ABOR1_SFX("No rule for this number of compartiments")
        ENDIF
        !
        ! Check the results for the fraction of compartiments
        !
        IF (ABS(SUM(PFRACOMP(JLIST,:))-1.0).GT.1.0e-6) CALL ABOR1_SFX("Wrong fraction of compartiments")
        !
     ENDIF
     !
  ENDDO
  !
  ! ###########################################################
  !
  ! Initialisation of heating-related variables
  !
  DO JLIST=1,SIZE(DTT%NPAR_USETYPE)
     !
     CALL GETPOS(BDD%NDESC_HEATUSEV,DTT%NPAR_USETYPE(JLIST),"HEAT","FORT",NPOS_FORT_CRE)
     CALL GETPOS(BDD%NDESC_HEATUSEV,DTT%NPAR_USETYPE(JLIST),"HEAT","FAIB",NPOS_FAIB_CRE)
     CALL GETPOS(BDD%NDESC_HEATUSEV,03,"HEAT","DUMM",NPOS_COM)
     CALL GETPOS(BDD%NDESC_HEATUSEV,13,"HEAT","DUMM",NPOS_TER)
     !
     IF (PRESENT(PTHEAT_OCCD)) THEN
        !
        PTHEAT_OCCD(JLIST,1) = (1.0-0.5*(BDD%XDESC_FNOHEAT(NPOS_FORT_CRE)+BDD%XDESC_FNOHEAT(NPOS_FAIB_CRE)))* &
             0.5 * (BDD%XDESC_THEAT_OCCD(NPOS_FORT_CRE)+BDD%XDESC_THEAT_OCCD(NPOS_FAIB_CRE)) + &
             0.5 * (BDD%XDESC_FNOHEAT(NPOS_FORT_CRE)+BDD%XDESC_FNOHEAT(NPOS_FAIB_CRE)) * &
             0.5 * (BDD%XDESC_THEAT_VCLD(NPOS_FORT_CRE)+BDD%XDESC_THEAT_VCLD(NPOS_FAIB_CRE))
        !
        IF (SIZE(PTHEAT_OCCD,2).GT.1) THEN
           !
           IF ((DTT%NPAR_USETYPE(JLIST).EQ.4).OR.(DTT%NPAR_USETYPE(JLIST).EQ.5)) THEN
              !
              ! Residential buildings
              !
              PTHEAT_OCCD(JLIST,1) = BDD%XDESC_THEAT_OCCD(NPOS_FORT_CRE)
              PTHEAT_OCCD(JLIST,2) = BDD%XDESC_THEAT_OCCD(NPOS_FAIB_CRE)
              PTHEAT_OCCD(JLIST,3) = 0.5*(BDD%XDESC_THEAT_OCCD(NPOS_FORT_CRE)+BDD%XDESC_THEAT_OCCD(NPOS_FAIB_CRE))
              !
           ELSE IF ((DTT%NPAR_USETYPE(JLIST).EQ.03).OR.(DTT%NPAR_USETYPE(JLIST).EQ.09) .OR. &
                (DTT%NPAR_USETYPE(JLIST).EQ.10).OR.(DTT%NPAR_USETYPE(JLIST).EQ.13)) THEN
              !
              ! Tertairy, commercial, health and educational buildings (modulation of 2 K)
              !
              PTHEAT_OCCD(JLIST,1) = BDD%XDESC_THEAT_OCCD(NPOS_FORT_CRE) - 2.0
              PTHEAT_OCCD(JLIST,2) = BDD%XDESC_THEAT_OCCD(NPOS_FORT_CRE) + 2.0
              PTHEAT_OCCD(JLIST,3) = BDD%XDESC_THEAT_OCCD(NPOS_FORT_CRE)
              !
           ELSE
              !
              ! Same design temperature in all compartments
              !
              PTHEAT_OCCD(JLIST,1) = BDD%XDESC_THEAT_OCCD(NPOS_FORT_CRE)
              PTHEAT_OCCD(JLIST,2) = BDD%XDESC_THEAT_OCCD(NPOS_FORT_CRE)
              PTHEAT_OCCD(JLIST,3) = BDD%XDESC_THEAT_OCCD(NPOS_FORT_CRE)
              !
           ENDIF
           !
           PTHEAT_OCCD(JLIST,4) = 200.0
           PTHEAT_OCCD(JLIST,5) = BDD%XDESC_THEAT_OCCD(NPOS_COM)
           PTHEAT_OCCD(JLIST,6) = BDD%XDESC_THEAT_OCCD(NPOS_TER)
           !
        ENDIF
        !
     ENDIF
     !
     IF (PRESENT(PTHEAT_OCCN)) THEN
        !
        PTHEAT_OCCN(JLIST,1) = (1.0-0.5*(BDD%XDESC_FNOHEAT(NPOS_FORT_CRE)+BDD%XDESC_FNOHEAT(NPOS_FAIB_CRE))) * &
             0.5*(BDD%XDESC_THEAT_OCCN(NPOS_FORT_CRE)+BDD%XDESC_THEAT_OCCN(NPOS_FAIB_CRE))                   + &
             0.5*(BDD%XDESC_FNOHEAT(NPOS_FORT_CRE)+BDD%XDESC_FNOHEAT(NPOS_FAIB_CRE)) * &
             0.5*(BDD%XDESC_THEAT_VCLD(NPOS_FORT_CRE)+BDD%XDESC_THEAT_VCLD(NPOS_FAIB_CRE))
        !
        IF (SIZE(PTHEAT_OCCN,2).GT.1) THEN
           !
           IF ((DTT%NPAR_USETYPE(JLIST).EQ.4).OR.(DTT%NPAR_USETYPE(JLIST).EQ.5)) THEN
              !
              ! Residential buildings
              !
              PTHEAT_OCCN(JLIST,1) = BDD%XDESC_THEAT_OCCN(NPOS_FORT_CRE)
              PTHEAT_OCCN(JLIST,2) = BDD%XDESC_THEAT_OCCN(NPOS_FAIB_CRE)
              PTHEAT_OCCN(JLIST,3) = 0.5*(BDD%XDESC_THEAT_OCCN(NPOS_FORT_CRE)+BDD%XDESC_THEAT_OCCN(NPOS_FAIB_CRE))
              !
           ELSE IF ((DTT%NPAR_USETYPE(JLIST).EQ.03).OR.(DTT%NPAR_USETYPE(JLIST).EQ.09) .OR. &
                (DTT%NPAR_USETYPE(JLIST).EQ.10).OR.(DTT%NPAR_USETYPE(JLIST).EQ.13)) THEN
              !
              ! Tertairy, commercial, health and educational buildings (modulation of 2 K)
              !
              PTHEAT_OCCN(JLIST,1) = BDD%XDESC_THEAT_OCCN(NPOS_FORT_CRE) - 2.0
              PTHEAT_OCCN(JLIST,2) = BDD%XDESC_THEAT_OCCN(NPOS_FORT_CRE) + 2.0
              PTHEAT_OCCN(JLIST,3) = BDD%XDESC_THEAT_OCCN(NPOS_FORT_CRE)
              !
           ELSE
              !
              ! Same design temperature in all compartments
              !
              PTHEAT_OCCN(JLIST,1) = BDD%XDESC_THEAT_OCCN(NPOS_FORT_CRE)
              PTHEAT_OCCN(JLIST,2) = BDD%XDESC_THEAT_OCCN(NPOS_FORT_CRE)
              PTHEAT_OCCN(JLIST,3) = BDD%XDESC_THEAT_OCCN(NPOS_FORT_CRE)
              !
           ENDIF
           !
           PTHEAT_OCCN(JLIST,4) = 200.0
           PTHEAT_OCCN(JLIST,5) = BDD%XDESC_THEAT_OCCN(NPOS_COM)
           PTHEAT_OCCN(JLIST,6) = BDD%XDESC_THEAT_OCCN(NPOS_TER)
           !
        ENDIF
        !
     ENDIF
     !
     IF (PRESENT(PTHEAT_VCDD)) THEN
        !
        PTHEAT_VCDD(JLIST,1) = (1.0-0.5*(BDD%XDESC_FNOHEAT(NPOS_FORT_CRE)+BDD%XDESC_FNOHEAT(NPOS_FAIB_CRE))) * &
             0.5*(BDD%XDESC_THEAT_VCDD(NPOS_FORT_CRE)+BDD%XDESC_THEAT_VCDD(NPOS_FAIB_CRE))                   + &
             0.5*(BDD%XDESC_FNOHEAT(NPOS_FORT_CRE)+BDD%XDESC_FNOHEAT(NPOS_FAIB_CRE)) * &
             0.5*(BDD%XDESC_THEAT_VCLD(NPOS_FORT_CRE)+BDD%XDESC_THEAT_VCLD(NPOS_FAIB_CRE))
        !
        IF (SIZE(PTHEAT_VCDD,2).GT.1) THEN
           !
           IF ((DTT%NPAR_USETYPE(JLIST).EQ.4).OR.(DTT%NPAR_USETYPE(JLIST).EQ.5)) THEN
              !
              ! Residential buildings
              !
              PTHEAT_VCDD(JLIST,1) = BDD%XDESC_THEAT_VCDD(NPOS_FORT_CRE)
              PTHEAT_VCDD(JLIST,2) = BDD%XDESC_THEAT_VCDD(NPOS_FAIB_CRE)
              PTHEAT_VCDD(JLIST,3) = 0.5*(BDD%XDESC_THEAT_VCDD(NPOS_FORT_CRE)+BDD%XDESC_THEAT_VCDD(NPOS_FAIB_CRE))
              !
           ELSE IF ((DTT%NPAR_USETYPE(JLIST).EQ.03).OR.(DTT%NPAR_USETYPE(JLIST).EQ.09) .OR. &
                (DTT%NPAR_USETYPE(JLIST).EQ.10).OR.(DTT%NPAR_USETYPE(JLIST).EQ.13)) THEN
              !
              ! Tertairy, commercial, health and educational buildings (modulation of 2 K)
              !
              PTHEAT_VCDD(JLIST,1) = BDD%XDESC_THEAT_VCDD(NPOS_FORT_CRE) - 2.0
              PTHEAT_VCDD(JLIST,2) = BDD%XDESC_THEAT_VCDD(NPOS_FORT_CRE) + 2.0
              PTHEAT_VCDD(JLIST,3) = BDD%XDESC_THEAT_VCDD(NPOS_FORT_CRE)
              !
           ELSE
              !
              ! Same design temperature in all compartments
              !
              PTHEAT_VCDD(JLIST,1) = BDD%XDESC_THEAT_VCDD(NPOS_FORT_CRE)
              PTHEAT_VCDD(JLIST,2) = BDD%XDESC_THEAT_VCDD(NPOS_FORT_CRE)
              PTHEAT_VCDD(JLIST,3) = BDD%XDESC_THEAT_VCDD(NPOS_FORT_CRE)
              !
           ENDIF
           !
           PTHEAT_VCDD(JLIST,4) = 200.0
           PTHEAT_VCDD(JLIST,5) = BDD%XDESC_THEAT_VCDD(NPOS_COM)
           PTHEAT_VCDD(JLIST,6) = BDD%XDESC_THEAT_VCDD(NPOS_TER)
           !
        ENDIF
        !
     ENDIF
     !
     IF (PRESENT(PTHEAT_VCDN)) THEN
        !
        PTHEAT_VCDN(JLIST,1) = (1.0-0.5*(BDD%XDESC_FNOHEAT(NPOS_FORT_CRE)+BDD%XDESC_FNOHEAT(NPOS_FAIB_CRE))) * & 
             0.5*(BDD%XDESC_THEAT_VCDN(NPOS_FORT_CRE)+BDD%XDESC_THEAT_VCDN(NPOS_FAIB_CRE))                   + &
             0.5*(BDD%XDESC_FNOHEAT(NPOS_FORT_CRE)+BDD%XDESC_FNOHEAT(NPOS_FAIB_CRE))                         * &
             0.5*(BDD%XDESC_THEAT_VCLD(NPOS_FORT_CRE)+BDD%XDESC_THEAT_VCLD(NPOS_FAIB_CRE))
        !
        IF (SIZE(PTHEAT_VCDN,2).GT.1) THEN
           !
           IF ((DTT%NPAR_USETYPE(JLIST).EQ.4).OR.(DTT%NPAR_USETYPE(JLIST).EQ.5)) THEN
              !
              ! Residential buildings
              !
              PTHEAT_VCDN(JLIST,1) = BDD%XDESC_THEAT_VCDN(NPOS_FORT_CRE)
              PTHEAT_VCDN(JLIST,2) = BDD%XDESC_THEAT_VCDN(NPOS_FAIB_CRE)
              PTHEAT_VCDN(JLIST,3) = 0.5*(BDD%XDESC_THEAT_VCDN(NPOS_FORT_CRE)+BDD%XDESC_THEAT_VCDN(NPOS_FAIB_CRE))
              !
           ELSE IF ((DTT%NPAR_USETYPE(JLIST).EQ.03).OR.(DTT%NPAR_USETYPE(JLIST).EQ.09) .OR. &
                (DTT%NPAR_USETYPE(JLIST).EQ.10).OR.(DTT%NPAR_USETYPE(JLIST).EQ.13)) THEN
              !
              ! Tertairy, commercial, health and educational buildings (modulation of 2 K)
              !
              PTHEAT_VCDN(JLIST,1) = BDD%XDESC_THEAT_VCDN(NPOS_FORT_CRE) - 2.0
              PTHEAT_VCDN(JLIST,2) = BDD%XDESC_THEAT_VCDN(NPOS_FORT_CRE) + 2.0
              PTHEAT_VCDN(JLIST,3) = BDD%XDESC_THEAT_VCDN(NPOS_FORT_CRE)
              !
           ELSE
              !
              ! Same design temperature in all compartments
              !
              PTHEAT_VCDN(JLIST,1) = BDD%XDESC_THEAT_VCDN(NPOS_FORT_CRE)
              PTHEAT_VCDN(JLIST,2) = BDD%XDESC_THEAT_VCDN(NPOS_FORT_CRE)
              PTHEAT_VCDN(JLIST,3) = BDD%XDESC_THEAT_VCDN(NPOS_FORT_CRE)
              !
           ENDIF
           !
           PTHEAT_VCDN(JLIST,4) = 200.0
           PTHEAT_VCDN(JLIST,5) = BDD%XDESC_THEAT_VCDN(NPOS_COM)
           PTHEAT_VCDN(JLIST,6) = BDD%XDESC_THEAT_VCDN(NPOS_TER)
           !
        ENDIF
        !
     ENDIF
     !
     IF (PRESENT(PTHEAT_VCLD)) THEN
        !
        PTHEAT_VCLD(JLIST,1) = 0.5*(BDD%XDESC_THEAT_VCLD(NPOS_FORT_CRE)+BDD%XDESC_THEAT_VCLD(NPOS_FAIB_CRE))
        !
        IF (SIZE(PTHEAT_VCLD,2).GT.1) THEN
           !
           IF ((DTT%NPAR_USETYPE(JLIST).EQ.4).OR.(DTT%NPAR_USETYPE(JLIST).EQ.5)) THEN
              !
              ! Residential buildings
              !
              PTHEAT_VCLD(JLIST,1) = BDD%XDESC_THEAT_VCLD(NPOS_FORT_CRE)
              PTHEAT_VCLD(JLIST,2) = BDD%XDESC_THEAT_VCLD(NPOS_FAIB_CRE)
              PTHEAT_VCLD(JLIST,3) = 0.5*(BDD%XDESC_THEAT_VCLD(NPOS_FORT_CRE)+BDD%XDESC_THEAT_VCLD(NPOS_FAIB_CRE))
              !
           ELSE IF ((DTT%NPAR_USETYPE(JLIST).EQ.03).OR.(DTT%NPAR_USETYPE(JLIST).EQ.09) .OR. &
                (DTT%NPAR_USETYPE(JLIST).EQ.10).OR.(DTT%NPAR_USETYPE(JLIST).EQ.13)) THEN
              !
              ! Tertairy, commercial, health and educational buildings (modulation of 2 K)
              !
              PTHEAT_VCLD(JLIST,1) = BDD%XDESC_THEAT_VCLD(NPOS_FORT_CRE) - 2.0
              PTHEAT_VCLD(JLIST,2) = BDD%XDESC_THEAT_VCLD(NPOS_FORT_CRE) + 2.0
              PTHEAT_VCLD(JLIST,3) = BDD%XDESC_THEAT_VCLD(NPOS_FORT_CRE)
              !
           ELSE
              !
              ! Same design temperature in all compartments
              !
              PTHEAT_VCLD(JLIST,1) = BDD%XDESC_THEAT_VCLD(NPOS_FORT_CRE)
              PTHEAT_VCLD(JLIST,2) = BDD%XDESC_THEAT_VCLD(NPOS_FORT_CRE)
              PTHEAT_VCLD(JLIST,3) = BDD%XDESC_THEAT_VCLD(NPOS_FORT_CRE)
              !
           ENDIF
           !
           PTHEAT_VCLD(JLIST,4) = 200.0
           PTHEAT_VCLD(JLIST,5) = BDD%XDESC_THEAT_VCLD(NPOS_COM)
           PTHEAT_VCLD(JLIST,6) = BDD%XDESC_THEAT_VCLD(NPOS_TER)
           !
        ENDIF
        !
     ENDIF
     !
  ENDDO
  !
  ! Initialisation of cooling-related variables
  !
  DO JLIST=1,SIZE(DTT%NPAR_USETYPE)
     !
     ! The values of the non-heated fraction are 
     ! required for the 1-compartment case
     !
     CALL GETPOS(BDD%NDESC_HEATUSEV,DTT%NPAR_USETYPE(JLIST),"HEAT","FORT",NPOS_FORT_CRE)
     CALL GETPOS(BDD%NDESC_HEATUSEV,DTT%NPAR_USETYPE(JLIST),"HEAT","FAIB",NPOS_FAIB_CRE)
     !
     CALL GETPOS(BDD%NDESC_COOLUSEV,DTT%NPAR_USETYPE(JLIST),"COOL","DUMM",NPOS)
     CALL GETPOS(BDD%NDESC_COOLUSEV,03,"COOL","DUMM",NPOS_COM)
     CALL GETPOS(BDD%NDESC_COOLUSEV,13,"COOL","DUMM",NPOS_TER)
     !
     IF (PRESENT(PTCOOL_OCCD)) THEN
        !
        PTCOOL_OCCD(JLIST,1) = (1.0-0.5*(BDD%XDESC_FNOHEAT(NPOS_FORT_CRE)+BDD%XDESC_FNOHEAT(NPOS_FAIB_CRE)))* &
             BDD%XDESC_TCOOL_OCCD(NPOS) + &
             0.5 * (BDD%XDESC_FNOHEAT(NPOS_FORT_CRE)+BDD%XDESC_FNOHEAT(NPOS_FAIB_CRE)) * &
             (BDD%XDESC_TCOOL_OCCD(NPOS) + 10.0)
        !
        IF (SIZE(PTCOOL_OCCD,2).GT.1) THEN
           !
           IF ((DTT%NPAR_USETYPE(JLIST).EQ.4).OR.(DTT%NPAR_USETYPE(JLIST).EQ.5)) THEN
              !
              ! Residential buildings (no modulation at the moment)
              !
              PTCOOL_OCCD(JLIST,1) = BDD%XDESC_TCOOL_OCCD(NPOS)
              PTCOOL_OCCD(JLIST,2) = BDD%XDESC_TCOOL_OCCD(NPOS)
              PTCOOL_OCCD(JLIST,3) = BDD%XDESC_TCOOL_OCCD(NPOS)
              !
           ELSE IF ((DTT%NPAR_USETYPE(JLIST).EQ.03).OR.(DTT%NPAR_USETYPE(JLIST).EQ.09) .OR. &
                (DTT%NPAR_USETYPE(JLIST).EQ.10).OR.(DTT%NPAR_USETYPE(JLIST).EQ.13)) THEN
              !
              ! Tertairy, commercial, health and educational buildings
              ! Only part of building is cooled
              !
              PTCOOL_OCCD(JLIST,1) = 400.0
              PTCOOL_OCCD(JLIST,2) = BDD%XDESC_TCOOL_OCCD(NPOS) -2.0
              PTCOOL_OCCD(JLIST,3) = BDD%XDESC_TCOOL_OCCD(NPOS)
              !
           ELSE
              !
              ! Same design temperature in all compartments
              !
              PTCOOL_OCCD(JLIST,1) = BDD%XDESC_TCOOL_OCCD(NPOS_FORT_CRE)
              PTCOOL_OCCD(JLIST,2) = BDD%XDESC_TCOOL_OCCD(NPOS_FORT_CRE)
              PTCOOL_OCCD(JLIST,3) = BDD%XDESC_TCOOL_OCCD(NPOS_FORT_CRE)
              !
           ENDIF
           !
           PTCOOL_OCCD(JLIST,4) = 400.0
           PTCOOL_OCCD(JLIST,5) = BDD%XDESC_TCOOL_OCCD(NPOS_COM)
           PTCOOL_OCCD(JLIST,6) = BDD%XDESC_TCOOL_OCCD(NPOS_TER)
           !
        ENDIF
        !
     ENDIF
     !
     IF (PRESENT(PTCOOL_OCCN)) THEN
        !
        PTCOOL_OCCN(JLIST,1) = (1.0-0.5*(BDD%XDESC_FNOHEAT(NPOS_FORT_CRE)+BDD%XDESC_FNOHEAT(NPOS_FAIB_CRE)))* &
             BDD%XDESC_TCOOL_OCCN(NPOS) + &
             0.5 * (BDD%XDESC_FNOHEAT(NPOS_FORT_CRE)+BDD%XDESC_FNOHEAT(NPOS_FAIB_CRE)) * &
             (BDD%XDESC_TCOOL_OCCN(NPOS) + 10.0)
        !
        IF (SIZE(PTCOOL_OCCN,2).GT.1) THEN
           !
           IF ((DTT%NPAR_USETYPE(JLIST).EQ.4).OR.(DTT%NPAR_USETYPE(JLIST).EQ.5)) THEN
              !
              ! Residential buildings (no modulation at the moment)
              !
              PTCOOL_OCCN(JLIST,1) = BDD%XDESC_TCOOL_OCCN(NPOS)
              PTCOOL_OCCN(JLIST,2) = BDD%XDESC_TCOOL_OCCN(NPOS)
              PTCOOL_OCCN(JLIST,3) = BDD%XDESC_TCOOL_OCCN(NPOS)
              !
           ELSE IF ((DTT%NPAR_USETYPE(JLIST).EQ.03).OR.(DTT%NPAR_USETYPE(JLIST).EQ.09) .OR. &
                (DTT%NPAR_USETYPE(JLIST).EQ.10).OR.(DTT%NPAR_USETYPE(JLIST).EQ.13)) THEN
              !
              ! Tertairy, commercial, health and educational buildings
              ! Only part of building is cooled
              !
              PTCOOL_OCCN(JLIST,1) = 400.0
              PTCOOL_OCCN(JLIST,2) = BDD%XDESC_TCOOL_OCCN(NPOS) -2.0
              PTCOOL_OCCN(JLIST,3) = BDD%XDESC_TCOOL_OCCN(NPOS)
              !
           ELSE
              !
              ! Same design temperature in all compartments
              !
              PTCOOL_OCCN(JLIST,1) = BDD%XDESC_TCOOL_OCCN(NPOS_FORT_CRE)
              PTCOOL_OCCN(JLIST,2) = BDD%XDESC_TCOOL_OCCN(NPOS_FORT_CRE)
              PTCOOL_OCCN(JLIST,3) = BDD%XDESC_TCOOL_OCCN(NPOS_FORT_CRE)
              !
           ENDIF
           !
           PTCOOL_OCCN(JLIST,4) = 400.0
           PTCOOL_OCCN(JLIST,5) = BDD%XDESC_TCOOL_OCCN(NPOS_COM)
           PTCOOL_OCCN(JLIST,6) = BDD%XDESC_TCOOL_OCCN(NPOS_TER)
           !
        ENDIF
        !
     ENDIF
     !
     IF (PRESENT(PTCOOL_VCDD)) THEN
        !
        PTCOOL_VCDD(JLIST,1) = (1.0-0.5*(BDD%XDESC_FNOHEAT(NPOS_FORT_CRE)+BDD%XDESC_FNOHEAT(NPOS_FAIB_CRE)))* &
             BDD%XDESC_TCOOL_VCDD(NPOS) + &
             0.5 * (BDD%XDESC_FNOHEAT(NPOS_FORT_CRE)+BDD%XDESC_FNOHEAT(NPOS_FAIB_CRE)) * &
             (BDD%XDESC_TCOOL_VCDD(NPOS) + 10.0)
        !
        IF (SIZE(PTCOOL_VCDD,2).GT.1) THEN
           !
           IF ((DTT%NPAR_USETYPE(JLIST).EQ.4).OR.(DTT%NPAR_USETYPE(JLIST).EQ.5)) THEN
              !
              ! Residential buildings (no modulation at the moment)
              !
              PTCOOL_VCDD(JLIST,1) = BDD%XDESC_TCOOL_VCDD(NPOS)
              PTCOOL_VCDD(JLIST,2) = BDD%XDESC_TCOOL_VCDD(NPOS)
              PTCOOL_VCDD(JLIST,3) = BDD%XDESC_TCOOL_VCDD(NPOS)
              !
           ELSE IF ((DTT%NPAR_USETYPE(JLIST).EQ.03).OR.(DTT%NPAR_USETYPE(JLIST).EQ.09) .OR. &
                (DTT%NPAR_USETYPE(JLIST).EQ.10).OR.(DTT%NPAR_USETYPE(JLIST).EQ.13)) THEN
              !
              ! Tertairy, commercial, health and educational buildings
              ! Only part of building is cooled
              !
              PTCOOL_VCDD(JLIST,1) = 400.0
              PTCOOL_VCDD(JLIST,2) = BDD%XDESC_TCOOL_VCDD(NPOS) -2.0
              PTCOOL_VCDD(JLIST,3) = BDD%XDESC_TCOOL_VCDD(NPOS)
              !
           ELSE
              !
              ! Same design temperature in all compartments
              !
              PTCOOL_VCDD(JLIST,1) = BDD%XDESC_TCOOL_VCDD(NPOS_FORT_CRE)
              PTCOOL_VCDD(JLIST,2) = BDD%XDESC_TCOOL_VCDD(NPOS_FORT_CRE)
              PTCOOL_VCDD(JLIST,3) = BDD%XDESC_TCOOL_VCDD(NPOS_FORT_CRE)
              !
           ENDIF
           !
           PTCOOL_VCDD(JLIST,4) = 400.0
           PTCOOL_VCDD(JLIST,5) = BDD%XDESC_TCOOL_VCDD(NPOS_COM)
           PTCOOL_VCDD(JLIST,6) = BDD%XDESC_TCOOL_VCDD(NPOS_TER)
           !
        ENDIF
        !
     ENDIF
     !
     IF (PRESENT(PTCOOL_VCDN)) THEN
        !
        PTCOOL_VCDN(JLIST,1) = (1.0-0.5*(BDD%XDESC_FNOHEAT(NPOS_FORT_CRE)+BDD%XDESC_FNOHEAT(NPOS_FAIB_CRE)))* &
             BDD%XDESC_TCOOL_VCDN(NPOS) + &
             0.5 * (BDD%XDESC_FNOHEAT(NPOS_FORT_CRE)+BDD%XDESC_FNOHEAT(NPOS_FAIB_CRE)) * &
             (BDD%XDESC_TCOOL_VCDN(NPOS) + 10.0)
        !
        IF (SIZE(PTCOOL_VCDN,2).GT.1) THEN
           !
           IF ((DTT%NPAR_USETYPE(JLIST).EQ.4).OR.(DTT%NPAR_USETYPE(JLIST).EQ.5)) THEN
              !
              ! Residential buildings (no modulation at the moment)
              !
              PTCOOL_VCDN(JLIST,1) = BDD%XDESC_TCOOL_VCDN(NPOS)
              PTCOOL_VCDN(JLIST,2) = BDD%XDESC_TCOOL_VCDN(NPOS)
              PTCOOL_VCDN(JLIST,3) = BDD%XDESC_TCOOL_VCDN(NPOS)
              !
           ELSE IF ((DTT%NPAR_USETYPE(JLIST).EQ.03).OR.(DTT%NPAR_USETYPE(JLIST).EQ.09) .OR. &
                (DTT%NPAR_USETYPE(JLIST).EQ.10).OR.(DTT%NPAR_USETYPE(JLIST).EQ.13)) THEN
              !
              ! Tertairy, commercial, health and educational buildings
              ! Only part of building is cooled
              !
              PTCOOL_VCDN(JLIST,1) = 400.0
              PTCOOL_VCDN(JLIST,2) = BDD%XDESC_TCOOL_VCDN(NPOS) -2.0
              PTCOOL_VCDN(JLIST,3) = BDD%XDESC_TCOOL_VCDN(NPOS)
              !
           ELSE
              !
              ! Same design temperature in all compartments
              !
              PTCOOL_VCDN(JLIST,1) = BDD%XDESC_TCOOL_VCDN(NPOS_FORT_CRE)
              PTCOOL_VCDN(JLIST,2) = BDD%XDESC_TCOOL_VCDN(NPOS_FORT_CRE)
              PTCOOL_VCDN(JLIST,3) = BDD%XDESC_TCOOL_VCDN(NPOS_FORT_CRE)
              !
           ENDIF
           !
           PTCOOL_VCDN(JLIST,4) = 400.0
           PTCOOL_VCDN(JLIST,5) = BDD%XDESC_TCOOL_VCDN(NPOS_COM)
           PTCOOL_VCDN(JLIST,6) = BDD%XDESC_TCOOL_VCDN(NPOS_TER)
           !
        ENDIF
        !
     ENDIF
     !
     IF (PRESENT(PTCOOL_VCLD)) THEN
        !
        PTCOOL_VCLD(JLIST,1) = (1.0-0.5*(BDD%XDESC_FNOHEAT(NPOS_FORT_CRE)+BDD%XDESC_FNOHEAT(NPOS_FAIB_CRE)))* &
             BDD%XDESC_TCOOL_VCLD(NPOS) + &
             0.5 * (BDD%XDESC_FNOHEAT(NPOS_FORT_CRE)+BDD%XDESC_FNOHEAT(NPOS_FAIB_CRE)) * &
             (BDD%XDESC_TCOOL_VCLD(NPOS) + 10.0)
        !
        IF (SIZE(PTCOOL_VCLD,2).GT.1) THEN
           !
           IF ((DTT%NPAR_USETYPE(JLIST).EQ.4).OR.(DTT%NPAR_USETYPE(JLIST).EQ.5)) THEN
              !
              ! Residential buildings (no modulation at the moment)
              !
              PTCOOL_VCLD(JLIST,1) = BDD%XDESC_TCOOL_VCLD(NPOS)
              PTCOOL_VCLD(JLIST,2) = BDD%XDESC_TCOOL_VCLD(NPOS)
              PTCOOL_VCLD(JLIST,3) = BDD%XDESC_TCOOL_VCLD(NPOS)
              !
           ELSE IF ((DTT%NPAR_USETYPE(JLIST).EQ.03).OR.(DTT%NPAR_USETYPE(JLIST).EQ.09) .OR. &
                (DTT%NPAR_USETYPE(JLIST).EQ.10).OR.(DTT%NPAR_USETYPE(JLIST).EQ.13)) THEN
              !
              ! Tertairy, commercial, health and educational buildings
              ! Only part of building is cooled
              !
              PTCOOL_VCLD(JLIST,1) = 400.0
              PTCOOL_VCLD(JLIST,2) = BDD%XDESC_TCOOL_VCLD(NPOS) -2.0
              PTCOOL_VCLD(JLIST,3) = BDD%XDESC_TCOOL_VCLD(NPOS)
              !
           ELSE
              !
              ! Same design temperature in all compartments
              !
              PTCOOL_VCLD(JLIST,1) = BDD%XDESC_TCOOL_VCLD(NPOS_FORT_CRE)
              PTCOOL_VCLD(JLIST,2) = BDD%XDESC_TCOOL_VCLD(NPOS_FORT_CRE)
              PTCOOL_VCLD(JLIST,3) = BDD%XDESC_TCOOL_VCLD(NPOS_FORT_CRE)
              !
           ENDIF
           !
           PTCOOL_VCLD(JLIST,4) = 400.0
           PTCOOL_VCLD(JLIST,5) = BDD%XDESC_TCOOL_VCLD(NPOS_COM)
           PTCOOL_VCLD(JLIST,6) = BDD%XDESC_TCOOL_VCLD(NPOS_TER)
           !
        ENDIF
        !
     ENDIF
     !
     IF (PRESENT(PF_WATER_COND)) THEN
        PF_WATER_COND(JLIST)=BDD%XDESC_F_WATER_COND(NPOS)
     ENDIF
     !
     IF (PRESENT(PF_WASTE_CAN)) THEN
        PF_WASTE_CAN(JLIST) = BDD%XDESC_F_WASTE_CAN(NPOS)
     ENDIF
     !
     IF (PRESENT(PCOP_RAT)) THEN
        PCOP_RAT(JLIST)=BDD%XDESC_COP_RAT(NPOS)
     ENDIF
     !
     IF (PRESENT(PHR_TARGET)) THEN
        PHR_TARGET(JLIST)=BDD%XDESC_HR_TARGET(NPOS)
     ENDIF
     !
  ENDDO
  !
  ! Initialisation of internal heat release-related variables
  ! At the moment the same internal heat release is distributed
  ! over all the heating design temperature differenciated compartments
  !
  DO JLIST=1,SIZE(DTT%NPAR_USETYPE)
     !
     ! The values of the non-heated fraction are 
     ! required for the 1-compartment case
     !
     CALL GETPOS(BDD%NDESC_HEATUSEV,DTT%NPAR_USETYPE(JLIST),"HEAT","FORT",NPOS_FORT_CRE)
     CALL GETPOS(BDD%NDESC_HEATUSEV,DTT%NPAR_USETYPE(JLIST),"HEAT","FAIB",NPOS_FAIB_CRE)
     !
     CALL GETPOS(BDD%NDESC_QINUSEV,DTT%NPAR_USETYPE(JLIST),"CQIN","FORT",NPOS_FORT_EQI)
     CALL GETPOS(BDD%NDESC_QINUSEV,DTT%NPAR_USETYPE(JLIST),"CQIN","MOYE",NPOS_MOYE_EQI)
     CALL GETPOS(BDD%NDESC_QINUSEV,DTT%NPAR_USETYPE(JLIST),"CQIN","FAIB",NPOS_FAIB_EQI)
     CALL GETPOS(BDD%NDESC_QINUSEV,03,"CQIN","DUMM",NPOS_COM)
     CALL GETPOS(BDD%NDESC_QINUSEV,13,"CQIN","DUMM",NPOS_TER)
     !
     IF (PRESENT(PQIN)) THEN
        !
        PQIN(JLIST,1) = (1.0-0.5*(BDD%XDESC_FNOHEAT(NPOS_FORT_CRE)+BDD%XDESC_FNOHEAT(NPOS_FAIB_CRE)))* &
             BDD%XDESC_QIN(NPOS_MOYE_EQI) + &
             0.5 * (BDD%XDESC_FNOHEAT(NPOS_FORT_CRE)+BDD%XDESC_FNOHEAT(NPOS_FAIB_CRE)) * 0.0
        !
        IF (SIZE(PQIN,2).GT.1) THEN
           !
           IF (DTT%NPAR_USETYPE(JLIST).EQ.4) THEN
              !
              PQIN(JLIST,1) = DTT%XPAR_FOEQI_APPT(JLIST) * BDD%XDESC_QIN(NPOS_FORT_EQI) + &
                   DTT%XPAR_FAEQI_APPT(JLIST) * BDD%XDESC_QIN(NPOS_FAIB_EQI) + &
                   (1.0-DTT%XPAR_FOEQI_APPT(JLIST) - DTT%XPAR_FAEQI_APPT(JLIST))  * &
                   BDD%XDESC_QIN(NPOS_MOYE_EQI)
              !
              PQIN(JLIST,2) = PQIN(JLIST,1)
              PQIN(JLIST,3) = PQIN(JLIST,1)
              PQIN(JLIST,4) = 0.0
              PQIN(JLIST,5) = BDD%XDESC_QIN(NPOS_COM)
              PQIN(JLIST,6) = BDD%XDESC_QIN(NPOS_TER)
              !
           ELSE IF (DTT%NPAR_USETYPE(JLIST).EQ.5) THEN
              !
              PQIN(JLIST,1) = DTT%XPAR_FOEQI_MAIS(JLIST) * BDD%XDESC_QIN(NPOS_FORT_EQI) + &
                   DTT%XPAR_FAEQI_MAIS(JLIST) * BDD%XDESC_QIN(NPOS_FAIB_EQI) + &
                   (1.0-DTT%XPAR_FOEQI_MAIS(JLIST) - DTT%XPAR_FAEQI_MAIS(JLIST))  * &
                   BDD%XDESC_QIN(NPOS_MOYE_EQI)
              !
              PQIN(JLIST,2) = PQIN(JLIST,1)
              PQIN(JLIST,3) = PQIN(JLIST,1)
              PQIN(JLIST,4) = 0.0
              PQIN(JLIST,5) = BDD%XDESC_QIN(NPOS_COM)
              PQIN(JLIST,6) = BDD%XDESC_QIN(NPOS_TER)
              !
           ELSE
              !
              PQIN(JLIST,1) = BDD%XDESC_QIN(NPOS_MOYE_EQI)
              PQIN(JLIST,2) = PQIN(JLIST,1)
              PQIN(JLIST,3) = PQIN(JLIST,1)
              PQIN(JLIST,4) = 0.0
              PQIN(JLIST,5) = BDD%XDESC_QIN(NPOS_COM)
              PQIN(JLIST,6) = BDD%XDESC_QIN(NPOS_TER)
              !
           ENDIF
           !
        ENDIF
     ENDIF
     !
     IF (PRESENT(PQIN_FRAD)) THEN
        PQIN_FRAD(JLIST)=BDD%XDESC_QIN_FRAD(NPOS_MOYE_EQI)
     ENDIF
     !
     IF (PRESENT(PQIN_FLAT)) THEN
        PQIN_FLAT(JLIST)=BDD%XDESC_QIN_FLAT(NPOS_MOYE_EQI)
     ENDIF
     !
     IF (PRESENT(PMODQIN_VCD)) THEN
        PMODQIN_VCD(JLIST,1) = BDD%XDESC_MODQIN_VCD(NPOS_MOYE_EQI)
        IF (SIZE(PMODQIN_VCD,2).GT.1) THEN
           PMODQIN_VCD(JLIST,1) = BDD%XDESC_MODQIN_VCD(NPOS_MOYE_EQI)
           PMODQIN_VCD(JLIST,2) = BDD%XDESC_MODQIN_VCD(NPOS_MOYE_EQI)
           PMODQIN_VCD(JLIST,3) = BDD%XDESC_MODQIN_VCD(NPOS_MOYE_EQI)
           PMODQIN_VCD(JLIST,4) = 1.0
           PMODQIN_VCD(JLIST,5) = BDD%XDESC_MODQIN_VCD(NPOS_COM)
           PMODQIN_VCD(JLIST,6) = BDD%XDESC_MODQIN_VCD(NPOS_TER)
        ENDIF
     ENDIF
     !
     IF (PRESENT(PMODQIN_VLD)) THEN
        PMODQIN_VLD(JLIST,1) = BDD%XDESC_MODQIN_VLD(NPOS_MOYE_EQI)
        IF (SIZE(PMODQIN_VLD,2).GT.1) THEN
           PMODQIN_VLD(JLIST,1) = BDD%XDESC_MODQIN_VLD(NPOS_MOYE_EQI)
           PMODQIN_VLD(JLIST,2) = BDD%XDESC_MODQIN_VLD(NPOS_MOYE_EQI)
           PMODQIN_VLD(JLIST,3) = BDD%XDESC_MODQIN_VLD(NPOS_MOYE_EQI)
           PMODQIN_VLD(JLIST,4) = 1.0
           PMODQIN_VLD(JLIST,5) = BDD%XDESC_MODQIN_VLD(NPOS_COM)
           PMODQIN_VLD(JLIST,6) = BDD%XDESC_MODQIN_VLD(NPOS_TER)
        ENDIF
     ENDIF
     !
     IF (PRESENT(PMODQIN_NIG)) THEN
        PMODQIN_NIG(JLIST,1) = BDD%XDESC_MODQIN_NIG(NPOS_MOYE_EQI)
        IF (SIZE(PMODQIN_NIG,2).GT.1) THEN
           PMODQIN_NIG(JLIST,1) = BDD%XDESC_MODQIN_NIG(NPOS_MOYE_EQI)
           PMODQIN_NIG(JLIST,2) = BDD%XDESC_MODQIN_NIG(NPOS_MOYE_EQI)
           PMODQIN_NIG(JLIST,3) = BDD%XDESC_MODQIN_NIG(NPOS_MOYE_EQI)
           PMODQIN_NIG(JLIST,4) = 1.0
           PMODQIN_NIG(JLIST,5) = BDD%XDESC_MODQIN_NIG(NPOS_COM)
           PMODQIN_NIG(JLIST,6) = BDD%XDESC_MODQIN_NIG(NPOS_TER)
        ENDIF
     ENDIF
     !
  ENDDO
  !
  ! Initialisation of shading and ventilation-related variables
  ! 
  DO JLIST=1,SIZE(DTT%NPAR_USETYPE)
     !
     CALL GETPOS(BDD%NDESC_VENTUSEV,DTT%NPAR_USETYPE(JLIST),"VENT","DUMM",NPOS)
     CALL GETPOS(BDD%NDESC_VENTUSEV,03,"VENT","DUMM",NPOS_COM)
     CALL GETPOS(BDD%NDESC_VENTUSEV,13,"VENT","DUMM",NPOS_TER)
     !
     IF (PRESENT(PNATVENT)) THEN
        PNATVENT(JLIST,1) = BDD%XDESC_NATVENT(NPOS)
        IF (SIZE(PNATVENT,2).GT.1) THEN
           PNATVENT(JLIST,1) = BDD%XDESC_NATVENT(NPOS)
           PNATVENT(JLIST,2) = BDD%XDESC_NATVENT(NPOS)
           PNATVENT(JLIST,3) = BDD%XDESC_NATVENT(NPOS)
           PNATVENT(JLIST,4) = 0.0
           PNATVENT(JLIST,5) = BDD%XDESC_NATVENT(NPOS_COM)
           PNATVENT(JLIST,6) = BDD%XDESC_NATVENT(NPOS_TER)
        ENDIF
     ENDIF
     !
     IF (PRESENT(PFVSUM)) THEN
        PFVSUM(JLIST,1) = BDD%XDESC_FVSUM(NPOS)
        IF (SIZE(PFVSUM,2).GT.1) THEN
           PFVSUM(JLIST,1) = BDD%XDESC_FVSUM(NPOS)
           PFVSUM(JLIST,2) = BDD%XDESC_FVSUM(NPOS)
           PFVSUM(JLIST,3) = BDD%XDESC_FVSUM(NPOS)
           PFVSUM(JLIST,4) = 0.0
           PFVSUM(JLIST,5) = BDD%XDESC_FVSUM(NPOS_COM)
           PFVSUM(JLIST,6) = BDD%XDESC_FVSUM(NPOS_TER)
        ENDIF
     ENDIF
     !
     IF (PRESENT(PFVNIG)) THEN
        PFVNIG(JLIST,1) = BDD%XDESC_FVNIG(NPOS)
        IF (SIZE(PFVNIG,2).GT.1) THEN
           PFVNIG(JLIST,1) = BDD%XDESC_FVNIG(NPOS)
           PFVNIG(JLIST,2) = BDD%XDESC_FVNIG(NPOS)
           PFVNIG(JLIST,3) = BDD%XDESC_FVNIG(NPOS)
           PFVNIG(JLIST,4) = 0.0
           PFVNIG(JLIST,5) = BDD%XDESC_FVNIG(NPOS_COM)
           PFVNIG(JLIST,6) = BDD%XDESC_FVNIG(NPOS_TER)
        ENDIF
     ENDIF
     !
     IF (PRESENT(PFVSHO)) THEN
        PFVSHO(JLIST,1) = BDD%XDESC_FVSHO(NPOS)
        IF (SIZE(PFVSHO,2).GT.1) THEN
           PFVSHO(JLIST,1) = BDD%XDESC_FVSHO(NPOS)
           PFVSHO(JLIST,2) = BDD%XDESC_FVSHO(NPOS)
           PFVSHO(JLIST,3) = BDD%XDESC_FVSHO(NPOS)
           PFVSHO(JLIST,4) = 0.0
           PFVSHO(JLIST,5) = BDD%XDESC_FVSHO(NPOS_COM)
           PFVSHO(JLIST,6) = BDD%XDESC_FVSHO(NPOS_TER)
        ENDIF
     ENDIF
     !
     IF (PRESENT(PTDESV)) THEN
        PTDESV(JLIST)=BDD%XDESC_TDESV(NPOS)
     ENDIF
     !
     IF (PRESENT(PFVVAC)) THEN
        PFVVAC(JLIST,1) = BDD%XDESC_FVVAC(NPOS)
        IF (SIZE(PFVVAC,2).GT.1) THEN
           PFVVAC(JLIST,1) = BDD%XDESC_FVVAC(NPOS)
           PFVVAC(JLIST,2) = BDD%XDESC_FVVAC(NPOS)
           PFVVAC(JLIST,3) = BDD%XDESC_FVVAC(NPOS)
           PFVVAC(JLIST,4) = 0.0
           PFVVAC(JLIST,5) = BDD%XDESC_FVVAC(NPOS_COM)
           PFVVAC(JLIST,6) = BDD%XDESC_FVVAC(NPOS_TER)
        ENDIF
     ENDIF
     !
     IF (PRESENT(PFOPEN)) THEN
        PFOPEN(JLIST)=BDD%XDESC_FOPEN(NPOS)
     ENDIF
     !
     IF (PRESENT(PFSSUM)) THEN
        PFSSUM(JLIST,1) = BDD%XDESC_FSSUM(NPOS)
        IF (SIZE(PFSSUM,2).GT.1) THEN
           PFSSUM(JLIST,1) = BDD%XDESC_FSSUM(NPOS)
           PFSSUM(JLIST,2) = BDD%XDESC_FSSUM(NPOS)
           PFSSUM(JLIST,3) = BDD%XDESC_FSSUM(NPOS)
           PFSSUM(JLIST,4) = 0.0
           PFSSUM(JLIST,5) = BDD%XDESC_FSSUM(NPOS_COM)
           PFSSUM(JLIST,6) = BDD%XDESC_FSSUM(NPOS_TER)
        ENDIF
     ENDIF
     !
     IF (PRESENT(PFSNIG)) THEN
        PFSNIG(JLIST,1) = BDD%XDESC_FSNIG(NPOS)
        IF (SIZE(PFSNIG,2).GT.1) THEN
           PFSNIG(JLIST,1) = BDD%XDESC_FSNIG(NPOS)
           PFSNIG(JLIST,2) = BDD%XDESC_FSNIG(NPOS)
           PFSNIG(JLIST,3) = BDD%XDESC_FSNIG(NPOS)
           PFSNIG(JLIST,4) = 0.0
           PFSNIG(JLIST,5) = BDD%XDESC_FSNIG(NPOS_COM)
           PFSNIG(JLIST,6) = BDD%XDESC_FSNIG(NPOS_TER)
        ENDIF
     ENDIF
     !
     IF (PRESENT(PFSVAC)) THEN
        PFSVAC(JLIST,1) = BDD%XDESC_FSVAC(NPOS)
        IF (SIZE(PFSVAC,2).GT.1) THEN
           PFSVAC(JLIST,1) = BDD%XDESC_FSVAC(NPOS)
           PFSVAC(JLIST,2) = BDD%XDESC_FSVAC(NPOS)
           PFSVAC(JLIST,3) = BDD%XDESC_FSVAC(NPOS)
           PFSVAC(JLIST,4) = 0.0
           PFSVAC(JLIST,5) = BDD%XDESC_FSVAC(NPOS_COM)
           PFSVAC(JLIST,6) = BDD%XDESC_FSVAC(NPOS_TER)
        ENDIF
     ENDIF
     !
     IF (PRESENT(PWIN_SW_MAX)) THEN
        PWIN_SW_MAX(JLIST)=BDD%XDESC_WIN_SW_MAX(NPOS)
     ENDIF
     !
  ENDDO
  !
  ! Initialisation of building occupation-related variables
  !
  DO JLIST=1,SIZE(DTT%NPAR_USETYPE)
     !
     IF (PRESENT(PPROBOCC)) THEN
        !
        CALL GETPOS(BDD%NDESC_OCCUSEV,DTT%NPAR_USETYPE(JLIST),"POCC","DUMM",NPOS)
        CALL GETPOS(BDD%NDESC_OCCUSEV,03,"POCC","DUMM",NPOS_COM)
        CALL GETPOS(BDD%NDESC_OCCUSEV,13,"POCC","DUMM",NPOS_TER)
        !
        PPROBOCC(JLIST,:,1) = BDD%XDESC_PROBOCC(NPOS,:)
        IF (SIZE(PPROBOCC,3).GT.1) THEN
           PPROBOCC(JLIST,:,1) = BDD%XDESC_PROBOCC(NPOS,:)
           PPROBOCC(JLIST,:,2) = BDD%XDESC_PROBOCC(NPOS,:)
           PPROBOCC(JLIST,:,3) = BDD%XDESC_PROBOCC(NPOS,:)
           PPROBOCC(JLIST,:,4) = 0.0
           PPROBOCC(JLIST,:,5) = BDD%XDESC_PROBOCC(NPOS_COM,:)
           PPROBOCC(JLIST,:,6) = BDD%XDESC_PROBOCC(NPOS_TER,:)
        ENDIF
        !
        IF (MAXVAL(PPROBOCC(JLIST,:,:)).GT.1.0) STOP("Wrong building occuppation probability")
        IF (MINVAL(PPROBOCC(JLIST,:,:)).LT.0.0) STOP("Wrong building occuppation probability")
        !
     ENDIF
     !
     ! Initialisation of schedules
     !
     IF (PRESENT(PDAYWBEG_SCHED)) THEN
        !
        CALL GETPOS(BDD%NDESC_SCEUSEV,DTT%NPAR_USETYPE(JLIST),"SCHE","DUMM",NPOS)
        CALL GETPOS(BDD%NDESC_SCEUSEV,03,"SCHE","DUMM",NPOS_COM)
        CALL GETPOS(BDD%NDESC_SCEUSEV,13,"SCHE","DUMM",NPOS_TER)
        !
        PDAYWBEG_SCHED(JLIST,:,1) = BDD%XDESC_DAYWBEG_SCHED(NPOS,:)
        IF (SIZE(PDAYWBEG_SCHED,3).GT.1) THEN
           PDAYWBEG_SCHED(JLIST,:,1) = BDD%XDESC_DAYWBEG_SCHED(NPOS,:)
           PDAYWBEG_SCHED(JLIST,:,2) = BDD%XDESC_DAYWBEG_SCHED(NPOS,:)
           PDAYWBEG_SCHED(JLIST,:,3) = BDD%XDESC_DAYWBEG_SCHED(NPOS,:)
           PDAYWBEG_SCHED(JLIST,:,4) = BDD%XDESC_DAYWBEG_SCHED(NPOS,:)
           PDAYWBEG_SCHED(JLIST,:,5) = BDD%XDESC_DAYWBEG_SCHED(NPOS_COM,:)
           PDAYWBEG_SCHED(JLIST,:,6) = BDD%XDESC_DAYWBEG_SCHED(NPOS_TER,:)
        ENDIF
        !
     ENDIF
     !
     IF (PRESENT(PHOURBEG_SCHED)) THEN
        !
        CALL GETPOS(BDD%NDESC_SCEUSEV,DTT%NPAR_USETYPE(JLIST),"SCHE","DUMM",NPOS)
        CALL GETPOS(BDD%NDESC_SCEUSEV,03,"SCHE","DUMM",NPOS_COM)
        CALL GETPOS(BDD%NDESC_SCEUSEV,13,"SCHE","DUMM",NPOS_TER)
        !
        PHOURBEG_SCHED(JLIST,:,1) = BDD%XDESC_HOURBEG_SCHED(NPOS,:)
        IF (SIZE(PHOURBEG_SCHED,3).GT.1) THEN
           PHOURBEG_SCHED(JLIST,:,1) = BDD%XDESC_HOURBEG_SCHED(NPOS,:)
           PHOURBEG_SCHED(JLIST,:,2) = BDD%XDESC_HOURBEG_SCHED(NPOS,:)
           PHOURBEG_SCHED(JLIST,:,3) = BDD%XDESC_HOURBEG_SCHED(NPOS,:)
           PHOURBEG_SCHED(JLIST,:,4) = BDD%XDESC_HOURBEG_SCHED(NPOS,:)
           PHOURBEG_SCHED(JLIST,:,5) = BDD%XDESC_HOURBEG_SCHED(NPOS_COM,:)
           PHOURBEG_SCHED(JLIST,:,6) = BDD%XDESC_HOURBEG_SCHED(NPOS_TER,:)
        ENDIF
        !
     ENDIF
     !
     ! Initialisation of holidays
     !
     IF (PRESENT(PBEG_HOLIDAY)) THEN
        !
        CALL GETPOS(BDD%NDESC_HOLUSEV,DTT%NPAR_USETYPE(JLIST),"HOLI","DUMM",NPOS)
        CALL GETPOS(BDD%NDESC_HOLUSEV,03,"HOLI","DUMM",NPOS_COM)
        CALL GETPOS(BDD%NDESC_HOLUSEV,13,"HOLI","DUMM",NPOS_TER)
        !
        PBEG_HOLIDAY(JLIST,:,1) = BDD%XDESC_BEG_HOLIDAY(NPOS,:)
        IF (SIZE(PBEG_HOLIDAY,3).GT.1) THEN
           PBEG_HOLIDAY(JLIST,:,1) = BDD%XDESC_BEG_HOLIDAY(NPOS,:)
           PBEG_HOLIDAY(JLIST,:,2) = BDD%XDESC_BEG_HOLIDAY(NPOS,:)
           PBEG_HOLIDAY(JLIST,:,3) = BDD%XDESC_BEG_HOLIDAY(NPOS,:)
           PBEG_HOLIDAY(JLIST,:,4) = BDD%XDESC_BEG_HOLIDAY(NPOS,:)
           PBEG_HOLIDAY(JLIST,:,5) = BDD%XDESC_BEG_HOLIDAY(NPOS_COM,:)
           PBEG_HOLIDAY(JLIST,:,6) = BDD%XDESC_BEG_HOLIDAY(NPOS_TER,:)
        ENDIF
        !
     ENDIF
     !
     IF (PRESENT(PEND_HOLIDAY)) THEN
        !
        CALL GETPOS(BDD%NDESC_HOLUSEV,DTT%NPAR_USETYPE(JLIST),"HOLI","DUMM",NPOS)
        CALL GETPOS(BDD%NDESC_HOLUSEV,03,"HOLI","DUMM",NPOS_COM)
        CALL GETPOS(BDD%NDESC_HOLUSEV,13,"HOLI","DUMM",NPOS_TER)
        !
        PEND_HOLIDAY(JLIST,:,1) = BDD%XDESC_END_HOLIDAY(NPOS,:)
        IF (SIZE(PEND_HOLIDAY,3).GT.1) THEN
           PEND_HOLIDAY(JLIST,:,1) = BDD%XDESC_END_HOLIDAY(NPOS,:)
           PEND_HOLIDAY(JLIST,:,2) = BDD%XDESC_END_HOLIDAY(NPOS,:)
           PEND_HOLIDAY(JLIST,:,3) = BDD%XDESC_END_HOLIDAY(NPOS,:)
           PEND_HOLIDAY(JLIST,:,4) = BDD%XDESC_END_HOLIDAY(NPOS,:)
           PEND_HOLIDAY(JLIST,:,5) = BDD%XDESC_END_HOLIDAY(NPOS_COM,:)
           PEND_HOLIDAY(JLIST,:,6) = BDD%XDESC_END_HOLIDAY(NPOS_TER,:)
        ENDIF
        !
     ENDIF
     !
     IF (PRESENT(PMOD_HOLIDAY)) THEN
        !
        CALL GETPOS(BDD%NDESC_HOLUSEV,DTT%NPAR_USETYPE(JLIST),"HOLI","DUMM",NPOS)
        CALL GETPOS(BDD%NDESC_HOLUSEV,03,"HOLI","DUMM",NPOS_COM)
        CALL GETPOS(BDD%NDESC_HOLUSEV,13,"HOLI","DUMM",NPOS_TER)
        !
        PMOD_HOLIDAY(JLIST,1) = BDD%XDESC_MOD_HOLIDAY(NPOS)
        IF (SIZE(PMOD_HOLIDAY,2).GT.1) THEN
           PMOD_HOLIDAY(JLIST,1) = BDD%XDESC_MOD_HOLIDAY(NPOS)
           PMOD_HOLIDAY(JLIST,2) = BDD%XDESC_MOD_HOLIDAY(NPOS)
           PMOD_HOLIDAY(JLIST,3) = BDD%XDESC_MOD_HOLIDAY(NPOS)
           PMOD_HOLIDAY(JLIST,4) = BDD%XDESC_MOD_HOLIDAY(NPOS)
           PMOD_HOLIDAY(JLIST,5) = BDD%XDESC_MOD_HOLIDAY(NPOS_COM)
           PMOD_HOLIDAY(JLIST,6) = BDD%XDESC_MOD_HOLIDAY(NPOS_TER)
        ENDIF
        !
     ENDIF
     !
  ENDDO
  !
  IF (LHOOK) CALL DR_HOOK('INI_DATA_PARAM_TEB',1,ZHOOK_HANDLE)
  !-------------------------------------------------------------------------------
  !
CONTAINS 
  !
  SUBROUTINE GETPOS(NUSEVEC,NUSE,CVAR,CIND,NPOS)
    !
    ! Attribute position in building use vector
    ! with exceptions depending on variable
    !
    IMPLICIT NONE
    !
    INTEGER, DIMENSION(:), INTENT(IN) :: NUSEVEC
    INTEGER, INTENT(IN)  :: NUSE
    CHARACTER(LEN=4), INTENT(IN)  :: CVAR
    CHARACTER(LEN=4), INTENT(IN)  :: CIND
    !
    INTEGER, INTENT(OUT) :: NPOS
    !
    INTEGER :: JJ
    INTEGER :: NCOUNT
    INTEGER, DIMENSION(:) :: NPOSMATCH(SIZE(NUSEVEC))
    !
    NPOSMATCH(:)=99999
    !
    NCOUNT=0
    DO JJ=1,SIZE(NUSEVEC)
       IF (NUSEVEC(JJ).EQ.NUSE) THEN
          NCOUNT=NCOUNT+1
          NPOSMATCH(NCOUNT)=JJ
       ENDIF
    ENDDO
    IF (NCOUNT.EQ.0) STOP("Building use not found")
    !
    ! Extra rules depending on variable.
    ! To be removed when sociological input can be read
    !
    IF (CVAR.EQ."HEAT") THEN
       !
       ! The first entry is hardcoded to be FORT CRE,
       ! the second for "FAIBLE CRE"
       !
       IF ((NUSE.EQ.4).OR.(NUSE.EQ.5)) THEN
          !
          IF (CIND.EQ."FORT") THEN
             NPOS=NPOSMATCH(1)
          ELSE
             NPOS=NPOSMATCH(2)
          ENDIF
          !
       ELSE
          NPOS=NPOSMATCH(1)
       ENDIF
       !
    ELSE IF (CVAR.EQ."COOL") THEN
       !
       ! No climatisation for COLLECTIF and INDIVIDUEL
       !
       IF ((NUSE.EQ.4).OR.(NUSE.EQ.5)) THEN
          NPOS=NPOSMATCH(2)
       ELSE
          NPOS=NPOSMATCH(1)
       ENDIF
       !
    ELSE IF (CVAR.EQ."CQIN") THEN
       !
       IF ((NUSE.EQ.4).OR.(NUSE.EQ.5)) THEN
          !
          IF      (CIND.EQ."FORT") THEN
             NPOS=NPOSMATCH(1)
          ELSE IF (CIND.EQ."MOYE") THEN
             NPOS=NPOSMATCH(2)
          ELSE IF (CIND.EQ."FAIB") THEN
             NPOS=NPOSMATCH(3)
          ELSE
             STOP("Error in attribution of internal heat release")
          ENDIF
          !
       ELSE
          NPOS=NPOSMATCH(1)
       ENDIF
       !
    ELSE IF (CVAR.EQ."VENT") THEN
       !
       NPOS=NPOSMATCH(1)
       !
    ELSE IF (CVAR.EQ."SCHE") THEN
       !
       NPOS=NPOSMATCH(1)
       !
    ELSE IF (CVAR.EQ."HOLI") THEN
       !
       NPOS=NPOSMATCH(1)
       !
    ELSE IF (CVAR.EQ."POCC") THEN
       !
       ! Entry for PRINCIPALE-ACTIF
       !
       NPOS=NPOSMATCH(1)
       !
    ELSE
       STOP("No rule implemented for this case")
    ENDIF
    !
  END SUBROUTINE GETPOS
  !
END SUBROUTINE INI_DATA_PARAM_TEB
