!     #########
      SUBROUTINE DIAG_TEB_GARDEN_INIT_n (DGMTO, DGGD, TGD, TGDO, TGDP, TVG, &
                                         HPROGRAM,KLU,KSW)
!     #####################
!
!!****  *DIAG_TEB_GARDEN_INIT_n* - routine to initialize TEB-ISBA diagnostic variables
!!
!!    PURPOSE
!!    -------
!!
!!**  METHOD
!!    ------
!!
!!    EXTERNAL
!!    --------
!!
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!
!!    AUTHOR
!!    ------
!!      V. Masson   *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    02/2003 
!!      modified    11/2003 by P. LeMoigne: surface cumulated energy budget
!!      modified    10/2004 by P. LeMoigne: surface miscellaneous fields
!!      B. Decharme    2008    New diag for water budget and allow to reset
!               cumulatives variables at the beginning of a run
!-------------------------------------------------------------------------------
!
!*       0.    DECLARATIONS
!              ------------
!
!
USE MODD_DIAG_MISC_TEB_OPTION_n, ONLY : DIAG_MISC_TEB_OPTIONS_t
USE MODD_DIAG_TEB_GARDEN_n, ONLY : DIAG_TEB_GARDEN_t
USE MODD_TEB_GARDEN_n, ONLY : TEB_GARDEN_t
USE MODD_TEB_GARDEN_OPTION_n, ONLY : TEB_GARDEN_OPTIONS_t
USE MODD_TEB_GARDEN_PGD_n, ONLY : TEB_GARDEN_PGD_t
USE MODD_TEB_VEG_n, ONLY : TEB_VEG_OPTIONS_t
!
USE MODD_SURF_PAR,          ONLY : XUNDEF
USE MODD_TYPE_DATE_SURF
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*       0.1   Declarations of arguments
!              -------------------------
!
!
TYPE(DIAG_MISC_TEB_OPTIONS_t), INTENT(INOUT) :: DGMTO
TYPE(DIAG_TEB_GARDEN_t), INTENT(INOUT) :: DGGD
TYPE(TEB_GARDEN_t), INTENT(INOUT) :: TGD
TYPE(TEB_GARDEN_OPTIONS_t), INTENT(INOUT) :: TGDO
TYPE(TEB_GARDEN_PGD_t), INTENT(INOUT) :: TGDP
TYPE(TEB_VEG_OPTIONS_t), INTENT(INOUT) :: TVG
!
INTEGER, INTENT(IN)         :: KLU       ! size of arrays
INTEGER, INTENT(IN)         :: KSW       ! spectral bands
 CHARACTER(LEN=6), INTENT(IN):: HPROGRAM  ! program calling
!
!*       0.2   Declarations of local variables
!              -------------------------------
!
INTEGER           :: IRESP          ! IRESP  : return-code if a problem appears
 CHARACTER(LEN=12) :: YREC           ! Name of the article to be read
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!-------------------------------------------------------------------------------
!
IF (LHOOK) CALL DR_HOOK('DIAG_TEB_GARDEN_INIT_N',0,ZHOOK_HANDLE)
!
ALLOCATE(DGGD%XRI     (KLU)) 
!
DGGD%XRI         = XUNDEF
!
ALLOCATE(DGGD%XCD     (KLU)) 
ALLOCATE(DGGD%XCH     (KLU)) 
ALLOCATE(DGGD%XRN     (KLU)) 
ALLOCATE(DGGD%XH      (KLU)) 
ALLOCATE(DGGD%XGFLUX  (KLU)) 
ALLOCATE(DGGD%XQS     (KLU)) 
!
DGGD%XCD         = XUNDEF
DGGD%XCH         = XUNDEF
DGGD%XRN         = XUNDEF
DGGD%XH          = XUNDEF
DGGD%XGFLUX      = XUNDEF
DGGD%XQS         = XUNDEF
!
ALLOCATE(DGGD%XLEI    (KLU)) 
ALLOCATE(DGGD%XLEG    (KLU)) 
ALLOCATE(DGGD%XLEGI   (KLU)) 
ALLOCATE(DGGD%XLEV    (KLU)) 
ALLOCATE(DGGD%XLES    (KLU)) 
ALLOCATE(DGGD%XLER    (KLU)) 
ALLOCATE(DGGD%XLETR   (KLU)) 
ALLOCATE(DGGD%XEVAP   (KLU)) 
!ALLOCATE(DGGD%XDRAIN  (KLU)) 
!ALLOCATE(DGGD%XRUNOFF (KLU)) 
ALLOCATE(DGGD%XHORT   (KLU)) 
ALLOCATE(DGGD%XDRIP   (KLU)) 
ALLOCATE(DGGD%XRRVEG  (KLU)) 
ALLOCATE(DGGD%XMELT   (KLU)) 
ALLOCATE(DGGD%XIRRIG_FLUX(KLU))
!
DGGD%XLEI        = XUNDEF
DGGD%XLEG        = XUNDEF
DGGD%XLEGI       = XUNDEF
DGGD%XLEV        = XUNDEF
DGGD%XLES        = XUNDEF
DGGD%XLER        = XUNDEF
DGGD%XLETR       = XUNDEF
DGGD%XEVAP       = XUNDEF
!DGGD%XDRAIN      = XUNDEF
!DGGD%XRUNOFF     = XUNDEF
DGGD%XHORT       = XUNDEF
DGGD%XDRIP       = XUNDEF
DGGD%XRRVEG      = XUNDEF
DGGD%XMELT       = XUNDEF
DGGD%XIRRIG_FLUX = XUNDEF
!
ALLOCATE(DGGD%XCG     (KLU)) 
ALLOCATE(DGGD%XC1     (KLU)) 
ALLOCATE(DGGD%XC2     (KLU)) 
ALLOCATE(DGGD%XWGEQ   (KLU)) 
ALLOCATE(DGGD%XCT     (KLU)) 
ALLOCATE(DGGD%XRS     (KLU)) 
ALLOCATE(DGGD%XCDN    (KLU)) 
ALLOCATE(DGGD%XHU     (KLU)) 
ALLOCATE(DGGD%XHUG    (KLU)) 
ALLOCATE(DGGD%XRESTORE(KLU)) 
ALLOCATE(DGGD%XUSTAR  (KLU)) 
IF (TVG%CPHOTO/='NON') THEN
  ALLOCATE(DGGD%XIACAN  (KLU,SIZE(TGDP%XABC)          ))
ELSE
  ALLOCATE(DGGD%XIACAN  (0,0))
END IF
!
DGGD%XCG         = XUNDEF
DGGD%XC1         = XUNDEF
DGGD%XC2         = XUNDEF
DGGD%XWGEQ       = XUNDEF
DGGD%XCT         = XUNDEF
DGGD%XRS         = XUNDEF
DGGD%XCDN        = XUNDEF
DGGD%XHU         = XUNDEF
DGGD%XHUG        = XUNDEF
DGGD%XRESTORE    = XUNDEF
DGGD%XUSTAR      = XUNDEF
IF (TVG%CPHOTO/='NON') THEN
  DGGD%XIACAN    = XUNDEF
END IF
!
ALLOCATE(DGGD%XSNOWTEMP(KLU,TGD%CUR%TSNOW%NLAYER        )) 
ALLOCATE(DGGD%XSNOWLIQ (KLU,TGD%CUR%TSNOW%NLAYER        )) 
ALLOCATE(DGGD%XSNOWDZ  (KLU,TGD%CUR%TSNOW%NLAYER        )) 
ALLOCATE(DGGD%XSNOWHMASS(KLU)) 
ALLOCATE(DGGD%XMELTADV  (KLU)) 
!
DGGD%XSNOWTEMP   = XUNDEF
DGGD%XSNOWLIQ    = XUNDEF
DGGD%XSNOWDZ     = XUNDEF
DGGD%XSNOWHMASS  = XUNDEF
DGGD%XMELTADV    = XUNDEF
!
ALLOCATE(DGGD%XHV     (KLU))
ALLOCATE(DGGD%XALBT   (KLU)) 
ALLOCATE(DGGD%XEMIST  (KLU)) 
!
DGGD%XHV               = XUNDEF
DGGD%XALBT             = XUNDEF
DGGD%XEMIST            = XUNDEF
!
ALLOCATE(DGGD%XFAPAR    (KLU))
ALLOCATE(DGGD%XFAPIR    (KLU))
ALLOCATE(DGGD%XFAPAR_BS (KLU))
ALLOCATE(DGGD%XFAPIR_BS (KLU))
ALLOCATE(DGGD%XDFAPARC  (KLU))
ALLOCATE(DGGD%XDFAPIRC  (KLU))
ALLOCATE(DGGD%XDLAI_EFFC(KLU))
!
DGGD%XFAPAR     = XUNDEF
DGGD%XFAPIR     = XUNDEF
DGGD%XFAPAR_BS  = XUNDEF
DGGD%XFAPIR_BS  = XUNDEF
DGGD%XDFAPARC   = XUNDEF
DGGD%XDFAPIRC   = XUNDEF
DGGD%XDLAI_EFFC = XUNDEF
!
!* surface energy budget
!
!IF (LSURF_BUDGET) THEN
  !
  ALLOCATE(DGGD%XSWD      (KLU))
  ALLOCATE(DGGD%XSWU      (KLU))
  ALLOCATE(DGGD%XSWBD     (KLU,KSW))
  ALLOCATE(DGGD%XSWBU     (KLU,KSW))
  ALLOCATE(DGGD%XLWD      (KLU))
  ALLOCATE(DGGD%XLWU      (KLU))
  ALLOCATE(DGGD%XFMU      (KLU))
  ALLOCATE(DGGD%XFMV      (KLU))
  !
  DGGD%XSWD     = XUNDEF
  DGGD%XSWU     = XUNDEF
  DGGD%XSWBD    = XUNDEF
  DGGD%XSWBU    = XUNDEF
  DGGD%XLWD     = XUNDEF
  DGGD%XLWU     = XUNDEF
  DGGD%XFMU     = XUNDEF
  DGGD%XFMV     = XUNDEF
  !
!END IF
!
!* surface temperature and parameters at 2m
!
ALLOCATE(DGGD%XTS    (KLU))
DGGD%XTS     = XUNDEF
ALLOCATE(DGGD%XTSRAD (KLU))
DGGD%XTSRAD  = XUNDEF
!
!* miscellaneous surface fields
!
IF (DGMTO%LSURF_MISC_BUDGET) THEN
  ALLOCATE(DGGD%XSWI    (KLU,TGDO%NGROUND_LAYER))
  ALLOCATE(DGGD%XTSWI   (KLU,TGDO%NGROUND_LAYER))
  ALLOCATE(DGGD%XTWSNOW (KLU))
  ALLOCATE(DGGD%XTDSNOW (KLU))
  DGGD%XSWI     = XUNDEF
  DGGD%XTSWI    = XUNDEF
  DGGD%XTWSNOW  = XUNDEF
  DGGD%XTDSNOW  = XUNDEF
ELSE
  ALLOCATE(DGGD%XSWI    (0,0))
  ALLOCATE(DGGD%XTSWI   (0,0))
  ALLOCATE(DGGD%XTWSNOW (0))
  ALLOCATE(DGGD%XTDSNOW (0))
ENDIF
!
ALLOCATE(DGGD%XALBT   (KLU))
ALLOCATE(DGGD%XGPP    (KLU))
ALLOCATE(DGGD%XRESP_AUTO  (KLU))
ALLOCATE(DGGD%XRESP_ECO   (KLU))
!
DGGD%XALBT    = XUNDEF
DGGD%XGPP     = XUNDEF
DGGD%XRESP_AUTO   = XUNDEF
DGGD%XRESP_ECO    = XUNDEF  
!
!END IF
!
!* transfer coefficients
!
!IF (LCOEF) THEN
  !
  ALLOCATE(DGGD%XCE            (KLU))
  ALLOCATE(DGGD%XZ0_WITH_SNOW  (KLU))
  ALLOCATE(DGGD%XZ0H_WITH_SNOW (KLU))
  ALLOCATE(DGGD%XZ0EFF         (KLU))
  !
  DGGD%XCE            = XUNDEF
  DGGD%XZ0_WITH_SNOW  = XUNDEF
  DGGD%XZ0H_WITH_SNOW = XUNDEF
  DGGD%XZ0EFF         = XUNDEF
!END IF
!
!
!* surface humidity
!
!IF (LSURF_VARS) THEN
  ALLOCATE(DGGD%XQS            (KLU))
  !
  DGGD%XQS            = XUNDEF
!END IF
!
!* Irrigation threshold
!
!IF (LAGRIP) THEN
  ALLOCATE(DGGD%XSEUIL(KLU))
  !
  DGGD%XSEUIL         = XUNDEF
!END IF
!
IF (LHOOK) CALL DR_HOOK('DIAG_TEB_GARDEN_INIT_N',1,ZHOOK_HANDLE)
!
!-------------------------------------------------------------------------------
!
END SUBROUTINE DIAG_TEB_GARDEN_INIT_n
