!     ######spl
      SUBROUTINE DIAG_MISC_TEB_INIT_n (DGCT, DGMT, DGMTO, TOP, BOP, HM, &
                                       HPROGRAM,KLU,KSW, KTEB_SOIL)
!     #####################
!
!!****  *DIAG_MISC_TEB_INIT_n* - routine to initialize TEB diagnostic variables
!!
!!    PURPOSE
!!    -------
!!
!!**  METHOD
!!    ------
!!
!!    EXTERNAL
!!    --------
!!
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!
!!    AUTHOR
!!    ------
!!      V. Masson   *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    01/2004 
!!      E.Redon/A.Lemonsu 01/2016 New diagnostics for high vegetation
!-------------------------------------------------------------------------------
!
!*       0.    DECLARATIONS
!              ------------
!
!
USE MODD_DIAG_CUMUL_TEB_n, ONLY : DIAG_CUMUL_TEB_t
USE MODD_DIAG_MISC_TEB_n, ONLY : DIAG_MISC_TEB_t
USE MODD_DIAG_MISC_TEB_OPTION_n, ONLY : DIAG_MISC_TEB_OPTIONS_t
USE MODD_TEB_OPTION_n, ONLY : TEB_OPTIONS_t
USE MODD_BEM_OPTION_n, ONLY : BEM_OPTIONS_t
!*** KC ***
USE MODD_SURFEX_n,     ONLY : TEB_HYDRO_MODEL_t
USE MODN_IO_OFFLINE,     ONLY:XTSTEP_OUTPUT,XTSTEP_SURF
!***
!
USE MODD_SURF_PAR,   ONLY : XUNDEF
USE MODD_TYPE_DATE_SURF
!


!
USE MODI_READ_SURF
!
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*       0.1   Declarations of arguments
!              -------------------------
!
!
TYPE(DIAG_CUMUL_TEB_t),        INTENT(INOUT) :: DGCT
TYPE(DIAG_MISC_TEB_t),         INTENT(INOUT) :: DGMT
TYPE(DIAG_MISC_TEB_OPTIONS_t), INTENT(INOUT) :: DGMTO
TYPE(TEB_OPTIONS_t),           INTENT(INOUT) :: TOP
TYPE(BEM_OPTIONS_t),           INTENT(INOUT) :: BOP
!*** KC ***
TYPE(TEB_HYDRO_MODEL_t), INTENT(INOUT) :: HM
!***
!
INTEGER, INTENT(IN) :: KLU        ! size of arrays
INTEGER, INTENT(IN) :: KSW        ! spectral bands
INTEGER, INTENT(IN) :: KTEB_SOIL  ! total soil layers
 CHARACTER(LEN=6), INTENT(IN):: HPROGRAM  ! program calling
!
!*       0.2   Declarations of local variables
!              -------------------------------
!
INTEGER           :: IRESP          ! IRESP  : return-code if a problem appears
 CHARACTER(LEN=12) :: YREC           ! Name of the article to be read
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!-------------------------------------------------------------------------------
!
!* surface energy budget
!
IF (LHOOK) CALL DR_HOOK('DIAG_MISC_TEB_INIT_N',0,ZHOOK_HANDLE)
!
!* miscellaneous fields
!
IF (DGMTO%LSURF_MISC_BUDGET) THEN
  ALLOCATE(DGMT%CUR%XQF_BLD           (KLU))
  ALLOCATE(DGMT%CUR%XFLX_BLD          (KLU))
  ALLOCATE(DGMT%CUR%XQF_TOWN          (KLU))
  ALLOCATE(DGMT%CUR%XDQS_TOWN         (KLU))
  ALLOCATE(DGMT%CUR%XRN_ROAD          (KLU))
  ALLOCATE(DGMT%CUR%XH_ROAD           (KLU))
  ALLOCATE(DGMT%CUR%XLE_ROAD          (KLU))
  ALLOCATE(DGMT%CUR%XGFLUX_ROAD       (KLU))
  ALLOCATE(DGMT%CUR%XRN_WALL_A        (KLU))
  ALLOCATE(DGMT%CUR%XH_WALL_A         (KLU))
  ALLOCATE(DGMT%CUR%XGFLUX_WALL_A     (KLU))
  ALLOCATE(DGMT%CUR%XRN_WALL_B        (KLU))
  ALLOCATE(DGMT%CUR%XH_WALL_B         (KLU))
  ALLOCATE(DGMT%CUR%XGFLUX_WALL_B     (KLU))
  ALLOCATE(DGMT%CUR%XRN_ROOF          (KLU))
  ALLOCATE(DGMT%CUR%XH_ROOF           (KLU))
  ALLOCATE(DGMT%CUR%XLE_ROOF          (KLU))
  ALLOCATE(DGMT%CUR%XGFLUX_ROOF       (KLU))
  ALLOCATE(DGMT%CUR%XRN_GARDEN        (KLU))
  ALLOCATE(DGMT%CUR%XH_GARDEN         (KLU))
  ALLOCATE(DGMT%CUR%XLE_GARDEN        (KLU))
  ALLOCATE(DGMT%CUR%XGFLUX_GARDEN     (KLU))
  ALLOCATE(DGMT%CUR%XRN_BLT           (KLU))
  ALLOCATE(DGMT%CUR%XH_BLT            (KLU))
  ALLOCATE(DGMT%CUR%XLE_BLT           (KLU))
  ALLOCATE(DGMT%CUR%XH_TRAFFIC_OUT    (KLU))
  ALLOCATE(DGMT%CUR%XLE_TRAFFIC_OUT   (KLU))
  ALLOCATE(DGMT%CUR%XH_INDUSTRY_OUT   (KLU))
  ALLOCATE(DGMT%CUR%XLE_INDUSTRY_OUT  (KLU))
  ALLOCATE(DGMT%CUR%XGFLUX_BLT        (KLU))
  ALLOCATE(DGMT%CUR%XRN_STRLROOF      (KLU))
  ALLOCATE(DGMT%CUR%XH_STRLROOF       (KLU))
  ALLOCATE(DGMT%CUR%XLE_STRLROOF      (KLU))
  ALLOCATE(DGMT%CUR%XGFLUX_STRLROOF   (KLU))
  ALLOCATE(DGMT%CUR%XRN_GREENROOF     (KLU))
  ALLOCATE(DGMT%CUR%XH_GREENROOF      (KLU))
  ALLOCATE(DGMT%CUR%XLE_GREENROOF     (KLU))
  ALLOCATE(DGMT%CUR%XGFLUX_GREENROOF  (KLU))
  ALLOCATE(DGMT%CUR%XG_GREENROOF_ROOF (KLU))
  ALLOCATE(DGMT%CUR%XRUNOFF_TOWN      (KLU))
  ALLOCATE(DGMT%CUR%XRUNOFF_GARDEN    (KLU))
  ALLOCATE(DGMT%CUR%XRUNOFF_ROAD      (KLU))
  ALLOCATE(DGMT%CUR%XRUNOFF_STRLROOF  (KLU))
  ALLOCATE(DGMT%CUR%XRUNOFF_ROOF      (KLU))
  ALLOCATE(DGMT%CUR%XRUNOFF_GREENROOF (KLU))
  ALLOCATE(DGMT%CUR%XDRAIN_GREENROOF  (KLU))
  ALLOCATE(DGMT%CUR%XDRAIN_GARDEN     (KLU))
  ALLOCATE(DGMT%CUR%XIRRIG_GREENROOF  (KLU))
  ALLOCATE(DGMT%CUR%XIRRIG_GARDEN     (KLU))
  ALLOCATE(DGMT%CUR%XIRRIG_ROAD       (KLU))
  !
  IF (TOP%LURBHYDRO) THEN
    ALLOCATE(DGMT%CUR%XRUNOFF_SEWER     (KLU))
    ALLOCATE(DGMT%CUR%XDRAIN_ROAD       (KLU))
    ALLOCATE(DGMT%CUR%XDRAIN_BLD        (KLU))
    IF (MOD(XTSTEP_OUTPUT,XTSTEP_SURF)==0) THEN 
     HM%THP%NSTEP_OUT  = XTSTEP_OUTPUT/XTSTEP_SURF              
     HM%THP%NSTEP_SURF = 0
    ELSE
     PRINT*,'ATTENTION, PAS DE TEMPS DES SORTIES=',XTSTEP_OUTPUT,' ET PAS DE TEMPS MODELE=',XTSTEP_SURF,' NON COMPATIBLES'
     STOP
    ENDIF
!  ALLOCATE(DGMT%CUR%XRUNOFF_TOWNC     (KLU))
!  ALLOCATE(DGMT%CUR%XRUNOFF_ROADC     (KLU))
!  ALLOCATE(DGMT%CUR%XRUNOFF_ROOFC     (KLU))
!  ALLOCATE(DGMT%CUR%XRUNOFF_STRLROOFC (KLU))
!  ALLOCATE(DGMT%CUR%XRUNOFF_GARDENC   (KLU))
!  ALLOCATE(DGMT%CUR%XRUNOFF_SEWERC    (KLU))
  ALLOCATE(DGMT%CUR%XDIS_TOWN         (KLU))
  ALLOCATE(DGMT%CUR%XDIS_ROOF         (KLU))
  ALLOCATE(DGMT%CUR%XDIS_ROAD         (KLU))
  ALLOCATE(DGMT%CUR%XDIS_GARDEN       (KLU))
  ALLOCATE(DGMT%CUR%XDIS_SEWER        (KLU))
!  ALLOCATE(DGMT%CUR%XDRAIN            (KLU))
  ALLOCATE(DGMT%CUR%XWG_ROAD_INI      (KLU,KTEB_SOIL))
  ALLOCATE(DGMT%CUR%XWG_BLD_INI       (KLU,KTEB_SOIL))
  ALLOCATE(DGMT%CUR%XWG_GARDEN_INI    (KLU,KTEB_SOIL))
 ENDIF
  !
  ALLOCATE(DGMT%CUR%XABS_SW_ROOF      (KLU))
  ALLOCATE(DGMT%CUR%XABS_SW_SNOW_ROOF (KLU))
  ALLOCATE(DGMT%CUR%XABS_LW_ROOF      (KLU))
  ALLOCATE(DGMT%CUR%XABS_LW_SNOW_ROOF (KLU))
  ALLOCATE(DGMT%CUR%XABS_SW_ROAD      (KLU))
  ALLOCATE(DGMT%CUR%XABS_SW_SNOW_ROAD (KLU))
  ALLOCATE(DGMT%CUR%XABS_LW_ROAD      (KLU))
  ALLOCATE(DGMT%CUR%XABS_LW_SNOW_ROAD (KLU))
  ALLOCATE(DGMT%CUR%XABS_SW_WALL_A    (KLU))
  ALLOCATE(DGMT%CUR%XABS_SW_WALL_B    (KLU))
  ALLOCATE(DGMT%CUR%XABS_LW_WALL_A    (KLU))
  ALLOCATE(DGMT%CUR%XABS_LW_WALL_B    (KLU))
  ALLOCATE(DGMT%CUR%XABS_SW_GARDEN    (KLU))
  ALLOCATE(DGMT%CUR%XABS_LW_GARDEN    (KLU))
  ALLOCATE(DGMT%CUR%XABS_SW_HVEG      (KLU))
  ALLOCATE(DGMT%CUR%XABS_LW_HVEG      (KLU))
  ALLOCATE(DGMT%CUR%XABS_SW_GREENROOF (KLU))
  ALLOCATE(DGMT%CUR%XABS_LW_GREENROOF (KLU))
  !
  ALLOCATE(DGMT%CUR%XREF_SW_FAC       (KLU))  
  ALLOCATE(DGMT%CUR%XREF_SW_GRND      (KLU))
  !
  ALLOCATE(DGMT%CUR%XEMIT_LW_FAC      (KLU))
  ALLOCATE(DGMT%CUR%XEMIT_LW_GRND     (KLU))
  !
  ALLOCATE(DGMT%CUR%XSENFABSTOR       (KLU))
  ALLOCATE(DGMT%CUR%XLATFABSTOR       (KLU))
  ALLOCATE(DGMT%CUR%XROOFTK           (KLU))
  ALLOCATE(DGMT%CUR%XWALLTK           (KLU))
  ALLOCATE(DGMT%CUR%XU_LOWCAN         (KLU))
  ALLOCATE(DGMT%CUR%XROAD_SHADE       (KLU))
  !
  IF (TOP%CBEM=='BEM') THEN
    ALLOCATE(DGMT%CUR%XH_BLD_COOL    (KLU))
    ALLOCATE(DGMT%CUR%XT_BLD_COOL    (KLU))
    ALLOCATE(DGMT%CUR%XH_BLD_HEAT    (KLU))
    ALLOCATE(DGMT%CUR%XLE_BLD_COOL   (KLU))
    ALLOCATE(DGMT%CUR%XLE_BLD_HEAT   (KLU))
    ALLOCATE(DGMT%CUR%XH_WASTE_CANY  (KLU))
    ALLOCATE(DGMT%CUR%XLE_WASTE_CANY (KLU))
    ALLOCATE(DGMT%CUR%XH_WASTE_ROOF  (KLU))
    ALLOCATE(DGMT%CUR%XLE_WASTE_ROOF (KLU))
    ALLOCATE(DGMT%CUR%XHVAC_COOL     (KLU))
    ALLOCATE(DGMT%CUR%XHVAC_HEAT     (KLU))
    ALLOCATE(DGMT%CUR%XQINOUT        (KLU))
    ALLOCATE(DGMT%CUR%XCOMP_HVAC_COOL(KLU,BOP%NBEMCOMP))
    ALLOCATE(DGMT%CUR%XCOMP_HVAC_HEAT(KLU,BOP%NBEMCOMP))
    ALLOCATE(DGMT%CUR%XCOMP_QINOUT   (KLU,BOP%NBEMCOMP))
    ALLOCATE(DGMT%CUR%XMASSTK        (KLU))
    ALLOCATE(DGMT%CUR%XINFCALC       (KLU))
    ALLOCATE(DGMT%CUR%XDIAGSHAD      (KLU,BOP%NBEMCOMP))
    ALLOCATE(DGMT%CUR%XDIAGVENT      (KLU,BOP%NBEMCOMP))
    ALLOCATE(DGMT%CUR%XDIAGVEFL      (KLU,BOP%NBEMCOMP))
    ALLOCATE(DGMT%CUR%XBLDOCC        (KLU,BOP%NBEMCOMP))
    ALLOCATE(DGMT%CUR%XQIN_KWH       (KLU))
    ALLOCATE(DGMT%CUR%XHVAC_HT_KWH   (KLU))
    ALLOCATE(DGMT%CUR%XHVAC_CL_KWH   (KLU))
    ALLOCATE(DGMT%CUR%XCAP_SYS       (KLU))
    ALLOCATE(DGMT%CUR%XM_SYS         (KLU))
    ALLOCATE(DGMT%CUR%XCOP           (KLU))
    ALLOCATE(DGMT%CUR%XQ_SYS         (KLU))
    ALLOCATE(DGMT%CUR%XT_SYS         (KLU))
    ALLOCATE(DGMT%CUR%XTR_SW_WIN     (KLU))
    ALLOCATE(DGMT%CUR%XFAN_POWER     (KLU))
    ALLOCATE(DGMT%CUR%XT_RAD_IND     (KLU))
    ALLOCATE(DGMT%CUR%XABS_SW_WIN    (KLU)) 
    ALLOCATE(DGMT%CUR%XABS_LW_WIN    (KLU))    
  ENDIF
  !
  IF (TOP%LSOLAR_PANEL) THEN
    ALLOCATE(DGMT%CUR%XABS_SW_PANEL   (KLU))
    ALLOCATE(DGMT%CUR%XABS_LW_PANEL   (KLU))
    ALLOCATE(DGMT%CUR%XRN_PANEL       (KLU))
    ALLOCATE(DGMT%CUR%XH_PANEL        (KLU))
    ALLOCATE(DGMT%CUR%XTHER_PROD_PANEL(KLU))
    ALLOCATE(DGMT%CUR%XPHOT_PROD_PANEL(KLU))
    ALLOCATE(DGMT%CUR%XPROD_PANEL     (KLU))
    ALLOCATE(DGMT%CUR%XTHER_PROD_BLD  (KLU))
    ALLOCATE(DGMT%CUR%XPHOT_PROD_BLD  (KLU))
  END IF
  !
    ALLOCATE(DGCT%CUR%XRUNOFFC_TOWN      (KLU))
    ALLOCATE(DGCT%CUR%XRUNOFFC_GARDEN    (KLU))
    ALLOCATE(DGCT%CUR%XDRAINC_GARDEN     (KLU))
    ALLOCATE(DGCT%CUR%XIRRIGC_GARDEN     (KLU))
    ALLOCATE(DGCT%CUR%XRUNOFFC_ROAD      (KLU))
    ALLOCATE(DGCT%CUR%XIRRIGC_ROAD       (KLU))
    ALLOCATE(DGCT%CUR%XRUNOFFC_STRLROOF  (KLU))
    ALLOCATE(DGCT%CUR%XRUNOFFC_ROOF      (KLU))
    ALLOCATE(DGCT%CUR%XRUNOFFC_GREENROOF (KLU))
    ALLOCATE(DGCT%CUR%XDRAINC_GREENROOF  (KLU))
    ALLOCATE(DGCT%CUR%XIRRIGC_GREENROOF  (KLU))
!*** KC ***
    IF (TOP%LURBHYDRO) THEN
      ALLOCATE(DGCT%CUR%XRUNOFFC_SEWER     (KLU))
      ALLOCATE(DGMT%CUR%XRUNOFF_TOWNB      (KLU))
      ALLOCATE(DGMT%CUR%XRUNOFF_GARDENB    (KLU))
      ALLOCATE(DGMT%CUR%XDRAIN_GARDENB     (KLU))
      ALLOCATE(DGMT%CUR%XDRAIN_ROADB       (KLU))
      ALLOCATE(DGMT%CUR%XDRAIN_BLDB        (KLU))
      ALLOCATE(DGMT%CUR%XRUNOFF_ROADB      (KLU))
      ALLOCATE(DGMT%CUR%XRUNOFF_STRLROOFB  (KLU))
      ALLOCATE(DGMT%CUR%XRUNOFF_ROOFB      (KLU))
      ALLOCATE(DGMT%CUR%XRUNOFF_GREENROOFB (KLU))
      ALLOCATE(DGMT%CUR%XRUNOFF_SEWERB     (KLU))
      ALLOCATE(DGMT%CUR%XLE_STRLROOFB      (KLU))
      ALLOCATE(DGMT%CUR%XLE_GREENROOFB     (KLU))
      ALLOCATE(DGMT%CUR%XLE_ROADB          (KLU))
      ALLOCATE(DGMT%CUR%XLE_GARDENB        (KLU))
      ALLOCATE(DGMT%CUR%XRAINB             (KLU))
      ALLOCATE(DGMT%CUR%XSNOWB             (KLU))
    ENDIF
!***
    IF (TOP%CBEM=='BEM') THEN
      ALLOCATE(DGCT%CUR%XHVACC_COOL       (KLU))
      ALLOCATE(DGCT%CUR%XHVACC_HEAT       (KLU))
      ALLOCATE(DGCT%CUR%XQINOUTCUM        (KLU))
    END IF
  IF (TOP%LSOLAR_PANEL) THEN
    ALLOCATE(DGCT%CUR%XTHER_PROD_BLDC(KLU))
    ALLOCATE(DGCT%CUR%XPHOT_PROD_BLDC(KLU))
  END IF
  DGMT%CUR%XQF_BLD            = XUNDEF
  DGMT%CUR%XFLX_BLD           = XUNDEF
  DGMT%CUR%XQF_TOWN           = XUNDEF
  DGMT%CUR%XDQS_TOWN          = XUNDEF
  DGMT%CUR%XRN_ROAD           = XUNDEF
  DGMT%CUR%XH_ROAD            = XUNDEF
  DGMT%CUR%XLE_ROAD           = XUNDEF
  DGMT%CUR%XGFLUX_ROAD        = XUNDEF
  DGMT%CUR%XRN_WALL_A         = XUNDEF
  DGMT%CUR%XH_WALL_A          = XUNDEF
  DGMT%CUR%XGFLUX_WALL_A      = XUNDEF
  DGMT%CUR%XRN_WALL_B         = XUNDEF
  DGMT%CUR%XH_WALL_B          = XUNDEF
  DGMT%CUR%XGFLUX_WALL_B      = XUNDEF
  DGMT%CUR%XRN_ROOF           = XUNDEF
  DGMT%CUR%XH_ROOF            = XUNDEF
  DGMT%CUR%XLE_ROOF           = XUNDEF
  DGMT%CUR%XGFLUX_ROOF        = XUNDEF 
  DGMT%CUR%XRN_GARDEN         = XUNDEF
  DGMT%CUR%XH_GARDEN          = XUNDEF
  DGMT%CUR%XLE_GARDEN         = XUNDEF
  DGMT%CUR%XGFLUX_GARDEN      = XUNDEF  
  DGMT%CUR%XRN_BLT            = XUNDEF
  DGMT%CUR%XH_BLT             = XUNDEF
  DGMT%CUR%XLE_BLT            = XUNDEF
  DGMT%CUR%XH_TRAFFIC_OUT     = XUNDEF
  DGMT%CUR%XLE_TRAFFIC_OUT    = XUNDEF
  DGMT%CUR%XH_INDUSTRY_OUT    = XUNDEF
  DGMT%CUR%XLE_INDUSTRY_OUT   = XUNDEF
  DGMT%CUR%XGFLUX_BLT         = XUNDEF  
  DGMT%CUR%XRN_STRLROOF       = XUNDEF
  DGMT%CUR%XH_STRLROOF        = XUNDEF
  DGMT%CUR%XLE_STRLROOF       = XUNDEF
  DGMT%CUR%XGFLUX_STRLROOF    = XUNDEF  
  DGMT%CUR%XRN_GREENROOF      = XUNDEF
  DGMT%CUR%XH_GREENROOF       = XUNDEF
  DGMT%CUR%XLE_GREENROOF      = XUNDEF
  DGMT%CUR%XGFLUX_GREENROOF   = XUNDEF  
  DGMT%CUR%XG_GREENROOF_ROOF  = XUNDEF  
  DGMT%CUR%XRUNOFF_TOWN       = XUNDEF  
  DGMT%CUR%XRUNOFF_GARDEN     = XUNDEF  
  DGMT%CUR%XRUNOFF_ROAD       = XUNDEF  
  DGMT%CUR%XRUNOFF_ROOF       = XUNDEF  
  DGMT%CUR%XRUNOFF_STRLROOF   = XUNDEF
  DGMT%CUR%XRUNOFF_GREENROOF  = XUNDEF  
  DGMT%CUR%XDRAIN_GREENROOF   = XUNDEF  
  DGMT%CUR%XDRAIN_GARDEN      = XUNDEF  
  DGMT%CUR%XIRRIG_GREENROOF   = XUNDEF  
  DGMT%CUR%XIRRIG_GARDEN      = XUNDEF  
  DGMT%CUR%XIRRIG_ROAD        = XUNDEF  
!
  DGMT%CUR%XABS_SW_ROOF       = XUNDEF  
  DGMT%CUR%XABS_SW_SNOW_ROOF  = XUNDEF  
  DGMT%CUR%XABS_LW_ROOF       = XUNDEF  
  DGMT%CUR%XABS_LW_SNOW_ROOF  = XUNDEF  
  DGMT%CUR%XABS_SW_ROAD       = XUNDEF  
  DGMT%CUR%XABS_SW_SNOW_ROAD  = XUNDEF  
  DGMT%CUR%XABS_LW_ROAD       = XUNDEF  
  DGMT%CUR%XABS_LW_SNOW_ROAD  = XUNDEF  
  DGMT%CUR%XABS_SW_WALL_A     = XUNDEF  
  DGMT%CUR%XABS_SW_WALL_B     = XUNDEF  
  DGMT%CUR%XABS_LW_WALL_A     = XUNDEF  
  DGMT%CUR%XABS_LW_WALL_B     = XUNDEF  
  DGMT%CUR%XABS_SW_GARDEN     = XUNDEF  
  DGMT%CUR%XABS_LW_GARDEN     = XUNDEF 
  DGMT%CUR%XABS_SW_HVEG       = XUNDEF  
  DGMT%CUR%XABS_LW_HVEG       = XUNDEF 
  DGMT%CUR%XABS_SW_GREENROOF  = XUNDEF  
  DGMT%CUR%XABS_LW_GREENROOF  = XUNDEF 
  !
  DGMT%CUR%XREF_SW_FAC        = XUNDEF
  DGMT%CUR%XREF_SW_GRND       = XUNDEF
  !
  DGMT%CUR%XEMIT_LW_FAC       = XUNDEF
  DGMT%CUR%XEMIT_LW_GRND      = XUNDEF
  !
  DGMT%CUR%XSENFABSTOR        = XUNDEF
  DGMT%CUR%XLATFABSTOR        = XUNDEF
  DGMT%CUR%XROOFTK            = XUNDEF
  DGMT%CUR%XWALLTK            = XUNDEF
  DGMT%CUR%XU_LOWCAN          = XUNDEF
  DGMT%CUR%XROAD_SHADE        = XUNDEF
  !
  IF (TOP%CBEM=='BEM') THEN
    DGMT%CUR%XH_BLD_COOL     = XUNDEF
    DGMT%CUR%XT_BLD_COOL     = XUNDEF
    DGMT%CUR%XH_BLD_HEAT     = XUNDEF
    DGMT%CUR%XLE_BLD_COOL    = XUNDEF
    DGMT%CUR%XLE_BLD_HEAT    = XUNDEF
    DGMT%CUR%XH_WASTE_CANY   = XUNDEF
    DGMT%CUR%XLE_WASTE_CANY  = XUNDEF
    DGMT%CUR%XH_WASTE_ROOF   = XUNDEF
    DGMT%CUR%XLE_WASTE_ROOF  = XUNDEF
    DGMT%CUR%XHVAC_COOL      = XUNDEF
    DGMT%CUR%XHVAC_HEAT      = XUNDEF
    DGMT%CUR%XQINOUT         = XUNDEF
    DGMT%CUR%XCOMP_HVAC_COOL = XUNDEF
    DGMT%CUR%XCOMP_HVAC_HEAT = XUNDEF
    DGMT%CUR%XCOMP_QINOUT    = XUNDEF
    DGMT%CUR%XMASSTK         = XUNDEF
    DGMT%CUR%XQIN_KWH        = XUNDEF
    DGMT%CUR%XHVAC_HT_KWH    = XUNDEF
    DGMT%CUR%XHVAC_CL_KWH    = XUNDEF
    DGMT%CUR%XINFCALC        = XUNDEF
    DGMT%CUR%XDIAGSHAD       = XUNDEF
    DGMT%CUR%XDIAGVENT       = XUNDEF
    DGMT%CUR%XDIAGVEFL       = XUNDEF
    DGMT%CUR%XBLDOCC         = XUNDEF
    DGMT%CUR%XCAP_SYS        = XUNDEF
    DGMT%CUR%XM_SYS          = XUNDEF
    DGMT%CUR%XCOP            = XUNDEF
    DGMT%CUR%XQ_SYS          = XUNDEF
    DGMT%CUR%XT_SYS          = XUNDEF
    DGMT%CUR%XTR_SW_WIN      = XUNDEF
    DGMT%CUR%XFAN_POWER      = XUNDEF
    DGMT%CUR%XT_RAD_IND      = XUNDEF
    DGMT%CUR%XABS_SW_WIN     = XUNDEF 
    DGMT%CUR%XABS_LW_WIN     = XUNDEF    
  ENDIF

  IF (TOP%LSOLAR_PANEL) THEN
    DGMT%CUR%XABS_SW_PANEL   = XUNDEF
    DGMT%CUR%XABS_LW_PANEL   = XUNDEF
    DGMT%CUR%XRN_PANEL       = XUNDEF
    DGMT%CUR%XH_PANEL        = XUNDEF
    DGMT%CUR%XTHER_PROD_PANEL= XUNDEF
    DGMT%CUR%XPHOT_PROD_PANEL= XUNDEF
    DGMT%CUR%XPROD_PANEL     = XUNDEF
    DGMT%CUR%XTHER_PROD_BLD  = XUNDEF
    DGMT%CUR%XPHOT_PROD_BLD  = XUNDEF
  END IF
!  
    DGCT%CUR%XRUNOFFC_TOWN       = 0.0  
    DGCT%CUR%XRUNOFFC_GARDEN     = 0.0  
    DGCT%CUR%XRUNOFFC_ROAD       = 0.0  
    DGCT%CUR%XRUNOFFC_ROOF       = 0.0  
    DGCT%CUR%XRUNOFFC_STRLROOF   = 0.0  
    DGCT%CUR%XRUNOFFC_GREENROOF  = 0.0  
    DGCT%CUR%XDRAINC_GREENROOF   = 0.0  
    DGCT%CUR%XDRAINC_GARDEN      = 0.0  
    DGCT%CUR%XIRRIGC_GREENROOF   = 0.0  
    DGCT%CUR%XIRRIGC_GARDEN      = 0.0  
!*** KC ***
  IF (TOP%LURBHYDRO) THEN  
    DGMT%CUR%XDRAIN_ROAD    = XUNDEF
    DGMT%CUR%XDRAIN_BLD     = XUNDEF
    DGCT%CUR%XRUNOFFC_SEWER      = 0.0
  ENDIF
!***
    DGCT%CUR%XIRRIGC_ROAD        = 0.0  
    IF (TOP%CBEM=='BEM') THEN
      DGCT%CUR%XHVACC_COOL       = 0.0
      DGCT%CUR%XHVACC_HEAT       = 0.0
      DGCT%CUR%XQINOUTCUM        = 0.0
    END IF
  IF (TOP%LSOLAR_PANEL) THEN
    DGCT%CUR%XTHER_PROD_BLDC = 0.
    DGCT%CUR%XPHOT_PROD_BLDC = 0.
  END IF
ENDIF
!
IF (LHOOK) CALL DR_HOOK('DIAG_MISC_TEB_INIT_N',1,ZHOOK_HANDLE)
!
!-------------------------------------------------------------------------------
!
END SUBROUTINE DIAG_MISC_TEB_INIT_n
