!SFX_LIC Copyright 1994-2014 CNRS, Meteo-France and Universite Paul Sabatier
!SFX_LIC This is part of the SURFEX software governed by the CeCILL-C licence
!SFX_LIC version 1. See LICENSE, CeCILL-C_V1-en.txt and CeCILL-C_V1-fr.txt  
!SFX_LIC for details. version 1.
!     #########
      SUBROUTINE DIAG_IDEAL_INIT_n (DGL, HPROGRAM, OREAD_BUDGETC, &
                                    KLU,KSW)
!     #####################
!
!!****  *DIAG_IDEAL_INIT_n* - routine to initialize IDEAL diagnostic variables
!!
!!    PURPOSE
!!    -------
!!
!!**  METHOD
!!    ------
!!
!!    EXTERNAL
!!    --------
!!
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!
!!    AUTHOR
!!    ------
!!      P. Le Moigne   *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    04/2009 
!!      P. Le Moigne 03/2015: add diagnostics IDEAL case
!-------------------------------------------------------------------------------
!
!*       0.    DECLARATIONS
!              ------------
!
!
USE MODD_DIAG_IDEAL_n, ONLY : DIAG_IDEAL_t
!
USE MODD_SURF_PAR,   ONLY : XUNDEF
!
USE MODI_READ_SURF
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*       0.1   Declarations of arguments
!              -------------------------
!
!
TYPE(DIAG_IDEAL_t), INTENT(INOUT) :: DGL
!
 CHARACTER(LEN=6), INTENT(IN):: HPROGRAM  ! program calling
LOGICAL, INTENT(IN) :: OREAD_BUDGETC
!
INTEGER, INTENT(IN) :: KLU   ! size of arrays
INTEGER, INTENT(IN) :: KSW   ! spectral bands
!
!*       0.2   Declarations of local variables
!              -------------------------------
!
INTEGER           :: IVERSION
INTEGER           :: IRESP          ! IRESP  : return-code if a problem appears
 CHARACTER(LEN=12) :: YREC           ! Name of the article to be read
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!-------------------------------------------------------------------------------
!
!* surface energy budget
!
IF (LHOOK) CALL DR_HOOK('DIAG_IDEAL_INIT_N',0,ZHOOK_HANDLE)
!
ALLOCATE(DGL%XDIAG_TS(KLU))
DGL%XDIAG_TS = XUNDEF
!
IF (DGL%LSURF_BUDGET .OR. DGL%LSURF_BUDGETC) THEN
  ALLOCATE(DGL%XRN     (KLU))
  ALLOCATE(DGL%XH      (KLU))
  ALLOCATE(DGL%XLE     (KLU))
  ALLOCATE(DGL%XLEI    (KLU))
  ALLOCATE(DGL%XGFLUX  (KLU))
  ALLOCATE(DGL%XEVAP   (KLU))
  ALLOCATE(DGL%XSUBL   (KLU))
  ALLOCATE(DGL%XSWD    (KLU))
  ALLOCATE(DGL%XSWU    (KLU))
  ALLOCATE(DGL%XLWD    (KLU))
  ALLOCATE(DGL%XLWU    (KLU))  
  ALLOCATE(DGL%XSWBD   (KLU,KSW))
  ALLOCATE(DGL%XSWBU   (KLU,KSW))
  ALLOCATE(DGL%XFMU    (KLU))
  ALLOCATE(DGL%XFMV    (KLU))
  ALLOCATE(DGL%XALBT   (KLU))
  ALLOCATE(DGL%XSWE    (KLU))  
  !
  DGL%XRN      = XUNDEF
  DGL%XH       = XUNDEF
  DGL%XLE      = XUNDEF
  DGL%XLEI     = XUNDEF  
  DGL%XGFLUX   = XUNDEF
  DGL%XEVAP    = XUNDEF
  DGL%XSUBL    = XUNDEF    
  DGL%XSWD     = XUNDEF
  DGL%XSWU     = XUNDEF
  DGL%XLWD     = XUNDEF
  DGL%XLWU     = XUNDEF  
  DGL%XSWBD    = XUNDEF
  DGL%XSWBU    = XUNDEF
  DGL%XFMU     = XUNDEF
  DGL%XFMV     = XUNDEF
  DGL%XALBT    = XUNDEF
  DGL%XSWE     = XUNDEF  
ELSE
  ALLOCATE(DGL%XRN     (0))
  ALLOCATE(DGL%XH      (0))
  ALLOCATE(DGL%XLE     (0))
  ALLOCATE(DGL%XLEI    (0))  
  ALLOCATE(DGL%XGFLUX  (0))
  ALLOCATE(DGL%XEVAP   (0))
  ALLOCATE(DGL%XSUBL   (0))   
  ALLOCATE(DGL%XSWD    (0))
  ALLOCATE(DGL%XSWU    (0))
  ALLOCATE(DGL%XLWD    (0))
  ALLOCATE(DGL%XLWU    (0))
  ALLOCATE(DGL%XSWBD   (0,0))
  ALLOCATE(DGL%XSWBU   (0,0))
  ALLOCATE(DGL%XFMU    (0))
  ALLOCATE(DGL%XFMV    (0))
  ALLOCATE(DGL%XALBT   (0))
  ALLOCATE(DGL%XSWE    (0))  
END IF
!
!* cumulative surface energy budget
!
IF (DGL%LSURF_BUDGETC) THEN
!    
  ALLOCATE(DGL%XRNC    (KLU))
  ALLOCATE(DGL%XHC     (KLU))
  ALLOCATE(DGL%XLEC    (KLU))
  ALLOCATE(DGL%XLEIC   (KLU))
  ALLOCATE(DGL%XGFLUXC (KLU))
  ALLOCATE(DGL%XEVAPC  (KLU))
  ALLOCATE(DGL%XSUBLC  (KLU))  
  ALLOCATE(DGL%XSWDC   (KLU))
  ALLOCATE(DGL%XSWUC   (KLU))
  ALLOCATE(DGL%XLWDC   (KLU))
  ALLOCATE(DGL%XLWUC   (KLU))
  ALLOCATE(DGL%XFMUC   (KLU))
  ALLOCATE(DGL%XFMVC   (KLU))
!
  IF (.NOT. OREAD_BUDGETC) THEN        
     DGL%XRNC    = 0.0
     DGL%XHC     = 0.0
     DGL%XLEC    = 0.0
     DGL%XLEIC   = 0.0
     DGL%XGFLUXC = 0.0
     DGL%XEVAPC  = 0.0
     DGL%XSUBLC  = 0.0
     DGL%XSWDC   = 0.0
     DGL%XSWUC   = 0.0
     DGL%XLWDC   = 0.0
     DGL%XLWUC   = 0.0
     DGL%XFMUC   = 0.0
     DGL%XFMVC   = 0.0
  ELSEIF (OREAD_BUDGETC.AND.DGL%LRESET_BUDGETC) THEN
     DGL%XRNC    = 0.0
     DGL%XHC     = 0.0
     DGL%XLEC    = 0.0
     DGL%XLEIC   = 0.0
     DGL%XGFLUXC = 0.0
     DGL%XEVAPC  = 0.0
     DGL%XSUBLC  = 0.0     
     DGL%XSWDC   = 0.0
     DGL%XSWUC   = 0.0
     DGL%XLWDC   = 0.0
     DGL%XLWUC   = 0.0
     DGL%XFMUC   = 0.0
     DGL%XFMVC   = 0.0
  ELSE
     CALL READ_SURF(HPROGRAM,'VERSION',IVERSION,IRESP)
     IF (IVERSION<8)THEN
       DGL%XRNC    = 0.0
       DGL%XHC     = 0.0
       DGL%XLEC    = 0.0
       DGL%XLEIC   = 0.0
       DGL%XGFLUXC = 0.0
       DGL%XEVAPC  = 0.0
       DGL%XSUBLC  = 0.0     
       DGL%XSWDC   = 0.0
       DGL%XSWUC   = 0.0
       DGL%XLWDC   = 0.0
       DGL%XLWUC   = 0.0
       DGL%XFMUC   = 0.0
       DGL%XFMVC   = 0.0             
     ELSE
       YREC='RNC_WAT'
       CALL READ_SURF(HPROGRAM,YREC,DGL%XRNC,IRESP)
       YREC='HC_WAT'
       CALL READ_SURF(HPROGRAM,YREC,DGL%XHC ,IRESP)
       YREC='LEC_WAT'
       CALL READ_SURF(HPROGRAM,YREC,DGL%XLEC,IRESP)
       YREC='LEIC_WAT'
       CALL READ_SURF(HPROGRAM,YREC,DGL%XLEIC,IRESP)     
       YREC='GFLUXC_WAT'
       CALL READ_SURF(HPROGRAM,YREC,DGL%XGFLUXC,IRESP)
       YREC='SWDC_WAT'
       CALL READ_SURF(HPROGRAM,YREC,DGL%XSWDC,IRESP)
       YREC='SWUC_WAT'
       CALL READ_SURF(HPROGRAM,YREC,DGL%XSWUC,IRESP)
       YREC='LWDC_WAT'
       CALL READ_SURF(HPROGRAM,YREC,DGL%XLWDC,IRESP)
       YREC='LWUC_WAT'
       CALL READ_SURF(HPROGRAM,YREC,DGL%XLWUC,IRESP)
       YREC='FMUC_WAT'
       CALL READ_SURF(HPROGRAM,YREC,DGL%XFMUC,IRESP)
       YREC='FMVC_WAT'
       CALL READ_SURF(HPROGRAM,YREC,DGL%XFMVC,IRESP)
       YREC='EVAPC_WAT'
        CALL READ_SURF(HPROGRAM,YREC,DGL%XEVAPC,IRESP)
        YREC='SUBLC_WAT'
        CALL READ_SURF(HPROGRAM,YREC,DGL%XSUBLC,IRESP)              
      ENDIF
!
  ENDIF   
ELSE
  ALLOCATE(DGL%XRNC    (0))
  ALLOCATE(DGL%XHC     (0))
  ALLOCATE(DGL%XLEC    (0))
  ALLOCATE(DGL%XLEIC   (0))
  ALLOCATE(DGL%XGFLUXC (0))
  ALLOCATE(DGL%XEVAPC  (0))
  ALLOCATE(DGL%XSUBLC  (0))  
  ALLOCATE(DGL%XSWDC   (0))
  ALLOCATE(DGL%XSWUC   (0))
  ALLOCATE(DGL%XLWDC   (0))
  ALLOCATE(DGL%XLWUC   (0))
  ALLOCATE(DGL%XFMUC   (0))
  ALLOCATE(DGL%XFMVC   (0))  
ENDIF
!
!* parameters at 2m
!
IF (DGL%N2M>=1) THEN
  ALLOCATE(DGL%XRI     (KLU))
  ALLOCATE(DGL%XT2M    (KLU))
  ALLOCATE(DGL%XT2M_MIN(KLU))
  ALLOCATE(DGL%XT2M_MAX(KLU))
  ALLOCATE(DGL%XQ2M    (KLU))
  ALLOCATE(DGL%XHU2M   (KLU))
  ALLOCATE(DGL%XHU2M_MIN(KLU))
  ALLOCATE(DGL%XHU2M_MAX(KLU))
  ALLOCATE(DGL%XZON10M (KLU))
  ALLOCATE(DGL%XMER10M (KLU))
  ALLOCATE(DGL%XWIND10M (KLU))
  ALLOCATE(DGL%XWIND10M_MAX(KLU))
  !
  DGL%XRI      = XUNDEF
  DGL%XT2M     = XUNDEF
  DGL%XT2M_MIN = XUNDEF
  DGL%XT2M_MAX = 0.0
  DGL%XQ2M     = XUNDEF
  DGL%XHU2M    = XUNDEF
  DGL%XHU2M_MIN= XUNDEF
  DGL%XHU2M_MAX=-XUNDEF
  DGL%XZON10M  = XUNDEF
  DGL%XMER10M  = XUNDEF
  DGL%XWIND10M = XUNDEF
  DGL%XWIND10M_MAX = 0.0
ELSE
  ALLOCATE(DGL%XRI      (0))
  ALLOCATE(DGL%XT2M     (0))
  ALLOCATE(DGL%XT2M_MIN (0))
  ALLOCATE(DGL%XT2M_MAX (0))
  ALLOCATE(DGL%XQ2M     (0))
  ALLOCATE(DGL%XHU2M    (0))
  ALLOCATE(DGL%XHU2M_MIN(0))
  ALLOCATE(DGL%XHU2M_MAX(0))
  ALLOCATE(DGL%XZON10M  (0))
  ALLOCATE(DGL%XMER10M  (0))
  ALLOCATE(DGL%XWIND10M (0))
  ALLOCATE(DGL%XWIND10M_MAX(0))
END IF
!
!* transfer coefficients
!
IF (DGL%LCOEF) THEN
  ALLOCATE(DGL%XCD     (KLU))
  ALLOCATE(DGL%XCH     (KLU))
  ALLOCATE(DGL%XCE     (KLU))
  ALLOCATE(DGL%XZ0     (KLU))
  ALLOCATE(DGL%XZ0H    (KLU))
  !
  DGL%XCD      = XUNDEF
  DGL%XCH      = XUNDEF
  DGL%XCE      = XUNDEF
  DGL%XZ0      = XUNDEF
  DGL%XZ0H     = XUNDEF
ELSE
  ALLOCATE(DGL%XCD     (0))
  ALLOCATE(DGL%XCH     (0))
  ALLOCATE(DGL%XCE     (0))
  ALLOCATE(DGL%XZ0     (0))
  ALLOCATE(DGL%XZ0H    (0))
END IF
!
!
!* surface humidity
!
IF (DGL%LSURF_VARS) THEN
  ALLOCATE(DGL%XQS     (KLU))
  !
  DGL%XQS      = XUNDEF
ELSE
  ALLOCATE(DGL%XQS     (0))
END IF
IF (LHOOK) CALL DR_HOOK('DIAG_IDEAL_INIT_N',1,ZHOOK_HANDLE)
!
!-------------------------------------------------------------------------------
!
END SUBROUTINE DIAG_IDEAL_INIT_n
