!     #################################################################################
SUBROUTINE DEALLOC_TEB_n (B, CHT, DTT, TG, T, TOP, TPN)
!     #################################################################################
!
!!****  *DEALLOC_TEB_n * - Deallocate all arrays
!!
!!    PURPOSE
!!    -------
!
!!**  METHOD
!!    ------
!!
!!    REFERENCE
!!    ---------
!!      
!!
!!    AUTHOR
!!    ------
!!     V. Masson 
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    01/2004
!!      G. Pigeon   09/2012: deallocate ROUGH_WALL/ROUGH_ROOF
!!      G. Pigeon   10/2012: deallocate BEM variables
!!------------------------------------------------------------------
!!
!
USE MODD_BEM_n, ONLY : BEM_t
USE MODD_CH_TEB_n, ONLY : CH_TEB_t
USE MODD_DATA_TEB_n, ONLY : DATA_TEB_t
USE MODD_TEB_GRID_n, ONLY : TEB_GRID_t
USE MODD_TEB_n, ONLY : TEB_t
USE MODD_TEB_OPTION_n, ONLY : TEB_OPTIONS_t
USE MODD_TEB_PANEL_n, ONLY : TEB_PANEL_t
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*      0.1    declarations of arguments
!
!
!*      0.2    declarations of local variables
!
!-------------------------------------------------------------------------------------
!
TYPE(BEM_t), INTENT(INOUT) :: B
TYPE(CH_TEB_t), INTENT(INOUT) :: CHT
TYPE(DATA_TEB_t), INTENT(INOUT) :: DTT
TYPE(TEB_GRID_t), INTENT(INOUT) :: TG
TYPE(TEB_t), INTENT(INOUT) :: T
TYPE(TEB_OPTIONS_t), INTENT(INOUT) :: TOP
TYPE(TEB_PANEL_t), INTENT(INOUT) :: TPN
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE

IF (LHOOK) CALL DR_HOOK('DEALLOC_TEB_N',0,ZHOOK_HANDLE)
!
IF (ASSOCIATED(TOP%LCOVER ))  DEALLOCATE(TOP%LCOVER )
IF (ASSOCIATED(TOP%XCOVER ))  DEALLOCATE(TOP%XCOVER )
IF (ASSOCIATED(TOP%XZS    ))  DEALLOCATE(TOP%XZS    )
!
!-------------------------------------------------------------------------------------
!
IF (ASSOCIATED(TG%XGRID_PAR )) DEALLOCATE(TG%XGRID_PAR )
IF (ASSOCIATED(TG%XLAT      )) DEALLOCATE(TG%XLAT      )
IF (ASSOCIATED(TG%XLON      )) DEALLOCATE(TG%XLON      )
IF (ASSOCIATED(TG%XMESH_SIZE)) DEALLOCATE(TG%XMESH_SIZE)
!
!-------------------------------------------------------------------------------------
!
IF(ASSOCIATED(T%CUR%XZ0_TOWN     )) DEALLOCATE(T%CUR%XZ0_TOWN     )
IF(ASSOCIATED(T%CUR%XALB_ROOF    )) DEALLOCATE(T%CUR%XALB_ROOF    )
IF(ASSOCIATED(T%CUR%XEMIS_ROOF   )) DEALLOCATE(T%CUR%XEMIS_ROOF   )
IF(ASSOCIATED(T%CUR%XALB_ROAD    )) DEALLOCATE(T%CUR%XALB_ROAD    )
IF(ASSOCIATED(T%CUR%XEMIS_ROAD   )) DEALLOCATE(T%CUR%XEMIS_ROAD   )
IF(ASSOCIATED(T%CUR%XALB_WALL    )) DEALLOCATE(T%CUR%XALB_WALL    )
IF(ASSOCIATED(T%CUR%XEMIS_WALL   )) DEALLOCATE(T%CUR%XEMIS_WALL   )
IF(ASSOCIATED(T%CUR%XBLD         )) DEALLOCATE(T%CUR%XBLD         )
IF(ASSOCIATED(T%CUR%XGARDEN      )) DEALLOCATE(T%CUR%XGARDEN      )
IF(ASSOCIATED(T%CUR%XROAD        )) DEALLOCATE(T%CUR%XROAD        )
IF(ASSOCIATED(T%CUR%XGREENROOF   )) DEALLOCATE(T%CUR%XGREENROOF   )
IF(ASSOCIATED(T%CUR%XROAD_DIR    )) DEALLOCATE(T%CUR%XROAD_DIR    )
IF(ASSOCIATED(T%CUR%XBLD_HEIGHT  )) DEALLOCATE(T%CUR%XBLD_HEIGHT  )
IF(ASSOCIATED(T%CUR%XWALL_O_HOR  )) DEALLOCATE(T%CUR%XWALL_O_HOR  )
IF(ASSOCIATED(T%CUR%XCAN_HW_RATIO)) DEALLOCATE(T%CUR%XCAN_HW_RATIO)
IF(ASSOCIATED(T%CUR%XROAD_O_GRND )) DEALLOCATE(T%CUR%XROAD_O_GRND)
IF(ASSOCIATED(T%CUR%XGARDEN_O_GRND))DEALLOCATE(T%CUR%XGARDEN_O_GRND)
IF(ASSOCIATED(T%CUR%XWALL_O_GRND )) DEALLOCATE(T%CUR%XWALL_O_GRND)
IF(ASSOCIATED(T%CUR%XWALL_O_BLD  )) DEALLOCATE(T%CUR%XWALL_O_BLD)
IF(ASSOCIATED(T%CUR%XH_TRAFFIC   )) DEALLOCATE(T%CUR%XH_TRAFFIC   )
IF(ASSOCIATED(T%CUR%XLE_TRAFFIC  )) DEALLOCATE(T%CUR%XLE_TRAFFIC  )
IF(ASSOCIATED(T%CUR%XH_INDUSTRY  )) DEALLOCATE(T%CUR%XH_INDUSTRY  )
IF(ASSOCIATED(T%CUR%XLE_INDUSTRY )) DEALLOCATE(T%CUR%XLE_INDUSTRY )
IF(ASSOCIATED(T%CUR%XHC_ROOF )) DEALLOCATE(T%CUR%XHC_ROOF )
IF(ASSOCIATED(T%CUR%XTC_ROOF )) DEALLOCATE(T%CUR%XTC_ROOF )
IF(ASSOCIATED(T%CUR%XD_ROOF  )) DEALLOCATE(T%CUR%XD_ROOF  )
IF(ASSOCIATED(T%CUR%XHC_ROAD )) DEALLOCATE(T%CUR%XHC_ROAD )
IF(ASSOCIATED(T%CUR%XTC_ROAD )) DEALLOCATE(T%CUR%XTC_ROAD )
IF(ASSOCIATED(T%CUR%XD_ROAD  )) DEALLOCATE(T%CUR%XD_ROAD  )
IF(ASSOCIATED(T%CUR%XHC_WALL )) DEALLOCATE(T%CUR%XHC_WALL )
IF(ASSOCIATED(T%CUR%XTC_WALL )) DEALLOCATE(T%CUR%XTC_WALL )
IF(ASSOCIATED(T%CUR%XD_WALL  )) DEALLOCATE(T%CUR%XD_WALL  )
IF(ASSOCIATED(T%CUR%XHC_BLD )) DEALLOCATE(T%CUR%XHC_BLD )
IF(ASSOCIATED(T%CUR%XTC_BLD )) DEALLOCATE(T%CUR%XTC_BLD )
IF(ASSOCIATED(T%CUR%XD_BLD  )) DEALLOCATE(T%CUR%XD_BLD  )
IF(ASSOCIATED(T%CUR%XHC_ALLBLD )) DEALLOCATE(T%CUR%XHC_ALLBLD )
IF(ASSOCIATED(T%CUR%XTC_ALLBLD )) DEALLOCATE(T%CUR%XTC_ALLBLD )
IF(ASSOCIATED(T%CUR%XD_ALLBLD  )) DEALLOCATE(T%CUR%XD_ALLBLD  )
IF(ASSOCIATED(T%CUR%XSVF_ROAD)) DEALLOCATE(T%CUR%XSVF_ROAD)
IF(ASSOCIATED(T%CUR%XSVF_WALL)) DEALLOCATE(T%CUR%XSVF_WALL)
IF(ASSOCIATED(T%CUR%XSVF_GARDEN)) DEALLOCATE(T%CUR%XSVF_GARDEN)
!
IF(ASSOCIATED(T%CUR%XSVF_HV))   DEALLOCATE(T%CUR%XSVF_HV)
IF(ASSOCIATED(T%CUR%XSVF_HV_R)) DEALLOCATE(T%CUR%XSVF_HV_R)
IF(ASSOCIATED(T%CUR%XSVF_R_HV)) DEALLOCATE(T%CUR%XSVF_R_HV)
IF(ASSOCIATED(T%CUR%XSVF_W_HV)) DEALLOCATE(T%CUR%XSVF_W_HV)
!
IF(ASSOCIATED(TPN%XEMIS_PANEL)) DEALLOCATE(TPN%XEMIS_PANEL)
IF(ASSOCIATED(TPN%XALB_PANEL )) DEALLOCATE(TPN%XALB_PANEL )
IF(ASSOCIATED(TPN%XEFF_PANEL )) DEALLOCATE(TPN%XEFF_PANEL )
IF(ASSOCIATED(TPN%XFRAC_PANEL)) DEALLOCATE(TPN%XFRAC_PANEL)
IF(ASSOCIATED(TPN%XTHER_PRODC_DAY)) DEALLOCATE(TPN%XTHER_PRODC_DAY)
!
IF (ASSOCIATED(T%CUR%XT_ROOF)) DEALLOCATE(T%CUR%XT_ROOF)
IF (ASSOCIATED(T%CUR%XT_ROAD)) DEALLOCATE(T%CUR%XT_ROAD)
IF (ASSOCIATED(T%CUR%XT_WALL_A)) DEALLOCATE(T%CUR%XT_WALL_A)
IF (ASSOCIATED(T%CUR%XT_WALL_B)) DEALLOCATE(T%CUR%XT_WALL_B)
IF (ASSOCIATED(T%CUR%XT_BLD  ))  DEALLOCATE(T%CUR%XT_BLD)
IF (ASSOCIATED(T%CUR%XT_ALLBLD))  DEALLOCATE(T%CUR%XT_ALLBLD)
IF (ASSOCIATED(T%CUR%XAC_ROOF)) DEALLOCATE(T%CUR%XAC_ROOF)
IF (ASSOCIATED(T%CUR%XAC_ROAD)) DEALLOCATE(T%CUR%XAC_ROAD)
IF (ASSOCIATED(T%CUR%XAC_WALL)) DEALLOCATE(T%CUR%XAC_WALL)
IF (ASSOCIATED(T%CUR%XAC_TOP)) DEALLOCATE(T%CUR%XAC_TOP)
IF (ASSOCIATED(T%CUR%XAC_ROOF_WAT)) DEALLOCATE(T%CUR%XAC_ROOF_WAT)
IF (ASSOCIATED(T%CUR%XAC_ROAD_WAT)) DEALLOCATE(T%CUR%XAC_ROAD_WAT)
IF (ASSOCIATED(T%CUR%XQSAT_ROOF)) DEALLOCATE(T%CUR%XQSAT_ROOF)
IF (ASSOCIATED(T%CUR%XQSAT_ROAD)) DEALLOCATE(T%CUR%XQSAT_ROAD)
IF (ASSOCIATED(T%CUR%XDELT_ROOF)) DEALLOCATE(T%CUR%XDELT_ROOF)
IF (ASSOCIATED(T%CUR%XDELT_ROAD)) DEALLOCATE(T%CUR%XDELT_ROAD)
!
IF (ASSOCIATED(T%CUR%XTHEWALL   )) DEALLOCATE(T%CUR%XTHEWALL   )
IF (ASSOCIATED(T%CUR%XTHEROOF   )) DEALLOCATE(T%CUR%XTHEROOF   )
IF (ASSOCIATED(T%CUR%XTHEFLOOR  )) DEALLOCATE(T%CUR%XTHEFLOOR  )
IF (ASSOCIATED(T%CUR%XTHEMASS   )) DEALLOCATE(T%CUR%XTHEMASS   )
IF (ASSOCIATED(T%CUR%XTHEROAD   )) DEALLOCATE(T%CUR%XTHEROAD   )
IF (ASSOCIATED(T%CUR%XTHEAIRIN  )) DEALLOCATE(T%CUR%XTHEAIRIN  )
IF (ASSOCIATED(T%CUR%XTHETOTAL  )) DEALLOCATE(T%CUR%XTHETOTAL  )
IF (ASSOCIATED(T%CUR%XLATWATROOF)) DEALLOCATE(T%CUR%XLATWATROOF)
IF (ASSOCIATED(T%CUR%XLATWATROAD)) DEALLOCATE(T%CUR%XLATWATROAD)
IF (ASSOCIATED(T%CUR%XLATICEROOF)) DEALLOCATE(T%CUR%XLATICEROOF)
IF (ASSOCIATED(T%CUR%XLATICEROAD)) DEALLOCATE(T%CUR%XLATICEROAD)
IF (ASSOCIATED(T%CUR%XLATAIRIN  )) DEALLOCATE(T%CUR%XLATAIRIN  )
IF (ASSOCIATED(T%CUR%XLATTOTAL  )) DEALLOCATE(T%CUR%XLATTOTAL  )
IF (ASSOCIATED(T%CUR%XENETOTAL  )) DEALLOCATE(T%CUR%XENETOTAL  )
!
!-------------------------------------------------------------------------------------
!
IF(ASSOCIATED(T%CUR%XAC_ROOF    ))  DEALLOCATE(T%CUR%XAC_ROOF    )
IF(ASSOCIATED(T%CUR%XAC_ROAD    ))  DEALLOCATE(T%CUR%XAC_ROAD    )
IF(ASSOCIATED(T%CUR%XAC_WALL    ))  DEALLOCATE(T%CUR%XAC_WALL    )
IF(ASSOCIATED(T%CUR%XAC_TOP     ))  DEALLOCATE(T%CUR%XAC_TOP     )
IF(ASSOCIATED(T%CUR%XAC_ROOF_WAT))  DEALLOCATE(T%CUR%XAC_ROOF_WAT)
IF(ASSOCIATED(T%CUR%XAC_ROAD_WAT))  DEALLOCATE(T%CUR%XAC_ROAD_WAT)
IF(ASSOCIATED(T%CUR%XQSAT_ROOF  ))  DEALLOCATE(T%CUR%XQSAT_ROOF  )
IF(ASSOCIATED(T%CUR%XQSAT_ROAD  ))  DEALLOCATE(T%CUR%XQSAT_ROAD  )
IF(ASSOCIATED(T%CUR%XDELT_ROOF  ))  DEALLOCATE(T%CUR%XDELT_ROOF  )
IF(ASSOCIATED(T%CUR%XDELT_ROAD  ))  DEALLOCATE(T%CUR%XDELT_ROAD  )
!
!-------------------------------------------------------------------------------------
!
IF(ASSOCIATED(CHT%XDEP))      DEALLOCATE(CHT%XDEP)
IF(ASSOCIATED(CHT%CCH_NAMES)) DEALLOCATE(CHT%CCH_NAMES)
IF(ASSOCIATED(CHT%SVT%CSV))       DEALLOCATE(CHT%SVT%CSV)
!
!-------------------------------------------------------------------------------------
!
IF(ASSOCIATED(DTT%XPAR_Z0_TOWN    )) DEALLOCATE(DTT%XPAR_Z0_TOWN    )
IF(ASSOCIATED(DTT%XPAR_BLD        )) DEALLOCATE(DTT%XPAR_BLD        )
IF(ASSOCIATED(DTT%XPAR_ALB_ROOF   )) DEALLOCATE(DTT%XPAR_ALB_ROOF   )
IF(ASSOCIATED(DTT%XPAR_EMIS_ROOF  )) DEALLOCATE(DTT%XPAR_EMIS_ROOF  )
IF(ASSOCIATED(DTT%XPAR_HC_ROOF    )) DEALLOCATE(DTT%XPAR_HC_ROOF    )
IF(ASSOCIATED(DTT%XPAR_TC_ROOF    )) DEALLOCATE(DTT%XPAR_TC_ROOF    )
IF(ASSOCIATED(DTT%XPAR_D_ROOF     )) DEALLOCATE(DTT%XPAR_D_ROOF     )
IF(ASSOCIATED(DTT%XPAR_ALB_ROAD   )) DEALLOCATE(DTT%XPAR_ALB_ROAD   )
IF(ASSOCIATED(DTT%XPAR_EMIS_ROAD  )) DEALLOCATE(DTT%XPAR_EMIS_ROAD  )
IF(ASSOCIATED(DTT%XPAR_HC_ROAD    )) DEALLOCATE(DTT%XPAR_HC_ROAD    )
IF(ASSOCIATED(DTT%XPAR_TC_ROAD    )) DEALLOCATE(DTT%XPAR_TC_ROAD    )
IF(ASSOCIATED(DTT%XPAR_D_ROAD     )) DEALLOCATE(DTT%XPAR_D_ROAD     )
IF(ASSOCIATED(DTT%XPAR_ALB_WALL   )) DEALLOCATE(DTT%XPAR_ALB_WALL   )
IF(ASSOCIATED(DTT%XPAR_EMIS_WALL  )) DEALLOCATE(DTT%XPAR_EMIS_WALL  )
IF(ASSOCIATED(DTT%XPAR_HC_WALL    )) DEALLOCATE(DTT%XPAR_HC_WALL    )
IF(ASSOCIATED(DTT%XPAR_TC_WALL    )) DEALLOCATE(DTT%XPAR_TC_WALL    )
IF(ASSOCIATED(DTT%XPAR_D_WALL     )) DEALLOCATE(DTT%XPAR_D_WALL     )
IF(ASSOCIATED(DTT%XPAR_BLD_HEIGHT )) DEALLOCATE(DTT%XPAR_BLD_HEIGHT )
IF(ASSOCIATED(DTT%XPAR_WALL_O_HOR )) DEALLOCATE(DTT%XPAR_WALL_O_HOR )
IF(ASSOCIATED(DTT%XPAR_H_TRAFFIC  )) DEALLOCATE(DTT%XPAR_H_TRAFFIC  )
IF(ASSOCIATED(DTT%XPAR_LE_TRAFFIC )) DEALLOCATE(DTT%XPAR_LE_TRAFFIC )
IF(ASSOCIATED(DTT%XPAR_H_INDUSTRY )) DEALLOCATE(DTT%XPAR_H_INDUSTRY )
IF(ASSOCIATED(DTT%XPAR_LE_INDUSTRY)) DEALLOCATE(DTT%XPAR_LE_INDUSTRY)
IF(ASSOCIATED(DTT%XPAR_GARDEN     )) DEALLOCATE(DTT%XPAR_GARDEN     )
IF(ASSOCIATED(DTT%XPAR_ROAD_DIR   )) DEALLOCATE(DTT%XPAR_ROAD_DIR   )
IF(ASSOCIATED(DTT%NPAR_BLDTYPE    )) DEALLOCATE(DTT%NPAR_BLDTYPE    )
IF(ASSOCIATED(DTT%NPAR_IND_BLD_AGE)) DEALLOCATE(DTT%NPAR_IND_BLD_AGE)
IF(ASSOCIATED(DTT%NPAR_COL_BLD_AGE)) DEALLOCATE(DTT%NPAR_COL_BLD_AGE)
IF(ASSOCIATED(DTT%NPAR_BLDCODE    )) DEALLOCATE(DTT%NPAR_BLDCODE    )
IF(ASSOCIATED(DTT%NPAR_USETYPE    )) DEALLOCATE(DTT%NPAR_USETYPE    )
IF(ASSOCIATED(DTT%NPAR_P1TERRITORY)) DEALLOCATE(DTT%NPAR_P1TERRITORY)
IF(ASSOCIATED(DTT%NPAR_PXTERRITORY)) DEALLOCATE(DTT%NPAR_PXTERRITORY)
IF(ASSOCIATED(DTT%XPAR_FRACIHS    )) DEALLOCATE(DTT%XPAR_FRACIHS)
IF(ASSOCIATED(DTT%XPAR_FRACCHS    )) DEALLOCATE(DTT%XPAR_FRACCHS)
IF(ASSOCIATED(DTT%XPAR_FRACCOM    )) DEALLOCATE(DTT%XPAR_FRACCOM)
IF(ASSOCIATED(DTT%XPAR_FRACTER    )) DEALLOCATE(DTT%XPAR_FRACTER)
IF(ASSOCIATED(DTT%XPAR_FRACIND    )) DEALLOCATE(DTT%XPAR_FRACIND)
IF(ASSOCIATED(DTT%XPAR_FRACPAV    )) DEALLOCATE(DTT%XPAR_FRACPAV)
IF(ASSOCIATED(DTT%XPAR_FRACMRI    )) DEALLOCATE(DTT%XPAR_FRACMRI)
IF(ASSOCIATED(DTT%XPAR_FRACHRI    )) DEALLOCATE(DTT%XPAR_FRACHRI)
IF(ASSOCIATED(DTT%XPAR_FRACATB    )) DEALLOCATE(DTT%XPAR_FRACATB)
IF(ASSOCIATED(DTT%XPAR_FOEQI_MAIS )) DEALLOCATE(DTT%XPAR_FOEQI_MAIS)
IF(ASSOCIATED(DTT%XPAR_FOEQI_APPT )) DEALLOCATE(DTT%XPAR_FOEQI_APPT)
IF(ASSOCIATED(DTT%XPAR_FAEQI_MAIS )) DEALLOCATE(DTT%XPAR_FAEQI_MAIS)
IF(ASSOCIATED(DTT%XPAR_FAEQI_APPT )) DEALLOCATE(DTT%XPAR_FAEQI_APPT)
IF(ASSOCIATED(DTT%XPAR_CRE_MAIS   )) DEALLOCATE(DTT%XPAR_CRE_MAIS)
IF(ASSOCIATED(DTT%XPAR_CRE_APPT   )) DEALLOCATE(DTT%XPAR_CRE_APPT)
IF(ASSOCIATED(DTT%XPAR_EFF_HEAT   )) DEALLOCATE(DTT%XPAR_EFF_HEAT)
!
!-------------------------------------------------------------------------------------
!
IF(ASSOCIATED(B%CUR%XHC_FLOOR   ))  DEALLOCATE(B%CUR%XHC_FLOOR   )
IF(ASSOCIATED(B%CUR%XTC_FLOOR   ))  DEALLOCATE(B%CUR%XTC_FLOOR   )
IF(ASSOCIATED(B%CUR%XD_FLOOR    ))  DEALLOCATE(B%CUR%XD_FLOOR    )
!
IF(ASSOCIATED(B%CUR%XHC_MASS   ))  DEALLOCATE(B%CUR%XHC_MASS   )
IF(ASSOCIATED(B%CUR%XTC_MASS   ))  DEALLOCATE(B%CUR%XTC_MASS   )
IF(ASSOCIATED(B%CUR%XD_MASS    ))  DEALLOCATE(B%CUR%XD_MASS    )
!
IF(ASSOCIATED(B%CUR%XF_WASTE_CAN))  DEALLOCATE(B%CUR%XF_WASTE_CAN)
IF(ASSOCIATED(B%CUR%XQIN        ))  DEALLOCATE(B%CUR%XQIN        )
IF(ASSOCIATED(B%CUR%XQIN_FRAD   ))  DEALLOCATE(B%CUR%XQIN_FRAD   )
IF(ASSOCIATED(B%CUR%XSHGC       ))  DEALLOCATE(B%CUR%XSHGC       )
IF(ASSOCIATED(B%CUR%XU_WIN      ))  DEALLOCATE(B%CUR%XU_WIN      )
IF(ASSOCIATED(B%CUR%XTRAN_WIN   ))  DEALLOCATE(B%CUR%XTRAN_WIN   )
IF(ASSOCIATED(B%CUR%XGR         ))  DEALLOCATE(B%CUR%XGR         )
IF(ASSOCIATED(B%CUR%XFLOOR_HEIGHT)) DEALLOCATE(B%CUR%XFLOOR_HEIGHT)
IF(ASSOCIATED(B%CUR%XN50        ))  DEALLOCATE(B%CUR%XN50        )
!
IF(ASSOCIATED(B%CUR%XQIN_FLAT   ))  DEALLOCATE(B%CUR%XQIN_FLAT   )
IF(ASSOCIATED(B%CUR%XHR_TARGET  ))  DEALLOCATE(B%CUR%XHR_TARGET  )
IF(ASSOCIATED(B%CUR%XCAP_SYS_HEAT)) DEALLOCATE(B%CUR%XCAP_SYS_HEAT)
IF(ASSOCIATED(B%CUR%XCAP_SYS_RAT))  DEALLOCATE(B%CUR%XCAP_SYS_RAT)
IF(ASSOCIATED(B%CUR%XT_ADP      ))  DEALLOCATE(B%CUR%XT_ADP      )
IF(ASSOCIATED(B%CUR%XM_SYS_RAT  ))  DEALLOCATE(B%CUR%XM_SYS_RAT  )
IF(ASSOCIATED(B%CUR%XCOP_RAT    ))  DEALLOCATE(B%CUR%XCOP_RAT    )
IF(ASSOCIATED(B%CUR%XT_SIZE_MAX ))  DEALLOCATE(B%CUR%XT_SIZE_MAX )
IF(ASSOCIATED(B%CUR%XT_SIZE_MIN ))  DEALLOCATE(B%CUR%XT_SIZE_MIN )

IF(ASSOCIATED(B%CUR%XMODQIN_VCD))  DEALLOCATE(B%CUR%XMODQIN_VCD)
IF(ASSOCIATED(B%CUR%XMODQIN_VLD))  DEALLOCATE(B%CUR%XMODQIN_VLD)
IF(ASSOCIATED(B%CUR%XMODQIN_NIG))  DEALLOCATE(B%CUR%XMODQIN_NIG)
IF(ASSOCIATED(B%CUR%XFVSUM))  DEALLOCATE(B%CUR%XFVSUM)
IF(ASSOCIATED(B%CUR%XFVNIG))  DEALLOCATE(B%CUR%XFVNIG)
IF(ASSOCIATED(B%CUR%XFVSHO))  DEALLOCATE(B%CUR%XFVSHO)
IF(ASSOCIATED(B%CUR%XTDESV))  DEALLOCATE(B%CUR%XTDESV)
IF(ASSOCIATED(B%CUR%XFVVAC))  DEALLOCATE(B%CUR%XFVVAC)
IF(ASSOCIATED(B%CUR%XFOPEN))  DEALLOCATE(B%CUR%XFOPEN)
IF(ASSOCIATED(B%CUR%XFSSUM))  DEALLOCATE(B%CUR%XFSSUM)
IF(ASSOCIATED(B%CUR%XFSNIG))  DEALLOCATE(B%CUR%XFSNIG)
IF(ASSOCIATED(B%CUR%XFSVAC))  DEALLOCATE(B%CUR%XFSVAC)
IF(ASSOCIATED(B%CUR%XWIN_SW_MAX))  DEALLOCATE(B%CUR%XWIN_SW_MAX)
IF(ASSOCIATED(B%CUR%XDAYWBEG_SCHED))  DEALLOCATE(B%CUR%XDAYWBEG_SCHED)
IF(ASSOCIATED(B%CUR%XHOURBEG_SCHED))  DEALLOCATE(B%CUR%XHOURBEG_SCHED)
IF(ASSOCIATED(B%CUR%XBEG_HOLIDAY))  DEALLOCATE(B%CUR%XBEG_HOLIDAY)
IF(ASSOCIATED(B%CUR%XEND_HOLIDAY))  DEALLOCATE(B%CUR%XEND_HOLIDAY)
IF(ASSOCIATED(B%CUR%XMOD_HOLIDAY))  DEALLOCATE(B%CUR%XMOD_HOLIDAY)
IF(ASSOCIATED(B%CUR%XPROBOCC))  DEALLOCATE(B%CUR%XPROBOCC)
IF(ASSOCIATED(B%CUR%XF_WASTE_CAN))  DEALLOCATE(B%CUR%XF_WASTE_CAN)
!
IF(ASSOCIATED(B%CUR%XABS_WIN    ))  DEALLOCATE(B%CUR%XABS_WIN    )
IF(ASSOCIATED(B%CUR%XALB_WIN    ))  DEALLOCATE(B%CUR%XALB_WIN    )
IF(ASSOCIATED(B%CUR%XUGG_WIN    ))  DEALLOCATE(B%CUR%XUGG_WIN    )
IF(ASSOCIATED(B%CUR%XSHADEARCHI ))  DEALLOCATE(B%CUR%XSHADEARCHI )
!
IF(ASSOCIATED(B%CUR%XISMECH ))      DEALLOCATE(B%CUR%XISMECH)
IF(ASSOCIATED(B%CUR%XMECHRATE ))    DEALLOCATE(B%CUR%XMECHRATE)
IF(ASSOCIATED(B%CUR%XF_WATER_COND)) DEALLOCATE(B%CUR%XF_WATER_COND)
IF(ASSOCIATED(B%CUR%XSHGC_SH    ))  DEALLOCATE(B%CUR%XSHGC_SH)
!
IF(ASSOCIATED(DTT%XPAR_ROUGH_ROOF ))  DEALLOCATE(DTT%XPAR_ROUGH_ROOF)
IF(ASSOCIATED(DTT%XPAR_ROUGH_WALL ))  DEALLOCATE(DTT%XPAR_ROUGH_WALL)
IF(ASSOCIATED(T%CUR%XROUGH_ROOF ))  DEALLOCATE(T%CUR%XROUGH_ROOF)
IF(ASSOCIATED(T%CUR%XROUGH_WALL ))  DEALLOCATE(T%CUR%XROUGH_WALL)
!
IF(ASSOCIATED(B%CUR%XN_FLOOR ))  DEALLOCATE(B%CUR%XN_FLOOR)
IF(ASSOCIATED(B%CUR%XGLAZ_O_BLD ))  DEALLOCATE(B%CUR%XGLAZ_O_BLD)
IF(ASSOCIATED(B%CUR%XMASS_O_BLD ))  DEALLOCATE(B%CUR%XMASS_O_BLD)
IF(ASSOCIATED(B%CUR%XFLOOR_HW_RATIO ))  DEALLOCATE(B%CUR%XFLOOR_HW_RATIO)
IF(ASSOCIATED(B%CUR%XF_FLOOR_MASS ))  DEALLOCATE(B%CUR%XF_FLOOR_MASS)
IF(ASSOCIATED(B%CUR%XF_FLOOR_WALL ))  DEALLOCATE(B%CUR%XF_FLOOR_WALL)
IF(ASSOCIATED(B%CUR%XF_FLOOR_WIN ))  DEALLOCATE(B%CUR%XF_FLOOR_WIN)
IF(ASSOCIATED(B%CUR%XF_FLOOR_ROOF ))  DEALLOCATE(B%CUR%XF_FLOOR_ROOF)
IF(ASSOCIATED(B%CUR%XF_WALL_FLOOR ))  DEALLOCATE(B%CUR%XF_WALL_FLOOR)
IF(ASSOCIATED(B%CUR%XF_WALL_MASS ))  DEALLOCATE(B%CUR%XF_WALL_MASS)
IF(ASSOCIATED(B%CUR%XF_WALL_WIN ))  DEALLOCATE(B%CUR%XF_WALL_WIN)
IF(ASSOCIATED(B%CUR%XF_WIN_FLOOR ))  DEALLOCATE(B%CUR%XF_WIN_FLOOR)
IF(ASSOCIATED(B%CUR%XF_WIN_MASS ))  DEALLOCATE(B%CUR%XF_WIN_MASS)
IF(ASSOCIATED(B%CUR%XF_WIN_WALL ))  DEALLOCATE(B%CUR%XF_WIN_WALL)
IF(ASSOCIATED(B%CUR%XF_MASS_FLOOR ))  DEALLOCATE(B%CUR%XF_MASS_FLOOR)
IF(ASSOCIATED(B%CUR%XF_MASS_WALL ))  DEALLOCATE(B%CUR%XF_MASS_WALL)
IF(ASSOCIATED(B%CUR%XF_MASS_WIN ))  DEALLOCATE(B%CUR%XF_MASS_WIN)
IF(ASSOCIATED(B%CUR%XTI_BLD ))  DEALLOCATE(B%CUR%XTI_BLD)
IF(ASSOCIATED(B%CUR%XQI_BLD ))  DEALLOCATE(B%CUR%XQI_BLD)
IF(ASSOCIATED(B%CUR%XT_FLOOR ))  DEALLOCATE(B%CUR%XT_FLOOR)
IF(ASSOCIATED(B%CUR%XT_MASS ))  DEALLOCATE(B%CUR%XT_MASS)
IF(ASSOCIATED(B%CUR%XAUX_MAX ))  DEALLOCATE(B%CUR%XAUX_MAX)
IF(ASSOCIATED(B%CUR%XPSOLD ))  DEALLOCATE(B%CUR%XPSOLD)
IF(ASSOCIATED(B%CUR%XSHADVACSW ))  DEALLOCATE(B%CUR%XSHADVACSW)
IF(ASSOCIATED(B%CUR%XVENTNIGSW ))  DEALLOCATE(B%CUR%XVENTNIGSW)
IF(ASSOCIATED(B%CUR%XT_WIN2 ))  DEALLOCATE(B%CUR%XT_WIN2)
IF(ASSOCIATED(B%CUR%XT_WIN1 ))  DEALLOCATE(B%CUR%XT_WIN1)
!
IF(ASSOCIATED(B%CUR%XTHEAT_OCCD)) DEALLOCATE(B%CUR%XTHEAT_OCCD)
IF(ASSOCIATED(B%CUR%XTHEAT_OCCN)) DEALLOCATE(B%CUR%XTHEAT_OCCN)
IF(ASSOCIATED(B%CUR%XTHEAT_VCDD)) DEALLOCATE(B%CUR%XTHEAT_VCDD)
IF(ASSOCIATED(B%CUR%XTHEAT_VCDN)) DEALLOCATE(B%CUR%XTHEAT_VCDN)
IF(ASSOCIATED(B%CUR%XTHEAT_VCLD)) DEALLOCATE(B%CUR%XTHEAT_VCLD)
IF(ASSOCIATED(B%CUR%XTCOOL_OCCD)) DEALLOCATE(B%CUR%XTCOOL_OCCD)
IF(ASSOCIATED(B%CUR%XTCOOL_OCCN)) DEALLOCATE(B%CUR%XTCOOL_OCCN)
IF(ASSOCIATED(B%CUR%XTCOOL_VCDD)) DEALLOCATE(B%CUR%XTCOOL_VCDD)
IF(ASSOCIATED(B%CUR%XTCOOL_VCDN)) DEALLOCATE(B%CUR%XTCOOL_VCDN)
IF(ASSOCIATED(B%CUR%XTCOOL_VCLD)) DEALLOCATE(B%CUR%XTCOOL_VCLD)
!
IF (LHOOK) CALL DR_HOOK('DEALLOC_TEB_N',1,ZHOOK_HANDLE)
!
!-------------------------------------------------------------------------------------
!
END SUBROUTINE DEALLOC_TEB_n


