!     ###############################################################################
SUBROUTINE COUPLING_TEB_n (DTCO, DTI, IG, I, DST, SLT, TM, GDM, GRM, HM,                   &
                           HPROGRAM, HCOUPLING,                                            &
               PTSTEP, KYEAR, KMONTH, KDAY, PTIME, KI, KSV, KSW, PTSUN, PZENITH, PAZIM,    &
               PZREF, PUREF, PZS, PU, PV, PQA, PTA, PRHOA, PSV, PCO2, HSV,                 &
               PRAIN, PSNOW, PLW, PDIR_SW, PSCA_SW, PSW_BANDS, PPS, PPA,                   &
               PSFTQ, PSFTH, PSFTS, PSFCO2, PSFU, PSFV,                                    &
               PTRAD, PDIR_ALB, PSCA_ALB, PEMIS, PTSURF, PZ0, PZ0H, PQSURF,                &
               PPEW_A_COEF, PPEW_B_COEF,                                                   &
               PPET_A_COEF, PPEQ_A_COEF, PPET_B_COEF, PPEQ_B_COEF,                         &
               HTEST                                                                       )
!     ###############################################################################
!
!!****  *COUPLING_TEB_n * - Driver for TEB 
!!
!!    PURPOSE
!!    -------
!
!!**  METHOD
!!    ------
!!
!!    REFERENCE
!!    ---------
!!      
!!
!!    AUTHOR
!!    ------
!!     V. Masson 
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    01/2004
!!                  10/2005 (G.Pigeon) transfer of domestic heating
!!      S. Riette   06/2009 Initialisation of XT, XQ, XU and XTKE on canopy levels
!!      S. Riette   01/2010 Use of interpol_sbl to compute 10m wind diagnostic
!!      G. Pigeon   09/2012 CCH_BEM, ROUGH_WALL, ROUGH_ROOF for building conv. coef
!!      G. Pigeon   10/2012 XF_WIN_WIN as arg. of TEB_GARDEN
!!      B. Decharme 09/2012 New wind implicitation
!!      J. Escobar  09/2012 KI not allowed without-interface , replace by KI
!!      V. Masson   08/2013 adds solar panels & occupation calendar
!!      B. Decharme  04/2013 new coupling variables
!!---------------------------------------------------------------
!
USE MODD_DATA_COVER_n, ONLY : DATA_COVER_t
USE MODD_DATA_ISBA_n, ONLY : DATA_ISBA_t
USE MODD_ISBA_GRID_n, ONLY : ISBA_GRID_t
USE MODD_ISBA_n, ONLY : ISBA_t
USE MODD_DST_n, ONLY : DST_t
USE MODD_SLT_n, ONLY : SLT_t
USE MODD_SURFEX_n, ONLY : TEB_MODEL_t
USE MODD_SURFEX_n, ONLY : TEB_GARDEN_MODEL_t
USE MODD_SURFEX_n, ONLY : TEB_GREENROOF_MODEL_t
USE MODD_SURFEX_n, ONLY : TEB_HYDRO_MODEL_t
!
USE MODD_REPROD_OPER, ONLY : CIMPLICIT_WIND
!
USE MODD_CSTS,         ONLY : XRD, XCPD, XP00, XLVTT, XLSTT, &
                              XPI, XKARMAN, XG, XRV, XSTEFAN, XTT
USE MODD_SURF_PAR,     ONLY : XUNDEF
!
!                              
USE MODD_DST_SURF
USE MODD_SLT_SURF
!
!
USE MODE_DSLT_SURF
USE MODE_THERMOS
USE MODE_SBLS
!
USE MODI_GOTO_WRAPPER_TEB_PATCH
USE MODI_AVERAGE_RAD
USE MODI_SM10
USE MODI_ADD_FORECAST_TO_DATE_SURF
USE MODI_DIAG_INLINE_TEB_n
USE MODI_DIAG_MISC_TEB_n
USE MODI_CH_AER_DEP
USE MODI_CH_DEP_TOWN
USE MODI_DSLT_DEP
USE MODI_TEB_GARDEN
USE MODI_TEB_CANOPY
! 
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
USE MODI_ABOR1_SFX
USE MODI_CANOPY_EVOL
USE MODI_CANOPY_GRID_UPDATE
USE MODI_UTCI_TEB
USE MODI_UTCIC_STRESS
USE MODI_CIRCUMSOLAR_RAD
!
IMPLICIT NONE
!
!*      0.1    declarations of arguments
!
!
!
TYPE(DATA_COVER_t), INTENT(INOUT) :: DTCO
TYPE(DATA_ISBA_t), INTENT(INOUT) :: DTI
TYPE(ISBA_GRID_t), INTENT(INOUT) :: IG
TYPE(ISBA_t), INTENT(INOUT) :: I
TYPE(DST_t), INTENT(INOUT) :: DST
TYPE(SLT_t), INTENT(INOUT) :: SLT
TYPE(TEB_MODEL_t), INTENT(INOUT) :: TM
TYPE(TEB_GARDEN_MODEL_t), INTENT(INOUT) :: GDM
TYPE(TEB_GREENROOF_MODEL_t), INTENT(INOUT) :: GRM
TYPE(TEB_HYDRO_MODEL_t), INTENT(INOUT) :: HM
!
 CHARACTER(LEN=6),    INTENT(IN)  :: HPROGRAM  ! program calling surf. schemes
 CHARACTER(LEN=1),    INTENT(IN)  :: HCOUPLING ! type of coupling
                                              ! 'E' : explicit
                                              ! 'I' : implicit
INTEGER,             INTENT(IN)  :: KYEAR     ! current year (UTC)
INTEGER,             INTENT(IN)  :: KMONTH    ! current month (UTC)
INTEGER,             INTENT(IN)  :: KDAY      ! current day (UTC)
REAL,                INTENT(IN)  :: PTIME     ! current time since midnight (UTC, s)
INTEGER,             INTENT(IN)  :: KI        ! number of points
INTEGER,             INTENT(IN)  :: KSV       ! number of scalars
INTEGER,             INTENT(IN)  :: KSW       ! number of short-wave spectral bands
REAL, DIMENSION(KI), INTENT(IN)  :: PTSUN     ! solar time                    (s from midnight)
REAL,                INTENT(IN)  :: PTSTEP    ! atmospheric time-step                 (s)
REAL, DIMENSION(KI), INTENT(IN)  :: PZREF     ! height of T,q forcing                 (m)
REAL, DIMENSION(KI), INTENT(IN)  :: PUREF     ! height of wind forcing                (m)
!
REAL, DIMENSION(KI), INTENT(IN)  :: PTA       ! air temperature forcing               (K)
REAL, DIMENSION(KI), INTENT(IN)  :: PQA       ! air humidity forcing                  (kg/m3)
REAL, DIMENSION(KI), INTENT(IN)  :: PRHOA     ! air density                           (kg/m3)
REAL, DIMENSION(KI,KSV),INTENT(IN) :: PSV     ! scalar variables
!                                             ! chemistry:   first char. in HSV: '#'  (molecule/m3)
!                                             !
 CHARACTER(LEN=6), DIMENSION(KSV),INTENT(IN):: HSV  ! name of all scalar variables
REAL, DIMENSION(KI), INTENT(IN)  :: PU        ! zonal wind                            (m/s)
REAL, DIMENSION(KI), INTENT(IN)  :: PV        ! meridian wind                         (m/s)
REAL, DIMENSION(KI,KSW),INTENT(IN) :: PDIR_SW ! direct  solar radiation (on horizontal surf.)
!                                             !                                       (W/m2)
REAL, DIMENSION(KI,KSW),INTENT(IN) :: PSCA_SW ! diffuse solar radiation (on horizontal surf.)
!                                             !                                       (W/m2)
REAL, DIMENSION(KSW),INTENT(IN)  :: PSW_BANDS ! mean wavelength of each shortwave band (m)
REAL, DIMENSION(KI), INTENT(IN)  :: PZENITH   ! zenithal angle       (radian from the vertical)
REAL, DIMENSION(KI), INTENT(IN)  :: PAZIM     ! azimuthal angle      (radian from North, clockwise)
REAL, DIMENSION(KI), INTENT(IN)  :: PLW       ! longwave radiation (on horizontal surf.)
!                                             !                                       (W/m2)
REAL, DIMENSION(KI), INTENT(IN)  :: PPS       ! pressure at atmospheric model surface (Pa)
REAL, DIMENSION(KI), INTENT(IN)  :: PPA       ! pressure at forcing level             (Pa)
REAL, DIMENSION(KI), INTENT(IN)  :: PZS       ! atmospheric model orography           (m)
REAL, DIMENSION(KI), INTENT(IN)  :: PCO2      ! CO2 concentration in the air          (kg/m3)
!
! CAUTION: modified status
!
REAL, DIMENSION(KI), INTENT(INOUT) :: PSNOW     ! snow precipitation                    (kg/m2/s)
REAL, DIMENSION(KI), INTENT(INOUT) :: PRAIN     ! liquid precipitation                  (kg/m2/s)
!
REAL, DIMENSION(KI), INTENT(OUT) :: PSFTH     ! flux of heat                          (W/m2)
REAL, DIMENSION(KI), INTENT(OUT) :: PSFTQ     ! flux of water vapor                   (kg/m2/s)
REAL, DIMENSION(KI), INTENT(OUT) :: PSFU      ! zonal momentum flux                   (Pa)
REAL, DIMENSION(KI), INTENT(OUT) :: PSFV      ! meridian momentum flux                (Pa)
REAL, DIMENSION(KI), INTENT(OUT) :: PSFCO2    ! flux of CO2                           (kg/m2/s)
REAL, DIMENSION(KI,KSV),INTENT(OUT):: PSFTS   ! flux of scalar var.                   (kg/m2/s)
!
REAL, DIMENSION(KI), INTENT(OUT) :: PTRAD     ! radiative temperature                 (K)
REAL, DIMENSION(KI,KSW),INTENT(OUT):: PDIR_ALB! direct albedo for each spectral band  (-)
REAL, DIMENSION(KI,KSW),INTENT(OUT):: PSCA_ALB! diffuse albedo for each spectral band (-)
REAL, DIMENSION(KI), INTENT(OUT) :: PEMIS     ! emissivity                            (-)
!
REAL, DIMENSION(KI), INTENT(OUT) :: PTSURF    ! surface effective temperature         (K)
REAL, DIMENSION(KI), INTENT(OUT) :: PZ0       ! roughness length for momentum         (m)
REAL, DIMENSION(KI), INTENT(OUT) :: PZ0H      ! roughness length for heat             (m)
REAL, DIMENSION(KI), INTENT(OUT) :: PQSURF    ! specific humidity at surface          (kg/kg)
!
REAL, DIMENSION(KI), INTENT(IN) :: PPEW_A_COEF! implicit coefficients
REAL, DIMENSION(KI), INTENT(IN) :: PPEW_B_COEF! needed if HCOUPLING='I'
REAL, DIMENSION(KI), INTENT(IN) :: PPET_A_COEF
REAL, DIMENSION(KI), INTENT(IN) :: PPEQ_A_COEF
REAL, DIMENSION(KI), INTENT(IN) :: PPET_B_COEF
REAL, DIMENSION(KI), INTENT(IN) :: PPEQ_B_COEF
 CHARACTER(LEN=2),    INTENT(IN) :: HTEST ! must be equal to 'OK'
!
!
!*      0.2    declarations of local variables
!
INTEGER              :: JSWB                ! loop counter on shortwave spectral bands
!         
REAL, DIMENSION(KI)  :: ZQA                 ! specific humidity                 (kg/kg)
REAL, DIMENSION(KI)  :: ZEXNA               ! Exner function at forcing level
REAL, DIMENSION(KI)  :: ZEXNS               ! Exner function at surface level
REAL, DIMENSION(KI)  :: ZWIND               ! wind
!
! Ouput Diagnostics:
!
REAL, DIMENSION(KI)  :: ZU_CANYON           ! wind in canyon
REAL, DIMENSION(KI)  :: ZT_CANYON           ! temperature in canyon
REAL, DIMENSION(KI)  :: ZQ_CANYON           ! specific humidity in canyon
REAL, DIMENSION(KI)  :: ZT_CAN              ! temperature in canyon       (evolving in TEB)
REAL, DIMENSION(KI)  :: ZQ_CAN              ! specific humidity in canyon (evolving in TEB)
!
REAL, DIMENSION(KI)  :: ZRN_ROOF            ! net radiation on roof
REAL, DIMENSION(KI)  :: ZH_ROOF             ! sensible heat flux on roof
REAL, DIMENSION(KI)  :: ZLE_ROOF            ! latent heat flux on roof
REAL, DIMENSION(KI)  :: ZLEW_ROOF           ! latent heat flux on snowfree roof
REAL, DIMENSION(KI)  :: ZGFLUX_ROOF         ! storage flux in roof
REAL, DIMENSION(KI)  :: ZRUNOFF_ROOF        ! water runoff from roof
REAL, DIMENSION(KI)  :: ZRN_ROAD            ! net radiation on road
REAL, DIMENSION(KI)  :: ZH_ROAD             ! sensible heat flux on road
REAL, DIMENSION(KI)  :: ZLE_ROAD            ! latent heat flux on road
REAL, DIMENSION(KI)  :: ZLEW_ROAD           ! latent heat flux on snowfree road
REAL, DIMENSION(KI)  :: ZGFLUX_ROAD         ! storage flux in road
REAL, DIMENSION(KI)  :: ZRUNOFF_ROAD        ! water runoff from road
REAL, DIMENSION(KI)  :: ZIRRIG_ROAD         ! water supply from road summer watering
REAL, DIMENSION(KI)  :: ZRN_WALL_A          ! net radiation on walls
REAL, DIMENSION(KI)  :: ZH_WALL_A           ! sensible heat flux on walls
REAL, DIMENSION(KI)  :: ZLE_WALL_A          ! latent heat flux on walls
REAL, DIMENSION(KI)  :: ZGFLUX_WALL_A       ! storage flux in walls
REAL, DIMENSION(KI)  :: ZRN_WALL_B          ! net radiation on walls
REAL, DIMENSION(KI)  :: ZH_WALL_B           ! sensible heat flux on walls
REAL, DIMENSION(KI)  :: ZLE_WALL_B          ! latent heat flux on walls
REAL, DIMENSION(KI)  :: ZGFLUX_WALL_B       ! storage flux in walls
REAL, DIMENSION(KI)  :: ZRN_GARDEN          ! net radiation on green areas
REAL, DIMENSION(KI)  :: ZH_GARDEN           ! sensible heat flux on green areas
REAL, DIMENSION(KI)  :: ZLE_GARDEN          ! latent heat flux on green areas
REAL, DIMENSION(KI)  :: ZGFLUX_GARDEN       ! storage flux in green areas
REAL, DIMENSION(KI)  :: ZRUNOFF_GARDEN      ! runoff over green areas
REAL, DIMENSION(KI)  :: ZDRAIN_GARDEN       ! drainage from green soil
REAL, DIMENSION(KI)  :: ZIRRIG_GARDEN       ! water supply from garden summer irrigation 
REAL, DIMENSION(KI)  :: ZRN_GREENROOF       ! net radiation on green roofs
REAL, DIMENSION(KI)  :: ZH_GREENROOF        ! sensible heat flux on green roofs
REAL, DIMENSION(KI)  :: ZLE_GREENROOF       ! latent heat flux on green roofs
REAL, DIMENSION(KI)  :: ZGFLUX_GREENROOF    ! storage flux in green roofs
REAL, DIMENSION(KI)  :: ZG_GREENROOF_ROOF   ! heat flux between base of greenroof
REAL, DIMENSION(KI)  :: ZRUNOFF_GREENROOF   ! water runoff from green roof
REAL, DIMENSION(KI)  :: ZDRAIN_GREENROOF    ! water drainage from green roof
REAL, DIMENSION(KI)  :: ZIRRIG_GREENROOF    ! water supply from green roof summer irrigation 
REAL, DIMENSION(KI)  :: ZRN_STRLROOF        ! net radiation on structural roof
REAL, DIMENSION(KI)  :: ZH_STRLROOF         ! sensible heat flux on structural roof
REAL, DIMENSION(KI)  :: ZLE_STRLROOF        ! latent heat flux on structural roof
REAL, DIMENSION(KI)  :: ZGFLUX_STRLROOF     ! storage flux in structural roof
REAL, DIMENSION(KI)  :: ZRUNOFF_STRLROOF    ! runoff over structural roof
REAL, DIMENSION(KI)  :: ZH_PANEL            ! sensible heat flux on solar panel
REAL, DIMENSION(KI)  :: ZTHER_PROD_PANEL    ! thermal      energy production from solar panel (W/m2 panel)
REAL, DIMENSION(KI)  :: ZPHOT_PROD_PANEL    ! photovoltaic energy production from solar panel (W/m2 panel)
REAL, DIMENSION(KI)  :: ZPROD_PANEL         ! averaged     energy production from solar panel (W/m2 panel)
REAL, DIMENSION(KI)  :: ZTHER_PROD_BLD      ! thermal      energy production from solar panel (W/m2 bld)
REAL, DIMENSION(KI)  :: ZPHOT_PROD_BLD      ! photovoltaic energy production from solar panel (W/m2 bld)
REAL, DIMENSION(KI)  :: ZPROD_BLD           ! averaged     energy production from solar panel (W/m2 bld)
REAL, DIMENSION(KI)  :: ZRN_PANEL           ! net radiation of solar panel
REAL, DIMENSION(KI)  :: ZRN_BLT             ! net radiation on built surf 
REAL, DIMENSION(KI)  :: ZH_BLT              ! sensible heat flux on built surf 
REAL, DIMENSION(KI)  :: ZLE_BLT             ! latent heat flux on built surf 
REAL, DIMENSION(KI)  :: ZGFLUX_BLT          ! storage flux in built surf 
REAL, DIMENSION(KI)  :: ZRN_GRND            ! net radiation on ground built surf
REAL, DIMENSION(KI)  :: ZH_GRND             ! sensible heat flux on ground built surf
REAL, DIMENSION(KI)  :: ZLE_GRND            ! latent heat flux on ground built surf
REAL, DIMENSION(KI)  :: ZGFLUX_GRND         ! storage flux in ground built surf
REAL, DIMENSION(KI)  :: ZRNSNOW_ROOF        ! net radiation over snow
REAL, DIMENSION(KI)  :: ZHSNOW_ROOF         ! sensible heat flux over snow
REAL, DIMENSION(KI)  :: ZLESNOW_ROOF        ! latent heat flux over snow
REAL, DIMENSION(KI)  :: ZGSNOW_ROOF         ! flux under the snow
REAL, DIMENSION(KI)  :: ZMELT_ROOF          ! snow melt
REAL, DIMENSION(KI)  :: ZRNSNOW_ROAD        ! net radiation over snow
REAL, DIMENSION(KI)  :: ZHSNOW_ROAD         ! sensible heat flux over snow
REAL, DIMENSION(KI)  :: ZLESNOW_ROAD        ! latent heat flux over snow
REAL, DIMENSION(KI)  :: ZGSNOW_ROAD         ! flux under the snow
REAL, DIMENSION(KI)  :: ZMELT_ROAD          ! snow melt
REAL, DIMENSION(KI)  :: ZFLUXFLOOR          ! Heat flux into the ground floor
REAL, DIMENSION(KI)  :: ZFLX_BLD_ROOF       ! Heat exchange between roof and indoor air
REAL, DIMENSION(KI)  :: ZFLX_BLD_WALL_A     ! Heat exchange between wall A and indoor air
REAL, DIMENSION(KI)  :: ZFLX_BLD_WALL_B     ! Heat exchange between wall B and indoor air
!
REAL, DIMENSION(KI)  :: ZTRAD               ! radiative temperature for current patch
REAL, DIMENSION(KI)  :: ZEMIS                                  ! emissivity for current patch
REAL, DIMENSION(KI,TM%TOP%NTEB_PATCH)     :: ZTRAD_PATCH       ! radiative temperature for each patch
REAL, DIMENSION(KI,TM%TOP%NTEB_PATCH)     :: ZEMIS_PATCH       ! emissivity for each patch
REAL, DIMENSION(KI,KSW,TM%TOP%NTEB_PATCH) :: ZDIR_ALB_PATCH    ! direct albedo per wavelength and patch
REAL, DIMENSION(KI,KSW,TM%TOP%NTEB_PATCH) :: ZSCA_ALB_PATCH    ! diffuse albedo per wavelength and patch
!
REAL, DIMENSION(KI)  :: ZRN                 ! net radiation over town
REAL, DIMENSION(KI)  :: ZH                  ! sensible heat flux over town
REAL, DIMENSION(KI)  :: ZLE                 ! latent heat flux over town
REAL, DIMENSION(KI)  :: ZGFLUX              ! flux through the ground
REAL, DIMENSION(KI)  :: ZSFCO2              ! CO2 flux over town
REAL, DIMENSION(KI)  :: ZQF_BLD             ! domestic heating
REAL, DIMENSION(KI)  :: ZFLX_BLD            ! flux from bld
REAL, DIMENSION(KI)  :: ZDQS_TOWN           ! storage inside town materials
REAL, DIMENSION(KI)  :: ZQF_TOWN            ! total anthropogenic heat
REAL, DIMENSION(KI)  :: ZEVAP               ! evaporation (km/m2/s)
REAL, DIMENSION(KI)  :: ZRUNOFF_TOWN        ! runoff over the ground
REAL, DIMENSION(KI)  :: ZCD                 ! drag coefficient
REAL, DIMENSION(KI)  :: ZCDN                ! neutral drag coefficient
REAL, DIMENSION(KI)  :: ZCH                 ! heat drag
REAL, DIMENSION(KI)  :: ZRI                 ! Richardson number
REAL, DIMENSION(KI)  :: ZUW_GRND            ! momentum flux for ground built surf
REAL, DIMENSION(KI)  :: ZUW_ROOF            ! momentum flux for roofs
REAL, DIMENSION(KI)  :: ZDUWDU_GRND         !
REAL, DIMENSION(KI)  :: ZDUWDU_ROOF         !
REAL, DIMENSION(KI)  :: ZUSTAR              ! friction velocity
REAL, DIMENSION(KI)  :: ZSFU                ! momentum flux for patch (U direction)
REAL, DIMENSION(KI)  :: ZSFV                ! momentum flux for patch (V direction)
REAL, DIMENSION(KI)  :: ZAVG_DIR_ALB        ! direct albedo of town
REAL, DIMENSION(KI)  :: ZAVG_SCA_ALB        ! diffuse albedo of town
REAL, DIMENSION(KI)  :: ZAVG_T_CANYON       ! temperature in canyon for town 
REAL, DIMENSION(KI)  :: ZAVG_Q_CANYON       ! specific humidity in canyon for town
!
REAL, DIMENSION(KI)  :: ZAVG_CD             ! aggregated drag coefficient
REAL, DIMENSION(KI)  :: ZAVG_CDN            ! aggregated neutral drag coefficient
REAL, DIMENSION(KI)  :: ZAVG_RI             ! aggregated Richardson number
REAL, DIMENSION(KI)  :: ZAVG_CH             ! aggregated Heat transfer coefficient
!
REAL, DIMENSION(KI)  :: ZDIR_ALB            ! direct albedo of town
REAL, DIMENSION(KI)  :: ZSCA_ALB            ! diffuse albedo of town
!
REAL, DIMENSION(KI)  :: ZH_TRAFFIC          ! anthropogenic sensible
!                                           ! heat fluxes due to traffic
REAL, DIMENSION(KI)  :: ZLE_TRAFFIC         ! anthropogenic latent
!                                           ! heat fluxes due to traffic
REAL, DIMENSION(KI)  :: ZRESA_TOWN          ! aerodynamical resistance
REAL, DIMENSION(KI)  :: ZAC_ROAD            ! road aerodynamical conductance
REAL, DIMENSION(KI)  :: ZAC_GARDEN          ! green area aerodynamical conductance
REAL, DIMENSION(KI)  :: ZAC_GRND            ! ground built surf aerodynamical conductance
REAL, DIMENSION(KI)  :: ZAC_GREENROOF       ! green roof aerodynamical conductance
REAL, DIMENSION(KI)  :: ZAC_ROAD_WAT        ! road water aerodynamical conductance
REAL, DIMENSION(KI)  :: ZAC_GARDEN_WAT      ! green area water aerodynamical conductance
REAL, DIMENSION(KI)  :: ZAC_GRND_WAT        ! ground built surf water aerodynamical conductance
REAL, DIMENSION(KI)  :: ZAC_GREENROOF_WAT   ! green roof water aerodynamical conductance
REAL, DIMENSION(KI,1):: ZESNOW_GARDEN       ! green area snow emissivity
!
REAL                 :: ZBEGIN_TRAFFIC_TIME ! start traffic time (solar time, s)
REAL                 :: ZEND_TRAFFIC_TIME   ! end traffic time   (solar time, s)
REAL, DIMENSION(KI)  :: ZDIR_SW             ! total direct SW
REAL, DIMENSION(KI)  :: ZSCA_SW             ! total diffuse SW
REAL, DIMENSION(KI)  :: ZPEW_A_COEF         ! implicit coefficients
REAL, DIMENSION(KI)  :: ZPEW_B_COEF         ! needed if HCOUPLING='I'

!***** CANOPY  *****
REAL, DIMENSION(KI,TM%TCP%NLVL):: ZFORC_U   ! tendency due to drag force for wind
REAL, DIMENSION(KI,TM%TCP%NLVL):: ZDFORC_UDU! formal derivative of
!                                           ! tendency due to drag force for wind
REAL, DIMENSION(KI,TM%TCP%NLVL):: ZFORC_E   ! tendency due to drag force for TKE
REAL, DIMENSION(KI,TM%TCP%NLVL):: ZDFORC_EDE! formal derivative of
!                                           ! tendency due to drag force for TKE
REAL, DIMENSION(KI,TM%TCP%NLVL):: ZFORC_T   ! tendency due to drag force for Temp
REAL, DIMENSION(KI,TM%TCP%NLVL):: ZDFORC_TDT! formal derivative of
!                                           ! tendency due to drag force for Temp
REAL, DIMENSION(KI,TM%TCP%NLVL):: ZFORC_Q   ! tendency due to drag force for hum
REAL, DIMENSION(KI,TM%TCP%NLVL):: ZDFORC_QDQ! formal derivative of
!                                           ! tendency due to drag force for hum.
REAL, DIMENSION(KI)  :: ZSFLUX_U            ! Surface flux u'w' (m2/s2)
REAL, DIMENSION(KI)  :: ZSFLUX_T            ! Surface flux w'T' (mK/s)
REAL, DIMENSION(KI)  :: ZSFLUX_Q            ! Surface flux w'q' (kgm2/s)
!
REAL, DIMENSION(KI)  :: ZAVG_UW_GRND
REAL, DIMENSION(KI)  :: ZAVG_DUWDU_GRND
REAL, DIMENSION(KI)  :: ZAVG_UW_ROOF
REAL, DIMENSION(KI)  :: ZAVG_DUWDU_ROOF
REAL, DIMENSION(KI)  :: ZAVG_H_GRND
REAL, DIMENSION(KI)  :: ZAVG_H_WALL
REAL, DIMENSION(KI)  :: ZAVG_E_WALL
REAL, DIMENSION(KI)  :: ZAVG_H_ROOF
REAL, DIMENSION(KI)  :: ZAVG_E_GRND
REAL, DIMENSION(KI)  :: ZAVG_E_ROOF
REAL, DIMENSION(KI)  :: ZAVG_AC_GRND
REAL, DIMENSION(KI)  :: ZAVG_AC_GRND_WAT
REAL, DIMENSION(KI)  :: ZAVG_Z0_TOWN
REAL, DIMENSION(KI)  :: ZAVG_RESA_TOWN
REAL, DIMENSION(KI)  :: ZAVG_USTAR          ! town avegared Ustar
REAL, DIMENSION(KI)  :: ZAVG_BLD            ! town averaged building fraction
REAL, DIMENSION(KI)  :: ZAVG_BLD_HEIGHT     ! town averaged building height
REAL, DIMENSION(KI)  :: ZAVG_WALL_O_HOR     ! town averaged Wall/hor ratio
REAL, DIMENSION(KI)  :: ZAVG_CAN_HW_RATIO   ! town averaged road aspect ratio
REAL, DIMENSION(KI)  :: ZAVG_H
REAL, DIMENSION(KI)  :: ZAVG_LE
REAL, DIMENSION(KI)  :: ZAVG_RN
REAL, DIMENSION(KI)  :: ZAVG_GFLUX
REAL, DIMENSION(KI)  :: ZAVG_REF_SW_GRND
REAL, DIMENSION(KI)  :: ZAVG_REF_SW_FAC
REAL, DIMENSION(KI)  :: ZAVG_REF_SW_HVEG
REAL, DIMENSION(KI)  :: ZAVG_SCA_SW
REAL, DIMENSION(KI)  :: ZAVG_DIR_SW 
REAL, DIMENSION(KI)  :: ZAVG_EMIT_LW_FAC
REAL, DIMENSION(KI)  :: ZAVG_EMIT_LW_GRND
REAL, DIMENSION(KI,SIZE(TM%B%CUR%XTI_BLD,2)) :: ZAVG_T_RAD_IND
REAL, DIMENSION(KI)  :: ZT_LOWCAN           ! temperature at lowest canyon level (K)
REAL, DIMENSION(KI)  :: ZQ_LOWCAN           ! humidity    at lowest canyon level (kg/kg)
REAL, DIMENSION(KI)  :: ZU_LOWCAN           ! wind        at lowest canyon level (m/s)
REAL, DIMENSION(KI)  :: ZZ_LOWCAN           ! height      of lowest canyon level (m)
REAL, DIMENSION(KI)  :: ZPEW_A_COEF_LOWCAN  ! implicit coefficients for wind coupling
REAL, DIMENSION(KI)  :: ZPEW_B_COEF_LOWCAN  ! between first canopy level and road
REAL, DIMENSION(KI)  :: ZTA                 ! temperature at canyon level just above roof (K)
REAL, DIMENSION(KI)  :: ZPA                 ! pressure    at canyon level just above roof (K)
REAL, DIMENSION(KI)  :: ZUA                 ! wind        at canyon level just above roof (m/s)
REAL, DIMENSION(KI)  :: ZUREF               ! height      of canyon level just above roof (m)
REAL, DIMENSION(KI)  :: ZZREF               ! height      of canyon level just above roof (m)
REAL, DIMENSION(KI)  :: ZLAMBDA_F           ! frontal density (-)
REAL, DIMENSION(KI)  :: ZLMO                ! Monin-Obukhov length at canopy height (m)
REAL, DIMENSION(KI,TM%TCP%NLVL) :: ZL       ! Mixing length generic profile at mid levels
!
! Urban hydrology
REAL, DIMENSION(KI) :: ZRUNOFF_SEWER     ! groundwater drainage into sewers (kg/m2/s)
REAL, DIMENSION(KI) :: ZRUNOFF_TOWNC     ! cumulated aggregated water runoff for town (kg/m2)
REAL, DIMENSION(KI) :: ZRUNOFF_ROADC     ! cumulated water surface runoff over roads (kg/m2)
REAL, DIMENSION(KI) :: ZRUNOFF_ROOFC     ! cumulated water surface runoff over roofs (kg/m2)
REAL, DIMENSION(KI) :: ZRUNOFF_STRLROOFC ! cumulated water surface runoff for structural roofs (kg/m2)
REAL, DIMENSION(KI) :: ZRUNOFF_GARDENC   ! cumulated water surface runoff for green areas      (kg/m2)
REAL, DIMENSION(KI) :: ZRUNOFF_SEWERC    ! cumulated groundwater drainage into sewers (kg/m2)
REAL, DIMENSION(KI) :: ZDRAIN_ROAD, ZDRAIN_BLD ! deep drainage under roads and buildings (kg/m2/s)
REAL, DIMENSION(KI) :: ZDIS_TOWN         ! Total town discharge (m3/s) on urban surfaces (XTOWN not taken into account)
REAL, DIMENSION(KI) :: ZDIS_ROOF         ! Roof discharge (m3/s) on urban surfaces (XTOWN not taken into account)
REAL, DIMENSION(KI) :: ZDIS_ROAD         ! Road discharge (m3/s) on urban surfaces (XTOWN not taken into account)
REAL, DIMENSION(KI) :: ZDIS_GARDEN       ! Garden surface discharge (m3/s) on urban surfaces (XTOWN not taken into account)
REAL, DIMENSION(KI) :: ZDIS_SEWER        ! soil infiltration dicharge into sewers (m3/s) on urban surfaces (XTOWN not taken into account)
! EST-CE REDONDANT AVEC ZDRAIN_GARDEN ??????
REAL, DIMENSION(KI) :: ZDRAIN            ! soil drainage from garden (kg/m2/s)
! budget
REAL, DIMENSION(KI) :: ZRAINB            !
REAL, DIMENSION(KI) :: ZSNOWB            !
REAL, DIMENSION(KI) :: ZLE_GARDENB       !
REAL, DIMENSION(KI) :: ZLE_ROADB         !
REAL, DIMENSION(KI) :: ZLE_STRLROOFB     !
REAL, DIMENSION(KI) :: ZLE_GREENROOFB    !
REAL, DIMENSION(KI) :: ZRUNOFF_TOWNB     !
REAL, DIMENSION(KI) :: ZRUNOFF_GARDENB   !
REAL, DIMENSION(KI) :: ZRUNOFF_ROADB     !
REAL, DIMENSION(KI) :: ZRUNOFF_ROOFB     !
REAL, DIMENSION(KI) :: ZRUNOFF_STRLROOFB !
REAL, DIMENSION(KI) :: ZRUNOFF_GREENROOFB! cumulated water runoff for greenroofs (kg/m2)
REAL, DIMENSION(KI) :: ZRUNOFF_SEWERB    !
REAL, DIMENSION(KI) :: ZDRAIN_ROADB      !
REAL, DIMENSION(KI) :: ZDRAIN_BLDB       !
REAL, DIMENSION(KI) :: ZDRAIN_GARDENB    !
REAL, DIMENSION(KI,TM%T%CUR%NTEB_SOIL) :: ZWG_ROAD_INI
REAL, DIMENSION(KI,TM%T%CUR%NTEB_SOIL) :: ZWG_BLD_INI
REAL, DIMENSION(KI,TM%T%CUR%NTEB_SOIL) :: ZWG_GARDEN_INI
!
! absorbed solar and infra-red radiation by road, wall and roof
!                                                      
REAL, DIMENSION(KI)  :: ZABS_SW_ROAD
REAL, DIMENSION(KI)  :: ZABS_SW_WALL_A
REAL, DIMENSION(KI)  :: ZABS_SW_WALL_B
REAL, DIMENSION(KI)  :: ZABS_SW_ROOF
REAL, DIMENSION(KI)  :: ZABS_SW_GARDEN
REAL, DIMENSION(KI)  :: ZABS_SW_HVEG
REAL, DIMENSION(KI)  :: ZABS_SW_GREENROOF
REAL, DIMENSION(KI)  :: ZABS_SW_PANEL
REAL, DIMENSION(KI)  :: ZABS_SW_SNOW_ROAD
REAL, DIMENSION(KI)  :: ZABS_SW_SNOW_ROOF
REAL, DIMENSION(KI)  :: ZABS_LW_SNOW_ROAD
REAL, DIMENSION(KI)  :: ZABS_LW_SNOW_ROOF
REAL, DIMENSION(KI)  :: ZABS_LW_ROAD
REAL, DIMENSION(KI)  :: ZABS_LW_WALL_A
REAL, DIMENSION(KI)  :: ZABS_LW_WALL_B
REAL, DIMENSION(KI)  :: ZABS_LW_ROOF
REAL, DIMENSION(KI)  :: ZABS_LW_GARDEN 
REAL, DIMENSION(KI)  :: ZABS_LW_HVEG 
REAL, DIMENSION(KI)  :: ZABS_LW_GREENROOF
REAL, DIMENSION(KI)  :: ZABS_LW_PANEL
!
REAL, DIMENSION(KI)  :: ZHEAT_RR_ROAD
REAL, DIMENSION(KI)  :: ZHEAT_RR_ROOF
REAL, DIMENSION(KI)  :: ZU_UTCI             ! wind speed for the UTCI calculation (m/s) 
!
REAL, DIMENSION(KI)  :: ZALFAU              ! V+(1) = alfa u'w'(1) + beta
REAL, DIMENSION(KI)  :: ZBETAU              ! V+(1) = alfa u'w'(1) + beta
REAL, DIMENSION(KI)  :: ZALFAT              ! Th+(1) = alfa w'th'(1) + beta
REAL, DIMENSION(KI)  :: ZBETAT              ! Th+(1) = alfa w'th'(1) + beta
REAL, DIMENSION(KI)  :: ZALFAQ              ! Q+(1) = alfa w'q'(1) + beta
REAL, DIMENSION(KI)  :: ZBETAQ              ! Q+(1) = alfa w'q'(1) + beta
!***** CANOPY  *****
REAL, DIMENSION(KI)  :: ZWAKE               ! reduction of average wind speed
!                                           ! in canyon due to direction average.
! new local variables after BEM
!
REAL, DIMENSION(KI)  :: ZCAP_SYS
REAL, DIMENSION(KI)  :: ZM_SYS
REAL, DIMENSION(KI)  :: ZCOP
REAL, DIMENSION(KI)  :: ZQ_SYS
REAL, DIMENSION(KI)  :: ZT_SYS
REAL, DIMENSION(KI)  :: ZTR_SW_WIN
REAL, DIMENSION(KI)  :: ZFAN_POWER
REAL, DIMENSION(KI)  :: ZABS_SW_WIN
REAL, DIMENSION(KI)  :: ZABS_LW_WIN
REAL, DIMENSION(KI)  :: ZH_BLD_COOL
REAL, DIMENSION(KI)  :: ZT_BLD_COOL
REAL, DIMENSION(KI)  :: ZH_BLD_HEAT
REAL, DIMENSION(KI)  :: ZLE_BLD_COOL
REAL, DIMENSION(KI)  :: ZLE_BLD_HEAT  
REAL, DIMENSION(KI)  :: ZH_WASTE_CANY
REAL, DIMENSION(KI)  :: ZLE_WASTE_CANY
REAL, DIMENSION(KI)  :: ZH_WASTE_ROOF
REAL, DIMENSION(KI)  :: ZLE_WASTE_ROOF
REAL, DIMENSION(KI)  :: ZHVAC_COOL  
REAL, DIMENSION(KI)  :: ZHVAC_HEAT
REAL, DIMENSION(KI)  :: ZQINOUT
REAL, DIMENSION(KI,SIZE(TM%B%CUR%XTI_BLD,2)) :: ZCOMP_QINOUT
REAL, DIMENSION(KI,SIZE(TM%B%CUR%XTI_BLD,2)) :: ZCOMP_HVAC_COOL  
REAL, DIMENSION(KI,SIZE(TM%B%CUR%XTI_BLD,2)) :: ZCOMP_HVAC_HEAT
REAL, DIMENSION(KI) :: ZH_TRAFFIC_OUT
REAL, DIMENSION(KI) :: ZLE_TRAFFIC_OUT
REAL, DIMENSION(KI) :: ZH_INDUSTRY_OUT
REAL, DIMENSION(KI) :: ZLE_INDUSTRY_OUT
REAL, DIMENSION(KI) :: ZINFCALC
REAL, DIMENSION(KI) :: ZROAD_SHADE
REAL, DIMENSION(KI,SIZE(TM%B%CUR%XTI_BLD,2)) :: ZDIAGSHAD
REAL, DIMENSION(KI,SIZE(TM%B%CUR%XTI_BLD,2)) :: ZDIAGVENT
REAL, DIMENSION(KI,SIZE(TM%B%CUR%XTI_BLD,2)) :: ZDIAGVEFL
REAL, DIMENSION(KI,SIZE(TM%B%CUR%XTI_BLD,2)) :: ZBLDOCC
REAL, DIMENSION(KI) :: ZSEN_SNOW_DIF_ROAD ! Sensible heat due to snowfall on road
REAL, DIMENSION(KI) :: ZSEN_SNOW_DIF_ROOF ! Sensible heat due to snowfall on roof
!
REAL, DIMENSION(KI) :: ZSEN_GREENROOF
REAL, DIMENSION(KI) :: ZLAT_GREENROOF
!
REAL, DIMENSION(KI) :: ZSENFABSTOR
REAL, DIMENSION(KI) :: ZLATFABSTOR
REAL, DIMENSION(KI) :: ZROOFTK
REAL, DIMENSION(KI) :: ZWALLTK
REAL, DIMENSION(KI) :: ZMASSTK
REAL, DIMENSION(KI) :: ZQIN_KWH   
REAL, DIMENSION(KI) :: ZHVAC_HT_KWH
REAL, DIMENSION(KI) :: ZHVAC_CL_KWH
!
REAL, DIMENSION(KI) :: ZDF_ROOF
REAL, DIMENSION(KI) :: ZDF_ROAD
!
REAL, DIMENSION(KI) :: ZSNOW_D_ROOF
REAL, DIMENSION(KI) :: ZSNOW_HC_ROOF
REAL, DIMENSION(KI) :: ZSNOW_D_ROAD
REAL, DIMENSION(KI) :: ZSNOW_HC_ROAD
!
REAL, DIMENSION(KI) :: ZDN_ROOF
REAL, DIMENSION(KI) :: ZDN_ROAD
!
REAL, DIMENSION(KI,SIZE(TM%B%CUR%XTI_BLD,2)) :: ZRHOI
!
!new local variables for UTCI calculation
REAL, DIMENSION(KI)  :: ZEMIT_LW_GRND
REAL, DIMENSION(KI)  :: ZEMIT_LW_FAC
REAL, DIMENSION(KI,SIZE(TM%B%CUR%XTI_BLD,2))  :: ZT_RAD_IND ! Indoor mean radiant temperature [K]
REAL, DIMENSION(KI)  :: ZREF_SW_GRND        ! total solar rad reflected from ground
REAL, DIMENSION(KI)  :: ZREF_SW_FAC         ! total solar rad reflected from facade
REAL, DIMENSION(KI)  :: ZREF_SW_HVEG        ! total solar rad reflected from high veg
REAL, DIMENSION(KI,SIZE(TM%B%CUR%XTI_BLD,2))  :: ZAVG_TI_BLD
REAL, DIMENSION(KI,SIZE(TM%B%CUR%XTI_BLD,2))  :: ZAVG_QI_BLD
REAL, DIMENSION(KI)  :: ZF1_o_B
REAL, DIMENSION(KI,SIZE(PDIR_SW,2)) :: ZDIR_SWB ! total direct SW per band
REAL, DIMENSION(KI,SIZE(PSCA_SW,2)) :: ZSCA_SWB ! total diffuse SW per band
!
! Local variables for energy budget calculation
!
REAL, DIMENSION(KI) :: ZLW_WALA_TO_ROAD
REAL, DIMENSION(KI) :: ZLW_WALB_TO_ROAD
REAL, DIMENSION(KI) :: ZLW_WIND_TO_ROAD
REAL, DIMENSION(KI) :: ZLW_WALA_TO_GARD
REAL, DIMENSION(KI) :: ZLW_WALB_TO_GARD
REAL, DIMENSION(KI) :: ZLW_WIND_TO_GARD
REAL, DIMENSION(KI) :: ZLW_ROAD_TO_WIND
REAL, DIMENSION(KI) :: ZLW_WALL_TO_WIND
REAL, DIMENSION(KI) :: ZLW_SNOW_TO_WIND
REAL, DIMENSION(KI) :: ZLW_GARD_TO_WIND
REAL, DIMENSION(KI) :: ZLW_ROAD_TO_WALA
REAL, DIMENSION(KI) :: ZLW_GARD_TO_WALA
REAL, DIMENSION(KI) :: ZLW_SNOW_TO_WALA
REAL, DIMENSION(KI) :: ZLW_WALB_TO_WALA
REAL, DIMENSION(KI) :: ZLW_WIND_TO_WALA
REAL, DIMENSION(KI) :: ZLW_ROAD_TO_WALB
REAL, DIMENSION(KI) :: ZLW_GARD_TO_WALB
REAL, DIMENSION(KI) :: ZLW_SNOW_TO_WALB
REAL, DIMENSION(KI) :: ZLW_WALA_TO_WALB
REAL, DIMENSION(KI) :: ZLW_WIND_TO_WALB
REAL, DIMENSION(KI) :: ZLW_WALA_TO_SNOW
REAL, DIMENSION(KI) :: ZLW_WALB_TO_SNOW
REAL, DIMENSION(KI) :: ZLW_WIND_TO_SNOW
!
REAL, DIMENSION(KI) :: ZTHEWALL
REAL, DIMENSION(KI) :: ZTHEROOF
REAL, DIMENSION(KI) :: ZTHEFLOOR
REAL, DIMENSION(KI) :: ZTHEMASS
REAL, DIMENSION(KI) :: ZTHEROAD
REAL, DIMENSION(KI) :: ZTHEAIRIN
REAL, DIMENSION(KI) :: ZTHETOTAL
REAL, DIMENSION(KI) :: ZLATWATROOF
REAL, DIMENSION(KI) :: ZLATWATROAD
REAL, DIMENSION(KI) :: ZLATICEROOF
REAL, DIMENSION(KI) :: ZLATICEROAD
REAL, DIMENSION(KI) :: ZLATAIRIN
REAL, DIMENSION(KI) :: ZLATTOTAL
REAL, DIMENSION(KI) :: ZENETOTAL
!
REAL, DIMENSION(KI) :: ZSEN_MELT_ROAD
REAL, DIMENSION(KI) :: ZSEN_MELT_ROOF
REAL, DIMENSION(KI) :: ZDIFF_SNOW_WAT_ROAD
REAL, DIMENSION(KI) :: ZDIFF_SNOW_WAT_ROOF
!
REAL, DIMENSION(KI) :: ZDEEP_FLUX
REAL, DIMENSION(KI) :: ZU10M
!
REAL, DIMENSION(KI) :: ZNOC_ROOF
REAL, DIMENSION(KI) :: ZNOC_ROAD 
!
! Difference to previous time step
!
REAL, DIMENSION(KI) :: ZDIFFTHEWALL
REAL, DIMENSION(KI) :: ZDIFFTHEROOF
REAL, DIMENSION(KI) :: ZDIFFTHEFLOOR
REAL, DIMENSION(KI) :: ZDIFFTHEMASS
REAL, DIMENSION(KI) :: ZDIFFTHEROAD
REAL, DIMENSION(KI) :: ZDIFFTHESNOWROAD
REAL, DIMENSION(KI) :: ZDIFFTHESNOWROOF
REAL, DIMENSION(KI) :: ZDIFFTHEAIRIN
REAL, DIMENSION(KI) :: ZDIFFTHETOTAL
REAL, DIMENSION(KI) :: ZDIFFLATWATROOF
REAL, DIMENSION(KI) :: ZDIFFLATWATROAD
REAL, DIMENSION(KI) :: ZDIFFLATICEROOF
REAL, DIMENSION(KI) :: ZDIFFLATICEROAD
REAL, DIMENSION(KI) :: ZDIFFLATAIRIN
REAL, DIMENSION(KI) :: ZDIFFLATTOTAL
REAL, DIMENSION(KI) :: ZDIFFENETOTAL
!
REAL, DIMENSION(KI) :: ZSRCSENFLX
REAL, DIMENSION(KI) :: ZSRCLATFLX
REAL, DIMENSION(KI) :: ZSRCNETRAD
REAL, DIMENSION(KI) :: ZSRCPROPAN
REAL, DIMENSION(KI) :: ZSRCSTOGAR
REAL, DIMENSION(KI) :: ZSRCSENINT
REAL, DIMENSION(KI) :: ZSRCLATINT
REAL, DIMENSION(KI) :: ZSRCHVACCL
REAL, DIMENSION(KI) :: ZSRCHVACHT
REAL, DIMENSION(KI) :: ZSRCFLXFLO
REAL, DIMENSION(KI) :: ZSRCFLXROF
REAL, DIMENSION(KI) :: ZSRCFLXWAL
REAL, DIMENSION(KI) :: ZSRCHTRAFF
REAL, DIMENSION(KI) :: ZSRCLTRAFF
REAL, DIMENSION(KI) :: ZSRCHINDUS
REAL, DIMENSION(KI) :: ZSRCLINDUS
REAL, DIMENSION(KI) :: ZSRCLATRAI
REAL, DIMENSION(KI) :: ZSRCLATSNO
REAL, DIMENSION(KI) :: ZSRCLATROI
REAL, DIMENSION(KI) :: ZSRCLATGRI
REAL, DIMENSION(KI) :: ZSRCRUNROF
REAL, DIMENSION(KI) :: ZSRCRUNROD
REAL, DIMENSION(KI) :: ZSRCNOCROF
REAL, DIMENSION(KI) :: ZSRCNOCROD
REAL, DIMENSION(KI) :: ZSRCSENSUM
REAL, DIMENSION(KI) :: ZSRCLATSUM
REAL, DIMENSION(KI) :: ZSRCALLSUM
!
REAL, DIMENSION(KI) :: ZCONV_LAT_SEN_ROAD
REAL, DIMENSION(KI) :: ZCONV_LAT_SEN_ROOF
!
REAL, DIMENSION(KI) :: ZDQS_SNOW_ROOF
REAL, DIMENSION(KI) :: ZDQS_SNOW_ROAD
!
REAL, DIMENSION(KI) :: AUXRHOO
REAL, DIMENSION(KI) :: ZCOEF
!
LOGICAL, DIMENSION(KI) :: GCHECK_BUDGET
!
REAL                 :: ZCONVERTFACM0_SLT, ZCONVERTFACM0_DST
REAL                 :: ZCONVERTFACM3_SLT, ZCONVERTFACM3_DST
REAL                 :: ZCONVERTFACM6_SLT, ZCONVERTFACM6_DST
!
INTEGER              :: JI
INTEGER              :: JLAYER
INTEGER              :: JCOMP
INTEGER              :: JJ
!
! number of TEB patches
!
INTEGER              :: JTEB_PATCH          ! loop counter
INTEGER              :: ILUOUT     ! Unit number
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!-------------------------------------------------------------------------------------
! Preliminaries:
!-------------------------------------------------------------------------------------
IF (LHOOK) CALL DR_HOOK('COUPLING_TEB_N',0,ZHOOK_HANDLE)
!
IF (HTEST/='OK') THEN
  CALL ABOR1_SFX('COUPLING_TEBN: FATAL ERROR DURING ARGUMENT TRANSFER')
END IF
!
! Robert: Here the modifications of PRAIN and PSNOW
!         from forcing vert shift are applied.
!         Very small values of rain and snow are also
!         set to 0.0
!
WHERE(PRAIN(:).LT.1.0E-10) PRAIN(:)=0.0
WHERE(PSNOW(:).LT.1.0E-10) PSNOW(:)=0.0
!
WHERE(PTA(:)>=(XTT+1.0))
   PRAIN(:) = PRAIN(:) + PSNOW(:)
   PSNOW(:) = 0.0
ELSEWHERE
   PSNOW(:) = PRAIN(:) + PSNOW(:)
   PRAIN(:) = 0.0
ENDWHERE
!
!-------------------------------------------------------------------------------------
!
! scalar fluxes
!
PSFTS(:,:) = 0.
!
! broadband radiative fluxes
!
ZDIR_SW(:) = 0.
ZSCA_SW(:) = 0.
DO JSWB=1,KSW
  !add directionnal contrib from scattered radiation
  CALL CIRCUMSOLAR_RAD(PDIR_SW(:,JSWB), PSCA_SW(:,JSWB), PZENITH, ZF1_o_B)
  ! -------------------------------------------------------------
  ! ON FORCE A ZERO POUR LE CAS SOLENE
  ZF1_o_B = 0.
  ! -------------------------------------------------------------
  ZDIR_SWB(:,JSWB) = PDIR_SW(:,JSWB) + PSCA_SW(:,JSWB) * ZF1_o_B
  ZSCA_SWB(:,JSWB) = PSCA_SW(:,JSWB) * (1. - ZF1_o_B)
  !add directionnal contrib from scattered radiation
  DO JJ=1,SIZE(PDIR_SW,1)
    ZDIR_SW(JJ) = ZDIR_SW(JJ) + ZDIR_SWB(JJ,JSWB)
    ZSCA_SW(JJ) = ZSCA_SW(JJ) + ZSCA_SWB(JJ,JSWB)
  ENDDO
END DO
!
DO JJ=1,KI
! specific humidity (conversion from kg/m3 to kg/kg)
!
  ZQA(JJ) = PQA(JJ) / PRHOA(JJ)
!
! wind
!
  ZWIND(JJ) = SQRT(PU(JJ)**2+PV(JJ)**2)
!
ENDDO
! method of wind coupling
!
IF (HCOUPLING=='I') THEN
  ZPEW_A_COEF = PPEW_A_COEF
  ZPEW_B_COEF = PPEW_B_COEF
ELSE
  ZPEW_A_COEF =  0.
  ZPEW_B_COEF =  ZWIND
END IF
!
!
! - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
! Time evolution
! - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
!
TM%TOP%TTIME%TIME = TM%TOP%TTIME%TIME + PTSTEP
 CALL ADD_FORECAST_TO_DATE_SURF(TM%TOP%TTIME%TDATE%YEAR,TM%TOP%TTIME%TDATE%MONTH,&
                TM%TOP%TTIME%TDATE%DAY,TM%TOP%TTIME%TIME)
!
! - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
!  Anthropogenic fluxes (except building heating)
! - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
!
! Robert: The values for the traffic heat flux are adjusted
!         based on the results of Pigeon et al. (2007)
!         with high releases between 6 h and 20 h  (14 hours)
!         and low releases between 20 h and 6 h.   (10 hours)
!         The diurnal cycle is calibrated in a way to 
!         conserve the value of the nominal traffic heat flux
!         from the input.
!
! TODO: 
! - sensible and latent fraction
! - weekly cycle
! - annual cycle
! - Smoothing
!
ZBEGIN_TRAFFIC_TIME = 21600.
ZEND_TRAFFIC_TIME   = 72000.
!
DO JJ=1,SIZE(ZH_TRAFFIC)
   IF ((PTSUN(JJ).GT.ZBEGIN_TRAFFIC_TIME).AND.(PTSUN(JJ).LT.ZEND_TRAFFIC_TIME)) THEN
      ZH_TRAFFIC (JJ) = (48.0/33.0)*TM%T%CUR%XH_TRAFFIC (JJ)
      ZLE_TRAFFIC(JJ) = (48.0/33.0)*TM%T%CUR%XLE_TRAFFIC(JJ)
   ELSE
      ZH_TRAFFIC (JJ) = (12.0/33.0)*TM%T%CUR%XH_TRAFFIC (JJ)
      ZLE_TRAFFIC(JJ) = (12.0/33.0)*TM%T%CUR%XLE_TRAFFIC(JJ)
   ENDIF
ENDDO
!
!--------------------------------------------------------------------------------------
!  Canyon forcing for TEB
!--------------------------------------------------------------------------------------
!-------------------------------------------------------------------------------------
! Town averaged quantities to force canopy atmospheric layers
!-------------------------------------------------------------------------------------

DO JTEB_PATCH=1,TM%TOP%NTEB_PATCH
  CALL GOTO_WRAPPER_TEB_PATCH(TM%B, TM%DGCT, TM%DGMT, TM%T, &
                              GDM%TGD, GDM%TGDPE,           &
                              GRM%TGR, GRM%TGRPE,           &
                              HM%TH, JTEB_PATCH             )
  CALL ADD_PATCH_CONTRIB(JTEB_PATCH,ZAVG_BLD,         TM%T%CUR%XBLD         )
  CALL ADD_PATCH_CONTRIB(JTEB_PATCH,ZAVG_BLD_HEIGHT,  TM%T%CUR%XBLD_HEIGHT  )
  CALL ADD_PATCH_CONTRIB(JTEB_PATCH,ZAVG_WALL_O_HOR,  TM%T%CUR%XWALL_O_HOR  )
  CALL ADD_PATCH_CONTRIB(JTEB_PATCH,ZAVG_CAN_HW_RATIO,TM%T%CUR%XCAN_HW_RATIO)
  CALL ADD_PATCH_CONTRIB(JTEB_PATCH,ZAVG_Z0_TOWN,     TM%T%CUR%XZ0_TOWN     )
END DO
!
IF (TM%TOP%LCANOPY) THEN
!-------------------------------------------------------------------------------------
! Updates canopy vertical grid as a function of forcing height
!-------------------------------------------------------------------------------------
!
!* determines where is the forcing level and modifies the upper levels of the canopy grid
!
  CALL CANOPY_GRID_UPDATE(KI,TM%TCP%NLVL,ZAVG_BLD_HEIGHT,ZAVG_BLD_HEIGHT+PUREF,&
                          TM%TCP%XZ,TM%TCP%XZF,TM%TCP%XDZ,TM%TCP%XDZF)
!
!* Initialisations of T, Q, TKE and wind at first time step
!
  IF(ANY(TM%TCP%XT(:,:) == XUNDEF)) THEN
    DO JLAYER=1,TM%TCP%NLVL
      TM%TCP%XT(:,JLAYER) = PTA(:)
      TM%TCP%XQ(:,JLAYER) = PQA(:)
      TM%TCP%XU(:,JLAYER) = 2./XPI * ZWIND(:)                                  &
              * LOG( (          2.* TM%T%CUR%XBLD_HEIGHT(:)/3.) / TM%T%CUR%XZ0_TOWN(:))   &
              / LOG( (PUREF(:)+ 2.* TM%T%CUR%XBLD_HEIGHT(:)/3.) / TM%T%CUR%XZ0_TOWN(:))
    END  DO
    TM%TCP%XTKE(:,:) = 1.
  ENDIF
!
!* default forcing above roof: forcing level
ZUREF(:)     = PUREF(:)
ZZREF(:)     = PZREF(:)
ZUA(:)       = TM%TCP%XU(:,TM%TCP%NLVL)
ZTA(:)       = TM%TCP%XT(:,TM%TCP%NLVL)
!
ZQA(:)       = TM%TCP%XQ(:,TM%TCP%NLVL)/PRHOA(:)
ZPA(:)       = TM%TCP%XP(:,TM%TCP%NLVL)
!* for the time being, only one value is kept for wall in-canyon forcing, in the middle of the canyon
ZU_CANYON(:) = ZUA(:)
ZT_CANYON(:) = ZTA(:)
ZQ_CANYON(:) = ZQA(:)
  DO JLAYER=1,TM%TCP%NLVL-1
    DO JI=1,KI
      !* finds middle canyon layer
      IF (TM%TCP%XZ(JI,JLAYER)<ZAVG_BLD_HEIGHT(JI)/2. .AND. &
          TM%TCP%XZ(JI,JLAYER+1)>=ZAVG_BLD_HEIGHT(JI)/2.) THEN
        ZCOEF(JI) = (ZAVG_BLD_HEIGHT(JI)/2.-TM%TCP%XZ(JI,JLAYER))/(TM%TCP%XZ(JI,JLAYER+1)-TM%TCP%XZ(JI,JLAYER))
        ZU_CANYON(JI) = TM%TCP%XU(JI,JLAYER) + ZCOEF(JI) * (TM%TCP%XU(JI,JLAYER+1)-TM%TCP%XU(JI,JLAYER))
        ZT_CANYON(JI) = TM%TCP%XT(JI,JLAYER) + ZCOEF(JI) * (TM%TCP%XT(JI,JLAYER+1)-TM%TCP%XT(JI,JLAYER))
        ZQ_CANYON(JI) =(TM%TCP%XQ(JI,JLAYER) + ZCOEF(JI) * &
                        (TM%TCP%XQ(JI,JLAYER+1)-TM%TCP%XQ(JI,JLAYER)))/PRHOA(JI)
      END IF
      !* finds layer just above roof (at least 1m above roof)
      IF (TM%TCP%XZ(JI,JLAYER)<ZAVG_BLD_HEIGHT(JI)+1. .AND. &
          TM%TCP%XZ(JI,JLAYER+1)>=ZAVG_BLD_HEIGHT(JI)+1.) THEN
        ZUREF(JI) = TM%TCP%XZ(JI,JLAYER+1) - ZAVG_BLD_HEIGHT(JI)
        ZZREF(JI) = TM%TCP%XZ(JI,JLAYER+1) - ZAVG_BLD_HEIGHT(JI)
        ZTA  (JI) = TM%TCP%XT(JI,JLAYER+1)
        ZQA  (JI) = TM%TCP%XQ(JI,JLAYER+1)/PRHOA(JI)
        !ZUA  (JI) = XU(JI,JLAYER+1)
        ZUA  (JI) = MAX(TM%TCP%XU(JI,JLAYER+1) - 2.*SQRT(TM%TCP%XTKE(JI,JLAYER+1)) , TM%TCP%XU(JI,JLAYER+1)/3.)
        ZPA  (JI) = TM%TCP%XP(JI,JLAYER+1)
        ZLMO (JI) = TM%TCP%XLMO(JI,JLAYER+1)
      END IF
    END DO
  END DO
  !
  ! Robert: Verification whether negative humidities have been diagnosed
  !
  IF (MINVAL(TM%TCP%XQ).LT.-1.0E-10) THEN
     CALL GET_LUOUT(HPROGRAM,ILUOUT)
     DO JJ=1,SIZE(TM%TCP%XQ,1)
        IF (MINVAL(TM%TCP%XQ(JJ,:)).LT.-1.0E-10) THEN
            WRITE(ILUOUT,*) "                "
            WRITE(ILUOUT,*) "JJ              : ",JJ
            WRITE(ILUOUT,*) "TM%TCP%XQ(JJ,:) : ",TM%TCP%XQ(JJ,:)
        ENDIF
     ENDDO
     CALL FLUSH(ILUOUT)
     CALL ABOR1_SFX ("Negative humidity in canyon")
  ENDIF
  !
  ZU_CANYON= MAX(ZU_CANYON,0.2)
  ZU_LOWCAN=TM%TCP%XU(:,1)
  ZT_LOWCAN=TM%TCP%XT(:,1)
  ZQ_LOWCAN=TM%TCP%XQ(:,1) / PRHOA(:)
  ZZ_LOWCAN=TM%TCP%XZ(:,1)
  WHERE(ZPA==XUNDEF) ZPA = PPA   ! security for first time step
!
!-------------------------------------------------------------------------------------
! determine the vertical profile for mixing and dissipative lengths (at full levels)
!-------------------------------------------------------------------------------------
!
! frontal density
  ZLAMBDA_F(:) = ZAVG_CAN_HW_RATIO*ZAVG_BLD / (0.5*XPI)
!
  CALL SM10(TM%TCP%XZ,ZAVG_BLD_HEIGHT,ZLAMBDA_F,ZL)
!
!-------------------------------------------------------------------------------------
! computes coefficients for implicitation
!-------------------------------------------------------------------------------------
!
  ZAVG_UW_GRND(:)      = 0.
  ZAVG_DUWDU_GRND(:)   = 0.
  ZAVG_UW_ROOF(:)      = 0.
  ZAVG_DUWDU_ROOF(:)   = 0.
  ZAVG_H_GRND(:)       = 0.
  ZAVG_H_WALL(:)       = 0.
  ZAVG_E_WALL(:)       = 0.
  ZAVG_H_ROOF(:)       = 0.
  ZAVG_E_GRND(:)       = 0.
  ZAVG_E_ROOF(:)       = 0.
  ZAVG_AC_GRND(:)      = 0.
  ZAVG_AC_GRND_WAT(:)  = 0.
  ZSFLUX_U(:)          = 0.
  ZSFLUX_T(:)          = 0.
  ZSFLUX_Q(:)          = 0.
!
  DO JLAYER=1,TM%TCP%NLVL-1
      !* Monin-Obuhkov theory not used inside the urban canopy
      ! => neutral mixing  if layer is below : (roof level +1 meter)
      WHERE (TM%TCP%XZ(:,JLAYER)<=ZAVG_BLD_HEIGHT(:)+1.) TM%TCP%XLMO(:,JLAYER) = XUNDEF
  ENDDO
!
!
!* computes tendencies on wind and Tke due to canopy
 CALL TEB_CANOPY(KI,TM%TCP%NLVL,TM%TCP%XZ,TM%TCP%XZF,TM%TCP%XDZ,TM%TCP%XDZF,&
                 ZAVG_BLD,ZAVG_BLD_HEIGHT,ZAVG_WALL_O_HOR,     &
                PPA,PRHOA,TM%TCP%XU,                                                         &
                ZAVG_DUWDU_GRND, ZAVG_UW_ROOF, ZAVG_DUWDU_ROOF,                       &
                ZAVG_H_WALL,ZAVG_E_WALL,ZAVG_H_ROOF,ZAVG_E_ROOF,ZAVG_AC_GRND,ZAVG_AC_GRND_WAT,    &
                ZFORC_U,ZDFORC_UDU,ZFORC_E,ZDFORC_EDE,ZFORC_T,ZDFORC_TDT,ZFORC_Q,ZDFORC_QDQ)
!
!* computes coefficients for implicitation
  CALL CANOPY_EVOL(KI,TM%TCP%NLVL,PTSTEP,1,                  &
                     ZL,ZWIND,PTA,PQA,PPA,PRHOA,             &
                     ZSFLUX_U,ZSFLUX_T,ZSFLUX_Q,             &
                     ZFORC_U,ZDFORC_UDU,ZFORC_E,ZDFORC_EDE,  &
                     ZFORC_T,ZDFORC_TDT,ZFORC_Q,ZDFORC_QDQ,  &
                     TM%TCP%XZ,TM%TCP%XZF,TM%TCP%XDZ,TM%TCP%XDZF,TM%TCP%XU,&
                     TM%TCP%XTKE,TM%TCP%XT,TM%TCP%XQ,TM%TCP%XLMO,     &
                     TM%TCP%XLM,TM%TCP%XLEPS,TM%TCP%XP,ZAVG_USTAR,                &
                     ZALFAU,ZBETAU,ZALFAT,ZBETAT,ZALFAQ,ZBETAQ)
!
  ZPEW_A_COEF_LOWCAN = - ZALFAU / PRHOA
  ZPEW_B_COEF_LOWCAN = ZBETAU  
!
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
ELSE              ! no canopy case
!- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
  DO JI=1,KI
!* skimming flow for h/w>1 (maximum effect of direction on wind in the canyon);
!* isolated flow for h/w<0.5 (wind is the same in large streets for all dir.)
!* wake flow between.
!
    ZWAKE(JI)= 1. + (2./XPI-1.) * 2. * (ZAVG_CAN_HW_RATIO(JI)-0.5)
    ZWAKE(JI)= MAX(MIN(ZWAKE(JI),1.),2./XPI)
!
!* Estimation of canyon wind speed from wind just above roof level
!  (at 1.33h). Wind at 1.33h is estimated using the log law.
!
   IF (ZAVG_BLD_HEIGHT(JI) .GT. 0.) THEN
    ZU_CANYON(JI) = ZWAKE(JI) * EXP(-ZAVG_CAN_HW_RATIO(JI)/4.) * ZWIND(JI)     &
              * LOG( (           2.* ZAVG_BLD_HEIGHT(JI)/3.) / ZAVG_Z0_TOWN(JI))   &
              / LOG( (PUREF(JI)+ 2.* ZAVG_BLD_HEIGHT(JI)/3.) / ZAVG_Z0_TOWN(JI))
    ZZ_LOWCAN(JI) = ZAVG_BLD_HEIGHT(JI) / 2.
   ELSE
    ZU_CANYON(JI) = ZWIND(JI)
    ZZ_LOWCAN(JI) = PZREF(JI)
   ENDIF
 END DO
!
!* Without SBL scheme, canyon air is assumed at mid height
!
! Check for negative humidity
!
  IF (MINVAL(TM%T%CUR%XQ_CANYON).LT.-1.0E-10) THEN
     CALL GET_LUOUT(HPROGRAM,ILUOUT)
     WRITE(ILUOUT,*) "TM%T%CUR%XQ_CANYON : ",TM%T%CUR%XQ_CANYON
     CALL FLUSH(ILUOUT)
     CALL ABOR1_SFX("Negative humidity in canyon")
  ENDIF
  !
  ZU_LOWCAN=ZU_CANYON
  ZT_LOWCAN=TM%T%CUR%XT_CANYON
  ZQ_LOWCAN=TM%T%CUR%XQ_CANYON
  ZT_CANYON=TM%T%CUR%XT_CANYON
  ZQ_CANYON=TM%T%CUR%XQ_CANYON
  ZUREF    =PUREF
  ZZREF    =PZREF
  ZTA      =PTA
  ZUA      =ZWIND
  ZPA      =PPA
  ZPEW_A_COEF_LOWCAN =  0.
  ZPEW_B_COEF_LOWCAN =  ZU_CANYON
END IF
!
! Exner functions
!
ZEXNS     (:) = (PPS(:)/XP00)**(XRD/XCPD)
ZEXNA     (:) = (ZPA(:)/XP00)**(XRD/XCPD)

!--------------------------------------------------------------------------------------
! Over Urban surfaces/towns:
!--------------------------------------------------------------------------------------
!
DO JTEB_PATCH=1,TM%TOP%NTEB_PATCH
  CALL GOTO_WRAPPER_TEB_PATCH(TM%B, TM%DGCT, TM%DGMT, TM%T, &
                              GDM%TGD, GDM%TGDPE,           &
                              GRM%TGR, GRM%TGRPE,           &
                              HM%TH, JTEB_PATCH             )
!
ZT_CAN=ZT_CANYON
ZQ_CAN=ZQ_CANYON
!
IF (TM%TOP%LCANOPY) THEN
  TM%T%CUR%XT_CANYON(:) = ZT_CANYON(:)
  TM%T%CUR%XQ_CANYON(:) = ZQ_CANYON(:)
END IF
!
ZLESNOW_ROOF(:) = 0.
ZLESNOW_ROAD(:) = 0.
ZG_GREENROOF_ROOF(:) = 0.
!
! Calculate the wind speed in 10 m height
!
DO JJ=1,KI
   IF (TM%DGT%XZON10M(JJ)/=XUNDEF) THEN
      ZU10M(JJ) = SQRT(TM%DGT%XZON10M(JJ)**2+TM%DGT%XMER10M(JJ)**2)
   ELSE
      ZU10M(JJ) = ZWIND(JJ)
   ENDIF
ENDDO
!
! - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
! Call the physical routines of TEB (including gardens and greenroofs)
! - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
!
 CALL TEB_GARDEN(HPROGRAM,DTCO, DTI, IG, I, TM, GDM, GRM, HM,                           &
                 TM%TOP%LGARDEN, TM%TOP%LGREENROOF, TM%TOP%LURBHYDRO,                   &
                 TM%TOP%LSOLAR_PANEL,                                                   &
                 TM%TOP%CZ0H, CIMPLICIT_WIND,                                           &
                 TM%TOP%CROAD_DIR, TM%TOP%CWALL_OPT, TM%TOP%CURBTREE,                   &
                 TM%TOP%TTIME, PTSUN, ZT_CAN, ZQ_CAN, ZU_CANYON,                        &
                 ZT_LOWCAN, ZQ_LOWCAN, ZU_LOWCAN, ZZ_LOWCAN,                            &
                 TM%B%CUR%XTI_BLD,TM%T%CUR%XT_ROOF, TM%T%CUR%XT_ROAD,                   &
                 TM%T%CUR%XT_WALL_A, TM%T%CUR%XT_WALL_B,                                &
                 TM%T%CUR%XT_BLD, TM%T%CUR%XT_ALLBLD,                                   &
                 TM%T%CUR%XWS_ROOF, TM%T%CUR%XWS_ROAD,                                  &
                 TM%T%CUR%TSNOW_ROOF%SCHEME,                                            &
                 TM%T%CUR%TSNOW_ROOF%WSNOW(:,:,1), TM%T%CUR%TSNOW_ROOF%T(:,:,1),        &
                 TM%T%CUR%TSNOW_ROOF%RHO(:,:,1), TM%T%CUR%TSNOW_ROOF%ALB(:,1),          &
                 TM%T%CUR%TSNOW_ROOF%TS(:,1), TM%T%CUR%TSNOW_ROOF%EMIS(:,1),            &
                 TM%T%CUR%TSNOW_ROAD%SCHEME,                                            &
                 TM%T%CUR%TSNOW_ROAD%WSNOW(:,:,1), TM%T%CUR%TSNOW_ROAD%T(:,:,1),        &
                 TM%T%CUR%TSNOW_ROAD%RHO(:,:,1), TM%T%CUR%TSNOW_ROAD%ALB(:,1),          &
                 TM%T%CUR%TSNOW_ROAD%TS(:,1), TM%T%CUR%TSNOW_ROAD%EMIS(:,1),            &
                 ZPEW_A_COEF, ZPEW_B_COEF,ZPEW_A_COEF_LOWCAN, ZPEW_B_COEF_LOWCAN,       &
                 PPS, TM%B%CUR%XPSOLD, TM%B%CUR%XSHADVACSW, TM%B%CUR%XVENTNIGSW, ZPA, ZEXNS, ZEXNA, ZTA, ZQA, PRHOA, PCO2, &
                 PLW, ZDIR_SWB, ZSCA_SWB, PSW_BANDS, KSW, PZENITH, PAZIM,               &
                 PRAIN, PSNOW, ZZREF, ZUREF, ZUA,                                       &
                 ZH_TRAFFIC, ZLE_TRAFFIC, TM%T%CUR%XH_INDUSTRY, TM%T%CUR%XLE_INDUSTRY,  &
                 PTSTEP,                                                                &
                 TM%T%CUR%XZ0_TOWN, TM%T%CUR%XBLD, TM%T%CUR%XGARDEN,                    &
                 TM%T%CUR%XROAD_DIR, TM%T%CUR%XROAD, TM%T%CUR%XGREENROOF,               &
                 GDM%TGDP%XFRAC_HVEG,                                                   &
                 TM%T%CUR%XBLD_HEIGHT, TM%T%CUR%XWALL_O_HOR, TM%T%CUR%XCAN_HW_RATIO,    &
                 TM%T%CUR%XROAD_O_GRND, TM%T%CUR%XGARDEN_O_GRND, TM%T%CUR%XWALL_O_GRND, &
                 TM%T%CUR%XALB_ROOF, TM%T%CUR%XEMIS_ROOF, TM%T%CUR%XHC_ROOF,            &
                 TM%T%CUR%XTC_ROOF,TM%T%CUR%XD_ROOF,                                    &
                 TM%T%CUR%XALB_ROAD, TM%T%CUR%XEMIS_ROAD, TM%T%CUR%XSVF_ROAD,           &
                 TM%T%CUR%XHC_ROAD, TM%T%CUR%XTC_ROAD, TM%T%CUR%XD_ROAD,                &
                 TM%T%CUR%XHC_BLD, TM%T%CUR%XTC_BLD, TM%T%CUR%XD_BLD,                   &
                 TM%T%CUR%XHC_ALLBLD, TM%T%CUR%XTC_ALLBLD, TM%T%CUR%XD_ALLBLD,          &
                 TM%T%CUR%XALB_WALL, TM%T%CUR%XEMIS_WALL, TM%T%CUR%XSVF_WALL,           &
                 TM%T%CUR%XSVF_GARDEN,                                                  &
                 TM%T%CUR%XHC_WALL,TM%T%CUR%XTC_WALL,TM%T%CUR%XD_WALL,                  &
                 ZRN_ROOF, ZH_ROOF, ZLE_ROOF, ZLEW_ROOF, ZGFLUX_ROOF,                   &
                 ZRUNOFF_ROOF,                                                          &
                 ZRN_ROAD, ZH_ROAD, ZLE_ROAD, ZLEW_ROAD, ZGFLUX_ROAD,                   &
                 ZRUNOFF_ROAD,                                                          &
                 ZRN_WALL_A, ZH_WALL_A, ZLE_WALL_A, ZGFLUX_WALL_A,                      &
                 ZRN_WALL_B, ZH_WALL_B, ZLE_WALL_B, ZGFLUX_WALL_B,                      &
                 ZRN_GARDEN,ZH_GARDEN,ZLE_GARDEN,ZGFLUX_GARDEN,                         &
                 ZRUNOFF_GARDEN, ZDRAIN_GARDEN, ZIRRIG_GARDEN,                          &
                 ZRUNOFF_SEWER, ZDRAIN,                                                 &
                 ZRN_GREENROOF,ZH_GREENROOF,ZLE_GREENROOF,ZGFLUX_GREENROOF,             &
                 ZRN_STRLROOF,ZH_STRLROOF,ZLE_STRLROOF,ZGFLUX_STRLROOF,                 &
                 ZRUNOFF_STRLROOF,                                                      &
                 ZRN_BLT,ZH_BLT,ZLE_BLT,ZGFLUX_BLT,                                     &
                 ZRNSNOW_ROOF, ZHSNOW_ROOF, ZLESNOW_ROOF, ZGSNOW_ROOF,                  &
                 ZMELT_ROOF,                                                            &
                 ZRNSNOW_ROAD, ZHSNOW_ROAD, ZLESNOW_ROAD, ZGSNOW_ROAD,                  &
                 ZMELT_ROAD,                                                            &
                 ZRN_GRND, ZH_GRND, ZLE_GRND, ZGFLUX_GRND,                              &
                 ZRN, ZH, ZLE, ZGFLUX, ZEVAP, ZRUNOFF_TOWN, ZSFCO2,                     &
                 ZUW_GRND, ZUW_ROOF, ZDUWDU_GRND, ZDUWDU_ROOF,                          &
                 ZUSTAR, ZCD, ZCDN, ZCH, ZRI,                                           &
                 ZTRAD, ZEMIS, ZDIR_ALB, ZSCA_ALB, ZRESA_TOWN, ZDQS_TOWN,               &
                 ZQF_TOWN, ZQF_BLD,                                                     &
                 ZFLX_BLD, ZAC_ROAD, ZAC_GARDEN, ZAC_GREENROOF,                         &
                 ZAC_ROAD_WAT, ZAC_GARDEN_WAT, ZAC_GREENROOF_WAT,                       &
                 ZABS_SW_ROOF,ZABS_LW_ROOF,                                             &
                 ZABS_SW_SNOW_ROOF,ZABS_LW_SNOW_ROOF,                                   &
                 ZABS_SW_ROAD,ZABS_LW_ROAD,                                             &
                 ZABS_SW_SNOW_ROAD,ZABS_LW_SNOW_ROAD,                                   &
                 ZABS_SW_WALL_A, ZABS_LW_WALL_A,                                        &
                 ZABS_SW_WALL_B, ZABS_LW_WALL_B,                                        &
                 ZABS_SW_PANEL,ZABS_LW_PANEL,                                           &
                 ZABS_SW_GARDEN,ZABS_LW_GARDEN,                                         &
                 ZABS_SW_HVEG, ZABS_LW_HVEG,                                            &
                 ZABS_SW_GREENROOF,ZABS_LW_GREENROOF, ZG_GREENROOF_ROOF,                &
                 ZRUNOFF_GREENROOF, ZDRAIN_GREENROOF,                                   &
                 ZIRRIG_GREENROOF, TM%BOP%CCOOL_COIL, TM%B%CUR%XF_WATER_COND,           &
                 TM%BOP%CHEAT_COIL,TM%B%CUR%CNATVENT,KDAY, TM%B%CUR%XAUX_MAX,           &
                 TM%B%CUR%XT_FLOOR, TM%B%CUR%XT_MASS, ZH_BLD_COOL,ZT_BLD_COOL,          &
                 ZH_BLD_HEAT, ZLE_BLD_COOL, ZLE_BLD_HEAT, ZH_WASTE_CANY, ZLE_WASTE_CANY,&
                 ZH_WASTE_ROOF, ZLE_WASTE_ROOF,                                         &
                 TM%B%CUR%XF_WASTE_CAN, ZHVAC_COOL, ZCOMP_HVAC_COOL, ZHVAC_HEAT, ZCOMP_HVAC_HEAT, TM%B%CUR%XQIN,          &
                 TM%B%CUR%XQIN_FRAD, TM%B%CUR%XQIN_FLAT, TM%B%CUR%XGR, TM%B%CUR%XN50, TM%B%CUR%XEFF_HEAT,&
                 TM%B%CUR%XHR_TARGET, TM%B%CUR%XT_WIN2,                                 &
                 TM%B%CUR%XTHEAT_OCCD,TM%B%CUR%XTHEAT_OCCN,TM%B%CUR%XTHEAT_VCDD,TM%B%CUR%XTHEAT_VCDN, &
                 TM%B%CUR%XTHEAT_VCLD,TM%B%CUR%XTCOOL_OCCD,TM%B%CUR%XTCOOL_OCCN,TM%B%CUR%XTCOOL_VCDD, &
                 TM%B%CUR%XTCOOL_VCDN,TM%B%CUR%XTCOOL_VCLD,TM%B%CUR%XFRACOMP,           &  
                 TM%B%CUR%XQI_BLD, TM%B%CUR%XCAP_SYS_HEAT,                              &
                 TM%B%CUR%XCAP_SYS_RAT, TM%B%CUR%XT_ADP, TM%B%CUR%XM_SYS_RAT,           &
                 TM%B%CUR%XCOP_RAT, ZCAP_SYS, ZM_SYS, ZCOP, ZQ_SYS, ZT_SYS,             &
                 ZTR_SW_WIN, TM%B%CUR%XWIN_SW_MAX, TM%B%CUR%XHC_FLOOR, TM%B%CUR%XTC_FLOOR, &
                 TM%B%CUR%XD_FLOOR, TM%B%CUR%XHC_MASS, TM%B%CUR%XTC_MASS,               &
                 TM%B%CUR%XD_MASS, TM%B%CUR%XT_WIN1, ZABS_SW_WIN, ZABS_LW_WIN,          &
                 TM%B%CUR%XSHGC_SH, TM%B%CUR%XUGG_WIN,                                  &
                 TM%B%CUR%XALB_WIN, TM%B%CUR%XABS_WIN, ZEMIT_LW_FAC, ZEMIT_LW_GRND,     &
                 ZT_RAD_IND, ZREF_SW_GRND,ZREF_SW_FAC, ZREF_SW_HVEG, PTIME,             &
                 TM%B%CUR%XISMECH, TM%B%CUR%XMECHRATE, TM%B%CUR%XSHADEARCHI,            &
                 TM%TOP%CBEM, TM%B%CUR%XN_FLOOR, TM%T%CUR%XWALL_O_BLD,                  &
                 TM%B%CUR%XGLAZ_O_BLD, TM%B%CUR%XMASS_O_BLD,                            &
                 TM%B%CUR%XF_FLOOR_MASS, TM%B%CUR%XF_FLOOR_WALL, TM%B%CUR%XF_FLOOR_WIN, &
                 TM%B%CUR%XF_FLOOR_ROOF, TM%B%CUR%XF_WALL_FLOOR, TM%B%CUR%XF_WALL_MASS, &
                 TM%B%CUR%XF_WALL_WIN, TM%B%CUR%XF_WIN_FLOOR, TM%B%CUR%XF_WIN_MASS,     &
                 TM%B%CUR%XF_WIN_WALL, TM%B%CUR%XF_MASS_FLOOR, TM%B%CUR%XF_MASS_WALL,   &
                 TM%B%CUR%XF_MASS_WIN, TM%TOP%LCANOPY, TM%B%CUR%XTRAN_WIN,              &
                 TM%TOP%CCH_BEM, TM%T%CUR%XROUGH_ROOF, TM%T%CUR%XROUGH_WALL,            &
                 TM%B%CUR%XF_WIN_WIN, GDM%TIR%LPAR_RD_IRRIG, GDM%TIR%XRD_START_MONTH,   &
                 GDM%TIR%XRD_END_MONTH, GDM%TIR%XRD_START_HOUR, GDM%TIR%XRD_END_HOUR,   &
                 GDM%TIR%XRD_24H_IRRIG, ZIRRIG_ROAD, TM%TPN%XEMIS_PANEL,                &
                 TM%TPN%XALB_PANEL, TM%TPN%XEFF_PANEL, TM%TPN%XFRAC_PANEL,              &
                 ZTHER_PROD_PANEL, ZPHOT_PROD_PANEL,             &
                 ZPROD_PANEL, ZTHER_PROD_BLD  , ZPHOT_PROD_BLD, ZPROD_BLD,              &
                 TM%TPN%XTHER_PRODC_DAY, ZH_PANEL, ZRN_PANEL,                           &
                 TM%B%CUR%XFSNIG,TM%B%CUR%XFVNIG,TM%B%CUR%XMODQIN_VCD,                  &
                 TM%B%CUR%XMODQIN_VLD,TM%B%CUR%XMODQIN_NIG, TM%B%CUR%XTDESV,            &
                 TM%B%CUR%XFVSHO,ZQINOUT,ZCOMP_QINOUT,TM%B%CUR%XFOPEN,TM%B%CUR%XFVSUM,               &
                 TM%B%CUR%XFVVAC,TM%B%CUR%XFSSUM,TM%B%CUR%XFSVAC,                       &
                 TM%B%CUR%XDAYWBEG_SCHED,TM%B%CUR%XHOURBEG_SCHED,TM%B%CUR%XPROBOCC,     &
                 TM%B%CUR%XEND_HOLIDAY,TM%B%CUR%XBEG_HOLIDAY,TM%B%CUR%XMOD_HOLIDAY,     &
                 ZINFCALC,ZDIAGSHAD,ZROAD_SHADE,ZBLDOCC,ZCONV_LAT_SEN_ROAD,                         &
                 ZCONV_LAT_SEN_ROOF,                                                    &
                 ZHEAT_RR_ROAD,ZHEAT_RR_ROOF,ZSEN_SNOW_DIF_ROAD,ZSEN_SNOW_DIF_ROOF,     &
                 ZSNOW_D_ROOF,ZSNOW_HC_ROOF,ZSNOW_D_ROAD,ZSNOW_HC_ROAD,                 &
                 ZDN_ROOF,ZDN_ROAD,ZDQS_SNOW_ROOF,ZDQS_SNOW_ROAD,ZSEN_MELT_ROAD,        &
                 ZSEN_MELT_ROOF,ZDIFF_SNOW_WAT_ROAD,ZDIFF_SNOW_WAT_ROOF,ZRHOI,          &
                 ZLW_WALA_TO_ROAD,ZLW_WALB_TO_ROAD,                                     &
                 ZLW_WIND_TO_ROAD,ZLW_WALA_TO_GARD,ZLW_WALB_TO_GARD,                    &
                 ZLW_WIND_TO_GARD,ZLW_ROAD_TO_WIND,ZLW_WALL_TO_WIND,                    &
                 ZLW_SNOW_TO_WIND,ZLW_GARD_TO_WIND,ZLW_ROAD_TO_WALA,                    &
                 ZLW_GARD_TO_WALA,ZLW_SNOW_TO_WALA,ZLW_WALB_TO_WALA,                    &
                 ZLW_WIND_TO_WALA,ZLW_ROAD_TO_WALB,ZLW_GARD_TO_WALB,                    &
                 ZLW_SNOW_TO_WALB,ZLW_WALA_TO_WALB,ZLW_WIND_TO_WALB,                    &
                 ZLW_WALA_TO_SNOW,ZLW_WALB_TO_SNOW,ZLW_WIND_TO_SNOW,ZDEEP_FLUX,         &
                 ZU10M,ZDIAGVENT,ZDIAGVEFL,ZSEN_GREENROOF,ZLAT_GREENROOF,      &
                 ZDRAIN_ROAD, ZDRAIN_BLD, ZNOC_ROOF, ZNOC_ROAD, ZFLUXFLOOR,             &
                 ZFLX_BLD_ROOF, ZFLX_BLD_WALL_A, ZFLX_BLD_WALL_B                        )
!
!***
! The internal heat release as well as the heating and
! cooling energy demand are converted from W/m²(bld)
! to W/m²(urb). CAUTION: this might cause errors
! if the changed definition of HVAC_HT and HVAC_CL
! collides with old plotting routines.
!
ZQINOUT   (:) = TM%T%CUR%XBLD(:) * ZQINOUT(:)
ZHVAC_COOL(:) = TM%T%CUR%XBLD(:) * ZHVAC_COOL(:)
ZHVAC_HEAT(:) = TM%T%CUR%XBLD(:) * ZHVAC_HEAT(:)
!
DO JCOMP=1,SIZE(ZCOMP_QINOUT,2)
  ZCOMP_QINOUT   (:,JCOMP) = TM%T%CUR%XBLD(:) * ZCOMP_QINOUT(:,JCOMP)
  ZCOMP_HVAC_COOL(:,JCOMP) = TM%T%CUR%XBLD(:) * ZCOMP_HVAC_COOL(:,JCOMP)
  ZCOMP_HVAC_HEAT(:,JCOMP) = TM%T%CUR%XBLD(:) * ZCOMP_HVAC_HEAT(:,JCOMP)
ENDDO
!
IF (.NOT. TM%TOP%LCANOPY) THEN
  CALL ADD_PATCH_CONTRIB(JTEB_PATCH,ZAVG_T_CANYON,ZT_CAN)
  CALL ADD_PATCH_CONTRIB(JTEB_PATCH,ZAVG_Q_CANYON,ZQ_CAN)
!
! Momentum fluxes
!
  ZSFU = 0.
  ZSFV = 0.
  DO JJ=1,SIZE(PU)
    IF (ZWIND(JJ)>0.) THEN
      ZCOEF(JJ) = - PRHOA(JJ) * ZUSTAR(JJ)**2 / ZWIND(JJ)
      ZSFU(JJ) = ZCOEF(JJ) * PU(JJ)
      ZSFV(JJ) = ZCOEF(JJ) * PV(JJ)
    ENDIF
  ENDDO
  CALL ADD_PATCH_CONTRIB(JTEB_PATCH,PSFU,ZSFU)
  CALL ADD_PATCH_CONTRIB(JTEB_PATCH,PSFV,ZSFV)
!
ENDIF
!
!-------------------------------------------------------------------------------------
! Outputs:
!-------------------------------------------------------------------------------------
!
! Grid box average fluxes/properties: Arguments and standard diagnostics
!
 CALL ADD_PATCH_CONTRIB(JTEB_PATCH,PSFTH,ZH)
 CALL ADD_PATCH_CONTRIB(JTEB_PATCH,PSFTQ,ZEVAP)
 CALL ADD_PATCH_CONTRIB(JTEB_PATCH,PSFCO2,ZSFCO2)
!
!
! Albedo for each wavelength and patch
!
DO JSWB=1,SIZE(PSW_BANDS)
  DO JJ=1,SIZE(ZDIR_ALB)
    ZDIR_ALB_PATCH(JJ,JSWB,JTEB_PATCH) = ZDIR_ALB(JJ)
    ZSCA_ALB_PATCH(JJ,JSWB,JTEB_PATCH) = ZSCA_ALB(JJ)
  ENDDO
END DO
!
! emissivity and radiative temperature
!
ZEMIS_PATCH(:,JTEB_PATCH) = ZEMIS
ZTRAD_PATCH(:,JTEB_PATCH) = ZTRAD
!
! computes some aggregated diagnostics
!
 CALL ADD_PATCH_CONTRIB(JTEB_PATCH,ZAVG_CD ,ZCD )
 CALL ADD_PATCH_CONTRIB(JTEB_PATCH,ZAVG_CDN,ZCDN)
 CALL ADD_PATCH_CONTRIB(JTEB_PATCH,ZAVG_RI ,ZRI )
 CALL ADD_PATCH_CONTRIB(JTEB_PATCH,ZAVG_CH ,ZCH )
 CALL ADD_PATCH_CONTRIB(JTEB_PATCH,ZAVG_RN ,ZRN )
 CALL ADD_PATCH_CONTRIB(JTEB_PATCH,ZAVG_H  ,ZH  )
 CALL ADD_PATCH_CONTRIB(JTEB_PATCH,ZAVG_LE ,ZLE )
 CALL ADD_PATCH_CONTRIB(JTEB_PATCH,ZAVG_GFLUX ,ZGFLUX )
!
!* warning: aerodynamical resistance does not yet take into account gardens
 CALL ADD_PATCH_CONTRIB(JTEB_PATCH,ZAVG_RESA_TOWN,1./ZRESA_TOWN)
IF (JTEB_PATCH==TM%TOP%NTEB_PATCH) ZAVG_RESA_TOWN = 1./ZAVG_RESA_TOWN
!
! ###############################################################
! ###############################################################
! Robert: Verification of energy conservation
! ###############################################################
! ###############################################################
!
! ############################################################
! A: Sensible heat stored
! ############################################################
!
! Sensible heat stored in the wall [J/m²(urb)]
!
ZTHEWALL(:)=0.0
DO JLAYER=1,SIZE(TM%T%CUR%XD_WALL,2)
   ZTHEWALL(:) = ZTHEWALL(:) + TM%T%CUR%XWALL_O_BLD(:)*TM%T%CUR%XBLD(:) * &
     TM%T%CUR%XD_WALL(:,JLAYER)*TM%T%CUR%XHC_WALL(:,JLAYER)          * &
     0.5*(TM%T%CUR%XT_WALL_A(:,JLAYER)+TM%T%CUR%XT_WALL_B(:,JLAYER))
ENDDO
!
! Sensible heat stored in the roof [J/m²(urb)]
!
ZTHEROOF(:)=0.0
DO JLAYER=1,SIZE(TM%T%CUR%XD_ROOF,2)
   ZTHEROOF(:) = ZTHEROOF(:) +       TM%T%CUR%XBLD(:) * &
     TM%T%CUR%XD_ROOF(:,JLAYER)*TM%T%CUR%XHC_ROOF(:,JLAYER)*TM%T%CUR%XT_ROOF(:,JLAYER)
ENDDO
!
! Sensible heat stored in the ground floor and the soil below [J/m²(urb)]
!
ZTHEFLOOR(:)=0.0
DO JLAYER=1,SIZE(TM%T%CUR%XT_ALLBLD,2)
   DO JCOMP=1,SIZE(TM%T%CUR%XT_ALLBLD,3)
      ZTHEFLOOR(:) = ZTHEFLOOR(:) + TM%B%CUR%XFRACOMP(:,JCOMP) * &
       TM%T%CUR%XBLD(:) * TM%T%CUR%XD_ALLBLD(:,JLAYER) *         &
       TM%T%CUR%XHC_ALLBLD(:,JLAYER)*TM%T%CUR%XT_ALLBLD(:,JLAYER,JCOMP)
   ENDDO
ENDDO
!
! Sensible heat stored in the mass [J/m²(urb)]
! The mass temperature can be averaged over the compartiments
!
ZTHEMASS(:) = 0.0
DO JJ=1,SIZE(TM%B%CUR%XN_FLOOR)
   IF (TM%B%CUR%XN_FLOOR(JJ).GT.1.5) THEN
      DO JLAYER=1,SIZE(TM%B%CUR%XT_MASS,2)
         DO JCOMP=1,SIZE(TM%B%CUR%XT_MASS,3)
            ZTHEMASS(JJ) = ZTHEMASS(JJ) + TM%B%CUR%XFRACOMP(JJ,JCOMP) * &
              TM%T%CUR%XBLD(JJ) * TM%B%CUR%XMASS_O_BLD(JJ) *            &
              TM%B%CUR%XD_MASS(JJ,JLAYER)*TM%B%CUR%XHC_MASS(JJ,JLAYER)* &
              TM%B%CUR%XT_MASS(JJ,JLAYER,JCOMP)
         ENDDO
      ENDDO
   ELSE
      ZTHEMASS(JJ)=0.0
   ENDIF
ENDDO
!
! Sensible heat stored in the road [J/m²(urb)]
!
ZTHEROAD(:)=0.0
DO JLAYER=1,SIZE(TM%T%CUR%XT_ROAD,2)
   ZTHEROAD(:) = ZTHEROAD(:) +  TM%T%CUR%XROAD(:)           * &
     TM%T%CUR%XD_ROAD(:,JLAYER)*TM%T%CUR%XHC_ROAD(:,JLAYER) * &
     TM%T%CUR%XT_ROAD(:,JLAYER)
ENDDO
!
! Sensible heat stored in the indoor air [J/m²(urb)]
!
ZTHEAIRIN(:)=0.0
IF (TM%TOP%CBEM.EQ."BEM") THEN
   DO JCOMP=1,SIZE(TM%B%CUR%XFRACOMP,2)
      ZTHEAIRIN(:) =  ZTHEAIRIN(:) + TM%B%CUR%XFRACOMP(:,JCOMP) * & 
         TM%T%CUR%XBLD(:)*XCPD*TM%T%CUR%XBLD_HEIGHT(:)*ZRHOI(:,JCOMP)*TM%B%CUR%XTI_BLD(:,JCOMP)
   ENDDO
ENDIF
!
! Total sensible heat stored [J/m²(urb)]
!
ZTHETOTAL(:)=ZTHEWALL(:)+ZTHEROOF(:)+ZTHEFLOOR(:)+ZTHEMASS(:)+ &
   ZTHEROAD(:)+ZTHEAIRIN(:)
!
! ####################################################
! B: Latent heat stored
! ####################################################
!
! Latent heat stored in the roof water and ice reservoir [J/m²(urb)]
!
ZLATWATROOF(:)=(1.0-TM%T%CUR%XGREENROOF(:))*TM%T%CUR%XBLD(:)*XLVTT*TM%T%CUR%XWS_ROOF(:)
ZLATICEROOF(:)=(1.0-TM%T%CUR%XGREENROOF(:))*TM%T%CUR%XBLD(:)*XLSTT*TM%T%CUR%TSNOW_ROOF%WSNOW(:,1,1)
!
! Latent heat stored in the road water and ice reservoir [J/m²(urb)]
!
ZLATWATROAD(:)=TM%T%CUR%XROAD(:)*XLVTT*TM%T%CUR%XWS_ROAD(:)
ZLATICEROAD(:)=TM%T%CUR%XROAD(:)*XLSTT*TM%T%CUR%TSNOW_ROAD%WSNOW(:,1,1)
!
! Latent heat stored in the indoor air humidity [J/m²(urb)]
!
ZLATAIRIN(:)=0.0
IF (TM%TOP%CBEM.EQ."BEM") THEN
   DO JCOMP=1,SIZE(TM%B%CUR%XFRACOMP,2)
      ZLATAIRIN(:) = ZLATAIRIN(:) + TM%B%CUR%XFRACOMP(:,JCOMP) * TM%T%CUR%XBLD(:)* &
         XLVTT*TM%T%CUR%XBLD_HEIGHT(:)*ZRHOI(:,JCOMP)*TM%B%CUR%XQI_BLD(:,JCOMP)
   ENDDO
ENDIF
!
! Total latent heat stored [J/m²(urb)]
!
ZLATTOTAL(:)=ZLATWATROOF(:)+ZLATICEROOF(:)+ZLATWATROAD(:)+ZLATICEROAD(:)+ZLATAIRIN(:)
!
! Total energy stored in TEB-BEM [J/m²(urb)]
!
ZENETOTAL(:)=ZLATTOTAL(:)+ZTHETOTAL(:)
!
! #######################################################
! C: Differences of storage terms to previous time step
! #######################################################
!
ZDIFFTHEAIRIN(:)   = (ZTHEAIRIN(:)   - TM%T%CUR%XTHEAIRIN(:))/PTSTEP
ZDIFFTHEWALL(:)    = (ZTHEWALL(:)    - TM%T%CUR%XTHEWALL(:))/PTSTEP
ZDIFFTHEROOF(:)    = (ZTHEROOF(:)    - TM%T%CUR%XTHEROOF(:))/PTSTEP
ZDIFFTHEFLOOR(:)   = (ZTHEFLOOR(:)   - TM%T%CUR%XTHEFLOOR(:))/PTSTEP
ZDIFFTHEMASS(:)    = (ZTHEMASS(:)    - TM%T%CUR%XTHEMASS(:))/PTSTEP
ZDIFFTHEROAD(:)    = (ZTHEROAD(:)    - TM%T%CUR%XTHEROAD(:))/PTSTEP
ZDIFFTHESNOWROAD(:)= TM%T%CUR%XROAD(:)*ZDN_ROAD(:)*ZDQS_SNOW_ROAD(:)
ZDIFFTHESNOWROOF(:)= (1.0-TM%T%CUR%XGREENROOF(:))*TM%T%CUR%XBLD(:)*ZDN_ROOF(:)*ZDQS_SNOW_ROOF(:)
ZDIFFTHETOTAL(:)   = (ZTHETOTAL(:)   - TM%T%CUR%XTHETOTAL(:))/PTSTEP
ZDIFFLATWATROOF(:) = (ZLATWATROOF(:) - TM%T%CUR%XLATWATROOF(:))/PTSTEP
ZDIFFLATWATROAD(:) = (ZLATWATROAD(:) - TM%T%CUR%XLATWATROAD(:))/PTSTEP
ZDIFFLATICEROOF(:) = (ZLATICEROOF(:) - TM%T%CUR%XLATICEROOF(:))/PTSTEP
ZDIFFLATICEROAD(:) = (ZLATICEROAD(:) - TM%T%CUR%XLATICEROAD(:))/PTSTEP
ZDIFFLATAIRIN(:)   = (ZLATAIRIN(:)   - TM%T%CUR%XLATAIRIN(:))/PTSTEP
ZDIFFLATTOTAL(:)   = (ZLATTOTAL(:)   - TM%T%CUR%XLATTOTAL(:))/PTSTEP
ZDIFFENETOTAL(:)   = (ZENETOTAL(:)   - TM%T%CUR%XENETOTAL(:))/PTSTEP
!
! #######################################################
! D: Sources of sensible and latent heat
! #######################################################
!
! Sensible and latent heat flux (W/m²(urb))
!
ZSRCSENFLX(:) = -ZH(:)
ZSRCLATFLX(:) = -ZLE(:)
!
! Net radiation (W/m²(urb))
!
ZSRCNETRAD(:) = ZRN(:)
!
! Production by solar panels (W/m²(urb))
!
IF (TM%TOP%LSOLAR_PANEL) THEN
   ZSRCPROPAN(:)=TM%T%CUR%XBLD(:)*ZPROD_BLD(:)
ELSE
   ZSRCPROPAN(:)=0.0
ENDIF
!
! Storage flux in garden (W/m²(urb))
!
ZSRCSTOGAR(:) = -TM%T%CUR%XGARDEN(:)*ZGFLUX_GARDEN(:)
!
! Anthropogenic sources (W/m²(urb))
!
IF (TM%TOP%CBEM.EQ."BEM") THEN
   ZSRCSENINT(:) = ZQINOUT(:)*(1.0-TM%B%CUR%XQIN_FLAT(:))
   ZSRCLATINT(:) = ZQINOUT(:)*(    TM%B%CUR%XQIN_FLAT(:))
   ZSRCHVACCL(:) = ZHVAC_COOL(:)
   ZSRCHVACHT(:) = ZHVAC_HEAT(:)
ELSE
   ZSRCSENINT(:) = 0.0
   ZSRCLATINT(:) = 0.0
   ZSRCHVACCL(:) = 0.0
   ZSRCHVACHT(:) = 0.0
ENDIF
!
! For CBEM=DEF the heat flux into the ground floor and convective 
! air exchange between indoor air and the roof and walls become
! source terms
!
IF (TM%TOP%CBEM.EQ."DEF") THEN
   ZSRCFLXFLO(:) = ZFLUXFLOOR(:)
   ZSRCFLXROF(:) = TM%T%CUR%XBLD(:)*ZFLX_BLD_ROOF(:)
   ZSRCFLXWAL(:) = TM%T%CUR%XBLD(:)*TM%T%CUR%XWALL_O_BLD(:)*0.5*(ZFLX_BLD_WALL_A(:)+ZFLX_BLD_WALL_B(:))
ELSE
   ZSRCFLXFLO(:) = 0.0
   ZSRCFLXROF(:) = 0.0
   ZSRCFLXWAL(:) = 0.0
ENDIF
!
ZSRCHTRAFF(:) = ZH_TRAFFIC(:)
ZSRCLTRAFF(:) = ZLE_TRAFFIC(:)
ZSRCHINDUS(:) = TM%T%CUR%XH_INDUSTRY(:)
ZSRCLINDUS(:) = TM%T%CUR%XLE_INDUSTRY(:)
!
! Use the modulated fields of traffic and industry releases
! for the output
!
ZH_TRAFFIC_OUT(:)  = ZH_TRAFFIC(:)
ZLE_TRAFFIC_OUT(:) = ZLE_TRAFFIC(:)
ZH_INDUSTRY_OUT(:) = TM%T%CUR%XH_INDUSTRY(:)
ZLE_INDUSTRY_OUT(:)= TM%T%CUR%XLE_INDUSTRY(:)
!
! Latent heat increase due to rain and snow
! on non-garden surfaces (W/m²(urb))
!
ZSRCLATRAI(:) = (1.0-TM%T%CUR%XGARDEN(:))*XLVTT*PRAIN(:)
ZSRCLATSNO(:) = (1.0-TM%T%CUR%XGARDEN(:))*XLSTT*PSNOW(:)
!
! Latent heat increase due to road and garden irrigation (W/m²(urb))
!
ZSRCLATROI(:) = TM%T%CUR%XROAD(:)*XLVTT*ZIRRIG_ROAD(:)
ZSRCLATGRI(:) = XLVTT*TM%T%CUR%XBLD(:)*TM%T%CUR%XGREENROOF(:)*ZIRRIG_GREENROOF(:)
!
! Latent heat decrease due to run-off (W/m²(urb))
!
ZSRCRUNROF(:) = -TM%T%CUR%XBLD(:) *XLVTT*ZRUNOFF_ROOF(:)
ZSRCRUNROD(:) = -TM%T%CUR%XROAD(:)*XLVTT*ZRUNOFF_ROAD(:)
!
! Latent heat decrease to to run-off not going to sewer (W/m²(urb))
!
ZSRCNOCROF(:) = -TM%T%CUR%XBLD(:) *XLVTT*ZNOC_ROOF(:)
ZSRCNOCROD(:) = -TM%T%CUR%XROAD(:)*XLVTT*ZNOC_ROAD(:)
!
! Conversion from latent to sensible heat during
! condensation on roofs and roads (W/m²(urb))
!
ZCONV_LAT_SEN_ROAD(:) = TM%T%CUR%XROAD(:)*ZCONV_LAT_SEN_ROAD(:)
ZCONV_LAT_SEN_ROOF(:) = TM%T%CUR%XBLD (:)*ZCONV_LAT_SEN_ROOF(:)
!
! Heating/cooling of rain water falling on roofs and roads (W/m²(urb))
!
ZHEAT_RR_ROAD(:) = -TM%T%CUR%XROAD(:)*ZHEAT_RR_ROAD(:)
ZHEAT_RR_ROOF(:) = -TM%T%CUR%XBLD (:)*ZHEAT_RR_ROOF(:)
!
! Heating/cooling due to snow falling on roofs and road (W/m²(urb))
!
ZSEN_SNOW_DIF_ROAD(:)=TM%T%CUR%XROAD(:)*ZSEN_SNOW_DIF_ROAD(:)
ZSEN_SNOW_DIF_ROOF(:)=(1.0-TM%T%CUR%XGREENROOF(:))*TM%T%CUR%XBLD (:)*ZSEN_SNOW_DIF_ROOF(:)
!
! Sum of sources and sinks separed for latent and sensible heat (W/m²(urb))
!
ZSRCSENSUM(:) = ZSRCSENFLX(:) + ZSRCNETRAD(:) - ZSRCPROPAN(:) + &
    ZSRCSENINT(:)+ZSRCFLXFLO + ZSRCFLXROF +  ZSRCFLXWAL       + &
    ZSRCHVACCL(:)+ZSRCHVACHT(:)+ZSRCHTRAFF(:)+ZSRCHINDUS(:)   + &
    ZHEAT_RR_ROAD(:)+ZHEAT_RR_ROOF(:)+ZSEN_SNOW_DIF_ROAD(:)   + &
    ZSEN_SNOW_DIF_ROOF(:)-ZSEN_MELT_ROAD(:)-ZSEN_MELT_ROOF(:) - &
    ZDIFFTHESNOWROAD(:)-ZDIFFTHESNOWROOF(:)+ZSRCSTOGAR(:) - ZSEN_GREENROOF(:)
!
ZSRCLATSUM(:) = ZSRCLATFLX(:) + ZSRCLATINT(:)      + &
   ZSRCLTRAFF(:) + ZSRCLINDUS(:)+ZSRCLATRAI(:)+ZSRCLATSNO(:)  + &
   ZSRCLATROI(:)+ZSRCLATGRI(:)+ZSRCRUNROF(:) + ZSRCRUNROD(:)  + &
   ZSRCNOCROF(:) + ZSRCNOCROD(:) - ZDIFF_SNOW_WAT_ROAD(:)     - &
   ZDIFF_SNOW_WAT_ROOF(:) - ZLAT_GREENROOF(:)                 
!
! Total sum with conversion terms
!
ZSRCALLSUM(:) = ZSRCSENSUM(:)+ZSRCLATSUM(:)+ZCONV_LAT_SEN_ROAD(:)+ZCONV_LAT_SEN_ROOF(:)
!
! #######################################################
! Save results of current time step 
! #######################################################
!
GCHECK_BUDGET(:) = .TRUE.
WHERE (TM%T%CUR%XENETOTAL.EQ.XUNDEF) GCHECK_BUDGET = .FALSE.
!
TM%T%CUR%XENETOTAL(:)   = ZENETOTAL(:)
TM%T%CUR%XTHEWALL(:)    = ZTHEWALL(:)
TM%T%CUR%XTHEROOF(:)    = ZTHEROOF(:)
TM%T%CUR%XTHEFLOOR(:)   = ZTHEFLOOR(:)
TM%T%CUR%XTHEMASS(:)    = ZTHEMASS(:)
TM%T%CUR%XTHEROAD(:)    = ZTHEROAD(:)
TM%T%CUR%XTHEAIRIN(:)   = ZTHEAIRIN(:)
TM%T%CUR%XTHETOTAL(:)   = ZTHETOTAL(:)
TM%T%CUR%XLATWATROOF(:) = ZLATWATROOF(:)
TM%T%CUR%XLATWATROAD(:) = ZLATWATROAD(:)
TM%T%CUR%XLATICEROOF(:) = ZLATICEROOF(:)
TM%T%CUR%XLATICEROAD(:) = ZLATICEROAD(:)
TM%T%CUR%XLATAIRIN(:)   = ZLATAIRIN(:)
TM%T%CUR%XLATTOTAL(:)   = ZLATTOTAL(:)
!
! The model is halted when there is a violation of 
! energy conservation of more than 1.0E-6 W/m²(urb)
!
DO JJ=1,SIZE(ZDIFFENETOTAL)
   !
   IF (GCHECK_BUDGET(JJ)) THEN
      !
      ! Check for NAN
      !
      IF (ISNAN(ZDIFFENETOTAL(JJ))) CALL ABOR1_SFX("NAN detected in energy budget diagnostics")
      IF (ISNAN(ZSRCALLSUM   (JJ))) CALL ABOR1_SFX("NAN detected in energy budget diagnostics")
      !
      IF (ABS(ZDIFFENETOTAL(JJ)-ZSRCALLSUM(JJ)).GT.1.0E-3) THEN
         !
         CALL GET_LUOUT(HPROGRAM,ILUOUT)
         !
         WRITE(ILUOUT,*) "                                                                      "
         WRITE(ILUOUT,*) "----------------------------------------------------------------------"
         WRITE(ILUOUT,*) "----------------------------------------------------------------------"
         WRITE(ILUOUT,*) "Violation of energy conservation, JJ= ",JJ
         WRITE(ILUOUT,*) "Solar time [s] :                      ",PTSUN(JJ)
         WRITE(ILUOUT,*) "----------------------------------------------------------------------"
         WRITE(ILUOUT,*) "----------------------------------------------------------------------"
         WRITE(ILUOUT,*) "Difference of energy stored ------------------------------------------"
         WRITE(ILUOUT,*) "----------------------------------------------------------------------"
         WRITE(ILUOUT,'(A34,1X,F10.4)') "Floor sensible heat  (W/m²(urb)): ",ZDIFFTHEFLOOR(JJ)
         WRITE(ILUOUT,'(A34,1X,F10.4)') "Roof sensible heat   (W/m²(urb)): ",ZDIFFTHEROOF(JJ)
         WRITE(ILUOUT,'(A34,1X,F10.4)') "Wall sensible heat   (W/m²(urb)): ",ZDIFFTHEWALL(JJ)
         WRITE(ILUOUT,'(A34,1X,F10.4)') "Mass sensible heat   (W/m²(urb)): ",ZDIFFTHEMASS(JJ)
         WRITE(ILUOUT,'(A34,1X,F10.4)') "Road sensible heat   (W/m²(urb)): ",ZDIFFTHEROAD(JJ)
         WRITE(ILUOUT,'(A34,1X,F10.4)') "Road snow sen heat   (W/m²(urb)): ",ZDIFFTHESNOWROAD(JJ)
         WRITE(ILUOUT,'(A34,1X,F10.4)') "Roof snow sen heat   (W/m²(urb)): ",ZDIFFTHESNOWROOF(JJ)
         WRITE(ILUOUT,'(A34,1X,F10.4)') "Garden sensible heat (W/m²(urb)): ",ZSRCSTOGAR(JJ)
         WRITE(ILUOUT,'(A34,1X,F10.4)') "Green roof sen. heat (W/m²(urb)): ",ZSEN_GREENROOF(JJ)
         WRITE(ILUOUT,'(A34,1X,F10.4)') "Green roof lat. heat (W/m²(urb)): ",ZLAT_GREENROOF(JJ)
         WRITE(ILUOUT,'(A34,1X,F10.4)') "In air sensible heat (W/m²(urb)): ",ZDIFFTHEAIRIN(JJ)
         WRITE(ILUOUT,'(A34,1X,F10.4)') "Roof wat latent heat (W/m²(urb)): ",ZDIFFLATWATROOF(JJ)
         WRITE(ILUOUT,'(A34,1X,F10.4)') "Roof ice latent heat (W/m²(urb)): ",ZDIFFLATICEROOF(JJ)
         WRITE(ILUOUT,'(A34,1X,F10.4)') "Road wat latent heat (W/m²(urb)): ",ZDIFFLATWATROAD(JJ)
         WRITE(ILUOUT,'(A34,1X,F10.4)') "Road ice latent heat (W/m²(urb)): ",ZDIFFLATICEROAD(JJ)
         WRITE(ILUOUT,'(A34,1X,F10.4)') "Indo air latent heat (W/m²(urb)): ",ZDIFFLATAIRIN(JJ)
         WRITE(ILUOUT,*) "----------------------------------------------------------------------"
         WRITE(ILUOUT,'(A34,1X,F10.4)') "Total sensible heat  (W/m²(urb)): ",ZDIFFTHETOTAL(JJ)
         WRITE(ILUOUT,'(A34,1X,F10.4)') "Total    latent heat (W/m²(urb)): ",ZDIFFLATTOTAL(JJ)
         WRITE(ILUOUT,'(A34,1X,F10.4)') "Total           heat (W/m²(urb)): ",ZDIFFENETOTAL(JJ)
         WRITE(ILUOUT,*) "----------------------------------------------------------------------"
         WRITE(ILUOUT,*) "Sources and sinks                                                     "
         WRITE(ILUOUT,*) "----------------------------------------------------------------------"
         WRITE(ILUOUT,'(A35,1X,F10.4)') "Sensible heat flux   (W/m²(Urb)): ",ZSRCSENFLX(JJ)
         WRITE(ILUOUT,'(A35,1X,F10.4)') "Latent   heat flux   (W/m²(Urb)): ",ZSRCLATFLX(JJ)
         WRITE(ILUOUT,'(A35,1X,F10.4)') "Net radiation        (W/m²(Urb)): ",ZSRCNETRAD(JJ)
         WRITE(ILUOUT,'(A35,1X,F10.4)') "Solar panel prod.    (W/m²(Urb)): ",ZSRCPROPAN(JJ)
         WRITE(ILUOUT,'(A35,1X,F10.4)') "Internal heat, sen   (W/m²(Urb)): ",ZSRCSENINT(JJ)
         WRITE(ILUOUT,'(A35,1X,F10.4)') "Internal heat, lat   (W/m²(Urb)): ",ZSRCLATINT(JJ)
         WRITE(ILUOUT,'(A35,1X,F10.4)') "Cooling demand       (W/m²(Urb)): ",ZSRCHVACCL(JJ)
         WRITE(ILUOUT,'(A35,1X,F10.4)') "Heating demand       (W/m²(Urb)): ",ZSRCHVACHT(JJ)
         WRITE(ILUOUT,'(A35,1X,F10.4)') "Flux to ground floor (W/m²(Urb)): ",ZSRCFLXFLO(JJ)
         WRITE(ILUOUT,'(A35,1X,F10.4)') "Flux roof to indoor  (W/m²(Urb)): ",ZSRCFLXROF(JJ)
         WRITE(ILUOUT,'(A35,1X,F10.4)') "Flux wall to indoor  (W/m²(Urb)): ",ZSRCFLXWAL(JJ)
         WRITE(ILUOUT,'(A35,1X,F10.4)') "Traffic sensible     (W/m²(Urb)): ",ZSRCHTRAFF(JJ)
         WRITE(ILUOUT,'(A35,1X,F10.4)') "Traffic latent       (W/m²(Urb)): ",ZSRCLTRAFF(JJ)
         WRITE(ILUOUT,'(A35,1X,F10.4)') "Industry sensible    (W/m²(Urb)): ",ZSRCHINDUS(JJ)
         WRITE(ILUOUT,'(A35,1X,F10.4)') "Industry latent      (W/m²(Urb)): ",ZSRCLINDUS(JJ)
         WRITE(ILUOUT,'(A35,1X,F10.4)') "Rain latent          (W/m²(Urb)): ",ZSRCLATRAI(JJ)
         WRITE(ILUOUT,'(A35,1X,F10.4)') "Snow latent          (W/m²(Urb)): ",ZSRCLATSNO(JJ)
         WRITE(ILUOUT,'(A35,1X,F10.4)') "Road irrig. latent   (W/m²(Urb)): ",ZSRCLATROI(JJ)
         WRITE(ILUOUT,'(A35,1X,F10.4)') "Green roof ir. lat.  (W/m²(Urb)): ",ZSRCLATGRI(JJ)
         WRITE(ILUOUT,'(A35,1X,F10.4)') "Rain h/c road        (W/m²(Urb)): ",ZHEAT_RR_ROAD(JJ)
         WRITE(ILUOUT,'(A35,1X,F10.4)') "Rain h/c roof        (W/m²(Urb)): ",ZHEAT_RR_ROOF(JJ)
         WRITE(ILUOUT,'(A35,1X,F10.4)') "Snow h/c road        (W/m²(Urb)): ",ZSEN_SNOW_DIF_ROAD(JJ)
         WRITE(ILUOUT,'(A35,1X,F10.4)') "Snow h/c roof        (W/m²(Urb)): ",ZSEN_SNOW_DIF_ROOF(JJ)
         WRITE(ILUOUT,'(A35,1X,F10.4)') "Roof runoff          (W/m²(Urb)): ",ZSRCRUNROF(JJ)
         WRITE(ILUOUT,'(A35,1X,F10.4)') "Road runoff          (W/m²(Urb)): ",ZSRCRUNROD(JJ)
         WRITE(ILUOUT,'(A35,1X,F10.4)') "Roof runoff no sewer (W/m²(Urb)): ",ZSRCNOCROF(JJ)
         WRITE(ILUOUT,'(A35,1X,F10.4)') "Road runoff no sewer (W/m²(Urb)): ",ZSRCNOCROD(JJ)
         WRITE(ILUOUT,'(A35,1X,F10.4)') "Sen heat melt road   (W/m²(Urb)): ",ZSEN_MELT_ROAD(JJ)
         WRITE(ILUOUT,'(A35,1X,F10.4)') "Sen heat melt roof   (W/m²(Urb)): ",ZSEN_MELT_ROOF(JJ)
         WRITE(ILUOUT,'(A35,1X,F10.4)') "Snow water conv road (W/m²(Urb)): ",ZDIFF_SNOW_WAT_ROAD(JJ)
         WRITE(ILUOUT,'(A35,1X,F10.4)') "Snow water conv roof (W/m²(Urb)): ",ZDIFF_SNOW_WAT_ROOF(JJ)
         WRITE(ILUOUT,*) "----------------------------------------------------------------------"
         WRITE(ILUOUT,'(A35,1X,F10.4)') "Sensible sum         (W/m²(Urb)): ",ZSRCSENSUM(JJ)
         WRITE(ILUOUT,'(A35,1X,F10.4)') "Latent sum           (W/m²(Urb)): ",ZSRCLATSUM(JJ)
         WRITE(ILUOUT,*) "----------------------------------------------------------------------"
         WRITE(ILUOUT,*) " Conversion between latent and sensible heat                          "
         WRITE(ILUOUT,*) "----------------------------------------------------------------------"
         WRITE(ILUOUT,'(A35,1X,F10.4)') "Roof                 (W/m²(Urb)): ",ZCONV_LAT_SEN_ROOF(JJ)
         WRITE(ILUOUT,'(A35,1X,F10.4)') "Road                 (W/m²(Urb)): ",ZCONV_LAT_SEN_ROAD(JJ)
         WRITE(ILUOUT,*) "----------------------------------------------------------------------"
         WRITE(ILUOUT,'(A35,1X,F10.4)') "Total sum            (W/m²(Urb)): ",ZSRCALLSUM(JJ)
         WRITE(ILUOUT,*) "----------------------------------------------------------------------"
         WRITE(ILUOUT,*) " Storage difference - sources and sinks (must be zero)                "
         WRITE(ILUOUT,*) "----------------------------------------------------------------------"
         WRITE(ILUOUT,'(A35,1X,F10.4)') "Energy budget imb.   (W/m²(Urb)): ",ZDIFFENETOTAL(JJ)-ZSRCALLSUM(JJ)
         WRITE(ILUOUT,*) "----------------------------------------------------------------------"
         WRITE(ILUOUT,*) "----------------------------------------------------------------------"
         WRITE(ILUOUT,*) "Diagnostics of outdoor longwave radiation imbalance not               "
         WRITE(ILUOUT,*) "detectable by the energy budget based on net radiation                "
         WRITE(ILUOUT,*) "----------------------------------------------------------------------"
         WRITE(ILUOUT,'(A35,1X,F10.4)') " Garden <--> Wall A  (W/m²(Urb)): ",ZLW_WALA_TO_GARD(JJ)+ZLW_GARD_TO_WALA(JJ)
         WRITE(ILUOUT,'(A35,1X,F10.4)') " Garden <--> Wall B  (W/m²(Urb)): ",ZLW_WALB_TO_GARD(JJ)+ZLW_GARD_TO_WALB(JJ)
         WRITE(ILUOUT,'(A35,1X,F10.4)') " Road   <--> Wall A  (W/m²(Urb)): ",ZLW_WALA_TO_ROAD(JJ)+ZLW_ROAD_TO_WALA(JJ)
         WRITE(ILUOUT,'(A35,1X,F10.4)') " Road   <--> Wall B  (W/m²(Urb)): ",ZLW_WALB_TO_ROAD(JJ)+ZLW_ROAD_TO_WALB(JJ)
         WRITE(ILUOUT,'(A35,1X,F10.4)') " Snow   <--> Wall A  (W/m²(Urb)): ",ZLW_WALA_TO_SNOW(JJ)+ZLW_SNOW_TO_WALA(JJ)
         WRITE(ILUOUT,'(A35,1X,F10.4)') " Snow   <--> Wall B  (W/m²(Urb)): ",ZLW_WALB_TO_SNOW(JJ)+ZLW_SNOW_TO_WALB(JJ)
         WRITE(ILUOUT,'(A35,1X,F10.4)') " Window <--> Walls   (W/m²(Urb)): ", & 
            ZLW_WALL_TO_WIND(JJ)+(ZLW_WIND_TO_WALA(JJ)+ZLW_WIND_TO_WALB(JJ))
         WRITE(ILUOUT,'(A35,1X,F10.4)') " Window <--> Road    (W/m²(Urb)): ",ZLW_ROAD_TO_WIND(JJ)+ZLW_WIND_TO_ROAD(JJ)
         WRITE(ILUOUT,'(A35,1X,F10.4)') " Window <--> Garden  (W/m²(Urb)): ",ZLW_GARD_TO_WIND(JJ)+ZLW_WIND_TO_GARD(JJ)
         WRITE(ILUOUT,'(A35,1X,F10.4)') " Window <--> Snow    (W/m²(Urb)): ",ZLW_SNOW_TO_WIND(JJ)+ZLW_WIND_TO_SNOW(JJ)
         WRITE(ILUOUT,'(A35,1X,F10.4)') " Wall A <--> Wall B  (W/m²(Urb)): ",ZLW_WALB_TO_WALA(JJ)+ZLW_WALA_TO_WALB(JJ)
         WRITE(ILUOUT,*) "----------------------------------------------------------------------"
         WRITE(ILUOUT,*) "----------------------------------------------------------------------"
         WRITE(ILUOUT,*) "Model halt due to violation of energy conservation "
         WRITE(ILUOUT,*) "This can be due to coding errors or missing        "
         WRITE(ILUOUT,*) "reservoirs and processes, please check             "
         WRITE(ILUOUT,*) "----------------------------------------------------------------------"
         WRITE(ILUOUT,*) "----------------------------------------------------------------------"
         CALL FLUSH(ILUOUT)
         !
         CALL ABOR1_SFX("Violation of energy conservation")
         !
      ENDIF
   ENDIF
ENDDO
!
! Robert: Calculation of new output diagnostics
!
! Sensible and latent heat storage in urban fabric (W/m²(urb))
!
ZSENFABSTOR(:)=ZDIFFTHEFLOOR(:)+ZDIFFTHEROOF(:)+ZDIFFTHEWALL(:)  + &
   ZDIFFTHEMASS(:) +ZDIFFTHEROAD(:)+ZDIFFTHEAIRIN(:)
!
ZLATFABSTOR(:)=ZDIFFLATWATROOF(:)+ZDIFFLATICEROOF(:)+ZDIFFLATWATROAD(:) + &
   ZDIFFLATICEROAD(:)+ZDIFFLATAIRIN(:)
!
! Total thickness of roof, wall and mass
!
ZROOFTK(:)=0.0
DO JLAYER=1,SIZE(TM%T%CUR%XT_ROOF,2)
   ZROOFTK(:)=ZROOFTK(:)+TM%T%CUR%XD_ROOF(:,JLAYER)
ENDDO
!
ZWALLTK(:)=0.0
DO JLAYER=1,SIZE(TM%T%CUR%XT_WALL_A,2)
   ZWALLTK(:)=ZWALLTK(:)+TM%T%CUR%XD_WALL(:,JLAYER)
ENDDO
!
ZMASSTK(:)=0.0
IF (TM%TOP%CBEM.EQ."BEM") THEN
   DO JJ=1,SIZE(TM%B%CUR%XN_FLOOR)
      IF (TM%B%CUR%XN_FLOOR(JJ).GT.1.5) THEN
         DO JLAYER=1,SIZE(TM%B%CUR%XD_MASS,2)
            ZMASSTK(JJ)=ZMASSTK(JJ)+TM%B%CUR%XD_MASS(JJ,JLAYER)
         ENDDO
      ENDIF
   ENDDO
ENDIF
!
! Conversion of internal heat release as well 
! as heating and cooling from W/m²(urb) into 
! kWh/m²(floor)/a
!
IF (TM%TOP%CBEM.EQ."BEM") THEN
   ZQIN_KWH     (:) = ( 0.365 * 24.0 * ZQINOUT(:)   ) / ( TM%T%CUR%XBLD(:) * TM%B%CUR%XN_FLOOR(:) )
   ZHVAC_HT_KWH (:) = ( 0.365 * 24.0 * ZHVAC_HEAT(:)) / ( TM%T%CUR%XBLD(:) * TM%B%CUR%XN_FLOOR(:) )
   ZHVAC_CL_KWH (:) = ( 0.365 * 24.0 * ZHVAC_COOL(:)) / ( TM%T%CUR%XBLD(:) * TM%B%CUR%XN_FLOOR(:) )
ELSE
   ZQIN_KWH     (:) = 0.0
   ZHVAC_HT_KWH (:) = 0.0
   ZHVAC_CL_KWH (:) = 0.0
ENDIF
!
! End verification of energy conservation
! ################################################################
!
!-------------------------------------------------------------------------------------
! Diagnostics on each patch
!-------------------------------------------------------------------------------------
!
 CALL DIAG_MISC_TEB_n(TM%DGCT, TM%DGMT, TM%DGMTO, TM%TOP, TM%T, TM%TG, HM, &
                      PTSTEP, ZDQS_TOWN, ZQF_BLD, ZQF_TOWN, ZFLX_BLD,           &
                     ZRUNOFF_TOWN,                                             &
                     ZRN_ROAD, ZH_ROAD, ZLE_ROAD, ZGFLUX_ROAD,                 &
                     ZRUNOFF_ROAD, ZIRRIG_ROAD,                                &
                     ZRN_WALL_A, ZH_WALL_A, ZGFLUX_WALL_A,                     &
                     ZRN_WALL_B, ZH_WALL_B, ZGFLUX_WALL_B,                     &
                     ZRN_ROOF, ZH_ROOF, ZLE_ROOF, ZGFLUX_ROOF, ZRUNOFF_ROOF,   &
                     ZRN_STRLROOF, ZH_STRLROOF, ZLE_STRLROOF, ZGFLUX_STRLROOF, &
                     ZRUNOFF_STRLROOF,                                         &
                     ZRN_GREENROOF, ZH_GREENROOF,                              &
                     ZLE_GREENROOF, ZGFLUX_GREENROOF, ZG_GREENROOF_ROOF,       &
                     ZRUNOFF_GREENROOF, ZDRAIN_GREENROOF,ZIRRIG_GREENROOF,     &
                     ZRN_GARDEN,ZH_GARDEN,ZLE_GARDEN,ZGFLUX_GARDEN,            &
                     ZRUNOFF_GARDEN, ZDRAIN_GARDEN, ZIRRIG_GARDEN,             &
                     ZRN_BLT,ZH_BLT,ZLE_BLT,ZGFLUX_BLT,                        &
                     ZRUNOFF_SEWER, ZRUNOFF_TOWNC,                             &
                     ZRUNOFF_ROADC, ZRUNOFF_ROOFC, ZRUNOFF_STRLROOFC,          &
                     ZRUNOFF_GARDENC, ZRUNOFF_SEWERC,                          &
                     ZDIS_TOWN, ZDIS_ROOF, ZDIS_ROAD, ZDIS_GARDEN, ZDIS_SEWER, &                                       
                     ZDRAIN_ROAD, ZDRAIN_BLD,                                  &
                     ZWG_ROAD_INI, ZWG_BLD_INI, ZWG_GARDEN_INI,                &
                     ZABS_SW_ROOF,ZABS_LW_ROOF,                                &
                     ZABS_SW_SNOW_ROOF,ZABS_LW_SNOW_ROOF,                      &
                     ZABS_SW_ROAD,ZABS_LW_ROAD,                                &
                     ZABS_SW_SNOW_ROAD,ZABS_LW_SNOW_ROAD,                      &
                     ZABS_SW_WALL_A, ZABS_LW_WALL_A, ZABS_SW_WALL_B,           &
                     ZABS_LW_WALL_B,                                           &
                     ZABS_SW_GARDEN,ZABS_LW_GARDEN,                            &
                     ZABS_SW_HVEG,ZABS_LW_HVEG,                                &
                     ZABS_SW_GREENROOF,ZABS_LW_GREENROOF,                      &
                     ZH_BLD_COOL, ZT_BLD_COOL,                                 &     
                     ZH_BLD_HEAT, ZLE_BLD_COOL, ZLE_BLD_HEAT,                  &
                     ZH_WASTE_CANY, ZLE_WASTE_CANY, ZH_WASTE_ROOF,             &
                     ZLE_WASTE_ROOF, ZHVAC_COOL, ZCOMP_HVAC_COOL,              &
                     ZHVAC_HEAT, ZCOMP_HVAC_HEAT, ZCAP_SYS, ZM_SYS, ZCOP,      &
                     ZQ_SYS, ZT_SYS, ZTR_SW_WIN, ZFAN_POWER,                   &
                     ZABS_SW_WIN, ZABS_LW_WIN,                                 &
                     ZABS_SW_PANEL, ZABS_LW_PANEL, ZRN_PANEL,                  &
                     ZH_PANEL, ZTHER_PROD_PANEL, ZPHOT_PROD_PANEL, ZPROD_PANEL,&
                     ZTHER_PROD_BLD, ZPHOT_PROD_BLD,                           &
                     ZQINOUT, ZCOMP_QINOUT, ZH_TRAFFIC_OUT, ZLE_TRAFFIC_OUT, ZH_INDUSTRY_OUT,&
                     ZLE_INDUSTRY_OUT, ZINFCALC, ZDIAGSHAD, ZDIAGVENT,         &
                     ZDIAGVEFL, ZBLDOCC, ZSENFABSTOR, ZLATFABSTOR, ZROOFTK,    &
                     ZWALLTK, ZMASSTK, ZU_LOWCAN, ZQIN_KWH, ZHVAC_HT_KWH,      &
                     ZHVAC_CL_KWH, PRAIN, PSNOW,                               &
                     ZEMIT_LW_FAC, ZEMIT_LW_GRND, ZROAD_SHADE                  )
!***
!
!
!-------------------------------------------------------------------------------------
! Computes averaged parameters necessary for UTCI
!-------------------------------------------------------------------------------------
!
IF (TM%DGT%N2M >0 .AND. TM%DGUT%LUTCI) THEN
  CALL ADD_PATCH_CONTRIB(JTEB_PATCH,ZAVG_REF_SW_GRND ,ZREF_SW_GRND )
  CALL ADD_PATCH_CONTRIB(JTEB_PATCH,ZAVG_REF_SW_FAC  ,ZREF_SW_FAC  )
  CALL ADD_PATCH_CONTRIB(JTEB_PATCH,ZAVG_REF_SW_HVEG ,ZREF_SW_HVEG )
  CALL ADD_PATCH_CONTRIB(JTEB_PATCH,ZAVG_SCA_SW      ,ZSCA_SW      )
  CALL ADD_PATCH_CONTRIB(JTEB_PATCH,ZAVG_DIR_SW      ,ZDIR_SW      )
  CALL ADD_PATCH_CONTRIB(JTEB_PATCH,ZAVG_EMIT_LW_FAC ,ZEMIT_LW_FAC )
  CALL ADD_PATCH_CONTRIB(JTEB_PATCH,ZAVG_EMIT_LW_GRND,ZEMIT_LW_GRND)
  !
  DO JCOMP=1,SIZE(TM%B%CUR%XTI_BLD,2)
     CALL ADD_PATCH_CONTRIB(JTEB_PATCH,ZAVG_T_RAD_IND(:,JCOMP),TM%B%CUR%XFRACOMP(:,JCOMP) * ZT_RAD_IND(:,JCOMP)       )
     CALL ADD_PATCH_CONTRIB(JTEB_PATCH,ZAVG_TI_BLD(:,JCOMP)   ,TM%B%CUR%XFRACOMP(:,JCOMP) * TM%B%CUR%XTI_BLD(:,JCOMP) )
     CALL ADD_PATCH_CONTRIB(JTEB_PATCH,ZAVG_QI_BLD(:,JCOMP)   ,TM%B%CUR%XFRACOMP(:,JCOMP) * TM%B%CUR%XQI_BLD(:,JCOMP) )
  ENDDO
  !
END IF
!
!-------------------------------------------------------------------------------------
! Use of the canopy version of TEB
!-------------------------------------------------------------------------------------
!
IF (TM%TOP%LCANOPY) THEN
!-------------------------------------------------------------------------------------
! Town averaged quantities to force canopy atmospheric layers
!-------------------------------------------------------------------------------------

 CALL ADD_PATCH_CONTRIB(JTEB_PATCH,ZAVG_DUWDU_GRND ,ZDUWDU_GRND )
 CALL ADD_PATCH_CONTRIB(JTEB_PATCH,ZAVG_UW_ROOF ,ZUW_ROOF)
 CALL ADD_PATCH_CONTRIB(JTEB_PATCH,ZAVG_DUWDU_ROOF ,ZDUWDU_ROOF)
 CALL ADD_PATCH_CONTRIB(JTEB_PATCH,ZAVG_H_WALL ,0.5*(ZH_WALL_A+ZH_WALL_B))
 CALL ADD_PATCH_CONTRIB(JTEB_PATCH,ZAVG_E_WALL ,(0.5*(ZLE_WALL_A + ZLE_WALL_B))/XLVTT)
 CALL ADD_PATCH_CONTRIB(JTEB_PATCH,ZAVG_H_ROOF ,(ZH_ROOF+TM%T%CUR%XH_INDUSTRY))
 CALL ADD_PATCH_CONTRIB(JTEB_PATCH,ZAVG_E_ROOF ,(ZLE_ROOF+TM%T%CUR%XLE_INDUSTRY)/XLVTT)
!
!-------------------------------------------------------------------------------------
! Computes the impact of canopy and surfaces on air
!-------------------------------------------------------------------------------------
!
ZAC_GRND    (:) = (TM%T%CUR%XROAD(:)*ZAC_ROAD    (:) + &
                TM%T%CUR%XGARDEN(:)*ZAC_GARDEN    (:)) / (TM%T%CUR%XROAD(:)+TM%T%CUR%XGARDEN(:))
ZAC_GRND_WAT(:) = (TM%T%CUR%XROAD(:)*ZAC_ROAD_WAT(:) + &
                TM%T%CUR%XGARDEN(:)*ZAC_GARDEN_WAT(:)) / (TM%T%CUR%XROAD(:)+TM%T%CUR%XGARDEN(:))
!
 CALL ADD_PATCH_CONTRIB(JTEB_PATCH,ZAVG_AC_GRND     ,ZAC_GRND    )
 CALL ADD_PATCH_CONTRIB(JTEB_PATCH,ZAVG_AC_GRND_WAT ,ZAC_GRND_WAT)
 CALL ADD_PATCH_CONTRIB(JTEB_PATCH,ZSFLUX_U ,ZUW_GRND * (1.-TM%T%CUR%XBLD))
 CALL ADD_PATCH_CONTRIB(JTEB_PATCH,ZSFLUX_T ,ZH_GRND  * (1.-TM%T%CUR%XBLD)/XCPD/PRHOA)
 CALL ADD_PATCH_CONTRIB(JTEB_PATCH,ZSFLUX_Q ,ZLE_GRND * (1.-TM%T%CUR%XBLD)/XLVTT)
!

END IF
!
!-------------------------------------------------------------------------------------
! end of loop on TEB patches
END DO
!-------------------------------------------------------------------------------------
!
!-------------------------------------------------------------------------------------
!* Evolution of canopy air if canopy option is active
!-------------------------------------------------------------------------------------
!
IF (TM%TOP%LCANOPY) THEN
!
!-------------------------------------------------------------------------------------
!* Impact of TEB fluxes on the air
!-------------------------------------------------------------------------------------
!
 CALL TEB_CANOPY(KI,TM%TCP%NLVL,TM%TCP%XZ,TM%TCP%XZF,TM%TCP%XDZ,TM%TCP%XDZF,ZAVG_BLD,&
                 ZAVG_BLD_HEIGHT,ZAVG_WALL_O_HOR, PPA,PRHOA,TM%TCP%XU,                &
                ZAVG_DUWDU_GRND, ZAVG_UW_ROOF, ZAVG_DUWDU_ROOF,                       &
                ZAVG_H_WALL,ZAVG_E_WALL,ZAVG_H_ROOF,ZAVG_E_ROOF,ZAVG_AC_GRND,ZAVG_AC_GRND_WAT,    &
                ZFORC_U,ZDFORC_UDU,ZFORC_E,ZDFORC_EDE,ZFORC_T,ZDFORC_TDT,ZFORC_Q,ZDFORC_QDQ)
!
!-------------------------------------------------------------------------------------
!* Evolution of canopy air due to these impacts
!-------------------------------------------------------------------------------------
!
 CALL CANOPY_EVOL(KI,TM%TCP%NLVL,PTSTEP,2,                                    &
                 ZL,ZWIND,PTA,PQA,PPA,PRHOA,                                  &
                 ZSFLUX_U,ZSFLUX_T,ZSFLUX_Q,                                  &
                 ZFORC_U,ZDFORC_UDU,ZFORC_E,ZDFORC_EDE,                       &
                 ZFORC_T,ZDFORC_TDT,ZFORC_Q,ZDFORC_QDQ,                       &
                 TM%TCP%XZ,TM%TCP%XZF,TM%TCP%XDZ,TM%TCP%XDZF,TM%TCP%XU,       &
                 TM%TCP%XTKE,TM%TCP%XT,TM%TCP%XQ,TM%TCP%XLMO,TM%TCP%XLM,      &
                 TM%TCP%XLEPS,TM%TCP%XP,             &
                 ZAVG_USTAR,                                                  &
                 ZALFAU,ZBETAU,ZALFAT,ZBETAT,ZALFAQ,ZBETAQ                    )
!
!
!-------------------------------------------------------------------------------------
! Momentum fluxes in the case canopy is active
!-------------------------------------------------------------------------------------
!
PSFU=0.
PSFV=0.
ZAVG_Z0_TOWN(:) = MIN(ZAVG_Z0_TOWN(:),PUREF(:)*0.5)
ZAVG_CDN=(XKARMAN/LOG(PUREF(:)/ZAVG_Z0_TOWN(:)))**2
ZAVG_CD = ZAVG_CDN
ZAVG_RI = 0.
DO JJ=1,SIZE(PU)
  IF (ZWIND(JJ)>0.) THEN
    ZCOEF(JJ) = - PRHOA(JJ) * ZAVG_USTAR(JJ)**2 / ZWIND(JJ)
    PSFU(JJ) = ZCOEF(JJ) * PU(JJ)
    PSFV(JJ) = ZCOEF(JJ) * PV(JJ)
    ZAVG_CD(JJ) = ZAVG_USTAR(JJ)**2 / ZWIND(JJ)**2
    ZAVG_RI(JJ) = -XG/PTA(JJ)*ZSFLUX_T(JJ)/ZAVG_USTAR(JJ)**4
  ENDIF
ENDDO
!
!
!-------------------------------------------------------------------------------------
!* Update of canyon parameters at the end of the time step for the consistance of diagnostics
!-------------------------------------------------------------------------------------
!
DO JLAYER=1,TM%TCP%NLVL-1
   DO JI=1,KI
      !* finds middle canyon layer
      IF (TM%TCP%XZ(JI,JLAYER)<ZAVG_BLD_HEIGHT(JI)/2. .AND. &
          TM%TCP%XZ(JI,JLAYER+1)>=ZAVG_BLD_HEIGHT(JI)/2.) THEN
        ZCOEF(JI) = (ZAVG_BLD_HEIGHT(JI)/2.-TM%TCP%XZ(JI,JLAYER))/(TM%TCP%XZ(JI,JLAYER+1)-TM%TCP%XZ(JI,JLAYER))
        ZU_CANYON(JI) = TM%TCP%XU(JI,JLAYER) + ZCOEF(JI) * (TM%TCP%XU(JI,JLAYER+1)-TM%TCP%XU(JI,JLAYER))
        ZT_CANYON(JI) = TM%TCP%XT(JI,JLAYER) + ZCOEF(JI) * (TM%TCP%XT(JI,JLAYER+1)-TM%TCP%XT(JI,JLAYER))
        ZQ_CANYON(JI) =(TM%TCP%XQ(JI,JLAYER) + ZCOEF(JI) * &
                        (TM%TCP%XQ(JI,JLAYER+1)-TM%TCP%XQ(JI,JLAYER)))/PRHOA(JI)
      END IF
   END DO
END DO
ZU_CANYON= MAX(ZU_CANYON,0.2)
!
DO JTEB_PATCH=1,TM%TOP%NTEB_PATCH
   CALL GOTO_WRAPPER_TEB_PATCH(TM%B, TM%DGCT, TM%DGMT, TM%T, &
       GDM%TGD, GDM%TGDPE, GRM%TGR, GRM%TGRPE, HM%TH, JTEB_PATCH)
   !
   TM%T%CUR%XT_CANYON(:) = ZT_CANYON(:)
   TM%T%CUR%XQ_CANYON(:) = ZQ_CANYON(:)
   !
ENDDO
!
!-------------------------------------------------------------------------------------
! End of specific case with canopy option
!-------------------------------------------------------------------------------------
!
END IF
!
!-------------------------------------------------------------------------------------
! Outputs:
!-------------------------------------------------------------------------------------
!
!-------------------------------------------------------------------------------------
!Radiative properties should be at time t+1 (see by the atmosphere) in order to close
!the energy budget between surfex and the atmosphere. It is not the case here
!for ALB and EMIS
!-------------------------------------------------------------------------------------
!
 CALL AVERAGE_RAD(TM%TOP%XTEB_PATCH,                                      &
                 ZDIR_ALB_PATCH, ZSCA_ALB_PATCH, ZEMIS_PATCH, ZTRAD_PATCH,&
                 PDIR_ALB,       PSCA_ALB,       PEMIS,       PTRAD       )
!
!-------------------------------------------------------------------------------
!Physical properties see by the atmosphere in order to close the energy budget 
!between surfex and the atmosphere. All variables should be at t+1 but very 
!difficult to do. Maybe it will be done later. However, Ts can be at time t+1
!-------------------------------------------------------------------------------
!
PTSURF (:) = PTRAD         (:) ! Should be the surface effective temperature; not radative
PZ0    (:) = ZAVG_Z0_TOWN  (:) ! Should account for ISBA (greenroof and garden) Z0
PZ0H   (:) = PZ0 (:) / 200.    ! Should account for ISBA (greenroof and garden) Z0
PQSURF (:) = TM%T%CUR%XQ_CANYON     (:) ! Should account for ISBA (greenroof and garden) Qs
!
!-------------------------------------------------------------------------------------
! Scalar fluxes:
!-------------------------------------------------------------------------------------
!
ZAVG_USTAR    (:) = SQRT(SQRT(PSFU**2+PSFV**2))
!
!
IF (TM%CHT%SVT%NBEQ>0) THEN
  IF (TM%CHT%CCH_DRY_DEP == "WES89") THEN
    CALL CH_DEP_TOWN(ZAVG_RESA_TOWN,  ZAVG_USTAR, PTA, PTRAD, ZAVG_WALL_O_HOR,&
                     PSV(:,TM%CHT%SVT%NSV_CHSBEG:TM%CHT%SVT%NSV_CHSEND),        &
                     TM%CHT%SVT%CSV(TM%CHT%SVT%NSV_CHSBEG:TM%CHT%SVT%NSV_CHSEND),  &
                     TM%CHT%XDEP(:,1:TM%CHT%SVT%NBEQ)  )
   
    DO JI=TM%CHT%SVT%NSV_CHSBEG,TM%CHT%SVT%NSV_CHSEND
!cdir nodep
      DO JJ=1,SIZE(PSFTS,1)
        PSFTS(JJ,JI) = - PSV(JJ,JI) * TM%CHT%XDEP(JJ,JI-TM%CHT%SVT%NSV_CHSBEG+1)
      ENDDO
    ENDDO

    IF (TM%CHT%SVT%NAEREQ > 0 ) THEN
      CALL CH_AER_DEP(PSV(:,TM%CHT%SVT%NSV_AERBEG:TM%CHT%SVT%NSV_AEREND),&
                         PSFTS(:,TM%CHT%SVT%NSV_AERBEG:TM%CHT%SVT%NSV_AEREND),&
                         ZAVG_USTAR,ZAVG_RESA_TOWN,PTA,PRHOA)   
    END IF

  ELSE
    DO JI=TM%CHT%SVT%NSV_CHSBEG,TM%CHT%SVT%NSV_CHSEND
      PSFTS(:,JI) =0.
    ENDDO
    IF(TM%CHT%SVT%NSV_AERBEG.LT.TM%CHT%SVT%NSV_AEREND) THEN
      DO JI=TM%CHT%SVT%NSV_AERBEG,TM%CHT%SVT%NSV_AEREND
        PSFTS(:,JI) =0.
      ENDDO
    ENDIF
  ENDIF
ENDIF

IF (TM%CHT%SVT%NDSTEQ>0) THEN
  ! Blindage à enlever lorsque que TEB aura été corrigé
  ZUSTAR(:)     = MIN(ZUSTAR(:), 10.)
  ZRESA_TOWN(:) = MAX(ZRESA_TOWN(:), 10.)
  !
  CALL DSLT_DEP(PSV(:,TM%CHT%SVT%NSV_DSTBEG:TM%CHT%SVT%NSV_DSTEND), &
                PSFTS(:,TM%CHT%SVT%NSV_DSTBEG:TM%CHT%SVT%NSV_DSTEND),   &
                ZUSTAR, ZRESA_TOWN, PTA, PRHOA, DST%XEMISSIG_DST, DST%XEMISRADIUS_DST,  &
                JPMODE_DST, XDENSITY_DST, XMOLARWEIGHT_DST, ZCONVERTFACM0_DST,  &
                ZCONVERTFACM6_DST, ZCONVERTFACM3_DST, LVARSIG_DST, LRGFIX_DST,  &
                CVERMOD  )  

  CALL MASSFLUX2MOMENTFLUX(         &
    PSFTS(:,TM%CHT%SVT%NSV_DSTBEG:TM%CHT%SVT%NSV_DSTEND), & !I/O ![kg/m2/sec] In: flux of only mass, out: flux of moments
    PRHOA,                          & !I [kg/m3] air density
    DST%XEMISRADIUS_DST,                &!I [um] emitted radius for the modes (max 3)
    DST%XEMISSIG_DST,                   &!I [-] emitted sigma for the different modes (max 3)
    NDSTMDE,                        &
    ZCONVERTFACM0_DST,              &
    ZCONVERTFACM6_DST,              &
    ZCONVERTFACM3_DST,              &
    LVARSIG_DST, LRGFIX_DST         )  
ENDIF
IF (TM%CHT%SVT%NSLTEQ>0) THEN
  CALL DSLT_DEP(PSV(:,TM%CHT%SVT%NSV_SLTBEG:TM%CHT%SVT%NSV_SLTEND), &
                PSFTS(:,TM%CHT%SVT%NSV_SLTBEG:TM%CHT%SVT%NSV_SLTEND),   &
                ZUSTAR, ZRESA_TOWN, PTA, PRHOA, SLT%XEMISSIG_SLT, SLT%XEMISRADIUS_SLT,  &
                JPMODE_SLT, XDENSITY_SLT, XMOLARWEIGHT_SLT, ZCONVERTFACM0_SLT,  &
                ZCONVERTFACM6_SLT, ZCONVERTFACM3_SLT, LVARSIG_SLT, LRGFIX_SLT,  &
                CVERMOD  )  

  CALL MASSFLUX2MOMENTFLUX(         &
    PSFTS(:,TM%CHT%SVT%NSV_SLTBEG:TM%CHT%SVT%NSV_SLTEND), & !I/O ![kg/m2/sec] In: flux of only mass, out: flux of moments
    PRHOA,                          & !I [kg/m3] air density
    SLT%XEMISRADIUS_SLT,                &!I [um] emitted radius for the modes (max 3)
    SLT%XEMISSIG_SLT,                   &!I [-] emitted sigma for the different modes (max 3)
    NSLTMDE,                        &
    ZCONVERTFACM0_SLT,              &
    ZCONVERTFACM6_SLT,              &
    ZCONVERTFACM3_SLT,              &
    LVARSIG_SLT, LRGFIX_SLT         ) 
ENDIF
!
! - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
! Inline diagnostics
! - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
!
 CALL DIAG_INLINE_TEB_n(TM%DGT, TM%TCP, TM%T, &
                        TM%TOP%LCANOPY, PTA, PTRAD, ZQA, PPA, PPS, PRHOA,       &
                       PU, PV, ZWIND, PZREF, PUREF,                            &
                       ZAVG_CD, ZAVG_CDN, ZAVG_RI, ZAVG_CH, ZAVG_Z0_TOWN,      &
                       PTRAD, PEMIS, PDIR_ALB, PSCA_ALB,                       &
                       PLW, ZDIR_SWB, ZSCA_SWB,                                  &
                       PSFTH, PSFTQ, PSFU, PSFV, PSFCO2,                       &
                       ZAVG_RN, ZAVG_H, ZAVG_LE, ZAVG_GFLUX                    )
!   
!-------------------------------------------------------------------------------------
! Thermal confort index
!-------------------------------------------------------------------------------------
!
IF (TM%DGUT%LUTCI .AND. TM%DGT%N2M >0) THEN
  DO JJ=1,KI
    IF (TM%DGT%XZON10M(JJ)/=XUNDEF) THEN
      ZU_UTCI(JJ) = SQRT(TM%DGT%XZON10M(JJ)**2+TM%DGT%XMER10M(JJ)**2)
    ELSE
      ZU_UTCI(JJ) = ZWIND(JJ)
    ENDIF
  ENDDO
 !
 ! Robert:
 ! CAUTION: In the case the canopy option is activated,
 ! the values of T_CANYON and Q_CANYON could be replaced
 ! with T_LOWCAN and Q_LOWCAN. This should be appropriate.
 !
 DO JCOMP=1,SIZE(TM%B%CUR%XTI_BLD,2)
    !
    CALL UTCI_TEB(TM%T%CUR%XT_CANYON, TM%T%CUR%XQ_CANYON, ZAVG_TI_BLD(:,JCOMP), ZAVG_QI_BLD(:,JCOMP), ZU_UTCI, &
       PPS, ZAVG_REF_SW_GRND,ZAVG_REF_SW_FAC, ZAVG_SCA_SW, ZAVG_DIR_SW, PZENITH, &
       ZAVG_EMIT_LW_FAC, ZAVG_EMIT_LW_GRND, PLW, ZAVG_T_RAD_IND(:,JCOMP), TM%T%CUR%XBLD, &
       TM%T%CUR%XBLD_HEIGHT, TM%T%CUR%XWALL_O_HOR, TM%DGUT%XUTCI_IN(:,JCOMP), TM%DGUT%XUTCI_OUTSUN,     &
       TM%DGUT%XUTCI_OUTSHADE, TM%DGUT%XTRAD_SUN, TM%DGUT%XTRAD_SHADE                           )
    CALL UTCIC_STRESS(PTSTEP,TM%DGUT%XUTCI_IN(:,JCOMP)      ,TM%DGUT%XUTCIC_IN(:,:,JCOMP)       )
    !
 ENDDO
 !
 CALL UTCIC_STRESS(PTSTEP,TM%DGUT%XUTCI_OUTSUN  ,TM%DGUT%XUTCIC_OUTSUN  )
 CALL UTCIC_STRESS(PTSTEP,TM%DGUT%XUTCI_OUTSHADE,TM%DGUT%XUTCIC_OUTSHADE)
 !
ELSE IF (TM%DGUT%LUTCI) THEN
  TM%DGUT%XUTCI_IN(:,:) = XUNDEF
  TM%DGUT%XUTCI_OUTSUN(:) = XUNDEF
  TM%DGUT%XUTCI_OUTSHADE(:) = XUNDEF
  TM%DGUT%XTRAD_SUN(:) = XUNDEF
  TM%DGUT%XTRAD_SHADE(:) = XUNDEF
  TM%DGUT%XUTCIC_IN(:,:,:) = XUNDEF
  TM%DGUT%XUTCIC_OUTSUN(:,:) = XUNDEF
  TM%DGUT%XUTCIC_OUTSHADE(:,:) = XUNDEF
ENDIF
!
IF (TM%TOP%CBEM.EQ."BEM") THEN
   !
   ! Update auxiliairy variable for pressure at previous time step.
   !
   TM%B%CUR%XPSOLD(:)=PPS(:)
   !
   ! Determine the switch for shading status
   ! during vacancy at 7:00 solar time. 
   !
   DO JJ=1,SIZE(TM%B%CUR%XSHADVACSW,1)
      DO JCOMP=1,SIZE(TM%B%CUR%XSHADVACSW,2)
         IF ( (PTSUN(JJ).GE.7.0*3600.0).AND.(PTSUN(JJ).LT.(7.0*3600.0+PTSTEP) ) ) THEN
            IF ((TM%B%CUR%XTI_BLD(JJ,JCOMP).GT.TM%B%CUR%XTDESV(JJ)).AND. &
               (TM%B%CUR%XTI_BLD(JJ,JCOMP).GT.TM%B%CUR%XTHEAT_OCCD(JJ,JCOMP))) THEN
                TM%B%CUR%XSHADVACSW(JJ,JCOMP)=1.0
            ELSE
                TM%B%CUR%XSHADVACSW(JJ,JCOMP)=0.0
            ENDIF
         ENDIF
      ENDDO
   ENDDO
   !
   ! Determine the switch for ventilation status
   ! during night at 22:00 solar time.
   ! CAUTION: this status change might not be reasonable for all building uses
   !
   DO JJ=1,SIZE(TM%B%CUR%XVENTNIGSW,1)
      DO JCOMP=1,SIZE(TM%B%CUR%XSHADVACSW,2)
         IF ( (PTSUN(JJ).GE.22.0*3600.0).AND.(PTSUN(JJ).LT.(22.0*3600.0+PTSTEP) ) ) THEN
            IF ((TM%B%CUR%XTI_BLD(JJ,JCOMP).GT.TM%B%CUR%XTDESV(JJ)).AND. &
                (TM%B%CUR%XTI_BLD(JJ,JCOMP).GT.TM%B%CUR%XTHEAT_OCCD(JJ,JCOMP))) THEN
                 TM%B%CUR%XVENTNIGSW(JJ,JCOMP) = 1.0
            ELSE
               TM%B%CUR%XVENTNIGSW(JJ,JCOMP) = 0.0
            ENDIF
         ENDIF
      ENDDO
   ENDDO
   !
ENDIF
!
IF (LHOOK) CALL DR_HOOK('COUPLING_TEB_N',1,ZHOOK_HANDLE)
!
!-------------------------------------------------------------------------------------
CONTAINS
SUBROUTINE ADD_PATCH_CONTRIB(JP,PAVG,PFIELD)
INTEGER, INTENT(IN) :: JP
REAL, DIMENSION(:), INTENT(INOUT) :: PAVG
REAL, DIMENSION(:), INTENT(IN)    :: PFIELD
!
IF (JTEB_PATCH==1) PAVG = 0.
PAVG = PAVG + TM%TOP%XTEB_PATCH(:,JP) * PFIELD(:)
!
END SUBROUTINE ADD_PATCH_CONTRIB
!-------------------------------------------------------------------------------------
!
END SUBROUTINE COUPLING_TEB_n


