!     #########
      SUBROUTINE CONVERT_PATCH_TEB (BDD, DTB, DTCO, DTT, TOP, DTGD, DTH,&
                                    PCOVER,OCOVER,PDEF_ROAD_DIR,        &
                                   KTEB_SOIL, PTEB_SOILGRID,            &
                                   PCONDDRY_ROAD, PHCAPSOIL_ROAD,       &
                                   PZ0_TOWN,                            &
                                   PALB_ROOF,                           &
                                   PEMIS_ROOF,PHC_ROOF,PTC_ROOF,        &
                                   PD_ROOF,                             &
                                   PALB_ROAD,                           &
                                   PEMIS_ROAD,PHC_ROAD,PTC_ROAD,        &
                                   PD_ROAD, KTEB_ROAD,                  &
                                   PALB_WALL,                           &
                                   PEMIS_WALL,PHC_WALL,PTC_WALL,        &
                                   PD_WALL,                             &
                                   PBLD_HEIGHT,                         &
                                   PWALL_O_HOR,PBLD,                    &
                                   PGARDEN, PROAD_DIR,                  &
                                   PH_TRAFFIC,  PLE_TRAFFIC,            &
                                   PH_INDUSTRY, PLE_INDUSTRY,           &
                                   PHC_FLOOR, PTC_FLOOR, PD_FLOOR,      &
                                   PHC_MASS,  PTC_MASS,  PD_MASS,       &
                                   PISMASS, PTHEAT_OCCD, PTHEAT_OCCN,   &
                                   PTHEAT_VCDD, PTHEAT_VCDN, PTHEAT_VCLD, PFRACOMP, &
                                   PTCOOL_OCCD, PTCOOL_OCCN, PTCOOL_VCDD, &
                                   PTCOOL_VCDN, PTCOOL_VCLD,              &
                                   PF_WASTE_CAN, PQIN,                  &
                                   PQIN_FRAD, PSHGC, PU_WIN, PGR,       &
                                   PSHGC_SH, PFLOOR_HEIGHT, PN50, PEFF_HEAT,      &
                                   PF_WATER_COND, PQIN_FLAT, PISMECH, PMECHRATE, &
                                   PMODQIN_VCD, PMODQIN_VLD, PMODQIN_NIG,  &
                                   PFVSUM, PFVNIG, PFVSHO, PTDESV, PFVVAC, &
                                   PFOPEN, PFSSUM, PFSNIG, PFSVAC, PWIN_SW_MAX, &
                                   PDAYWBEG_SCHED, PHOURBEG_SCHED,      &
                                   PBEG_HOLIDAY, PEND_HOLIDAY, PMOD_HOLIDAY, &
                                   PPROBOCC, &
                                   PHR_TARGET, PCAP_SYS_HEAT,           &
                                   PCAP_SYS_RAT, PT_ADP, PM_SYS_RAT,    &
                                   PCOP_RAT, PT_SIZE_MAX, PT_SIZE_MIN,  &
                                   PSHADEARCHI, PNATVENT, PROUGH_ROOF,  &
                                   PROUGH_WALL, PGREENROOF,             &
                                   PEMIS_PANEL, PALB_PANEL, PEFF_PANEL, &
                                   PFRAC_PANEL,                         &
                                   PHTRUNK_HVEG, PWCROWN_HVEG,          &
                                   PLAI_HVEG, PALB_HVEG, PALB_LVEG,     &
                                   PLSEWER, PLSTORM, PDSEWER            )
!     ##############################################################
!
!!**** *CONVERT_PATCH_TEB* compilation of conver_cover_isba, pgd_isba_par and
!!      init_from_data_isba_parn
!!
!!    PURPOSE
!!    -------
!!
!!    METHOD
!!    ------
!!   
!
!!    EXTERNAL
!!    --------
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!    AUTHOR
!!    ------
!!
!!    S. Faroux        Meteo-France
!!
!!    MODIFICATION
!!    ------------
!!
!!    Original    16/11/10
!!    G. Pigeon           09/12: add ROUGH_ROOF and ROUGH_WALL coef for outdoor conv. coef
!!    V. Masson           08/13: adds solar panels
!!    E. Redon/A. Lemonsu 01/16: add street trees
!!    K.Chancibault/A.Lemonsu 01/16: add urban hydrology
!!
!----------------------------------------------------------------------------
!
!*    0.     DECLARATION
!            -----------
!
!
USE MODD_BLD_DESCRIPTION_n, ONLY : BLD_DESC_t
USE MODD_DATA_BEM_n, ONLY : DATA_BEM_t
USE MODD_DATA_COVER_n, ONLY : DATA_COVER_t
USE MODD_DATA_TEB_n, ONLY : DATA_TEB_t
USE MODD_DATA_TEB_GARDEN_n, ONLY : DATA_TEB_GARDEN_t
USE MODD_DATA_TEB_HYDRO_n, ONLY : DATA_TEB_HYDRO_t
USE MODD_TEB_OPTION_n, ONLY : TEB_OPTIONS_t
!
USE MODD_SURF_PAR,       ONLY : XUNDEF
!
USE MODD_DATA_COVER_PAR, ONLY : NDATA_ROAD_LAYER, NDATA_WALL_LAYER,               &
                                NDATA_ROOF_LAYER, NDATA_FLOOR_LAYER, NDATA_MASS_LAYER
USE MODD_DATA_COVER,     ONLY : XDATA_Z0_TOWN, XDATA_ALB_ROOF,                    &
                                XDATA_EMIS_ROOF, XDATA_HC_ROOF, XDATA_TC_ROOF,    &
                                XDATA_D_ROOF, XDATA_ALB_ROAD, XDATA_EMIS_ROAD,    &
                                XDATA_HC_ROAD, XDATA_TC_ROAD, XDATA_D_ROAD,       &
                                XDATA_ALB_WALL, XDATA_EMIS_WALL, XDATA_HC_WALL,   &
                                XDATA_TC_WALL, XDATA_D_WALL, XDATA_BLD_HEIGHT,    &
                                XDATA_H_TRAFFIC, XDATA_LE_TRAFFIC,                &
                                XDATA_H_INDUSTRY, XDATA_LE_INDUSTRY,              &
                                XDATA_HC_FLOOR, XDATA_TC_FLOOR, XDATA_D_FLOOR,    &
                                XDATA_HC_MASS, XDATA_TC_MASS, XDATA_D_MASS,       &
                                XDATA_THEAT_OCCD, XDATA_THEAT_OCCN, XDATA_THEAT_VCDD, & 
                                XDATA_THEAT_VCDN, XDATA_THEAT_VCLD, XDATA_TCOOL_OCCD, &
                                XDATA_TCOOL_OCCN, XDATA_TCOOL_VCDD, XDATA_TCOOL_VCDN, &
                                XDATA_TCOOL_VCLD, XDATA_FVSUM, XDATA_FVVAC,        &
                                XDATA_FSSUM, XDATA_FSVAC, XDATA_FSNIG, XDATA_FVNIG,& 
                                XDATA_F_WASTE_CAN, XDATA_QIN,                      &
                                XDATA_QIN_FRAD, XDATA_SHGC, XDATA_U_WIN, XDATA_GR,&
                                XDATA_SHGC_SH, XDATA_FLOOR_HEIGHT,XDATA_ISMASS, XDATA_N50, XDATA_EFF_HEAT,    &
                                XDATA_F_WATER_COND, XDATA_QIN_FLAT,               &   
                                XDATA_HR_TARGET, XDATA_CAP_SYS_HEAT,&
                                XDATA_CAP_SYS_RAT, XDATA_T_ADP, XDATA_M_SYS_RAT,  &
                                XDATA_COP_RAT, XDATA_T_SIZE_MAX, XDATA_T_SIZE_MIN,&
                                XDATA_ISMECH, XDATA_MECHRATE, XDATA_SHADEARCHI,   &
                                XDATA_NATVENT, XDATA_PROBOCC, XDATA_ROUGH_ROOF,     &
                                XDATA_ROUGH_WALL,XDATA_FRAC_GR,&
                                XDATA_EMIS_PANEL,XDATA_ALB_PANEL, XDATA_EFF_PANEL,&
                                XDATA_FRAC_PANEL, XDATA_MODQIN_VCD,               &
                                XDATA_MODQIN_VLD, XDATA_MODQIN_NIG, XDATA_TDESV,  &
                                XDATA_FVSHO, XDATA_WIN_SW_MAX, XDATA_FOPEN 
!
USE MODI_THERMAL_LAYERS_CONF
USE MODI_THERMAL_LAYERS_CONF_ROAD
USE MODI_INI_DATA_PARAM_TEB
USE MODI_AV_PGD
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
USE MODI_ABOR1_SFX
!
IMPLICIT NONE
!
!*    0.1    Declaration of arguments
!            ------------------------
!
!
TYPE(BLD_DESC_t), INTENT(INOUT) :: BDD
TYPE(DATA_BEM_t), INTENT(INOUT) :: DTB
TYPE(DATA_COVER_t), INTENT(INOUT) :: DTCO
TYPE(DATA_TEB_t), INTENT(INOUT) :: DTT
TYPE(DATA_TEB_GARDEN_t), INTENT(INOUT) :: DTGD
TYPE(DATA_TEB_HYDRO_t), INTENT(INOUT) :: DTH
TYPE(TEB_OPTIONS_t), INTENT(INOUT) :: TOP
!
REAL, DIMENSION(:,:),   INTENT(IN)    :: PCOVER
LOGICAL, DIMENSION(:),  INTENT(IN)    :: OCOVER
REAL,                   INTENT(IN)    :: PDEF_ROAD_DIR ! default road direction
INTEGER             ,   INTENT(IN)    :: KTEB_SOIL
REAL, DIMENSION(:)  ,   INTENT(IN)    :: PTEB_SOILGRID
!
REAL, DIMENSION(:,:),   INTENT(IN)    :: PCONDDRY_ROAD
REAL, DIMENSION(:,:),   INTENT(IN)    :: PHCAPSOIL_ROAD
!
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PZ0_TOWN
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PALB_ROOF
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PEMIS_ROOF
REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL   :: PHC_ROOF
REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL   :: PTC_ROOF
REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL   :: PD_ROOF
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PALB_ROAD
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PEMIS_ROAD
REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL   :: PHC_ROAD
REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL   :: PTC_ROAD
REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL   :: PD_ROAD
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PALB_WALL
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PEMIS_WALL
REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL   :: PHC_WALL
REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL   :: PTC_WALL
REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL   :: PD_WALL
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PBLD_HEIGHT
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PWALL_O_HOR
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PBLD
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PGARDEN
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PROAD_DIR
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PH_TRAFFIC
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PLE_TRAFFIC
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PH_INDUSTRY
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PLE_INDUSTRY
REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL   :: PHC_FLOOR
REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL   :: PTC_FLOOR
REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL   :: PD_FLOOR
REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL   :: PHC_MASS
REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL   :: PTC_MASS
REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL   :: PD_MASS
REAL, DIMENSION(:)  , INTENT(OUT), OPTIONAL   :: PISMASS
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PSHGC
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PU_WIN
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PGR
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PN50
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PEFF_HEAT
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PSHGC_SH
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PFLOOR_HEIGHT
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PF_WATER_COND
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PCAP_SYS_HEAT
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PCAP_SYS_RAT
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PT_ADP
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PM_SYS_RAT
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PT_SIZE_MAX
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PT_SIZE_MIN
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PSHADEARCHI
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PISMECH
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PMECHRATE
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PROUGH_ROOF
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PROUGH_WALL
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PGREENROOF
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PEMIS_PANEL
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PALB_PANEL
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PEFF_PANEL
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PFRAC_PANEL
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PHTRUNK_HVEG       ! Fields for street trees
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PWCROWN_HVEG       ! "
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PLAI_HVEG          ! "
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PALB_HVEG          ! "
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PALB_LVEG          ! "
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PLSEWER            ! Fields for urban hydrology
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PLSTORM            ! "
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PDSEWER            ! "
!
! Human behaviour related variables
!
REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL :: PFRACOMP
REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL :: PTHEAT_OCCD
REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL :: PTHEAT_OCCN
REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL :: PTHEAT_VCDD
REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL :: PTHEAT_VCDN
REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL :: PTHEAT_VCLD
REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL :: PTCOOL_OCCD
REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL :: PTCOOL_OCCN
REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL :: PTCOOL_VCDD
REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL :: PTCOOL_VCDN
REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL :: PTCOOL_VCLD
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL :: PCOP_RAT
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL :: PHR_TARGET
REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL :: PQIN
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL :: PQIN_FRAD
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL :: PQIN_FLAT
REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL :: PMODQIN_VCD
REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL :: PMODQIN_VLD   
REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL :: PMODQIN_NIG   
REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL :: PFVSUM
REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL :: PFVNIG
REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL :: PFVSHO
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL :: PTDESV
REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL :: PFVVAC
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL :: PFOPEN
REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL :: PFSSUM
REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL :: PFSNIG
REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL :: PFSVAC
REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL :: PNATVENT
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL :: PWIN_SW_MAX
REAL, DIMENSION(:,:,:), INTENT(OUT), OPTIONAL :: PBEG_HOLIDAY
REAL, DIMENSION(:,:,:), INTENT(OUT), OPTIONAL :: PEND_HOLIDAY
REAL, DIMENSION(:,:)  , INTENT(OUT), OPTIONAL :: PMOD_HOLIDAY
REAL, DIMENSION(:,:,:), INTENT(OUT), OPTIONAL :: PDAYWBEG_SCHED
REAL, DIMENSION(:,:,:), INTENT(OUT), OPTIONAL :: PHOURBEG_SCHED
REAL, DIMENSION(:,:,:), INTENT(OUT), OPTIONAL :: PPROBOCC
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL :: PF_WASTE_CAN
!
INTEGER, DIMENSION(:),INTENT(OUT), OPTIONAL   :: KTEB_ROAD
!
!*    0.2    Declaration of local variables
!            ------------------------------
!
REAL, DIMENSION(:,:), ALLOCATABLE :: ZTC, ZHC, ZD
INTEGER, DIMENSION(SIZE(DTT%XPAR_FRACTER)) :: ZISOWALLPOS
INTEGER, DIMENSION(SIZE(DTT%XPAR_FRACTER)) :: ZISOROOFPOS
!
INTEGER               :: JLAYER    ! loop counter on layers
INTEGER               :: IL        ! number of points
INTEGER               :: JJ        ! loop counter
INTEGER               :: JCOMP     ! loop counter
!
 CHARACTER(LEN=3)      :: YAVG      ! Type of averaging for buildings
 CHARACTER(LEN=4)      :: YAREA     ! Area where parameter is averaged
!
!*    0.3    Declaration of namelists
!            ------------------------
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!-------------------------------------------------------------------------------
!
!*    1.      Initializations
!             ---------------
!
IF (LHOOK) CALL DR_HOOK('CONVERT_PATCH_TEB',0,ZHOOK_HANDLE)
!
IF (TOP%CBLD_ATYPE=='ARI') THEN
  YAVG=TOP%CBLD_ATYPE
  YAREA='BLD'
ELSE
  YAVG=TOP%CBLD_ATYPE
  YAREA='BLV'
END IF
!
IL = SIZE(PCOVER,1)
!-------------------------------------------------------------------------------
!
!       ROAD DIRECTION 
!       --------------
IF (PRESENT(PROAD_DIR)) THEN
  IF (DTT%LDATA_ROAD_DIR) THEN
    PROAD_DIR=DTT%XPAR_ROAD_DIR
  ELSE
    PROAD_DIR=PDEF_ROAD_DIR
  ENDIF
ENDIF
!
!
!       GARDEN fraction
!       ---------------
IF (PRESENT(PGARDEN)) THEN
  IF (DTT%LDATA_GARDEN) THEN
    PGARDEN=DTT%XPAR_GARDEN
  ELSE
    CALL AV_PGD(DTCO, &
                 PGARDEN, PCOVER, DTCO%XDATA_GARDEN(:),'TWN','ARI',OCOVER)
  ENDIF
ENDIF
!
!
!       BLD fraction
!       -------------
IF (PRESENT(PBLD)) THEN
  IF (DTT%LDATA_BLD) THEN
    PBLD=DTT%XPAR_BLD  
  ELSE
    CALL AV_PGD(DTCO, &
                 PBLD, PCOVER, DTCO%XDATA_BLD(:),'TWN','ARI',OCOVER)
  ENDIF
ENDIF
!
!
!      Z0_TOWN
!      ----------
IF (PRESENT(PZ0_TOWN)) THEN 
  IF (DTT%LDATA_Z0_TOWN) THEN
    PZ0_TOWN=DTT%XPAR_Z0_TOWN  
  ELSE
    CALL AV_PGD(DTCO, &
                 PZ0_TOWN ,PCOVER ,XDATA_Z0_TOWN (:),'TWN','CDN',OCOVER)  
!    CALL AV_PGD(DTCO, &
!                 PZ0_TOWN ,PCOVER ,XDATA_Z0_TOWN (:),'BLD','CDN',OCOVER)
  ENDIF  
ENDIF
!
!      BLD Height
!      ----------
IF (PRESENT(PBLD_HEIGHT)) THEN 
  IF (DTT%LDATA_BLD_HEIGHT) THEN
    PBLD_HEIGHT=DTT%XPAR_BLD_HEIGHT
  ELSE
    CALL AV_PGD(DTCO, &
                 PBLD_HEIGHT ,PCOVER ,XDATA_BLD_HEIGHT (:),'BLD','ARI',OCOVER)  
  ENDIF  
ENDIF
!
!      WALL O HOR
!      ----------
IF (PRESENT(PWALL_O_HOR)) THEN
  IF (DTT%LDATA_WALL_O_HOR) THEN
    PWALL_O_HOR=DTT%XPAR_WALL_O_HOR 
  ELSE
    CALL AV_PGD(DTCO, &
                 PWALL_O_HOR ,PCOVER ,DTCO%XDATA_WALL_O_HOR (:),'BLD','ARI',OCOVER)  
  ENDIF  
ENDIF
!
!      ALB_ROOF
!      ----------
IF (PRESENT(PALB_ROOF)) THEN 
  IF (DTT%LDATA_ALB_ROOF) THEN
    PALB_ROOF=DTT%XPAR_ALB_ROOF
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT, &
                            DTT%NPAR_BLDCODE,PALB_ROOF=PALB_ROOF)
  ELSE
    CALL AV_PGD(DTCO, &
                 PALB_ROOF ,PCOVER ,XDATA_ALB_ROOF (:),YAREA,YAVG,OCOVER)  
  ENDIF  
ENDIF
!
!      EMIS_ROOF
!      ----------
IF (PRESENT(PEMIS_ROOF)) THEN 
  IF (DTT%LDATA_EMIS_ROOF) THEN
    PEMIS_ROOF=DTT%XPAR_EMIS_ROOF
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT, &
                            DTT%NPAR_BLDCODE,PEMIS_ROOF=PEMIS_ROOF)
  ELSE
    CALL AV_PGD(DTCO, &
                 PEMIS_ROOF ,PCOVER ,XDATA_EMIS_ROOF (:),YAREA,YAVG,OCOVER)  
  ENDIF  
ENDIF
!
!      HC_ROOF, TC_ROOF, D_ROOF
!      ------------------------
!
IF (PRESENT(PHC_ROOF) .AND. PRESENT(PTC_ROOF) .AND. PRESENT(PD_ROOF)) THEN
  IF (DTT%LDATA_HC_ROOF) THEN
    CALL ALLOCATE_THERMAL_WORK(DTT%NPAR_ROOF_LAYER)
    ZHC=DTT%XPAR_HC_ROOF
    ZTC=DTT%XPAR_TC_ROOF
    ZD =DTT%XPAR_D_ROOF
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL ALLOCATE_THERMAL_WORK(BDD%NDESC_ROOF_LAYER)
    CALL INI_DATA_PARAM_TEB(BDD, DTT, &
                            DTT%NPAR_BLDCODE,PHC_ROOF=ZHC)
    CALL INI_DATA_PARAM_TEB(BDD, DTT, &
                            DTT%NPAR_BLDCODE,PTC_ROOF=ZTC)
    CALL INI_DATA_PARAM_TEB(BDD, DTT, &
                            DTT%NPAR_BLDCODE,PD_ROOF =ZD )
    CALL INI_DATA_PARAM_TEB(BDD, DTT, DTT%NPAR_BLDCODE,NISOROOFPOS=ZISOROOFPOS)
    !
    ! Robert:
    ! For buildings with usage collective housing and
    ! conctruction periods 1-2 the isolation of the roof is modified
    ! if there is a COMMERCIAL or TERTIIARY fraction. This takes into
    ! account the renovation that is usually made for this use type. 
    ! It is assumed that the maximum isolation thickness would be 10 cm.
    !
    ! DO JJ=1,SIZE(DTT%NPAR_BLDCODE)
    !    !
    !    IF ((DTT%NPAR_USETYPE(JJ).EQ.4).AND.(DTT%NPAR_COL_BLD_AGE(JJ).LE.2)) THEN
    !       !
    !       ZD(JJ,ZISOROOFPOS(JJ)) = (1.0-DTT%XPAR_FRACCOM(JJ)-DTT%XPAR_FRACTER(JJ))*ZD(JJ,ZISOROOFPOS(JJ)) + &
    !           (DTT%XPAR_FRACCOM(JJ)+DTT%XPAR_FRACTER(JJ))*0.0 !0.10
    !       !
    !    ENDIF
    !    !
    !  ENDDO
    !  !
  ELSE
    CALL ALLOCATE_THERMAL_WORK(NDATA_ROOF_LAYER)
    DO JLAYER=1,NDATA_ROOF_LAYER
      CALL AV_PGD(DTCO, &
                 ZHC(:,JLAYER), PCOVER, XDATA_HC_ROOF (:,JLAYER),YAREA,YAVG,OCOVER)
      CALL AV_PGD(DTCO, &
                 ZTC(:,JLAYER), PCOVER ,XDATA_TC_ROOF (:,JLAYER),YAREA,YAVG,OCOVER)
      CALL AV_PGD(DTCO, &
                 ZD (:,JLAYER), PCOVER ,XDATA_D_ROOF  (:,JLAYER),YAREA,YAVG,OCOVER)
    ENDDO
  ENDIF  
  CALL THERMAL_LAYERS_CONF('ROOF ',ZHC,ZTC,ZD,PHC_ROOF,PTC_ROOF,PD_ROOF)
  CALL DEALLOCATE_THERMAL_WORK
ENDIF
!
!      ALB_ROAD
!      ----------
IF (PRESENT(PALB_ROAD)) THEN 
  IF (DTT%LDATA_ALB_ROAD) THEN
    PALB_ROAD=DTT%XPAR_ALB_ROAD
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT, &
                            DTT%NPAR_BLDCODE,PALB_ROAD=PALB_ROAD)
  ELSE
    CALL AV_PGD(DTCO, &
                 PALB_ROAD ,PCOVER ,XDATA_ALB_ROAD (:),'STR','ARI',OCOVER)  
  ENDIF  
ENDIF
!
!      EMIS_ROAD
!      ----------
IF (PRESENT(PEMIS_ROAD)) THEN 
  IF (DTT%LDATA_EMIS_ROAD) THEN
    PEMIS_ROAD=DTT%XPAR_EMIS_ROAD
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT, &
                            DTT%NPAR_BLDCODE,PEMIS_ROAD=PEMIS_ROAD)
  ELSE
    CALL AV_PGD(DTCO, &
                 PEMIS_ROAD ,PCOVER ,XDATA_EMIS_ROAD (:),'STR','ARI',OCOVER)  
  ENDIF  
ENDIF
!
!      HC_ROAD, TC_ROAD, D_ROAD
!      ------------------------
!
IF (PRESENT(PHC_ROAD) .AND. PRESENT(PTC_ROAD) .AND. PRESENT(PD_ROAD) .AND. PRESENT(KTEB_ROAD)) THEN
  !
  IF (DTT%LDATA_HC_ROAD) THEN
    CALL ALLOCATE_THERMAL_WORK(DTT%NPAR_ROAD_LAYER)
    ZHC=DTT%XPAR_HC_ROAD
    ZTC=DTT%XPAR_TC_ROAD
    ZD =DTT%XPAR_D_ROAD
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL ALLOCATE_THERMAL_WORK(BDD%NDESC_ROAD_LAYER)
    CALL INI_DATA_PARAM_TEB(BDD, DTT, &
                            DTT%NPAR_BLDCODE,PHC_ROAD=ZHC)
    CALL INI_DATA_PARAM_TEB(BDD, DTT, &
                            DTT%NPAR_BLDCODE,PTC_ROAD=ZTC)
    CALL INI_DATA_PARAM_TEB(BDD, DTT, &
                            DTT%NPAR_BLDCODE,PD_ROAD =ZD )
  ELSE
    CALL ALLOCATE_THERMAL_WORK(NDATA_ROAD_LAYER)
    DO JLAYER=1,NDATA_ROAD_LAYER
      CALL AV_PGD(DTCO, &
                 ZHC(:,JLAYER), PCOVER, XDATA_HC_ROAD (:,JLAYER),YAREA,YAVG,OCOVER)
      CALL AV_PGD(DTCO, &
                 ZTC(:,JLAYER), PCOVER ,XDATA_TC_ROAD (:,JLAYER),YAREA,YAVG,OCOVER)
      CALL AV_PGD(DTCO, &
                 ZD (:,JLAYER), PCOVER ,XDATA_D_ROAD  (:,JLAYER),YAREA,YAVG,OCOVER)
      !CALL AV_PGD (PHC_ROAD(:,JLAYER), PCOVER, XDATA_HC_ROAD (:,JLAYER),YAREA,YAVG)
      !CALL AV_PGD (PTC_ROAD(:,JLAYER), PCOVER ,XDATA_TC_ROAD (:,JLAYER),YAREA,YAVG)
      !CALL AV_PGD (PD_ROAD(:,JLAYER), PCOVER ,XDATA_D_ROAD  (:,JLAYER),YAREA,YAVG)
    ENDDO
  ENDIF  
  !
   CALL THERMAL_LAYERS_CONF_ROAD('ROAD ', KTEB_SOIL, PTEB_SOILGRID,   &
                                ZHC, ZTC, ZD,                         &
                                PCONDDRY_ROAD, PHCAPSOIL_ROAD,        &
                                PHC_ROAD, PTC_ROAD, PD_ROAD, KTEB_ROAD)
  CALL DEALLOCATE_THERMAL_WORK
ENDIF
!
!      ALB_WALL
!      ----------
IF (PRESENT(PALB_WALL)) THEN
  IF (DTT%LDATA_ALB_WALL) THEN
    PALB_WALL=DTT%XPAR_ALB_WALL
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT, &
                            DTT%NPAR_BLDCODE,PALB_WALL=PALB_WALL)
  ELSE
    CALL AV_PGD(DTCO, &
                 PALB_WALL ,PCOVER ,XDATA_ALB_WALL (:),YAREA,YAVG,OCOVER)  
  ENDIF  
ENDIF
!
!      EMIS_WALL
!      ----------
IF (PRESENT(PEMIS_WALL)) THEN
  IF (DTT%LDATA_EMIS_WALL) THEN
    PEMIS_WALL=DTT%XPAR_EMIS_WALL
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT, &
                            DTT%NPAR_BLDCODE,PEMIS_WALL=PEMIS_WALL)
  ELSE
    CALL AV_PGD(DTCO, &
                 PEMIS_WALL ,PCOVER ,XDATA_EMIS_WALL (:),YAREA,YAVG,OCOVER)  
  ENDIF  
ENDIF
!
!      HC_WALL, TC_WALL, D_WALL
!      ------------------------
!
IF (PRESENT(PHC_WALL) .AND. PRESENT(PTC_WALL) .AND. PRESENT(PD_WALL)) THEN
  IF (DTT%LDATA_HC_WALL) THEN
    CALL ALLOCATE_THERMAL_WORK(DTT%NPAR_WALL_LAYER)
    ZHC=DTT%XPAR_HC_WALL
    ZTC=DTT%XPAR_TC_WALL
    ZD =DTT%XPAR_D_WALL
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL ALLOCATE_THERMAL_WORK(BDD%NDESC_WALL_LAYER)
    CALL INI_DATA_PARAM_TEB(BDD, DTT, &
                            DTT%NPAR_BLDCODE,PHC_WALL=ZHC)
    CALL INI_DATA_PARAM_TEB(BDD, DTT, &
                            DTT%NPAR_BLDCODE,PTC_WALL=ZTC)
    CALL INI_DATA_PARAM_TEB(BDD, DTT, &
                            DTT%NPAR_BLDCODE,PD_WALL =ZD )
    CALL INI_DATA_PARAM_TEB(BDD, DTT, DTT%NPAR_BLDCODE,NISOWALLPOS=ZISOWALLPOS)
    !
    ! Robert:
    ! For buildings with usage collective housing and
    ! conctruction periods 1-2 the isolation of the walls is modified
    ! if there is a COMMERCIAL or TERTIIARY fraction. This takes into
    ! account the renovation that is usually made for this use type. 
    ! It is assumed that the maximum isolation thickness would be 10 cm.
    !
    ! DO JJ=1,SIZE(DTT%NPAR_BLDCODE)
    !    !
    !    IF ((DTT%NPAR_USETYPE(JJ).EQ.4).AND.(DTT%NPAR_COL_BLD_AGE(JJ).LE.2)) THEN
    !       !
    !       ZD(JJ,ZISOWALLPOS(JJ)) = (1.0-DTT%XPAR_FRACCOM(JJ)-DTT%XPAR_FRACTER(JJ))*ZD(JJ,ZISOWALLPOS(JJ)) + &
    !           (DTT%XPAR_FRACCOM(JJ)+DTT%XPAR_FRACTER(JJ))*0.0 ! 0.1
    !       !
    !    ENDIF
    !    !
    ! ENDDO
    !
  ELSE
    CALL ALLOCATE_THERMAL_WORK(NDATA_WALL_LAYER)
    DO JLAYER=1,NDATA_WALL_LAYER
      CALL AV_PGD(DTCO, &
                 ZHC(:,JLAYER), PCOVER, XDATA_HC_WALL (:,JLAYER),YAREA,YAVG,OCOVER)
      CALL AV_PGD(DTCO, &
                 ZTC(:,JLAYER), PCOVER ,XDATA_TC_WALL (:,JLAYER),YAREA,YAVG,OCOVER)
      CALL AV_PGD(DTCO, &
                 ZD (:,JLAYER), PCOVER ,XDATA_D_WALL  (:,JLAYER),YAREA,YAVG,OCOVER)
    ENDDO
  ENDIF  
  CALL THERMAL_LAYERS_CONF('WALL ',ZHC,ZTC,ZD,PHC_WALL,PTC_WALL,PD_WALL)
  CALL DEALLOCATE_THERMAL_WORK
ENDIF
!
!      HC_FLOOR, TC_FLOOR, D_FLOOR
!      ------------------------
!
IF (PRESENT(PHC_FLOOR) .AND. PRESENT(PTC_FLOOR) .AND. PRESENT(PD_FLOOR)) THEN
  IF (DTB%LDATA_HC_FLOOR) THEN
    CALL ALLOCATE_THERMAL_WORK(DTB%NPAR_FLOOR_LAYER)
    ZHC=DTB%XPAR_HC_FLOOR
    ZTC=DTB%XPAR_TC_FLOOR
    ZD =DTB%XPAR_D_FLOOR
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL ALLOCATE_THERMAL_WORK(BDD%NDESC_FLOOR_LAYER)
    CALL INI_DATA_PARAM_TEB(BDD, DTT, &
                            DTT%NPAR_BLDCODE,PHC_FLOOR=ZHC)
    CALL INI_DATA_PARAM_TEB(BDD, DTT, &
                            DTT%NPAR_BLDCODE,PTC_FLOOR=ZTC)
    CALL INI_DATA_PARAM_TEB(BDD, DTT, &
                            DTT%NPAR_BLDCODE,PD_FLOOR =ZD )
  ELSE
    CALL ALLOCATE_THERMAL_WORK(NDATA_FLOOR_LAYER)
    DO JLAYER=1,NDATA_FLOOR_LAYER
      CALL AV_PGD(DTCO, &
                 ZHC(:,JLAYER), PCOVER, XDATA_HC_FLOOR (:,JLAYER),YAREA,YAVG,OCOVER)
      CALL AV_PGD(DTCO, &
                 ZTC(:,JLAYER), PCOVER ,XDATA_TC_FLOOR (:,JLAYER),YAREA,YAVG,OCOVER)
      CALL AV_PGD(DTCO, &
                 ZD (:,JLAYER), PCOVER ,XDATA_D_FLOOR  (:,JLAYER),YAREA,YAVG,OCOVER)
    ENDDO
  ENDIF  
  CALL THERMAL_LAYERS_CONF('FLOOR',ZHC,ZTC,ZD,PHC_FLOOR,PTC_FLOOR,PD_FLOOR)
  CALL DEALLOCATE_THERMAL_WORK
ENDIF
!
!     H_TRAFFIC
!     ---------
IF (PRESENT(PH_TRAFFIC)) THEN
  IF (DTT%LDATA_H_TRAFFIC) THEN
    PH_TRAFFIC=DTT%XPAR_H_TRAFFIC
  ELSE
    CALL AV_PGD(DTCO, &
                 PH_TRAFFIC ,PCOVER ,XDATA_H_TRAFFIC(:),'TWN','ARI',OCOVER)
  ENDIF  
ENDIF
!
!     LE_TRAFFIC
!     ----------
IF (PRESENT(PLE_TRAFFIC)) THEN
  IF (DTT%LDATA_LE_TRAFFIC) THEN
    PLE_TRAFFIC=DTT%XPAR_LE_TRAFFIC
  ELSE
    CALL AV_PGD(DTCO, &
                 PLE_TRAFFIC ,PCOVER ,XDATA_LE_TRAFFIC(:),'TWN','ARI',OCOVER)
  ENDIF  
ENDIF
!
!     H_INDUSTRY
!     ----------
IF (PRESENT(PH_INDUSTRY)) THEN
  IF (DTT%LDATA_H_INDUSTRY) THEN
    PH_INDUSTRY=DTT%XPAR_H_INDUSTRY
  ELSE
    CALL AV_PGD(DTCO, &
                 PH_INDUSTRY ,PCOVER ,XDATA_H_INDUSTRY(:),'TWN','ARI',OCOVER)
  ENDIF  
ENDIF
!
!     SOLAR PANELS
!     ------------
IF (PRESENT(PEMIS_PANEL)) THEN
  IF (DTT%LDATA_EMIS_PANEL) THEN
    PEMIS_PANEL=DTT%XPAR_EMIS_PANEL
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT, &
                            DTT%NPAR_BLDCODE,PEMIS_PANEL=PEMIS_PANEL)
  ELSE
    CALL AV_PGD(DTCO, &
                 PEMIS_PANEL ,PCOVER ,XDATA_EMIS_PANEL(:),'BLD','ARI',OCOVER)
  ENDIF  
ENDIF
!
IF (PRESENT(PALB_PANEL)) THEN
  IF (DTT%LDATA_ALB_PANEL) THEN
    PALB_PANEL=DTT%XPAR_ALB_PANEL
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT, &
                            DTT%NPAR_BLDCODE,PALB_PANEL=PALB_PANEL)
  ELSE
    CALL AV_PGD(DTCO, &
                 PALB_PANEL ,PCOVER ,XDATA_ALB_PANEL(:),'BLD','ARI',OCOVER)
  ENDIF  
ENDIF
!
IF (PRESENT(PEFF_PANEL)) THEN
  IF (DTT%LDATA_EFF_PANEL) THEN
    PEFF_PANEL=DTT%XPAR_EFF_PANEL
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT, &
                            DTT%NPAR_BLDCODE,PEFF_PANEL=PEFF_PANEL)
  ELSE
    CALL AV_PGD(DTCO, &
                 PEFF_PANEL ,PCOVER ,XDATA_EFF_PANEL(:),'BLD','ARI',OCOVER)
  ENDIF  
ENDIF
!
IF (PRESENT(PFRAC_PANEL)) THEN
  IF (DTT%LDATA_FRAC_PANEL) THEN
    PFRAC_PANEL=DTT%XPAR_FRAC_PANEL
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT, &
                            DTT%NPAR_BLDCODE,PFRAC_PANEL=PFRAC_PANEL)
  ELSE
    CALL AV_PGD(DTCO, &
                 PFRAC_PANEL ,PCOVER ,XDATA_FRAC_PANEL(:),'BLD','ARI',OCOVER)
  ENDIF  
ENDIF
!
!     LE_INDUSTRY
!     -----------
IF (PRESENT(PLE_INDUSTRY)) THEN
  IF (DTT%LDATA_LE_INDUSTRY) THEN
    PLE_INDUSTRY=DTT%XPAR_LE_INDUSTRY
  ELSE
    CALL AV_PGD(DTCO, &
                 PLE_INDUSTRY ,PCOVER ,XDATA_LE_INDUSTRY(:),'TWN','ARI',OCOVER)
  ENDIF  
ENDIF
!
!     SHGC
!     -----------
IF (PRESENT(PSHGC)) THEN
  IF (DTB%LDATA_SHGC) THEN
    PSHGC=DTB%XPAR_SHGC
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT, &
                            DTT%NPAR_BLDCODE,PSHGC=PSHGC)
  ELSE
    CALL AV_PGD(DTCO, &
                 PSHGC ,PCOVER ,XDATA_SHGC(:),'TWN','ARI',OCOVER)
  ENDIF  
ENDIF
!
!     U_WIN
!     -----------
IF (PRESENT(PU_WIN)) THEN
  IF (DTB%LDATA_U_WIN) THEN
    PU_WIN=DTB%XPAR_U_WIN
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
     CALL INI_DATA_PARAM_TEB(BDD, DTT, &
                          DTT%NPAR_BLDCODE,PU_WIN=PU_WIN)
    !
    ! Modification of PU_WIN according to the fraction of TERTIARE and COMMERCE
    ! It is assumed that the refurbished PU_WIN equals to 2.4 W/mK
    !
    ! DO JJ=1,SIZE(DTT%NPAR_BLDCODE)
    !    !
    !    IF ((DTT%NPAR_USETYPE(JJ).EQ.4).AND.(DTT%NPAR_COL_BLD_AGE(JJ).LE.2)) THEN
    !       !
    !       ! PU_WIN(JJ) = (1.0-DTT%XPAR_FRACCOM(JJ)-DTT%XPAR_FRACTER(JJ))*PU_WIN(JJ) + (DTT%XPAR_FRACCOM(JJ)+DTT%XPAR_FRACTER(JJ))*2.4
    !       PU_WIN(JJ) = PU_WIN(JJ)
    !       !
    !    ENDIF
    !    !
    ! ENDDO
    !
  ELSE
    CALL AV_PGD(DTCO, &
                 PU_WIN ,PCOVER ,XDATA_U_WIN(:),'TWN','ARI',OCOVER)
  ENDIF  
ENDIF
!
!     GR
!     -----------
IF (PRESENT(PGR)) THEN
  IF (DTB%LDATA_GR) THEN
    PGR=DTB%XPAR_GR
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT, &
                            DTT%NPAR_BLDCODE,PGR=PGR)
  ELSE
    CALL AV_PGD(DTCO, &
                 PGR ,PCOVER ,XDATA_GR(:),'TWN','ARI',OCOVER)
  ENDIF  
ENDIF
!
!     SHGC_SH
!     -----------
IF (PRESENT(PSHGC_SH)) THEN
  IF (DTB%LDATA_SHGC_SH) THEN
    PSHGC_SH=DTB%XPAR_SHGC_SH
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT, &
                            DTT%NPAR_BLDCODE,PSHGC_SH=PSHGC_SH)
  ELSE
    CALL AV_PGD(DTCO, &
                 PSHGC_SH ,PCOVER ,XDATA_SHGC_SH(:),'TWN','ARI',OCOVER)
  ENDIF  
ENDIF
!
!     FLOOR_HEIGHT
!     -----------
IF (PRESENT(PFLOOR_HEIGHT)) THEN
  IF (DTB%LDATA_FLOOR_HEIGHT) THEN
    PFLOOR_HEIGHT=DTB%XPAR_FLOOR_HEIGHT
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT, &
                            DTT%NPAR_BLDCODE,PFLOOR_HEIGHT=PFLOOR_HEIGHT)
  ELSE
    CALL AV_PGD(DTCO, &
                 PFLOOR_HEIGHT ,PCOVER ,XDATA_FLOOR_HEIGHT(:),'TWN','ARI',OCOVER)
  ENDIF  
ENDIF
!
!     ISMASS
!     -----------
IF (PRESENT(PISMASS)) THEN
  IF (DTB%LDATA_ISMASS) THEN
    PISMASS=DTB%XPAR_ISMASS
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT, &
                            DTT%NPAR_BLDCODE,PISMASS=PISMASS)
  ELSE
    CALL AV_PGD(DTCO, &
                 PISMASS ,PCOVER ,XDATA_ISMASS(:),'TWN','ARI',OCOVER)
  ENDIF  
ENDIF
!
!      HC_MASS, TC_MASS, D_MASS
!      ------------------------
!
IF (PRESENT(PHC_MASS) .AND. PRESENT(PTC_MASS) .AND. PRESENT(PD_MASS)) THEN
   IF (DTB%LDATA_HC_MASS) THEN
      !
      CALL ALLOCATE_THERMAL_WORK(DTB%NPAR_MASS_LAYER)
      ZHC=DTB%XPAR_HC_MASS
      ZTC=DTB%XPAR_TC_MASS
      ZD =DTB%XPAR_D_MASS 
      !
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      !
      CALL ALLOCATE_THERMAL_WORK(BDD%NDESC_MASS_LAYER)
      CALL INI_DATA_PARAM_TEB(BDD, DTT,DTT%NPAR_BLDCODE,PHC_MASS=ZHC)
      CALL INI_DATA_PARAM_TEB(BDD, DTT,DTT%NPAR_BLDCODE,PTC_MASS=ZTC)
      CALL INI_DATA_PARAM_TEB(BDD, DTT,DTT%NPAR_BLDCODE,PD_MASS =ZD )
      !
      CALL INI_DATA_PARAM_TEB(BDD, DTT,DTT%NPAR_BLDCODE,PISMASS=PISMASS)
      !
   ELSE
      !
      CALL ALLOCATE_THERMAL_WORK(NDATA_MASS_LAYER)
      !
      DO JLAYER=1,NDATA_MASS_LAYER
         CALL AV_PGD (DTCO, ZHC(:,JLAYER), PCOVER, XDATA_HC_MASS (:,JLAYER),YAREA,YAVG,OCOVER)
         CALL AV_PGD (DTCO, ZTC(:,JLAYER), PCOVER ,XDATA_TC_MASS (:,JLAYER),YAREA,YAVG,OCOVER)
         CALL AV_PGD (DTCO, ZD (:,JLAYER), PCOVER ,XDATA_D_MASS  (:,JLAYER),YAREA,YAVG,OCOVER)
      ENDDO
      !
  ENDIF
  !
  CALL THERMAL_LAYERS_CONF('MASS ',ZHC,ZTC,ZD,PHC_MASS,PTC_MASS,PD_MASS)
  CALL DEALLOCATE_THERMAL_WORK
  !
ENDIF
!
!     N50
!     -----------
IF (PRESENT(PN50)) THEN
  IF (DTB%LDATA_N50) THEN
    PN50=DTB%XPAR_N50
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT, &
                            DTT%NPAR_BLDCODE,PN50=PN50)
    !
    ! Modification of PN50 according to the fraction of TERTIARE and COMMERCE
    ! It is assumed that the refurbished PN50 equals to 3.0 vol/h
    !
    !DO JJ=1,SIZE(NPAR_BLDCODE)
    !   !
    !   IF ((NPAR_USETYPE(JJ).EQ.4).AND.(NPAR_COL_BLD_AGE(JJ).LE.2)) THEN
    !      !
    !      PN50(JJ) = (1.0-DTT%XPAR_FRACCOM(JJ)-DTT%XPAR_FRACTER(JJ))*PN50(JJ) + (DTT%XPAR_FRACCOM(JJ)+DTT%XPAR_FRACTER(JJ))*3.0
    !      !
    !   ENDIF
    !   !
    !ENDDO
    !
  ELSE
    CALL AV_PGD(DTCO, &
                 PN50 ,PCOVER ,XDATA_N50(:),'TWN','ARI',OCOVER)
  ENDIF  
ENDIF
!
!     EFF_HEAT
!     -----------
IF (PRESENT(PEFF_HEAT)) THEN
  IF (DTT%LDATA_EFF_HEAT) THEN
    PEFF_HEAT=DTT%XPAR_EFF_HEAT
  ELSE
    CALL AV_PGD(DTCO, &
                PEFF_HEAT,PCOVER ,XDATA_EFF_HEAT(:),'TWN','ARI',OCOVER)
  ENDIF  
ENDIF
!
!     F_WATER_COND
!     -----------
IF (PRESENT(PF_WATER_COND)) THEN
  IF (DTB%LDATA_F_WATER_COND) THEN
    PF_WATER_COND=DTB%XPAR_F_WATER_COND
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT, &
                            DTT%NPAR_BLDCODE,PF_WATER_COND=PF_WATER_COND)
  ELSE
    CALL AV_PGD(DTCO, &
                 PF_WATER_COND ,PCOVER ,XDATA_F_WATER_COND(:),'TWN','ARI',OCOVER)
  ENDIF  
ENDIF
!
!     HR_TARGET
!     -----------
IF (PRESENT(PHR_TARGET)) THEN
  IF (DTB%LDATA_HR_TARGET) THEN
    PHR_TARGET=DTB%XPAR_HR_TARGET
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT, &
                            DTT%NPAR_BLDCODE,PHR_TARGET=PHR_TARGET)
  ELSE
    CALL AV_PGD(DTCO, &
                 PHR_TARGET ,PCOVER ,XDATA_HR_TARGET(:),'TWN','ARI',OCOVER)
  ENDIF  
ENDIF
!
!     CAP_SYS_HEAT
!     -----------
IF (PRESENT(PCAP_SYS_HEAT)) THEN
  IF (DTB%LDATA_CAP_SYS_HEAT) THEN
    PCAP_SYS_HEAT=DTB%XPAR_CAP_SYS_HEAT
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT, &
                            DTT%NPAR_BLDCODE,PCAP_SYS_HEAT=PCAP_SYS_HEAT)
  ELSE
    CALL AV_PGD(DTCO, &
                 PCAP_SYS_HEAT ,PCOVER ,XDATA_CAP_SYS_HEAT(:),'TWN','ARI',OCOVER)
  ENDIF  
ENDIF
!
!     CAP_SYS_RAT
!     -----------
IF (PRESENT(PCAP_SYS_RAT)) THEN
  IF (DTB%LDATA_CAP_SYS_RAT) THEN
    PCAP_SYS_RAT=DTB%XPAR_CAP_SYS_RAT
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT, &
                            DTT%NPAR_BLDCODE,PCAP_SYS_RAT=PCAP_SYS_RAT)
  ELSE
    CALL AV_PGD(DTCO, &
                 PCAP_SYS_RAT ,PCOVER ,XDATA_CAP_SYS_RAT(:),'TWN','ARI',OCOVER)
  ENDIF  
ENDIF
!
!     T_ADP
!     -----------
IF (PRESENT(PT_ADP)) THEN
  IF (DTB%LDATA_T_ADP) THEN
    PT_ADP=DTB%XPAR_T_ADP
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT, &
                            DTT%NPAR_BLDCODE,PT_ADP=PT_ADP)
  ELSE
    CALL AV_PGD(DTCO, &
                 PT_ADP ,PCOVER ,XDATA_T_ADP(:),'TWN','ARI',OCOVER)
  ENDIF  
ENDIF
!
!     M_SYS_RAT
!     -----------
IF (PRESENT(PM_SYS_RAT)) THEN
  IF (DTB%LDATA_M_SYS_RAT) THEN
    PM_SYS_RAT=DTB%XPAR_M_SYS_RAT
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT, &
                            DTT%NPAR_BLDCODE,PM_SYS_RAT=PM_SYS_RAT)
  ELSE
    CALL AV_PGD(DTCO, &
                 PM_SYS_RAT ,PCOVER ,XDATA_M_SYS_RAT(:),'TWN','ARI',OCOVER)
  ENDIF  
ENDIF
!
!     COP_RAT
!     -----------
IF (PRESENT(PCOP_RAT)) THEN
  IF (DTB%LDATA_COP_RAT) THEN
    PCOP_RAT=DTB%XPAR_COP_RAT
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT, &
                            DTT%NPAR_BLDCODE,PCOP_RAT=PCOP_RAT)
  ELSE
    CALL AV_PGD(DTCO, &
                 PCOP_RAT ,PCOVER ,XDATA_COP_RAT(:),'TWN','ARI',OCOVER)
  ENDIF  
ENDIF
!
!     GREENROOF FRACTION
!     ------------------
IF (PRESENT(PGREENROOF)) THEN
  IF (DTT%LDATA_GREENROOF) THEN
    PGREENROOF=DTT%XPAR_GREENROOF
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT, &
                            DTT%NPAR_BLDCODE,PGREENROOF=PGREENROOF)
  ELSE
    CALL AV_PGD(DTCO, &
                 PGREENROOF,PCOVER ,XDATA_FRAC_GR(:),'BLD','ARI',OCOVER)
  ENDIF  
ENDIF
!
!     T_SIZE_MAX
!     -----------
IF (PRESENT(PT_SIZE_MAX)) THEN
  IF (DTB%LDATA_T_SIZE_MAX) THEN
    PT_SIZE_MAX=DTB%XPAR_T_SIZE_MAX
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT, &
                            DTT%NPAR_BLDCODE,PT_SIZE_MAX=PT_SIZE_MAX)
  ELSE
    CALL AV_PGD(DTCO, &
                 PT_SIZE_MAX ,PCOVER ,XDATA_T_SIZE_MAX(:),'TWN','ARI',OCOVER)
  ENDIF  
ENDIF
!
!     T_SIZE_MIN
!     -----------
IF (PRESENT(PT_SIZE_MIN)) THEN
  IF (DTB%LDATA_T_SIZE_MIN) THEN
    PT_SIZE_MIN=DTB%XPAR_T_SIZE_MIN
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT, &
                            DTT%NPAR_BLDCODE,PT_SIZE_MIN=PT_SIZE_MIN)
  ELSE
    CALL AV_PGD(DTCO, &
                 PT_SIZE_MIN ,PCOVER ,XDATA_T_SIZE_MIN(:),'TWN','ARI',OCOVER)
  ENDIF  
ENDIF
!
!     SHADEARCHI
!     -----
IF (PRESENT(PSHADEARCHI)) THEN
  IF (DTB%LDATA_SHADEARCHI) THEN
    PSHADEARCHI(:) = DTB%XPAR_SHADEARCHI(:)
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT, &
                            DTT%NPAR_BLDCODE,PSHADEARCHI=PSHADEARCHI)
  ELSE
    CALL AV_PGD(DTCO, &
                 PSHADEARCHI,PCOVER ,XDATA_SHADEARCHI(:),'TWN','ARI',OCOVER)
  ENDIF  
ENDIF
!
!     ISMECH
!     -----
IF (PRESENT(PISMECH)) THEN
   IF (DTB%LDATA_ISMECH) THEN
      PISMECH(:) = DTB%XPAR_ISMECH(:)
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(BDD, DTT,DTT%NPAR_BLDCODE,PISMECH=PISMECH)
   ELSE
      CALL AV_PGD (DTCO,PISMECH,PCOVER ,XDATA_ISMECH(:),'TWN','ARI',OCOVER)
   ENDIF
ENDIF
!
!     MECHRATE
!     -----
IF (PRESENT(PMECHRATE)) THEN
   IF (DTB%LDATA_MECHRATE) THEN
      PMECHRATE(:) = DTB%XPAR_MECHRATE(:)
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(BDD, DTT,DTT%NPAR_BLDCODE,PMECHRATE=PMECHRATE)
   ELSE
      CALL AV_PGD (DTCO,PMECHRATE,PCOVER ,XDATA_MECHRATE(:),'TWN','ARI',OCOVER)
   ENDIF
ENDIF
!
! B: Occupant behavioural characteristics
!
! Fraction of compartments in bem
!
IF (PRESENT(PFRACOMP)) THEN
   !
   IF (DTB%LDATA_FRACOMP) THEN
      PFRACOMP=DTB%XPAR_FRACOMP
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(BDD, DTT,DTT%NPAR_BLDCODE,PFRACOMP=PFRACOMP)
   ELSE
      CALL ABOR1_SFX("Not yet implemented")
      ! CALL AV_PGD (DTCO,PTHEAT_OCCD,PCOVER,XDATA_THEAT_OCCD(:),'BLD','ARI',OCOVER)
   ENDIF
ENDIF
!
! Heating design temperature when occupied during the day
!
IF (PRESENT(PTHEAT_OCCD)) THEN
   IF (DTB%LDATA_THEAT_OCCD) THEN
      PTHEAT_OCCD=DTB%XPAR_THEAT_OCCD
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(BDD, DTT,DTT%NPAR_BLDCODE,PTHEAT_OCCD=PTHEAT_OCCD)
   ELSE
      CALL ABOR1_SFX("Not yet implemented")
      !CALL AV_PGD (DTCO,PTHEAT_OCCD,PCOVER,XDATA_THEAT_OCCD(:),'BLD','ARI',OCOVER)
   ENDIF
ENDIF
!
! Heating design temperature when occupied during night
!
IF (PRESENT(PTHEAT_OCCN)) THEN
   IF (DTB%LDATA_THEAT_OCCN) THEN
      PTHEAT_OCCN=DTB%XPAR_THEAT_OCCN
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(BDD, DTT,DTT%NPAR_BLDCODE,PTHEAT_OCCN=PTHEAT_OCCN)
   ELSE
      CALL ABOR1_SFX("Not yet implemented")
      !CALL AV_PGD (DTCO,PTHEAT_OCCN,PCOVER,XDATA_THEAT_OCCN(:),'BLD','ARI',OCOVER)
   ENDIF
ENDIF
!
! Heating design temperature when vacant during the day
!
IF (PRESENT(PTHEAT_VCDD)) THEN
   IF (DTB%LDATA_THEAT_VCDD) THEN
      PTHEAT_VCDD=DTB%XPAR_THEAT_VCDD
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(BDD, DTT,DTT%NPAR_BLDCODE,PTHEAT_VCDD=PTHEAT_VCDD)
   ELSE
      CALL ABOR1_SFX("Not yet implemented")
      !CALL AV_PGD (DTCO,PTHEAT_VCDD,PCOVER,XDATA_THEAT_VCDD(:),'BLD','ARI',OCOVER)
   ENDIF
ENDIF
!
! Heating design temperature when vacant during the night
!
IF (PRESENT(PTHEAT_VCDN)) THEN
   IF (DTB%LDATA_THEAT_VCDN) THEN
      PTHEAT_VCDN=DTB%XPAR_THEAT_VCDN
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(BDD, DTT,DTT%NPAR_BLDCODE,PTHEAT_VCDN=PTHEAT_VCDN)
   ELSE
      CALL ABOR1_SFX("Not yet implemented")    
      !CALL AV_PGD (DTCO,PTHEAT_VCDN,PCOVER,XDATA_THEAT_VCDN(:),'BLD','ARI',OCOVER)
   ENDIF
ENDIF
!
! Heating design temperature when vacant for long-term
!
IF (PRESENT(PTHEAT_VCLD)) THEN
   IF (DTB%LDATA_THEAT_VCLD) THEN
      PTHEAT_VCLD=DTB%XPAR_THEAT_VCLD
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(BDD, DTT,DTT%NPAR_BLDCODE,PTHEAT_VCLD=PTHEAT_VCLD)
   ELSE
      CALL ABOR1_SFX("Not yet implemented")
      !CALL AV_PGD (DTCO,PTHEAT_VCLD,PCOVER,XDATA_THEAT_VCLD(:),'BLD','ARI',OCOVER)
   ENDIF
ENDIF
!
! Cooling design temperature when occupied during the day
!
IF (PRESENT(PTCOOL_OCCD)) THEN
   IF (DTB%LDATA_TCOOL_OCCD) THEN
      PTCOOL_OCCD=DTB%XPAR_TCOOL_OCCD
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(BDD, DTT,DTT%NPAR_BLDCODE,PTCOOL_OCCD=PTCOOL_OCCD)
   ELSE
      CALL ABOR1_SFX("Not yet implemented")
      !CALL AV_PGD (DTCO,PTCOOL_OCCD,PCOVER,XDATA_TCOOL_OCCD(:),'BLD','ARI',OCOVER)
   ENDIF
ENDIF
!
! Cooling design temperature when occupied during night
!
IF (PRESENT(PTCOOL_OCCN)) THEN
   IF (DTB%LDATA_TCOOL_OCCN) THEN
      PTCOOL_OCCN=DTB%XPAR_TCOOL_OCCN
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(BDD, DTT,DTT%NPAR_BLDCODE,PTCOOL_OCCN=PTCOOL_OCCN)
   ELSE
      CALL ABOR1_SFX("Not yet implemented")
      !CALL AV_PGD (DTCO,PTCOOL_OCCN,PCOVER,XDATA_TCOOL_OCCN(:),'BLD','ARI',OCOVER)
   ENDIF
ENDIF
!
! Cooling design temperature when vacant during the day
!
IF (PRESENT(PTCOOL_VCDD)) THEN
   IF (DTB%LDATA_TCOOL_VCDD) THEN
      PTCOOL_VCDD=DTB%XPAR_TCOOL_VCDD
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(BDD, DTT,DTT%NPAR_BLDCODE,PTCOOL_VCDD=PTCOOL_VCDD)
   ELSE
      CALL ABOR1_SFX("Not yet implemented")
      !CALL AV_PGD (DTCO,PTCOOL_VCDD,PCOVER,XDATA_TCOOL_VCDD(:),'BLD','ARI',OCOVER)
   ENDIF
ENDIF
!
! Cooling design temperature when vacant during the night
!
IF (PRESENT(PTCOOL_VCDN)) THEN
   IF (DTB%LDATA_TCOOL_VCDN) THEN
      PTCOOL_VCDN=DTB%XPAR_TCOOL_VCDN
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(BDD, DTT,DTT%NPAR_BLDCODE,PTCOOL_VCDN=PTCOOL_VCDN)
   ELSE
      CALL ABOR1_SFX("Not yet implemented")
      !CALL AV_PGD (DTCO,PTCOOL_VCDN,PCOVER,XDATA_TCOOL_VCDN(:),'BLD','ARI',OCOVER)
   ENDIF
ENDIF
!
! Cooling design temperature when vacant for long-term
!
IF (PRESENT(PTCOOL_VCLD)) THEN
   IF (DTB%LDATA_TCOOL_VCLD) THEN
      PTCOOL_VCLD=DTB%XPAR_TCOOL_VCLD
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(BDD, DTT,DTT%NPAR_BLDCODE,PTCOOL_VCLD=PTCOOL_VCLD)
   ELSE
      CALL ABOR1_SFX("Not yet implemented")
      !CALL AV_PGD (DTCO,PTCOOL_VCLD,PCOVER,XDATA_TCOOL_VCLD(:),'BLD','ARI',OCOVER)
   ENDIF
ENDIF
!
!     QIN
!     -----------
IF (PRESENT(PQIN)) THEN
   IF (DTB%LDATA_QIN) THEN
      PQIN=DTB%XPAR_QIN
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(BDD, DTT,DTT%NPAR_BLDCODE,PQIN=PQIN)
   ELSE
      CALL ABOR1_SFX("Not yet implemented")
      !CALL AV_PGD (DTCO,PQIN ,PCOVER ,XDATA_QIN(:),'TWN','ARI',OCOVER)
   ENDIF
ENDIF
!
!     QIN_FRAD
!     -----------
IF (PRESENT(PQIN_FRAD)) THEN
   IF (DTB%LDATA_QIN_FRAD) THEN
      PQIN_FRAD=DTB%XPAR_QIN_FRAD
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(BDD, DTT,DTT%NPAR_BLDCODE,PQIN_FRAD=PQIN_FRAD)
   ELSE
      CALL AV_PGD (DTCO,PQIN_FRAD ,PCOVER ,XDATA_QIN_FRAD(:),'TWN','ARI',OCOVER)
   ENDIF
ENDIF
!
!     QIN_FLAT
!     -----------
IF (PRESENT(PQIN_FLAT)) THEN
   IF (DTB%LDATA_QIN_FLAT) THEN
      PQIN_FLAT=DTB%XPAR_QIN_FLAT
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(BDD, DTT,DTT%NPAR_BLDCODE,PQIN_FLAT=PQIN_FLAT)
   ELSE
      CALL AV_PGD (DTCO,PQIN_FLAT ,PCOVER ,XDATA_QIN_FLAT(:),'TWN','ARI',OCOVER)
   ENDIF
ENDIF
!
! Modulation of qin for short term vacancy
!
IF (PRESENT(PMODQIN_VCD)) THEN
   IF (DTB%LDATA_MODQIN_VCD) THEN
      PMODQIN_VCD=DTB%XPAR_MODQIN_VCD
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(BDD, DTT,DTT%NPAR_BLDCODE,PMODQIN_VCD=PMODQIN_VCD)
   ELSE
      CALL ABOR1_SFX("Not yet implemented")
      !CALL AV_PGD(DTCO,PMODQIN_VCD,PCOVER ,XDATA_MODQIN_VCD(:),'TWN','ARI',OCOVER)
   ENDIF
ENDIF
!
! Modulation of qin for long-term vacancy
!
IF (PRESENT(PMODQIN_VLD)) THEN
   IF (DTB%LDATA_MODQIN_VLD) THEN
      PMODQIN_VLD=DTB%XPAR_MODQIN_VLD
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(BDD, DTT,DTT%NPAR_BLDCODE,PMODQIN_VLD=PMODQIN_VLD)
   ELSE
      CALL ABOR1_SFX("Not yet implemented")
      !CALL AV_PGD(DTCO,PMODQIN_VLD,PCOVER ,XDATA_MODQIN_VLD(:),'TWN','ARI',OCOVER)
   ENDIF
ENDIF
! 
! Modulation of qin during the night
!
IF (PRESENT(PMODQIN_NIG)) THEN
   IF (DTB%LDATA_MODQIN_NIG) THEN
      PMODQIN_NIG=DTB%XPAR_MODQIN_NIG
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(BDD, DTT,DTT%NPAR_BLDCODE,PMODQIN_NIG=PMODQIN_NIG)
   ELSE
      CALL ABOR1_SFX("Not yet implemented")
      ! CALL AV_PGD(DTCO,PMODQIN_NIG,PCOVER ,XDATA_MODQIN_NIG(:),'TWN','ARI',OCOVER)
   ENDIF
ENDIF
!
!     NATVENT
!     -------
IF (PRESENT(PNATVENT)) THEN
  IF (DTB%LDATA_NATVENT) THEN
     PNATVENT(:,:) = DTB%XPAR_NATVENT(:,:)
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(BDD, DTT,DTT%NPAR_BLDCODE,PNATVENT=PNATVENT)
  ELSE
     CALL ABOR1_SFX("Ventilation mode not given")
  ENDIF  
ENDIF
!
! Ventilation during warm conditions
!
IF (PRESENT(PFVSUM)) THEN
   IF (DTB%LDATA_FVSUM) THEN
      PFVSUM=DTB%XPAR_FVSUM
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(BDD, DTT,DTT%NPAR_BLDCODE,PFVSUM=PFVSUM)
   ELSE
      CALL ABOR1_SFX("Not yet implemented")
      !CALL AV_PGD(DTCO,PFVSUM,PCOVER,XDATA_FVSUM(:),'TWN','ARI',OCOVER)
   ENDIF
ENDIF
!
! Ventilation during night
!
IF (PRESENT(PFVNIG)) THEN
   IF (DTB%LDATA_FVNIG) THEN
      PFVNIG=DTB%XPAR_FVNIG
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(BDD, DTT,DTT%NPAR_BLDCODE,PFVNIG=PFVNIG)
   ELSE
      CALL ABOR1_SFX("Not yet implemented")
      !CALL AV_PGD(DTCO,PFVNIG,PCOVER ,XDATA_FVNIG(:),'TWN','ARI',OCOVER)
   ENDIF
ENDIF
!
! Short term ventilation indendend of meteorological conditions
!
IF (PRESENT(PFVSHO)) THEN
   IF (DTB%LDATA_FVSHO) THEN
      PFVSHO=DTB%XPAR_FVSHO
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(BDD, DTT,DTT%NPAR_BLDCODE,PFVSHO=PFVSHO)
   ELSE
      CALL ABOR1_SFX("Not yet implemented")
      !CALL AV_PGD(DTCO,PFVSHO,PCOVER ,XDATA_FVSHO(:),'TWN','ARI',OCOVER)
   ENDIF
ENDIF
!
! Design temperature for ventilation
!
IF (PRESENT(PTDESV)) THEN
   IF (DTB%LDATA_TDESV) THEN
      PTDESV=DTB%XPAR_TDESV
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(BDD, DTT,DTT%NPAR_BLDCODE,PTDESV=PTDESV)
   ELSE
      CALL AV_PGD(DTCO,PTDESV,PCOVER ,XDATA_TDESV,'TWN','ARI',OCOVER)
   ENDIF
ENDIF
!
! Ventilation when vacant
!
IF (PRESENT(PFVVAC)) THEN
   IF (DTB%LDATA_FVVAC) THEN
      PFVVAC=DTB%XPAR_FVVAC
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(BDD, DTT,DTT%NPAR_BLDCODE,PFVVAC=PFVVAC)
   ELSE
      CALL ABOR1_SFX("Not yet implemented")
      !CALL AV_PGD(DTCO,PFVVAC,PCOVER,XDATA_FVVAC(:),'TWN','ARI',OCOVER)
   ENDIF
ENDIF
!
! Fraction of windows to be opened
!
IF (PRESENT(PFOPEN)) THEN
   IF (DTB%LDATA_FOPEN) THEN
      PFOPEN=DTB%XPAR_FOPEN
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(BDD, DTT,DTT%NPAR_BLDCODE,PFOPEN=PFOPEN)
   ELSE
      CALL AV_PGD(DTCO,PFOPEN,PCOVER ,XDATA_FOPEN(:),'TWN','ARI',OCOVER)
   ENDIF
ENDIF
!
! Shading during warm conditions
!
IF (PRESENT(PFSSUM)) THEN
   IF (DTB%LDATA_FSSUM) THEN
      PFSSUM=DTB%XPAR_FSSUM
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(BDD, DTT,DTT%NPAR_BLDCODE,PFSSUM=PFSSUM)
   ELSE
      CALL ABOR1_SFX("Not yet implemented")
      !CALL AV_PGD(DTCO,PFSSUM,PCOVER,XDATA_FSSUM(:),'TWN','ARI',OCOVER)
   ENDIF
ENDIF
!
! Shading during night
!
IF (PRESENT(PFSNIG)) THEN
   IF (DTB%LDATA_FSNIG) THEN
      PFSNIG=DTB%XPAR_FSNIG
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(BDD, DTT,DTT%NPAR_BLDCODE,PFSNIG=PFSNIG)
   ELSE
      CALL ABOR1_SFX("Not yet implemented")
      !CALL AV_PGD(DTCO,PFSNIG,PCOVER,XDATA_FSNIG(:),'TWN','ARI',OCOVER)
   ENDIF
ENDIF
!
! Shading when building vacant
!
IF (PRESENT(PFSVAC)) THEN
   IF (DTB%LDATA_FSVAC) THEN
      PFSVAC=DTB%XPAR_FSVAC
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(BDD, DTT,DTT%NPAR_BLDCODE,PFSVAC=PFSVAC)
   ELSE
      CALL ABOR1_SFX("Not yet implemented")
      !CALL AV_PGD(DTCO,PFSVAC,PCOVER,XDATA_FSVAC(:),'TWN','ARI',OCOVER)
   ENDIF
ENDIF
!
! Wall insulation threshold for shading
! 
IF (PRESENT(PWIN_SW_MAX)) THEN
   IF (DTB%LDATA_WIN_SW_MAX) THEN
      PWIN_SW_MAX=DTB%XPAR_WIN_SW_MAX
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(BDD, DTT,DTT%NPAR_BLDCODE,PWIN_SW_MAX=PWIN_SW_MAX)
   ELSE
      CALL AV_PGD(DTCO,PWIN_SW_MAX,PCOVER,XDATA_WIN_SW_MAX(:),'TWN','ARI',OCOVER)
   ENDIF
ENDIF
!
! Start day of week for schedules
!
IF (PRESENT(PDAYWBEG_SCHED)) THEN
   IF (DTB%LDATA_DAYWBEG_SCHED) THEN
      PDAYWBEG_SCHED=DTB%XPAR_DAYWBEG_SCHED
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(BDD, DTT,DTT%NPAR_BLDCODE,PDAYWBEG_SCHED=PDAYWBEG_SCHED)
   ELSE
      CALL ABOR1_SFX('Schedules must not be prescribed as maps')
      ! CALL AV_PGD (PDAYWBEG_SCHED(:,JLAYER),PCOVER ,XDATA_DAYWBEG_SCHED(:,JLAYER),YAREA,YAVG,OCOVER)
   ENDIF
ENDIF
!
! Start hour for schedules
!
IF (PRESENT(PHOURBEG_SCHED)) THEN
   IF (DTB%LDATA_HOURBEG_SCHED) THEN
      PHOURBEG_SCHED=DTB%XPAR_HOURBEG_SCHED
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(BDD, DTT,DTT%NPAR_BLDCODE,PHOURBEG_SCHED=PHOURBEG_SCHED)
   ELSE
      CALL ABOR1_SFX('Schedules must not be prescribed as maps')
      !CALL AV_PGD (PHOURBEG_SCHED(:,JLAYER),PCOVER ,XDATA_HOURBEG_SCHED(:,JLAYER),YAREA,YAVG,OCOVER)
   ENDIF
ENDIF
!
! Julian day of holiday beginning
!
IF (PRESENT(PBEG_HOLIDAY)) THEN
   IF (DTB%LDATA_BEG_HOLIDAY) THEN
      PBEG_HOLIDAY=DTB%XPAR_BEG_HOLIDAY
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(BDD, DTT,DTT%NPAR_BLDCODE,PBEG_HOLIDAY=PBEG_HOLIDAY)
   ELSE
      CALL ABOR1_SFX('Holidays must not be prescribed as maps')
      ! CALL AV_PGD (PDAYWBEG_SCHED(:,JLAYER),PCOVER ,XDATA_DAYWBEG_SCHED(:,JLAYER),YAREA,YAVG,OCOVER)
   ENDIF
ENDIF
!
! Julian day of holiday end
!
IF (PRESENT(PEND_HOLIDAY)) THEN
   IF (DTB%LDATA_END_HOLIDAY) THEN
      PEND_HOLIDAY=DTB%XPAR_END_HOLIDAY
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(BDD, DTT,DTT%NPAR_BLDCODE,PEND_HOLIDAY=PEND_HOLIDAY)
   ELSE
      CALL ABOR1_SFX('Holidays must not be prescribed as maps')
      ! CALL AV_PGD (PDAYWBEG_SCHED(:,JLAYER),PCOVER ,XDATA_DAYWBEG_SCHED(:,JLAYER),YAREA,YAVG,OCOVER)
   ENDIF
ENDIF
!
! Modulation factor during holidays
!
IF (PRESENT(PMOD_HOLIDAY)) THEN
   IF (DTB%LDATA_MOD_HOLIDAY) THEN
      PMOD_HOLIDAY=DTB%XPAR_MOD_HOLIDAY
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(BDD, DTT,DTT%NPAR_BLDCODE,PMOD_HOLIDAY=PMOD_HOLIDAY)
   ELSE
      CALL ABOR1_SFX('Holidays must not be prescribed as maps')
      ! CALL AV_PGD (PDAYWBEG_SCHED(:,JLAYER),PCOVER ,XDATA_DAYWBEG_SCHED(:,JLAYER),YAREA,YAVG,OCOVER)
   ENDIF
ENDIF
!
! Probability of building occupation
!
IF (PRESENT(PPROBOCC)) THEN
   IF (DTB%LDATA_PROBOCC) THEN
      PPROBOCC=DTB%XPAR_PROBOCC
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(BDD, DTT,DTT%NPAR_BLDCODE,PPROBOCC=PPROBOCC)
   ELSE
      CALL ABOR1_SFX('Maps of building occuppation not implemented yet')
      ! CALL AV_PGD (PPROBOCC(:,1),PCOVER ,XDATA_PROBOCC(:,1),YAREA,YAVG,OCOVER)
   ENDIF
ENDIF
!
! Fraction of waste heat released into the canyon
!
IF (PRESENT(PF_WASTE_CAN)) THEN
   IF (DTB%LDATA_F_WASTE_CAN) THEN
      PF_WASTE_CAN=DTB%XPAR_F_WASTE_CAN
   ELSEIF (DTT%LDATA_BLDTYPE) THEN
      CALL INI_DATA_PARAM_TEB(BDD, DTT,DTT%NPAR_BLDCODE,PF_WASTE_CAN=PF_WASTE_CAN)
   ELSE
      CALL AV_PGD (DTCO,PF_WASTE_CAN ,PCOVER ,XDATA_F_WASTE_CAN(:),'TWN','ARI',OCOVER)
   ENDIF
ENDIF
!
!
!      ROUGH_ROOF
!      ----------
IF (PRESENT(PROUGH_ROOF)) THEN 
  IF (DTT%LDATA_ROUGH_ROOF) THEN
    PROUGH_ROOF=DTT%XPAR_ROUGH_ROOF
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT, &
                            DTT%NPAR_BLDCODE,PROUGH_ROOF=PROUGH_ROOF)
  ELSE
    CALL AV_PGD(DTCO, &
                 PROUGH_ROOF ,PCOVER ,XDATA_ROUGH_ROOF (:),YAREA,YAVG,OCOVER)  
  ENDIF  
ENDIF
!
!      ROUGH_WALL
!      ----------
IF (PRESENT(PROUGH_WALL)) THEN 
  IF (DTT%LDATA_ROUGH_WALL) THEN
    PROUGH_WALL=DTT%XPAR_ROUGH_WALL
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, DTT, &
                            DTT%NPAR_BLDCODE,PROUGH_WALL=PROUGH_WALL)
  ELSE
    CALL AV_PGD(DTCO, &
                 PROUGH_WALL ,PCOVER ,XDATA_ROUGH_WALL (:),YAREA,YAVG,OCOVER)  
  ENDIF  
ENDIF
!
! --------------------------------------------------------------------------! 
!
!      * New fields for case of street trees
!
!      HTRUNK_HVEG
!      ----------
IF (PRESENT(PHTRUNK_HVEG)) THEN 
  PHTRUNK_HVEG=DTGD%XPAR_HTRUNK_HVEG
ENDIF
!
!      WCROWN_HVEG
!      ----------
IF (PRESENT(PWCROWN_HVEG)) THEN 
  PWCROWN_HVEG=DTGD%XPAR_WCROWN_HVEG
ENDIF
!
!      LAI_HVEG
!      --------
IF (PRESENT(PLAI_HVEG)) THEN 
  PLAI_HVEG=DTGD%XPAR_LAI_HVEG(:,7)
ENDIF
!
!      ALB_HVEG
!      --------
IF (PRESENT(PALB_HVEG)) THEN 
  PALB_HVEG=DTGD%XPAR_ALB_HVEG(:)
ENDIF
!
!      ALB_LVEG
!      --------
IF (PRESENT(PALB_LVEG)) THEN 
  PALB_LVEG=DTGD%XPAR_ALB_LVEG(:)
ENDIF
! 
!
! --------------------------------------------------------------------------! 
!
!      * New fields for case of urban hydrology
!
!      LSEWER
!      ------
IF (PRESENT(PLSEWER)) THEN 
  PLSEWER=DTH%XPAR_LSEWER
ENDIF
!
!      LSTORM
!      ------
IF (PRESENT(PLSTORM)) THEN 
  PLSTORM=DTH%XPAR_LSTORM
ENDIF
!
!      DSEWER
!      ------
IF (PRESENT(PDSEWER)) THEN 
  PDSEWER=DTH%XPAR_DSEWER
ENDIF
!
IF (LHOOK) CALL DR_HOOK('CONVERT_PATCH_TEB',1,ZHOOK_HANDLE)
!
!-------------------------------------------------------------------------------
CONTAINS
!
SUBROUTINE ALLOCATE_THERMAL_WORK(KPAR)
INTEGER, INTENT(IN) :: KPAR
ALLOCATE(ZD(IL,KPAR))
ALLOCATE(ZHC(IL,KPAR))
ALLOCATE(ZTC(IL,KPAR))
END SUBROUTINE ALLOCATE_THERMAL_WORK
SUBROUTINE DEALLOCATE_THERMAL_WORK
DEALLOCATE(ZD)
DEALLOCATE(ZHC)
DEALLOCATE(ZTC)
END SUBROUTINE DEALLOCATE_THERMAL_WORK
!-------------------------------------------------------------------------------
!
END SUBROUTINE CONVERT_PATCH_TEB
