!
!   ####################################################################
!
SUBROUTINE BEM (HPROGRAM, PTSTEP, KDAY, OAUTOSIZE,                          &
     PBLD, PBLD_HEIGHT, PN_FLOOR, PGR, PN50,PEFF_HEAT, PHC_FLOOR,PTC_FLOOR, &
     PD_FLOOR, PHC_MASS, PTC_MASS, PD_MASS,                                 &
     PHC_ALLBLD, PTC_ALLBLD, PD_ALLBLD,                                     &  
     PF_FLOOR_MASS, PF_FLOOR_WALL,                                          &
     PF_FLOOR_WIN, PF_FLOOR_ROOF,PF_MASS_FLOOR, PF_MASS_WALL, PF_MASS_WIN,  &
     PRADHT_IN, PWALL_O_BLD, PGLAZ_O_BLD, PMASS_O_BLD, HCOOL_COIL,          &
     HHEAT_COIL, PPS, PPSOLD, PRHOA, PT_CANYON, PQ_CANYON, PU_CANYON,       &
     PT_ROOF, PT_WALL_A, PT_WALL_B, PT_WIN2, PLOAD_IN_FLOOR, PLOAD_IN_MASS, &
     PCONV_ROOF_BLD, PCONV_WALL_BLD, PCONV_WIN_BLD, PRAD_ROOF_MASS,         &
     PRAD_ROOF_FLOOR, PRAD_WALL_MASS, PRAD_WALL_FLOOR, PRAD_WIN_MASS,       &
     PRAD_WIN_FLOOR, HNATVENT, PVENT_BEHAV_ANYWAY, PVENT_BEHAV_ADAPTI, PTCOOL_TARGET,PTHEAT_TARGET,    &
     PHR_TARGET, PQIN, PQIN_FRAD, PQIN_FLAT, PF_WASTE_CAN, PTDESV,          &
     PISMECH, PMECHRATE, PFVSHO, PSHADE, PSHGC_SH, PFOPEN, PF_WATER_COND,   &
     PCAP_SYS_HEAT,PT_ADP,PCOP_RAT,                                         &
     PT_FLOOR, PT_MASS, PT_ALLBLD, PTI_BLD, PQI_BLD, PCAP_SYS_RAT,          &
     PM_SYS_RAT, PAUX_MAX,                                                  &
     PH_BLD_COOL, PH_BLD_HEAT, PLE_BLD_COOL, PLE_BLD_HEAT, PT_BLD_COOL,     &
     PHVAC_COOL, PHVAC_HEAT, PT_SYS, PQ_SYS, PM_SYS, PH_WASTE_CANY,         &
     PLE_WASTE_CANY, PH_WASTE_ROOF, PLE_WASTE_ROOF, PCOP, PCAP_SYS,         &
     PFLX_BLD_FLOOR,PFLX_BLD_MASS,PINFCALC,PRHOI_NEW,PDIAGVENT,PDIAGVEFL,   &
     PCST_H_WASTE_CANY,PCST_LE_WASTE_CANY,PCOEFF_H_WASTE_CANY,              &
     PCOEFF_LE_WASTE_CANY)
  !
  !   ##################################################################
  !
  !!****  *BEM*
  !!
  !!    PURPOSE
  !!    -------
  !
  !     Computes the temperature and humidity evolution of indoor air, 
  !     building energy demand, HVAC energy consumption, 
  !     waste heat from HVAC systems, and heat fluxes from indoor to building surfaces.
  !
  !
  !!**  METHOD
  !     ------
  !
  !              NOMENCLATURE: bld  - refers to building plant area; 
  !                            floor- refers to building plant area multiplied 
  !                                   by the number of floors;
  !                            wall - refers to wall area (excluding windows).
  !                            win  - refers to window area. 
  !                            mass - refers to internal mass area. 
  !
  !
  !        solar radiation transmitted through windows
  !        *******************************************
  !
  !     Qsol_tr_win = Qsol_facade * tr_win * GR 
  !
  !
  !        indoor wall conv/rad heat transfer coefficients
  !        ***********************************************
  !
  !     The calculation of CHTC accounts for favorable or unfavorable convection 
  !     depending on the relative position between the hot layer and cold layer
  !
  ! 
  !        building energy demand
  !        **********************
  !
  !     Calculation of the cooling and heating, sensible and latent building energy demand.
  !     The sensible demand includes the convective heat transfer from indoor surfaces, the 
  !     convective fraction of internal heat gains, and sensible infiltration/ventilation heat
  !     gains. The latent demand includes the latent fraction of internal heat gains and latent
  !     infiltration/ventilation heat gains.  
  !
  !        surface areas and volummes (referred to m2_bld)
  !        ***********************************************
  !
  !     Awall   =  WALL_O_BLD [m2_wall/m2_bld]
  !     Awin    =  GLAZ_O_BLD [m2_win/m2_bld]   
  !     Amass   =  2 * N_FLOOR                 [m2_mass/m2_bld]  
  !     N_FLOOR  =  BLD_HEIGHT / FLOOR_HEIGHT  [#]
  !     Aroof   =  1                           [m2_roof/m2_bld]  
  !     Afloor  =  1                           [m2_floor/m2_bld]   
  !     Vol_air =  BLD_HEIGHT                  [m3_bld/m2_bld]
  !
  !
  !        evolution of the internal temperature
  !        *************************************
  !
  !                                  dTin  
  !     Vol_air * ro_air * cp_air * ---- =    h_wall * Awall * (Twall - Tin)
  !                                   dt    + h_roof * Aroof * (Troof -Tin)
  !                                         + h_floor * Afloor *(Tfloor - Tin)
  !                                         + h_mass * Amass * (Tmass - Tin)
  !                                         + h_win * Awin * (Twin - Tin)
  !                                         + Qig * (1 - fig_rad) * (1-fig_lat)
  !                                         + Vinf * ro_air * cp_air * (Tout - Tin) 
  !                                         + Vsys * ro_air * cp_air * (Tsys - Tin) 
  !
  !
  !        evolution of the internal specific humidity
  !        *******************************************
  !
  !                                  dQin  
  !      Vol_air * ro_air * lv_air * ---- = Qig * fig_lat
  !                                   dt    + Vinf * ro_air * lv_air * (Qout - Qin) 
  !                                         + Vsys * ro_air * lv_air * (Qsys - Qin) 
  !
  !
  !        heat fluxes from indoor to surfaces
  !        ***********************************
  !
  !      Qin_wall  = h_wall  * (Tin - Twall)  [W/m2_wall]
  !      Qin_roof  = h_roof  * (Tin - Troof)  [W/m2_roof] 
  !      Qin_floor = h_floor * (Tin - Tfloor) [W/m2_floor] 
  !      Qin_mass  = h_wall  * (Tin - Tmass)  
  !                + Qig * fig_rad * (1-fig_lat)/ 2  
  !                + Qsol_tr_win              [W/m2_mass]
  !
  !
  !        energy consumption and waste heat from cooling system
  !        *****************************************************
  !
  !      Qhvac  = Qbld / COP
  !      Qwaste = Qbld + Qhvac
  !
  !
  !        energy consumption and waste heat from heating system
  !        *****************************************************
  !
  !      Qhvac  = Qbld / Eff
  !      Qwaste = Qhvac - Qbld
  !
  !
  !!    EXTERNAL
  !!    --------
  !!
  !!
  !!    IMPLICIT ARGUMENTS
  !!    ------------------
  !!
  !!
  !!    REFERENCE
  !!    ---------
  !!
  !!
  !!    AUTHOR
  !!    ------
  !!
  !!	B. Bueno           * Meteo-France *
  !!
  !!    MODIFICATIONS
  !!    -------------
  !!     Original 2010
  !!     G. Pigeon nov. 2011: inclusion floor/mass budget inside
  !!                          add automatic/manual ventilation
  !!                          conserve exchanges with the different surfaces inside 1 time step
  !!    G. Pigeon sept. 2012: use of TARP/DOE coef for indoor convection
  !!                          use of both PT_WALL_A and PT_WALL_B for calculations
  !!                          the internal mass depth is 1/2 of the floor depth
  !!                          add the option of no atmospheric heat releases by HVAC system (PF_WATER_COND < 0)
  !!    G. Pigeon oct. 2012:  use indoor air density + new solar heat gain distribution
  !!    V. Masson May  2013   implicitation of internal building temperature evolution
  !!    V. Masson Mars 2016   soil column under buildings
  !-------------------------------------------------------------------------------
  !
  ! 0.     DECLARATIONS
  !
  USE MODD_CSTS,ONLY : XCPD,XSTEFAN,XLVTT,XG,XRV,XRD,XCPV
  USE MODE_THERMOS
  USE MODE_PSYCHRO
  USE MODI_DX_AIR_COOLING_COIL_CV
  USE MODI_FLOOR_LAYER_E_BUDGET
  USE MODI_MASS_LAYER_E_BUDGET
  USE MODE_CONV_DOE
  !
  USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
  USE PARKIND1  ,ONLY : JPRB
  !
  IMPLICIT NONE
  !
  ! 0.1    Declarations of arguments
  !
  INTEGER,          INTENT(IN) :: KDAY       ! Simulation day
  REAL,             INTENT(IN) :: PTSTEP     ! Time step
  LOGICAL,          INTENT(IN) :: OAUTOSIZE  ! Flag to activate autosize calculations
  CHARACTER(LEN=6), INTENT(IN) :: HCOOL_COIL ! type of cooling system
  CHARACTER(LEN=6), INTENT(IN) :: HHEAT_COIL ! type of heating system
  CHARACTER(LEN=6), INTENT(IN) :: HPROGRAM   ! program calling surf. schemes
  !
  CHARACTER(LEN=4), DIMENSION(:), INTENT(IN) :: HNATVENT ! switch for ventilation type
  !
  REAL, DIMENSION(:), INTENT(IN) :: PSHGC_SH        ! window + shading solar heat gain coef.
  REAL, DIMENSION(:), INTENT(IN) :: PTDESV         ! Desing temperature for ventilation [K]
  REAL, DIMENSION(:), INTENT(IN) :: PPS             ! Canyon air pressure [Pa]
  REAL, DIMENSION(:), INTENT(IN) :: PPSOLD          ! Canyon air pressure at previous time step [Pa]
  REAL, DIMENSION(:), INTENT(IN) :: PRHOA           ! Air density at the lowest level [kg m-3]
  REAL, DIMENSION(:), INTENT(IN) :: PT_CANYON       ! Canyon air temperature [K]
  REAL, DIMENSION(:), INTENT(IN) :: PQ_CANYON       ! Canyon air specific humidity [kg kg-1]
  REAL, DIMENSION(:), INTENT(IN) :: PU_CANYON       ! Canyon wind speed (m s-1)
  REAL, DIMENSION(:), INTENT(IN) :: PT_WIN2         ! Indoor window temperature [K]
  REAL, DIMENSION(:), INTENT(IN) :: PGR             ! Glazing ratio
  REAL, DIMENSION(:), INTENT(IN) :: PQIN            ! Internal heat gains [W m-2(floor)]
  REAL, DIMENSION(:), INTENT(IN) :: PQIN_FRAD       ! Radiant fraction of internal heat gains
  REAL, DIMENSION(:), INTENT(IN) :: PQIN_FLAT       ! Latent franction of internal heat gains
  REAL, DIMENSION(:), INTENT(IN) :: PN50            ! Airtightness [AC/H at 50 Pa]
  REAL, DIMENSION(:), INTENT(IN) :: PEFF_HEAT       ! Heating system efficiency
  REAL, DIMENSION(:), INTENT(IN) :: PTCOOL_TARGET   ! Cooling setpoint of HVAC system [K]
  REAL, DIMENSION(:), INTENT(IN) :: PTHEAT_TARGET   ! Heating setpoint of HVAC system [K]
  REAL, DIMENSION(:), INTENT(IN) :: PF_WASTE_CAN    ! Fraction of waste heat released into the canyon
  REAL, DIMENSION(:), INTENT(IN) :: PHR_TARGET      ! Relative humidity setpoint
  REAL, DIMENSION(:), INTENT(IN) :: PF_WATER_COND   ! Fraction of evaporation for the condensers
  REAL, DIMENSION(:), INTENT(IN) :: PCAP_SYS_HEAT   ! Cap. of the heating system [W m-2(bld)]
  REAL, DIMENSION(:), INTENT(IN) :: PT_ADP          ! Apparatus dewpoint temperature of the cooling coil [K]          
  REAL, DIMENSION(:), INTENT(IN) :: PCOP_RAT        ! Rated COP of the cooling system
  REAL, DIMENSION(:), INTENT(IN) :: PBLD            ! Urban horizontal building density
  REAL, DIMENSION(:), INTENT(IN) :: PBLD_HEIGHT     ! Average building height [m]
  REAL, DIMENSION(:), INTENT(IN) :: PF_FLOOR_MASS   ! View factor floor-mass
  REAL, DIMENSION(:), INTENT(IN) :: PF_FLOOR_WALL   ! View factor floor-wall
  REAL, DIMENSION(:), INTENT(IN) :: PF_FLOOR_WIN    ! View factor floor-window
  REAL, DIMENSION(:), INTENT(IN) :: PRADHT_IN       ! Indoor radiant heat transfer coefficient [W K-1 m-2]
  REAL, DIMENSION(:), INTENT(IN) :: PN_FLOOR        ! Number of floors     
  REAL, DIMENSION(:), INTENT(IN) :: PWALL_O_BLD     ! Wall area [m2_wall/m2_bld]
  REAL, DIMENSION(:), INTENT(IN) :: PGLAZ_O_BLD     ! Window area [m2_win/m2_bld]
  REAL, DIMENSION(:), INTENT(IN) :: PMASS_O_BLD     ! Mass area [m2_mass/m2_bld]
  REAL, DIMENSION(:), INTENT(IN) :: PF_FLOOR_ROOF   ! View factor floor-roof
  REAL, DIMENSION(:), INTENT(IN) :: PF_MASS_FLOOR   ! View factor mass-floor
  REAL, DIMENSION(:), INTENT(IN) :: PF_MASS_WALL    ! View factor mass-wall
  REAL, DIMENSION(:), INTENT(IN) :: PF_MASS_WIN     ! View factor mass-window
  REAL, DIMENSION(:), INTENT(IN) :: PRAD_ROOF_MASS  ! Rad. fluxes between roof and mass
  REAL, DIMENSION(:), INTENT(IN) :: PRAD_ROOF_FLOOR ! Rad. fluxes between roof and floor
  REAL, DIMENSION(:), INTENT(IN) :: PRAD_WALL_MASS  ! Rad. fluxes between wall and mass
  REAL, DIMENSION(:), INTENT(IN) :: PRAD_WALL_FLOOR ! Rad. fluxes between wall and floor
  REAL, DIMENSION(:), INTENT(IN) :: PRAD_WIN_MASS   ! Rad. fluxes between wind. and mass
  REAL, DIMENSION(:), INTENT(IN) :: PRAD_WIN_FLOOR  ! Rad. fluxes between wind. and floor
  REAL, DIMENSION(:), INTENT(IN) :: PCONV_ROOF_BLD  ! Conv. fluxes between roof and indoor air
  REAL, DIMENSION(:), INTENT(IN) :: PCONV_WALL_BLD  ! Conv. fluxes between wall and indoor air
  REAL, DIMENSION(:), INTENT(IN) :: PCONV_WIN_BLD   ! Conv. fluxes between wind. and indoor air
  REAL, DIMENSION(:), INTENT(IN) :: PLOAD_IN_FLOOR  ! solar + int heat gain on floor W/m² [floor]
  REAL, DIMENSION(:), INTENT(IN) :: PLOAD_IN_MASS   ! solar + int heat gain on floor W/m² [mass]
  !
  REAL, DIMENSION(:,:), INTENT(INOUT) :: PT_ALLBLD     ! soil layers temperatures under buildings
  REAL, DIMENSION(:,:), INTENT(IN)  :: PHC_ALLBLD      ! heat capacity for floor/soil layers under buildings
  REAL, DIMENSION(:,:), INTENT(IN)  :: PTC_ALLBLD      ! thermal conductivity for floor/soil layers under buildings
  REAL, DIMENSION(:,:), INTENT(IN)  :: PD_ALLBLD       ! depth of floor/soil layers under buildings
  !
  REAL, DIMENSION(:), INTENT(IN) :: PFVSHO          ! Ventilation independent of indoor/outdoor temperature
  REAL, DIMENSION(:), INTENT(IN) :: PFOPEN          ! Fraction of windows to be opened
  REAL, DIMENSION(:), INTENT(IN) :: PVENT_BEHAV_ANYWAY   ! Fraction of windows opened in any case
  REAL, DIMENSION(:), INTENT(IN) :: PVENT_BEHAV_ADAPTI   ! Fraction of windows that could be opened
  REAL, DIMENSION(:), INTENT(IN) :: PSHADE          ! Fraction of blinds closed
  REAL, DIMENSION(:), INTENT(IN) :: PISMECH         ! Presence of mechanical ventilation (architectural characteristic)
  REAL, DIMENSION(:), INTENT(IN) :: PMECHRATE       ! Air exchange rate due to mechanical ventilation [1/h]
  !
  REAL, DIMENSION(:,:), INTENT(IN) :: PT_ROOF    ! Roof layers temperatures [K]
  REAL, DIMENSION(:,:), INTENT(IN) :: PT_WALL_A  ! Wall A layers temperatures [K]
  REAL, DIMENSION(:,:), INTENT(IN) :: PT_WALL_B  ! Wall B layers temperatures [K]
  REAL, DIMENSION(:,:), INTENT(IN) :: PHC_FLOOR  ! Heat capacity for floor layers
  REAL, DIMENSION(:,:), INTENT(IN) :: PTC_FLOOR  ! Thermal conductivity for floor layers
  REAL, DIMENSION(:,:), INTENT(IN) :: PD_FLOOR   ! Depth of floor layers
  REAL, DIMENSION(:,:), INTENT(IN) :: PHC_MASS   ! Heat capacity for mass layers
  REAL, DIMENSION(:,:), INTENT(IN) :: PTC_MASS   ! Thermal conductivity for mass layers
  REAL, DIMENSION(:,:), INTENT(IN) :: PD_MASS    ! Depth of mass layers
  !
  REAL, DIMENSION(:), INTENT(OUT) :: PH_BLD_COOL    ! Sensible cooling energy demand of the building [W m-2(bld)]
  REAL, DIMENSION(:), INTENT(OUT) :: PH_BLD_HEAT    ! Heating energy demand of the building [W m-2(bld)]
  REAL, DIMENSION(:), INTENT(OUT) :: PLE_BLD_COOL   ! Latent cooling energy demand of the building [W m-2(bld)]
  REAL, DIMENSION(:), INTENT(OUT) :: PLE_BLD_HEAT   ! Latent heating energy demand of the building [W m-2(bld)]
  REAL, DIMENSION(:), INTENT(OUT) :: PT_BLD_COOL    ! Total cooling energy demand of the building [W m-2(bld)]
  REAL, DIMENSION(:), INTENT(OUT) :: PHVAC_COOL     ! Energy consumption of the cooling system [W m-2(bld)]
  REAL, DIMENSION(:), INTENT(OUT) :: PT_SYS         ! Supply air temperature [K]                         
  REAL, DIMENSION(:), INTENT(OUT) :: PQ_SYS         ! Supply air specific humidity [kg kg-1]
  REAL, DIMENSION(:), INTENT(OUT) :: PH_WASTE_CANY  ! Sensible waste heat to canyon [W m-2(urb)]
  REAL, DIMENSION(:), INTENT(OUT) :: PLE_WASTE_CANY ! Latent waste heat to canyon [W m-2(urb)]
  REAL, DIMENSION(:), INTENT(OUT) :: PH_WASTE_ROOF  ! Sensible waste heat to roof [W m-2(urb)]
  REAL, DIMENSION(:), INTENT(OUT) :: PLE_WASTE_ROOF ! Latent waste heat to roof [W m-2(urb)]
  REAL, DIMENSION(:), INTENT(OUT) :: PHVAC_HEAT     ! Energy consumption of the heating system [W m-2(bld)]
  REAL, DIMENSION(:), INTENT(OUT) :: PM_SYS         ! Actual HVAC mass flow rate [kg s-1 m-2(bld)]
  REAL, DIMENSION(:), INTENT(OUT) :: PCOP           ! COP of the cooling system
  REAL, DIMENSION(:), INTENT(OUT) :: PCAP_SYS       ! Actual capacity of the cooling system [W m-2(bld)] 
  REAL, DIMENSION(:), INTENT(OUT) :: PFLX_BLD_FLOOR ! Heat flux from indoor air to floor [W m-2(bld)]
  REAL, DIMENSION(:), INTENT(OUT) :: PFLX_BLD_MASS  ! Heat flux from indoor air to mass [W m-2(bld)]
  REAL, DIMENSION(:), INTENT(OUT) :: PINFCALC       ! Infiltration calculated [vol/h]
  REAL, DIMENSION(:), INTENT(OUT) :: PRHOI_NEW      ! indoor air density
  REAL, DIMENSION(:), INTENT(OUT) :: PDIAGVEFL      ! Diagnostic of ventilation exchange rate [1/h]
  REAL, DIMENSION(:), INTENT(OUT) :: PDIAGVENT      ! Is ventilation active?
  REAL, DIMENSION(:), INTENT(OUT) :: PCST_H_WASTE_CANY
  REAL, DIMENSION(:), INTENT(OUT) :: PCST_LE_WASTE_CANY
  REAL, DIMENSION(:), INTENT(OUT) :: PCOEFF_H_WASTE_CANY
  REAL, DIMENSION(:), INTENT(OUT) :: PCOEFF_LE_WASTE_CANY
  !
  REAL, DIMENSION(:), INTENT(INOUT) :: PAUX_MAX     ! Auxiliar variable for autosize calcs
  REAL, DIMENSION(:), INTENT(INOUT) :: PTI_BLD      ! Indoor air temperature [K]
  REAL, DIMENSION(:), INTENT(INOUT) :: PQI_BLD      ! Indoor air specific humidity [kg kg-1]
  REAL, DIMENSION(:), INTENT(INOUT) :: PCAP_SYS_RAT ! Rated cap. of the cooling system [W m-2(bld)]
  REAL, DIMENSION(:), INTENT(INOUT) :: PM_SYS_RAT   ! Rated HVAC mass flow rate [kg s-1 m-2(bld)]
  !
  REAL, DIMENSION(:,:), INTENT(INOUT) :: PT_FLOOR ! Floor layers temperatures [K]
  REAL, DIMENSION(:,:), INTENT(INOUT) :: PT_MASS  ! Internal mass layers temperatures [K]
  !
  ! 0.2    Declarations of local variables 
  !
  INTEGER :: IROOF   ! Number of roof layers
  INTEGER :: IWALL   ! Number of wall layers
  INTEGER :: JLAYER  ! Loop counter
  INTEGER :: JJ,KK   ! Loop counter
  INTEGER :: ILUOUT  ! Unit number
  !
  REAL(KIND=JPRB) :: ZHOOK_HANDLE
  !
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZIMB_SENH_BLD   ! Imbalance of indoor air sensible heat [W m-2(urb)]
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZIMB_LATH_BLD   ! Imbalance of indoor air latent heat [W m-2(urb)]
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZQIN            ! Internal heat gains [W m-2(bld)]
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZINF            ! Infiltration flow rate [m3 s-1 m-2(bld)]
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZNAT_VENT       ! Nat.vent airflow rate [m3 s-1 m-2(bld)]
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZTI_BLD_OPEN    ! Indoor air temperature if windows opened
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZTI_BLD_CLOSED  ! Indoor air temperature if windows closed
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZQCOOL_TARGET   ! Specific humidity cooling setpoing [kg kg-1]
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZQHEAT_TARGET   ! Specific humidity heating setpoing [kg kg-1]
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZM_SYS_RAT      ! Auxiliar mass flow rate [kg s-1 m-2(bld)]
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZXMIX           ! Outdoor mixing fraction
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZT_MIX          ! Mixing air temperature [K]
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZQ_MIX          ! Mixing air specific humidity [kg kg-1]
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZWASTE
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZDQS_FLOOR
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZDQS_MASS
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZRAD_FLOOR_MASS ! Rad. fluxes from floor to mass
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZCONV_FLOOR_BLD ! Conv. fluxes from floor to indoor air
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZCONV_MASS_BLD  ! Conv. fluxes from mass to indoor air
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZTV_BLD_OLD     ! Virtual temperature before update
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZTV_BLD_NEW     ! Virtual temperature after update
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZTI_BLD_OLD     ! Indoor temperature before update
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZDIFFAIRMASS    ! Difference of indoor air mass
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZRHOI_OLD       ! indoor air density
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZRHOI           ! indoor air density
  !
  REAL :: ZHPAIRTW ! Warm reservoir temperature for air-source heat pump
  REAL :: ZHPAIRTC ! Cold reservoir temperature for air-source heat pump
  REAL :: ZCOPCARI ! Ideal Carnot efficiency
  REAL :: ZCOPCARR ! Real Carnot efficiency
  !
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZCHTC_IN_FLOOR
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZTS_FLOOR_CONV
  !
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZSRCCONVWALL
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZSRCCONVGLAZ
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZSRCCONVMASS
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZSRCCONVROOF
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZSRCCONVFLOO
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZSRCQINSENHE
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZSRCQINLATHE
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZSRCSENINFVE
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZSRCLATINFVE
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZSRCSENHHVAC
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZSRCLATHHVAC
  !
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZAC_IN_MASS_COOL,ZAC_IN_FLOOR_COOL
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZAC_IN_ROOF_COOL,ZAC_IN_WALL_A_COOL
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZAC_IN_WALL_B_COOL,ZAC_IN_WIN_COOL   
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZAC_IN_MASS_HEAT,ZAC_IN_FLOOR_HEAT
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZAC_IN_ROOF_HEAT,ZAC_IN_WALL_A_HEAT
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZAC_IN_WALL_B_HEAT,ZAC_IN_WIN_HEAT  
  !
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZDIFFAIRSEN
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZDIFFAIRLAT
  !
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZTHEAIRIN_NEW
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZTHEAIRIN_OLD
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZLATAIRIN_NEW
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZLATAIRIN_OLD
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZDIFFSENAIRIN
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZDIFFLATAIRIN
  !
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZUP_HVAC_HEAT
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZUP_HVAC_COOL
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZUP_H_WASTE_CANY
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZUP_H_WASTE_ROOF
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZUP_LE_WASTE_CANY
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZUP_LE_WASTE_ROOF
  !
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZFRAC_VENT
  !
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZTWB_CANYON   ! Canyon air wet-bulb temperature [ K]
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZCAPTEMP      ! Total cooling capacity modifier curve function of temperature
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZTW_IN        ! Wet-bulb temperature of the air entering the coil [ K]
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZT_COND       ! Dry-bulb or wet-bulb air temperature entering the condenser [K]
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZEIRTEMP      ! Energy input ratio modifier curve function of temperature
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZPLR          ! Part load ratio
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZPARTLOADF    ! Part load fraction correlation
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZSHR          ! Actual coil sensible heat rate
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZH_ADP        ! Enthalpy of air at ADP conditions [J/kg]
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZH_OUT        ! Enthalpy of air leaving the cooling coil [J/kg]
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZH_IN         ! Enthalpy of air entering the cooling coil [J/kg]
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZMINCRIT
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZPSATCOOL
  REAL, DIMENSION(SIZE(PTI_BLD)) :: ZPSATHEAT
  REAL :: ZINFI
  REAL :: ZMECH
  !
  ! Performance curves coefficients
  REAL :: ZA1, ZB1, ZC1, ZD1, ZE1, ZF1
  REAL :: ZA3, ZB3, ZC3, ZD3, ZE3, ZF3
  REAL :: ZA5, ZB5, ZC5
  !
  !-------------------------------------------------------------------------------
  IF (LHOOK) CALL DR_HOOK('BEM',0,ZHOOK_HANDLE)
  !
  ! ###########################################################
  ! 1.   Initializations
  ! ###########################################################
  !
  ! Array dimensions
  !
  IROOF=SIZE(PT_ROOF,2)
  IWALL=SIZE(PT_WALL_A,2)
  !
  ZNAT_VENT (:) = 0.0
  !
  PH_WASTE_CANY  (:) = 0.0
  PLE_WASTE_CANY (:) = 0.0
  PH_WASTE_ROOF  (:) = 0.0
  PLE_WASTE_ROOF (:) = 0.0
  !
  ZUP_H_WASTE_CANY  (:) = 0.0
  ZUP_H_WASTE_ROOF  (:) = 0.0
  ZUP_LE_WASTE_CANY (:) = 0.0
  ZUP_LE_WASTE_ROOF (:) = 0.0
  !
  ! Robert: Calculation of infiltration rate as a function of
  !         building characteristics and meteorological conditions
  !
  CALL GET_INFILTRATION(PRHOA,PN50,PTI_BLD,PT_CANYON,PU_CANYON,PBLD_HEIGHT,PINFCALC)
  !
  ! Conversion AC/H -> [m3 s-1 m-2(bld)]
  !
  ZINF(:)=PINFCALC(:)*PBLD_HEIGHT(:)/3600
  !
  ! Robert:
  ! For the case where a permanent mechanical ventilation
  ! system is present, the ventilation due to this
  ! mechanical ventilation is added to the infiltration
  ! rate using the sum of squares. 
  ! CAUTION: this might not always be justified.
  !
  DO JJ=1,SIZE(PISMECH,1)
     IF (PISMECH(JJ).GT.0.5) THEN
        !
        ZMECH=PMECHRATE(JJ)*PBLD_HEIGHT(JJ)/3600.
        ZINFI=ZINF(JJ)
        !
        ZINF(JJ)=SQRT(ZMECH**2+ZINFI**2)
        PINFCALC(JJ)=3600.0*ZINF(JJ)/PBLD_HEIGHT(JJ)
        !
     ENDIF
  ENDDO
  !
  ! Option to fix the infiltration rate
  !
  ! ZINF(:)=0.0*PBLD_HEIGHT(:)/3600
  ! WRITE(1012,*) "CAUTION: infiltration hardcoded for test purpuses"
  !
  ! Conversion W/m²/floor -> W/m²(bld)
  !
  ZQIN(:)=PQIN(:)*PN_FLOOR(:)
  !
  ! Indoor air density
  !
  ! Robert: Use pressure from old time step in order to be consistant
  !         with temperature and humidity before update
  !
  ZRHOI(:)=PPSOLD(:)/(XRD*PTI_BLD(:)*(1.+((XRV/XRD)-1.)*PQI_BLD(:)))
  !
  !###########################################################
  ! 2.   heat balance for building floor and mass
  !###########################################################
  !
  ! 2.1 FLOOR HEAT BALANCE
  !
  CALL FLOOR_LAYER_E_BUDGET(HPROGRAM,PT_ALLBLD,PTSTEP,PHC_ALLBLD,PTC_ALLBLD,PD_ALLBLD, &
       PFLX_BLD_FLOOR,ZDQS_FLOOR,PF_FLOOR_MASS,PF_FLOOR_WALL,                      &
       PF_FLOOR_WIN,PF_FLOOR_ROOF,PRADHT_IN,PT_MASS(:,1),PRAD_WALL_FLOOR,          &
       PRAD_ROOF_FLOOR,PRAD_WIN_FLOOR,PLOAD_IN_FLOOR,PTI_BLD,                      &
       ZRAD_FLOOR_MASS, ZCONV_FLOOR_BLD,ZCHTC_IN_FLOOR,ZTS_FLOOR_CONV)
  !
  DO JLAYER=1,SIZE(PT_FLOOR,2)
     PT_FLOOR(:,JLAYER) = PT_ALLBLD(:,JLAYER)
  ENDDO
  !
  ! 2.2 MASS HEAT BALANCE
  !
  CALL MASS_LAYER_E_BUDGET(HPROGRAM,PT_MASS,PTSTEP,PHC_MASS,PTC_MASS,PD_MASS, &
       PFLX_BLD_MASS,ZDQS_MASS,PF_MASS_WALL,PF_MASS_WIN,PF_MASS_FLOOR,        &
       PRADHT_IN,PRAD_WALL_MASS,PRAD_ROOF_MASS,PRAD_WIN_MASS,PLOAD_IN_MASS,   &
       PTI_BLD,ZRAD_FLOOR_MASS,ZCONV_MASS_BLD)
  !
  ZAC_IN_WALL_A_COOL = CHTC_VERT_DOE(PT_WALL_A(:,IWALL), PTCOOL_TARGET)
  ZAC_IN_WALL_B_COOL = CHTC_VERT_DOE(PT_WALL_B(:,IWALL), PTCOOL_TARGET)
  ZAC_IN_WIN_COOL    = CHTC_VERT_DOE(PT_WIN2           , PTCOOL_TARGET)
  ZAC_IN_MASS_COOL   = CHTC_VERT_DOE(PT_MASS(:,1)      , PTCOOL_TARGET)
  ZAC_IN_ROOF_COOL   = CHTC_DOWN_DOE(PT_ROOF(:,IROOF)  , PTCOOL_TARGET)
  ZAC_IN_FLOOR_COOL  = CHTC_UP_DOE  (PT_FLOOR(:,1)     , PTCOOL_TARGET)
  !
  ZAC_IN_WALL_A_HEAT = CHTC_VERT_DOE(PT_WALL_A(:,IWALL), PTHEAT_TARGET)
  ZAC_IN_WALL_B_HEAT = CHTC_VERT_DOE(PT_WALL_B(:,IWALL), PTHEAT_TARGET)
  ZAC_IN_WIN_HEAT    = CHTC_VERT_DOE(PT_WIN2           , PTHEAT_TARGET)
  ZAC_IN_MASS_HEAT   = CHTC_VERT_DOE(PT_MASS(:,1)      , PTHEAT_TARGET)
  ZAC_IN_ROOF_HEAT   = CHTC_DOWN_DOE(PT_ROOF(:,IROOF)  , PTHEAT_TARGET)
  ZAC_IN_FLOOR_HEAT  = CHTC_UP_DOE  (PT_FLOOR(:,1)     , PTHEAT_TARGET)
  !
  ! Calculation of ventilation exchange rate before loop
  !
  CALL GET_NAT_VENT(PTI_BLD,PT_CANYON,PU_CANYON,PGLAZ_O_BLD,PSHADE,PSHGC_SH,ZNAT_VENT,PFOPEN)
  !
  !
  DO JJ=1,SIZE(PT_CANYON)
     !
     ! Impose lower limit for coefficients
     !
     ZAC_IN_WALL_A_COOL(JJ) = MAX(1.,ZAC_IN_WALL_A_COOL(JJ))
     ZAC_IN_WALL_B_COOL(JJ) = MAX(1.,ZAC_IN_WALL_B_COOL(JJ))
     ZAC_IN_WIN_COOL(JJ)    = MAX(1.,ZAC_IN_WIN_COOL(JJ))
     ZAC_IN_MASS_COOL(JJ)   = MAX(1.,ZAC_IN_MASS_COOL(JJ))
     ZAC_IN_ROOF_COOL(JJ)   = MAX(1.,ZAC_IN_ROOF_COOL(JJ))
     ZAC_IN_FLOOR_COOL(JJ)  = MAX(1.,ZAC_IN_FLOOR_COOL(JJ))
     !   
     ZAC_IN_WALL_A_HEAT(JJ) = MAX(1.,ZAC_IN_WALL_A_HEAT(JJ))
     ZAC_IN_WALL_B_HEAT(JJ) = MAX(1.,ZAC_IN_WALL_B_HEAT(JJ))
     ZAC_IN_WIN_HEAT(JJ)    = MAX(1.,ZAC_IN_WIN_HEAT(JJ))
     ZAC_IN_MASS_HEAT(JJ)   = MAX(1.,ZAC_IN_MASS_HEAT(JJ))
     ZAC_IN_ROOF_HEAT(JJ)   = MAX(1.,ZAC_IN_ROOF_HEAT(JJ))
     ZAC_IN_FLOOR_HEAT(JJ)  = MAX(1.,ZAC_IN_FLOOR_HEAT(JJ))
     !
     ! 4. Indoor energy balance calculation
     !
     ! Calculation of ventilation depending on choice of HNATVENT
     !
     IF (HNATVENT(JJ)=='NONE') THEN
        !
        ! No ventilation
        !
        PDIAGVENT(JJ)=0.0
        !
     ELSEIF (HNATVENT(JJ)=='AUTO') THEN
        !
        STOP("Implement constraints due to user needs")
        !
        ! Automatic opening of windows
        !
        ! Calculation of hypothetical air temperature 
        ! inside opened or closed buildings.
        !
        ZTI_BLD_CLOSED(JJ) = ( PTI_BLD(JJ)                   + &
             PTSTEP/(ZRHOI(JJ)*XCPD*PBLD_HEIGHT(JJ))         * &
             ( PWALL_O_BLD(JJ) * PCONV_WALL_BLD(JJ)          + &
             PGLAZ_O_BLD (JJ)* PCONV_WIN_BLD(JJ)             + &
             PMASS_O_BLD(JJ) * ZCONV_MASS_BLD(JJ)            + &
             PCONV_ROOF_BLD(JJ)                              + &
             ZCONV_FLOOR_BLD(JJ)                             + &
             ZQIN(JJ)*(1-PQIN_FRAD(JJ))*(1-PQIN_FLAT(JJ)) )  + &
             ZINF(JJ)*PTSTEP/PBLD_HEIGHT(JJ)*PT_CANYON(JJ) ) / &
             (1.0+ZINF(JJ)*PTSTEP/PBLD_HEIGHT(JJ))
        !
        ZTI_BLD_OPEN(JJ)   = ( PTI_BLD(JJ)                                  + &
             PTSTEP/(ZRHOI(JJ)*XCPD*PBLD_HEIGHT(JJ))                        * &
             ( PWALL_O_BLD(JJ) * PCONV_WALL_BLD(JJ)                           + &
             PGLAZ_O_BLD (JJ)* PCONV_WIN_BLD(JJ)                            + &
             PMASS_O_BLD(JJ) * ZCONV_MASS_BLD(JJ)                           + &
             PCONV_ROOF_BLD(JJ)                           + &
             ZCONV_FLOOR_BLD(JJ)                          + &
             ZQIN(JJ)*(1-PQIN_FRAD(JJ))*(1-PQIN_FLAT(JJ)) )                 + &
             (ZNAT_VENT(JJ)+ZINF(JJ))*PTSTEP/PBLD_HEIGHT(JJ)*PT_CANYON(JJ) )/ &
             (1.0+(ZNAT_VENT(JJ)+ZINF(JJ))*PTSTEP/PBLD_HEIGHT(JJ))
        !
        ! Robert: Ventilation is made if it permits to reduce the difference 
        !         to the ventilation design temperature and if neither heating 
        !         nor cooling would be required for the ventilated building
        !         The automatic ventilation is independend of the building 
        !         occupation and therefore effectuated in exactly the same
        !         for all building in a urban district (binary switch)
        !
        IF ( ( ABS(ZTI_BLD_OPEN(JJ) - PTDESV(JJ))     .LT.  &
             ABS(ZTI_BLD_CLOSED(JJ) - PTDESV(JJ)) )   .AND. &
             ( ZTI_BLD_OPEN(JJ) .LT. PTCOOL_TARGET(JJ) ) .AND. &
             ( ZTI_BLD_OPEN(JJ) .GT. PTHEAT_TARGET(JJ) ) ) THEN
           !
           PDIAGVENT(JJ)=1.0
           !
        ELSE
           PDIAGVENT(JJ)=0.0
        END IF
        !
        ! Manual ventilation
        !
     ELSEIF (HNATVENT(JJ)=='MANU') THEN
        !
        ZFRAC_VENT(JJ) = (1.0 / (1.0 + exp(-1.0*( PTI_BLD (JJ) - PTDESV  (JJ)-2.0)))) * &
                         (1.0 / (1.0 + exp(-1.0*( PTI_BLD (JJ) - PT_CANYON(JJ)   ))))
        !
        IF ( (ZFRAC_VENT(JJ).LT.-1.0E-10).OR.(ZFRAC_VENT(JJ).GT.(1.0+1.0E-10)) ) STOP("Wrong ventilation fraction")
        !
        PDIAGVENT(JJ) = PVENT_BEHAV_ANYWAY(JJ) + ZFRAC_VENT(JJ) * PVENT_BEHAV_ADAPTI(JJ)
        !
        ! Ventilation fractions below 0.2 are set to 0.0 since ventilation 
        ! is very non-linear and interpheres with heating
        !
        IF (PDIAGVENT(JJ).LT.0.2) PDIAGVENT(JJ)=0.0
        !
        IF ( (PDIAGVENT(JJ).LT.-1.0E-10).OR.(PDIAGVENT(JJ).GT.(1.0+1.0E-10)) ) STOP("Wrong ventilation fraction")
        !
     ELSE
        CALL ABOR1_SFX("This ventilation case is not implemented")
     ENDIF
     !
     ! Robert: Ventilation for air refreshment independ of indoor/outdoor conditions
     ! This shall consider that people open the windows after getting up,
     ! and/or when they arive home from work and/or before they go to bed, etc. 
     ! At the moment only for manual ventilation.
     ! However, one might consider that people open the window also
     ! for the cases of automatic and mechanical ventilation.
     ! If the house is not occupied the LFVSHO input variable needs to be
     ! set to .FALSE., since in that case the windows remain closed.
     !
     IF ((PFVSHO(JJ).GT.0.5).AND.(HNATVENT(JJ)=='MANU')) THEN
        !
        CALL ABOR1_SFX("Solution for short-term ventilation needs to be implemented")
        !
     ENDIF
     !
  ENDDO
  !
  !################################################################################
  ! Calculation of heating and cooling energy demand
  !################################################################################
  !
  ! Re-calculation of ventilation rate
  !
  CALL GET_NAT_VENT(PTI_BLD,PT_CANYON,PU_CANYON,PGLAZ_O_BLD,PSHADE,PSHGC_SH,ZNAT_VENT,PFOPEN)
  !
  ! In case of manual ventilation, the ventilation flow rate is multiplied
  ! by the fraction of windows that have been opened
  !
  DO JJ=1,SIZE(PDIAGVENT)
      IF (HNATVENT(JJ)=='MANU') ZNAT_VENT(JJ) = ZNAT_VENT(JJ) * PDIAGVENT(JJ)
  ENDDO
  !
  ! If natural or mechanical surventilation ACTIVE
  !
  DO JJ=1,SIZE(PDIAGVENT)
     IF (PDIAGVENT(JJ).GT.0.0) THEN
        !
        ! The following lines would need to be changed in case 
        ! the HVAC system is not switched off during ventilation.
        !
        PH_BLD_COOL (JJ) = 0.0
        PH_BLD_HEAT (JJ) = 0.0
        PLE_BLD_COOL(JJ) = 0.0
        PLE_BLD_HEAT(JJ) = 0.0
        !    
        PT_BLD_COOL (JJ) = 0.0
        PHVAC_COOL  (JJ) = 0.0
        PT_SYS      (JJ) = PTI_BLD(JJ)
        PQ_SYS      (JJ) = PQI_BLD(JJ)
        !
        PH_WASTE_CANY  (JJ) = 0.0
        PLE_WASTE_CANY (JJ) = 0.0
        PH_WASTE_ROOF  (JJ) = 0.0
        PLE_WASTE_ROOF (JJ) = 0.0
        !
        PHVAC_HEAT (JJ) = 0.0
        PM_SYS     (JJ) = 0.0
        PCOP       (JJ) = 0.0
        PCAP_SYS   (JJ) = 0.0
        !
     ENDIF
  ENDDO
  !
  ! *If natural surventilation INACTIVE
  !
  WHERE (PDIAGVENT(:).LE.0.0)
     !
     ZNAT_VENT(:) = 0.
     !
     ! ------------------------------------------------
     ! Building energy demand for heating and cooling
     ! CAUTION: ventilation = 0.0 assumed
     ! ------------------------------------------------
     !
     PH_BLD_COOL(:)                                                                              &
          = 0.5*PWALL_O_BLD(:)*(ZAC_IN_WALL_A_COOL(:)*(PT_WALL_A(:,IWALL)-PTCOOL_TARGET(:))   &
          +                      ZAC_IN_WALL_B_COOL(:)*(PT_WALL_B(:,IWALL)-PTCOOL_TARGET(:)) ) &
          +     PGLAZ_O_BLD(:)* ZAC_IN_WIN_COOL(:)   *(PT_WIN2(:)       - PTCOOL_TARGET(:))   &
          +     PMASS_O_BLD(:)* ZAC_IN_MASS_COOL(:)  *(PT_MASS(:,1)     - PTCOOL_TARGET(:))   &
          +                      ZAC_IN_ROOF_COOL(:)  *(PT_ROOF(:,IROOF) - PTCOOL_TARGET(:))   &
          +                      ZAC_IN_FLOOR_COOL(:) *(PT_FLOOR(:,1)    - PTCOOL_TARGET(:))   &
          + ZQIN(:)*(1.0-PQIN_FRAD(:))*(1.0-PQIN_FLAT(:))                                      &
          + ZINF(:)*XCPD*ZRHOI(:)*(PT_CANYON(:)-PTCOOL_TARGET(:))
     !
     PH_BLD_HEAT(:)                                                                                    &
          = - ( 0.5*PWALL_O_BLD(:) * (ZAC_IN_WALL_A_HEAT(:)*(PT_WALL_A(:,IWALL)-PTHEAT_TARGET(:))   &
          +                            ZAC_IN_WALL_B_HEAT(:)*(PT_WALL_B(:,IWALL)-PTHEAT_TARGET(:)) ) &
          +         PGLAZ_O_BLD(:) *  ZAC_IN_WIN_HEAT(:)   *(PT_WIN2(:)        -PTHEAT_TARGET(:))   &    
          +         PMASS_O_BLD(:) *  ZAC_IN_MASS_HEAT(:)  *(PT_MASS(:,1)      -PTHEAT_TARGET(:))   &
          +                            ZAC_IN_ROOF_HEAT(:)  *(PT_ROOF(:,IROOF)  -PTHEAT_TARGET(:))   &
          +                            ZAC_IN_FLOOR_HEAT(:) *(PT_FLOOR(:,1)     -PTHEAT_TARGET(:))   &
          + ZQIN(:)*(1.0-PQIN_FRAD(:))*(1.0-PQIN_FLAT(:))                                            &
          + ZINF(:)*XCPD*ZRHOI(:)*(PT_CANYON(:)-PTHEAT_TARGET(:)) )
     !
     ! The design specific humidity is calculated based on 
     ! the desing temperature and the design relative humidity
     !
     ZPSATCOOL(:) = PSAT(PTCOOL_TARGET(:))
     ZPSATHEAT(:) = PSAT(PTHEAT_TARGET(:))
     !
     ZQCOOL_TARGET(:) = 0.62198*PHR_TARGET(:)*ZPSATCOOL(:) / &
          (PPS(:)-PHR_TARGET(:)*ZPSATCOOL(:))
     !
     ZQHEAT_TARGET(:) = 0.62198*PHR_TARGET(:)*ZPSATHEAT(:) / &
          (PPS(:)-PHR_TARGET(:)*ZPSATHEAT(:))
     !
     ! The latent heat required to reach the target specific humidity is calculated
     !
     PLE_BLD_COOL(:) = ZQIN(:)*PQIN_FLAT(:)+ZINF(:)*XLVTT*(PQ_CANYON(:)-ZQCOOL_TARGET(:))
     !
     ! No target humidity for heating
     !
     PLE_BLD_HEAT(:) = 0.0
     !
     ! PLE_BLD_HEAT(:)=ZQIN(:)*PQIN_FLAT(:)+ZINF(:)*ZRHOI(:)*XLVTT*(PQ_CANYON(:)-ZQHEAT_TARGET(:))
     !
  ENDWHERE
  !
  ! Autosize calculations
  !
  IF (OAUTOSIZE.AND.(KDAY.EQ.15)) THEN
     !
     DO JJ=1,SIZE(PH_BLD_COOL)
        !
        IF (PH_BLD_COOL(JJ) .GT. PAUX_MAX(JJ))  THEN
           !
           PAUX_MAX    (JJ) = PH_BLD_COOL(JJ)
           !
           ! Cooling coil sensible heat rate 
           !
           ZSHR(JJ) = MIN(XCPD*(PTCOOL_TARGET(JJ)-PT_ADP(JJ))/        &
                (ENTH_FN_T_Q(PTCOOL_TARGET(JJ),ZQCOOL_TARGET(JJ)) -  &
                ENTH_FN_T_Q(PT_ADP(JJ),QSAT(PT_ADP(JJ),PPS(JJ)))), 1.)
           !
           ! Cooling Coil Capacity [W m-2(bld)]
           !
           PCAP_SYS_RAT(JJ)=PH_BLD_COOL(JJ)/ZSHR(JJ) 
           !
           ! Cooling rated air flow rate [kg s-1 m-2(bld)]
           !
           ZM_SYS_RAT(JJ)=PH_BLD_COOL(JJ)/XCPD/(PTCOOL_TARGET(JJ)-(14.0+273.16))
           IF (ZM_SYS_RAT(JJ).GT.PM_SYS_RAT(JJ)) PM_SYS_RAT(JJ)=ZM_SYS_RAT(JJ)
           !
           ! Robert: Removed below
           ! Impose condition 
           !
           ! IF (PM_SYS_RAT(JJ)/ZRHOI(JJ)/PCAP_SYS_RAT(JJ) < 0.00004027) THEN
           !   PCAP_SYS_RAT(JJ) = PM_SYS_RAT(JJ)/ZRHOI(JJ)/0.00004027
           ! ELSE IF (PM_SYS_RAT(JJ)/ZRHOI(JJ)/PCAP_SYS_RAT(JJ) > 0.00006041) THEN
           !   PCAP_SYS_RAT(JJ) = PM_SYS_RAT(JJ)/ZRHOI(JJ)/0.00006041
           ! END IF
           !
        END IF
        !
        ! Impose a minimum and maximum value of the cooling system capacity
        !
        PCAP_SYS_RAT(JJ) = MAX(PCAP_SYS_RAT(JJ),(PM_SYS_RAT(JJ)/ZRHOI(JJ)/0.00004027))
        PCAP_SYS_RAT(JJ) = MIN(PCAP_SYS_RAT(JJ),(PM_SYS_RAT(JJ)/ZRHOI(JJ)/0.00006041))
        !
     ENDDO
     !
  END IF
  !
  ! End of autosize calculations
  !
  ! Calculation of system efficiency
  !
  PM_SYS  (:) = PM_SYS_RAT  (:)
  PCOP    (:) = PCOP_RAT    (:)
  PCAP_SYS(:) = PCAP_SYS_RAT(:)
  !
  ! Calculation of mixing conditions
  ! Robert: At the moment the mixing conditions are equal
  !         to the indoor conditions since there is no 
  !         cooling/heating when there is ventilation.
  !
  ZXMIX (:) = 0.0*ZRHOI(:)/PM_SYS(:)
  ZT_MIX(:) = ZXMIX(:)*PT_CANYON(:)+(1.-ZXMIX(:))*PTI_BLD(:)
  ZQ_MIX(:) = ZXMIX(:)*PQ_CANYON(:)+(1.-ZXMIX(:))*PQI_BLD(:)
  !
  ! ###########################################
  ! Calculations related to cooling
  ! Only for grid points with cooling required
  ! ###########################################
  !
  ! Calculation of cooling system performance and waste heat
  !
  IF (HCOOL_COIL=='IDEAL') THEN
     !
     DO JJ=1,SIZE(PH_BLD_COOL)
        IF (PH_BLD_COOL(JJ).GT.0.0) THEN
           !
           ! Ideal system
           !
           ! desactivation of LE_BLD_COOL impact on HVAC_COOL calculation
           ! following too much impact in VURCA simulation (23/01/2012)
           ! this would be the case for a vaporization system !
           ! PT_BLD_COOL(JJ)=PH_BLD_COOL(JJ)+PLE_BLD_COOL(JJ)
           ! PHVAC_COOL (JJ) = PT_BLD_COOL(JJ) / PCOP_RAT(JJ)
           !
           PHVAC_COOL(JJ)=PH_BLD_COOL(JJ)/PCOP_RAT(JJ)
           !
           PHVAC_COOL(JJ) = MAX(PHVAC_COOL(JJ),0.0)
           !
           PT_SYS(JJ)=ZT_MIX(JJ)-PH_BLD_COOL(JJ)/PM_SYS(JJ)/XCPD
           !
           !PQ_SYS(JJ) = ZQ_MIX(JJ) - PLE_BLD_COOL(JJ) / PM_SYS(JJ)/ XLVTT
           !desactivation following too much impact in VURCA simulation
           !(23/01/2012)
           !
           PQ_SYS(JJ) = ZQ_MIX(JJ)
           !
           ! On part of the waste heat from climatisation is ejected into
           ! the canyon, the other part at the roof.
           !
           PH_WASTE_CANY (JJ) = PF_WASTE_CAN(JJ)*(PHVAC_COOL(JJ)*(1.+PCOP_RAT(JJ))*(1.-PF_WATER_COND(JJ)))
           PLE_WASTE_CANY(JJ) = PF_WASTE_CAN(JJ)*(PHVAC_COOL(JJ)*(1.+PCOP_RAT(JJ))*PF_WATER_COND(JJ))
           !
           PH_WASTE_ROOF (JJ) = (1.0-PF_WASTE_CAN(JJ))*(PHVAC_COOL(JJ)*(1.+PCOP_RAT(JJ))*(1.-PF_WATER_COND(JJ)))
           PLE_WASTE_ROOF(JJ) = (1.0-PF_WASTE_CAN(JJ))*(PHVAC_COOL(JJ)*(1.+PCOP_RAT(JJ))*PF_WATER_COND(JJ))
           !
        ENDIF
     ENDDO
     !
  ELSEIF (HCOOL_COIL=='DXCOIL') THEN
     !
     DO JJ=1,SIZE(PH_BLD_COOL)
        IF (PH_BLD_COOL(JJ).GT.0.0) THEN
           !
           CALL DX_AIR_COOLING_COIL_CV(PT_CANYON(JJ), PQ_CANYON(JJ), PPS(JJ),      &
                ZRHOI(JJ), ZT_MIX(JJ), ZQ_MIX(JJ), PCOP_RAT(JJ), PF_WASTE_CAN(JJ), &
                PCAP_SYS_RAT(JJ), PT_ADP(JJ), PF_WATER_COND(JJ),                   &
                PM_SYS(JJ), PH_BLD_COOL(JJ), PH_WASTE_CANY(JJ),PLE_WASTE_CANY(JJ), &
                PH_WASTE_ROOF(JJ),PLE_WASTE_ROOF(JJ), PCOP(JJ), PCAP_SYS(JJ),      &
                PT_SYS(JJ),PQ_SYS(JJ),PHVAC_COOL(JJ),PT_BLD_COOL(JJ)               )
           !
        ENDIF
     ENDDO
     !
  ELSE
     print*,HCOOL_COIL
     CALL ABOR1_SFX("This type of cooling system is not implemented")
  ENDIF
  !
  ! Cooling system without atmospheric releases.
  ! e.g. releases in soil/water F_WATER_COND < 0 
  ! NOTE: In this case the energy leaving the system would need to
  !       be considered.
  !
  DO JJ=1,SIZE(PH_BLD_COOL)
     IF (PH_BLD_COOL(JJ).GT.0.0) THEN
        IF(PF_WATER_COND(JJ).LT.0.0) THEN
           PH_WASTE_CANY(JJ)  = 0.
           PLE_WASTE_CANY(JJ) = 0.
           PH_WASTE_ROOF(JJ)  = 0.
           PLE_WASTE_ROOF(JJ) = 0.
        ELSE
           !
           ! From EP Engineering Reference (p. 647)
           !
           ! PFAN_POWER(JJ)=PM_SYS(JJ)*PFAN_AP(JJ)*PFAN_EFF(JJ)*ZRHOI(JJ)
           !
           PH_BLD_HEAT (JJ) = 0.0
           PLE_BLD_HEAT(JJ) = 0.0
           PHVAC_HEAT  (JJ) = 0.0
           !
        ENDIF
     ENDIF
  ENDDO
  !
  ! ---------------------------------------------
  ! * HEATING system : Performance and Waste heat
  ! ---------------------------------------------
  !
  IF (MAXVAL(PH_BLD_HEAT).GT.0.0) THEN
     !
     ! If the heating system is not idal, the delivered 
     ! heating is limited to the capacity of the system
     !
     IF (HHEAT_COIL .NE. 'IDEAL') THEN
        DO JJ=1,SIZE(PH_BLD_HEAT)
           PH_BLD_HEAT(JJ)=MIN(PH_BLD_HEAT(JJ),PCAP_SYS_HEAT(JJ))
        ENDDO
     ENDIF
     !
     WHERE (PH_BLD_HEAT(:).GT.0.0)
        !
        PT_SYS(:) = ZT_MIX(:) + PH_BLD_HEAT(:)/PM_SYS(:)/XCPD
        PQ_SYS(:) = ZQ_MIX(:)
        !
        ! The heating energy demand is equal to the 
        ! building energy demand divided by the efficiency
        !
        ! For CONVENTIONAL heating systems, the heating energy
        ! demand is HIGHER than the building energy demand
        ! since the efficiency is lower than 1.0.
        ! For HEAT PUMPS, the heating energy demand
        ! is LOWER than the building energy demand since
        ! the efficiency is larger than 1.0.
        !
        PHVAC_HEAT(:)=PH_BLD_HEAT(:)/PEFF_HEAT(:)
        !
        ! The waste heat is the difference between the
        ! heating energy demand and the building energy demand.
        ! For EFF_HEAT < 1.0 the waste heat is positive (e.g. waste heat of furnace)
        ! For EFF_HEAT > 1.0 the waste heat is negative since
        !                    the heat is taken from the outside air (air heat pumps)
        !
        ! CAUTION: for a soil heat pump, this equation needs to be
        ! changed since the heat source is no longer the outdoor
        ! air, but the deep soil or a water reservoir.
        !
        PH_WASTE_ROOF(:)=PHVAC_HEAT(:)-PH_BLD_HEAT(:)
        !
        ! Here it is assumed that there is not latent waste.
        ! This might not be true when there is fuel combustion
        ! for heating.
        !
        PLE_WASTE_ROOF (:)=0.0
        !
        ! No cooling
        ! 
        PH_BLD_COOL (:)=0.0
        PLE_BLD_COOL(:)=0.0
        PT_BLD_COOL (:)=0.0
        PHVAC_COOL  (:)=0.0
        !
        ! From EP Engineering Reference (p. 647)
        !
        ! PFAN_POWER(:)=PM_SYS(:)*PFAN_AP(:)*(PFAN_EFF(:)*ZRHOI(:))
        !
     END WHERE
     !
  ENDIF
  !
  ! ------------------------------
  ! * NEITHER COOLING NOR HEATING
  ! ------------------------------
  !
  WHERE ( (PH_BLD_HEAT(:).LE.0.0).AND.(PH_BLD_COOL(:).LE.0.0) )
     !
     PH_BLD_COOL (:) = 0.0
     PH_BLD_HEAT (:) = 0.0
     PLE_BLD_COOL(:) = 0.0
     PLE_BLD_HEAT(:) = 0.0
     PT_BLD_COOL (:) = 0.0 
     PHVAC_COOL  (:) = 0.0
     PHVAC_HEAT  (:) = 0.0
     !
     PT_SYS      (:) = ZT_MIX(:)
     PQ_SYS      (:) = ZQ_MIX(:)
     PM_SYS      (:) = 0.0
     !
     PH_WASTE_CANY  (:) = 0.0
     PLE_WASTE_CANY (:) = 0.0
     PH_WASTE_ROOF  (:) = 0.0
     PLE_WASTE_ROOF (:) = 0.0
     !
  ENDWHERE
  !
  !
  !---------------------------------------------------------------------------------
  ! ENERGY DEMAND COMPUTED
  !################################################################################
  !
  ! EVOLUTION OF THE INTERNAL TEMPERATURE AND HUMIDITY
  !
  ! Waste fluxes to canyon with respect to the old canyon temperature
  !
  ZWASTE(:) = ZINF(:) + ZNAT_VENT(:)
  !
  ! Save indoor temperature and virtual temperature before update
  !
  ZTV_BLD_OLD(:)=PTI_BLD(:)*(1.+((XRV/XRD)-1.)*PQI_BLD(:))
  ZTI_BLD_OLD(:)=PTI_BLD(:)
  !
  ZRHOI_OLD(:)=ZRHOI(:)
  !
  ! Calculate the total sensible and latent heat stored in
  ! the indoor air before update [J/m²(urb)]
  !
  ZTHEAIRIN_OLD(:) = XCPD *PBLD(:)*PBLD_HEIGHT(:)*ZRHOI_OLD(:)*PTI_BLD(:)
  ZLATAIRIN_OLD(:) = XLVTT*PBLD(:)*PBLD_HEIGHT(:)*ZRHOI_OLD(:)*PQI_BLD(:)
  !
  ! Update of indoor temperature
  !
  PTI_BLD(:) = ( PTI_BLD(:)                            + &
       PTSTEP/(ZRHOI(:)*XCPD*PBLD_HEIGHT(:))           * &
       ( PWALL_O_BLD(:) * PCONV_WALL_BLD(:)            + &
       PGLAZ_O_BLD(:) * PCONV_WIN_BLD(:)               + &
       PMASS_O_BLD(:) * ZCONV_MASS_BLD(:)              + &
       PCONV_ROOF_BLD(:)                                + &
       ZCONV_FLOOR_BLD(:)                               + &
       ZQIN(:)*(1.0-PQIN_FRAD(:))*(1.0-PQIN_FLAT(:)) )+ &
       PTSTEP/PBLD_HEIGHT(:)    *                         &
       ((ZINF(:)+ZNAT_VENT(:)) * PT_CANYON(:) +   &
       PM_SYS(:)/ZRHOI(:)      * (PT_SYS   (:)) ) )  /  &
       (1. + PTSTEP/PBLD_HEIGHT(:)                      * &
       (ZINF(:) + ZNAT_VENT(:) + PM_SYS(:)/ZRHOI(:)) )
  !
  ! Update of indoor humidity
  !
  PQI_BLD(:) = ( PQI_BLD(:) +  PTSTEP/PBLD_HEIGHT(:) * &
       (  ZQIN(:)*PQIN_FLAT(:)/(ZRHOI(:)*XLVTT)        &
       + (ZINF(:)+ZNAT_VENT(:))*PQ_CANYON(:) &
       +  PM_SYS(:)/ZRHOI(:)   *(PQ_SYS   (:)) )    )  &
       / ( 1. + PTSTEP/PBLD_HEIGHT(:)*                   &
       (ZINF(:) + ZNAT_VENT(:) + PM_SYS(:)/ZRHOI(:)) )
  !
  ! Robert: Include diagnostic of ventilation exchange rate [1/h]
  !
  PDIAGVEFL(:)=3600.*ZNAT_VENT(:)/PBLD_HEIGHT(:)
  !
  ! Indoor air density at new time step
  !
  PRHOI_NEW(:)=PPS(:)/(XRD*PTI_BLD(:)*(1.+((XRV/XRD)-1.)*PQI_BLD(:)))
  !
  ! Calculate the total sensible and latent heat stored in
  ! the indoor air after update [J/m²(urb)]
  !
  ZTHEAIRIN_NEW(:) = XCPD *PBLD(:)*PBLD_HEIGHT(:)*PRHOI_NEW(:)*PTI_BLD(:)
  ZLATAIRIN_NEW(:) = XLVTT*PBLD(:)*PBLD_HEIGHT(:)*PRHOI_NEW(:)*PQI_BLD(:)
  !
  ! Robert: Recalculation of heating and cooling demand after update
  !
  IF (MAXVAL(PH_BLD_HEAT).GT.0.0) THEN
     !
     WHERE (PH_BLD_HEAT(:).GT.0.0)
        !
        ZUP_HVAC_HEAT(:)    = XCPD*PM_SYS(:)*(PT_SYS(:)-PTI_BLD(:))/PEFF_HEAT(:)
        ZUP_H_WASTE_ROOF(:) = ZUP_HVAC_HEAT(:)-XCPD*PM_SYS(:)*(PT_SYS(:)-PTI_BLD(:))
        PH_WASTE_ROOF(:)    = ZUP_H_WASTE_ROOF(:)
        PH_WASTE_ROOF(:)    = PH_WASTE_ROOF(:) - (ZUP_HVAC_HEAT(:) - PHVAC_HEAT(:) )
        PLE_WASTE_ROOF(:)   = PLE_WASTE_ROOF(:)-XLVTT*PM_SYS(:)*(PQ_SYS(:)-PQI_BLD(:))
        !
     END WHERE
     !
  ENDIF
  !
  IF (MAXVAL(PH_BLD_COOL).GT.0.0) THEN
     !
     WHERE (PH_BLD_COOL(:).GT.0.0)
        !
        ZUP_HVAC_COOL(:) = XCPD*PM_SYS(:)*(PTI_BLD(:)-PT_SYS(:))/PCOP(:)
        !
        ! Sensible heat
        !
        ZUP_H_WASTE_CANY  (:) = PF_WASTE_CAN(:)*(ZUP_HVAC_COOL(:)*(1.+PCOP(:))*(1.-PF_WATER_COND(:)))
        PH_WASTE_CANY(:)=ZUP_H_WASTE_CANY(:)
        PH_WASTE_CANY(:)=PH_WASTE_CANY(:) - PF_WASTE_CAN(:)*(ZUP_HVAC_COOL(:)-PHVAC_COOL(:))
        !
        ZUP_H_WASTE_ROOF  (:) = (1.0-PF_WASTE_CAN(:))*(ZUP_HVAC_COOL(:)*(1.+PCOP(:))*(1.-PF_WATER_COND(:)))
        PH_WASTE_ROOF(:)=ZUP_H_WASTE_ROOF(:)
        PH_WASTE_ROOF(:)=PH_WASTE_ROOF(:) - (1.0-PF_WASTE_CAN(:))*(ZUP_HVAC_COOL(:)-PHVAC_COOL(:))
        !
        ! Latent heat
        !
        ZUP_LE_WASTE_CANY (:) = PF_WASTE_CAN(:)*(ZUP_HVAC_COOL(:)*(1.+PCOP(:))*    PF_WATER_COND(:))
        PLE_WASTE_CANY(:)=ZUP_LE_WASTE_CANY(:)
        PLE_WASTE_CANY(:)=PLE_WASTE_CANY(:) - PF_WASTE_CAN(:)*(XLVTT*PM_SYS(:)*(PQ_SYS(:)-PQI_BLD(:)))
        !
        ZUP_LE_WASTE_ROOF (:) = (1.0-PF_WASTE_CAN(:))*(ZUP_HVAC_COOL(:)*(1.+PCOP(:))*    PF_WATER_COND(:))
        PLE_WASTE_ROOF(:)=ZUP_LE_WASTE_ROOF(:)
        PLE_WASTE_ROOF(:)=PLE_WASTE_ROOF(:) - (1.0-PF_WASTE_CAN(:))*(XLVTT*PM_SYS(:)*(PQ_SYS(:)-PQI_BLD(:)))
        !
     END WHERE
     !
  ENDIF
  !
  ! Virtual temperature after update
  !
  ZTV_BLD_NEW(:)=PTI_BLD(:)*(1.+((XRV/XRD)-1.)*PQI_BLD(:))
  !
  ! --------------------------------------------------------------------
  ! Robert: Diagnostics of sensible and latent heat budget of indoor air
  ! --------------------------------------------------------------------
  !
  ! Sensible heat convective source terms (W/m²(urb))
  !
  ZSRCCONVWALL(:) = PBLD(:) * PWALL_O_BLD    (:) * PCONV_WALL_BLD(:)
  ZSRCCONVGLAZ(:) = PBLD(:) * PGLAZ_O_BLD    (:) * PCONV_WIN_BLD (:)
  ZSRCCONVMASS(:) = PBLD(:) * PMASS_O_BLD    (:) * ZCONV_MASS_BLD(:)
  ZSRCCONVROOF(:) = PBLD(:) * PCONV_ROOF_BLD (:)
  ZSRCCONVFLOO(:) = PBLD(:) * ZCONV_FLOOR_BLD(:)
  !
  ! Internal load of sensible and latent heat (W/m²(urb))
  !
  ZSRCQINSENHE(:)=PBLD(:)*ZQIN(:)*(1.0-PQIN_FRAD(:))*(1.0-PQIN_FLAT(:))
  ZSRCQINLATHE(:)=PBLD(:)*ZQIN(:)*PQIN_FLAT(:)
  !
  ! Sensible and latent heat due to infiltration/ventilation (W/m²(urb))
  !
  ZSRCSENINFVE(:)=XCPD *PBLD(:)*(ZINF(:)+ZNAT_VENT(:))*ZRHOI_OLD(:)*(PT_CANYON(:)-PTI_BLD(:))
  ZSRCLATINFVE(:)=XLVTT*PBLD(:)*(ZINF(:)+ZNAT_VENT(:))*ZRHOI_OLD(:)*(PQ_CANYON(:)-PQI_BLD(:))
  !
  ! Sensible and latent heat due to heating and climatisation (W/m²(urb))
  !
  ZSRCSENHHVAC(:)=XCPD *PBLD(:)*PM_SYS(:)*(PT_SYS(:)-PTI_BLD(:))
  ZSRCLATHHVAC(:)=XLVTT*PBLD(:)*PM_SYS(:)*(PQ_SYS(:)-PQI_BLD(:))
  !
  ! Difference of sensible and latent heat reservoir (W/m²(urb))
  !
  ZDIFFSENAIRIN(:) = (ZTHEAIRIN_NEW(:)-ZTHEAIRIN_OLD(:))/PTSTEP
  ZDIFFLATAIRIN(:) = (ZLATAIRIN_NEW(:)-ZLATAIRIN_OLD(:))/PTSTEP
  !
  ! ---------------------------------------------------------
  ! ---------------------------------------------------------
  !
  ! Robert: When the indoor temperature increases (decreases), the volume
  ! of the air expands (contracts). Since the volume of the 
  ! building is fixed, there is thus air leaving/entering the building. 
  ! This needs to be taken into account in order to preserve
  ! the sensible heat as well as humidity/latent heat
  !
  ! Calculation of the indoor air mass difference 
  ! between actual and previous time step (kg/m²(bld))
  !
  ZDIFFAIRMASS(:)=PBLD_HEIGHT(:)*(PRHOI_NEW(:)-ZRHOI_OLD(:))
  !
  ! Calculation of the sensible and latent heat per time unit 
  ! contained in the air mass difference (W/m²(urb))
  !
  ZDIFFAIRSEN(:)=XCPD  * PBLD(:)*ZDIFFAIRMASS(:)*PTI_BLD(:)/PTSTEP
  ZDIFFAIRLAT(:)=XLVTT * PBLD(:)*ZDIFFAIRMASS(:)*PQI_BLD(:)/PTSTEP
  !
  ! Sensible and latent heat budget of indoor air. 
  !
  ZIMB_SENH_BLD(:) = ZSRCCONVWALL(:) + ZSRCCONVGLAZ(:)     + &
       ZSRCCONVMASS(:) + ZSRCCONVROOF(:) + ZSRCCONVFLOO(:) + &
       ZSRCQINSENHE(:) + ZSRCSENINFVE(:) + ZSRCSENHHVAC(:) + &
       ZDIFFAIRSEN (:) - ZDIFFSENAIRIN(:)
  !
  ZIMB_LATH_BLD(:) = ZSRCQINLATHE(:) + ZSRCLATINFVE(:) + &
       ZSRCLATHHVAC(:) + ZDIFFAIRLAT(:)- ZDIFFLATAIRIN(:)
  !
  ! Check sensible heat budget of indoor air
  !
  IF (MAXVAL(ZIMB_SENH_BLD).GT.1.0E-6) THEN
     !
     CALL GET_LUOUT(HPROGRAM,ILUOUT)
     !
     DO JJ=1,SIZE(ZIMB_SENH_BLD)
        !
        IF (ZIMB_SENH_BLD(JJ).GT.0.0) THEN
           !
           WRITE(ILUOUT,*) "                                        "
           WRITE(ILUOUT,*) "The sensible heat balance of indoor air "
           WRITE(ILUOUT,*) "                                        "
           WRITE(ILUOUT,*) "JJ                : ",JJ
           WRITE(ILUOUT,*) "ZSRCCONVWALL(JJ)  : ",ZSRCCONVWALL(JJ)
           WRITE(ILUOUT,*) "ZSRCCONVGLAZ(JJ)  : ",ZSRCCONVGLAZ(JJ)
           WRITE(ILUOUT,*) "ZSRCCONVMASS(JJ)  : ",ZSRCCONVMASS(JJ)
           WRITE(ILUOUT,*) "ZSRCCONVROOF(JJ)  : ",ZSRCCONVROOF(JJ)
           WRITE(ILUOUT,*) "ZSRCCONVFLOO(JJ)  : ",ZSRCCONVFLOO(JJ)
           WRITE(ILUOUT,*) "ZSRCQINSENHE(JJ)  : ",ZSRCQINSENHE(JJ)
           WRITE(ILUOUT,*) "ZSRCSENINFVE(JJ)  : ",ZSRCSENINFVE(JJ)
           WRITE(ILUOUT,*) "ZSRCSENHHVAC(JJ)  : ",ZSRCSENHHVAC(JJ)
           WRITE(ILUOUT,*) "ZDIFFAIRSEN (JJ)  : ",ZDIFFAIRSEN (JJ)
           WRITE(ILUOUT,*) "------------------  "
           WRITE(ILUOUT,*) "ZIMB_SENH_BLD(JJ) : ",ZIMB_SENH_BLD(JJ)
           WRITE(ILUOUT,*) "ZDIFFSENAIRIN(JJ) : ",ZDIFFSENAIRIN(JJ)
           CALL FLUSH(ILUOUT)
           !
        ENDIF
        !
     ENDDO
     !
     CALL ABOR1_SFX("Too large imbalance of indoor sensible heat budget")
     !
  END IF
  !
  ! Check latent heat budget of indoor air
  !
  IF (MAXVAL(ZIMB_LATH_BLD).GT.1.0E-6 ) THEN
     CALL GET_LUOUT(HPROGRAM,ILUOUT)
     DO JJ=1,SIZE(ZIMB_LATH_BLD)
        !
        IF (ZIMB_LATH_BLD(JJ).GT.0.0) THEN
           !
           WRITE(ILUOUT,*) "                                      "
           WRITE(ILUOUT,*) "The latent heat balance of indoor air "
           WRITE(ILUOUT,*) "                                      "
           WRITE(ILUOUT,*) "ZSRCQINLATHE(JJ)  : ",ZSRCQINLATHE(JJ)
           WRITE(ILUOUT,*) "ZSRCLATINFVE(JJ)  : ",ZSRCLATINFVE(JJ)
           WRITE(ILUOUT,*) "ZSRCLATHHVAC(JJ)  : ",ZSRCLATHHVAC(JJ)
           WRITE(ILUOUT,*) "ZDIFFAIRLAT (JJ)  : ",ZDIFFAIRLAT (JJ)
           WRITE(ILUOUT,*) "--------------  "
           WRITE(ILUOUT,*) "ZIMB_LATH_BLD(JJ) : ",ZIMB_LATH_BLD(JJ)
           WRITE(ILUOUT,*) "ZDIFFLATAIRIN(JJ) : ",ZDIFFLATAIRIN(JJ)
           CALL FLUSH(ILUOUT)
           !
        ENDIF
        !
     ENDDO
     CALL ABOR1_SFX("Too large imbalance of indoor latent heat budget")
  ENDIF
  !
  ! Robert:
  ! In order to avoid numerical instabilities when diagnosing
  ! T_CANYON and Q_CANYON, the waste fluxes to the canyon are splitted
  ! into a part not depending directly on PT_CANYON (PQ_CANYON)
  ! and the part directly depending on PT_CANYON (PQ_CANYON).
  ! In avg_urban_fluxes, the equations will be written in an implicit
  ! manner for the part depeding on PTI_BLD - PT_CANYON
  !
  ! Constant part
  !
  PCST_H_WASTE_CANY (:) = PBLD(:) * PH_WASTE_CANY (:)
  PCST_LE_WASTE_CANY(:) = PBLD(:) * PLE_WASTE_CANY(:)
  !
  ! Coefficients for implicitation
  !
  PCOEFF_H_WASTE_CANY (:) = PBLD(:) * XCPD  * ZWASTE(:) * ZRHOI_OLD(:)
  PCOEFF_LE_WASTE_CANY(:) = PBLD(:) * XLVTT * ZWASTE(:) * ZRHOI_OLD(:)
  !
  ! Original formulation of waste fluxes to be used for all diagnostics,
  ! except for T_CANYON and Q_CANYON
  !
  PH_WASTE_CANY (:) = PBLD(:) * PH_WASTE_CANY (:) + PBLD(:) * XCPD  * ZWASTE(:) * ZRHOI_OLD(:) * (PTI_BLD(:) - PT_CANYON(:))
  PLE_WASTE_CANY(:) = PBLD(:) * PLE_WASTE_CANY(:) + PBLD(:) * XLVTT * ZWASTE(:) * ZRHOI_OLD(:) * (PQI_BLD(:) - PQ_CANYON(:))
  !
  ! Robert: The sensible and latent heat contained in the air mass
  !         entering or leaving the building due to expansion/contraction
  !         is added to the sensible and latent waste heat flux
  !
  PH_WASTE_ROOF (:) = PBLD(:) * PH_WASTE_ROOF (:) - ZDIFFAIRSEN(:)
  PLE_WASTE_ROOF(:) = PBLD(:) * PLE_WASTE_ROOF(:) - ZDIFFAIRLAT(:)
  !
  IF (LHOOK) CALL DR_HOOK('BEM',1,ZHOOK_HANDLE)
  !
CONTAINS
  !
  SUBROUTINE GET_NAT_VENT(PPTI_BLD,PPT_CANYON,PPU_CANYON,PPGLAZ_O_BLD, &
       PSHADE,PSHGC_SH,PNAT_VENT,PFOPEN)
    !
    IMPLICIT NONE
    !
    REAL, DIMENSION(:) , INTENT(IN)  :: PPTI_BLD
    REAL, DIMENSION(:) , INTENT(IN)  :: PPT_CANYON
    REAL, DIMENSION(:) , INTENT(IN)  :: PPU_CANYON
    REAL, DIMENSION(:) , INTENT(IN)  :: PPGLAZ_O_BLD
    REAL, DIMENSION(:) , INTENT(IN)  :: PSHGC_SH
    REAL, DIMENSION(:) , INTENT(IN)  :: PFOPEN
    REAL, DIMENSION(:) , INTENT(IN)  :: PSHADE
    REAL, DIMENSION(:) , INTENT(OUT) :: PNAT_VENT
    REAL(KIND=JPRB)   :: ZHOOK_HANDLE
    !
    ! Local variables
    !
    REAL :: ZHWIN,ZCT,ZCW,ZCST,ZALPHA,ZFAC
    REAL, DIMENSION(SIZE(PPTI_BLD)) :: ZMODVENT
    !
    IF (LHOOK) CALL DR_HOOK('BEM:GET_NAT_VENT',0,ZHOOK_HANDLE)
    !
    ! Robert: Ventilation flow rate through single sided windows
    ! taken from the European directive prEN 15242.
    ! "Ventilation for buildings — Calculation methods for the
    !  determination of air flow rates in buildings including infiltration"
    !
    ! The exchanges due to turbulence, wind force and buouyancy are considered
    !
    ZCT    = 0.01   ! Coefficient for exchange due to turbulence
    ZCW    = 0.001  ! Coefficient for exchange due to wind force
    ZCST   = 0.0035 ! Coefficient for exchange due to buouyancy
    ZALPHA = 180.0  ! Window opening angle (0° for closed, 180° for fully open)
    ZHWIN  = 1.5    ! Height of the window (m)
    !
    ! Empirical factor for dependency of air-flow on window opening angle
    !
    ZFAC = 2.60E-7*ZALPHA**3-1.19E-4*ZALPHA**2+1.86E-2*ZALPHA
    !
    ! Natural ventilation flow rate [m^3/m^2(bld)/s] (single sided ventilation)
    !
    PNAT_VENT(:)=ZFAC*0.5*PPGLAZ_O_BLD(:)*SQRT(ZCT+ZCW*PPU_CANYON(:)**2+ZCST*ZHWIN*ABS(PPTI_BLD(:)-PPT_CANYON(:)))
    !
    ! In the case of shading, the natural ventilation is influenced by
    ! the shading elements. However, the degree of modification is highly
    ! dependent on the building and window geometry, the type of shades, 
    ! the meteorological conditions and so on. A general formula
    ! is not available. For this reason, an ad-hoc modification of the 
    ! natural ventilation is made here based on the transmissivity of the
    ! shading elements.
    !
    ! No modification of the natural ventilation flow rate is made
    ! for shades with relatively high transmissivity.
    ! Indeed, the shades can even enhance ventilation.
    ! For shades with very low transmissivity it is assumed
    ! that only one-tenth of the natural ventilation takes place
    !
    DO JJ=1,SIZE(PSHGC_SH)
       IF (PSHGC_SH(JJ).GT.0.5) THEN
          ZMODVENT(JJ)=1.0
       ELSE
          ZMODVENT(JJ)=2*PSHGC_SH(JJ)
          ZMODVENT(JJ)=MAX(ZMODVENT(JJ),0.1)
       ENDIF
    ENDDO
    !
    ! The modulation factor is applied according
    ! to the fraction of closed blinds
    !
    PNAT_VENT(:)=PSHADE(:)*(ZMODVENT(:)*PNAT_VENT(:))+(1.0-PSHADE(:))*PNAT_VENT(:)
    !
    ! Multiplication of the ventilation flow rate
    ! by the fraction of windows opened
    !
    PNAT_VENT(:)=PNAT_VENT(:)*PFOPEN(:)
    !
    IF (LHOOK) CALL DR_HOOK('BEM:GET_NAT_VENT',1,ZHOOK_HANDLE)
    !
  END SUBROUTINE GET_NAT_VENT
  !
  SUBROUTINE GET_INFILTRATION(PRHOA,PPN50,PPTI_BLD,PPT_CANYON,PPU_CANYON,PPBLD_HEIGHT,PINFCALC)
    !
    USE MODD_CSTS, ONLY : XG,XRV,XRD
    !
    ! Robert: Calculation of the air exchange rate due to infiltration [1/h]
    ! as a funtion of the simulated canyon wind speed and the simulated 
    ! outdoor and indoor temperatures.
    ! The equations are similar to the Alberta Air Infiltration Model 
    ! (e.g. Wang et al. 2009, Building and Environment).
    !
    IMPLICIT NONE
    !
    REAL, INTENT(IN), DIMENSION(:) :: PRHOA
    REAL, INTENT(IN), DIMENSION(:) :: PPN50
    REAL, INTENT(IN), DIMENSION(:) :: PPTI_BLD
    REAL, INTENT(IN), DIMENSION(:) :: PPT_CANYON
    REAL, INTENT(IN), DIMENSION(:) :: PPU_CANYON
    REAL, INTENT(IN), DIMENSION(:) :: PPBLD_HEIGHT
    !
    REAL, INTENT(OUT), DIMENSION(:) :: PINFCALC
    !
    REAL(KIND=JPRB) :: ZHOOK_HANDLE
    !
    ! Local variables
    !
    REAL :: ZFLOW
    REAL :: ZBETA
    REAL :: ZR
    REAL :: ZX
    REAL :: ZY
    REAL :: ZHF
    REAL :: ZZF
    REAL :: ZM
    REAL :: ZXC
    REAL :: ZF
    REAL :: ZJ
    !
    REAL, DIMENSION(SIZE(PPTI_BLD)) :: ZCAIRTIGHT
    REAL, DIMENSION(SIZE(PPTI_BLD)) :: ZRHOOUT
    REAL, DIMENSION(SIZE(PPTI_BLD)) :: ZFSTACK
    REAL, DIMENSION(SIZE(PPTI_BLD)) :: ZFWIND
    REAL, DIMENSION(SIZE(PPTI_BLD)) :: ZQSTACK
    REAL, DIMENSION(SIZE(PPTI_BLD)) :: ZQWIND
    REAL, DIMENSION(SIZE(PPTI_BLD)) :: ZQTOTAL
    !
    IF (LHOOK) CALL DR_HOOK('BEM:GET_INFILTRATION',0,ZHOOK_HANDLE)
    !
    ZFLOW = 2./3. ! Flow exponent (1.0 = lam.; 0.5 = turb.; 2/3 for typical infil. flow)
    ZBETA = -0.33 ! Empirical constant
    ZR    = 0.0   ! All leakage concentrated in the walls
    ZX    = 0.0   ! No sealing-floor difference since all leakage in walls
    ZY    = 0.2   ! Typical value for flue fraction (Walker and Wilson, 1998)
    ZZF   = 1.5   ! Typical value for normalised flue height (Walker and Wilson, 1998)
    !
    ! Stack factor based on Walker and Wilson (1998)
    !
    ZM=MIN(1.0,(ZX+(2*ZFLOW+1)*ZY)**2/(2.0-ZR))
    !
    ZXC=ZR+2.0*(1.0-ZR-ZY)/(ZFLOW+1.0)-2.0*ZY*(ZZF-1.0)**ZFLOW
    !
    ZF=ZFLOW*ZY*(ZZF-1)**(ZFLOW-1./3.)*(1.0-(3*(ZXC-ZX)**2*(ZR)**(1.0-ZFLOW))/(2*(ZZF+1)))
    !
    ZFSTACK=((1+ZFLOW*ZR)/(ZFLOW+1))*(0.5-0.5*(ZM)**(5./4.))**(ZFLOW+1)+ZF
    !
    ! Infiltration factor based on Walker and Wilson (1998), no crawl space
    !
    ZJ=0.5*(ZX+ZR+2*ZY)
    !
    ZFWIND=0.19*(2.0-ZFLOW)*(1.0-(0.5*(ZX+ZR))**(1.5-ZY))-0.25*ZY*(ZJ-2.0*ZY*(ZJ)**4)
    !
    ! Conversion of PPN50 [1/h] to CAIRTIGHT [1/h]
    !
    ZCAIRTIGHT(:)=PPN50(:)/(50)**ZFLOW
    !
    ! The infiltration rate due to the stack effect
    !
    ZQSTACK(:)=ZCAIRTIGHT(:)*ZFSTACK*(PRHOA(:)*XG*PPBLD_HEIGHT(:)*(ABS(PPTI_BLD(:)-PPT_CANYON(:))/PPTI_BLD(:)))**ZFLOW
    !
    ! The infiltration rate due to the wind effect
    ! A shelter factor of 1.0 is assumed since the canyon wind speed is used.
    !
    ZQWIND(:)=ZCAIRTIGHT(:)*ZFWIND*(PRHOA(:)*0.5*(PPU_CANYON(:))**2)**ZFLOW
    !
    ! Total infiltration rate in 1/h
    !
    PINFCALC(:)=((ZQSTACK(:))**(1.0/ZFLOW)+(ZQWIND(:))**(1.0/ZFLOW)+ZBETA*(ZQSTACK(:)*ZQWIND(:))**(1.0/(2.0*ZFLOW)))**ZFLOW
    !
    IF (LHOOK) CALL DR_HOOK('BEM:GET_INFILTRATION',1,ZHOOK_HANDLE)
    !
  END SUBROUTINE GET_INFILTRATION
  !
END SUBROUTINE BEM
