!     #########
      SUBROUTINE WRITESURF_PGD_TEB_PAR_n (BDD, DTB, DTGD, DTGR, DTT, DGU, U, TGDO, TGDP, TGRO, TIR, TOP, &
                                          HPROGRAM)
!     ################################################
!
!!****  *WRITESURF_PGD_TEB_PAR_n* - reads ISBA physiographic fields
!!                        
!!
!!    PURPOSE
!!    -------
!!
!!**  METHOD
!!    ------
!!
!!    EXTERNAL
!!    --------
!!
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!
!!    AUTHOR
!!    ------
!!      V. Masson   *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    05/2005
!!       V. Masson  08/2013 add solar panels
!-------------------------------------------------------------------------------
!
!*       0.    DECLARATIONS
!              ------------
!
!
!
!

!
!
USE MODD_BLD_DESCRIPTION_n, ONLY : BLD_DESC_t
USE MODD_DATA_BEM_n, ONLY : DATA_BEM_t
USE MODD_DATA_TEB_GARDEN_n, ONLY : DATA_TEB_GARDEN_t
USE MODD_DATA_TEB_GREENROOF_n, ONLY : DATA_TEB_GREENROOF_t
USE MODD_DATA_TEB_n, ONLY : DATA_TEB_t
USE MODD_DIAG_SURF_ATM_n, ONLY : DIAG_SURF_ATM_t
USE MODD_SURF_ATM_n, ONLY : SURF_ATM_t
USE MODD_TEB_GARDEN_OPTION_n, ONLY : TEB_GARDEN_OPTIONS_t
USE MODD_TEB_GARDEN_PGD_n, ONLY : TEB_GARDEN_PGD_t
USE MODD_TEB_GREENROOF_OPTION_n, ONLY : TEB_GREENROOF_OPTIONS_t
USE MODD_TEB_IRRIG_n, ONLY : TEB_IRRIG_t
USE MODD_TEB_OPTION_n, ONLY : TEB_OPTIONS_t
!
USE MODI_WRITE_SURF
USE MODI_WRITE_BLD_DESCRIPTION_n
USE MODI_WRITESURF_PGD_TEB_IRRIG_n
!
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*       0.1   Declarations of arguments
!              -------------------------
!
!
TYPE(BLD_DESC_t), INTENT(INOUT) :: BDD
TYPE(DATA_BEM_t), INTENT(INOUT) :: DTB
TYPE(DATA_TEB_GARDEN_t), INTENT(INOUT) :: DTGD
TYPE(DATA_TEB_GREENROOF_t), INTENT(INOUT) :: DTGR
TYPE(DATA_TEB_t), INTENT(INOUT) :: DTT
TYPE(DIAG_SURF_ATM_t), INTENT(INOUT) :: DGU
TYPE(SURF_ATM_t), INTENT(INOUT) :: U
TYPE(TEB_GARDEN_OPTIONS_t), INTENT(INOUT) :: TGDO
TYPE(TEB_GARDEN_PGD_t), INTENT(INOUT) :: TGDP
TYPE(TEB_GREENROOF_OPTIONS_t), INTENT(INOUT) :: TGRO
TYPE(TEB_IRRIG_t), INTENT(INOUT) :: TIR
TYPE(TEB_OPTIONS_t), INTENT(INOUT) :: TOP
!
 CHARACTER(LEN=6),  INTENT(IN)  :: HPROGRAM ! program calling
!
!*       0.2   Declarations of local variables
!              -------------------------------
!
INTEGER           :: IRESP          ! IRESP  : return-code if a problem appears
 CHARACTER(LEN=12) :: YRECFM         ! Name of the article to be read
 CHARACTER(LEN=100):: YCOMMENT       ! Comment string
INTEGER           :: JLAYER         ! loop index
INTEGER           :: JTIME          ! loop index
REAL, DIMENSION(:), ALLOCATABLE :: ZWORK
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!-------------------------------------------------------------------------------
!
IF (LHOOK) CALL DR_HOOK('WRITESURF_PGD_TEB_PAR_N',0,ZHOOK_HANDLE)
YRECFM='L_BLDTYPE'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%LDATA_BLDTYPE,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_BLDTYPE) THEN
  YRECFM='D_BLDTYPE'
  YCOMMENT='X_Y_'//YRECFM//' (m)'
  ALLOCATE(ZWORK(SIZE(DTT%NPAR_BLDTYPE)))
  ZWORK=FLOAT(DTT%NPAR_BLDTYPE(:))
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,ZWORK,IRESP,YCOMMENT)
  DEALLOCATE(ZWORK)
ENDIF
!
YRECFM='L_BLD_AGE'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%LDATA_BLD_AGE,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_BLD_AGE) THEN
  YRECFM='D_BLD_AGE'
  YCOMMENT='X_Y_'//YRECFM//' (m)'
  ALLOCATE(ZWORK(SIZE(DTT%NPAR_BLD_AGE)))
  ZWORK=FLOAT(DTT%NPAR_BLD_AGE(:))
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,ZWORK,IRESP,YCOMMENT)
  DEALLOCATE(ZWORK)
ENDIF
!
YRECFM='L_USETYPE'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%LDATA_USETYPE,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_USETYPE) THEN
  YRECFM='D_USETYPE'
  YCOMMENT='X_Y_'//YRECFM//' (m)'
  ALLOCATE(ZWORK(SIZE(DTT%NPAR_USETYPE)))
  ZWORK=FLOAT(DTT%NPAR_USETYPE(:))
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,ZWORK,IRESP,YCOMMENT)
  DEALLOCATE(ZWORK)
ENDIF
!
IF (DTT%LDATA_BLDTYPE .OR. DTT%LDATA_BLD_AGE .OR. DTT%LDATA_USETYPE) CALL WRITE_BLD_DESCRIPTION_n(DGU, U, &
                                                                                                  BDD, &
                                                                                                  HPROGRAM)
!
YRECFM='L_Z0_TOWN'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%LDATA_Z0_TOWN,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_Z0_TOWN) THEN
  YRECFM='D_Z0_TOWN'
  YCOMMENT='X_Y_'//YRECFM//' (m)'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%XPAR_Z0_TOWN,IRESP,YCOMMENT)
ENDIF
!
YRECFM='L_BLD'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%LDATA_BLD,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_BLD) THEN
  YRECFM='D_BLD'
  YCOMMENT='X_Y_'//YRECFM//' (-)'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%XPAR_BLD,IRESP,YCOMMENT)
ENDIF
!
YRECFM='L_GARDEN'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%LDATA_GARDEN,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_GARDEN) THEN
  YRECFM='D_GARDEN'
  YCOMMENT='X_Y_'//YRECFM//' (-)'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%XPAR_GARDEN,IRESP,YCOMMENT)
ENDIF
!
YRECFM='L_GREENROOF'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%LDATA_GREENROOF,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_GREENROOF) THEN
  YRECFM='D_GREENROOF'
  YCOMMENT='X_Y_'//YRECFM//' (-)'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%XPAR_GREENROOF,IRESP,YCOMMENT)
ENDIF
!
YRECFM='L_ROAD_DIR'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%LDATA_ROAD_DIR,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_ROAD_DIR) THEN
  YRECFM='D_ROAD_DIR'
  YCOMMENT='X_Y_'//YRECFM//' (-)'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%XPAR_ROAD_DIR,IRESP,YCOMMENT)
ENDIF
!
YRECFM='L_ALB_ROOF'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%LDATA_ALB_ROOF,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_ALB_ROOF) THEN
  YRECFM='D_ALB_ROOF'
  YCOMMENT='X_Y_'//YRECFM//' (-)'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%XPAR_ALB_ROOF,IRESP,YCOMMENT)
ENDIF
!
YRECFM='L_EMIS_ROOF'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%LDATA_EMIS_ROOF,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_EMIS_ROOF) THEN
  YRECFM='D_EMI_ROOF'
  YCOMMENT='X_Y_'//YRECFM//' (-)'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%XPAR_EMIS_ROOF,IRESP,YCOMMENT)
ENDIF
!
IF (DTT%LDATA_HC_ROOF) THEN
  YCOMMENT='Number of specified Roof thermal layers'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,'PAR_RF_LAYER',DTT%NPAR_ROOF_LAYER,IRESP,YCOMMENT)
END IF
!
YRECFM='L_HC_ROOF'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%LDATA_HC_ROOF,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_HC_ROOF) THEN
  DO JLAYER=1,DTT%NPAR_ROOF_LAYER
    WRITE(YRECFM,FMT='(A9,I1.1)') 'D_HC_ROOF',JLAYER
    YCOMMENT='X_Y_'//YRECFM//' (J/K/m3)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%XPAR_HC_ROOF(:,JLAYER),IRESP,YCOMMENT)
  END DO
ENDIF
!
YRECFM='L_TC_ROOF'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%LDATA_TC_ROOF,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_TC_ROOF) THEN
  DO JLAYER=1,DTT%NPAR_ROOF_LAYER
    WRITE(YRECFM,FMT='(A9,I1.1)') 'D_TC_ROOF',JLAYER
    YCOMMENT='X_Y_'//YRECFM//' (W/K/m)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%XPAR_TC_ROOF(:,JLAYER),IRESP,YCOMMENT)
  END DO
ENDIF
!
YRECFM='L_D_ROOF'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%LDATA_D_ROOF,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_D_ROOF) THEN
  DO JLAYER=1,DTT%NPAR_ROOF_LAYER
    WRITE(YRECFM,FMT='(A8,I1.1)') 'D_D_ROOF',JLAYER
    YCOMMENT='X_Y_'//YRECFM//' (m)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%XPAR_D_ROOF(:,JLAYER),IRESP,YCOMMENT)
  END DO
ENDIF
!
YRECFM='L_ALB_ROAD'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%LDATA_ALB_ROAD,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_ALB_ROAD) THEN
  YRECFM='D_ALB_ROAD'
  YCOMMENT='X_Y_'//YRECFM//' (-)'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%XPAR_ALB_ROAD,IRESP,YCOMMENT)
ENDIF
!
YRECFM='L_EMIS_ROAD'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%LDATA_EMIS_ROAD,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_EMIS_ROAD) THEN
  YRECFM='D_EMI_ROAD'
  YCOMMENT='X_Y_'//YRECFM//' (-)'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%XPAR_EMIS_ROAD,IRESP,YCOMMENT)
ENDIF
!
IF (DTT%LDATA_HC_ROAD) THEN
  YCOMMENT='Number of specified Road thermal layers'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,'PAR_RD_LAYER',DTT%NPAR_ROAD_LAYER,IRESP,YCOMMENT)
END IF
!
YRECFM='L_HC_ROAD'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%LDATA_HC_ROAD,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_HC_ROAD) THEN
  DO JLAYER=1,DTT%NPAR_ROAD_LAYER
    WRITE(YRECFM,FMT='(A9,I1.1)') 'D_HC_ROAD',JLAYER
    YCOMMENT='X_Y_'//YRECFM//' (J/K/m3)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%XPAR_HC_ROAD(:,JLAYER),IRESP,YCOMMENT)
  END DO
ENDIF
!
YRECFM='L_TC_ROAD'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%LDATA_TC_ROAD,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_TC_ROAD) THEN
  DO JLAYER=1,DTT%NPAR_ROAD_LAYER
    WRITE(YRECFM,FMT='(A9,I1.1)') 'D_TC_ROAD',JLAYER
    YCOMMENT='X_Y_'//YRECFM//' (W/K/m)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%XPAR_TC_ROAD(:,JLAYER),IRESP,YCOMMENT)
  END DO
ENDIF
!
YRECFM='L_D_ROAD'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%LDATA_D_ROAD,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_D_ROAD) THEN
  DO JLAYER=1,DTT%NPAR_ROAD_LAYER
    WRITE(YRECFM,FMT='(A8,I1.1)') 'D_D_ROAD',JLAYER
    YCOMMENT='X_Y_'//YRECFM//' (m)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%XPAR_D_ROAD(:,JLAYER),IRESP,YCOMMENT)
  END DO
ENDIF
!
YRECFM='L_ALB_WALL'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%LDATA_ALB_WALL,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_ALB_WALL) THEN
  YRECFM='D_ALB_WALL'
  YCOMMENT='X_Y_'//YRECFM//' (-)'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%XPAR_ALB_WALL,IRESP,YCOMMENT)
ENDIF
!
YRECFM='L_EMIS_WALL'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%LDATA_EMIS_WALL,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_EMIS_WALL) THEN
  YRECFM='D_EMI_WALL'
  YCOMMENT='X_Y_'//YRECFM//' (-)'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%XPAR_EMIS_WALL,IRESP,YCOMMENT)
ENDIF
!
!
IF (DTT%LDATA_HC_WALL) THEN
  YCOMMENT='Number of specified Wall thermal layers'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,'PAR_WL_LAYER',DTT%NPAR_WALL_LAYER,IRESP,YCOMMENT)
END IF
!
YRECFM='L_HC_WALL'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%LDATA_HC_WALL,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_HC_WALL) THEN
  DO JLAYER=1,DTT%NPAR_WALL_LAYER
    WRITE(YRECFM,FMT='(A9,I1.1)') 'D_HC_WALL',JLAYER
    YCOMMENT='X_Y_'//YRECFM//' (J/K/m3)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%XPAR_HC_WALL(:,JLAYER),IRESP,YCOMMENT)
  END DO
ENDIF
!
YRECFM='L_TC_WALL'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%LDATA_TC_WALL,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_TC_WALL) THEN
  DO JLAYER=1,DTT%NPAR_WALL_LAYER
    WRITE(YRECFM,FMT='(A9,I1.1)') 'D_TC_WALL',JLAYER
    YCOMMENT='X_Y_'//YRECFM//' (W/K/m)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%XPAR_TC_WALL(:,JLAYER),IRESP,YCOMMENT)
  END DO
ENDIF
!
YRECFM='L_D_WALL'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%LDATA_D_WALL,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_D_WALL) THEN
  DO JLAYER=1,DTT%NPAR_WALL_LAYER
    WRITE(YRECFM,FMT='(A8,I1.1)') 'D_D_WALL',JLAYER
    YCOMMENT='X_Y_'//YRECFM//' (m)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%XPAR_D_WALL(:,JLAYER),IRESP,YCOMMENT)
  END DO
ENDIF
!
YRECFM='L_BLD_HEIGHT'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%LDATA_BLD_HEIGHT,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_BLD_HEIGHT) THEN
  YRECFM='D_BLD_HEIG'
  YCOMMENT='X_Y_'//YRECFM//' (m)'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%XPAR_BLD_HEIGHT,IRESP,YCOMMENT)
ENDIF
!
YRECFM='L_WALL_O_HOR'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%LDATA_WALL_O_HOR,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_WALL_O_HOR) THEN
  YRECFM='D_WALL_O_H'
  YCOMMENT='X_Y_'//YRECFM//' (-)'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%XPAR_WALL_O_HOR,IRESP,YCOMMENT)
ENDIF
!
YRECFM='L_H_TRAF'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%LDATA_H_TRAFFIC,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_H_TRAFFIC) THEN
  YRECFM='D_H_TRAF'
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%XPAR_H_TRAFFIC,IRESP,YCOMMENT)
ENDIF
!
YRECFM='L_LE_TRAF'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%LDATA_LE_TRAFFIC,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_LE_TRAFFIC) THEN
  YRECFM='D_LE_TRAF'
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%XPAR_LE_TRAFFIC,IRESP,YCOMMENT)
ENDIF
!
YRECFM='L_H_IND'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%LDATA_H_INDUSTRY,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_H_INDUSTRY) THEN
  YRECFM='D_H_IND'
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%XPAR_H_INDUSTRY,IRESP,YCOMMENT)
ENDIF
!
YRECFM='L_LE_IND'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%LDATA_LE_INDUSTRY,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_LE_INDUSTRY) THEN
  YRECFM='D_LE_IND'
  YCOMMENT='X_Y_'//YRECFM//' (W/m2)'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%XPAR_LE_INDUSTRY,IRESP,YCOMMENT)
ENDIF
!
YRECFM='L_ROUGH_ROOF'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%LDATA_ROUGH_ROOF,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_ROUGH_ROOF) THEN
  YRECFM='D_ROUGH_ROOF'
  YCOMMENT='X_Y_'//YRECFM//' (-)'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%XPAR_ROUGH_ROOF,IRESP,YCOMMENT)
ENDIF
!
YRECFM='L_ROUGH_WALL'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%LDATA_ROUGH_WALL,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_ROUGH_WALL) THEN
  YRECFM='D_ROUGH_WALL'
  YCOMMENT='X_Y_'//YRECFM//' (-)'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%XPAR_ROUGH_WALL,IRESP,YCOMMENT)
ENDIF!
!
YRECFM='L_F_RESIDENT'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%LDATA_RESIDENTIAL,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_RESIDENTIAL) THEN
  YRECFM='D_F_RESIDENT'
  YCOMMENT='X_Y_'//YRECFM//' (-)'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%XPAR_RESIDENTIAL,IRESP,YCOMMENT)
ENDIF
!
!* solar panels
!
YRECFM='L_EMIS_PANEL'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%LDATA_EMIS_PANEL,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_EMIS_PANEL) THEN
  YRECFM='D_EMIS_PANEL'
  YCOMMENT='X_Y_'//YRECFM//' (-)'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%XPAR_EMIS_PANEL,IRESP,YCOMMENT)
ENDIF
!
YRECFM='L_ALB_PANEL'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%LDATA_ALB_PANEL,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_ALB_PANEL) THEN
  YRECFM='D_ALB_PANEL'
  YCOMMENT='X_Y_'//YRECFM//' (-)'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%XPAR_ALB_PANEL,IRESP,YCOMMENT)
ENDIF
!
YRECFM='L_EFF_PANEL'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%LDATA_EFF_PANEL,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_EFF_PANEL) THEN
  YRECFM='D_EFF_PANEL'
  YCOMMENT='X_Y_'//YRECFM//' (-)'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%XPAR_EFF_PANEL,IRESP,YCOMMENT)
ENDIF
!
YRECFM='L_FRAC_PANEL'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%LDATA_FRAC_PANEL,IRESP,HCOMMENT=YCOMMENT)
IF (DTT%LDATA_FRAC_PANEL) THEN
  YRECFM='D_FRAC_PANEL'
  YCOMMENT='X_Y_'//YRECFM//' (-)'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTT%XPAR_FRAC_PANEL,IRESP,YCOMMENT)
ENDIF
!
!* Building Energy Model
!
IF (TOP%CBEM .EQ. 'BEM') THEN
  !
  IF (DTB%LDATA_HC_FLOOR) THEN
    YCOMMENT='Number of specified Floor thermal layers'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,'PAR_FL_LAYER',DTB%NPAR_FLOOR_LAYER,IRESP,YCOMMENT)
  END IF
  !
  YRECFM='L_HC_FLOOR'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%LDATA_HC_FLOOR,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_HC_FLOOR) THEN
    DO JLAYER=1,DTB%NPAR_FLOOR_LAYER
      WRITE(YRECFM,FMT='(A10,I1.1)') 'D_HC_FLOOR',JLAYER
      YCOMMENT='X_Y_'//YRECFM//' (J/K/m3)'
      CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%XPAR_HC_FLOOR(:,JLAYER),IRESP,YCOMMENT)
    END DO
  ENDIF
  !
  YRECFM='L_TC_FLOOR'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%LDATA_TC_FLOOR,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_TC_FLOOR) THEN
    DO JLAYER=1,DTB%NPAR_FLOOR_LAYER
      WRITE(YRECFM,FMT='(A10,I1.1)') 'D_TC_FLOOR',JLAYER
      YCOMMENT='X_Y_'//YRECFM//' (W/K/m)'
      CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%XPAR_TC_FLOOR(:,JLAYER),IRESP,YCOMMENT)
    END DO
  ENDIF
  !
  YRECFM='L_D_FLOOR'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%LDATA_D_FLOOR,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_D_FLOOR) THEN
    DO JLAYER=1,DTB%NPAR_FLOOR_LAYER
      WRITE(YRECFM,FMT='(A9,I1.1)') 'D_D_FLOOR',JLAYER
      YCOMMENT='X_Y_'//YRECFM//' (m)'
      CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%XPAR_D_FLOOR(:,JLAYER),IRESP,YCOMMENT)
    END DO
  ENDIF
  !
  YRECFM='L_TCOOL_TARG'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%LDATA_TCOOL_TARGET,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_TCOOL_TARGET) THEN
    YRECFM='D_TCOOL_TARG'
    YCOMMENT='X_Y_'//YRECFM//' (K)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%XPAR_TCOOL_TARGET,IRESP,YCOMMENT)
  ENDIF
  !
  YRECFM='L_THEAT_TARG'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%LDATA_THEAT_TARGET,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_THEAT_TARGET) THEN
    YRECFM='D_THEAT_TARG'
    YCOMMENT='X_Y_'//YRECFM//' (K)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%XPAR_THEAT_TARGET,IRESP,YCOMMENT)
  ENDIF
  !
  YRECFM='L_F_WAST_CAN'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%LDATA_F_WASTE_CAN,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_F_WASTE_CAN) THEN
    YRECFM='D_F_WAST_CAN'
    YCOMMENT='X_Y_'//YRECFM//' (-)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%XPAR_F_WASTE_CAN,IRESP,YCOMMENT)
  ENDIF
  !
  YRECFM='L_EFF_HEAT'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%LDATA_EFF_HEAT,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_EFF_HEAT) THEN
    YRECFM='D_EFF_HEAT'
    YCOMMENT='X_Y_'//YRECFM//' (-)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%XPAR_EFF_HEAT,IRESP,YCOMMENT)
  ENDIF
  !
  YRECFM='L_QIN'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%LDATA_QIN,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_QIN) THEN
    YRECFM='D_QIN'
    YCOMMENT='X_Y_'//YRECFM//' (K)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%XPAR_QIN,IRESP,YCOMMENT)
  ENDIF
  !
  YRECFM='L_QIN_FRAD'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%LDATA_QIN_FRAD,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_QIN_FRAD) THEN
    YRECFM='D_QIN_FRAD'
    YCOMMENT='X_Y_'//YRECFM//' (K)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%XPAR_QIN_FRAD,IRESP,YCOMMENT)
  ENDIF
  !
  YRECFM='L_SHGC'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%LDATA_SHGC,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_SHGC) THEN
    YRECFM='D_SHGC'
    YCOMMENT='X_Y_'//YRECFM//' (-)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%XPAR_SHGC,IRESP,YCOMMENT)
  ENDIF
  !
  YRECFM='L_U_WIN'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%LDATA_U_WIN,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_U_WIN) THEN
    YRECFM='D_U_WIN'
    YCOMMENT='X_Y_'//YRECFM//' (W m-2 K-1)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%XPAR_U_WIN,IRESP,YCOMMENT)
  ENDIF
  !
  YRECFM='L_GR'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%LDATA_GR,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_GR) THEN
    YRECFM='D_GR'
    YCOMMENT='X_Y_'//YRECFM//' (-)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%XPAR_GR,IRESP,YCOMMENT)
  ENDIF
  !
  YRECFM='L_SHGC_SH'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%LDATA_SHGC_SH,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_SHGC_SH) THEN
    YRECFM='D_SHGC_SH'
    YCOMMENT='X_Y_'//YRECFM//' (-)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%XPAR_SHGC_SH,IRESP,YCOMMENT)
  ENDIF  
  !
  YRECFM='L_FLOOR_HEIG'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%LDATA_FLOOR_HEIGHT,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_FLOOR_HEIGHT) THEN
    YRECFM='D_FLOOR_HEIG'
    YCOMMENT='X_Y_'//YRECFM//' (m)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%XPAR_FLOOR_HEIGHT,IRESP,YCOMMENT)
  ENDIF
  !
  YRECFM='L_INF'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%LDATA_INF,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_INF) THEN
    YRECFM='D_INF'
    YCOMMENT='X_Y_'//YRECFM//' (ACH)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%XPAR_INF,IRESP,YCOMMENT)
  ENDIF
  !
  YRECFM='L_QIN_FLAT'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%LDATA_QIN_FLAT,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_QIN_FLAT) THEN
    YRECFM='D_QIN_FLAT'
    YCOMMENT='X_Y_'//YRECFM//' (-)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%XPAR_QIN_FLAT,IRESP,YCOMMENT)
  ENDIF
  !
  YRECFM='L_HR_TARGET'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%LDATA_HR_TARGET,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_HR_TARGET) THEN
    YRECFM='D_HR_TARGET'
    YCOMMENT='X_Y_'//YRECFM//' (-)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%XPAR_HR_TARGET,IRESP,YCOMMENT)
  ENDIF
  !
  YRECFM='L_V_VENT'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%LDATA_V_VENT,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_V_VENT) THEN
    YRECFM='D_V_VENT'
    YCOMMENT='X_Y_'//YRECFM//' (ACH)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%XPAR_V_VENT,IRESP,YCOMMENT)
  ENDIF
  !
  YRECFM='L_CAP_SYS_HE'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%LDATA_CAP_SYS_HEAT,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_CAP_SYS_HEAT) THEN
    YRECFM='D_CAP_SYS_HE'
    YCOMMENT='X_Y_'//YRECFM//' (W m-2)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%XPAR_CAP_SYS_HEAT,IRESP,YCOMMENT)
  ENDIF
  !
  YRECFM='L_CAP_SYS_RA'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%LDATA_CAP_SYS_RAT,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_CAP_SYS_RAT) THEN
    YRECFM='D_CAP_SYS_RA'
    YCOMMENT='X_Y_'//YRECFM//' (W m-2)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%XPAR_CAP_SYS_RAT,IRESP,YCOMMENT)
  ENDIF
  !
  YRECFM='L_T_ADP'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%LDATA_T_ADP,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_T_ADP) THEN
    YRECFM='D_T_ADP'
    YCOMMENT='X_Y_'//YRECFM//' (K)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%XPAR_T_ADP,IRESP,YCOMMENT)
  ENDIF
  !
  YRECFM='L_M_SYS_RAT'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%LDATA_M_SYS_RAT,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_M_SYS_RAT) THEN
    YRECFM='D_M_SYS_RAT'
    YCOMMENT='X_Y_'//YRECFM//' (kg s-1 m-)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%XPAR_M_SYS_RAT,IRESP,YCOMMENT)
  ENDIF
  !
  YRECFM='L_COP_RAT'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%LDATA_COP_RAT,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_COP_RAT) THEN
    YRECFM='D_COP_RAT'
    YCOMMENT='X_Y_'//YRECFM//' (-)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%XPAR_COP_RAT,IRESP,YCOMMENT)
  ENDIF
  !
  YRECFM='L_T_SIZE_MAX'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%LDATA_T_SIZE_MAX,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_T_SIZE_MAX) THEN
    YRECFM='D_T_SIZE_MAX'
    YCOMMENT='X_Y_'//YRECFM//' (K)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%XPAR_T_SIZE_MAX,IRESP,YCOMMENT)
  ENDIF
  !
  YRECFM='L_T_SIZE_MIN'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%LDATA_T_SIZE_MIN,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_T_SIZE_MIN) THEN
    YRECFM='D_T_SIZE_MIN'
    YCOMMENT='X_Y_'//YRECFM//' (K)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%XPAR_T_SIZE_MIN,IRESP,YCOMMENT)
  ENDIF
  !
  YRECFM='L_FWAT_COND'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%LDATA_F_WATER_COND,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_F_WATER_COND) THEN
    YRECFM='D_FWAT_COND'
    YCOMMENT='X_Y_'//YRECFM//' (-)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%XPAR_F_WATER_COND,IRESP,YCOMMENT)
  ENDIF
  !
  YRECFM='L_SHADE'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%LDATA_SHADE,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_SHADE) THEN
    YRECFM='D_SHADE'
    YCOMMENT='X_Y_'//YRECFM//' (-)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%XPAR_SHADE,IRESP,YCOMMENT)
  ENDIF
  !
  YRECFM='L_NATVENT'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%LDATA_NATVENT,IRESP,HCOMMENT=YCOMMENT)
  IF (DTB%LDATA_NATVENT) THEN
    YRECFM='D_NATVENT'
    YCOMMENT='X_Y_'//YRECFM//' (-)'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTB%XPAR_NATVENT,IRESP,YCOMMENT)
  ENDIF
  !  
ENDIF
!
! Flag for data for gardens
YRECFM='PAR_GARDEN'
YCOMMENT='FLAG FOR SPECIFIED GARDEN PARAMETERS'
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,TGDO%LPAR_GARDEN,IRESP,HCOMMENT=YCOMMENT)
!
IF (TOP%LGARDEN .AND. TGDO%LPAR_GARDEN) THEN
!
  YRECFM='GD_NTIME'
  YCOMMENT=YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTGD%NTIME,IRESP,HCOMMENT=YCOMMENT)
!
! Type of high vegetation
  YRECFM='D_TYPE_HVEG'
  YCOMMENT='X_Y_TYPE_HVEG'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,TGDP%CTYPE_HVEG,IRESP,HCOMMENT=YCOMMENT)
!
! Type of low vegetation
  YRECFM='D_TYPE_LVEG'
  YCOMMENT='X_Y_TYPE_LVEG'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,TGDP%CTYPE_LVEG,IRESP,HCOMMENT=YCOMMENT)
!
! Type of bare soil (no vegetation)
  YRECFM='D_TYPE_NVEG'
  YCOMMENT='X_Y_TYPE_NVEG'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,TGDP%CTYPE_NVEG,IRESP,HCOMMENT=YCOMMENT)
!
! Fraction of high vegetation
  YRECFM='D_FRAC_HVEG'
  YCOMMENT='X_Y_D_FRAC_HVEG'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTGD%XDATA_FRAC_HVEG(:),IRESP,HCOMMENT=YCOMMENT)
!
! Fraction of low vegetation
  YRECFM='D_FRAC_LVEG'
  YCOMMENT='X_Y_D_FRAC_LVEG'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTGD%XDATA_FRAC_LVEG(:),IRESP,HCOMMENT=YCOMMENT)
!
! Fraction of bare soil
  YRECFM='D_FRAC_NVEG'
  YCOMMENT='X_Y_D_FRAC_NVEG'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTGD%XDATA_FRAC_NVEG(:),IRESP,HCOMMENT=YCOMMENT)
!
! LAI of high vegetation
  DO JTIME=1,DTGD%NTIME
    WRITE(YRECFM,FMT='(A10,I2.2)') 'D_LAI_HVEG',JTIME
    YCOMMENT='X_Y_D_LAI_HVEG'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTGD%XDATA_LAI_HVEG(:,JTIME),IRESP,HCOMMENT=YCOMMENT)
  END DO
!
! LAI of low vegetation
  DO JTIME=1,DTGD%NTIME
    WRITE(YRECFM,FMT='(A10,I2.2)') 'D_LAI_LVEG',JTIME
    YCOMMENT='X_Y_D_LAI_LVEG'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTGD%XDATA_LAI_LVEG(:,JTIME),IRESP,HCOMMENT=YCOMMENT)
  END DO
!
! Height of trees
  YRECFM='D_H_HVEG'
  YCOMMENT='X_Y_DATA_H_HVEG'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTGD%XDATA_H_HVEG(:),IRESP,HCOMMENT=YCOMMENT)
!
ENDIF
!
IF (TOP%LGREENROOF .AND. TGRO%LPAR_GREENROOF) THEN
!
! Type of green roof
  YRECFM='D_TYPE_GR'
  YCOMMENT='X_Y_TYPE_GR'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,TGRO%CTYP_GR,IRESP,HCOMMENT=YCOMMENT)
!
! Fraction of OM in green roof layer
  DO JLAYER=1,TGRO%NLAYER_GR
    WRITE(YRECFM,FMT='(A7,I2.2)') 'D_OM_GR',JLAYER
    YCOMMENT='X_Y_D_OM_GR'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTGR%XPAR_OM_GR(:,JLAYER),IRESP,HCOMMENT=YCOMMENT)
  END DO
!
! Fraction of CLAY in the non-OM part of the green roof layer
  DO JLAYER=1,TGRO%NLAYER_GR
    WRITE(YRECFM,FMT='(A9,I2.2)') 'D_CLAY_GR',JLAYER
    YCOMMENT='X_Y_D_CLAY_GR'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTGR%XPAR_CLAY_GR(:,JLAYER),IRESP,HCOMMENT=YCOMMENT)
  END DO
!
! Fraction of SAND in the non-OM part of the green roof layer
  DO JLAYER=1,TGRO%NLAYER_GR
    WRITE(YRECFM,FMT='(A9,I2.2)') 'D_SAND_GR',JLAYER
    YCOMMENT='X_Y_D_SAND_GR'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTGR%XPAR_SAND_GR(:,JLAYER),IRESP,HCOMMENT=YCOMMENT)
  END DO
!
! LAI of green roof vegetation
  DO JTIME=1,TGRO%NTIME_GR
    WRITE(YRECFM,FMT='(A8,I2.2)') 'D_LAI_GR',JTIME
    YCOMMENT='X_Y_D_LAI_GR'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTGR%XPAR_LAI_GR(:,JTIME),IRESP,HCOMMENT=YCOMMENT)
  END DO
! 
ENDIF
!-------------------------------------------------------------------------------
!
!*      Irrigation of gardens or greenroofs
!       -----------------------------------
!
CALL WRITESURF_PGD_TEB_IRRIG_n(DGU, U, &
                               TIR, &
                               HPROGRAM)
!
IF (LHOOK) CALL DR_HOOK('WRITESURF_PGD_TEB_PAR_N',1,ZHOOK_HANDLE)
!
!
!-------------------------------------------------------------------------------
!
END SUBROUTINE WRITESURF_PGD_TEB_PAR_n
