!     #########
      SUBROUTINE WRITESURF_PGD_ISBA_PAR_n (DGU, U, &
                                            DTI, &
                                           HPROGRAM)
!     ################################################
!
!!****  *WRITESURF_PGD_ISBA_PAR_n* - writes ISBA physiographic fields
!!                        
!!
!!    PURPOSE
!!    -------
!!
!!**  METHOD
!!    ------
!!
!!    EXTERNAL
!!    --------
!!
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!
!!    AUTHOR
!!    ------
!!      V. Masson   *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    01/2003 
!!      P. Le Moigne 12/2004 : add type of photosynthesis 
!!      P. Samuelsson 10/2014: MEB
!-------------------------------------------------------------------------------
!
!*       0.    DECLARATIONS
!              ------------
!
  
!
!
!
!
USE MODD_DIAG_SURF_ATM_n, ONLY : DIAG_SURF_ATM_t
USE MODD_SURF_ATM_n, ONLY : SURF_ATM_t
!
USE MODD_DATA_ISBA_n, ONLY : DATA_ISBA_t
!
USE MODI_WRITE_SURF
!
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*       0.1   Declarations of arguments
!              -------------------------
!
!
!
TYPE(DIAG_SURF_ATM_t), INTENT(INOUT) :: DGU
TYPE(SURF_ATM_t), INTENT(INOUT) :: U
!
TYPE(DATA_ISBA_t), INTENT(INOUT) :: DTI
!
 CHARACTER(LEN=6),  INTENT(IN)  :: HPROGRAM ! program calling
!
!*       0.2   Declarations of local variables
!              -------------------------------
!
INTEGER           :: IRESP          ! IRESP  : return-code if a problem appears
 CHARACTER(LEN=12) :: YRECFM         ! Name of the article to be read
 CHARACTER(LEN=100):: YCOMMENT       ! Comment string
INTEGER           :: JTIME          ! loop index
INTEGER           :: JLAYER         ! loop index
INTEGER           :: JPATCH         ! loop index
REAL,    DIMENSION(:,:), ALLOCATABLE :: ZWORK
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!-------------------------------------------------------------------------------
!
IF (LHOOK) CALL DR_HOOK('WRITESURF_PGD_ISBA_PAR_N',0,ZHOOK_HANDLE)
YRECFM='L_VEGTYPE'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%LDATA_VEGTYPE,IRESP,HCOMMENT=YCOMMENT)
IF (DTI%LDATA_VEGTYPE) THEN
  YRECFM='D_VEGTYPE'
  YCOMMENT='X_Y_DATA_VEGTYPE'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%XPAR_VEGTYPE(:,:),IRESP,HCOMMENT=YCOMMENT)
ENDIF
!
IF (DTI%LDATA_LAI .OR. DTI%LDATA_VEG .OR. DTI%LDATA_Z0 .OR. DTI%LDATA_EMIS) THEN
  YRECFM='NDATA_TIME'
  YCOMMENT='(-)'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%NTIME,IRESP,HCOMMENT=YCOMMENT)
ENDIF
!
YRECFM='L_VEG'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%LDATA_VEG,IRESP,HCOMMENT=YCOMMENT)
IF (DTI%LDATA_VEG) THEN
  DO JTIME=1,DTI%NTIME
    WRITE(YRECFM,FMT='(A7,I2.2)') 'D_VEG_T',JTIME
    YCOMMENT='X_Y_D_VEG'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%XPAR_VEG(:,JTIME,:),IRESP,HCOMMENT=YCOMMENT)
  END DO
ENDIF
!
YRECFM='L_LAI'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%LDATA_LAI,IRESP,HCOMMENT=YCOMMENT)
IF (DTI%LDATA_LAI) THEN
  DO JTIME=1,DTI%NTIME
    WRITE(YRECFM,FMT='(A7,I2.2)') 'D_LAI_T',JTIME
    YCOMMENT='X_Y_D_LAI'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%XPAR_LAI(:,JTIME,:),IRESP,HCOMMENT=YCOMMENT)
  END DO
ENDIF
!
YRECFM='L_LAIGV'
YCOMMENT=YRECFM
CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%LDATA_LAIGV,IRESP,HCOMMENT=YCOMMENT)
IF (DTI%LDATA_LAIGV) THEN
  DO JTIME=1,36
    WRITE(YRECFM,FMT='(A9,I2.2)') 'D_LAIGV_T',JTIME
    YCOMMENT='X_Y_D_LAIGV'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%XPAR_LAIGV(:,JTIME,:),IRESP,HCOMMENT=YCOMMENT)
  END DO
ENDIF
!
YRECFM='L_H_VEG'
YCOMMENT=YRECFM
CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%LDATA_H_VEG,IRESP,HCOMMENT=YCOMMENT)
IF (DTI%LDATA_H_VEG) THEN
  DO JTIME=1,36
    WRITE(YRECFM,FMT='(A9,I2.2)') 'D_H_VEG_T',JTIME
    YCOMMENT='X_Y_D_H_VEG'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%XPAR_H_VEG(:,JTIME,:),IRESP,HCOMMENT=YCOMMENT)
  END DO
ENDIF
!
YRECFM='L_GNDLITTER'
YCOMMENT=YRECFM
CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%LDATA_GNDLITTER,IRESP,HCOMMENT=YCOMMENT)
IF (DTI%LDATA_GNDLITTER) THEN
  DO JTIME=1,36
    WRITE(YRECFM,FMT='(A7,I2.2)') 'D_GNDLITTER',JTIME
    YCOMMENT='X_Y_D_GNDLITTER'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%XPAR_GNDLITTER(:,JTIME,:),IRESP,HCOMMENT=YCOMMENT)
  END DO
ENDIF
!
YRECFM='L_Z0'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%LDATA_Z0,IRESP,HCOMMENT=YCOMMENT)
IF (DTI%LDATA_Z0) THEN
  DO JTIME=1,DTI%NTIME
    WRITE(YRECFM,FMT='(A6,I2.2)') 'D_Z0_T',JTIME
    YCOMMENT='X_Y_D_Z0'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%XPAR_Z0(:,JTIME,:),IRESP,HCOMMENT=YCOMMENT)
  END DO
ENDIF
!
YRECFM='L_Z0LITTER'
YCOMMENT=YRECFM
CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%LDATA_Z0LITTER,IRESP,HCOMMENT=YCOMMENT)
IF (DTI%LDATA_Z0LITTER) THEN
  DO JTIME=1,36
    WRITE(YRECFM,FMT='(A8,I2.2)') 'D_Z0LITTER_T',JTIME
    YCOMMENT='X_Y_D_Z0LITTER'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%XPAR_Z0LITTER(:,JTIME,:),IRESP,HCOMMENT=YCOMMENT)
  END DO
ENDIF
!
YRECFM='L_EMIS'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%LDATA_EMIS,IRESP,HCOMMENT=YCOMMENT)
IF (DTI%LDATA_EMIS) THEN
  DO JTIME=1,DTI%NTIME
    WRITE(YRECFM,FMT='(A8,I2.2)') 'D_EMIS_T',JTIME
    YCOMMENT='X_Y_D_EMIS'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%XPAR_EMIS(:,JTIME,:),IRESP,HCOMMENT=YCOMMENT)
  END DO
ENDIF
!
YRECFM='L_RSMIN'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%LDATA_RSMIN,IRESP,HCOMMENT=YCOMMENT)
IF (DTI%LDATA_RSMIN) THEN
  YRECFM='D_RSMIN'
  YCOMMENT='X_Y_D_RSMIN'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%XPAR_RSMIN(:,:),IRESP,HCOMMENT=YCOMMENT)
ENDIF
!
YRECFM='L_RSMINGV'
YCOMMENT=YRECFM
CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%LDATA_RSMINGV,IRESP,HCOMMENT=YCOMMENT)
IF (DTI%LDATA_RSMINGV) THEN
  YRECFM='D_RSMINGV'
  YCOMMENT='X_Y_D_RSMINGV'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%XPAR_RSMINGV(:,:),IRESP,HCOMMENT=YCOMMENT)
ENDIF
!
YRECFM='L_GAMMA'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%LDATA_GAMMA,IRESP,HCOMMENT=YCOMMENT)
IF (DTI%LDATA_GAMMA) THEN
  YRECFM='D_GAMMA'
  YCOMMENT='X_Y_D_GAMMA'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%XPAR_GAMMA(:,:),IRESP,HCOMMENT=YCOMMENT)
ENDIF
!
YRECFM='L_GAMMAGV'
YCOMMENT=YRECFM
CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%LDATA_GAMMAGV,IRESP,HCOMMENT=YCOMMENT)
IF (DTI%LDATA_GAMMAGV) THEN
  YRECFM='D_GAMMAGV'
  YCOMMENT='X_Y_D_GAMMAGV'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%XPAR_GAMMAGV(:,:),IRESP,HCOMMENT=YCOMMENT)
ENDIF
!
YRECFM='L_WRMAX_CF'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%LDATA_WRMAX_CF,IRESP,HCOMMENT=YCOMMENT)
IF (DTI%LDATA_WRMAX_CF) THEN
  YRECFM='D_WRMAX_CF'
  YCOMMENT='X_Y_D_WRMAX_CF'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%XPAR_WRMAX_CF(:,:),IRESP,HCOMMENT=YCOMMENT)
ENDIF
!
YRECFM='L_WRMAX_CFGV'
YCOMMENT=YRECFM
CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%LDATA_WRMAX_CFGV,IRESP,HCOMMENT=YCOMMENT)
IF (DTI%LDATA_WRMAX_CFGV) THEN
  YRECFM='D_WRMAX_CFGV'
  YCOMMENT='X_Y_D_WRMAX_CFGV'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%XPAR_WRMAX_CFGV(:,:),IRESP,HCOMMENT=YCOMMENT)
ENDIF
!
YRECFM='L_RGL'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%LDATA_RGL,IRESP,HCOMMENT=YCOMMENT)
IF (DTI%LDATA_RGL) THEN
  YRECFM='D_RGL'
  YCOMMENT='X_Y_D_RGL'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%XPAR_RGL(:,:),IRESP,HCOMMENT=YCOMMENT)
ENDIF
!
YRECFM='L_RGLGV'
YCOMMENT=YRECFM
CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%LDATA_RGLGV,IRESP,HCOMMENT=YCOMMENT)
IF (DTI%LDATA_RGLGV) THEN
  YRECFM='D_RGLGV'
  YCOMMENT='X_Y_D_RGLGV'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%XPAR_RGLGV(:,:),IRESP,HCOMMENT=YCOMMENT)
ENDIF
!
YRECFM='L_CV'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%LDATA_CV,IRESP,HCOMMENT=YCOMMENT)
IF (DTI%LDATA_CV) THEN
  YRECFM='D_CV'
  YCOMMENT='X_Y_D_CV'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%XPAR_CV(:,:),IRESP,HCOMMENT=YCOMMENT)
ENDIF
!
YRECFM='L_Z0_O_Z0H'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%LDATA_Z0_O_Z0H,IRESP,HCOMMENT=YCOMMENT)
IF (DTI%LDATA_Z0_O_Z0H) THEN
  YRECFM='D_Z0_O_Z0H'
  YCOMMENT='X_Y_D_Z0_O_Z0H'
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%XPAR_Z0_O_Z0H(:,:),IRESP,HCOMMENT=YCOMMENT)
ENDIF
!
YRECFM='L_DG'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%LDATA_DG,IRESP,HCOMMENT=YCOMMENT)
IF (DTI%LDATA_DG) THEN
  ALLOCATE(ZWORK(SIZE(DTI%XPAR_DG,1),SIZE(DTI%XPAR_DG,3)))
  DO JLAYER=1,SIZE(DTI%XPAR_DG,2)
    IF (JLAYER<10)  WRITE(YRECFM,FMT='(A4,I1.1)') 'D_DG',JLAYER
    IF (JLAYER>=10) WRITE(YRECFM,FMT='(A4,I2.2)') 'D_DG',JLAYER
    YCOMMENT='X_Y_'//YRECFM
    DO JPATCH=1,SIZE(DTI%XPAR_DG,3)
      ZWORK(:,JPATCH) = DTI%XPAR_DG(:,JLAYER,JPATCH)
    END DO
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,ZWORK,IRESP,HCOMMENT=YCOMMENT)
  END DO
  DEALLOCATE(ZWORK)
ENDIF
!
YRECFM='L_ROOTFRAC'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%LDATA_ROOTFRAC,IRESP,HCOMMENT=YCOMMENT)
IF (DTI%LDATA_ROOTFRAC) THEN
  ALLOCATE(ZWORK(SIZE(DTI%XPAR_ROOTFRAC,1),SIZE(DTI%XPAR_ROOTFRAC,3)))
  DO JLAYER=1,SIZE(DTI%XPAR_ROOTFRAC,2)
    IF (JLAYER<10)  WRITE(YRECFM,FMT='(A10,I1.1)') 'D_ROOTFRAC',JLAYER
    IF (JLAYER>=10) WRITE(YRECFM,FMT='(A10,I2.2)') 'D_ROOTFRAC',JLAYER
    YCOMMENT='X_Y_'//YRECFM
    DO JPATCH=1,SIZE(DTI%XPAR_ROOTFRAC,3)
      ZWORK(:,JPATCH) = DTI%XPAR_ROOTFRAC(:,JLAYER,JPATCH)
    END DO
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,ZWORK,IRESP,HCOMMENT=YCOMMENT)
  END DO
  DEALLOCATE(ZWORK)
ENDIF
!
YRECFM='L_RTFRACGV'
CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%LDATA_ROOTFRACGV,IRESP,HCOMMENT=YCOMMENT)
IF (DTI%LDATA_ROOTFRACGV) THEN
  ALLOCATE(ZWORK(SIZE(DTI%XPAR_ROOTFRACGV,1),SIZE(DTI%XPAR_ROOTFRACGV,3)))
  DO JLAYER=1,SIZE(DTI%XPAR_ROOTFRACGV,2)
    IF (JLAYER<10)  WRITE(YRECFM,FMT='(A10,I1.1)') 'D_RTFRACGV',JLAYER
    IF (JLAYER>=10) WRITE(YRECFM,FMT='(A10,I2.2)') 'D_RTFRACGV',JLAYER
    YCOMMENT='X_Y_'//YRECFM
    DO JPATCH=1,SIZE(DTI%XPAR_ROOTFRACGV,3)
      ZWORK(:,JPATCH) = DTI%XPAR_ROOTFRACGV(:,JLAYER,JPATCH)
    END DO
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,ZWORK,IRESP,HCOMMENT=YCOMMENT)
  END DO
  DEALLOCATE(ZWORK)
ENDIF
!
YRECFM='L_GROUND_DPT'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%LDATA_GROUND_DEPTH,IRESP,HCOMMENT=YCOMMENT)
IF (DTI%LDATA_GROUND_DEPTH) THEN
  YRECFM='D_GROUND_DPT'
  YCOMMENT='X_Y_'//YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%XPAR_GROUND_DEPTH(:,:),IRESP,HCOMMENT=YCOMMENT)
ENDIF
!
YRECFM='L_ROOT_DEPTH'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%LDATA_ROOT_DEPTH,IRESP,HCOMMENT=YCOMMENT)
IF (DTI%LDATA_ROOT_DEPTH) THEN
  YRECFM='D_ROOT_DEPTH'
  YCOMMENT='X_Y_'//YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%XPAR_ROOT_DEPTH(:,:),IRESP,HCOMMENT=YCOMMENT)
ENDIF
!
YRECFM='L_RT_DEPTHGV'
YCOMMENT=YRECFM
CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%LDATA_ROOT_DEPTHGV,IRESP,HCOMMENT=YCOMMENT)
IF (DTI%LDATA_ROOT_DEPTHGV) THEN
  YRECFM='D_RT_DEPTHGV'
  YCOMMENT='X_Y_'//YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%XPAR_ROOT_DEPTHGV(:,:),IRESP,HCOMMENT=YCOMMENT)
ENDIF
!
YRECFM='L_ROOT_EXT'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%LDATA_ROOT_EXTINCTION,IRESP,HCOMMENT=YCOMMENT)
IF (DTI%LDATA_ROOT_EXTINCTION) THEN
  YRECFM='D_ROOT_EXT'
  YCOMMENT='X_Y_'//YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%XPAR_ROOT_EXTINCTION(:,:),IRESP,HCOMMENT=YCOMMENT)
ENDIF
!
YRECFM='L_RT_EXTGV'
YCOMMENT=YRECFM
CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%LDATA_ROOT_EXTINCTIONGV,IRESP,HCOMMENT=YCOMMENT)
IF (DTI%LDATA_ROOT_EXTINCTIONGV) THEN
  YRECFM='D_RT_EXTGV'
  YCOMMENT='X_Y_'//YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%XPAR_ROOT_EXTINCTIONGV(:,:),IRESP,HCOMMENT=YCOMMENT)
ENDIF
!
YRECFM='L_ROOT_LIN'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%LDATA_ROOT_LIN,IRESP,HCOMMENT=YCOMMENT)
IF (DTI%LDATA_ROOT_LIN) THEN
  YRECFM='D_ROOT_LIN'
  YCOMMENT='X_Y_'//YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%XPAR_ROOT_LIN(:,:),IRESP,HCOMMENT=YCOMMENT)
ENDIF
!
YRECFM='L_DICE'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%LDATA_DICE,IRESP,HCOMMENT=YCOMMENT)
IF (DTI%LDATA_DICE) THEN
  YRECFM='D_DICE'
  YCOMMENT='X_Y_'//YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%XPAR_DICE(:,:),IRESP,HCOMMENT=YCOMMENT)
ENDIF
!
YRECFM='L_ALBNIR_VEG'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%LDATA_ALBNIR_VEG,IRESP,HCOMMENT=YCOMMENT)
IF (DTI%LDATA_ALBNIR_VEG) THEN
  YRECFM='D_ALBNIR_VEG'
  YCOMMENT='X_Y_'//YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%XPAR_ALBNIR_VEG(:,:),IRESP,HCOMMENT=YCOMMENT)
ENDIF
!
YRECFM='L_ALBVIS_VEG'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%LDATA_ALBVIS_VEG,IRESP,HCOMMENT=YCOMMENT)
IF (DTI%LDATA_ALBVIS_VEG) THEN
  YRECFM='D_ALBVIS_VEG'
  YCOMMENT='X_Y_'//YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%XPAR_ALBVIS_VEG(:,:),IRESP,HCOMMENT=YCOMMENT)
ENDIF
!
YRECFM='L_ALBUV_VEG'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%LDATA_ALBUV_VEG,IRESP,HCOMMENT=YCOMMENT)
IF (DTI%LDATA_ALBUV_VEG) THEN
  YRECFM='D_ALBUV_VEG'
  YCOMMENT='X_Y_'//YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%XPAR_ALBUV_VEG(:,:),IRESP,HCOMMENT=YCOMMENT)
ENDIF
!
YRECFM='L_ALBNIR_SOI'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%LDATA_ALBNIR_SOIL,IRESP,HCOMMENT=YCOMMENT)
IF (DTI%LDATA_ALBNIR_SOIL) THEN
  YRECFM='D_ALBNIR_SOI'
  YCOMMENT='X_Y_'//YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%XPAR_ALBNIR_SOIL(:,:),IRESP,HCOMMENT=YCOMMENT)
ENDIF
!
YRECFM='L_ALBVIS_SOI'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%LDATA_ALBVIS_SOIL,IRESP,HCOMMENT=YCOMMENT)
IF (DTI%LDATA_ALBVIS_SOIL) THEN
  YRECFM='D_ALBVIS_SOI'
  YCOMMENT='X_Y_'//YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%XPAR_ALBVIS_SOIL(:,:),IRESP,HCOMMENT=YCOMMENT)
ENDIF
!
YRECFM='L_ALBUV_SOI'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%LDATA_ALBUV_SOIL,IRESP,HCOMMENT=YCOMMENT)
IF (DTI%LDATA_ALBUV_SOIL) THEN
  YRECFM='D_ALBUV_SOI'
  YCOMMENT='X_Y_'//YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%XPAR_ALBUV_SOIL(:,:),IRESP,HCOMMENT=YCOMMENT)
ENDIF
!
YRECFM='L_GMES'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%LDATA_GMES,IRESP,HCOMMENT=YCOMMENT)
IF (DTI%LDATA_GMES) THEN
  YRECFM='D_GMES'
  YCOMMENT='X_Y_'//YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%XPAR_GMES(:,:),IRESP,HCOMMENT=YCOMMENT)
ENDIF
!
YRECFM='L_BSLAI'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%LDATA_BSLAI,IRESP,HCOMMENT=YCOMMENT)
IF (DTI%LDATA_BSLAI) THEN
  YRECFM='D_BSLAI'
  YCOMMENT='X_Y_'//YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%XPAR_BSLAI(:,:),IRESP,HCOMMENT=YCOMMENT)
ENDIF
!
YRECFM='L_LAIMIN'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%LDATA_LAIMIN,IRESP,HCOMMENT=YCOMMENT)
IF (DTI%LDATA_LAIMIN) THEN
  YRECFM='D_LAIMIN'
  YCOMMENT='X_Y_'//YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%XPAR_LAIMIN(:,:),IRESP,HCOMMENT=YCOMMENT)
ENDIF
!
YRECFM='L_SEFOLD'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%LDATA_SEFOLD,IRESP,HCOMMENT=YCOMMENT)
IF (DTI%LDATA_SEFOLD) THEN
  YRECFM='D_SEFOLD'
  YCOMMENT='X_Y_'//YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%XPAR_SEFOLD(:,:),IRESP,HCOMMENT=YCOMMENT)
ENDIF
!
YRECFM='L_GC'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%LDATA_GC,IRESP,HCOMMENT=YCOMMENT)
IF (DTI%LDATA_GC) THEN
  YRECFM='D_GC'
  YCOMMENT='X_Y_'//YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%XPAR_GC(:,:),IRESP,HCOMMENT=YCOMMENT)
ENDIF
!
YRECFM='L_DMAX'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%LDATA_DMAX,IRESP,HCOMMENT=YCOMMENT)
IF (DTI%LDATA_DMAX) THEN
  YRECFM='D_DMAX'
  YCOMMENT='X_Y_'//YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%XPAR_DMAX(:,:),IRESP,HCOMMENT=YCOMMENT)
ENDIF
!
YRECFM='L_F2I'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%LDATA_F2I,IRESP,HCOMMENT=YCOMMENT)
IF (DTI%LDATA_F2I) THEN
  YRECFM='D_F2I'
  YCOMMENT='X_Y_'//YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%XPAR_F2I(:,:),IRESP,HCOMMENT=YCOMMENT)
ENDIF
!
YRECFM='L_STRESS'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%LDATA_STRESS,IRESP,HCOMMENT=YCOMMENT)
IF (DTI%LDATA_STRESS) THEN
  ALLOCATE(ZWORK(SIZE(DTI%LPAR_STRESS,1),SIZE(DTI%LPAR_STRESS,2)))
  ZWORK=0.
  WHERE(DTI%LPAR_STRESS) ZWORK=1.
  YRECFM='D_STRESS'
  YCOMMENT='X_Y_'//YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,ZWORK(:,:),IRESP,HCOMMENT=YCOMMENT)
  DEALLOCATE(ZWORK)
ENDIF
!
YRECFM='L_H_TREE'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%LDATA_H_TREE,IRESP,HCOMMENT=YCOMMENT)
IF (DTI%LDATA_H_TREE) THEN
  YRECFM='D_H_TREE'
  YCOMMENT='X_Y_'//YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%XPAR_H_TREE(:,:),IRESP,HCOMMENT=YCOMMENT)
ENDIF
!
YRECFM='L_RE25'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%LDATA_RE25,IRESP,HCOMMENT=YCOMMENT)
IF (DTI%LDATA_RE25) THEN
  YRECFM='D_RE25'
  YCOMMENT='X_Y_'//YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%XPAR_RE25(:,:),IRESP,HCOMMENT=YCOMMENT)
ENDIF
!
YRECFM='L_CE_NITRO'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%LDATA_CE_NITRO,IRESP,HCOMMENT=YCOMMENT)
IF (DTI%LDATA_CE_NITRO) THEN
  YRECFM='D_CE_NITRO'
  YCOMMENT='X_Y_'//YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%XPAR_CE_NITRO(:,:),IRESP,HCOMMENT=YCOMMENT)
ENDIF
!
YRECFM='L_CF_NITRO'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%LDATA_CF_NITRO,IRESP,HCOMMENT=YCOMMENT)
IF (DTI%LDATA_CF_NITRO) THEN
  YRECFM='D_CF_NITRO'
  YCOMMENT='X_Y_'//YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%XPAR_CF_NITRO(:,:),IRESP,HCOMMENT=YCOMMENT)
ENDIF
!
YRECFM='L_CNA_NITRO'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%LDATA_CNA_NITRO,IRESP,HCOMMENT=YCOMMENT)
IF (DTI%LDATA_CNA_NITRO) THEN
  YRECFM='D_CNA_NITRO'
  YCOMMENT='X_Y_'//YRECFM
  CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%XPAR_CNA_NITRO(:,:),IRESP,HCOMMENT=YCOMMENT)
ENDIF
!
YRECFM='L_IRRIG'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%LDATA_IRRIG,IRESP,HCOMMENT=YCOMMENT)
IF (DTI%LDATA_IRRIG) THEN
  DO JTIME=1,DTI%NTIME
    WRITE(YRECFM,FMT='(A9,I2.2)') 'D_IRRIG_T',JTIME
    YCOMMENT='X_Y_IRRIG'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%XPAR_IRRIG(:,JTIME,:),IRESP,HCOMMENT=YCOMMENT)
  ENDDO
ENDIF
!
YRECFM='L_WATSUP'
YCOMMENT=YRECFM
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%LDATA_WATSUP,IRESP,HCOMMENT=YCOMMENT)
IF (DTI%LDATA_WATSUP) THEN
  DO JTIME=1,DTI%NTIME
    WRITE(YRECFM,FMT='(A10,I2.2)') 'D_WATSUP_T',JTIME
    YCOMMENT='X_Y_WATSUP'
    CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,YRECFM,DTI%XPAR_WATSUP(:,JTIME,:),IRESP,HCOMMENT=YCOMMENT)
  ENDDO
ENDIF
!
IF (LHOOK) CALL DR_HOOK('WRITESURF_PGD_ISBA_PAR_N',1,ZHOOK_HANDLE)
!
!-------------------------------------------------------------------------------
!
END SUBROUTINE WRITESURF_PGD_ISBA_PAR_n
