!#################################################################
SUBROUTINE WRITE_GRIDTYPE_GAUSS (DGU, U, &
                                 HPROGRAM,KLU,KGRID_PAR,PGRID_PAR,KRESP)
!#################################################################
!
!!****  *WRITE_GRIDTYPE_GAUSS* - routine to write the horizontal grid
!!
!!    PURPOSE
!!    -------
!!
!!**  METHOD
!!    ------
!!
!!    EXTERNAL
!!    --------
!!
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!
!!    AUTHOR
!!    ------
!!      V. Masson   *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    01/2004 
!-------------------------------------------------------------------------------
!
!*       0.    DECLARATIONS
!              ------------
!
!
!
USE MODD_DIAG_SURF_ATM_n, ONLY : DIAG_SURF_ATM_t
USE MODD_SURF_ATM_n, ONLY : SURF_ATM_t
!
USE MODI_WRITE_SURF
!
USE MODE_GRIDTYPE_GAUSS
!
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*       0.1   Declarations of arguments
!              -------------------------
!
!
TYPE(DIAG_SURF_ATM_t), INTENT(INOUT) :: DGU
TYPE(SURF_ATM_t), INTENT(INOUT) :: U
!
 CHARACTER(LEN=6),           INTENT(IN)  :: HPROGRAM   ! calling program
INTEGER,                    INTENT(IN)  :: KLU        ! number of points
INTEGER,                    INTENT(IN)  :: KGRID_PAR  ! size of PGRID_PAR
REAL, DIMENSION(KGRID_PAR), INTENT(IN)  :: PGRID_PAR  ! parameters defining this grid
INTEGER,                    INTENT(OUT) :: KRESP      ! error return code
!
!*       0.2   Declarations of local variables
!              -------------------------------
!
INTEGER :: INLATI  ! number of pseudo-latitudes
REAL    :: ZLAPO   ! latitude  of the rotated pole (deg)
REAL    :: ZLOPO   ! longitude of the rotated pole (deg)
REAL    :: ZCODIL  ! stretching factor (must be greater than or equal to 1)
INTEGER, DIMENSION(:), ALLOCATABLE :: INLOPA ! number of pseudo-longitudes on each
                                             ! pseudo-latitude circle
REAL,    DIMENSION(KLU) :: ZLAT ! latitudes
REAL,    DIMENSION(KLU) :: ZLON ! longitudes
REAL,    DIMENSION(KLU) :: ZLAT_XY
REAL,    DIMENSION(KLU) :: ZLON_XY
REAL,    DIMENSION(KLU) :: ZMESH_SIZE
!                                                                 _____ Sup
REAL,    DIMENSION(KLU) :: ZLATSUP     ! Grid corner Latitude    |     |
REAL,    DIMENSION(KLU) :: ZLONSUP     ! Grid corner Longitude   |     |
REAL,    DIMENSION(KLU) :: ZLATINF     ! Grid corner Latitude    |_____|
REAL,    DIMENSION(KLU) :: ZLONINF     ! Grid corner Longitude  Inf
!
INTEGER                            :: IL    ! total number of points
!
 CHARACTER(LEN=100)                :: YCOMMENT ! comment written in the file
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!---------------------------------------------------------------------------
!
IF (LHOOK) CALL DR_HOOK('WRITE_GRIDTYPE_GAUSS',0,ZHOOK_HANDLE)
!
!*       1.    Projection and 2D grid parameters
!              ---------------------------------
!
 CALL GET_GRIDTYPE_GAUSS(PGRID_PAR,INLATI)
!
ALLOCATE(INLOPA(INLATI))
!
 CALL GET_GRIDTYPE_GAUSS(PGRID_PAR,INLATI,ZLAPO,ZLOPO,ZCODIL,INLOPA(:),IL,&
                         ZLAT,ZLON,ZLAT_XY,ZLON_XY,ZMESH_SIZE,            &
                         ZLONINF,ZLATINF,ZLONSUP,ZLATSUP                  )  
!
!---------------------------------------------------------------------------
!
!*       2.    Writing of the grid definition parameters
!              -----------------------------------------
!
YCOMMENT=' '
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,'NLATI',INLATI,KRESP,YCOMMENT)
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,'LAPO',ZLAPO, KRESP,YCOMMENT)
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,'LOPO',ZLOPO,KRESP,YCOMMENT)
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,'CODIL',ZCODIL,KRESP,YCOMMENT)
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,'NLOPA',INLOPA(:),KRESP,YCOMMENT,HDIR='-',HNAM_DIM='Nlati           ')
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,'LATGAUSS',ZLAT(:),KRESP,YCOMMENT)
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,'LONGAUSS',ZLON(:),KRESP,YCOMMENT)
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,'LAT_G_XY',ZLAT_XY(:),KRESP,YCOMMENT)
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,'LON_G_XY',ZLON_XY(:),KRESP,YCOMMENT)
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,'MESHGAUSS',ZMESH_SIZE(:),KRESP,YCOMMENT)
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,'LONINF',ZLONINF(:),KRESP,YCOMMENT)
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,'LATINF',ZLATINF(:),KRESP,YCOMMENT)
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,'LONSUP',ZLONSUP(:),KRESP,YCOMMENT)
 CALL WRITE_SURF(DGU, U, &
                 HPROGRAM,'LATSUP',ZLATSUP(:),KRESP,YCOMMENT)
!
DEALLOCATE(INLOPA)
!
!---------------------------------------------------------------------------
IF (LHOOK) CALL DR_HOOK('WRITE_GRIDTYPE_GAUSS',1,ZHOOK_HANDLE)
!---------------------------------------------------------------------------
!
END SUBROUTINE WRITE_GRIDTYPE_GAUSS
