!     #########
SUBROUTINE SURFACE_CDCH_1DARP (PZREF, PZ0EFF, PZ0H, PVMOD, PTA, PTG, &
                                 PQA, PQS, PCD, PCDN, PCH              )    
!   ###################################################################
!     Purpose :
!     ------

!     - CALCUL DES COEFFICIENTS D'ECHANGE TURBULENT Cd ET Ch
!       DE LA MEME FACON QU'ARPEGE. (cf ACHMT)

!-----------------------------------------------------------------------
!     -------
!     Auteur.
!     -------
!  Dec 2007 : M. Jidane      * MAROC METEO *
!
!-----------------------------------------------------------------------

! -   ARGUMENTS D'ENTREE.
!     -------------------
! PZ0EFF     : LA LONGUEUR DE RUGOSITE COURANTE.
! PZ0H       : LONGUEUR DE RUGOSITE THERMIQUE COURANTE
! PTA        : TEMPERATURE.
! PTG        : TEMPERATURE DE SURFACE.
! PQA        : specific humidity
! PQS        : humidity at surface

!-----------------------------------------------------------------------

! -   ARGUMENTS DE SORTIE.
!     --------------------
! PCD        : COEFFICIENT D'ECHANGE EN SURFACE POUR U ET V.
! PCDN       : COEFFICIENT NEUTRE D'ECHANGE EN SURFACE.
! PCH        : COEFFICIENT D'ECHANGE EN SURFACE POUR T ET Q

USE MODD_CSTS,        ONLY : XG, XRD, XRV, XCPD, XKARMAN
USE MODD_SURF_ATM,    ONLY : XEDB, XEDC, XEDD, XEDK, XUSURIC, XUSURID, XUSURICL

!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE

REAL, DIMENSION(:), INTENT(IN)  :: PZREF
REAL, DIMENSION(:), INTENT(IN)  :: PZ0EFF
REAL, DIMENSION(:), INTENT(IN)  :: PZ0H
REAL, DIMENSION(:), INTENT(IN)  :: PVMOD
REAL, DIMENSION(:), INTENT(IN)  :: PTA
REAL, DIMENSION(:), INTENT(IN)  :: PTG
REAL, DIMENSION(:), INTENT(IN)  :: PQA
REAL, DIMENSION(:), INTENT(IN)  :: PQS
REAL, DIMENSION(:), INTENT(OUT) :: PCD
REAL, DIMENSION(:), INTENT(OUT) :: PCDN
REAL, DIMENSION(:), INTENT(OUT) :: PCH

INTEGER         :: JLON

REAL, DIMENSION(0:3,1:4) :: GCZ0H

REAL, DIMENSION(SIZE(PTA))     :: ZSTAB
!                         ZSTAB : INDICE DE STABILITE A LA SURFACE.
REAL, DIMENSION(SIZE(PTA))     :: ZCDNH, ZRTI, ZU

REAL :: ZR, ZRS
!                         ZR  : CONSTANTE DES GAZ POUR L'AIR.
!                         ZRS : CONSTANTE DES GAZ POUR L'AIR AU SOL.

REAL :: Z2B, Z3B, Z3BC, ZCD, ZCD0, ZCH, ZCH0, ZCIS, ZDID, &
          ZDIH, ZDS, ZLOI, ZLOS, ZMU, ZPD, ZPH, ZRZD, ZRZH, &
          ZUSURIC, ZSTA, ZIXP, ZSTAH, ZHS  
REAL(KIND=JPRB) :: ZHOOK_HANDLE

!*
!     ------------------------------------------------------------------
!     I - CONSTANTES AUXILIAIRES.
!  ISBA - roughness length
IF (LHOOK) CALL DR_HOOK('SURFACE_CDCH_1DARP',0,ZHOOK_HANDLE)
GCZ0H(0,1)=7.5
GCZ0H(1,1)=2.39037
GCZ0H(2,1)=-.28583
GCZ0H(3,1)=.01074
GCZ0H(0,2)=0.5
GCZ0H(1,2)=-.07028
GCZ0H(2,2)=.01023
GCZ0H(3,2)=-.00067
GCZ0H(0,3)=5.0
GCZ0H(1,3)=4.51268
GCZ0H(2,3)=.34012
GCZ0H(3,3)=-.05330
GCZ0H(0,4)=0.5
GCZ0H(1,4)=-.09421
GCZ0H(2,4)=.01463
GCZ0H(3,4)=-.00099


ZUSURIC=XUSURIC*XUSURICL

!*
!     ------------------------------------------------------------------
!     II - CALCUL DES PARAMETRES DERIVES ET CONSTANTE DE SECURITE (POUR
!     LE CARRE DU CISAILLEMENT DE VENT).

!          COMPUTATION OF DERIVED PARAMETERS AND SECURITY CONSTANT (FOR
!     THE SQUARE OF THE WIND SHEAR).

Z2B=2.0*XEDB
Z3B=3.*XEDB
Z3BC=3.*XEDB*XEDC

!*
!     ------------------------------------------------------------------
!     IV - CALCUL DE L EPAISSEUR DE LA CLS (EN GEOPOTENTIEL).

!          COMPUTATION OF THE THICKNESS OF THE SBL (IN GEOPOTENTIAL).

! - TEMPORAIRE(S) 1D .

!*
!     ------------------------------------------------------------------
!     VI - CALCULS PROPREMENT DITS DES CARACTERISTIQUES DE SURFACE.

!          EFFECTIVE CALCULATIONS OF THE SURFACE CHARACTERISTICS.

IF(XUSURID == 0.0) THEN
  ZIXP=1.0
ELSE
  ZIXP=3.
ENDIF

DO JLON=1, SIZE(PTA)

  ZR  = XRD + (XRV-XRD)*PQA(JLON)
  ZRS = XRD + (XRV-XRD)*PQS(JLON)

!     CALCULS GEOMETRIQUES.
!     GEOMETRIC CALCULATIONS.

  ZRZD=1.0+PZREF(JLON)/PZ0EFF(JLON)
  PCDN(JLON)=(XKARMAN/LOG(ZRZD))**2

!     CALCUL PRELIMINAIRES NECESSAIRES A LA DETERMINATION DES
!     COEFFICIENTS D'ECHANGE CD ET CH DANS LE CAS DE DEUX RUGOSITES
!     DYNAMIQUE Z0 ET THERMIQUE ZOH.

!     PRELIMINARY COMPUTATIONS NECESSARY FOR THE DETERMINATION OF
!     EXCHANGE COEFFICIENTS CD AND CH IN THE CASE OF TWO ROUGHNESS
!     LENGTHS Z0 DYNAMICAL AND ZOH THERMAL.

! - TEMPORAIRE(S) 1D .

! ZCDNH     : COEFFICIENT THERMIQUE NEUTRE D'ECHANGE EN SURFACE.
!           : NEUTRAL SURFACE THERMAL EXCHANGE COEFFICIENT.

  ZRZH=1.0+PZREF(JLON)/PZ0H(JLON)
  ZCDNH(JLON)=XKARMAN**2/(LOG(ZRZH)*LOG(ZRZD))
  ZMU=LOG(PZ0EFF(JLON)/PZ0H(JLON))
  ZCD0=(GCZ0H(0,1)+ZMU*(GCZ0H(1,1)+ZMU*(GCZ0H(2,1)+ZMU &
        *GCZ0H(3,1))))/(1.5*XEDC)    
  ZPD=(GCZ0H(0,2)+ZMU*(GCZ0H(1,2)+ZMU*(GCZ0H(2,2)+ZMU*GCZ0H(3,2))))-0.5
  ZCH0=(GCZ0H(0,3)+ZMU*(GCZ0H(1,3)+ZMU*(GCZ0H(2,3)+ZMU*GCZ0H(3,3))))/XEDC
  ZPH=(GCZ0H(0,4)+ZMU*(GCZ0H(1,4)+ZMU*(GCZ0H(2,4)+ZMU*GCZ0H(3,4))))-0.5
  ZCD=ZCD0*ZRZD**ZPD
  ZCH=ZCH0*ZRZH**ZPH

!     CISAILLEMENT DE VENT.
!     WIND SHEAR.

! - TEMPORAIRE(S) 1D .

! ZU        : MODULE DU VENT DE SURFACE.
!           : SURFACE WIND SPEED.

  ZCIS=PVMOD(JLON)**2
  ZU(JLON)=PVMOD(JLON)

!     CALCUL DE STABILITE.
!     STABILITY COMPUTATION.

! - TEMPORAIRE(S) 1D .

! ZRTI      : INVERSE DE R*T.
!           : INVERSE OF R*T.
! ZSTA      : APPROXIMATION DE DELTA(PHI)*DELTA(LN(THETA)).
!           : APPROXIMATION OF DELTA(PHI)*DELTA(LN(THETA)).

  ZRTI(JLON)=2.0/(ZR*PTA(JLON)+(XRD/XCPD)*XG*PZREF(JLON)&
        +ZRS*PTG(JLON))    
  ZSTA=XG*PZREF(JLON)*(ZR*PTA(JLON)+(XRD/XCPD) &
        *XG*PZREF(JLON)-ZRS*PTG(JLON))*ZRTI(JLON)    
  ZSTAH=ZSTA/(1.0+ZIXP*ZUSURIC*MAX(0.0,ZSTA)/ZCIS)**(1.0/ZIXP)
  ZSTA=ZSTA/(1.0+ZUSURIC*MAX(0.0,ZSTA)/ZCIS)
  ZSTAB(JLON)=MAX(0.0,SIGN(1.0,ZSTA))

!     CALCULS COMMUNS POUR QUANTITE DE MOUVEMENT ET ENERGIE.
!     COMMON COMPUTATIONS FOR MOMENTUM AND ENERGY.

  ZDS=SQRT(ZCIS+XEDD/XEDK*ABS(ZSTA))
  ZHS=SQRT(ZCIS+XEDD*XEDK*ABS(ZSTAH))
  ZDID=1.0/(ZU(JLON)+ZCD*Z3BC*PCDN(JLON)*SQRT(ABS(ZSTA)*ZRZD))
  ZDIH=1.0/(ZU(JLON)+ZCH*Z3BC*ZCDNH(JLON)*SQRT(ABS(ZSTA)*ZRZH))

!     CALCULS POUR LES COMPOSANTES DU VENT DE CD ET DE SON PRODUIT PAR
!     DENSITE FOIS MODULE DU VENT.
!     COMPUTATIONS FOR MOMENTUM OF CD AND OF ITS PRODUCT BY DENSITY
!     TIME WIND SPEED.

  ZLOS=ZCIS*ZDS/(ZU(JLON)*ZDS+Z2B*ABS(ZSTA))
  ZLOI=ZU(JLON)-Z2B*ZSTA*ZDID
  PCD(JLON)=(ZLOI+ZSTAB(JLON)*(ZLOS-ZLOI))*PCDN(JLON)/ZU(JLON)

!     IDEM POUR LA TEMPERATURE ET L'HUMIDITE.
!     THE SAME FOR TEMPERATURE AND HUMIDITY.

  ZLOS=ZCIS**2/(ZU(JLON)*ZCIS+Z3B*ABS(ZSTAH)*ZHS)
  ZLOI=ZU(JLON)-Z3B*ZSTA*ZDIH
  PCH(JLON)=(ZLOI+ZSTAB(JLON)*(ZLOS-ZLOI))*ZCDNH(JLON)/ZU(JLON)

ENDDO
IF (LHOOK) CALL DR_HOOK('SURFACE_CDCH_1DARP',1,ZHOOK_HANDLE)

END SUBROUTINE SURFACE_CDCH_1DARP
