!     #########
    SUBROUTINE SST_UPDATE (DTS, S, &
                           PSST,TTIME)
!   ###############################################################
!!****  *SST_UPDATE*
!!
!!    PURPOSE
!!    -------
!
!     performs the time evolution of sst
!              
!!**  METHOD
!!    ------
!!
!!    EXTERNAL
!!    --------
!!    none
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!      
!!    none
!!
!!    REFERENCE
!!    ---------
!!
!!      
!!    AUTHOR
!!    ------
!!
!!      P. Le Moigne          * Meteo-France *
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    09/2007
!!
!-------------------------------------------------------------------------------
!
!*       0.     DECLARATIONS
!               ------------
!
!
USE MODD_DATA_SEAFLUX_n, ONLY : DATA_SEAFLUX_t
USE MODD_SEAFLUX_n, ONLY : SEAFLUX_t
!
USE MODD_TYPE_DATE_SURF
USE MODI_TEMPORAL_DISTS
USE MODI_TEMPORAL_LTS
!
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*      0.1    declarations of arguments
!
!
!
TYPE(DATA_SEAFLUX_t), INTENT(INOUT) :: DTS
TYPE(SEAFLUX_t), INTENT(INOUT) :: S
!
TYPE(DATE_TIME),      INTENT(IN)    :: TTIME   ! UTC time
REAL,   DIMENSION(:), INTENT(INOUT) :: PSST    ! sst
!
!*      0.2    declarations of local variables
!
INTEGER                                  :: JXP
REAL, DIMENSION(SIZE(PSST))              :: ZSST, ZSST0
REAL                                     :: ZSDTJX
REAL                                     :: ZDT, ZALPHA
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!-----------------------------------------------------------------
!
IF (LHOOK) CALL DR_HOOK('SST_UPDATE',0,ZHOOK_HANDLE)
!
IF (.NOT.S%LTZTIME_DONE) THEN
   S%LTZTIME_DONE = .TRUE.
   S%JSX = 1
   S%TZTIME%TDATE%YEAR  = TTIME%TDATE%YEAR
   S%TZTIME%TDATE%MONTH = TTIME%TDATE%MONTH
   S%TZTIME%TDATE%DAY   = TTIME%TDATE%DAY
   S%TZTIME%TIME        = TTIME%TIME
ENDIF
!
ZSST0(:) = S%XSST_INI(:)
!
IF ( TEMPORAL_LTS ( TTIME, DTS%TDATA_SST(1) ) ) THEN
  !
  CALL TEMPORAL_DISTS ( DTS%TDATA_SST(1)%TDATE%YEAR,DTS%TDATA_SST(1)%TDATE%MONTH, &
                        DTS%TDATA_SST(1)%TDATE%DAY ,DTS%TDATA_SST(1)%TIME,        &
                        S%TZTIME%TDATE%YEAR   ,S%TZTIME%TDATE%MONTH,          &
                        S%TZTIME%TDATE%DAY    ,S%TZTIME%TIME,                 &
                        ZSDTJX                                            )  
  !
  CALL TEMPORAL_DISTS ( TTIME%TDATE%YEAR   ,TTIME%TDATE%MONTH,           &
                        TTIME%TDATE%DAY    ,TTIME%TIME,                  &
                        S%TZTIME%TDATE%YEAR  ,S%TZTIME%TDATE%MONTH,          &
                        S%TZTIME%TDATE%DAY   ,S%TZTIME%TIME,                 &
                        ZDT                                              )  
  !
  ZALPHA = ZDT / ZSDTJX
  !
  ZSST(:)= ZSST0(:)+(DTS%XDATA_SST(:,1)-ZSST0(:))*ZALPHA
  !
ELSE IF ( .NOT. TEMPORAL_LTS ( TTIME, DTS%TDATA_SST(DTS%NTIME) ) ) THEN
  !
  ZSST(:) = DTS%XDATA_SST(:,DTS%NTIME)
  !
ELSE
  !
  DO
    JXP = S%JSX + 1
    IF ( TEMPORAL_LTS( TTIME, DTS%TDATA_SST(JXP)) ) EXIT
    S%JSX = S%JSX + 1
  ENDDO
  !  
  CALL TEMPORAL_DISTS ( DTS%TDATA_SST(JXP)%TDATE%YEAR,DTS%TDATA_SST(JXP)%TDATE%MONTH,   &
                        DTS%TDATA_SST(JXP)%TDATE%DAY ,DTS%TDATA_SST(JXP)%TIME,          &
                        DTS%TDATA_SST(S%JSX)%TDATE%YEAR ,DTS%TDATA_SST(S%JSX)%TDATE%MONTH,  &
                        DTS%TDATA_SST(S%JSX)%TDATE%DAY  ,DTS%TDATA_SST(S%JSX)%TIME,         &
                        ZSDTJX                                            )  
  !
  CALL TEMPORAL_DISTS ( TTIME%TDATE%YEAR   ,TTIME%TDATE%MONTH,                  &
                        TTIME%TDATE%DAY    ,TTIME%TIME,                         &
                        DTS%TDATA_SST(S%JSX)%TDATE%YEAR,DTS%TDATA_SST(S%JSX)%TDATE%MONTH,   &
                        DTS%TDATA_SST(S%JSX)%TDATE%DAY ,DTS%TDATA_SST(S%JSX)%TIME,          &
                        ZDT                                             )  
  !
  ZALPHA = ZDT / ZSDTJX

  !
  ZSST(:)= DTS%XDATA_SST(:,S%JSX)+(DTS%XDATA_SST(:,JXP)-DTS%XDATA_SST(:,S%JSX))*ZALPHA
  !                
END IF
!
PSST(:) = ZSST(:)
!
IF (LHOOK) CALL DR_HOOK('SST_UPDATE',1,ZHOOK_HANDLE)
!-----------------------------------------------------------------
!
END SUBROUTINE SST_UPDATE
