!     #########
      SUBROUTINE READ_PGD_TEB_PAR_n (DTCO, U, &
                                      BDD, DTB, DTT, TG, TOP, &
                                     HPROGRAM,KNI,HDIRIN)
!     ################################################
!
!!****  *READ_PGD_TEB_PAR_n* - reads ISBA physiographic fields
!!                        
!!
!!    PURPOSE
!!    -------
!!
!!**  METHOD
!!    ------
!!
!!    EXTERNAL
!!    --------
!!
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!
!!    AUTHOR
!!    ------
!!      V. Masson   *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    05/2005
!!        V. Masson 08/2013 adds solar panels
!-------------------------------------------------------------------------------
!
!*       0.    DECLARATIONS
!              ------------
!
!

!
!
!
!
!
USE MODD_DATA_COVER_n, ONLY : DATA_COVER_t
USE MODD_SURF_ATM_n, ONLY : SURF_ATM_t
!
USE MODD_BLD_DESCRIPTION_n, ONLY : BLD_DESC_t
USE MODD_DATA_BEM_n, ONLY : DATA_BEM_t
USE MODD_DATA_TEB_n, ONLY : DATA_TEB_t
USE MODD_TEB_GRID_n, ONLY : TEB_GRID_t
USE MODD_TEB_OPTION_n, ONLY : TEB_OPTIONS_t
!
USE MODI_READ_SURF
USE MODI_READ_BLD_DESCRIPTION_n
USE MODI_GET_LUOUT
USE MODI_BLDCODE
USE MODI_ABOR1_SFX
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*       0.1   Declarations of arguments
!              -------------------------
!
!
!
TYPE(DATA_COVER_t), INTENT(INOUT) :: DTCO
TYPE(SURF_ATM_t), INTENT(INOUT) :: U
!
TYPE(BLD_DESC_t), INTENT(INOUT) :: BDD
TYPE(DATA_BEM_t), INTENT(INOUT) :: DTB
TYPE(DATA_TEB_t), INTENT(INOUT) :: DTT
TYPE(TEB_GRID_t), INTENT(INOUT) :: TG
TYPE(TEB_OPTIONS_t), INTENT(INOUT) :: TOP
!
 CHARACTER(LEN=6),  INTENT(IN)  :: HPROGRAM ! program calling
INTEGER,           INTENT(IN)  :: KNI      ! size of the new domain
 CHARACTER(LEN=1),  INTENT(IN)  :: HDIRIN
!
!*       0.2   Declarations of local variables
!              -------------------------------
!
INTEGER           :: ILUOUT         ! output listing logical unit
INTEGER           :: IRESP          ! IRESP  : return-code if a problem appears
 CHARACTER(LEN=12) :: YRECFM         ! Name of the article to be read
INTEGER           :: JLAYER         ! loop index
!
INTEGER           :: IVERSION       ! surface version
INTEGER           :: IBUGFIX        ! surface bugfix version
REAL, DIMENSION(TG%NDIM) :: ZWORK      ! work array
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!-------------------------------------------------------------------------------
IF (LHOOK) CALL DR_HOOK('READ_PGD_TEB_PAR_N',0,ZHOOK_HANDLE)
!
 CALL GET_LUOUT(HPROGRAM,ILUOUT)
!
YRECFM='VERSION'
 CALL READ_SURF(&
                HPROGRAM,YRECFM,IVERSION,IRESP)
YRECFM='BUG'
 CALL READ_SURF(&
                HPROGRAM,YRECFM,IBUGFIX,IRESP)
!
IF (IVERSION<7 .AND. .NOT.TOP%LECOCLIMAP) THEN
  !
  DTT%LDATA_BLDTYPE     = .FALSE.
  DTT%LDATA_BLD_AGE     = .FALSE.
  DTT%LDATA_USETYPE     = .FALSE.
  DTT%LDATA_Z0_TOWN     = .TRUE.
  DTT%LDATA_BLD         = .TRUE.
  DTT%LDATA_GARDEN      = .TRUE.
  DTT%LDATA_GREENROOF   = .TRUE.
  DTT%LDATA_ROAD_DIR    = .FALSE.
  DTT%LDATA_ALB_ROOF    = .TRUE.
  DTT%LDATA_EMIS_ROOF   = .TRUE.
  DTT%LDATA_HC_ROOF     = .TRUE.
  DTT%LDATA_TC_ROOF     = .TRUE.
  DTT%LDATA_D_ROOF      = .TRUE.
  DTT%LDATA_ALB_ROAD    = .TRUE.
  DTT%LDATA_EMIS_ROAD   = .TRUE.
  DTT%LDATA_HC_ROAD     = .TRUE.
  DTT%LDATA_TC_ROAD     = .TRUE.
  DTT%LDATA_D_ROAD      = .TRUE.
  DTT%LDATA_ALB_WALL    = .TRUE.
  DTT%LDATA_EMIS_WALL   = .TRUE.
  DTT%LDATA_HC_WALL     = .TRUE.
  DTT%LDATA_TC_WALL     = .TRUE.
  DTT%LDATA_D_WALL      = .TRUE.
  DTT%LDATA_BLD_HEIGHT  = .TRUE.
  DTT%LDATA_WALL_O_HOR  = .TRUE.
  DTT%LDATA_H_TRAFFIC   = .TRUE.
  DTT%LDATA_LE_TRAFFIC  = .TRUE.
  DTT%LDATA_H_INDUSTRY  = .TRUE.
  DTT%LDATA_LE_INDUSTRY = .TRUE.
  DTT%LDATA_ROUGH_ROOF  = .FALSE.
  DTT%LDATA_ROUGH_WALL  = .FALSE.
  DTT%LDATA_RESIDENTIAL = .FALSE.
  !
ELSEIF (IVERSION>=7) THEN
  !
  IF (IVERSION>7 .OR. IBUGFIX>=3) THEN
    YRECFM='L_BLDTYPE'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_BLDTYPE,IRESP)
    YRECFM='L_BLD_AGE'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_BLD_AGE,IRESP)
    YRECFM='L_USETYPE'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_USETYPE,IRESP)
    IF (DTT%LDATA_BLDTYPE .OR. DTT%LDATA_BLD_AGE .OR. DTT%LDATA_USETYPE) CALL READ_BLD_DESCRIPTION_n(&
                                                                                                     BDD, &
                                                                                                     HPROGRAM)
  ENDIF
  YRECFM='L_Z0_TOWN'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_Z0_TOWN,IRESP)
  YRECFM='L_BLD'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_BLD,IRESP)
  IF (IVERSION>=6) THEN
    YRECFM='L_GARDEN'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_GARDEN,IRESP)
  ENDIF
  IF (IVERSION==7 .AND. IBUGFIX<=2) THEN
    DTT%LDATA_ROAD_DIR = .FALSE.
    DTT%LDATA_GREENROOF= .FALSE.
  ELSE
    YRECFM='L_ROAD_DIR'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_ROAD_DIR,IRESP)
    YRECFM='L_GREENROOF'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_GREENROOF,IRESP)
  END IF
  IF (IVERSION==7 .AND. IBUGFIX<=3) THEN
    DTT%LDATA_EMIS_PANEL = .FALSE.
    DTT%LDATA_ALB_PANEL  = .FALSE.
    DTT%LDATA_EFF_PANEL  = .FALSE.
    DTT%LDATA_FRAC_PANEL = .FALSE.
  ELSE
    YRECFM='L_EMIS_PANEL'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_EMIS_PANEL,IRESP)
    YRECFM='L_ALB_PANEL'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_ALB_PANEL,IRESP)
    YRECFM='L_EFF_PANEL'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_EFF_PANEL,IRESP)
    YRECFM='L_FRAC_PANEL'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_FRAC_PANEL,IRESP)
  END IF
  YRECFM='L_ALB_ROOF'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_ALB_ROOF,IRESP)
  YRECFM='L_EMIS_ROOF'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_EMIS_ROOF,IRESP)
  YRECFM='L_HC_ROOF'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_HC_ROOF,IRESP)
  YRECFM='L_TC_ROOF'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_TC_ROOF,IRESP)
  YRECFM='L_D_ROOF'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_D_ROOF,IRESP)
  YRECFM='L_ALB_ROAD'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_ALB_ROAD,IRESP)
  YRECFM='L_EMIS_ROAD'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_EMIS_ROAD,IRESP)
  YRECFM='L_HC_ROAD'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_HC_ROAD,IRESP)
  YRECFM='L_TC_ROAD'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_TC_ROAD,IRESP)
  YRECFM='L_D_ROAD'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_D_ROAD,IRESP)
  YRECFM='L_ALB_WALL'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_ALB_WALL,IRESP)
  YRECFM='L_EMIS_WALL'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_EMIS_WALL,IRESP)
  YRECFM='L_HC_WALL'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_HC_WALL,IRESP)
  YRECFM='L_TC_WALL'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_TC_WALL,IRESP)
  YRECFM='L_D_WALL'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_D_WALL,IRESP)
  YRECFM='L_BLD_HEIGHT'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_BLD_HEIGHT,IRESP)
  YRECFM='L_WALL_O_HOR'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_WALL_O_HOR,IRESP)
  YRECFM='L_H_TRAF'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_H_TRAFFIC,IRESP)
  YRECFM='L_LE_TRAF'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_LE_TRAFFIC,IRESP)
  YRECFM='L_H_IND'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_H_INDUSTRY,IRESP)
  YRECFM='L_LE_IND'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_LE_INDUSTRY,IRESP)
  IF (IVERSION>7 .OR. IBUGFIX>=3) THEN
    YRECFM='L_ROUGH_ROOF'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_ROUGH_ROOF,IRESP)
    YRECFM='L_ROUGH_WALL'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_ROUGH_WALL,IRESP)
  ENDIF
  IF (IVERSION>7) THEN
    YRECFM='L_F_RESIDENT'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%LDATA_RESIDENTIAL,IRESP)
  ENDIF
  !
  IF (TOP%CBEM=='BEM') THEN
    YRECFM='L_HC_FLOOR'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%LDATA_HC_FLOOR,IRESP)
    YRECFM='L_TC_FLOOR'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%LDATA_TC_FLOOR,IRESP)
    YRECFM='L_D_FLOOR'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%LDATA_D_FLOOR,IRESP)            
    YRECFM='L_TCOOL_TARG'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%LDATA_TCOOL_TARGET,IRESP)
    YRECFM='L_THEAT_TARG'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%LDATA_THEAT_TARGET,IRESP)
    YRECFM='L_F_WAST_CAN'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%LDATA_F_WASTE_CAN,IRESP)
    YRECFM='L_EFF_HEAT'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%LDATA_EFF_HEAT,IRESP)
    YRECFM='L_QIN'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%LDATA_QIN,IRESP)
    YRECFM='L_QIN_FRAD'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%LDATA_QIN_FRAD,IRESP)
    YRECFM='L_SHGC'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%LDATA_SHGC,IRESP)
    YRECFM='L_U_WIN'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%LDATA_U_WIN,IRESP)
    YRECFM='L_GR'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%LDATA_GR,IRESP)
    YRECFM='L_SHGC_SH'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%LDATA_SHGC_SH,IRESP)    
    YRECFM='L_FLOOR_HEIG'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%LDATA_FLOOR_HEIGHT,IRESP)
    YRECFM='L_INF'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%LDATA_INF,IRESP)
    YRECFM='L_FWAT_COND'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%LDATA_F_WATER_COND,IRESP)
    YRECFM='L_SHADE'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%LDATA_SHADE,IRESP) 
    YRECFM='L_NATVENT'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%LDATA_NATVENT,IRESP)     
    YRECFM='L_V_VENT'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%LDATA_V_VENT,IRESP)    
    YRECFM='L_QIN_FLAT'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%LDATA_QIN_FLAT,IRESP)
    YRECFM='L_HR_TARGET'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%LDATA_HR_TARGET,IRESP)
    YRECFM='L_CAP_SYS_HE'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%LDATA_CAP_SYS_HEAT,IRESP)
    YRECFM='L_CAP_SYS_RA'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%LDATA_CAP_SYS_RAT,IRESP)
    YRECFM='L_T_ADP'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%LDATA_T_ADP,IRESP)
    YRECFM='L_M_SYS_RAT'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%LDATA_M_SYS_RAT,IRESP)
    YRECFM='L_COP_RAT'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%LDATA_COP_RAT,IRESP)
    YRECFM='L_T_SIZE_MAX'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%LDATA_T_SIZE_MAX,IRESP)
    YRECFM='L_T_SIZE_MIN'
    CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%LDATA_T_SIZE_MIN,IRESP)
  ENDIF
  !
ENDIF
!
!* read number of layers if thermal properties are specified
!
IF (DTT%LDATA_HC_ROOF) THEN
  YRECFM='PAR_RF_LAYER'
  IF (IVERSION<7 .OR. (IVERSION==7 .AND. IBUGFIX<=2)) YRECFM='ROOF_LAYER'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%NPAR_ROOF_LAYER,IRESP)
END IF
!
IF (DTT%LDATA_HC_ROAD) THEN
  YRECFM='PAR_RD_LAYER'
  IF (IVERSION<7 .OR. (IVERSION==7 .AND. IBUGFIX<=2)) YRECFM='ROAD_LAYER'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%NPAR_ROAD_LAYER,IRESP)
END IF
!
IF (DTT%LDATA_HC_WALL) THEN
  YRECFM='PAR_WL_LAYER'
  IF (IVERSION<7 .OR. (IVERSION==7 .AND. IBUGFIX<=2)) YRECFM='WALL_LAYER'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTT%NPAR_WALL_LAYER,IRESP)
END IF
!
IF (DTB%LDATA_HC_FLOOR) THEN
  YRECFM='PAR_FL_LAYER'
  IF (IVERSION<7 .OR. (IVERSION==7 .AND. IBUGFIX<=2)) YRECFM='FLOOR_LAYER'
  CALL READ_SURF(&
                HPROGRAM,YRECFM,DTB%NPAR_FLOOR_LAYER,IRESP)
END IF
!
!* read specified fields
!
IF (DTT%LDATA_BLDTYPE .AND. .NOT. DTT%LDATA_BLDTYPE) THEN
  CALL ABOR1_SFX('FATAL ERROR: Building type is prescribed but not the building age')
END IF
!
IF (DTT%LDATA_BLDTYPE) THEN
  ALLOCATE(DTT%NPAR_BLDTYPE     (TG%NDIM))    
  YRECFM='D_BLDTYPE'
  CALL READ_FIELD(YRECFM,ZWORK,HDIRIN)
  DTT%NPAR_BLDTYPE(:) = NINT(ZWORK)
ENDIF
!
IF (DTT%LDATA_BLD_AGE) THEN
  ALLOCATE(DTT%NPAR_BLD_AGE     (TG%NDIM))    
  YRECFM='D_BLD_AGE'
  CALL READ_FIELD(YRECFM,ZWORK,HDIRIN)
  DTT%NPAR_BLD_AGE(:) = NINT(ZWORK)
ENDIF
!
IF (DTT%LDATA_BLDTYPE .AND. DTT%LDATA_BLDTYPE) THEN
  ALLOCATE(DTT%NPAR_BLDCODE(TG%NDIM))
  DTT%NPAR_BLDCODE=BLDCODE(BDD, DTT%NPAR_BLDTYPE,DTT%NPAR_BLD_AGE)
END IF
!
IF (DTT%LDATA_USETYPE) THEN
  ALLOCATE(DTT%NPAR_USETYPE     (TG%NDIM))    
  YRECFM='D_USETYPE'
  CALL READ_FIELD(YRECFM,ZWORK,HDIRIN)
  DTT%NPAR_USETYPE(:) = NINT(ZWORK)
ENDIF
!
IF (DTT%LDATA_Z0_TOWN) THEN
  ALLOCATE(DTT%XPAR_Z0_TOWN     (TG%NDIM))
  YRECFM='D_Z0_TOWN'
  CALL READ_FIELD(YRECFM,DTT%XPAR_Z0_TOWN,HDIRIN)
ENDIF
!
IF (DTT%LDATA_BLD) THEN
  ALLOCATE(DTT%XPAR_BLD         (TG%NDIM))
  YRECFM='D_BLD'
  CALL READ_FIELD(YRECFM,DTT%XPAR_BLD,HDIRIN)
ENDIF
!
IF (IVERSION>=6) THEN
  IF (DTT%LDATA_GARDEN) THEN
    ALLOCATE(DTT%XPAR_GARDEN      (TG%NDIM))
    YRECFM='D_GARDEN'
    CALL READ_FIELD(YRECFM,DTT%XPAR_GARDEN,HDIRIN)
  ENDIF
!
ENDIF
!
IF (DTT%LDATA_GREENROOF) THEN
  ALLOCATE(DTT%XPAR_GREENROOF    (TG%NDIM))
  YRECFM='D_GREENROOF'
  CALL READ_FIELD(YRECFM,DTT%XPAR_GREENROOF,HDIRIN)
ENDIF
!
IF (DTT%LDATA_ROAD_DIR) THEN
  ALLOCATE(DTT%XPAR_ROAD_DIR    (TG%NDIM))
  YRECFM='D_ROAD_DIR'
  CALL READ_FIELD(YRECFM,DTT%XPAR_ROAD_DIR,HDIRIN)
ENDIF
!
IF (DTT%LDATA_ALB_ROOF) THEN
  ALLOCATE(DTT%XPAR_ALB_ROOF    (TG%NDIM))        
  YRECFM='D_ALB_ROOF'
  CALL READ_FIELD(YRECFM,DTT%XPAR_ALB_ROOF,HDIRIN)
ENDIF
!
IF (DTT%LDATA_EMIS_ROOF) THEN
  ALLOCATE(DTT%XPAR_EMIS_ROOF   (TG%NDIM))        
  YRECFM='D_EMI_ROOF'
  CALL READ_FIELD(YRECFM,DTT%XPAR_EMIS_ROOF,HDIRIN)
ENDIF
!
IF (DTT%LDATA_HC_ROOF) THEN
  ALLOCATE(DTT%XPAR_HC_ROOF     (TG%NDIM,DTT%NPAR_ROOF_LAYER))
  DO JLAYER=1,DTT%NPAR_ROOF_LAYER
    WRITE(YRECFM,FMT='(A9,I1.1)') 'D_HC_ROOF',JLAYER
    CALL READ_FIELD(YRECFM,DTT%XPAR_HC_ROOF(:,JLAYER),HDIRIN)
  END DO
ENDIF
!
IF (DTT%LDATA_TC_ROOF) THEN
  ALLOCATE(DTT%XPAR_TC_ROOF     (TG%NDIM,DTT%NPAR_ROOF_LAYER))
  DO JLAYER=1,DTT%NPAR_ROOF_LAYER
    WRITE(YRECFM,FMT='(A9,I1.1)') 'D_TC_ROOF',JLAYER
    CALL READ_FIELD(YRECFM,DTT%XPAR_TC_ROOF(:,JLAYER),HDIRIN)
  END DO
ENDIF
!
IF (DTT%LDATA_D_ROOF) THEN
  ALLOCATE(DTT%XPAR_D_ROOF      (TG%NDIM,DTT%NPAR_ROOF_LAYER))
  DO JLAYER=1,DTT%NPAR_ROOF_LAYER
    WRITE(YRECFM,FMT='(A8,I1.1)') 'D_D_ROOF',JLAYER
    CALL READ_FIELD(YRECFM,DTT%XPAR_D_ROOF(:,JLAYER),HDIRIN)
  END DO
ENDIF
!
IF (DTT%LDATA_ALB_ROAD) THEN
  ALLOCATE(DTT%XPAR_ALB_ROAD    (TG%NDIM))
  YRECFM='D_ALB_ROAD'
  CALL READ_FIELD(YRECFM,DTT%XPAR_ALB_ROAD,HDIRIN)
ENDIF
!
IF (DTT%LDATA_EMIS_ROAD) THEN
  ALLOCATE(DTT%XPAR_EMIS_ROAD   (TG%NDIM))
  YRECFM='D_EMI_ROAD'
  CALL READ_FIELD(YRECFM,DTT%XPAR_EMIS_ROAD,HDIRIN)
ENDIF
!
IF (DTT%LDATA_HC_ROAD) THEN
  ALLOCATE(DTT%XPAR_HC_ROAD     (TG%NDIM,DTT%NPAR_ROAD_LAYER))
  DO JLAYER=1,DTT%NPAR_ROAD_LAYER
    WRITE(YRECFM,FMT='(A9,I1.1)') 'D_HC_ROAD',JLAYER
    CALL READ_FIELD(YRECFM,DTT%XPAR_HC_ROAD(:,JLAYER),HDIRIN)
  END DO
ENDIF
!
IF (DTT%LDATA_TC_ROAD) THEN
  ALLOCATE(DTT%XPAR_TC_ROAD     (TG%NDIM,DTT%NPAR_ROAD_LAYER))
  DO JLAYER=1,DTT%NPAR_ROAD_LAYER
    WRITE(YRECFM,FMT='(A9,I1.1)') 'D_TC_ROAD',JLAYER
    CALL READ_FIELD(YRECFM,DTT%XPAR_TC_ROAD(:,JLAYER),HDIRIN)
  END DO
ENDIF
!
IF (DTT%LDATA_D_ROAD) THEN
  ALLOCATE(DTT%XPAR_D_ROAD      (TG%NDIM,DTT%NPAR_ROAD_LAYER))
  DO JLAYER=1,DTT%NPAR_ROAD_LAYER
    WRITE(YRECFM,FMT='(A8,I1.1)') 'D_D_ROAD',JLAYER
    CALL READ_FIELD(YRECFM,DTT%XPAR_D_ROAD(:,JLAYER),HDIRIN)
  END DO
ENDIF
!
IF (DTT%LDATA_ALB_WALL) THEN
  ALLOCATE(DTT%XPAR_ALB_WALL    (TG%NDIM))
  YRECFM='D_ALB_WALL'
  CALL READ_FIELD(YRECFM,DTT%XPAR_ALB_WALL,HDIRIN)
ENDIF
!
IF (DTT%LDATA_EMIS_WALL) THEN
  ALLOCATE(DTT%XPAR_EMIS_WALL   (TG%NDIM))
  YRECFM='D_EMI_WALL'
  CALL READ_FIELD(YRECFM,DTT%XPAR_EMIS_WALL,HDIRIN)
ENDIF
!
IF (DTT%LDATA_HC_WALL) THEN
  ALLOCATE(DTT%XPAR_HC_WALL     (TG%NDIM,DTT%NPAR_WALL_LAYER))
  DO JLAYER=1,DTT%NPAR_WALL_LAYER
    WRITE(YRECFM,FMT='(A9,I1.1)') 'D_HC_WALL',JLAYER
    CALL READ_FIELD(YRECFM,DTT%XPAR_HC_WALL(:,JLAYER),HDIRIN)
  END DO
ENDIF
!
IF (DTT%LDATA_TC_WALL) THEN
  ALLOCATE(DTT%XPAR_TC_WALL     (TG%NDIM,DTT%NPAR_WALL_LAYER))
  DO JLAYER=1,DTT%NPAR_WALL_LAYER
    WRITE(YRECFM,FMT='(A9,I1.1)') 'D_TC_WALL',JLAYER
    CALL READ_FIELD(YRECFM,DTT%XPAR_TC_WALL(:,JLAYER),HDIRIN)
  END DO
ENDIF
!
IF (DTT%LDATA_D_WALL) THEN
  ALLOCATE(DTT%XPAR_D_WALL      (TG%NDIM,DTT%NPAR_WALL_LAYER))
  DO JLAYER=1,DTT%NPAR_WALL_LAYER
    WRITE(YRECFM,FMT='(A8,I1.1)') 'D_D_WALL',JLAYER
    CALL READ_FIELD(YRECFM,DTT%XPAR_D_WALL(:,JLAYER),HDIRIN)
  END DO
ENDIF
!
IF (DTT%LDATA_BLD_HEIGHT) THEN
  ALLOCATE(DTT%XPAR_BLD_HEIGHT  (TG%NDIM))
  YRECFM='D_BLD_HEIG'
  CALL READ_FIELD(YRECFM,DTT%XPAR_BLD_HEIGHT,HDIRIN)
ENDIF
!
IF (DTT%LDATA_WALL_O_HOR) THEN
  ALLOCATE(DTT%XPAR_WALL_O_HOR  (TG%NDIM))
  YRECFM='D_WALL_O_H'
  CALL READ_FIELD(YRECFM,DTT%XPAR_WALL_O_HOR,HDIRIN)
ENDIF
!
IF (DTT%LDATA_H_TRAFFIC) THEN
  ALLOCATE(DTT%XPAR_H_TRAFFIC   (TG%NDIM))
  YRECFM='D_H_TRAF'
  CALL READ_FIELD(YRECFM,DTT%XPAR_H_TRAFFIC,HDIRIN)
ENDIF
!
IF (DTT%LDATA_LE_TRAFFIC) THEN
  ALLOCATE(DTT%XPAR_LE_TRAFFIC  (TG%NDIM))
  YRECFM='D_LE_TRAF'
  CALL READ_FIELD(YRECFM,DTT%XPAR_LE_TRAFFIC,HDIRIN)
ENDIF
!
IF (DTT%LDATA_H_INDUSTRY) THEN
  ALLOCATE(DTT%XPAR_H_INDUSTRY  (TG%NDIM))
  YRECFM='D_H_IND'
  CALL READ_FIELD(YRECFM,DTT%XPAR_H_INDUSTRY,HDIRIN)
ENDIF
!
IF (DTT%LDATA_LE_INDUSTRY) THEN
  ALLOCATE(DTT%XPAR_LE_INDUSTRY (TG%NDIM))
  YRECFM='D_LE_IND'
  CALL READ_FIELD(YRECFM,DTT%XPAR_LE_INDUSTRY,HDIRIN)
ENDIF
!
IF (DTT%LDATA_ROUGH_ROOF) THEN
  ALLOCATE(DTT%XPAR_ROUGH_ROOF (TG%NDIM))
  YRECFM='D_ROUGH_ROOF'
  CALL READ_FIELD(YRECFM,DTT%XPAR_ROUGH_ROOF,HDIRIN)
ENDIF
!
IF (DTT%LDATA_ROUGH_WALL) THEN
  ALLOCATE(DTT%XPAR_ROUGH_WALL (TG%NDIM))
  YRECFM='D_ROUGH_WALL'
  CALL READ_FIELD(YRECFM,DTT%XPAR_ROUGH_WALL,HDIRIN)
ENDIF
!
IF (DTT%LDATA_RESIDENTIAL) THEN
  ALLOCATE(DTT%XPAR_RESIDENTIAL (TG%NDIM))
  YRECFM='D_F_RESIDENT'
  CALL READ_FIELD(YRECFM,DTT%XPAR_RESIDENTIAL,HDIRIN)
ENDIF
!
! solar panels
!
IF (DTT%LDATA_EMIS_PANEL) THEN
  ALLOCATE(DTT%XPAR_EMIS_PANEL (TG%NDIM))
  YRECFM='D_EMIS_PANEL'
  CALL READ_FIELD(YRECFM,DTT%XPAR_EMIS_PANEL,HDIRIN)
ENDIF
!
IF (DTT%LDATA_ALB_PANEL) THEN
  ALLOCATE(DTT%XPAR_ALB_PANEL (TG%NDIM))
  YRECFM='D_ALB_PANEL'
  CALL READ_FIELD(YRECFM,DTT%XPAR_ALB_PANEL,HDIRIN)
ENDIF
!
IF (DTT%LDATA_EFF_PANEL) THEN
  ALLOCATE(DTT%XPAR_EFF_PANEL (TG%NDIM))
  YRECFM='D_EFF_PANEL'
  CALL READ_FIELD(YRECFM,DTT%XPAR_EFF_PANEL,HDIRIN)
ENDIF
!
IF (DTT%LDATA_FRAC_PANEL) THEN
  ALLOCATE(DTT%XPAR_FRAC_PANEL (TG%NDIM))
  YRECFM='D_FRAC_PANEL'
  CALL READ_FIELD(YRECFM,DTT%XPAR_FRAC_PANEL,HDIRIN)
ENDIF
!
!* Building Energy Model
!
IF (TOP%CBEM=='BEM') THEN
  !

  IF (DTB%LDATA_HC_FLOOR) THEN
    ALLOCATE(DTB%XPAR_HC_FLOOR    (TG%NDIM,DTB%NPAR_FLOOR_LAYER))
    DO JLAYER=1,DTB%NPAR_FLOOR_LAYER
      WRITE(YRECFM,FMT='(A10,I1.1)') 'D_HC_FLOOR',JLAYER
      CALL READ_FIELD(YRECFM,DTB%XPAR_HC_FLOOR(:,JLAYER),HDIRIN)
    END DO
  ENDIF
  !
  IF (DTB%LDATA_TC_FLOOR) THEN
    ALLOCATE(DTB%XPAR_TC_FLOOR    (TG%NDIM,DTB%NPAR_FLOOR_LAYER))
    DO JLAYER=1,DTB%NPAR_FLOOR_LAYER
      WRITE(YRECFM,FMT='(A10,I1.1)') 'D_TC_FLOOR',JLAYER
      CALL READ_FIELD(YRECFM,DTB%XPAR_TC_FLOOR(:,JLAYER),HDIRIN)
    END DO
  ENDIF
  !
  IF (DTB%LDATA_D_FLOOR) THEN
    ALLOCATE(DTB%XPAR_D_FLOOR     (TG%NDIM,DTB%NPAR_FLOOR_LAYER))
    DO JLAYER=1,DTB%NPAR_FLOOR_LAYER
      WRITE(YRECFM,FMT='(A9,I1.1)') 'D_D_FLOOR',JLAYER
      CALL READ_FIELD(YRECFM,DTB%XPAR_D_FLOOR(:,JLAYER),HDIRIN)
    END DO
  ENDIF
  !
  IF (DTB%LDATA_TCOOL_TARGET) THEN
    ALLOCATE(DTB%XPAR_TCOOL_TARGET  (TG%NDIM))
    YRECFM='D_TCOOL_TARG'
    CALL READ_FIELD(YRECFM,DTB%XPAR_TCOOL_TARGET,HDIRIN)
  ENDIF
  !
  IF (DTB%LDATA_THEAT_TARGET) THEN
    ALLOCATE(DTB%XPAR_THEAT_TARGET  (TG%NDIM))
    YRECFM='D_THEAT_TARG'
    CALL READ_FIELD(YRECFM,DTB%XPAR_THEAT_TARGET,HDIRIN)
  ENDIF
  !
  IF (DTB%LDATA_F_WASTE_CAN) THEN
    ALLOCATE(DTB%XPAR_F_WASTE_CAN   (TG%NDIM))
    YRECFM='D_F_WAST_CAN'
    CALL READ_FIELD(YRECFM,DTB%XPAR_F_WASTE_CAN,HDIRIN)
  ENDIF
  !
  IF (DTB%LDATA_EFF_HEAT) THEN
    ALLOCATE(DTB%XPAR_EFF_HEAT      (TG%NDIM))
    YRECFM='D_EFF_HEAT'
    CALL READ_FIELD(YRECFM,DTB%XPAR_EFF_HEAT,HDIRIN)
  ENDIF
  !
  IF (DTB%LDATA_QIN) THEN
    ALLOCATE(DTB%XPAR_QIN           (TG%NDIM))
    YRECFM='D_QIN'
    CALL READ_FIELD(YRECFM,DTB%XPAR_QIN,HDIRIN)
  ENDIF
  !
  IF (DTB%LDATA_QIN_FRAD) THEN
    ALLOCATE(DTB%XPAR_QIN_FRAD      (TG%NDIM))
    YRECFM='D_QIN_FRAD'
    CALL READ_FIELD(YRECFM,DTB%XPAR_QIN_FRAD,HDIRIN)
  ENDIF
  !
  IF (DTB%LDATA_SHGC) THEN
    ALLOCATE(DTB%XPAR_SHGC          (TG%NDIM))
    YRECFM='D_SHGC'
    CALL READ_FIELD(YRECFM,DTB%XPAR_SHGC,HDIRIN)
  ENDIF
  !
  IF (DTB%LDATA_U_WIN) THEN
    ALLOCATE(DTB%XPAR_U_WIN         (TG%NDIM))
    YRECFM='D_U_WIN'
    CALL READ_FIELD(YRECFM,DTB%XPAR_U_WIN,HDIRIN)
  ENDIF
  !
  IF (DTB%LDATA_GR) THEN
    ALLOCATE(DTB%XPAR_GR            (TG%NDIM))
    YRECFM='D_GR'
    CALL READ_FIELD(YRECFM,DTB%XPAR_GR,HDIRIN)
  ENDIF
  !
  IF (DTB%LDATA_SHGC_SH) THEN
    ALLOCATE(DTB%XPAR_SHGC_SH       (TG%NDIM))
    YRECFM='D_SHGC_SH'
    CALL READ_FIELD(YRECFM,DTB%XPAR_SHGC_SH,HDIRIN)
  ENDIF
  !
  IF (DTB%LDATA_FLOOR_HEIGHT) THEN
    ALLOCATE(DTB%XPAR_FLOOR_HEIGHT  (TG%NDIM))
    YRECFM='D_FLOOR_HEIG'
    CALL READ_FIELD(YRECFM,DTB%XPAR_FLOOR_HEIGHT,HDIRIN)
  ENDIF
  !
  IF (DTB%LDATA_INF) THEN
    ALLOCATE(DTB%XPAR_INF           (TG%NDIM))
    YRECFM='D_INF'
    CALL READ_FIELD(YRECFM,DTB%XPAR_INF,HDIRIN)
  ENDIF
  !
  IF (DTB%LDATA_F_WATER_COND) THEN
     ALLOCATE(DTB%XPAR_F_WATER_COND (TG%NDIM))
    YRECFM='D_FWAT_COND'
    CALL READ_FIELD(YRECFM,DTB%XPAR_F_WATER_COND,HDIRIN)
  ENDIF
  !
  IF (DTB%LDATA_SHADE) THEN
    ALLOCATE(DTB%XPAR_SHADE        (TG%NDIM))
    YRECFM='D_SHADE'
    CALL READ_FIELD(YRECFM,DTB%XPAR_SHADE,HDIRIN)
    DTB%XPAR_SHADE=FLOAT(NINT(DTB%XPAR_SHADE))
  ENDIF
  !
  IF (DTB%LDATA_NATVENT) THEN
    ALLOCATE(DTB%XPAR_NATVENT      (TG%NDIM))
    YRECFM='D_NATVENT'
    CALL READ_FIELD(YRECFM,DTB%XPAR_NATVENT,HDIRIN)
    DTB%XPAR_NATVENT=FLOAT(NINT(DTB%XPAR_NATVENT))
  ENDIF
  !  
  IF (DTB%LDATA_QIN_FLAT) THEN
    ALLOCATE(DTB%XPAR_QIN_FLAT     (TG%NDIM))
    YRECFM='D_QIN_FLAT'
    CALL READ_FIELD(YRECFM,DTB%XPAR_QIN_FLAT,HDIRIN)
  ENDIF
  !
  IF (DTB%LDATA_HR_TARGET) THEN
    ALLOCATE(DTB%XPAR_HR_TARGET    (TG%NDIM))
    YRECFM='D_HR_TARGET'
    CALL READ_FIELD(YRECFM,DTB%XPAR_HR_TARGET,HDIRIN)
  ENDIF
  !
  IF (DTB%LDATA_V_VENT) THEN
    ALLOCATE(DTB%XPAR_V_VENT       (TG%NDIM))
    YRECFM='D_V_VENT'
    CALL READ_FIELD(YRECFM,DTB%XPAR_V_VENT,HDIRIN)
  ENDIF
  !
  IF (DTB%LDATA_CAP_SYS_HEAT) THEN
    ALLOCATE(DTB%XPAR_CAP_SYS_HEAT (TG%NDIM))
    YRECFM='D_CAP_SYS_HE'
    CALL READ_FIELD(YRECFM,DTB%XPAR_CAP_SYS_HEAT,HDIRIN)
  ENDIF
  !
  IF (DTB%LDATA_CAP_SYS_RAT) THEN
    ALLOCATE(DTB%XPAR_CAP_SYS_RAT  (TG%NDIM))
    YRECFM='D_CAP_SYS_RA'
    CALL READ_FIELD(YRECFM,DTB%XPAR_CAP_SYS_RAT,HDIRIN)
  ENDIF
  !
  IF (DTB%LDATA_T_ADP) THEN
    ALLOCATE(DTB%XPAR_T_ADP        (TG%NDIM))
    YRECFM='D_T_ADP'
    CALL READ_FIELD(YRECFM,DTB%XPAR_T_ADP,HDIRIN)
  ENDIF
  !
  IF (DTB%LDATA_M_SYS_RAT) THEN
    ALLOCATE(DTB%XPAR_M_SYS_RAT    (TG%NDIM))
    YRECFM='D_M_SYS_RAT'
    CALL READ_FIELD(YRECFM,DTB%XPAR_M_SYS_RAT,HDIRIN)
  ENDIF
  !
  IF (DTB%LDATA_COP_RAT) THEN
    ALLOCATE(DTB%XPAR_COP_RAT      (TG%NDIM))
    YRECFM='D_COP_RAT'
    CALL READ_FIELD(YRECFM,DTB%XPAR_COP_RAT,HDIRIN)
  ENDIF
  !
  IF (DTB%LDATA_T_SIZE_MAX) THEN
    ALLOCATE(DTB%XPAR_T_SIZE_MAX   (TG%NDIM))
    YRECFM='D_T_SIZE_MAX'
    CALL READ_FIELD(YRECFM,DTB%XPAR_T_SIZE_MAX,HDIRIN)
  ENDIF
  !
  IF (DTB%LDATA_T_SIZE_MIN) THEN
    ALLOCATE(DTB%XPAR_T_SIZE_MIN   (TG%NDIM))
    YRECFM='D_T_SIZE_MIN'
    CALL READ_FIELD(YRECFM,DTB%XPAR_T_SIZE_MIN,HDIRIN)
  ENDIF
  !
ENDIF
!
IF (LHOOK) CALL DR_HOOK('READ_PGD_TEB_PAR_N',1,ZHOOK_HANDLE)
!
!-------------------------------------------------------------------------------
CONTAINS
!-------------------------------------------------------------------------------
!
SUBROUTINE READ_FIELD(HRECFM,PFIELD,YDIR)
!
USE MODI_HOR_INTERPOL
!
IMPLICIT NONE
!
 CHARACTER(LEN=*),     INTENT(IN)  :: HRECFM ! name of record in the file
REAL, DIMENSION(TG%NDIM), INTENT(OUT) :: PFIELD
 CHARACTER(LEN=1),     INTENT(IN)  :: YDIR
!
REAL, DIMENSION(KNI)              :: ZF
REAL, DIMENSION(:,:), POINTER     :: ZIN
REAL, DIMENSION(TG%NDIM,1)           :: ZOUT
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('READ_PGD_TEB_PAR_N:READ_FIELD',0,ZHOOK_HANDLE)
!
IF (YDIR=='A') THEN
  !
  CALL READ_SURF(&
                HPROGRAM,HRECFM,ZF,IRESP,HDIR='A')
  ALLOCATE(ZIN(KNI,1))
  ZIN(:,1) = ZF(:)
  CALL HOR_INTERPOL(DTCO, U, &
                    ILUOUT,ZIN,ZOUT)
  DEALLOCATE(ZIN)
  PFIELD(:) = ZOUT(:,1)
  !
ELSE
  CALL READ_SURF(&
                HPROGRAM,HRECFM,PFIELD,IRESP)
ENDIF
!
IF (LHOOK) CALL DR_HOOK('READ_PGD_TEB_PAR_N:READ_FIELD',1,ZHOOK_HANDLE)
!
END SUBROUTINE READ_FIELD
!_______________________________
!
END SUBROUTINE READ_PGD_TEB_PAR_n
