!     #########
      SUBROUTINE READ_PGD_TEB_GARDEN_PAR_n (&
                                             DTGD, TGDO, TGDP, TG, &
                                            HPROGRAM)
!     ################################################
!
!!****  *READ_PGD_TEB_GARDEN_PAR_n* - reads ISBA physiographic fields
!!                        
!!
!!    PURPOSE
!!    -------
!!
!!**  METHOD
!!    ------
!!
!!    EXTERNAL
!!    --------
!!
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!
!!    AUTHOR
!!    ------
!!      V. Masson   *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    01/2003 
!!      P. Le Moigne 12/2004 : add type of photosynthesis
!!      R. Alkama    05/2012 : Add 7 new vegtypes (19 rather than 12)
!!      B. Decharme    05/13 : new param for equatorial forest
!-------------------------------------------------------------------------------
!
!*       0.    DECLARATIONS
!              ------------
!
!
!
!
!
USE MODD_DATA_TEB_GARDEN_n, ONLY : DATA_TEB_GARDEN_t
USE MODD_TEB_GARDEN_OPTION_n, ONLY : TEB_GARDEN_OPTIONS_t
USE MODD_TEB_GARDEN_PGD_n, ONLY : TEB_GARDEN_PGD_t
USE MODD_TEB_GRID_n, ONLY : TEB_GRID_t
!
USE MODD_CSTS,              ONLY : XDAY
USE MODD_SURF_PAR,          ONLY : XUNDEF
USE MODD_ISBA_PAR,          ONLY : XOPTIMGRID, NOPTIMLAYER
USE MODD_DATA_COVER_PAR,    ONLY : NVT_NO, NVT_ROCK, NVT_SNOW, NVT_TEBD,     & 
                                     NVT_BONE, NVT_TRBE, NVT_C3, NVT_C4,     &
                                     NVT_IRR, NVT_GRAS, NVT_TROG,NVT_PARK,   &
                                     NVT_TRBD, NVT_TEBE, NVT_TENE, NVT_BOBD, &
                                     NVT_BOND, NVT_BOGR, NVT_SHRB, NVEGTYPE
!
USE MODI_READ_SURF
USE MODI_VEG_FROM_LAI
USE MODI_Z0V_FROM_LAI
USE MODI_EMIS_FROM_VEG
USE MODI_DRY_WET_SOIL_ALBEDOS
USE MODI_SOIL_ALBEDO
USE MODI_ABOR1_SFX
!
USE MODD_REPROD_OPER,    ONLY : XEVERG_RSMIN
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*       0.1   Declarations of arguments
!              -------------------------
!
!
!
!
TYPE(DATA_TEB_GARDEN_t), INTENT(INOUT) :: DTGD
TYPE(TEB_GARDEN_OPTIONS_t), INTENT(INOUT) :: TGDO
TYPE(TEB_GARDEN_PGD_t), INTENT(INOUT) :: TGDP
TYPE(TEB_GRID_t), INTENT(INOUT) :: TG
!
 CHARACTER(LEN=6),  INTENT(IN)  :: HPROGRAM ! program calling
!
!*       0.2   Declarations of local variables
!              -------------------------------
!
INTEGER                               :: IRESP          ! IRESP  : return-code if a problem appears
CHARACTER(LEN=12)                     :: YRECFM         ! Name of the article to be read
CHARACTER(LEN=100)                    :: YCOMMENT       ! Comment string
INTEGER                               :: JI, JLAYER     ! loop index
INTEGER                               :: JTIME          ! loop index
!
REAL, DIMENSION(TG%NDIM,3)               :: ZDATA_RSMIN
REAL, DIMENSION(TG%NDIM,3)               :: ZDATA_GAMMA
REAL, DIMENSION(TG%NDIM,3)               :: ZDATA_WRMAX_CF
REAL, DIMENSION(TG%NDIM,3)               :: ZDATA_RGL
REAL, DIMENSION(TG%NDIM,3)               :: ZDATA_CV
REAL, DIMENSION(TG%NDIM,TGDO%NGROUND_LAYER,3) :: ZDATA_DG
REAL, DIMENSION(TG%NDIM,3)               :: ZDATA_ALBNIR_VEG
REAL, DIMENSION(TG%NDIM,3)               :: ZDATA_ALBVIS_VEG
REAL, DIMENSION(TG%NDIM,3)               :: ZDATA_ALBUV_VEG
REAL, DIMENSION(TG%NDIM,3)               :: ZDATA_GMES
REAL, DIMENSION(TG%NDIM,3)               :: ZDATA_RE25
REAL, DIMENSION(TG%NDIM,3)               :: ZDATA_BSLAI
REAL, DIMENSION(TG%NDIM,3)               :: ZDATA_LAIMIN
REAL, DIMENSION(TG%NDIM,3)               :: ZDATA_SEFOLD
REAL, DIMENSION(TG%NDIM,3)               :: ZDATA_GC
REAL, DIMENSION(TG%NDIM,3)               :: ZDATA_DMAX
REAL, DIMENSION(TG%NDIM,3)               :: ZDATA_CE_NITRO
REAL, DIMENSION(TG%NDIM,3)               :: ZDATA_CF_NITRO
REAL, DIMENSION(TG%NDIM,3)               :: ZDATA_CNA_NITRO
!
REAL, DIMENSION(TG%NDIM)                 :: ZDATA_WG1
REAL, DIMENSION(TG%NDIM)                 :: ZDATA_WGSAT
!
LOGICAL :: GAGRI_TO_GRASS
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!-------------------------------------------------------------------------------
!
!*       1.    Reading of PGD file
!              --------------------
!
IF (LHOOK) CALL DR_HOOK('READ_PGD_TEB_GARDEN_PAR_N',0,ZHOOK_HANDLE)
DTGD%NTIME= 12
!
GAGRI_TO_GRASS=.FALSE.
!
YRECFM='GD_NTIME'
CALL READ_SURF(&
               HPROGRAM,YRECFM,DTGD%NTIME,IRESP,HCOMMENT=YCOMMENT)
!
ALLOCATE(DTGD%XDATA_FRAC_HVEG (TG%NDIM))
ALLOCATE(DTGD%XDATA_FRAC_LVEG (TG%NDIM))
ALLOCATE(DTGD%XDATA_FRAC_NVEG (TG%NDIM))
ALLOCATE(DTGD%XDATA_LAI_HVEG  (TG%NDIM,DTGD%NTIME))
ALLOCATE(DTGD%XDATA_LAI_LVEG  (TG%NDIM,DTGD%NTIME))
ALLOCATE(DTGD%XDATA_H_HVEG    (TG%NDIM))
!
! Read type of high vegetation
YRECFM='D_TYPE_HVEG'
 CALL READ_SURF(&
               HPROGRAM,YRECFM,TGDP%CTYPE_HVEG,IRESP,HCOMMENT=YCOMMENT)
!
! Read type of low vegetation
YRECFM='D_TYPE_LVEG'
 CALL READ_SURF(&
               HPROGRAM,YRECFM,TGDP%CTYPE_LVEG,IRESP,HCOMMENT=YCOMMENT)
!
! Read type of bare soil (no vegetation)
YRECFM='D_TYPE_NVEG'
 CALL READ_SURF(&
               HPROGRAM,YRECFM,TGDP%CTYPE_NVEG,IRESP,HCOMMENT=YCOMMENT)
!
! Read fraction of high vegetation
YRECFM='D_FRAC_HVEG'
 CALL READ_SURF(&
               HPROGRAM,YRECFM,DTGD%XDATA_FRAC_HVEG,IRESP,HCOMMENT=YCOMMENT)
!
! Read fraction of low vegetation
YRECFM='D_FRAC_LVEG'
 CALL READ_SURF(&
               HPROGRAM,YRECFM,DTGD%XDATA_FRAC_LVEG,IRESP,HCOMMENT=YCOMMENT)
!
! Read fraction of bare soil (no vegetation)
YRECFM='D_FRAC_NVEG'
 CALL READ_SURF(&
               HPROGRAM,YRECFM,DTGD%XDATA_FRAC_NVEG,IRESP,HCOMMENT=YCOMMENT)
!
! Read height of trees( for high vegetation)
YRECFM='D_H_HVEG'
 CALL READ_SURF(&
               HPROGRAM,YRECFM,DTGD%XDATA_H_HVEG,IRESP,HCOMMENT=YCOMMENT)
!
! Read LAI of high vegetation
DO JTIME=1,DTGD%NTIME
  WRITE(YRECFM,FMT='(A10,I2.2)') 'D_LAI_HVEG',JTIME
  CALL READ_SURF(&
               HPROGRAM,YRECFM,DTGD%XDATA_LAI_HVEG(:,JTIME),IRESP,HCOMMENT=YCOMMENT)
  WRITE(YRECFM,FMT='(A10,I2.2)') 'D_LAI_LVEG',JTIME
  CALL READ_SURF(&
               HPROGRAM,YRECFM,DTGD%XDATA_LAI_LVEG(:,JTIME),IRESP,HCOMMENT=YCOMMENT)
END DO
!
!-------------------------------------------------------------------------------
!
!*       2.    Definition of ISBA parameters
!              -----------------------------
!
ALLOCATE(DTGD%XDATA_LAI        (TG%NDIM,DTGD%NTIME))
ALLOCATE(DTGD%XDATA_VEG        (TG%NDIM,DTGD%NTIME))
ALLOCATE(DTGD%XDATA_RSMIN      (TG%NDIM))
ALLOCATE(DTGD%XDATA_GAMMA      (TG%NDIM))
ALLOCATE(DTGD%XDATA_WRMAX_CF   (TG%NDIM))
ALLOCATE(DTGD%XDATA_RGL        (TG%NDIM))
ALLOCATE(DTGD%XDATA_CV         (TG%NDIM))
ALLOCATE(DTGD%XDATA_DG         (TG%NDIM,TGDO%NGROUND_LAYER))
ALLOCATE(DTGD%XDATA_ROOTFRAC   (TG%NDIM,TGDO%NGROUND_LAYER))
ALLOCATE(DTGD%XDATA_DICE       (TG%NDIM))
ALLOCATE(DTGD%XDATA_Z0         (TG%NDIM,DTGD%NTIME))
ALLOCATE(DTGD%XDATA_Z0_O_Z0H   (TG%NDIM))
ALLOCATE(DTGD%XDATA_ALBNIR_VEG (TG%NDIM))
ALLOCATE(DTGD%XDATA_ALBVIS_VEG (TG%NDIM))
ALLOCATE(DTGD%XDATA_ALBUV_VEG  (TG%NDIM))
ALLOCATE(DTGD%XDATA_ALBNIR_SOIL(TG%NDIM))
ALLOCATE(DTGD%XDATA_ALBVIS_SOIL(TG%NDIM))
ALLOCATE(DTGD%XDATA_ALBUV_SOIL (TG%NDIM))
ALLOCATE(DTGD%XDATA_ALBNIR_DRY (TG%NDIM))
ALLOCATE(DTGD%XDATA_ALBVIS_DRY (TG%NDIM))
ALLOCATE(DTGD%XDATA_ALBUV_DRY  (TG%NDIM))
ALLOCATE(DTGD%XDATA_ALBNIR_WET (TG%NDIM))
ALLOCATE(DTGD%XDATA_ALBVIS_WET (TG%NDIM))
ALLOCATE(DTGD%XDATA_ALBUV_WET  (TG%NDIM))
ALLOCATE(DTGD%XDATA_EMIS       (TG%NDIM,DTGD%NTIME))
ALLOCATE(DTGD%XDATA_VEGTYPE    (TG%NDIM,NVEGTYPE))
ALLOCATE(DTGD%XDATA_GMES       (TG%NDIM))
ALLOCATE(DTGD%XDATA_RE25       (TG%NDIM))
ALLOCATE(DTGD%XDATA_BSLAI      (TG%NDIM))
ALLOCATE(DTGD%XDATA_LAIMIN     (TG%NDIM))
ALLOCATE(DTGD%XDATA_SEFOLD     (TG%NDIM))
ALLOCATE(DTGD%XDATA_GC         (TG%NDIM))
ALLOCATE(DTGD%XDATA_DMAX       (TG%NDIM))
ALLOCATE(DTGD%XDATA_F2I        (TG%NDIM))
ALLOCATE(DTGD%LDATA_STRESS     (TG%NDIM))
ALLOCATE(DTGD%XDATA_H_TREE     (TG%NDIM))
ALLOCATE(DTGD%XDATA_CE_NITRO   (TG%NDIM))
ALLOCATE(DTGD%XDATA_CF_NITRO   (TG%NDIM))
ALLOCATE(DTGD%XDATA_CNA_NITRO  (TG%NDIM))
!
DTGD%XDATA_LAI        (:,:) = XUNDEF
DTGD%XDATA_VEG        (:,:) = XUNDEF
DTGD%XDATA_RSMIN        (:) = XUNDEF
DTGD%XDATA_GAMMA        (:) = XUNDEF
DTGD%XDATA_WRMAX_CF     (:) = XUNDEF
DTGD%XDATA_RGL          (:) = XUNDEF
DTGD%XDATA_CV           (:) = XUNDEF
DTGD%XDATA_DG         (:,:) = XUNDEF
DTGD%XDATA_DICE       (:)   = XUNDEF
DTGD%XDATA_ROOTFRAC   (:,:) = XUNDEF
DTGD%XDATA_Z0         (:,:) = XUNDEF
DTGD%XDATA_Z0_O_Z0H     (:) = XUNDEF
DTGD%XDATA_ALBNIR_VEG   (:) = XUNDEF
DTGD%XDATA_ALBVIS_VEG   (:) = XUNDEF
DTGD%XDATA_ALBUV_VEG    (:) = XUNDEF
DTGD%XDATA_ALBNIR_SOIL  (:) = XUNDEF
DTGD%XDATA_ALBVIS_SOIL  (:) = XUNDEF
DTGD%XDATA_ALBUV_SOIL   (:) = XUNDEF
DTGD%XDATA_ALBNIR_DRY   (:) = XUNDEF
DTGD%XDATA_ALBVIS_DRY   (:) = XUNDEF
DTGD%XDATA_ALBUV_DRY    (:) = XUNDEF
DTGD%XDATA_ALBNIR_WET   (:) = XUNDEF
DTGD%XDATA_ALBVIS_WET   (:) = XUNDEF
DTGD%XDATA_ALBUV_WET    (:) = XUNDEF
DTGD%XDATA_EMIS       (:,:) = XUNDEF
DTGD%XDATA_VEGTYPE    (:,:) = XUNDEF
DTGD%XDATA_GMES         (:) = XUNDEF
DTGD%XDATA_RE25         (:) = XUNDEF
DTGD%XDATA_BSLAI        (:) = XUNDEF
DTGD%XDATA_LAIMIN       (:) = XUNDEF
DTGD%XDATA_SEFOLD       (:) = XUNDEF
DTGD%XDATA_GC           (:) = XUNDEF
DTGD%XDATA_DMAX         (:) = XUNDEF
DTGD%XDATA_F2I          (:) = XUNDEF
DTGD%LDATA_STRESS       (:) = .FALSE.
DTGD%XDATA_H_TREE       (:) = XUNDEF
DTGD%XDATA_CE_NITRO     (:) = XUNDEF
DTGD%XDATA_CF_NITRO     (:) = XUNDEF
DTGD%XDATA_CNA_NITRO    (:) = XUNDEF
!
! Vegtypes
DTGD%XDATA_VEGTYPE(:,:) = 0.
IF (TGDP%CTYPE_NVEG == 'NO  ') DTGD%XDATA_VEGTYPE(:, NVT_NO  ) = DTGD%XDATA_FRAC_NVEG(:)
IF (TGDP%CTYPE_NVEG == 'ROCK') DTGD%XDATA_VEGTYPE(:, NVT_ROCK) = DTGD%XDATA_FRAC_NVEG(:)
IF (TGDP%CTYPE_NVEG == 'SNOW') DTGD%XDATA_VEGTYPE(:, NVT_SNOW) = DTGD%XDATA_FRAC_NVEG(:)
IF (TGDP%CTYPE_HVEG == 'TEBD') DTGD%XDATA_VEGTYPE(:, NVT_TEBD) = DTGD%XDATA_FRAC_HVEG(:)
IF (TGDP%CTYPE_HVEG == 'TRBD') DTGD%XDATA_VEGTYPE(:, NVT_TRBD) = DTGD%XDATA_FRAC_HVEG(:)
IF (TGDP%CTYPE_HVEG == 'TEBE') DTGD%XDATA_VEGTYPE(:, NVT_TEBE) = DTGD%XDATA_FRAC_HVEG(:)
IF (TGDP%CTYPE_HVEG == 'BOBD') DTGD%XDATA_VEGTYPE(:, NVT_BOBD) = DTGD%XDATA_FRAC_HVEG(:)
IF (TGDP%CTYPE_HVEG == 'SHRB') DTGD%XDATA_VEGTYPE(:, NVT_SHRB) = DTGD%XDATA_FRAC_HVEG(:)
IF (TGDP%CTYPE_HVEG == 'BONE') DTGD%XDATA_VEGTYPE(:, NVT_BONE) = DTGD%XDATA_FRAC_HVEG(:)
IF (TGDP%CTYPE_HVEG == 'TENE') DTGD%XDATA_VEGTYPE(:, NVT_TENE) = DTGD%XDATA_FRAC_HVEG(:)
IF (TGDP%CTYPE_HVEG == 'BOND') DTGD%XDATA_VEGTYPE(:, NVT_BOND) = DTGD%XDATA_FRAC_HVEG(:)
IF (TGDP%CTYPE_HVEG == 'TRBE') DTGD%XDATA_VEGTYPE(:, NVT_TRBE) = DTGD%XDATA_FRAC_HVEG(:)
IF (TGDP%CTYPE_LVEG == 'C3  ') DTGD%XDATA_VEGTYPE(:, NVT_C3  ) = DTGD%XDATA_FRAC_LVEG(:)
IF (TGDP%CTYPE_LVEG == 'C4  ') DTGD%XDATA_VEGTYPE(:, NVT_C4  ) = DTGD%XDATA_FRAC_LVEG(:)
IF (TGDP%CTYPE_LVEG == 'IRR ') DTGD%XDATA_VEGTYPE(:, NVT_IRR ) = DTGD%XDATA_FRAC_LVEG(:)
IF (TGDP%CTYPE_LVEG == 'GRAS') DTGD%XDATA_VEGTYPE(:, NVT_GRAS) = DTGD%XDATA_FRAC_LVEG(:)
IF (TGDP%CTYPE_LVEG == 'BOGR') DTGD%XDATA_VEGTYPE(:, NVT_BOGR) = DTGD%XDATA_FRAC_LVEG(:)
IF (TGDP%CTYPE_LVEG == 'TROG') DTGD%XDATA_VEGTYPE(:, NVT_TROG) = DTGD%XDATA_FRAC_LVEG(:)
IF (TGDP%CTYPE_LVEG == 'PARK') DTGD%XDATA_VEGTYPE(:, NVT_PARK) = DTGD%XDATA_FRAC_LVEG(:)

!
! Dry/Wet soil albedo
CALL DRY_WET_SOIL_ALBEDOS(TGDP%XSAND(:,1),TGDP%XCLAY(:,1),                             &
                          DTGD%XDATA_VEGTYPE,                                     &
                          DTGD%XDATA_ALBNIR_DRY,DTGD%XDATA_ALBVIS_DRY,DTGD%XDATA_ALBUV_DRY, &
                          DTGD%XDATA_ALBNIR_WET,DTGD%XDATA_ALBVIS_WET,DTGD%XDATA_ALBUV_WET  )  
!
! Height of trees
DTGD%XDATA_H_TREE  (:) = DTGD%XDATA_H_HVEG(:)
!
! Critical normilized soil water content for stress parameterisation
DTGD%XDATA_F2I     (:) = 0.3
!
! Ratio between roughness length for momentum and heat
DTGD%XDATA_Z0_O_Z0H(:) = 10.
!
! Defensive/offensive strategy (1/0)
DTGD%LDATA_STRESS  (:) = .FALSE. 
!
DO JI=1,TG%NDIM
!
! Near-IR, visible, and UV albedo (vegetation only)

 ZDATA_ALBNIR_VEG(JI,:)= 0.30
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TEBD)>0. )  ZDATA_ALBNIR_VEG(JI,1)= 0.25
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TRBD)>0. )  ZDATA_ALBNIR_VEG(JI,1)= 0.25
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TEBE)>0. )  ZDATA_ALBNIR_VEG(JI,1)= 0.25
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_BOBD)>0. )  ZDATA_ALBNIR_VEG(JI,1)= 0.25
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_SHRB)>0. )  ZDATA_ALBNIR_VEG(JI,1)= 0.25
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_BONE)>0. )  ZDATA_ALBNIR_VEG(JI,1)= 0.15
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TENE)>0. )  ZDATA_ALBNIR_VEG(JI,1)= 0.15
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_BOND)>0. )  ZDATA_ALBNIR_VEG(JI,1)= 0.15
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TRBE)>0. )  ZDATA_ALBNIR_VEG(JI,1)= 0.21

 ZDATA_ALBVIS_VEG(JI,:)= 0.10
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TEBD)>0. )  ZDATA_ALBVIS_VEG(JI,1)= 0.05
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TRBD)>0. )  ZDATA_ALBVIS_VEG(JI,1)= 0.05
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TEBE)>0. )  ZDATA_ALBVIS_VEG(JI,1)= 0.05
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_BOBD)>0. )  ZDATA_ALBVIS_VEG(JI,1)= 0.05
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_SHRB)>0. )  ZDATA_ALBVIS_VEG(JI,1)= 0.05
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_BONE)>0. )  ZDATA_ALBVIS_VEG(JI,1)= 0.05
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TENE)>0. )  ZDATA_ALBVIS_VEG(JI,1)= 0.05
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_BOND)>0. )  ZDATA_ALBVIS_VEG(JI,1)= 0.05
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TRBE)>0. )  ZDATA_ALBVIS_VEG(JI,1)= 0.05

 ZDATA_ALBUV_VEG (JI,:)= 0.06
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TEBD)>0. )  ZDATA_ALBUV_VEG(JI,1)= 0.0525
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TRBD)>0. )  ZDATA_ALBUV_VEG(JI,1)= 0.0525
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TEBE)>0. )  ZDATA_ALBUV_VEG(JI,1)= 0.0525
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_BOBD)>0. )  ZDATA_ALBUV_VEG(JI,1)= 0.0525
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_SHRB)>0. )  ZDATA_ALBUV_VEG(JI,1)= 0.0525
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_BONE)>0. )  ZDATA_ALBUV_VEG(JI,1)= 0.0425
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TENE)>0. )  ZDATA_ALBUV_VEG(JI,1)= 0.0425
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_BOND)>0. )  ZDATA_ALBUV_VEG(JI,1)= 0.0425
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TRBE)>0. )  ZDATA_ALBUV_VEG(JI,1)= 0.0380 
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_GRAS)>0. )  ZDATA_ALBUV_VEG(JI,2)= 0.0800
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_BOGR)>0. )  ZDATA_ALBUV_VEG(JI,2)= 0.0800 
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TROG)>0. )  ZDATA_ALBUV_VEG(JI,2)= 0.1250
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_IRR )>0. )  ZDATA_ALBUV_VEG(JI,2)= 0.0450
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_PARK)>0. )  ZDATA_ALBUV_VEG(JI,2)= 0.0450

 IF (DTGD%XDATA_FRAC_HVEG(JI)+DTGD%XDATA_FRAC_LVEG(JI) .GT. 0.) THEN
  DTGD%XDATA_ALBNIR_VEG(JI) =  ( ZDATA_ALBNIR_VEG(JI,1)*DTGD%XDATA_FRAC_HVEG(JI)   &
                            + ZDATA_ALBNIR_VEG(JI,2)*DTGD%XDATA_FRAC_LVEG(JI) ) &
                          / ( DTGD%XDATA_FRAC_HVEG(JI)+DTGD%XDATA_FRAC_LVEG(JI)    )  
!
  DTGD%XDATA_ALBVIS_VEG(JI) =  ( ZDATA_ALBVIS_VEG(JI,1)*DTGD%XDATA_FRAC_HVEG(JI)   &
                            + ZDATA_ALBVIS_VEG(JI,2)*DTGD%XDATA_FRAC_LVEG(JI) ) &
                          / ( DTGD%XDATA_FRAC_HVEG(JI)+DTGD%XDATA_FRAC_LVEG(JI)    )  
! 
  DTGD%XDATA_ALBUV_VEG (JI) =  ( ZDATA_ALBUV_VEG (JI,1)*DTGD%XDATA_FRAC_HVEG(JI)   &
                            + ZDATA_ALBUV_VEG (JI,2)*DTGD%XDATA_FRAC_LVEG(JI) ) &
                          / ( DTGD%XDATA_FRAC_HVEG (JI)+DTGD%XDATA_FRAC_LVEG(JI)   )  
 ENDIF
!
! Soil albedo
 ZDATA_WGSAT(:) = 0.
 ZDATA_WG1  (:) = 0.
 CALL SOIL_ALBEDO('DRY',                                               &
                    ZDATA_WGSAT, ZDATA_WG1,                              &
                    DTGD%XDATA_ALBVIS_DRY, DTGD%XDATA_ALBNIR_DRY, DTGD%XDATA_ALBUV_DRY, &
                    DTGD%XDATA_ALBVIS_WET, DTGD%XDATA_ALBNIR_WET, DTGD%XDATA_ALBUV_WET, &
                    DTGD%XDATA_ALBVIS_SOIL,DTGD%XDATA_ALBNIR_SOIL,DTGD%XDATA_ALBUV_SOIL )  
!
! Min stomatal resistance
 ZDATA_RSMIN(JI,:)= 40.
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TEBD)>0. )  ZDATA_RSMIN(JI,1)= 150.
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TRBD)>0. )  ZDATA_RSMIN(JI,1)= 150.
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TEBE)>0. )  ZDATA_RSMIN(JI,1)= 150.
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_BOBD)>0. )  ZDATA_RSMIN(JI,1)= 150.
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_SHRB)>0. )  ZDATA_RSMIN(JI,1)= 150.
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_BONE)>0. )  ZDATA_RSMIN(JI,1)= 150.
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TENE)>0. )  ZDATA_RSMIN(JI,1)= 150.
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_BOND)>0. )  ZDATA_RSMIN(JI,1)= 150.
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TRBE)>0. )  ZDATA_RSMIN(JI,1)= XEVERG_RSMIN
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TROG)>0. )  ZDATA_RSMIN(JI,2)= 120.
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_C4  )>0. )  ZDATA_RSMIN(JI,2)= 120.
 IF (DTGD%XDATA_FRAC_HVEG(JI)+DTGD%XDATA_FRAC_LVEG(JI) .GT. 0.)              &
    DTGD%XDATA_RSMIN(JI) =  ( ZDATA_RSMIN(JI,1)*DTGD%XDATA_FRAC_HVEG(JI)     &
                       + ZDATA_RSMIN(JI,2)*DTGD%XDATA_FRAC_LVEG(JI)   ) &
                     / ( DTGD%XDATA_FRAC_HVEG(JI)+DTGD%XDATA_FRAC_LVEG(JI) )  
!
! Gamma parameter
 ZDATA_GAMMA(JI,:)= 0.
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TEBD)>0. )  ZDATA_GAMMA(JI,1)= 0.04
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TRBD)>0. )  ZDATA_GAMMA(JI,1)= 0.04
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TEBE)>0. )  ZDATA_GAMMA(JI,1)= 0.04
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_BOBD)>0. )  ZDATA_GAMMA(JI,1)= 0.04
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_SHRB)>0. )  ZDATA_GAMMA(JI,1)= 0.04
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_BONE)>0. )  ZDATA_GAMMA(JI,1)= 0.04
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TENE)>0. )  ZDATA_GAMMA(JI,1)= 0.04
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_BOND)>0. )  ZDATA_GAMMA(JI,1)= 0.04
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TRBE)>0. )  ZDATA_GAMMA(JI,1)= 0.04
 IF (DTGD%XDATA_FRAC_HVEG(JI)+DTGD%XDATA_FRAC_LVEG(JI) .GT. 0.)              &
    DTGD%XDATA_GAMMA(JI) =  ( ZDATA_GAMMA(JI,1)*DTGD%XDATA_FRAC_HVEG(JI)     &
                       + ZDATA_GAMMA(JI,2)*DTGD%XDATA_FRAC_LVEG(JI)   ) &
                     / ( DTGD%XDATA_FRAC_HVEG(JI)+DTGD%XDATA_FRAC_LVEG(JI) )  
!
! Wrmax_cf
 ZDATA_WRMAX_CF(JI,:)= 0.2
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TEBD)>0. )  ZDATA_WRMAX_CF(JI,1)= 0.1
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TRBD)>0. )  ZDATA_WRMAX_CF(JI,1)= 0.1
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TEBE)>0. )  ZDATA_WRMAX_CF(JI,1)= 0.1
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_BOBD)>0. )  ZDATA_WRMAX_CF(JI,1)= 0.1
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_SHRB)>0. )  ZDATA_WRMAX_CF(JI,1)= 0.1
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_BONE)>0. )  ZDATA_WRMAX_CF(JI,1)= 0.1
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TENE)>0. )  ZDATA_WRMAX_CF(JI,1)= 0.1
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_BOND)>0. )  ZDATA_WRMAX_CF(JI,1)= 0.1
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TRBE)>0. )  ZDATA_WRMAX_CF(JI,1)= 0.1
 IF (DTGD%XDATA_FRAC_HVEG(JI)+DTGD%XDATA_FRAC_LVEG(JI) .GT. 0.)                    &
    DTGD%XDATA_WRMAX_CF(JI) =  ( ZDATA_WRMAX_CF(JI,1)*DTGD%XDATA_FRAC_HVEG(JI)     &
                          + ZDATA_WRMAX_CF(JI,2)*DTGD%XDATA_FRAC_LVEG(JI)   ) &
                        / ( DTGD%XDATA_FRAC_HVEG(JI)+DTGD%XDATA_FRAC_LVEG(JI)    )  
!
! Rgl
 ZDATA_RGL(JI,:)= 100.
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TEBD)>0. )  ZDATA_RGL(JI,1)= 30.
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TRBD)>0. )  ZDATA_RGL(JI,1)= 30.
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TEBE)>0. )  ZDATA_RGL(JI,1)= 30.
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_BOBD)>0. )  ZDATA_RGL(JI,1)= 30.
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_SHRB)>0. )  ZDATA_RGL(JI,1)= 30.
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_BONE)>0. )  ZDATA_RGL(JI,1)= 30.
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TENE)>0. )  ZDATA_RGL(JI,1)= 30.
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_BOND)>0. )  ZDATA_RGL(JI,1)= 30.
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TRBE)>0. )  ZDATA_RGL(JI,1)= 30.
 IF (DTGD%XDATA_FRAC_HVEG(JI)+DTGD%XDATA_FRAC_LVEG(JI) .GT. 0.)            &
    DTGD%XDATA_RGL(JI) =  ( ZDATA_RGL(JI,1)*DTGD%XDATA_FRAC_HVEG(JI)       &
                     + ZDATA_RGL(JI,2)*DTGD%XDATA_FRAC_LVEG(JI)     ) &
                   / ( DTGD%XDATA_FRAC_HVEG(JI)+DTGD%XDATA_FRAC_LVEG(JI) )  
!
! Cv
 ZDATA_CV(JI,:)= 2.E-5
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TEBD)>0. )  ZDATA_CV(JI,1)= 1.E-5
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TRBD)>0. )  ZDATA_CV(JI,1)= 1.E-5
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TEBE)>0. )  ZDATA_CV(JI,1)= 1.E-5
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_BOBD)>0. )  ZDATA_CV(JI,1)= 1.E-5
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_SHRB)>0. )  ZDATA_CV(JI,1)= 1.E-5
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_BONE)>0. )  ZDATA_CV(JI,1)= 1.E-5
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TENE)>0. )  ZDATA_CV(JI,1)= 1.E-5
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_BOND)>0. )  ZDATA_CV(JI,1)= 1.E-5
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TRBE)>0. )  ZDATA_CV(JI,1)= 1.E-5
 IF (DTGD%XDATA_FRAC_HVEG(JI)+DTGD%XDATA_FRAC_LVEG(JI) .GT. 0.)           &
    DTGD%XDATA_CV(JI) =  ( ZDATA_CV(JI,1)*DTGD%XDATA_FRAC_HVEG(JI)        &
                    + ZDATA_CV(JI,2)*DTGD%XDATA_FRAC_LVEG(JI)      ) &
                  / ( DTGD%XDATA_FRAC_HVEG(JI)+DTGD%XDATA_FRAC_LVEG(JI) )  
!
! Mesophyll conductance (m s-1)
 ZDATA_GMES(JI,:)=0.020
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TEBD)>0. )  ZDATA_GMES(JI,1)= 0.001
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TRBD)>0. )  ZDATA_GMES(JI,1)= 0.001
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TEBE)>0. )  ZDATA_GMES(JI,1)= 0.001
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_BOBD)>0. )  ZDATA_GMES(JI,1)= 0.001
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_SHRB)>0. )  ZDATA_GMES(JI,1)= 0.001
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_BONE)>0. )  ZDATA_GMES(JI,1)= 0.001
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TENE)>0. )  ZDATA_GMES(JI,1)= 0.001
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_BOND)>0. )  ZDATA_GMES(JI,1)= 0.001
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TRBE)>0. )  ZDATA_GMES(JI,1)= 0.001
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_C3  )>0. )  ZDATA_GMES(JI,2)= 0.003
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_C4  )>0. )  ZDATA_GMES(JI,2)= 0.003
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_IRR )>0. )  ZDATA_GMES(JI,2)= 0.003
 IF (DTGD%XDATA_FRAC_HVEG(JI)+DTGD%XDATA_FRAC_LVEG(JI) .GT. 0.)             &
    DTGD%XDATA_GMES(JI) =  ( ZDATA_GMES(JI,1)*DTGD%XDATA_FRAC_HVEG(JI)      &
                      + ZDATA_GMES(JI,2)*DTGD%XDATA_FRAC_LVEG(JI)    ) &
                    / ( DTGD%XDATA_FRAC_HVEG(JI)+DTGD%XDATA_FRAC_LVEG(JI) )  
!
! Ecosystem Respiration (kg/kg.m.s-1)
 ZDATA_RE25(JI,:)= 3.0E-7 
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_BONE)>0. )  ZDATA_RE25(JI,1)= 1.5E-7
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TENE)>0. )  ZDATA_RE25(JI,1)= 1.5E-7
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_BOND)>0. )  ZDATA_RE25(JI,1)= 1.5E-7
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_C4  )>0. )  ZDATA_RE25(JI,2)= 2.5E-7
 IF (DTGD%XDATA_FRAC_HVEG(JI)+DTGD%XDATA_FRAC_LVEG(JI) .GT. 0.)             &
    DTGD%XDATA_RE25(JI) =  ( ZDATA_RE25(JI,1)*DTGD%XDATA_FRAC_HVEG(JI)      &
                      + ZDATA_RE25(JI,2)*DTGD%XDATA_FRAC_LVEG(JI)    ) &
                    / ( DTGD%XDATA_FRAC_HVEG(JI)+DTGD%XDATA_FRAC_LVEG(JI) )  
!
! Cuticular conductance (m s-1)
 ZDATA_GC(JI,:)=0.00025
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TEBD)>0. )  ZDATA_GC(JI,1)= 0.00015
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TRBD)>0. )  ZDATA_GC(JI,1)= 0.00015
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TEBE)>0. )  ZDATA_GC(JI,1)= 0.00015
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_BOBD)>0. )  ZDATA_GC(JI,1)= 0.00015
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_SHRB)>0. )  ZDATA_GC(JI,1)= 0.00015
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_BONE)>0. )  ZDATA_GC(JI,1)= 0.
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TENE)>0. )  ZDATA_GC(JI,1)= 0.
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_BOND)>0. )  ZDATA_GC(JI,1)= 0.
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TRBE)>0. )  ZDATA_GC(JI,1)= 0.00015   
 IF (DTGD%XDATA_FRAC_HVEG(JI)+DTGD%XDATA_FRAC_LVEG(JI) .GT. 0.)           &
    DTGD%XDATA_GC(JI) =  ( ZDATA_GC(JI,1)*DTGD%XDATA_FRAC_HVEG(JI)        &
                    + ZDATA_GC(JI,2)*DTGD%XDATA_FRAC_LVEG(JI)      ) &
                  / ( DTGD%XDATA_FRAC_HVEG(JI)+DTGD%XDATA_FRAC_LVEG(JI) )  
!
! Ratio d(biomass)/d(lai) (kg/m2)
 ZDATA_BSLAI(JI,:)=0.36 
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TEBD)>0. )  ZDATA_BSLAI(JI,1)= 0.25
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TRBD)>0. )  ZDATA_BSLAI(JI,1)= 0.25
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TEBE)>0. )  ZDATA_BSLAI(JI,1)= 0.25
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_BOBD)>0. )  ZDATA_BSLAI(JI,1)= 0.25
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_SHRB)>0. )  ZDATA_BSLAI(JI,1)= 0.25
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_BONE)>0. )  ZDATA_BSLAI(JI,1)= 0.25
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TENE)>0. )  ZDATA_BSLAI(JI,1)= 0.25
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_BOND)>0. )  ZDATA_BSLAI(JI,1)= 0.25
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TRBE)>0. )  ZDATA_BSLAI(JI,1)= 0.25
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_C3  )>0. )  ZDATA_BSLAI(JI,2)= 0.06
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_C4  )>0. )  ZDATA_BSLAI(JI,2)= 0.06
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_IRR )>0. )  ZDATA_BSLAI(JI,2)= 0.06
 IF (DTGD%XDATA_FRAC_HVEG(JI)+DTGD%XDATA_FRAC_LVEG(JI) .GT. 0.)              &
    DTGD%XDATA_BSLAI(JI) =  ( ZDATA_BSLAI(JI,1)*DTGD%XDATA_FRAC_HVEG(JI)     &
                       + ZDATA_BSLAI(JI,2)*DTGD%XDATA_FRAC_LVEG(JI)   ) &
                     / ( DTGD%XDATA_FRAC_HVEG(JI)+DTGD%XDATA_FRAC_LVEG(JI) )  
!
! Maximum air saturation deficit tolerate by vegetation (kg/kg)
 ZDATA_DMAX(JI,:) = 0.1
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TEBD)>0. )  ZDATA_DMAX(JI,1)= 0.1
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TRBD)>0. )  ZDATA_DMAX(JI,1)= 0.1
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TEBE)>0. )  ZDATA_DMAX(JI,1)= 0.1
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_BOBD)>0. )  ZDATA_DMAX(JI,1)= 0.1
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_SHRB)>0. )  ZDATA_DMAX(JI,1)= 0.1
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_BONE)>0. )  ZDATA_DMAX(JI,1)= 0.1
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TENE)>0. )  ZDATA_DMAX(JI,1)= 0.1
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_BOND)>0. )  ZDATA_DMAX(JI,1)= 0.1
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TRBE)>0. )  ZDATA_DMAX(JI,1)= 0.1
 IF (DTGD%XDATA_FRAC_HVEG(JI)+DTGD%XDATA_FRAC_LVEG(JI) .GT. 0.)             &
    DTGD%XDATA_DMAX(JI) =  ( ZDATA_DMAX(JI,1)*DTGD%XDATA_FRAC_HVEG(JI)      &
                      + ZDATA_DMAX(JI,2)*DTGD%XDATA_FRAC_LVEG(JI)    ) &
                    / ( DTGD%XDATA_FRAC_HVEG(JI)+DTGD%XDATA_FRAC_LVEG(JI) )  
!
! e-folding time for senescence (days)
 ZDATA_SEFOLD(JI,:)=90. * XDAY
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TEBD)>0. )  ZDATA_SEFOLD(JI,1)= 365.* XDAY
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TRBD)>0. )  ZDATA_SEFOLD(JI,1)= 365.* XDAY
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TEBE)>0. )  ZDATA_SEFOLD(JI,1)= 365.* XDAY
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_BOBD)>0. )  ZDATA_SEFOLD(JI,1)= 365.* XDAY
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_SHRB)>0. )  ZDATA_SEFOLD(JI,1)= 365.* XDAY
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_BONE)>0. )  ZDATA_SEFOLD(JI,1)= 365.* XDAY
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TENE)>0. )  ZDATA_SEFOLD(JI,1)= 365.* XDAY
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_BOND)>0. )  ZDATA_SEFOLD(JI,1)= 365.* XDAY
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TRBE)>0. )  ZDATA_SEFOLD(JI,1)= 365.* XDAY
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_C3  )>0. )  ZDATA_SEFOLD(JI,2)=  60.* XDAY
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_C4  )>0. )  ZDATA_SEFOLD(JI,2)=  60.* XDAY
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_IRR )>0. )  ZDATA_SEFOLD(JI,2)=  60.* XDAY
 IF (DTGD%XDATA_FRAC_HVEG(JI)+DTGD%XDATA_FRAC_LVEG(JI) .GT. 0.)                &
    DTGD%XDATA_SEFOLD(JI) =  ( ZDATA_SEFOLD(JI,1)*DTGD%XDATA_FRAC_HVEG(JI)     &
                        + ZDATA_SEFOLD(JI,2)*DTGD%XDATA_FRAC_LVEG(JI)   ) &
                      / ( DTGD%XDATA_FRAC_HVEG(JI)+DTGD%XDATA_FRAC_LVEG(JI)  )  
!
! Minimum LAI (m2/m2)
 ZDATA_LAIMIN (JI,:) = 0.3
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_BONE)>0. )  ZDATA_LAIMIN(JI,1)= 1.0
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TENE)>0. )  ZDATA_LAIMIN(JI,1)= 1.0
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_BOND)>0. )  ZDATA_LAIMIN(JI,1)= 1.0
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TRBE)>0. )  ZDATA_LAIMIN(JI,1)= 1.0
 IF (DTGD%XDATA_FRAC_HVEG(JI)+DTGD%XDATA_FRAC_LVEG(JI) .GT. 0.)                &
    DTGD%XDATA_LAIMIN(JI) =  ( ZDATA_LAIMIN(JI,1)*DTGD%XDATA_FRAC_HVEG(JI)     &
                        + ZDATA_LAIMIN(JI,2)*DTGD%XDATA_FRAC_LVEG(JI)   ) &
                      / ( DTGD%XDATA_FRAC_HVEG(JI)+DTGD%XDATA_FRAC_LVEG(JI)  )  
!
! Leaf aera ratio sensitivity to nitrogen concentration
 ZDATA_CE_NITRO(JI,:)=7.68
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TEBD)>0. )  ZDATA_CE_NITRO(JI,1)= 4.83
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TRBD)>0. )  ZDATA_CE_NITRO(JI,1)= 4.83
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TEBE)>0. )  ZDATA_CE_NITRO(JI,1)= 4.83
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_BOBD)>0. )  ZDATA_CE_NITRO(JI,1)= 4.83
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_SHRB)>0. )  ZDATA_CE_NITRO(JI,1)= 4.83
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_BONE)>0. )  ZDATA_CE_NITRO(JI,1)= 4.85
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TENE)>0. )  ZDATA_CE_NITRO(JI,1)= 4.85
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_BOND)>0. )  ZDATA_CE_NITRO(JI,1)= 4.85
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TRBE)>0. )  ZDATA_CE_NITRO(JI,1)= 4.83
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_C3  )>0. )  ZDATA_CE_NITRO(JI,2)= 3.79
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_GRAS)>0. )  ZDATA_CE_NITRO(JI,2)= 5.56
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_BOGR)>0. )  ZDATA_CE_NITRO(JI,2)= 5.56
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_PARK)>0. )  ZDATA_CE_NITRO(JI,2)= 5.56
 IF (DTGD%XDATA_FRAC_HVEG(JI)+DTGD%XDATA_FRAC_LVEG(JI) .GT. 0.)                    &
    DTGD%XDATA_CE_NITRO(JI) =  ( ZDATA_CE_NITRO(JI,1)*DTGD%XDATA_FRAC_HVEG(JI)     &
                          + ZDATA_CE_NITRO(JI,2)*DTGD%XDATA_FRAC_LVEG(JI)   ) &
                        / ( DTGD%XDATA_FRAC_HVEG(JI)+DTGD%XDATA_FRAC_LVEG(JI)    )  
!
! Lethal minimum value of leaf area ratio
 ZDATA_CF_NITRO(JI,:)=-4.33
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TEBD)>0. )  ZDATA_CF_NITRO(JI,1)= 2.53
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TRBD)>0. )  ZDATA_CF_NITRO(JI,1)= 2.53
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TEBE)>0. )  ZDATA_CF_NITRO(JI,1)= 2.53
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_BOBD)>0. )  ZDATA_CF_NITRO(JI,1)= 2.53
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_SHRB)>0. )  ZDATA_CF_NITRO(JI,1)= 2.53
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_BONE)>0. )  ZDATA_CF_NITRO(JI,1)= -0.24
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TENE)>0. )  ZDATA_CF_NITRO(JI,1)= -0.24
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_BOND)>0. )  ZDATA_CF_NITRO(JI,1)= -0.24
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TRBE)>0. )  ZDATA_CF_NITRO(JI,1)= 0.12
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_C3  )>0. )  ZDATA_CF_NITRO(JI,2)=  9.84
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_GRAS)>0. )  ZDATA_CF_NITRO(JI,2)=  6.73
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_BOGR)>0. )  ZDATA_CF_NITRO(JI,2)=  6.73 
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_PARK)>0. )  ZDATA_CF_NITRO(JI,2)=  6.73
 IF (DTGD%XDATA_FRAC_HVEG(JI)+DTGD%XDATA_FRAC_LVEG(JI) .GT. 0.)                    &
    DTGD%XDATA_CF_NITRO(JI) =  ( ZDATA_CF_NITRO(JI,1)*DTGD%XDATA_FRAC_HVEG(JI)     &
                          + ZDATA_CF_NITRO(JI,2)*DTGD%XDATA_FRAC_LVEG(JI)   ) &
                        / ( DTGD%XDATA_FRAC_HVEG(JI)+DTGD%XDATA_FRAC_LVEG(JI)    )  
!
! Nitrogen concentration of active biomass
 ZDATA_CNA_NITRO(JI,:)=1.3
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TEBD)>0. )  ZDATA_CNA_NITRO(JI,1)= 2.0
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TRBD)>0. )  ZDATA_CNA_NITRO(JI,1)= 2.0
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TEBE)>0. )  ZDATA_CNA_NITRO(JI,1)= 2.0
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_BOBD)>0. )  ZDATA_CNA_NITRO(JI,1)= 2.0
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_SHRB)>0. )  ZDATA_CNA_NITRO(JI,1)= 2.0
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_BONE)>0. )  ZDATA_CNA_NITRO(JI,1)= 2.8
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TENE)>0. )  ZDATA_CNA_NITRO(JI,1)= 2.8
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_BOND)>0. )  ZDATA_CNA_NITRO(JI,1)= 2.8
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_TRBE)>0. )  ZDATA_CNA_NITRO(JI,1)= 1.7
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_C4  )>0. )  ZDATA_CNA_NITRO(JI,2)= 1.9
 IF(DTGD%XDATA_VEGTYPE(JI,NVT_IRR )>0. )  ZDATA_CNA_NITRO(JI,2)= 1.9
 IF (DTGD%XDATA_FRAC_HVEG(JI)+DTGD%XDATA_FRAC_LVEG(JI) .GT. 0.)                      &
    DTGD%XDATA_CNA_NITRO(JI) =  ( ZDATA_CNA_NITRO(JI,1)*DTGD%XDATA_FRAC_HVEG(JI)     &
                           + ZDATA_CNA_NITRO(JI,2)*DTGD%XDATA_FRAC_LVEG(JI)   ) &
                         / ( DTGD%XDATA_FRAC_HVEG(JI)+DTGD%XDATA_FRAC_LVEG(JI)     )  
!
! Ground layers
 IF (TGDO%NGROUND_LAYER<=3) THEN
   ZDATA_DG(JI,1,:) = 0.01
   ZDATA_DG(JI,2,:) = 1.50
   IF(DTGD%XDATA_VEGTYPE(JI,NVT_TEBD)>0. )  ZDATA_DG(JI,2,1)= 2.0
   IF(DTGD%XDATA_VEGTYPE(JI,NVT_TRBD)>0. )  ZDATA_DG(JI,2,1)= 2.0
   IF(DTGD%XDATA_VEGTYPE(JI,NVT_TEBE)>0. )  ZDATA_DG(JI,2,1)= 2.0
   IF(DTGD%XDATA_VEGTYPE(JI,NVT_BOBD)>0. )  ZDATA_DG(JI,2,1)= 2.0
   IF(DTGD%XDATA_VEGTYPE(JI,NVT_SHRB)>0. )  ZDATA_DG(JI,2,1)= 2.0
   IF(DTGD%XDATA_VEGTYPE(JI,NVT_BONE)>0. )  ZDATA_DG(JI,2,1)= 2.0
   IF(DTGD%XDATA_VEGTYPE(JI,NVT_TENE)>0. )  ZDATA_DG(JI,2,1)= 2.0
   IF(DTGD%XDATA_VEGTYPE(JI,NVT_BOND)>0. )  ZDATA_DG(JI,2,1)= 2.0
   IF(DTGD%XDATA_VEGTYPE(JI,NVT_TRBE)>0. )  ZDATA_DG(JI,2,1)= 2.0
   IF(DTGD%XDATA_VEGTYPE(JI,NVT_NO  )>0. )  ZDATA_DG(JI,2,3)= 0.5
   IF(DTGD%XDATA_VEGTYPE(JI,NVT_ROCK)>0. )  ZDATA_DG(JI,2,3)= 0.5
   IF(DTGD%XDATA_VEGTYPE(JI,NVT_SNOW)>0. )  ZDATA_DG(JI,2,3)= 0.5
   IF (TGDO%NGROUND_LAYER==3) THEN
      ZDATA_DG(JI,3,:) = 2.00
      IF(DTGD%XDATA_VEGTYPE(JI,NVT_TEBD)>0. )  ZDATA_DG(JI,3,1)= 3.0
      IF(DTGD%XDATA_VEGTYPE(JI,NVT_TRBD)>0. )  ZDATA_DG(JI,3,1)= 3.0
      IF(DTGD%XDATA_VEGTYPE(JI,NVT_TEBE)>0. )  ZDATA_DG(JI,3,1)= 3.0
      IF(DTGD%XDATA_VEGTYPE(JI,NVT_BOBD)>0. )  ZDATA_DG(JI,3,1)= 3.0
      IF(DTGD%XDATA_VEGTYPE(JI,NVT_SHRB)>0. )  ZDATA_DG(JI,3,1)= 3.0
      IF(DTGD%XDATA_VEGTYPE(JI,NVT_BONE)>0. )  ZDATA_DG(JI,3,1)= 3.0
      IF(DTGD%XDATA_VEGTYPE(JI,NVT_TENE)>0. )  ZDATA_DG(JI,3,1)= 3.0
      IF(DTGD%XDATA_VEGTYPE(JI,NVT_BOND)>0. )  ZDATA_DG(JI,3,1)= 3.0
      IF(DTGD%XDATA_VEGTYPE(JI,NVT_TRBE)>0. )  ZDATA_DG(JI,3,1)= 3.0
      IF(DTGD%XDATA_VEGTYPE(JI,NVT_NO  )>0. )  ZDATA_DG(JI,3,3)= 1.0
      IF(DTGD%XDATA_VEGTYPE(JI,NVT_ROCK)>0. )  ZDATA_DG(JI,3,3)= 1.0
      IF(DTGD%XDATA_VEGTYPE(JI,NVT_SNOW)>0. )  ZDATA_DG(JI,3,3)= 1.0
   ENDIF
   DTGD%XDATA_DG(JI,:) =    ZDATA_DG(JI,:,1)*DTGD%XDATA_FRAC_HVEG(JI)   &
                       + ZDATA_DG(JI,:,2)*DTGD%XDATA_FRAC_LVEG(JI) &
                       + ZDATA_DG(JI,:,3)*DTGD%XDATA_FRAC_NVEG(JI)  
 ELSEIF (TGDO%NGROUND_LAYER<=NOPTIMLAYER) THEN
   DTGD%XDATA_DG(JI,:) = XOPTIMGRID(:)
 ELSE
   CALL ABOR1_SFX("READ_PGD_TEB_GARDEN_PAR: WITH MORE THAN 14 SOIL LAYERS, "//&
     "WITHOUT ECOCLIMAP, GARDEN CANNOT RUN")
 ENDIF 
!
! Root fractions
 DTGD%XDATA_ROOTFRAC(JI,TGDO%NGROUND_LAYER) = 1.
 DTGD%XDATA_ROOTFRAC(JI,1) = 0.20
 IF (TGDO%NGROUND_LAYER>2) THEN
   DO JLAYER = TGDO%NGROUND_LAYER-1,2,-1
     DTGD%XDATA_ROOTFRAC(JI,JLAYER) = DTGD%XDATA_ROOTFRAC(JI,JLAYER+1)-0.8/(TGDO%NGROUND_LAYER-1)
   ENDDO
 ENDIF
!
 DTGD%XDATA_DICE(JI) = DTGD%XDATA_DG(JI,2)
!
 DO JTIME=1,DTGD%NTIME
! Leaf Area Index
 IF (DTGD%XDATA_FRAC_HVEG(JI)+DTGD%XDATA_FRAC_LVEG(JI) .GT. 0.)                           &
     DTGD%XDATA_LAI     (JI,JTIME) = ( DTGD%XDATA_LAI_HVEG(JI,JTIME)*DTGD%XDATA_FRAC_HVEG(JI)  &
                                + DTGD%XDATA_LAI_LVEG(JI,JTIME)*DTGD%XDATA_FRAC_LVEG(JI)) &
                               /( DTGD%XDATA_FRAC_HVEG(JI)+DTGD%XDATA_FRAC_LVEG(JI))  
! Fraction of vegetation
  DTGD%XDATA_VEG     (JI,JTIME) = VEG_FROM_LAI  (DTGD%XDATA_LAI    (JI,JTIME),       &
                                            DTGD%XDATA_VEGTYPE(JI,:),GAGRI_TO_GRASS)  
! Roughness length for momentum
  DTGD%XDATA_Z0      (JI,JTIME) = Z0V_FROM_LAI  (DTGD%XDATA_LAI    (JI,JTIME),       &
                                            DTGD%XDATA_H_TREE (JI),           &
                                            DTGD%XDATA_VEGTYPE(JI,:),GAGRI_TO_GRASS)  
! Emissivity
  DTGD%XDATA_EMIS    (JI,JTIME) = EMIS_FROM_VEG (DTGD%XDATA_VEG    (JI,JTIME),       &
                                            DTGD%XDATA_VEGTYPE(JI,:))
 END DO
!
ENDDO
IF (LHOOK) CALL DR_HOOK('READ_PGD_TEB_GARDEN_PAR_N',1,ZHOOK_HANDLE)
!
!-------------------------------------------------------------------------------
!
END SUBROUTINE READ_PGD_TEB_GARDEN_PAR_n
