!     #########
      SUBROUTINE READ_OCEAN_n (DTCO, O, OR, U, &
                               HPROGRAM)
!     #########################################
!
!!****  *READ_OCEAN_n* - read oceanic variables
!!
!!
!!    PURPOSE
!!    -------
!!
!!**  METHOD
!!    ------
!!
!!    EXTERNAL
!!    --------
!!
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!
!!    AUTHOR
!!    ------
!!      C. Lebeaupin Brossier   *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    04/2007 
!!      Modofied    07/2012, P. Le Moigne : CMO1D phasing
!-------------------------------------------------------------------------------
!
!*       0.    DECLARATIONS
!              ------------
!
!
!
!
USE MODD_DATA_COVER_n, ONLY : DATA_COVER_t
USE MODD_OCEAN_n, ONLY : OCEAN_t
USE MODD_OCEAN_REL_n, ONLY : OCEAN_REL_t
USE MODD_SURF_ATM_n, ONLY : SURF_ATM_t
!
USE MODD_SURF_PAR, ONLY : XUNDEF
USE MODD_OCEAN_GRID, ONLY : NOCKMIN,NOCKMAX,XZHOC
!
!
USE MODI_READ_SURF
USE MODI_OCEAN_MERCATORVERGRID
!
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
USE MODI_GET_TYPE_DIM_n
!
IMPLICIT NONE
!
!*       0.1   Declarations of arguments
!              -------------------------
!
!
TYPE(DATA_COVER_t), INTENT(INOUT) :: DTCO
TYPE(OCEAN_t), INTENT(INOUT) :: O
TYPE(OCEAN_REL_t), INTENT(INOUT) :: OR
TYPE(SURF_ATM_t), INTENT(INOUT) :: U
!
 CHARACTER(LEN=6),  INTENT(IN)  :: HPROGRAM ! calling program
!
!*       0.2   Declarations of local variables
!              -------------------------------
!
INTEGER           :: ILU          ! 1D physical dimension
!
INTEGER           :: IRESP          ! Error code after redding
!
 CHARACTER(LEN=4)  :: YLVL
!
 CHARACTER(LEN=12) :: YRECFM         ! Name of the article to be read
 CHARACTER(LEN=14) :: YFORM          ! Writing format
REAL, DIMENSION(:),ALLOCATABLE  :: ZWORK      ! 1D array to write data in file
!
INTEGER :: JLEVEL ! loop counter on oceanic levels
INTEGER :: J      ! loop counter on sea grid points
!
INTEGER           :: IVERSION       ! surface version
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!-------------------------------------------------------------------------------
IF (LHOOK) CALL DR_HOOK('READ_OCEAN_N',0,ZHOOK_HANDLE)
O%NOCTCOUNT=0
!
YRECFM='VERSION'
 CALL READ_SURF(&
                HPROGRAM,YRECFM,IVERSION,IRESP)
!
!* flag to use or not Ocean model
!
IF (IVERSION<=3) THEN
   O%LMERCATOR=.FALSE.
ELSE
   YRECFM='SEA_OCEAN'
   CALL READ_SURF(&
                HPROGRAM,YRECFM,O%LMERCATOR,IRESP)
ENDIF
!
IF (.NOT. O%LMERCATOR) THEN
  ALLOCATE(O%XSEAT(0,0))
  ALLOCATE(OR%XSEAT_REL(0,0))
  ALLOCATE(O%XSEAS(0,0))
  ALLOCATE(OR%XSEAS_REL(0,0))
  ALLOCATE(OR%XSEAU_REL(0,0))
  ALLOCATE(OR%XSEAV_REL(0,0))
  ALLOCATE(O%XSEAU(0,0))
  ALLOCATE(O%XSEAV(0,0))
  ALLOCATE(O%XSEAE(0,0))
  ALLOCATE(O%XSEABATH(0,0))
  ALLOCATE(O%XSEAHMO(0))
  ALLOCATE(O%XLE        (0,0))
  ALLOCATE(O%XLK        (0,0))
  ALLOCATE(O%XKMEL      (0,0))
  ALLOCATE(O%XKMELM     (0,0))
  ALLOCATE(O%XSEATEND   (0))
  ALLOCATE(O%XDTFSOL(0,0))
  ALLOCATE(O%XDTFNSOL(0))
  IF (LHOOK) CALL DR_HOOK('READ_OCEAN_N',1,ZHOOK_HANDLE)
  RETURN
ENDIF
!
!-------------------------------------------------------------------------------
!
NOCKMIN = 0
YRECFM='SEA_NBLEVEL'
 CALL READ_SURF(HPROGRAM,YRECFM,NOCKMAX,IRESP)
!
ALLOCATE(XZHOC(NOCKMIN:NOCKMAX))
XZHOC(NOCKMIN) = 0.
! Read vertical grid
DO JLEVEL = NOCKMIN+1,NOCKMAX
  WRITE(YLVL,'(I4)') JLEVEL
  YRECFM='LEVL_OC'//ADJUSTL(YLVL(:LEN_TRIM(YLVL)))
  CALL READ_SURF(HPROGRAM,YRECFM,XZHOC(JLEVEL),IRESP)
END DO
!
 CALL OCEAN_MERCATORVERGRID
!
! Relaxation time and logical
YRECFM='TAU_REL_OC'
 CALL READ_SURF(&
                HPROGRAM,YRECFM,OR%XTAU_REL,IRESP)
!
YRECFM='LREL_CUR_OC'
 CALL READ_SURF(&
                HPROGRAM,YRECFM,OR%LREL_CUR,IRESP)

YRECFM='LREL_TS_OC'
 CALL READ_SURF(&
                HPROGRAM,YRECFM,OR%LREL_TS,IRESP)
YRECFM='LFLX_NULL_OC'
 CALL READ_SURF(&
                HPROGRAM,YRECFM,OR%LFLUX_NULL,IRESP)
YRECFM='LFLX_CORR_OC'
 CALL READ_SURF(&
                HPROGRAM,YRECFM,OR%LFLX_CORR,IRESP)
YRECFM='CORR_FLX_OC'
 CALL READ_SURF(&
                HPROGRAM,YRECFM,OR%XQCORR,IRESP)
YRECFM='LDIAPYC_OC'
 CALL READ_SURF(&
                HPROGRAM,YRECFM,OR%LDIAPYCNAL,IRESP)
!
!* 1D physical dimension
!
YRECFM='SIZE_SEA'
 CALL GET_TYPE_DIM_n(DTCO, U, &
                     'SEA   ',ILU)
!
!*       2.     Prognostic fields:
!               -----------------
!
ALLOCATE(ZWORK(ILU))
!* oceanic temperature
!
ALLOCATE(O%XSEAT(ILU,NOCKMIN:NOCKMAX))
!
DO JLEVEL=NOCKMIN+1,NOCKMAX
  WRITE(YLVL,'(I4)') JLEVEL
  YRECFM='TEMP_OC'//ADJUSTL(YLVL(:LEN_TRIM(YLVL)))
  CALL READ_SURF(&
                HPROGRAM,YRECFM,ZWORK(:),IRESP)
  O%XSEAT(:,JLEVEL)=ZWORK(:)
END DO
O%XSEAT(:,NOCKMIN)=O%XSEAT(:,NOCKMIN+1)
!
!* relaxation profile for oceanic temperature
!
ALLOCATE(OR%XSEAT_REL(ILU,NOCKMIN:NOCKMAX))
!
DO JLEVEL=NOCKMIN+1,NOCKMAX
  WRITE(YLVL,'(I4)') JLEVEL
  YRECFM='T_OC_REL'//ADJUSTL(YLVL(:LEN_TRIM(YLVL)))
  CALL READ_SURF(&
                HPROGRAM,YRECFM,ZWORK(:),IRESP)
  OR%XSEAT_REL(:,JLEVEL)=ZWORK(:)
END DO
OR%XSEAT_REL(:,NOCKMIN)=OR%XSEAT_REL(:,NOCKMIN+1)
!
!* oceanic salinity
!
ALLOCATE(O%XSEAS(ILU,NOCKMIN:NOCKMAX))
!
DO JLEVEL=NOCKMIN+1,NOCKMAX
  WRITE(YLVL,'(I4)') JLEVEL
  YRECFM='SALT_OC'//ADJUSTL(YLVL(:LEN_TRIM(YLVL)))
  CALL READ_SURF(&
                HPROGRAM,YRECFM,ZWORK(:),IRESP)
  O%XSEAS(:,JLEVEL)=ZWORK(:)
END DO
O%XSEAS(:,NOCKMIN)=O%XSEAS(:,NOCKMIN+1)
!
!* oceanic salinity profile of relaxation
!
ALLOCATE(OR%XSEAS_REL(ILU,NOCKMIN:NOCKMAX))
!
DO JLEVEL=NOCKMIN+1,NOCKMAX
  WRITE(YLVL,'(I4)') JLEVEL
  YRECFM='S_OC_REL'//ADJUSTL(YLVL(:LEN_TRIM(YLVL)))
  CALL READ_SURF(&
                HPROGRAM,YRECFM,ZWORK(:),IRESP)
  OR%XSEAS_REL(:,JLEVEL)=ZWORK(:)
END DO
OR%XSEAS_REL(:,NOCKMIN)=OR%XSEAS_REL(:,NOCKMIN+1)
!
!* oceanic current
!
ALLOCATE(OR%XSEAU_REL(ILU,NOCKMIN:NOCKMAX))
ALLOCATE(OR%XSEAV_REL(ILU,NOCKMIN:NOCKMAX))
!
DO JLEVEL=NOCKMIN+1,NOCKMAX
  WRITE(YLVL,'(I4)') JLEVEL
  YRECFM='U_OC_REL'//ADJUSTL(YLVL(:LEN_TRIM(YLVL)))
  CALL READ_SURF(&
                HPROGRAM,YRECFM,ZWORK(:),IRESP)
  OR%XSEAU_REL(:,JLEVEL)=ZWORK(:)
END DO
OR%XSEAU_REL(:,NOCKMIN)=OR%XSEAU_REL(:,NOCKMIN+1)
!
DO JLEVEL=NOCKMIN+1,NOCKMAX
  WRITE(YLVL,'(I4)') JLEVEL
  YRECFM='V_OC_REL'//ADJUSTL(YLVL(:LEN_TRIM(YLVL)))
  CALL READ_SURF(&
                HPROGRAM,YRECFM,ZWORK(:),IRESP)
  OR%XSEAV_REL(:,JLEVEL)=ZWORK(:)
END DO
OR%XSEAV_REL(:,NOCKMIN)=OR%XSEAV_REL(:,NOCKMIN+1)
!
ALLOCATE(O%XSEAU(ILU,NOCKMIN:NOCKMAX))
ALLOCATE(O%XSEAV(ILU,NOCKMIN:NOCKMAX))
!
DO JLEVEL=NOCKMIN+1,NOCKMAX
  WRITE(YLVL,'(I4)') JLEVEL
  YRECFM='UCUR_OC'//ADJUSTL(YLVL(:LEN_TRIM(YLVL)))
  CALL READ_SURF(&
                HPROGRAM,YRECFM,ZWORK(:),IRESP)
  O%XSEAU(:,JLEVEL)=ZWORK(:)
END DO
DO JLEVEL=NOCKMIN+1,NOCKMAX
  WRITE(YLVL,'(I4)') JLEVEL
  YRECFM='VCUR_OC'//ADJUSTL(YLVL(:LEN_TRIM(YLVL)))
  CALL READ_SURF(&
                HPROGRAM,YRECFM,ZWORK(:),IRESP)
  O%XSEAV(:,JLEVEL)=ZWORK(:)
END DO
O%XSEAU(:,NOCKMIN)=O%XSEAU(:,NOCKMIN+1)
O%XSEAV(:,NOCKMIN)=O%XSEAV(:,NOCKMIN+1)
!
!* oceanic turbulent kinetic energy
!
ALLOCATE(O%XSEAE(ILU,NOCKMIN:NOCKMAX))
!
DO JLEVEL=NOCKMIN+1,NOCKMAX
  WRITE(YLVL,'(I4)') JLEVEL
  YRECFM='TKE_OC'//ADJUSTL(YLVL(:LEN_TRIM(YLVL)))
  CALL READ_SURF(&
                HPROGRAM,YRECFM,ZWORK(:),IRESP)
  O%XSEAE(:,JLEVEL)=ZWORK(:)
END DO
O%XSEAE(:,NOCKMIN)=O%XSEAE(:,NOCKMIN+1)
!
!
!-------------------------------------------------------------------------------
!
!*       4.     Semi-prognostic fields:
!               ----------------------
!
!* bathymetry indice
!
ALLOCATE(O%XSEABATH(ILU,NOCKMIN:NOCKMAX))
!
DO JLEVEL=NOCKMIN+1,NOCKMAX
  WRITE(YLVL,'(I4)') JLEVEL
  YRECFM='SEAINDBATH'//ADJUSTL(YLVL(:LEN_TRIM(YLVL)))
  CALL READ_SURF(&
                HPROGRAM,YRECFM,ZWORK(:),IRESP)
  O%XSEABATH(:,JLEVEL)=ZWORK(:)
END DO
O%XSEABATH(:,NOCKMIN)=1.
!
!-------------------------------------------------------------------------------
!Complete undefined values for the oceanic 1D model convergence
DO J=1,ILU
  DO JLEVEL=NOCKMIN+2,NOCKMAX
    IF (O%XSEABATH(J,JLEVEL)==0.) THEN
      O%XSEAT(J,JLEVEL)=O%XSEAT(J,JLEVEL-1)
      O%XSEAS(J,JLEVEL)=O%XSEAS(J,JLEVEL-1)
      O%XSEAU(J,JLEVEL)=O%XSEAU(J,JLEVEL-1)
      O%XSEAV(J,JLEVEL)=O%XSEAV(J,JLEVEL-1)
      O%XSEAE(J,JLEVEL)=O%XSEAE(J,JLEVEL-1)
      !
      OR%XSEAT_REL(J,JLEVEL)=OR%XSEAT_REL(J,JLEVEL-1)
      OR%XSEAS_REL(J,JLEVEL)=OR%XSEAS_REL(J,JLEVEL-1)
      OR%XSEAU_REL(J,JLEVEL)=OR%XSEAU_REL(J,JLEVEL-1)
      OR%XSEAV_REL(J,JLEVEL)=OR%XSEAV_REL(J,JLEVEL-1)      
    ENDIF
  ENDDO
ENDDO
!
DEALLOCATE(ZWORK)
!-------------------------------------------------------------------------------
ALLOCATE(O%XSEAHMO(ILU))
YRECFM='SEA_HMO'
 CALL READ_SURF(&
                HPROGRAM,YRECFM,O%XSEAHMO(:),IRESP)
!
!-------------------------------------------------------------------------------
ALLOCATE(O%XLE        (SIZE(O%XSEAT,1),NOCKMIN:NOCKMAX))
ALLOCATE(O%XLK        (SIZE(O%XSEAT,1),NOCKMIN:NOCKMAX))
ALLOCATE(O%XKMEL      (SIZE(O%XSEAT,1),NOCKMIN:NOCKMAX))
ALLOCATE(O%XKMELM     (SIZE(O%XSEAT,1),NOCKMIN:NOCKMAX))
O%XLE(:,:)    =XUNDEF
O%XLK(:,:)    =XUNDEF
O%XKMEL(:,:)  =XUNDEF
O%XKMELM(:,:) =XUNDEF
!
ALLOCATE(O%XSEATEND   (SIZE(O%XSEAT,1)))
O%XSEATEND(:) =XUNDEF
!
ALLOCATE(O%XDTFSOL(ILU,NOCKMIN:NOCKMAX))
ALLOCATE(O%XDTFNSOL(ILU))
!
O%XDTFSOL(:,:) = XUNDEF 
O%XDTFNSOL(:) = XUNDEF 
!
IF (LHOOK) CALL DR_HOOK('READ_OCEAN_N',1,ZHOOK_HANDLE)
!
!------------------------------------------------------------------------------
END SUBROUTINE READ_OCEAN_n
