SUBROUTINE READ_FROM_SURFEX_FILE (DTCO, DGU, U, &
                                  HFTYP,HFNAM,HMASK,HSCHEME,PFIELD,HNAM)
!
!
!
!
USE MODD_DATA_COVER_n, ONLY : DATA_COVER_t
USE MODD_DIAG_SURF_ATM_n, ONLY : DIAG_SURF_ATM_t
USE MODD_SURF_ATM_n, ONLY : SURF_ATM_t
!
USE MODI_INIT_IO_SURF_n
USE MODI_END_IO_SURF_n
USE MODI_READ_SURF
!
#ifdef SFX_ASC
USE MODI_SET_SURFEX_FILE_NAME_ASC
#endif
#ifdef SFX_FA
USE MODI_SET_SURFEX_FILE_NAME_FA
#endif
#ifdef SFX_LFI
USE MODI_SET_SURFEX_FILE_NAME_LFI
#endif
#ifdef SFX_NC
USE MODI_SET_SURFEX_FILE_NAME_NC
#endif
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!
!
TYPE(DATA_COVER_t), INTENT(INOUT) :: DTCO
TYPE(DIAG_SURF_ATM_t), INTENT(INOUT) :: DGU
TYPE(SURF_ATM_t), INTENT(INOUT) :: U

!
 CHARACTER(LEN=6), INTENT(IN) :: HFTYP
 CHARACTER(LEN=28), INTENT(IN) :: HFNAM
 CHARACTER(LEN=6), INTENT(IN) :: HMASK
 CHARACTER(LEN=6), INTENT(IN) :: HSCHEME
REAL, DIMENSION(:), INTENT(OUT) :: PFIELD
 CHARACTER(LEN=*), OPTIONAL, INTENT(IN) :: HNAM
!
 CHARACTER(LEN=28)     :: HNAME
 CHARACTER(LEN=12)     :: YRECFM
INTEGER               :: IRESP, I0
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE

IF (LHOOK) CALL DR_HOOK('READ_FROM_SURFEX_FILE',0,ZHOOK_HANDLE)

HNAME=ADJUSTL(ADJUSTR(HFNAM))

IF (PRESENT(HNAM)) THEN
  YRECFM=HNAM
ELSE
  I0=INDEX(HNAME,'.',BACK=.TRUE.)
  YRECFM=HNAME(1:I0-1)
ENDIF

IF (HFTYP=='ASCII ') THEN
#ifdef SFX_ASC
  CALL SET_SURFEX_FILE_NAME_ASC(HNAME_IN=HNAME)
#endif
ELSEIF (HFTYP=='FA    ') THEN
#ifdef SFX_FA
  CALL SET_SURFEX_FILE_NAME_FA(HNAME_IN=HNAME)
#endif
ELSEIF (HFTYP=='LFI   ') THEN
#ifdef SFX_LFI
  CALL SET_SURFEX_FILE_NAME_LFI(HNAME_IN=HNAME)
#endif
ELSEIF (HFTYP=='NC    ') THEN
#ifdef SFX_NC
  CALL SET_SURFEX_FILE_NAME_NC(HNAME_IN=HNAME)
#endif
ENDIF
CALL INIT_IO_SURF_n(DTCO, DGU, U, &
                     HFTYP,HMASK,HSCHEME,'READ ')
 CALL READ_SURF(&
                HFTYP,YRECFM,PFIELD,IRESP)
 CALL END_IO_SURF_n(HFTYP)

IF (LHOOK) CALL DR_HOOK('READ_FROM_SURFEX_FILE',1,ZHOOK_HANDLE)

END SUBROUTINE READ_FROM_SURFEX_FILE
