!     #########################
      SUBROUTINE READ_BLD_DESCRIPTION_n (&
                                          BDD, &
                                         HPROGRAM)
!     #########################
!
!!
!!    PURPOSE
!!    -------
!!
!!    METHOD
!!    ------
!!
!!
!!    EXTERNAL
!!    --------
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!    AUTHOR
!!    ------
!!
!!    V. Masson        Meteo-France
!!
!!    MODIFICATION
!!    ------------
!!
!!    Original    05/2012 
!
!----------------------------------------------------------------------------
!
!*    0.     DECLARATION
!            -----------
!
!
!
!
!
!
USE MODD_BLD_DESCRIPTION_n, ONLY : BLD_DESC_t
!
USE MODI_READ_SURF
USE MODI_ABOR1_SFX
!
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*    0.1    Declaration of arguments
!            ------------------------
!
!
!
!
TYPE(BLD_DESC_t), INTENT(INOUT) :: BDD
!
 CHARACTER(LEN=6),  INTENT(IN) :: HPROGRAM
!
!
!*    0.2    Declaration of local variables
!      ------------------------------
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
REAL, DIMENSION(:), ALLOCATABLE :: ZWORK
INTEGER                         :: IRESP
INTEGER                         :: I1, I2
INTEGER                         :: JL
INTEGER                         :: ITOT
INTEGER           :: IVERSION       ! surface version
INTEGER           :: IBUGFIX        ! surface bugfix version
!-------------------------------------------------------------------------------
!-------------------------------------------------------------------------------
!
IF (LHOOK) CALL DR_HOOK('READ_BLD_DESCRIPTION_n',0,ZHOOK_HANDLE)
!
!-------------------------------------------------------------------------------
!
!*    1.   Read file version
!          -----------------
!
 CALL READ_SURF(&
                HPROGRAM,'VERSION',IVERSION,IRESP)
 CALL READ_SURF(&
                HPROGRAM,'BUG',IBUGFIX,IRESP)
!-------------------------------------------------------------------------------
!
!*    1.   Read configuration variables of the descriptive data
!          ----------------------------------------------------
!
ALLOCATE(ZWORK(7))
 CALL READ_SURF(&
                HPROGRAM,'BLD_DESC_CNF',ZWORK,IRESP,HDIR='-')
!
BDD%NDESC_BLD         = NINT(ZWORK(1))
BDD%NDESC_AGE         = NINT(ZWORK(2))
BDD%NDESC_USE         = NINT(ZWORK(3))
BDD%NDESC_WALL_LAYER  = NINT(ZWORK(4))
BDD%NDESC_ROOF_LAYER  = NINT(ZWORK(5))
BDD%NDESC_ROAD_LAYER  = NINT(ZWORK(6))
BDD%NDESC_FLOOR_LAYER = NINT(ZWORK(7))
!
DEALLOCATE(ZWORK)
!
BDD%NDESC_CODE = BDD%NDESC_BLD * BDD%NDESC_AGE
!-------------------------------------------------------------------------------
!
!*    2.   Allocates descriptive data
!          --------------------------
!
!
ALLOCATE(BDD%NDESC_BLD_LIST(BDD%NDESC_BLD))
ALLOCATE(BDD%NDESC_CODE_LIST(BDD%NDESC_CODE))
ALLOCATE(BDD%XDESC_ALB_ROOF(BDD%NDESC_CODE))
ALLOCATE(BDD%XDESC_ALB_ROAD(BDD%NDESC_CODE))
ALLOCATE(BDD%XDESC_ALB_WALL(BDD%NDESC_CODE))
ALLOCATE(BDD%XDESC_EMIS_ROOF(BDD%NDESC_CODE))
ALLOCATE(BDD%XDESC_EMIS_ROAD(BDD%NDESC_CODE))
ALLOCATE(BDD%XDESC_EMIS_WALL(BDD%NDESC_CODE))
ALLOCATE(BDD%XDESC_HC_ROOF(BDD%NDESC_CODE,BDD%NDESC_ROOF_LAYER))
ALLOCATE(BDD%XDESC_TC_ROOF(BDD%NDESC_CODE,BDD%NDESC_ROOF_LAYER))
ALLOCATE(BDD%XDESC_D_ROOF (BDD%NDESC_CODE,BDD%NDESC_ROOF_LAYER))
ALLOCATE(BDD%XDESC_HC_ROAD(BDD%NDESC_CODE,BDD%NDESC_ROAD_LAYER))
ALLOCATE(BDD%XDESC_TC_ROAD(BDD%NDESC_CODE,BDD%NDESC_ROAD_LAYER))
ALLOCATE(BDD%XDESC_D_ROAD (BDD%NDESC_CODE,BDD%NDESC_ROAD_LAYER))
ALLOCATE(BDD%XDESC_HC_WALL(BDD%NDESC_CODE,BDD%NDESC_WALL_LAYER))
ALLOCATE(BDD%XDESC_TC_WALL(BDD%NDESC_CODE,BDD%NDESC_WALL_LAYER))
ALLOCATE(BDD%XDESC_D_WALL (BDD%NDESC_CODE,BDD%NDESC_WALL_LAYER))
ALLOCATE(BDD%XDESC_HC_FLOOR(BDD%NDESC_CODE,BDD%NDESC_FLOOR_LAYER))
ALLOCATE(BDD%XDESC_TC_FLOOR(BDD%NDESC_CODE,BDD%NDESC_FLOOR_LAYER))
ALLOCATE(BDD%XDESC_D_FLOOR (BDD%NDESC_CODE,BDD%NDESC_FLOOR_LAYER))
ALLOCATE(BDD%XDESC_SHGC(BDD%NDESC_CODE))
ALLOCATE(BDD%XDESC_U_WIN(BDD%NDESC_CODE))
ALLOCATE(BDD%XDESC_GR(BDD%NDESC_CODE))
!
ALLOCATE(BDD%XDESC_F_WASTE_CAN(BDD%NDESC_CODE))
ALLOCATE(BDD%XDESC_F_WATER_COND(BDD%NDESC_CODE))
ALLOCATE(BDD%XDESC_COP_RAT(BDD%NDESC_CODE))
ALLOCATE(BDD%XDESC_EFF_HEAT(BDD%NDESC_CODE))
ALLOCATE(BDD%XDESC_INF(BDD%NDESC_CODE))
ALLOCATE(BDD%XDESC_V_VENT(BDD%NDESC_CODE))
ALLOCATE(BDD%XDESC_GREENROOF(BDD%NDESC_CODE))
!
ALLOCATE(BDD%XDESC_EMIS_PANEL(BDD%NDESC_CODE))
ALLOCATE(BDD%XDESC_ALB_PANEL (BDD%NDESC_CODE))
ALLOCATE(BDD%XDESC_EFF_PANEL (BDD%NDESC_CODE))
ALLOCATE(BDD%XDESC_FRAC_PANEL(BDD%NDESC_CODE))
!
ALLOCATE(BDD%NDESC_USE_LIST(BDD%NDESC_USE))
ALLOCATE(BDD%XDESC_TCOOL_TARGET(BDD%NDESC_USE))
ALLOCATE(BDD%XDESC_THEAT_TARGET(BDD%NDESC_USE))
ALLOCATE(BDD%XDESC_QIN(BDD%NDESC_USE))
ALLOCATE(BDD%XDESC_QIN_FLAT(BDD%NDESC_USE))
ALLOCATE(BDD%XDESC_SHGC_SH(BDD%NDESC_USE))
ALLOCATE(BDD%XDESC_SHADE(BDD%NDESC_USE))
ALLOCATE(BDD%XDESC_NATVENT(BDD%NDESC_USE))
ALLOCATE(BDD%XDESC_RESIDENTIAL(BDD%NDESC_USE))
!
ALLOCATE(BDD%NDESC_AGE_LIST(BDD%NDESC_AGE))
ALLOCATE(BDD%NDESC_AGE_DATE(BDD%NDESC_AGE))
!
!* default data for old files
BDD%XDESC_EMIS_PANEL = 0.9
BDD%XDESC_ALB_PANEL  = 0.1
BDD%XDESC_EFF_PANEL  = 0.14
BDD%XDESC_FRAC_PANEL = 0.   ! no solar panels for old versions of SURFEX
!-------------------------------------------------------------------------------
!
!*    3.   Read descriptive data
!          ---------------------
!
ITOT=(21+3*BDD%NDESC_ROOF_LAYER+3*BDD%NDESC_ROAD_LAYER+3*BDD%NDESC_WALL_LAYER+3*BDD%NDESC_FLOOR_LAYER)*BDD%NDESC_CODE &
      + 9*BDD%NDESC_USE + 2*BDD%NDESC_AGE + BDD%NDESC_BLD
ALLOCATE(ZWORK(ITOT))
!
 CALL READ_SURF(&
                HPROGRAM,'BLD_DESC_DAT',ZWORK,IRESP,HDIR='-')
!
!
I1=0 ; I2=0
 CALL UP_DESC_IND(BDD%NDESC_BLD)  ; BDD%NDESC_BLD_LIST(:)  = NINT(ZWORK(I1:I2))
 CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%NDESC_CODE_LIST(:)  = NINT(ZWORK(I1:I2))
 CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_ALB_ROOF(:)  = ZWORK(I1:I2)
 CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_ALB_ROAD(:)  = ZWORK(I1:I2)
 CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_ALB_WALL(:)  = ZWORK(I1:I2)
 CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_EMIS_ROOF(:) = ZWORK(I1:I2)
 CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_EMIS_ROAD(:) = ZWORK(I1:I2)
 CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_EMIS_WALL(:) = ZWORK(I1:I2)
DO JL=1,BDD%NDESC_ROOF_LAYER
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_HC_ROOF(:,JL) = ZWORK(I1:I2)
END DO
DO JL=1,BDD%NDESC_ROOF_LAYER
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_TC_ROOF(:,JL) = ZWORK(I1:I2)
END DO
DO JL=1,BDD%NDESC_ROOF_LAYER
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_D_ROOF (:,JL) = ZWORK(I1:I2)
END DO
DO JL=1,BDD%NDESC_ROAD_LAYER
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_HC_ROAD(:,JL) = ZWORK(I1:I2)
END DO
DO JL=1,BDD%NDESC_ROAD_LAYER
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_TC_ROAD(:,JL) = ZWORK(I1:I2)
END DO
DO JL=1,BDD%NDESC_ROAD_LAYER
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_D_ROAD (:,JL) = ZWORK(I1:I2)
END DO
DO JL=1,BDD%NDESC_WALL_LAYER
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_HC_WALL(:,JL) = ZWORK(I1:I2)
END DO
DO JL=1,BDD%NDESC_WALL_LAYER
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_TC_WALL(:,JL) = ZWORK(I1:I2)
END DO
DO JL=1,BDD%NDESC_WALL_LAYER
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_D_WALL (:,JL) = ZWORK(I1:I2)
END DO
DO JL=1,BDD%NDESC_FLOOR_LAYER
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_HC_FLOOR(:,JL) = ZWORK(I1:I2)
END DO
DO JL=1,BDD%NDESC_FLOOR_LAYER
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_TC_FLOOR(:,JL) = ZWORK(I1:I2)
END DO
DO JL=1,BDD%NDESC_FLOOR_LAYER
  CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_D_FLOOR (:,JL) = ZWORK(I1:I2)
END DO
!
 CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_SHGC(:)  = ZWORK(I1:I2)
 CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_U_WIN(:) = ZWORK(I1:I2)
 CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_GR(:)    = ZWORK(I1:I2)
!
 CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_F_WASTE_CAN(:)  = ZWORK(I1:I2)
 CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_F_WATER_COND(:) = ZWORK(I1:I2)
 CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_COP_RAT(:)      = ZWORK(I1:I2)
 CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_EFF_HEAT(:)     = ZWORK(I1:I2)
 CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_INF(:)          = ZWORK(I1:I2)
 CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_V_VENT(:)       = ZWORK(I1:I2)
 CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_GREENROOF(:)    = ZWORK(I1:I2)
 IF (IVERSION>7 .OR. (IVERSION==7 .AND. IBUGFIX>=4)) THEN
   CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_EMIS_PANEL(:)   = ZWORK(I1:I2)
   CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_ALB_PANEL(:)    = ZWORK(I1:I2)
   CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_EFF_PANEL(:)    = ZWORK(I1:I2)
   CALL UP_DESC_IND(BDD%NDESC_CODE) ; BDD%XDESC_FRAC_PANEL(:)   = ZWORK(I1:I2)
 END IF
!
 CALL UP_DESC_IND(BDD%NDESC_USE) ; BDD%NDESC_USE_LIST(:)     = NINT(ZWORK(I1:I2))
 CALL UP_DESC_IND(BDD%NDESC_USE) ; BDD%XDESC_TCOOL_TARGET(:) = ZWORK(I1:I2)
 CALL UP_DESC_IND(BDD%NDESC_USE) ; BDD%XDESC_THEAT_TARGET(:) = ZWORK(I1:I2)
 CALL UP_DESC_IND(BDD%NDESC_USE) ; BDD%XDESC_QIN(:)          = ZWORK(I1:I2)
 CALL UP_DESC_IND(BDD%NDESC_USE) ; BDD%XDESC_QIN_FLAT(:)     = ZWORK(I1:I2)
 CALL UP_DESC_IND(BDD%NDESC_USE) ; BDD%XDESC_SHGC_SH(:)      = ZWORK(I1:I2)
 CALL UP_DESC_IND(BDD%NDESC_USE) ; BDD%XDESC_SHADE(:)        = ZWORK(I1:I2)
 CALL UP_DESC_IND(BDD%NDESC_USE) ; BDD%XDESC_NATVENT(:)      = ZWORK(I1:I2)
 CALL UP_DESC_IND(BDD%NDESC_USE) ; BDD%XDESC_RESIDENTIAL(:)  = ZWORK(I1:I2)
!
 CALL UP_DESC_IND(BDD%NDESC_AGE) ; BDD%NDESC_AGE_LIST(:)     = NINT(ZWORK(I1:I2))
 CALL UP_DESC_IND(BDD%NDESC_AGE) ; BDD%NDESC_AGE_DATE(:)     = NINT(ZWORK(I1:I2))
!
DEALLOCATE(ZWORK)
!
IF (LHOOK) CALL DR_HOOK('READ_BLD_DESCRIPTION_n',1,ZHOOK_HANDLE)
!-------------------------------------------------------------------------------
CONTAINS
SUBROUTINE UP_DESC_IND(K)
INTEGER, INTENT(IN) :: K
I1=I2+1
I2=I2+K
END SUBROUTINE UP_DESC_IND
!-------------------------------------------------------------------------------
!
END SUBROUTINE READ_BLD_DESCRIPTION_n
