!----------------------------------------------------
!!    MODIFICATIONS
!!    -------------
!!      Original       
!!      J.Escobar      10/06/2013: replace DOUBLE PRECISION by REAL to handle problem for promotion of real on IBM SP
!----------------------------------------------------
!
MODULE MODI_READ_AND_SEND_MPI
!
INTERFACE READ_AND_SEND_MPI
!
SUBROUTINE READ_AND_SEND_MPI_N1D(KWORK,KWORK2,KMASK)
!
INTEGER, DIMENSION(:), INTENT(IN) :: KWORK
INTEGER, DIMENSION(:), INTENT(OUT) :: KWORK2
!
INTEGER, DIMENSION(:), INTENT(IN), OPTIONAL :: KMASK
!
END SUBROUTINE READ_AND_SEND_MPI_N1D
!
SUBROUTINE READ_AND_SEND_MPI_N2D(KWORK,KWORK2,KMASK)
!
INTEGER, DIMENSION(:,:), INTENT(IN) :: KWORK
INTEGER, DIMENSION(:,:), INTENT(OUT) :: KWORK2
!
INTEGER, DIMENSION(:), INTENT(IN), OPTIONAL :: KMASK
!
END SUBROUTINE READ_AND_SEND_MPI_N2D
!
SUBROUTINE READ_AND_SEND_MPI_X1D(PWORK,PWORK2,KMASK)
!
REAL, DIMENSION(:), INTENT(IN) :: PWORK
REAL, DIMENSION(:), INTENT(OUT) :: PWORK2
!
INTEGER, DIMENSION(:), INTENT(IN), OPTIONAL :: KMASK
!
END SUBROUTINE READ_AND_SEND_MPI_X1D
!
SUBROUTINE READ_AND_SEND_MPI_X2D(PWORK,PWORK2,KMASK)
!
REAL, DIMENSION(:,:), INTENT(IN) :: PWORK
REAL, DIMENSION(:,:), INTENT(OUT) :: PWORK2
!
INTEGER, DIMENSION(:), INTENT(IN), OPTIONAL :: KMASK
!
END SUBROUTINE READ_AND_SEND_MPI_X2D
!
SUBROUTINE READ_AND_SEND_MPI_X3D(PWORK,PWORK2,KMASK)
!
REAL, DIMENSION(:,:,:), INTENT(IN) :: PWORK
REAL, DIMENSION(:,:,:), INTENT(OUT) :: PWORK2
!
INTEGER, DIMENSION(:), INTENT(IN), OPTIONAL :: KMASK
!
END SUBROUTINE READ_AND_SEND_MPI_X3D
!
END INTERFACE
!
END MODULE MODI_READ_AND_SEND_MPI
!
SUBROUTINE READ_AND_SEND_MPI_N1D(KWORK,KWORK2,KMASK)
!
USE MODD_SURFEX_MPI, ONLY : NINDEX, NPROC, NRANK, NCOMM, NPIO, NSIZE, &
                            XTIME_NPIO_READ, XTIME_COMM_READ, IDX_R, WLOG_MPI
USE MODD_SURFEX_OMP, ONLY : NINDX1SFX, NINDX2SFX, NWORK, NBLOCK
!
USE MODI_PACK_SAME_RANK
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
#ifdef SFX_MPI
INCLUDE "mpif.h"
#endif
!
INTEGER, DIMENSION(:), INTENT(IN) :: KWORK
INTEGER, DIMENSION(:), INTENT(OUT) :: KWORK2
!
INTEGER, DIMENSION(:), INTENT(IN), OPTIONAL :: KMASK
!
#ifdef SFX_MPI
INTEGER, DIMENSION(MPI_STATUS_SIZE) :: ISTATUS
#endif
INTEGER :: ICPT
INTEGER :: I,J
INTEGER :: INFOMPI
REAL :: XTIME0
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_N1D',0,ZHOOK_HANDLE)
!
!$OMP BARRIER
!
IF (NRANK==NPIO) THEN
  !
!$OMP SINGLE 
  !
  IDX_R = IDX_R + 1
  !
  DO I=1,NPROC-1
    !
#ifdef SFX_MPI
    XTIME0 = MPI_WTIME()
#endif
    !
    ICPT = 0
    !
    NWORK(:) = 0
    !
    DO J=1,SIZE(NINDEX)
      !
      IF ( NINDEX(J)==MOD(I,NPROC) ) THEN
        ICPT = ICPT + 1
        NWORK(ICPT) = KWORK(J)
      ENDIF
      !
    ENDDO
    !
#ifdef SFX_MPI
    XTIME_NPIO_READ = XTIME_NPIO_READ + (MPI_WTIME() - XTIME0)
    !  
    IF (I<NPROC) THEN
      XTIME0 = MPI_WTIME()
      CALL MPI_SEND(NWORK,SIZE(NWORK)*KIND(NWORK)/4,MPI_INTEGER,I,IDX_R,NCOMM,INFOMPI)
      XTIME_COMM_READ = XTIME_COMM_READ + (MPI_WTIME() - XTIME0)
    ENDIF
#endif
    !
  ENDDO
  !
!$OMP END SINGLE 
  ! 
ELSE
  !
!$OMP SINGLE
  ! 
  IDX_R = IDX_R + 1
  !  
#ifdef SFX_MPI
  NWORK(:) = 0
  !  
  XTIME0 = MPI_WTIME()
  CALL MPI_RECV(NWORK,SIZE(NWORK)*KIND(NWORK)/4,MPI_INTEGER,NPIO,IDX_R,NCOMM,ISTATUS,INFOMPI)
  XTIME_COMM_READ = XTIME_COMM_READ + (MPI_WTIME() - XTIME0)
#endif
  !
!$OMP END SINGLE
  !
ENDIF
!
IF (PRESENT(KMASK)) THEN
  CALL PACK_SAME_RANK(KMASK,NWORK(NINDX1SFX:NINDX2SFX),KWORK2)
ELSE
  KWORK2(:) = NWORK(NINDX1SFX:NINDX2SFX)
ENDIF
!
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_N1D',1,ZHOOK_HANDLE)
!
!
END SUBROUTINE READ_AND_SEND_MPI_N1D
!
!**************************************************************************
!
SUBROUTINE READ_AND_SEND_MPI_N2D(KWORK,KWORK2,KMASK)
!
USE MODD_SURFEX_MPI, ONLY : NINDEX, NPROC, NRANK, NCOMM, NPIO, NSIZE, &
                            XTIME_NPIO_READ, XTIME_COMM_READ, IDX_R, WLOG_MPI
USE MODD_SURFEX_OMP, ONLY : NINDX1SFX, NINDX2SFX, NWORK2, NBLOCK
!
USE MODI_PACK_SAME_RANK
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
#ifdef SFX_MPI
INCLUDE "mpif.h"
#endif
!
INTEGER, DIMENSION(:,:), INTENT(IN) :: KWORK
INTEGER, DIMENSION(:,:), INTENT(OUT) :: KWORK2
!
INTEGER, DIMENSION(:), INTENT(IN), OPTIONAL :: KMASK
!
#ifdef SFX_MPI
INTEGER, DIMENSION(MPI_STATUS_SIZE) :: ISTATUS
#endif
INTEGER :: IS2, IP2
INTEGER :: ICPT
INTEGER :: I,J, K
INTEGER :: INFOMPI
REAL XTIME0
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_N2D',0,ZHOOK_HANDLE)
!
!$OMP BARRIER
!
IP2 = SIZE(KWORK2,2)
IS2 = SIZE(NWORK2,2)
!
!$OMP SINGLE
IF (IP2>IS2) THEN
  DEALLOCATE(NWORK2)
  ALLOCATE(NWORK2(NSIZE,IP2))
ENDIF
!$OMP END SINGLE
!
IF (NRANK==NPIO) THEN
  !
!$OMP SINGLE 
  !
  IDX_R = IDX_R + 1
  !
  DO I=1,NPROC-1
    !
#ifdef SFX_MPI
    XTIME0 = MPI_WTIME()
#endif
    !
    ICPT = 0
    !
    NWORK2(:,1:IP2) = 0
    !
    DO J=1,SIZE(NINDEX)
      !
      IF ( NINDEX(J)==MOD(I,NPROC) ) THEN
        ICPT = ICPT + 1
        NWORK2(ICPT,1:IP2) = KWORK(J,:)
      ENDIF
      !
    ENDDO
    !
#ifdef SFX_MPI
    XTIME_NPIO_READ = XTIME_NPIO_READ + (MPI_WTIME() - XTIME0)
    !  
    IF (I<NPROC) THEN
      XTIME0 = MPI_WTIME()
      CALL MPI_SEND(NWORK2(:,1:IP2),NSIZE*IP2*KIND(NWORK2)/4,MPI_INTEGER,I,IDX_R,NCOMM,INFOMPI)
      XTIME_COMM_READ = XTIME_COMM_READ + (MPI_WTIME() - XTIME0)
    ENDIF
#endif
    !
  ENDDO
  !
!$OMP END SINGLE 
  ! 
ELSE
  !
!$OMP SINGLE
  ! 
  IDX_R = IDX_R + 1
  !  
#ifdef SFX_MPI
  NWORK2(:,1:IP2) = 0
  !  
  XTIME0 = MPI_WTIME()
  CALL MPI_RECV(NWORK2(:,1:IP2),NSIZE*IP2*KIND(NWORK2)/4,MPI_INTEGER,NPIO,IDX_R,NCOMM,ISTATUS,INFOMPI)
  XTIME_COMM_READ = XTIME_COMM_READ + (MPI_WTIME() - XTIME0)
#endif
  !
!$OMP END SINGLE
  !
ENDIF
!
IF (PRESENT(KMASK)) THEN
  CALL PACK_SAME_RANK(KMASK,NWORK2(NINDX1SFX:NINDX2SFX,1:IP2),KWORK2)
ELSE
  KWORK2(:,:) = NWORK2(NINDX1SFX:NINDX2SFX,1:IP2)
ENDIF
!
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_N2D',1,ZHOOK_HANDLE)
!
!
END SUBROUTINE READ_AND_SEND_MPI_N2D
!
!**************************************************************************
!
SUBROUTINE READ_AND_SEND_MPI_X1D(PWORK,PWORK2,KMASK)
!
USE MODD_SURFEX_MPI, ONLY : NINDEX, NPROC, NRANK, NCOMM, NPIO, NSIZE, &
                            XTIME_NPIO_READ, XTIME_COMM_READ, WLOG_MPI, IDX_R
USE MODD_SURFEX_OMP, ONLY : NINDX1SFX, NINDX2SFX, XWORK, NBLOCK             
!
USE MODI_PACK_SAME_RANK
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
#ifdef SFX_MPI
INCLUDE "mpif.h"
#endif
!
REAL, DIMENSION(:), INTENT(IN) :: PWORK
REAL, DIMENSION(:), INTENT(OUT) :: PWORK2
!
INTEGER, DIMENSION(:), INTENT(IN), OPTIONAL :: KMASK
!
#ifdef SFX_MPI
INTEGER, DIMENSION(MPI_STATUS_SIZE) :: ISTATUS
#endif
INTEGER :: ICPT
INTEGER :: I,J
INTEGER :: INFOMPI
REAL   :: XTIME0
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_X1D',0,ZHOOK_HANDLE)
!
!$OMP BARRIER
!
IF (NRANK==NPIO) THEN
  !
!$OMP SINGLE
  !
  IDX_R = IDX_R + 1
  !
  DO I=1,NPROC
    !
#ifdef SFX_MPI
    XTIME0 = MPI_WTIME()
#endif
    !
    ICPT = 0
    !
    XWORK(:) = 0.
    !
    DO J=1,SIZE(NINDEX)
      !
      IF ( NINDEX(J)==MOD(I,NPROC) ) THEN
        ICPT = ICPT + 1
        XWORK(ICPT) = PWORK(J)
      ENDIF
      !
    ENDDO
    !
#ifdef SFX_MPI
    XTIME_NPIO_READ = XTIME_NPIO_READ + (MPI_WTIME() - XTIME0)
    !
    IF (I<NPROC) THEN
      XTIME0 = MPI_WTIME()
      CALL MPI_SEND(XWORK,SIZE(XWORK)*KIND(XWORK)/4,MPI_REAL,I,IDX_R,NCOMM,INFOMPI)
      XTIME_COMM_READ = XTIME_COMM_READ + (MPI_WTIME() - XTIME0)
    ENDIF
#endif
    !
  ENDDO
  !
!$OMP END SINGLE
!
ELSE
  !
!$OMP SINGLE
  !  
  IDX_R = IDX_R + 1
  !
#ifdef SFX_MPI
  XWORK(:) = 0.
  !
  XTIME0 = MPI_WTIME()
  CALL MPI_RECV(XWORK,SIZE(XWORK)*KIND(XWORK)/4,MPI_REAL,NPIO,IDX_R,NCOMM,ISTATUS,INFOMPI)
  XTIME_COMM_READ = XTIME_COMM_READ + (MPI_WTIME() - XTIME0)
#endif
  !
!$OMP END SINGLE
  !
ENDIF
!
IF (PRESENT(KMASK)) THEN
  CALL PACK_SAME_RANK(KMASK,XWORK(NINDX1SFX:NINDX2SFX),PWORK2)
ELSE
  PWORK2(:) = XWORK(NINDX1SFX:NINDX2SFX)
ENDIF
!
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_X1D',1,ZHOOK_HANDLE)
!
END SUBROUTINE READ_AND_SEND_MPI_X1D
!
!**************************************************************************
!
SUBROUTINE READ_AND_SEND_MPI_X2D(PWORK,PWORK2,KMASK)
!
USE MODD_SURFEX_MPI, ONLY : NINDEX, NPROC, NRANK, NCOMM, NPIO, NSIZE, &
                            XTIME_NPIO_READ, XTIME_COMM_READ, WLOG_MPI, IDX_R
USE MODD_SURFEX_OMP, ONLY : NINDX1SFX, NINDX2SFX, XWORK2, NBLOCK
!
USE MODI_PACK_SAME_RANK
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
#ifdef SFX_MPI
INCLUDE "mpif.h"
#endif
!
REAL, DIMENSION(:,:), INTENT(IN) :: PWORK
REAL, DIMENSION(:,:), INTENT(OUT) :: PWORK2
!
INTEGER, DIMENSION(:), INTENT(IN), OPTIONAL :: KMASK
!
#ifdef SFX_MPI
INTEGER, DIMENSION(MPI_STATUS_SIZE) :: ISTATUS
#endif
INTEGER :: IS2, IP2
INTEGER :: ICPT
INTEGER :: I,J, K
INTEGER :: INFOMPI
REAL   :: XTIME0
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_X2D',0,ZHOOK_HANDLE)
!
!$OMP BARRIER
!
IP2 = SIZE(PWORK2,2)
IS2 = SIZE(XWORK2,2)
!
!$OMP SINGLE
IF (IP2>IS2) THEN
  DEALLOCATE(XWORK2)
  ALLOCATE(XWORK2(NSIZE,IP2))
ENDIF
!$OMP END SINGLE
!
IF (NRANK==NPIO) THEN
  !
!$OMP SINGLE
  !  
  IDX_R = IDX_R + 1
  !
  DO I=1,NPROC
    !
#ifdef SFX_MPI
    XTIME0 = MPI_WTIME()
#endif
    !
    ICPT = 0
    !    
    XWORK2(:,1:IP2) = 0.
    !
    DO J=1,SIZE(NINDEX)
      !
      IF ( NINDEX(J)==MOD(I,NPROC) ) THEN
        ICPT = ICPT + 1
        XWORK2(ICPT,1:IP2) = PWORK(J,:)
      ENDIF
      !
    ENDDO
    !
#ifdef SFX_MPI
    XTIME_NPIO_READ = XTIME_NPIO_READ + (MPI_WTIME() - XTIME0)
    !
    IF (I<NPROC) THEN
      XTIME0 = MPI_WTIME()
      CALL MPI_SEND(XWORK2(:,1:IP2),NSIZE*IP2*KIND(XWORK2)/4,MPI_REAL,I,IDX_R,NCOMM,INFOMPI)
      XTIME_COMM_READ = XTIME_COMM_READ + (MPI_WTIME() - XTIME0)
    ENDIF
#endif
    !
  ENDDO
  !
!$OMP END SINGLE
  !  
ELSE
  !
!$OMP SINGLE
  !
  IDX_R = IDX_R + 1
  !
#ifdef SFX_MPI
  XWORK2(:,1:IP2) = 0.
  !
  XTIME0 = MPI_WTIME()
  CALL MPI_RECV(XWORK2(:,1:IP2),NSIZE*IP2*KIND(XWORK2)/4,MPI_REAL,NPIO,IDX_R,NCOMM,ISTATUS,INFOMPI)
  XTIME_COMM_READ = XTIME_COMM_READ + (MPI_WTIME() - XTIME0)
#endif
  !
!$OMP END SINGLE
  !  
ENDIF
!
IF (PRESENT(KMASK)) THEN
  CALL PACK_SAME_RANK(KMASK,XWORK2(NINDX1SFX:NINDX2SFX,1:IP2),PWORK2)
ELSE
  PWORK2(:,:) = XWORK2(NINDX1SFX:NINDX2SFX,1:IP2)
ENDIF
!
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_X2D',1,ZHOOK_HANDLE)
!
END SUBROUTINE READ_AND_SEND_MPI_X2D
!**************************************************************************
!
SUBROUTINE READ_AND_SEND_MPI_X3D(PWORK,PWORK2,KMASK)
!
USE MODD_SURFEX_MPI, ONLY : NINDEX, NPROC, NRANK, NCOMM, NPIO, NSIZE, &
                            XTIME_NPIO_READ, XTIME_COMM_READ, IDX_R, WLOG_MPI
USE MODD_SURFEX_OMP, ONLY : NINDX1SFX, NINDX2SFX, XWORK3, NBLOCK
!
USE MODI_PACK_SAME_RANK
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
#ifdef SFX_MPI
INCLUDE "mpif.h"
#endif
!
REAL, DIMENSION(:,:,:), INTENT(IN) :: PWORK
REAL, DIMENSION(:,:,:), INTENT(OUT) :: PWORK2
!
INTEGER, DIMENSION(:), INTENT(IN), OPTIONAL :: KMASK
!
#ifdef SFX_MPI
INTEGER, DIMENSION(MPI_STATUS_SIZE) :: ISTATUS
#endif
INTEGER :: IP2, IS2, IP3, IS3
INTEGER :: ICPT 
INTEGER :: I,J
INTEGER :: INFOMPI
REAL   :: XTIME0
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_X3D',0,ZHOOK_HANDLE)
!
!$OMP BARRIER
!
IP2 = SIZE(PWORK2,2)
IP3 = SIZE(PWORK2,3)
IS2 = SIZE(XWORK3,2)
IS3 = SIZE(XWORK3,3)
!
!$OMP SINGLE
IF (IP2>IS2 .OR. IP3>IS3) THEN
  DEALLOCATE(XWORK3)
  ALLOCATE(XWORK3(NSIZE,MAX(IP2,IS2),MAX(IP3,IS3)))
ENDIF
!$OMP END SINGLE
!
IF (NRANK==NPIO) THEN
  !
!$OMP SINGLE
  !  
  IDX_R = IDX_R + 1
  !  
  DO I=1,NPROC
    !
#ifdef SFX_MPI
    XTIME0 = MPI_WTIME()
#endif
    ! 
    ICPT = 0
    !
    XWORK3(:,1:IP2,1:IP3) = 0.
    !
    DO J=1,SIZE(NINDEX)
      !
      IF ( NINDEX(J)==MOD(I,NPROC) ) THEN
        ICPT = ICPT + 1
        XWORK3(ICPT,1:IP2,1:IP3) = PWORK(J,:,:)
      ENDIF
      !
    ENDDO
    !
#ifdef SFX_MPI
    XTIME_NPIO_READ = XTIME_NPIO_READ + (MPI_WTIME() - XTIME0)
    !
    IF (I<NPROC) THEN
      XTIME0 = MPI_WTIME()
      CALL MPI_SEND(XWORK3(:,1:IP2,1:IP3),NSIZE*IP2*IP3*KIND(XWORK3)/4,MPI_REAL,I,IDX_R,NCOMM,INFOMPI)
      XTIME_COMM_READ = XTIME_COMM_READ + (MPI_WTIME() - XTIME0)
    ENDIF
#endif
    !
  ENDDO
  !
!$OMP END SINGLE
  !  
ELSE
  !
!$OMP SINGLE
  !  
  IDX_R = IDX_R + 1
  !
#ifdef SFX_MPI
  XWORK3(:,1:IP2,1:IP3) = 0.
  !
  XTIME0 = MPI_WTIME()  
  CALL MPI_RECV(XWORK3(:,1:IP2,1:IP3),NSIZE*IP2*IP3*KIND(XWORK3)/4,MPI_REAL,NPIO,IDX_R,NCOMM,ISTATUS,INFOMPI)
  XTIME_COMM_READ = XTIME_COMM_READ + (MPI_WTIME() - XTIME0)
#endif
  !
!$OMP END SINGLE
  !  
ENDIF
!
IF (PRESENT(KMASK)) THEN
  CALL PACK_SAME_RANK(KMASK,XWORK3(NINDX1SFX:NINDX2SFX,1:IP2,1:IP3),PWORK2)
ELSE
  PWORK2(:,:,:) = XWORK3(NINDX1SFX:NINDX2SFX,1:IP2,1:IP3)
ENDIF
!
IF (LHOOK) CALL DR_HOOK('READ_AND_SEND_MPI_X3D',1,ZHOOK_HANDLE)
!
!
END SUBROUTINE READ_AND_SEND_MPI_X3D
