!     #########
      SUBROUTINE PREP_CTRL_SEAFLUX(K2M,OSURF_BUDGET,O2M_MIN_ZS,ORAD_BUDGET,OCOEF,OSURF_VARS,&
                                     ODIAG_OCEAN,ODIAG_SEAICE,KLUOUT,OSURF_BUDGETC)  
!     #################################################################################################################
!
!!****  *PREP_CTRL_SEAFLUX* - routine to check that diagnostics are switched off
!!
!!    PURPOSE
!!    -------
!!
!!**  METHOD
!!    ------
!!
!!    EXTERNAL
!!    --------
!!
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!
!!    AUTHOR
!!    ------
!!      P. Le Moigne   *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    04/2007 
!!      Modified    09/2013 : S. Senesi : manage ODIAG_SEAICE
!-------------------------------------------------------------------------------
!
!*       0.    DECLARATIONS
!              ------------
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*       0.1   Declarations of arguments
!              -------------------------
!
!
INTEGER,  INTENT(INOUT) :: K2M                ! flag for 2m parameters
LOGICAL,  INTENT(INOUT) :: OSURF_BUDGET       ! flag for surface budget
LOGICAL,  INTENT(INOUT) :: O2M_MIN_ZS         ! flag for 2m parameters at min zs
LOGICAL,  INTENT(INOUT) :: ORAD_BUDGET        ! flag for radiative budget
LOGICAL,  INTENT(INOUT) :: OCOEF              ! flag for turbulent coefficients
LOGICAL,  INTENT(INOUT) :: OSURF_VARS         ! flag for other surface variables
LOGICAL,  INTENT(INOUT) :: ODIAG_OCEAN        ! flag for ocean variables
LOGICAL,  INTENT(INOUT) :: ODIAG_SEAICE       ! flag for seaice variables
INTEGER,  INTENT(IN)    :: KLUOUT             ! unit number
LOGICAL,  INTENT(INOUT) :: OSURF_BUDGETC ! flag for cumulated surface budget
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!*       0.2   Declarations of local variables
!              -------------------------------
!
!-------------------------------------------------------------------------------
!
IF (LHOOK) CALL DR_HOOK('PREP_CTRL_SEAFLUX',0,ZHOOK_HANDLE)
K2M = 0
!
OSURF_BUDGET  = .FALSE.
O2M_MIN_ZS    = .FALSE.
ORAD_BUDGET   = .FALSE.
OCOEF         = .FALSE.
OSURF_VARS    = .FALSE.
ODIAG_OCEAN   = .FALSE.
ODIAG_SEAICE  = .FALSE.
OSURF_BUDGETC = .FALSE.
!
WRITE(KLUOUT,*)'SEAFLUX DIAGNOSTICS DESACTIVATED'
IF (LHOOK) CALL DR_HOOK('PREP_CTRL_SEAFLUX',1,ZHOOK_HANDLE)
!-------------------------------------------------------------------------------
!
END SUBROUTINE PREP_CTRL_SEAFLUX
