!     #########
SUBROUTINE PACK_ISBA_PATCH_n (AG, IG, I, PKI, &
                              KMASK,KSIZE,KPATCH)
!##############################################
!
!
!!****  *PACK_ISBA_PATCH_n * - packs ISBA variables
!!
!!    PURPOSE
!!    -------
!
!!**  METHOD
!!    ------
!!
!!    REFERENCE
!!    ---------
!!      
!!
!!    AUTHOR
!!    ------
!!     V. Masson and A. boone
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    01/2004
!!      B. Decharme    2008 floodplains
!!      B. Decharme 01/2009 Good dim for XP_TG
!!      A.L. Gibelin 04/2009 : BIOMASS and RESP_BIOMASS arrays 
!!      A.L. Gibelin 04/2009 : TAU_WOOD for NCB option 
!!      A.L. Gibelin 05/2009 : Add carbon spinup
!!      A.L. Gibelin 06/2009 : Soil carbon variables for CNT option
!!      A.L. Gibelin 07/2009 : Suppress RDK and transform GPP as a diagnostic
!!      A.L. Gibelin 07/2009 : Suppress PPST and PPSTF as outputs
!!      B. Decharme  04/2013 : DIF lateral subsurface drainage
!!                             water table / surface coupling
!!      P Samuelsson 10/2014 : MEB
!!      P Samuelsson 10/2014 : Additional snow albedos
!!
!!------------------------------------------------------------------
!
!
USE MODD_AGRI_n, ONLY : AGRI_t
USE MODD_ISBA_GRID_n, ONLY : ISBA_GRID_t
USE MODD_ISBA_n, ONLY : ISBA_t
USE MODD_PACK_ISBA, ONLY : PACK_ISBA_t
!
USE MODD_DATA_COVER_PAR,  ONLY : NVEGTYPE
!
USE MODD_TREEDRAG,    ONLY : LTREEDRAG
USE MODD_AGRI,        ONLY : LAGRIP
                             

!
USE MODD_CSTS,       ONLY : XLVTT, XLSTT, XCPD
!
USE MODI_ABOR1_SFX
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!
TYPE(AGRI_t), INTENT(INOUT) :: AG
TYPE(ISBA_GRID_t), INTENT(INOUT) :: IG
TYPE(ISBA_t), INTENT(INOUT) :: I
TYPE(PACK_ISBA_t), INTENT(INOUT) :: PKI
!
INTEGER, INTENT(IN)               :: KSIZE, KPATCH
INTEGER, DIMENSION(:), INTENT(IN) :: KMASK
!
INTEGER :: ISIZE_LSIMPLE, ISIZE_L0, ISIZE_TSIMPLE, ISIZE_T0, ISIZE_SIMPLE,  &
           ISIZE_GROUND, ISIZE_VEGTYPE, ISIZE_TG, ISIZE_SNOW, ISIZE_ALB,    &
           ISIZE_2, ISIZE_BIOMASS, ISIZE_SOILCARB, ISIZE_LITTLEVS,          &
           ISIZE_LITTER, ISIZE_0, ISIZE_00,ISIZE_000, ISIZE_01,             &
           ISIZE_NSIMPLE, ISIZE_N0
!
INTEGER :: JJ, JI, JK, JL 
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!------------------------------------------------------------------------
IF (LHOOK) CALL DR_HOOK('PACK_ISBA_PATCH_N',0,ZHOOK_HANDLE)
!
ALLOCATE(PKI%LBLOCK_SIMPLE(KSIZE,PKI%NSIZE_LSIMPLE))
ALLOCATE(PKI%LBLOCK_0(0,PKI%NSIZE_L0))
ALLOCATE(PKI%NBLOCK_SIMPLE(KSIZE,PKI%NSIZE_NSIMPLE))
ALLOCATE(PKI%NBLOCK_0(0,PKI%NSIZE_N0))
ALLOCATE(PKI%TBLOCK_SIMPLE(KSIZE,PKI%NSIZE_TSIMPLE))
ALLOCATE(PKI%TBLOCK_0(0,PKI%NSIZE_T0))
ALLOCATE(PKI%XBLOCK_SIMPLE(KSIZE,PKI%NSIZE_SIMPLE))
ALLOCATE(PKI%XBLOCK_GROUND(KSIZE,I%NGROUND_LAYER,PKI%NSIZE_GROUND))
ALLOCATE(PKI%XBLOCK_VEGTYPE(KSIZE,NVEGTYPE,PKI%NSIZE_VEGTYPE))
ALLOCATE(PKI%XBLOCK_TG(KSIZE,SIZE(I%XTG,2),PKI%NSIZE_TG))
ALLOCATE(PKI%XBLOCK_SNOW(KSIZE,I%TSNOW%NLAYER,PKI%NSIZE_SNOW))
ALLOCATE(PKI%XBLOCK_ALB(KSIZE,SIZE(I%XDIR_ALB_WITH_SNOW,2),PKI%NSIZE_ALB))
ALLOCATE(PKI%XBLOCK_2(KSIZE,2,PKI%NSIZE_2))
ALLOCATE(PKI%XBLOCK_BIOMASS(KSIZE,I%NNBIOMASS,PKI%NSIZE_BIOMASS))
ALLOCATE(PKI%XBLOCK_SOILCARB(KSIZE,I%NNSOILCARB,PKI%NSIZE_SOILCARB))
ALLOCATE(PKI%XBLOCK_LITTLEVS(KSIZE,I%NNLITTLEVS,PKI%NSIZE_LITTLEVS))
ALLOCATE(PKI%XBLOCK_LITTER(KSIZE,I%NNLITTER,I%NNLITTLEVS,PKI%NSIZE_LITTER))
ALLOCATE(PKI%XBLOCK_0(0,PKI%NSIZE_0))
ALLOCATE(PKI%XBLOCK_00(0,0,PKI%NSIZE_00))
ALLOCATE(PKI%XBLOCK_000(0,0,0,PKI%NSIZE_000))
ALLOCATE(PKI%XBLOCK_01(0,1,PKI%NSIZE_01))
!
ISIZE_LSIMPLE=0
ISIZE_L0=0
ISIZE_NSIMPLE=0
ISIZE_N0=0
ISIZE_TSIMPLE=0
ISIZE_T0=0
ISIZE_SIMPLE=0
ISIZE_GROUND=0
ISIZE_VEGTYPE=0
ISIZE_TG=0
ISIZE_SNOW=0
ISIZE_ALB=0
ISIZE_2=0
ISIZE_BIOMASS=0
ISIZE_LITTER=0
ISIZE_SOILCARB=0
ISIZE_LITTLEVS=0
ISIZE_0=0
ISIZE_00=0
ISIZE_000=0
ISIZE_01=0
!
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_Z0_O_Z0H     => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_EMIS         => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_ALBNIR       => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_ALBVIS       => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_ALBUV        => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_ALBNIR_VEG   => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_ALBVIS_VEG   => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_ALBUV_VEG    => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_ALBNIR_SOIL  => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_ALBVIS_SOIL  => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_ALBUV_SOIL   => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_Z0           => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE) 
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_WRMAX_CF     => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_GAMMA        => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_CV           => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_RGL          => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_RUNOFFD      => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_Z0EFFIP      => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_Z0EFFIM      => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_Z0EFFJP      => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_Z0EFFJM      => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_WR           => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_LAI          => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE) 
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_RESA         => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE) 
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_CPS          => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_LVTT         => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_LSTT         => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_VEG          => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE) 
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_SNOWALB      => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE) 
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_LE           => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE) 
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_PSN          => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_PSNG         => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_PSNV         => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_ALBNIR_DRY   => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_ALBVIS_DRY   => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_ALBUV_DRY    => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_ALBNIR_WET   => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_ALBVIS_WET   => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_ALBUV_WET    => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_RUNOFFB      => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_WDRAIN       => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_TAUICE       => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_Z0REL        => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_AOSIP        => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_AOSIM        => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_AOSJP        => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_AOSJM        => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_HO2IP        => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_HO2IM        => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_HO2JP        => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_HO2JM        => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_SSO_SLOPE    => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_GAMMAT       => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_TDEEP        => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_LAT        => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_LON        => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
!
ISIZE_GROUND = ISIZE_GROUND + 1
PKI%XP_CLAY         => PKI%XBLOCK_GROUND(:,:,ISIZE_GROUND)
ISIZE_GROUND = ISIZE_GROUND + 1
PKI%XP_SAND         => PKI%XBLOCK_GROUND(:,:,ISIZE_GROUND)
ISIZE_GROUND = ISIZE_GROUND + 1
PKI%XP_WFC          => PKI%XBLOCK_GROUND(:,:,ISIZE_GROUND)
ISIZE_GROUND = ISIZE_GROUND + 1
PKI%XP_WWILT        => PKI%XBLOCK_GROUND(:,:,ISIZE_GROUND)
ISIZE_GROUND = ISIZE_GROUND + 1
PKI%XP_WSAT         => PKI%XBLOCK_GROUND(:,:,ISIZE_GROUND)
ISIZE_GROUND = ISIZE_GROUND + 1
PKI%XP_CONDSAT      => PKI%XBLOCK_GROUND(:,:,ISIZE_GROUND)
ISIZE_GROUND = ISIZE_GROUND + 1
PKI%XP_DG           => PKI%XBLOCK_GROUND(:,:,ISIZE_GROUND)
ISIZE_GROUND = ISIZE_GROUND + 1
PKI%XP_WG           => PKI%XBLOCK_GROUND(:,:,ISIZE_GROUND)
ISIZE_GROUND = ISIZE_GROUND + 1
PKI%XP_WGI          => PKI%XBLOCK_GROUND(:,:,ISIZE_GROUND)
!
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_KSAT_ICE     => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_D_ICE        => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
!
ISIZE_VEGTYPE = ISIZE_VEGTYPE + 1
PKI%XP_VEGTYPE_PATCH => PKI%XBLOCK_VEGTYPE(:,:,ISIZE_VEGTYPE)
!
ISIZE_TG = ISIZE_TG + 1
PKI%XP_TG           => PKI%XBLOCK_TG(:,:,ISIZE_TG)
!
ISIZE_SNOW = ISIZE_SNOW + 1
PKI%XP_SNOWSWE      => PKI%XBLOCK_SNOW(:,:,ISIZE_SNOW)
ISIZE_SNOW = ISIZE_SNOW + 1
PKI%XP_SNOWRHO      => PKI%XBLOCK_SNOW(:,:,ISIZE_SNOW)
!
ISIZE_ALB = ISIZE_ALB + 1
PKI%XP_DIR_ALB_WITH_SNOW=> PKI%XBLOCK_ALB(:,:,ISIZE_ALB)
ISIZE_ALB = ISIZE_ALB + 1
PKI%XP_SCA_ALB_WITH_SNOW=> PKI%XBLOCK_ALB(:,:,ISIZE_ALB)
!
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_FFLOOD       => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_PIFLOOD      => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_FF           => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_FFG          => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_FFV          => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_FFROZEN      => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_ALBF         => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_EMISF        => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKI%XP_FSAT         => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
!
IF(I%TSNOW%SCHEME=='EBA') THEN
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
   PKI%XP_PSNV_A      => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ELSE
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_PSNV_A       => PKI%XBLOCK_0(:,ISIZE_0)
ENDIF
!
IF (I%TSNOW%SCHEME=='3-L' .OR. I%TSNOW%SCHEME=='CRO') THEN
  ISIZE_SNOW = ISIZE_SNOW + 1
   PKI%XP_SNOWHEAT   => PKI%XBLOCK_SNOW(:,:,ISIZE_SNOW)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
   PKI%XP_SNOWEMIS   => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SNOW = ISIZE_SNOW + 1
   PKI%XP_SNOWAGE    => PKI%XBLOCK_SNOW(:,:,ISIZE_SNOW)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
   PKI%XP_SNOWALBVIS   => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE) 
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
   PKI%XP_SNOWALBNIR   => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE) 
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
   PKI%XP_SNOWALBFIR   => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE) 
ELSE
  ISIZE_00 = ISIZE_00 + 1
  PKI%XP_SNOWHEAT   => PKI%XBLOCK_00(:,:,ISIZE_00) 
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_SNOWEMIS   => PKI%XBLOCK_0(:,ISIZE_0)
  ISIZE_00 = ISIZE_00 + 1
  PKI%XP_SNOWAGE    => PKI%XBLOCK_00(:,:,ISIZE_00)
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_SNOWALBVIS   => PKI%XBLOCK_0(:,ISIZE_0) 
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_SNOWALBNIR   => PKI%XBLOCK_0(:,ISIZE_0) 
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_SNOWALBFIR   => PKI%XBLOCK_0(:,ISIZE_0) 
END IF
!
IF(I%TSNOW%SCHEME=='CRO') THEN
  ISIZE_SNOW = ISIZE_SNOW + 1
   PKI%XP_SNOWGRAN1  => PKI%XBLOCK_SNOW(:,:,ISIZE_SNOW)
  ISIZE_SNOW = ISIZE_SNOW + 1
   PKI%XP_SNOWGRAN2  => PKI%XBLOCK_SNOW(:,:,ISIZE_SNOW)
  ISIZE_SNOW = ISIZE_SNOW + 1
   PKI%XP_SNOWHIST   => PKI%XBLOCK_SNOW(:,:,ISIZE_SNOW)
ELSE      
  ISIZE_00 = ISIZE_00 + 1
  PKI%XP_SNOWGRAN1  => PKI%XBLOCK_00(:,:,ISIZE_00)  
  ISIZE_00 = ISIZE_00 + 1
  PKI%XP_SNOWGRAN2  => PKI%XBLOCK_00(:,:,ISIZE_00) 
  ISIZE_00 = ISIZE_00 + 1
  PKI%XP_SNOWHIST   => PKI%XBLOCK_00(:,:,ISIZE_00) 
END IF
!
IF(I%LGLACIER)THEN  
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1  
   PKI%XP_ICE_STO=> PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ELSE     
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_ICE_STO=> PKI%XBLOCK_0(:,ISIZE_0)
ENDIF
!
IF (I%CSCOND=='PL98'.OR.I%CISBA=='DIF') THEN
  ISIZE_GROUND = ISIZE_GROUND + 1
   PKI%XP_HCAPSOIL   => PKI%XBLOCK_GROUND(:,:,ISIZE_GROUND)
  ISIZE_GROUND = ISIZE_GROUND + 1
   PKI%XP_CONDDRY    => PKI%XBLOCK_GROUND(:,:,ISIZE_GROUND)
  ISIZE_GROUND = ISIZE_GROUND + 1
   PKI%XP_CONDSLD    => PKI%XBLOCK_GROUND(:,:,ISIZE_GROUND)   
ELSE
  ISIZE_01 = ISIZE_01 + 1
  PKI%XP_HCAPSOIL   => PKI%XBLOCK_01(:,:,ISIZE_01)
  ISIZE_01 = ISIZE_01 + 1
  PKI%XP_CONDDRY    => PKI%XBLOCK_01(:,:,ISIZE_01)
  ISIZE_01 = ISIZE_01 + 1
  PKI%XP_CONDSLD    => PKI%XBLOCK_01(:,:,ISIZE_01)
END IF
!
IF (I%CISBA=='2-L' .OR. I%CISBA=='3-L') THEN   
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
   PKI%XP_C4B          => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE) 
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
   PKI%XP_ACOEF        => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
 ISIZE_SIMPLE = ISIZE_SIMPLE + 1
   PKI%XP_PCOEF        => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
   PKI%XP_CGSAT        => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE) 
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
   PKI%XP_C1SAT        => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE) 
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
   PKI%XP_C2REF        => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE) 
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
   PKI%XP_C4REF        => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)   
  ISIZE_2 = ISIZE_2 + 1
  PKI%XP_C3           => PKI%XBLOCK_2(:,:,ISIZE_2)
ELSE
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_C4B          => PKI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_ACOEF        => PKI%XBLOCK_0(:,ISIZE_0) 
 ISIZE_0 = ISIZE_0 + 1
  PKI%XP_PCOEF        => PKI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_CGSAT        => PKI%XBLOCK_0(:,ISIZE_0) 
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_C1SAT        => PKI%XBLOCK_0(:,ISIZE_0) 
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_C2REF        => PKI%XBLOCK_0(:,ISIZE_0)   
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_C4REF        => PKI%XBLOCK_0(:,ISIZE_0)  
  ISIZE_00 = ISIZE_00 + 1
  PKI%XP_C3           => PKI%XBLOCK_00(:,:,ISIZE_00)   
END IF
!
ISIZE_GROUND = ISIZE_GROUND + 1
PKI%XP_MPOTSAT    => PKI%XBLOCK_GROUND(:,:,ISIZE_GROUND)
ISIZE_GROUND = ISIZE_GROUND + 1
PKI%XP_BCOEF      => PKI%XBLOCK_GROUND(:,:,ISIZE_GROUND)
!
IF (I%CISBA=='DIF') THEN
!
  ISIZE_GROUND = ISIZE_GROUND + 1
   PKI%XP_ROOTFRAC   => PKI%XBLOCK_GROUND(:,:,ISIZE_GROUND) 
  ISIZE_GROUND = ISIZE_GROUND + 1
   PKI%XP_DZG        => PKI%XBLOCK_GROUND(:,:,ISIZE_GROUND)
  ISIZE_GROUND = ISIZE_GROUND + 1
   PKI%XP_DZDIF      => PKI%XBLOCK_GROUND(:,:,ISIZE_GROUND) 
  ISIZE_GROUND = ISIZE_GROUND + 1
   PKI%XP_SOILWGHT   => PKI%XBLOCK_GROUND(:,:,ISIZE_GROUND)
!
  ISIZE_NSIMPLE = ISIZE_NSIMPLE + 1
   PKI%NK_WG_LAYER   => PKI%NBLOCK_SIMPLE(:,ISIZE_NSIMPLE)
! 
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1  
   PKI%XP_FWTD=> PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1  
   PKI%XP_WTD=> PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
!
ELSE
!
  ISIZE_01 = ISIZE_01 + 1
  PKI%XP_ROOTFRAC   => PKI%XBLOCK_01(:,:,ISIZE_01)
  ISIZE_01 = ISIZE_01 + 1
  PKI%XP_DZG        => PKI%XBLOCK_01(:,:,ISIZE_01)
  ISIZE_01 = ISIZE_01 + 1
  PKI%XP_DZDIF      => PKI%XBLOCK_01(:,:,ISIZE_01)
  ISIZE_01 = ISIZE_01 + 1
  PKI%XP_SOILWGHT   => PKI%XBLOCK_01(:,:,ISIZE_01)  
!  
  ISIZE_N0 = ISIZE_N0 + 1
   PKI%NK_WG_LAYER   => PKI%NBLOCK_0(:,ISIZE_N0)
!  
  ISIZE_0 = ISIZE_0 + 1
   PKI%XP_FWTD=> PKI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
   PKI%XP_WTD=> PKI%XBLOCK_0(:,ISIZE_0)
!
END IF
!
IF (I%CISBA=='DIF'.AND.I%CRUNOFF=='SGH') THEN
!
  ISIZE_GROUND = ISIZE_GROUND + 1
  PKI%XP_TOPQS => PKI%XBLOCK_GROUND(:,:,ISIZE_GROUND)
!  
ELSE
!
  ISIZE_01 = ISIZE_01 + 1
  PKI%XP_TOPQS   => PKI%XBLOCK_01(:,:,ISIZE_01)
!   
END IF
!
IF (I%LTR_ML) THEN
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKI%XP_FAPARC => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKI%XP_FAPIRC => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKI%XP_LAI_EFFC => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKI%XP_MUS => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)  
ELSE
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_FAPARC => PKI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_FAPIRC => PKI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_LAI_EFFC => PKI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_MUS => PKI%XBLOCK_0(:,ISIZE_0)
ENDIF
!
IF (I%CPHOTO=='NON') THEN
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
   PKI%XP_RSMIN      => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ELSE
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_RSMIN      => PKI%XBLOCK_0(:,ISIZE_0)
END IF
!
IF (I%CPHOTO/='NON' .OR. I%LMEB_PATCH(KPATCH)) THEN
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
   PKI%XP_BSLAI      => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ELSE
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_BSLAI      => PKI%XBLOCK_0(:,ISIZE_0)
ENDIF
!
IF (I%CPHOTO/='NON'.OR.LTREEDRAG) THEN
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKI%XP_H_TREE     => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ELSE
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_H_TREE     => PKI%XBLOCK_0(:,ISIZE_0)       
ENDIF
!
IF (I%CPHOTO/='NON') THEN
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
   PKI%XP_LAIMIN     => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
   PKI%XP_SEFOLD     => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
   PKI%XP_ANF        => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
   PKI%XP_ANMAX      => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
   PKI%XP_FZERO      => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
   PKI%XP_EPSO       => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
   PKI%XP_GAMM       => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
   PKI%XP_QDGAMM     => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
   PKI%XP_GMES       => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
   PKI%XP_RE25       => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
   PKI%XP_QDGMES     => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
   PKI%XP_T1GMES     => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
   PKI%XP_T2GMES     => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
   PKI%XP_AMAX       => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
   PKI%XP_QDAMAX     => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
   PKI%XP_T1AMAX     => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
   PKI%XP_T2AMAX     => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
   PKI%XP_AN         => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE) 
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
   PKI%XP_ANDAY      => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE) 
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
   PKI%XP_ANFM       => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE) 
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
   PKI%XP_GC         => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_BIOMASS = ISIZE_BIOMASS + 1
  PKI%XP_BIOMASS        => PKI%XBLOCK_BIOMASS(:,:,ISIZE_BIOMASS)
  ISIZE_BIOMASS = ISIZE_BIOMASS + 1 
  PKI%XP_RESP_BIOMASS   => PKI%XBLOCK_BIOMASS(:,:,ISIZE_BIOMASS)
ELSE
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_LAIMIN     => PKI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_SEFOLD     => PKI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_ANF        => PKI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_ANMAX      => PKI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_FZERO      => PKI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_EPSO       => PKI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_GAMM       => PKI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_QDGAMM     => PKI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_GMES       => PKI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_RE25       => PKI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_QDGMES     => PKI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_T1GMES     => PKI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_T2GMES     => PKI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_AMAX       => PKI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_QDAMAX     => PKI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_T1AMAX     => PKI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_T2AMAX     => PKI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_AN         => PKI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_ANDAY      => PKI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_ANFM       => PKI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_GC         => PKI%XBLOCK_0(:,ISIZE_0)
  ISIZE_00 = ISIZE_00 + 1
  PKI%XP_BIOMASS        => PKI%XBLOCK_00(:,:,ISIZE_00)
  ISIZE_00 = ISIZE_00 + 1
  PKI%XP_RESP_BIOMASS   => PKI%XBLOCK_00(:,:,ISIZE_00)
END IF
!
IF (I%CPHOTO=='AST' .OR. I%CPHOTO=='LST' .OR. I%CPHOTO=='NIT' .OR. I%CPHOTO=='NCB') THEN
  ISIZE_LSIMPLE = ISIZE_LSIMPLE + 1
  PKI%LP_STRESS     => PKI%LBLOCK_SIMPLE(:,ISIZE_LSIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
   PKI%XP_F2I        => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
   PKI%XP_AH         => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
   PKI%XP_BH         => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
   PKI%XP_DMAX       => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ELSE
  ISIZE_L0 = ISIZE_L0 + 1
  PKI%LP_STRESS     => PKI%LBLOCK_0(:,ISIZE_L0)
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_F2I        => PKI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_AH         => PKI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_BH         => PKI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_DMAX       => PKI%XBLOCK_0(:,ISIZE_0)
END IF
!
IF (I%CPHOTO=='LAI' .OR. I%CPHOTO=='LST' .OR. I%CPHOTO=='NIT' .OR. I%CPHOTO=='NCB') THEN
  ISIZE_TSIMPLE = ISIZE_TSIMPLE + 1
  PKI%TP_SEED           => PKI%TBLOCK_SIMPLE(:,ISIZE_TSIMPLE)
  ISIZE_TSIMPLE = ISIZE_TSIMPLE + 1
  PKI%TP_REAP           => PKI%TBLOCK_SIMPLE(:,ISIZE_TSIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
   PKI%XP_IRRIG          => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
   PKI%XP_WATSUP         => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  IF (LAGRIP) THEN
     ISIZE_LSIMPLE = ISIZE_LSIMPLE + 1
     PKI%XP_LIRRIDAY       => PKI%LBLOCK_SIMPLE(:,ISIZE_LSIMPLE)
     ISIZE_SIMPLE = ISIZE_SIMPLE + 1
     PKI%XP_THRESHOLD      => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
     ISIZE_LSIMPLE = ISIZE_LSIMPLE + 1
     PKI%XP_LIRRIGATE      => PKI%LBLOCK_SIMPLE(:,ISIZE_LSIMPLE)
  ELSE
     ISIZE_L0 = ISIZE_L0 + 1
     PKI%XP_LIRRIDAY       => PKI%LBLOCK_0(:,ISIZE_L0)
     ISIZE_0 = ISIZE_0 + 1
     PKI%XP_THRESHOLD      => PKI%XBLOCK_0(:,ISIZE_0)
     ISIZE_L0 = ISIZE_L0 + 1
     PKI%XP_LIRRIGATE      => PKI%LBLOCK_0(:,ISIZE_L0)
  ENDIF
ELSE
  ISIZE_T0 = ISIZE_T0 + 1
  PKI%TP_SEED           => PKI%TBLOCK_0(:,ISIZE_T0)
  ISIZE_T0 = ISIZE_T0 + 1
  PKI%TP_REAP           => PKI%TBLOCK_0(:,ISIZE_T0)
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_IRRIG          => PKI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_WATSUP         => PKI%XBLOCK_0(:,ISIZE_0)
  ISIZE_L0 = ISIZE_L0 + 1
  PKI%XP_LIRRIDAY       => PKI%LBLOCK_0(:,ISIZE_L0)
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_THRESHOLD      => PKI%XBLOCK_0(:,ISIZE_0)
  ISIZE_L0 = ISIZE_L0 + 1
  PKI%XP_LIRRIGATE      => PKI%LBLOCK_0(:,ISIZE_L0)
ENDIF
!
IF(I%CPHOTO=='NIT' .OR. I%CPHOTO=='NCB') THEN
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
   PKI%XP_CE_NITRO       => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
   PKI%XP_CF_NITRO       => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
   PKI%XP_CNA_NITRO      => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
   PKI%XP_BSLAI_NITRO    => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ELSE
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_CE_NITRO       => PKI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_CF_NITRO       => PKI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_CNA_NITRO      => PKI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_BSLAI_NITRO    => PKI%XBLOCK_0(:,ISIZE_0)
END IF
!
IF (I%CPHOTO=='NCB') THEN
  ISIZE_BIOMASS = ISIZE_BIOMASS + 1
  PKI%XP_INCREASE     => PKI%XBLOCK_BIOMASS(:,:,ISIZE_BIOMASS)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
   PKI%XP_TAU_WOOD     => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)  
ELSE
  ISIZE_00 = ISIZE_00 + 1
  PKI%XP_INCREASE     => PKI%XBLOCK_00(:,:,ISIZE_00)
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_TAU_WOOD     => PKI%XBLOCK_0(:,ISIZE_0)
ENDIF
!
IF (I%CRESPSL=='CNT') THEN
  ISIZE_LITTER = ISIZE_LITTER + 1
  PKI%XP_LITTER         => PKI%XBLOCK_LITTER(:,:,:,ISIZE_LITTER)
  ISIZE_SOILCARB = ISIZE_SOILCARB + 1
  PKI%XP_SOILCARB       => PKI%XBLOCK_SOILCARB(:,:,ISIZE_SOILCARB)
  ISIZE_LITTLEVS = ISIZE_LITTLEVS + 1
  PKI%XP_LIGNIN_STRUC   => PKI%XBLOCK_LITTLEVS(:,:,ISIZE_LITTLEVS)
  ISIZE_BIOMASS = ISIZE_BIOMASS + 1
  PKI%XP_TURNOVER       => PKI%XBLOCK_BIOMASS(:,:,ISIZE_BIOMASS)
ELSE
  ISIZE_000 = ISIZE_000 + 1
  PKI%XP_LITTER         => PKI%XBLOCK_000(:,:,:,ISIZE_000)
  ISIZE_00 = ISIZE_00 + 1
  PKI%XP_SOILCARB       => PKI%XBLOCK_00(:,:,ISIZE_00)
  ISIZE_00 = ISIZE_00 + 1
  PKI%XP_LIGNIN_STRUC   => PKI%XBLOCK_00(:,:,ISIZE_00)
  ISIZE_00 = ISIZE_00 + 1
  PKI%XP_TURNOVER       => PKI%XBLOCK_00(:,:,ISIZE_00)
END IF
!
IF (I%CRAIN=='SGH')THEN
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
   PKI%XP_MUF=> PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ELSE
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_MUF=> PKI%XBLOCK_0(:,ISIZE_0)
ENDIF
!
! MEB STUFF START
!
! Note that here the understory ground vegetation (GV) that was part of the original
! MEB development has been eliminated. The reason is to avoid a composite
! of vegetation and soil. Thus, most varibales with old extension V
! (representing canopy vegetation) are now unassociated. Instead, the classical ISBA
! variables (e.g. RGL, GAMMA, ...) will represent a composite vegetation in the
! MEB case. We still keep the GV-variables in the system for future needs.
! Code is commented with "nogv" in appropriate places.
!
IF (I%LMEB_PATCH(KPATCH))THEN
!
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKI%XP_WRL         => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKI%XP_WRLI         => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKI%XP_WRVN        => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKI%XP_TV          => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKI%XP_TL          => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKI%XP_TC          => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKI%XP_QC          => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
!nogv  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
!nogv  XP_RSMINV      => XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKI%XP_H_VEG       => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
!nogv  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
!nogv  XP_RGLV        => XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
!nogv  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
!nogv  XP_GAMMAV      => XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
!nogv  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
!nogv  XP_WRMAX_CFV   => XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
!nogv  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
!nogv  XP_LAIV        => XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
!nogv  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
!nogv  XP_Z0V         => XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKI%XP_GNDLITTER   => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKI%XP_Z0LITTER    => PKI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
!
!nogv  ISIZE_GROUND = ISIZE_GROUND + 1
!nogv  XP_ROOTFRACV   => XBLOCK_GROUND(:,:,ISIZE_GROUND)  
ELSE
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_WRL         => PKI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_WRLI         => PKI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_WRVN        => PKI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_TV          => PKI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_TL          => PKI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_TC          => PKI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_QC          => PKI%XBLOCK_0(:,ISIZE_0)
!nogv  ISIZE_0 = ISIZE_0 + 1
!nogv  XP_RSMINV      => XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_H_VEG       => PKI%XBLOCK_0(:,ISIZE_0)
!nogv  ISIZE_0 = ISIZE_0 + 1
!nogv  XP_RGLV        => XBLOCK_0(:,ISIZE_0)
!nogv  ISIZE_0 = ISIZE_0 + 1
!nogv  XP_GAMMAV      => XBLOCK_0(:,ISIZE_0)
!nogv  ISIZE_0 = ISIZE_0 + 1
!nogv  XP_WRMAX_CFV   => XBLOCK_0(:,ISIZE_0)
!nogv  ISIZE_0 = ISIZE_0 + 1
!nogv  XP_LAIV        => XBLOCK_0(:,ISIZE_0)
!nogv  ISIZE_0 = ISIZE_0 + 1
!nogv  XP_Z0V         => XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_GNDLITTER   => PKI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKI%XP_Z0LITTER    => PKI%XBLOCK_0(:,ISIZE_0)
!
!nogv  ISIZE_01 = ISIZE_01 + 1
!nogv  XP_ROOTFRACV   => XBLOCK_01(:,:,ISIZE_01)
ENDIF
ISIZE_0 = ISIZE_0 + 1
PKI%XP_RSMINV      => PKI%XBLOCK_0(:,ISIZE_0)
ISIZE_0 = ISIZE_0 + 1
PKI%XP_RGLV        => PKI%XBLOCK_0(:,ISIZE_0)
ISIZE_0 = ISIZE_0 + 1
PKI%XP_GAMMAV      => PKI%XBLOCK_0(:,ISIZE_0)
ISIZE_0 = ISIZE_0 + 1
PKI%XP_WRMAX_CFV   => PKI%XBLOCK_0(:,ISIZE_0)
ISIZE_0 = ISIZE_0 + 1
PKI%XP_LAIV        => PKI%XBLOCK_0(:,ISIZE_0)
ISIZE_0 = ISIZE_0 + 1
PKI%XP_Z0V         => PKI%XBLOCK_0(:,ISIZE_0)
ISIZE_01 = ISIZE_01 + 1
PKI%XP_ROOTFRACV   => PKI%XBLOCK_01(:,:,ISIZE_01)
! MEB STUFF END
!
!
IF (ISIZE_SIMPLE.GT.PKI%NSIZE_SIMPLE) &
  CALL ABOR1_SFX("PACK_ISBA_PATCH_n: PROBLEM DEFINING SIZE_SIMPLE / NUMBER OF FIELDS")
IF (ISIZE_GROUND.GT.PKI%NSIZE_GROUND) &
  CALL ABOR1_SFX("PACK_ISBA_PATCH_n: PROBLEM DEFINING SIZE_GROUND / NUMBER OF FIELDS")
IF (ISIZE_VEGTYPE.GT.PKI%NSIZE_VEGTYPE) &
  CALL ABOR1_SFX("PACK_ISBA_PATCH_n: PROBLEM DEFINING SIZE_VEGTYPE / NUMBER OF FIELDS")
IF (ISIZE_TG.GT.PKI%NSIZE_TG) &
  CALL ABOR1_SFX("PACK_ISBA_PATCH_n: PROBLEM DEFINING SIZE_TG / NUMBER OF FIELDS")
IF (ISIZE_SNOW.GT.PKI%NSIZE_SNOW) &
  CALL ABOR1_SFX("PACK_ISBA_PATCH_n: PROBLEM DEFINING SIZE_SNOW / NUMBER OF FIELDS")
IF (ISIZE_ALB.GT.PKI%NSIZE_ALB) &
  CALL ABOR1_SFX("PACK_ISBA_PATCH_n: PROBLEM DEFINING SIZE_ALB / NUMBER OF FIELDS")
IF (ISIZE_0.GT.PKI%NSIZE_0) &
  CALL ABOR1_SFX("PACK_ISBA_PATCH_n: PROBLEM DEFINING SIZE_0 / NUMBER OF FIELDS")
IF (ISIZE_00.GT.PKI%NSIZE_00) &
  CALL ABOR1_SFX("PACK_ISBA_PATCH_n: PROBLEM DEFINING SIZE_00 / NUMBER OF FIELDS")
IF (ISIZE_01.GT.PKI%NSIZE_01) &
  CALL ABOR1_SFX("PACK_ISBA_PATCH_n: PROBLEM DEFINING SIZE_01 / NUMBER OF FIELDS")
IF (ISIZE_2.GT.PKI%NSIZE_2) &
  CALL ABOR1_SFX("PACK_ISBA_PATCH_n: PROBLEM DEFINING SIZE_2 / NUMBER OF FIELDS")
IF (ISIZE_BIOMASS.GT.PKI%NSIZE_BIOMASS) &
  CALL ABOR1_SFX("PACK_ISBA_PATCH_n: PROBLEM DEFINING SIZE_BIOMASS / NUMBER OF FIELDS")
IF (ISIZE_LITTER.GT.PKI%NSIZE_LITTER) &
  CALL ABOR1_SFX("PACK_ISBA_PATCH_n: PROBLEM DEFINING SIZE_LITTER / NUMBER OF FIELDS")
IF (ISIZE_SOILCARB.GT.PKI%NSIZE_SOILCARB) &
  CALL ABOR1_SFX("PACK_ISBA_PATCH_n: PROBLEM DEFINING SIZE_SOILCARB / NUMBER OF FIELDS")
IF (ISIZE_LITTLEVS.GT.PKI%NSIZE_LITTLEVS) &
  CALL ABOR1_SFX("PACK_ISBA_PATCH_n: PROBLEM DEFINING SIZE_LITTLEVS / NUMBER OF FIELDS")
IF (ISIZE_000.GT.PKI%NSIZE_000) &
  CALL ABOR1_SFX("PACK_ISBA_PATCH_n: PROBLEM DEFINING SIZE_000 / NUMBER OF FIELDS")
IF (ISIZE_TSIMPLE.GT.PKI%NSIZE_TSIMPLE) &
  CALL ABOR1_SFX("PACK_ISBA_PATCH_n: PROBLEM DEFINING SIZE_TSIMPLE / NUMBER OF FIELDS")
IF (ISIZE_T0.GT.PKI%NSIZE_T0) &
  CALL ABOR1_SFX("PACK_ISBA_PATCH_n: PROBLEM DEFINING SIZE_T0 / NUMBER OF FIELDS")
IF (ISIZE_LSIMPLE.GT.PKI%NSIZE_LSIMPLE) &
  CALL ABOR1_SFX("PACK_ISBA_PATCH_n: PROBLEM DEFINING SIZE_LSIMPLE / NUMBER OF FIELDS")
IF (ISIZE_L0.GT.PKI%NSIZE_L0) &
  CALL ABOR1_SFX("PACK_ISBA_PATCH_n: PROBLEM DEFINING SIZE_L0 / NUMBER OF FIELDS")
IF (ISIZE_N0.GT.PKI%NSIZE_N0) &
  CALL ABOR1_SFX("PACK_ISBA_PATCH_n: PROBLEM DEFINING SIZE_N0 / NUMBER OF FIELDS")  
!
!------------------------------------------------------------------------
!
IF (I%NPATCH==1) THEN
  !
  PKI%XP_Z0_O_Z0H     (:)    =    I%XZ0_O_Z0H     (:, 1)
  PKI%XP_EMIS         (:)    =    I%XEMIS         (:, 1)
  PKI%XP_ALBNIR       (:)    =    I%XALBNIR       (:, 1)
  PKI%XP_ALBVIS       (:)    =    I%XALBVIS       (:, 1)
  PKI%XP_ALBUV        (:)    =    I%XALBUV        (:, 1)
  PKI%XP_ALBNIR_VEG   (:)    =    I%XALBNIR_VEG   (:, 1)
  PKI%XP_ALBVIS_VEG   (:)    =    I%XALBVIS_VEG   (:, 1)
  PKI%XP_ALBUV_VEG    (:)    =    I%XALBUV_VEG    (:, 1)
  PKI%XP_ALBNIR_SOIL  (:)    =    I%XALBNIR_SOIL  (:, 1)
  PKI%XP_ALBVIS_SOIL  (:)    =    I%XALBVIS_SOIL  (:, 1)
  PKI%XP_ALBUV_SOIL   (:)    =    I%XALBUV_SOIL   (:, 1)
  PKI%XP_Z0           (:)    =    I%XZ0           (:, 1)
  PKI%XP_WRMAX_CF     (:)    =    I%XWRMAX_CF     (:, 1)
  PKI%XP_GAMMA        (:)    =    I%XGAMMA        (:, 1)
  PKI%XP_CV           (:)    =    I%XCV           (:, 1)
  PKI%XP_RGL          (:)    =    I%XRGL          (:, 1)
  PKI%XP_RUNOFFD      (:)    =    I%XRUNOFFD      (:, 1) 
  PKI%XP_Z0EFFIP      (:)    =    I%XZ0EFFIP      (:, 1)
  PKI%XP_Z0EFFIM      (:)    =    I%XZ0EFFIM      (:, 1)
  PKI%XP_Z0EFFJP      (:)    =    I%XZ0EFFJP      (:, 1)
  PKI%XP_Z0EFFJM      (:)    =    I%XZ0EFFJM      (:, 1)  
  PKI%XP_WR           (:)    =    I%XWR           (:, 1)   
  PKI%XP_LAI          (:)    =    I%XLAI          (:, 1) 
  PKI%XP_RESA         (:)    =    I%XRESA         (:, 1)
  PKI%XP_CPS          (:)    =    I%XPCPS         (:, 1)
  PKI%XP_LVTT         (:)    =    I%XPLVTT        (:, 1)
  PKI%XP_LSTT         (:)    =    I%XPLSTT        (:, 1) 
  PKI%XP_VEG          (:)    =    I%XVEG          (:, 1)  
  PKI%XP_SNOWALB      (:)    =    I%TSNOW%ALB     (:, 1) 
  PKI%XP_LE           (:)    =    I%XLE           (:, 1)  
  PKI%XP_PSN          (:)    =    I%XPSN          (:, 1)
  PKI%XP_PSNG         (:)    =    I%XPSNG         (:, 1)
  PKI%XP_PSNV         (:)    =    I%XPSNV         (:, 1)  
  PKI%XP_ALBNIR_DRY   (:)    =    I%XALBNIR_DRY   (:)
  PKI%XP_ALBVIS_DRY   (:)    =    I%XALBVIS_DRY   (:)
  PKI%XP_ALBUV_DRY    (:)    =    I%XALBUV_DRY    (:)
  PKI%XP_ALBNIR_WET   (:)    =    I%XALBNIR_WET   (:)
  PKI%XP_ALBVIS_WET   (:)    =    I%XALBVIS_WET   (:)
  PKI%XP_ALBUV_WET    (:)    =    I%XALBUV_WET    (:)  
  PKI%XP_RUNOFFB      (:)    =    I%XRUNOFFB      (:)
  PKI%XP_WDRAIN       (:)    =    I%XWDRAIN       (:)
  PKI%XP_TAUICE       (:)    =    I%XTAUICE       (:)
  PKI%XP_Z0REL        (:)    =    I%XZ0REL        (:)
  PKI%XP_AOSIP        (:)    =    I%XAOSIP        (:)
  PKI%XP_AOSIM        (:)    =    I%XAOSIM        (:)
  PKI%XP_AOSJP        (:)    =    I%XAOSJP        (:)
  PKI%XP_AOSJM        (:)    =    I%XAOSJM        (:)
  PKI%XP_HO2IP        (:)    =    I%XHO2IP        (:)
  PKI%XP_HO2IM        (:)    =    I%XHO2IM        (:)
  PKI%XP_HO2JP        (:)    =    I%XHO2JP        (:)
  PKI%XP_HO2JM        (:)    =    I%XHO2JM        (:)
  PKI%XP_SSO_SLOPE    (:)    =    I%XSSO_SLOPE    (:)
  PKI%XP_GAMMAT       (:)    =    I%XGAMMAT       (:)
  PKI%XP_TDEEP        (:)    =    I%XTDEEP        (:)  
  PKI%XP_LAT          (:)    =    IG%XLAT          (:)
  PKI%XP_LON          (:)    =    IG%XLON          (:)
  !
  PKI%XP_CLAY         (:,:)  =    I%XCLAY         (:, :)
  PKI%XP_SAND         (:,:)  =    I%XSAND         (:, :) 
  PKI%XP_WFC          (:, :) =    I%XWFC          (:, :)
  PKI%XP_WWILT        (:, :) =    I%XWWILT        (:, :)
  PKI%XP_WSAT         (:, :) =    I%XWSAT         (:, :)
  PKI%XP_CONDSAT      (:, :) =    I%XCONDSAT      (:, :, 1)  
  PKI%XP_DG           (:, :) =    I%XDG           (:, :, 1)  
  PKI%XP_WG           (:, :) =    I%XWG           (:, :, 1)
  PKI%XP_WGI          (:, :) =    I%XWGI          (:, :, 1)
  PKI%XP_MPOTSAT      (:, :) =    I%XMPOTSAT      (:, :) 
  PKI%XP_BCOEF        (:, :) =    I%XBCOEF        (:, :)  
  !
  PKI%XP_KSAT_ICE     (:)    =    I%XKSAT_ICE     (:, 1)
  PKI%XP_D_ICE        (:)    =    I%XD_ICE        (:, 1)
  !
  PKI%XP_VEGTYPE_PATCH(:, :) =    I%XVEGTYPE_PATCH(:, :, 1)  
  !
  PKI%XP_TG           (:, :) =    I%XTG           (:, :, 1)  
  !  
  PKI%XP_SNOWSWE      (:, :) =    I%TSNOW%WSNOW   (:, :, 1)
  PKI%XP_SNOWRHO      (:, :) =    I%TSNOW%RHO     (:, :, 1)  
  !  
  PKI%XP_DIR_ALB_WITH_SNOW (:,:)= I%XDIR_ALB_WITH_SNOW(:, :, 1)
  PKI%XP_SCA_ALB_WITH_SNOW (:,:)= I%XSCA_ALB_WITH_SNOW(:, :, 1)
  !  
  PKI%XP_FSAT(:)=I%XFSAT(:)
  !
  IF(I%LFLOOD)THEN
    PKI%XP_FFLOOD  (:)=I%XFFLOOD  (:)
    PKI%XP_PIFLOOD (:)=I%XPIFLOOD (:)
    PKI%XP_FF      (:)=I%XFF      (:, 1)
    PKI%XP_FFG     (:)=I%XFFG     (:, 1)
    PKI%XP_FFV     (:)=I%XFFV     (:, 1)    
    PKI%XP_FFROZEN (:)=I%XFFROZEN (:, 1)    
    PKI%XP_ALBF    (:)=I%XALBF    (:, 1)
    PKI%XP_EMISF   (:)=I%XEMISF   (:, 1)
  ELSE
    PKI%XP_FFLOOD  (:)= 0.0
    PKI%XP_PIFLOOD (:)= 0.0
    PKI%XP_FF      (:)= 0.0
    PKI%XP_FFG     (:)= 0.0
    PKI%XP_FFV     (:)= 0.0
    PKI%XP_FFROZEN (:)= 0.0   
    PKI%XP_ALBF    (:)= 0.0
    PKI%XP_EMISF   (:)= 0.0    
  ENDIF
  !
  IF(I%TSNOW%SCHEME=='EBA') THEN
    PKI%XP_PSNV_A (:)    = I%XPSNV_A(:, 1)
  ENDIF
  !
  IF (I%TSNOW%SCHEME=='3-L' .OR. I%TSNOW%SCHEME=='CRO') THEN
    PKI%XP_SNOWHEAT   (:,:) =    I%TSNOW%HEAT  (:,:,1)
    PKI%XP_SNOWAGE    (:,:) =    I%TSNOW%AGE   (:,:,1)  
    PKI%XP_SNOWALBVIS   (:)    =    I%TSNOW%ALBVIS  (:, 1) 
    PKI%XP_SNOWALBNIR   (:)    =    I%TSNOW%ALBNIR  (:, 1) 
    PKI%XP_SNOWALBFIR   (:)    =    I%TSNOW%ALBFIR  (:, 1) 
  END IF
  !
  IF(I%TSNOW%SCHEME=='CRO') THEN
    PKI%XP_SNOWGRAN1  (:,:) =     I%TSNOW%GRAN1  (:,:,1)
    PKI%XP_SNOWGRAN2  (:,:) =     I%TSNOW%GRAN2  (:,:,1)
    PKI%XP_SNOWHIST   (:,:) =     I%TSNOW%HIST   (:,:,1)  
  END IF
  !
  IF(I%LGLACIER)THEN
    PKI%XP_ICE_STO (:)= I%XICE_STO  (:,1)
  ENDIF
  !  
  IF (I%CSCOND=='PL98'.OR.I%CISBA=='DIF') THEN
    PKI%XP_HCAPSOIL(:, :) = I%XHCAPSOIL    (:, :)
    PKI%XP_CONDDRY (:, :) = I%XCONDDRY     (:, :)
    PKI%XP_CONDSLD (:, :) = I%XCONDSLD     (:, :)    
  END IF
  !
  IF (I%CISBA=='2-L' .OR. I%CISBA=='3-L') THEN
    PKI%XP_C4B        (:)    =    I%XC4B          (:)
    PKI%XP_ACOEF      (:)    =    I%XACOEF        (:)
    PKI%XP_PCOEF      (:)    =    I%XPCOEF        (:)
    PKI%XP_CGSAT      (:)    =    I%XCGSAT        (:) 
    PKI%XP_C1SAT      (:)    =    I%XC1SAT        (:, 1)
    PKI%XP_C2REF      (:)    =    I%XC2REF        (:, 1)    
    PKI%XP_C4REF      (:)    =    I%XC4REF        (:, 1)    
    PKI%XP_C3         (:,:)  =    I%XC3           (:,:,1)    
  END IF
  !
  IF (I%CISBA=='DIF') THEN
    PKI%XP_ROOTFRAC   (:, :) =    I%XROOTFRAC   (:, :, 1)
    PKI%XP_DZG        (:, :) =    I%XDZG        (:, :, 1)
    PKI%XP_DZDIF      (:, :) =    I%XDZDIF      (:, :, 1)
    PKI%XP_SOILWGHT   (:, :) =    I%XSOILWGHT   (:, :, 1)
    PKI%NK_WG_LAYER   (:   ) =    I%NWG_LAYER   (:,    1)
    PKI%XP_FWTD       (:   ) =    I%XFWTD       (:)
    PKI%XP_WTD        (:   ) =    I%XWTD        (:)
  END IF
  !
  IF (I%CISBA=='DIF'.AND.I%CRUNOFF=='SGH') THEN
    PKI%XP_TOPQS   (:, :) =    I%XTOPQS   (:, :, 1)
  END IF
  !
  IF (I%LTR_ML) THEN
    PKI%XP_FAPARC     (:)   =     I%XFAPARC     (:, 1)
    PKI%XP_FAPIRC     (:)   =     I%XFAPIRC     (:, 1)
    PKI%XP_LAI_EFFC   (:)   =     I%XLAI_EFFC   (:, 1)
    PKI%XP_MUS        (:)   =     I%XMUS        (:, 1)
  ENDIF
  !  
  IF (I%CPHOTO=='NON') THEN
    PKI%XP_RSMIN      (:)    =    I%XRSMIN      (:, 1) 
  END IF
!
! For multi-energy balance (MEB):
!
! Note that here the understory ground vegetation (GV) that was part of the original
! MEB development has been eliminated. The reason is to avoid a composite
! of vegetation and soil. Thus, most varibales with old extension V
! (representing canopy vegetation) are now unassociated. Instead, the classical ISBA
! variables (e.g. RGL, GAMMA, ...) will represent a composite vegetation in the
! MEB case. We still keep the GV-variables in the system for future needs.
! Code is commented with "nogv" in appropriate places.
!
  IF(I%LMEB_PATCH(1))THEN
!
    PKI%XP_WRL          (:)    =    I%XWRL          (:, 1) 
    PKI%XP_WRLI         (:)    =    I%XWRLI         (:, 1) 
    PKI%XP_WRVN         (:)    =    I%XWRVN         (:, 1) 
    PKI%XP_TV           (:)    =    I%XTV           (:, 1) 
    PKI%XP_TL           (:)    =    I%XTL           (:, 1) 
    PKI%XP_TC           (:)    =    I%XTC           (:, 1) 
    PKI%XP_QC           (:)    =    I%XQC           (:, 1) 
!
! Please note that secondary Ecoclimap parameters, i.e. those
! with postfix GV, are given to the corresponing original ISBA physiography
! parameters in the case of LMEB_PATCH/OMEB=true. And the original ISBA
! physiography parameters are given to the canopy vegetation parameters.
! E.g. XLAI -> XP_LAIV and XLAIGV -> XP_LAI
!
!nogv    IF (CISBA=='DIF') THEN
!nogv      XP_ROOTFRACV         =  XP_ROOTFRAC
!nogv      XP_ROOTFRAC   (:, :) =  XROOTFRACGV   (:, :, 1)
!nogv    END IF
!nogv    IF (CPHOTO=='NON') THEN
!nogv      XP_RSMINV        = XP_RSMIN
!nogv      XP_RSMIN  (:)    = XRSMINGV  (:, 1)
!nogv    END IF
!
!nogv    XP_RGLV         (:)    =    XRGL          (:, 1)
!nogv    XP_GAMMAV       (:)    =    XGAMMA        (:, 1)
!nogv    XP_WRMAX_CFV    (:)    =    XWRMAX_CF     (:, 1)
!nogv    XP_LAIV         (:)    =    XLAI          (:, 1)
!nogv    XP_Z0V          (:)    =    XZ0           (:, 1)
    PKI%XP_H_VEG        (:)    =    I%XH_VEG        (:, 1)
!
!nogv    XP_VEG          (:)    =    XGNDLITTER    (:, 1)
!nogv    XP_RGL          (:)    =    XRGLGV        (:, 1)
!nogv    XP_GAMMA        (:)    =    XGAMMAGV      (:, 1)
!nogv    XP_WRMAX_CF     (:)    =    XWRMAX_CFGV   (:, 1)
!nogv    XP_LAI          (:)    =    XLAIGV        (:, 1)
!nogv    XP_Z0           (:)    =    XZ0LITTER     (:, 1)
    PKI%XP_GNDLITTER    (:)    =    I%XGNDLITTER    (:, 1)
    PKI%XP_Z0LITTER     (:)    =    I%XZ0LITTER     (:, 1)

  ENDIF
!
  IF(I%CPHOTO/='NON' .OR. I%LMEB_PATCH(1))THEN
    PKI%XP_BSLAI      (:)    =    I%XBSLAI      (:, 1)
  ENDIF
!
  IF (I%CPHOTO/='NON') THEN
    PKI%XP_LAIMIN     (:)    =    I%XLAIMIN     (:, 1)
    PKI%XP_SEFOLD     (:)    =    I%XSEFOLD     (:, 1)
    PKI%XP_H_TREE     (:)    =    I%XH_TREE     (:, 1)
    PKI%XP_ANMAX      (:)    =    I%XANMAX      (:, 1)
    PKI%XP_FZERO      (:)    =    I%XFZERO      (:, 1)
    PKI%XP_EPSO       (:)    =    I%XEPSO       (:, 1)
    PKI%XP_GAMM       (:)    =    I%XGAMM       (:, 1)
    PKI%XP_QDGAMM     (:)    =    I%XQDGAMM     (:, 1)
    PKI%XP_GMES       (:)    =    I%XGMES       (:, 1)
    PKI%XP_RE25       (:)    =    I%XRE25       (:, 1)
    PKI%XP_QDGMES     (:)    =    I%XQDGMES     (:, 1)
    PKI%XP_T1GMES     (:)    =    I%XT1GMES     (:, 1)
    PKI%XP_T2GMES     (:)    =    I%XT2GMES     (:, 1)
    PKI%XP_AMAX       (:)    =    I%XAMAX       (:, 1)
    PKI%XP_QDAMAX     (:)    =    I%XQDAMAX     (:, 1)
    PKI%XP_T1AMAX     (:)    =    I%XT1AMAX     (:, 1)
    PKI%XP_T2AMAX     (:)    =    I%XT2AMAX     (:, 1)
    PKI%XP_AN         (:)    =    I%XAN         (:, 1) 
    PKI%XP_ANDAY      (:)    =    I%XANDAY      (:, 1) 
    PKI%XP_ANFM       (:)    =    I%XANFM       (:, 1) 
    PKI%XP_GC         (:)    =    I%XGC         (:, 1)
    PKI%XP_BIOMASS        (:,:)  =    I%XBIOMASS        (:,:,1)
    PKI%XP_RESP_BIOMASS   (:,:)  =    I%XRESP_BIOMASS   (:,:,1)
  END IF
  !
  IF (I%CPHOTO=='AST' .OR. I%CPHOTO=='LST' .OR. I%CPHOTO=='NIT' .OR. I%CPHOTO=='NCB') THEN  
    PKI%LP_STRESS     (:)    =    I%LSTRESS     (:, 1)
    PKI%XP_F2I        (:)    =    I%XF2I        (:, 1)
    PKI%XP_AH         (:)    =    I%XAH         (:, 1)
    PKI%XP_BH         (:)    =    I%XBH         (:, 1)
    PKI%XP_DMAX       (:)    =    I%XDMAX       (:, 1)
  END IF
  !
  IF(I%CPHOTO=='LAI' .OR. I%CPHOTO=='LST' .OR. I%CPHOTO=='NIT' .OR. I%CPHOTO=='NCB') THEN
    PKI%TP_SEED     (:) = I%TSEED     (:,1)
    PKI%TP_REAP     (:) = I%TREAP     (:,1)
    PKI%XP_IRRIG    (:) = I%XIRRIG    (:,1)
    PKI%XP_WATSUP   (:) = I%XWATSUP   (:,1)
    IF (LAGRIP) THEN
       PKI%XP_LIRRIDAY (:) = AG%LIRRIDAY  (:,1)
       PKI%XP_THRESHOLD(:) = AG%XTHRESHOLDSPT(:,1)
       PKI%XP_LIRRIGATE(:) = AG%LIRRIGATE (:,1)
    END IF
  ENDIF
  !  
  IF(I%CPHOTO=='NIT' .OR. I%CPHOTO=='NCB') THEN 
     PKI%XP_CE_NITRO       (:)  =    I%XCE_NITRO       (:,1)
     PKI%XP_CF_NITRO       (:)  =    I%XCF_NITRO       (:,1)
     PKI%XP_CNA_NITRO      (:)  =    I%XCNA_NITRO      (:,1)
     PKI%XP_BSLAI_NITRO    (:)    =    I%XBSLAI_NITRO  (:,1)
  END IF
  !
  IF (I%CPHOTO=='NCB') THEN
     PKI%XP_INCREASE       (:,:)  =    I%XINCREASE       (:,:,1)          
     PKI%XP_TAU_WOOD       (:)    =    I%XTAU_WOOD       (:,1)
  END IF
  !
  IF (I%CRESPSL=='CNT') THEN
    PKI%XP_LITTER         (:,:,:) =    I%XLITTER         (:,:,:,1)
    PKI%XP_SOILCARB       (:,:)   =    I%XSOILCARB       (:,:,1)
    PKI%XP_LIGNIN_STRUC   (:,:)   =    I%XLIGNIN_STRUC   (:,:,1)
    PKI%XP_TURNOVER       (:,:)   =    I%XTURNOVER       (:,:,1)
  END IF
  !
  IF (I%CRAIN=='SGH') THEN
    PKI%XP_MUF(:)=I%XMUF(:)
  ENDIF
!
!------------------------------------------------------------------------
ELSE
!------------------------------------------------------------------------
!
  DO JJ=1,KSIZE
    JI                      =    KMASK(JJ)
    PKI%XP_Z0_O_Z0H     (JJ)    =    I%XZ0_O_Z0H     (JI, KPATCH)
    PKI%XP_EMIS         (JJ)    =    I%XEMIS         (JI, KPATCH)
    PKI%XP_ALBNIR       (JJ)    =    I%XALBNIR       (JI, KPATCH)
    PKI%XP_ALBVIS       (JJ)    =    I%XALBVIS       (JI, KPATCH)
    PKI%XP_ALBUV        (JJ)    =    I%XALBUV        (JI, KPATCH)
    PKI%XP_ALBNIR_VEG   (JJ)    =    I%XALBNIR_VEG   (JI, KPATCH)
    PKI%XP_ALBVIS_VEG   (JJ)    =    I%XALBVIS_VEG   (JI, KPATCH)
    PKI%XP_ALBUV_VEG    (JJ)    =    I%XALBUV_VEG    (JI, KPATCH)
    PKI%XP_ALBNIR_SOIL  (JJ)    =    I%XALBNIR_SOIL  (JI, KPATCH)
    PKI%XP_ALBVIS_SOIL  (JJ)    =    I%XALBVIS_SOIL  (JI, KPATCH)
    PKI%XP_ALBUV_SOIL   (JJ)    =    I%XALBUV_SOIL   (JI, KPATCH)
    PKI%XP_Z0           (JJ)    =    I%XZ0           (JI, KPATCH)
    PKI%XP_WRMAX_CF     (JJ)    =    I%XWRMAX_CF     (JI, KPATCH)
    PKI%XP_GAMMA        (JJ)    =    I%XGAMMA        (JI, KPATCH)
    PKI%XP_CV           (JJ)    =    I%XCV           (JI, KPATCH)
    PKI%XP_RGL          (JJ)    =    I%XRGL          (JI, KPATCH)
    PKI%XP_RUNOFFD      (JJ)    =    I%XRUNOFFD      (JI, KPATCH)
    PKI%XP_Z0EFFIP      (JJ)    =    I%XZ0EFFIP      (JI, KPATCH)
    PKI%XP_Z0EFFIM      (JJ)    =    I%XZ0EFFIM      (JI, KPATCH)
    PKI%XP_Z0EFFJP      (JJ)    =    I%XZ0EFFJP      (JI, KPATCH)
    PKI%XP_Z0EFFJM      (JJ)    =    I%XZ0EFFJM      (JI, KPATCH)  
    PKI%XP_WR           (JJ)    =    I%XWR           (JI, KPATCH) 
    PKI%XP_LAI          (JJ)    =    I%XLAI          (JI, KPATCH) 
    PKI%XP_RESA         (JJ)    =    I%XRESA         (JI, KPATCH) 
    PKI%XP_CPS          (JJ)    =    I%XPCPS         (JI, KPATCH)
    PKI%XP_LVTT         (JJ)    =    I%XPLVTT        (JI, KPATCH)
    PKI%XP_LSTT         (JJ)    =    I%XPLSTT        (JI, KPATCH)
    PKI%XP_VEG          (JJ)    =    I%XVEG          (JI, KPATCH) 
    PKI%XP_SNOWALB      (JJ)    =    I%TSNOW%ALB     (JI, KPATCH) 
    PKI%XP_LE           (JJ)    =    I%XLE           (JI, KPATCH) 
    PKI%XP_PSN          (JJ)    =    I%XPSN          (JI, KPATCH)
    PKI%XP_PSNG         (JJ)    =    I%XPSNG         (JI, KPATCH)
    PKI%XP_PSNV         (JJ)    =    I%XPSNV         (JI, KPATCH)    
    PKI%XP_ALBNIR_DRY   (JJ)    =    I%XALBNIR_DRY   (JI)
    PKI%XP_ALBVIS_DRY   (JJ)    =    I%XALBVIS_DRY   (JI)
    PKI%XP_ALBUV_DRY    (JJ)    =    I%XALBUV_DRY    (JI)
    PKI%XP_ALBNIR_WET   (JJ)    =    I%XALBNIR_WET   (JI)
    PKI%XP_ALBVIS_WET   (JJ)    =    I%XALBVIS_WET   (JI)
    PKI%XP_ALBUV_WET    (JJ)    =    I%XALBUV_WET    (JI)    
    PKI%XP_RUNOFFB      (JJ)    =    I%XRUNOFFB      (JI)
    PKI%XP_WDRAIN       (JJ)    =    I%XWDRAIN       (JI)
    PKI%XP_TAUICE       (JJ)    =    I%XTAUICE       (JI)
    PKI%XP_Z0REL        (JJ)    =    I%XZ0REL        (JI)
    PKI%XP_AOSIP        (JJ)    =    I%XAOSIP        (JI)
    PKI%XP_AOSIM        (JJ)    =    I%XAOSIM        (JI)
    PKI%XP_AOSJP        (JJ)    =    I%XAOSJP        (JI)
    PKI%XP_AOSJM        (JJ)    =    I%XAOSJM        (JI)
    PKI%XP_HO2IP        (JJ)    =    I%XHO2IP        (JI)
    PKI%XP_HO2IM        (JJ)    =    I%XHO2IM        (JI)
    PKI%XP_HO2JP        (JJ)    =    I%XHO2JP        (JI)
    PKI%XP_HO2JM        (JJ)    =    I%XHO2JM        (JI)
    PKI%XP_SSO_SLOPE    (JJ)    =    I%XSSO_SLOPE    (JI)
    PKI%XP_GAMMAT       (JJ)    =    I%XGAMMAT       (JI)
    PKI%XP_TDEEP        (JJ)    =    I%XTDEEP        (JI) 
    PKI%XP_LAT          (JJ)    =    IG%XLAT          (JI)
    PKI%XP_LON          (JJ)    =    IG%XLON          (JI)    
    PKI%XP_FSAT         (JJ)    =    I%XFSAT         (JI)
  ENDDO
  !  
  DO JK=1,I%NGROUND_LAYER
    DO JJ=1,KSIZE
      JI                       =    KMASK(JJ)
      PKI%XP_CLAY         (JJ,JK)  =    I%XCLAY         (JI, JK)
      PKI%XP_SAND         (JJ,JK)  =    I%XSAND         (JI, JK)
      PKI%XP_WFC          (JJ,JK)  =    I%XWFC          (JI, JK)
      PKI%XP_WWILT        (JJ,JK)  =    I%XWWILT        (JI, JK)
      PKI%XP_WSAT         (JJ,JK)  =    I%XWSAT         (JI, JK)    
      PKI%XP_CONDSAT      (JJ,JK)  =    I%XCONDSAT      (JI, JK, KPATCH)      
      PKI%XP_DG           (JJ,JK)  =    I%XDG           (JI, JK, KPATCH)  
      PKI%XP_WG           (JJ,JK)  =    I%XWG           (JI, JK, KPATCH)
      PKI%XP_WGI          (JJ,JK)  =    I%XWGI          (JI, JK, KPATCH)
      PKI%XP_MPOTSAT      (JJ, JK) =    I%XMPOTSAT      (JI, JK)
      PKI%XP_BCOEF        (JJ, JK) =    I%XBCOEF        (JI, JK)      
    ENDDO    
  ENDDO  
  !  
  DO JJ=1,KSIZE
     JI              = KMASK(JJ)
     PKI%XP_KSAT_ICE(JJ) = I%XKSAT_ICE(JI,KPATCH)
     PKI%XP_D_ICE   (JJ) = I%XD_ICE   (JI,KPATCH)
  END DO
  !
  DO JK=1,NVEGTYPE
    DO JJ=1,KSIZE
      JI                      =    KMASK(JJ)
      PKI%XP_VEGTYPE_PATCH(JJ,JK) =    I%XVEGTYPE_PATCH(JI, JK, KPATCH)
    ENDDO
  ENDDO  
  !
  DO JK=1,SIZE(I%XTG,2)
    DO JJ=1,KSIZE
      JI                       =    KMASK(JJ)
      PKI%XP_TG           (JJ,JK)  =    I%XTG           (JI, JK, KPATCH)  
    ENDDO
  ENDDO
  !  
  DO JK=1,I%TSNOW%NLAYER
    DO JJ=1,KSIZE
      JI                       =    KMASK(JJ)
      PKI%XP_SNOWSWE      (JJ,JK)  =    I%TSNOW%WSNOW   (JI, JK, KPATCH)
      PKI%XP_SNOWRHO      (JJ,JK)  =    I%TSNOW%RHO     (JI, JK, KPATCH)
    ENDDO
  ENDDO  
  !  
  DO JK=1,SIZE(PKI%XP_DIR_ALB_WITH_SNOW,2)
    DO JJ=1,KSIZE
      JI                          = KMASK(JJ)
      PKI%XP_DIR_ALB_WITH_SNOW (JJ,JK)= I%XDIR_ALB_WITH_SNOW(JI,JK,KPATCH)
      PKI%XP_SCA_ALB_WITH_SNOW (JJ,JK)= I%XSCA_ALB_WITH_SNOW(JI,JK,KPATCH)
    ENDDO
  ENDDO
  !
  IF (I%LFLOOD)THEN
    DO JJ=1,KSIZE
       JI             = KMASK(JJ)
       PKI%XP_FFLOOD  (JJ)=I%XFFLOOD  (JI)
       PKI%XP_PIFLOOD (JJ)=I%XPIFLOOD (JI)
       PKI%XP_FF      (JJ)=I%XFF      (JI,KPATCH)
       PKI%XP_FFG     (JJ)=I%XFFG     (JI,KPATCH)
       PKI%XP_FFV     (JJ)=I%XFFV     (JI,KPATCH)
       PKI%XP_FFROZEN (JJ)=I%XFFROZEN (JI,KPATCH)    
       PKI%XP_ALBF    (JJ)=I%XALBF    (JI,KPATCH)
       PKI%XP_EMISF   (JJ)=I%XEMISF   (JI,KPATCH)       
    END DO
  ELSE
    PKI%XP_FFLOOD  (:) = 0.0
    PKI%XP_PIFLOOD (:) = 0.0
    PKI%XP_FF      (:) = 0.0
    PKI%XP_FFG     (:) = 0.0
    PKI%XP_FFROZEN (:) = 0.0
    PKI%XP_FFV     (:) = 0.0
    PKI%XP_ALBF    (:) = 0.0
    PKI%XP_EMISF   (:) = 0.0
  ENDIF
!
  IF(I%TSNOW%SCHEME=='EBA') THEN
    DO JJ=1,KSIZE
       JI                = KMASK(JJ)
       PKI%XP_PSNV_A (JJ)    = I%XPSNV_A(JI, KPATCH)
    END DO
  END IF
  !
  IF (I%TSNOW%SCHEME=='3-L' .OR. I%TSNOW%SCHEME=='CRO') THEN
    DO JK=1,SIZE(PKI%XP_SNOWHEAT,2)
      DO JJ=1,KSIZE
        JI                     =    KMASK(JJ)
        PKI%XP_SNOWHEAT   (JJ, JK) =    I%TSNOW%HEAT   (JI, JK, KPATCH)
        PKI%XP_SNOWAGE    (JJ, JK) =    I%TSNOW%AGE    (JI, JK, KPATCH)
      ENDDO
    END DO
    DO JJ=1,KSIZE
      JI                      =    KMASK(JJ)
      PKI%XP_SNOWALBVIS   (JJ)    =    I%TSNOW%ALBVIS  (JI, KPATCH) 
      PKI%XP_SNOWALBNIR   (JJ)    =    I%TSNOW%ALBNIR  (JI, KPATCH) 
      PKI%XP_SNOWALBFIR   (JJ)    =    I%TSNOW%ALBFIR  (JI, KPATCH) 
    ENDDO
  END IF
  !
  IF (I%TSNOW%SCHEME=='CRO') THEN
    DO JK=1,SIZE(PKI%XP_SNOWGRAN1,2)
      DO JJ=1,KSIZE
        JI                     =    KMASK(JJ)  
        PKI%XP_SNOWGRAN1  (JJ, JK) =    I%TSNOW%GRAN1  (JI, JK, KPATCH)
        PKI%XP_SNOWGRAN2  (JJ, JK) =    I%TSNOW%GRAN2  (JI, JK, KPATCH)
        PKI%XP_SNOWHIST   (JJ, JK) =    I%TSNOW%HIST   (JI, JK, KPATCH)
      ENDDO
    END DO
  END IF
  !
  IF(I%LGLACIER)THEN
    DO JJ=1,KSIZE
       JI             = KMASK(JJ)
       PKI%XP_ICE_STO(JJ) = I%XICE_STO  (JI,KPATCH)
    ENDDO
  ENDIF
  !  
  IF (I%CSCOND=='PL98'.OR.I%CISBA=='DIF') THEN
    DO JK=1,SIZE(I%XHCAPSOIL,2)
      DO JJ=1,KSIZE
        JI                    =    KMASK(JJ)
        PKI%XP_HCAPSOIL   (JJ, JK) =    I%XHCAPSOIL    (JI, JK)
        PKI%XP_CONDDRY    (JJ, JK) =    I%XCONDDRY     (JI, JK)
        PKI%XP_CONDSLD    (JJ, JK) =    I%XCONDSLD     (JI, JK)
      ENDDO
    ENDDO
  END IF
  !
  IF (I%CISBA=='2-L' .OR. I%CISBA=='3-L') THEN
    DO JJ=1,KSIZE
      JI                    =    KMASK(JJ)
      PKI%XP_C4B        (JJ)    =    I%XC4B          (JI)
      PKI%XP_ACOEF      (JJ)    =    I%XACOEF        (JI)
      PKI%XP_PCOEF      (JJ)    =    I%XPCOEF        (JI)
      PKI%XP_CGSAT      (JJ)    =    I%XCGSAT        (JI) 
      PKI%XP_C1SAT      (JJ)    =    I%XC1SAT        (JI, KPATCH)
      PKI%XP_C2REF      (JJ)    =    I%XC2REF        (JI, KPATCH)     
      PKI%XP_C4REF      (JJ)    =    I%XC4REF        (JI, KPATCH)      
    ENDDO
    !
    DO JK=1,SIZE(I%XC3,2)
      DO JJ=1,KSIZE
        JI                    =    KMASK(JJ)
        PKI%XP_C3         (JJ,JK)  =    I%XC3           (JI, JK, KPATCH)
      ENDDO
    ENDDO
  END IF
  !
    DO JK=1,SIZE(I%XBCOEF,2)
      DO JJ=1,KSIZE    
         JI                  =    KMASK(JJ)
         PKI%XP_MPOTSAT (JJ, JK) =    I%XMPOTSAT (JI, JK)
         PKI%XP_BCOEF   (JJ, JK) =    I%XBCOEF   (JI, JK)
      ENDDO
    ENDDO
  !
  IF (I%CISBA=='DIF') THEN
    DO JK=1,SIZE(I%XROOTFRAC,2)
      DO JJ=1,KSIZE
        JI                     =    KMASK(JJ)
        PKI%XP_ROOTFRAC   (JJ, JK) =    I%XROOTFRAC   (JI, JK, KPATCH)
        PKI%XP_DZG        (JJ, JK) =    I%XDZG        (JI, JK, KPATCH)
        PKI%XP_DZDIF      (JJ, JK) =    I%XDZDIF      (JI, JK, KPATCH)
        PKI%XP_SOILWGHT   (JJ, JK) =    I%XSOILWGHT   (JI, JK, KPATCH)
      ENDDO
    ENDDO
    DO JJ=1,KSIZE
      JI                =  KMASK(JJ)
      PKI%NK_WG_LAYER (JJ)  =  I%NWG_LAYER (JI,KPATCH)
      PKI%XP_FWTD     (JJ)  =  I%XFWTD     (JI)
      PKI%XP_WTD      (JJ)  =  I%XWTD      (JI)
    ENDDO
  ENDIF
  !
  IF (I%CISBA=='DIF'.AND.I%CRUNOFF=='SGH') THEN
    DO JK=1,SIZE(I%XROOTFRAC,2)
      DO JJ=1,KSIZE
        JI                     =    KMASK(JJ)
        PKI%XP_TOPQS   (JJ, JK)    =    I%XTOPQS   (JI, JK, KPATCH)  
      ENDDO
    ENDDO        
  END IF
  !
  IF (I%LTR_ML) THEN
    DO JJ=1,KSIZE
      JI                    =    KMASK(JJ)
      PKI%XP_FAPARC      (JJ)    =    I%XFAPARC      (JI, KPATCH)
      PKI%XP_FAPIRC      (JJ)    =    I%XFAPIRC      (JI, KPATCH)
      PKI%XP_LAI_EFFC    (JJ)    =    I%XLAI_EFFC    (JI, KPATCH)
      PKI%XP_MUS         (JJ)    =    I%XMUS         (JI, KPATCH)
    ENDDO
  ENDIF  
  !
  IF (I%CPHOTO=='NON') THEN
    DO JJ=1,KSIZE
      JI                    =    KMASK(JJ)
      PKI%XP_RSMIN      (JJ)    =    I%XRSMIN      (JI, KPATCH)
    END DO
  END IF
  !
  IF(I%LMEB_PATCH(KPATCH))THEN
!
    DO JJ=1,KSIZE
      JI                      =    KMASK(JJ)
      PKI%XP_WRL          (JJ)    =    I%XWRL          (JI, KPATCH) 
      PKI%XP_WRLI         (JJ)    =    I%XWRLI         (JI, KPATCH) 
      PKI%XP_WRVN         (JJ)    =    I%XWRVN         (JI, KPATCH) 
      PKI%XP_TV           (JJ)    =    I%XTV           (JI, KPATCH) 
      PKI%XP_TL           (JJ)    =    I%XTL           (JI, KPATCH) 
      PKI%XP_TC           (JJ)    =    I%XTC           (JI, KPATCH) 
      PKI%XP_QC           (JJ)    =    I%XQC           (JI, KPATCH) 
    ENDDO
!
! Please note that secondary Ecoclimap parameters, i.e. those
! with postfix GV, are given to the corresponing original ISBA physiography
! parameters in the case of LMEB_PATCH/OMEB=true. And the original ISBA
! physiography parameters are given to the canopy vegetation parameters.
! E.g. XLAI -> XP_LAIV and XLAIGV -> XP_LAI
!
!nogv    IF (CISBA=='DIF') THEN
!nogv      XP_ROOTFRACV = XP_ROOTFRAC
!nogv      DO JK=1,SIZE(XROOTFRAC,2)
!nogv        DO JJ=1,KSIZE
!nogv          JI                    =    KMASK(JJ)
!nogv          XP_ROOTFRAC  (JJ, JK) =  XROOTFRACGV   (JI, JK, KPATCH)
!nogv        ENDDO
!nogv      ENDDO
!nogv    END IF
!
!nogv    IF (CPHOTO=='NON') THEN
!nogv      XP_RSMINV = XP_RSMIN
!nogv      DO JJ=1,KSIZE
!nogv        JI                    =    KMASK(JJ)
!nogv        XP_RSMIN      (JJ)    =    XRSMINGV      (JI, KPATCH)
!nogv      END DO
!nogv    END IF
!
    DO JJ=1,KSIZE
      JI                      =    KMASK(JJ)
      PKI%XP_H_VEG        (JJ)    =    I%XH_VEG        (JI, KPATCH)
!nogv      XP_RGLV         (JJ)    =    XRGL          (JI, KPATCH)
!nogv      XP_GAMMAV       (JJ)    =    XGAMMA        (JI, KPATCH)
!nogv      XP_WRMAX_CFV    (JJ)    =    XWRMAX_CF     (JI, KPATCH)
!nogv      XP_LAIV         (JJ)    =    XLAI          (JI, KPATCH)
!nogv      XP_Z0V          (JJ)    =    XZ0           (JI, KPATCH)
!
!nogv      XP_VEG          (JJ)    =    XGNDLITTER    (JI, KPATCH)
!nogv      XP_RGL          (JJ)    =    XRGLGV        (JI, KPATCH)
!nogv      XP_GAMMA        (JJ)    =    XGAMMAGV      (JI, KPATCH)
!nogv      XP_WRMAX_CF     (JJ)    =    XWRMAX_CFGV   (JI, KPATCH)
!nogv      XP_LAI          (JJ)    =    XLAIGV        (JI, KPATCH)
!nogv      XP_Z0           (JJ)    =    XZ0LITTER     (JI, KPATCH)
      PKI%XP_GNDLITTER    (JJ)    =    I%XGNDLITTER    (JI, KPATCH)
      PKI%XP_Z0LITTER     (JJ)    =    I%XZ0LITTER     (JI, KPATCH)
    ENDDO
  ENDIF
!
  IF(I%CPHOTO/='NON' .OR. I%LMEB_PATCH(KPATCH))THEN
    DO JJ=1,KSIZE
      JI                    =    KMASK(JJ)
      PKI%XP_BSLAI      (JJ)    =    I%XBSLAI      (JI, KPATCH)
    ENDDO
  ENDIF
!
  IF (I%CPHOTO/='NON') THEN
    DO JJ=1,KSIZE
      JI                    =    KMASK(JJ)
      PKI%XP_LAIMIN     (JJ)    =    I%XLAIMIN     (JI, KPATCH)
      PKI%XP_SEFOLD     (JJ)    =    I%XSEFOLD     (JI, KPATCH)
      PKI%XP_H_TREE     (JJ)    =    I%XH_TREE     (JI, KPATCH)
      PKI%XP_ANMAX      (JJ)    =    I%XANMAX      (JI, KPATCH)
      PKI%XP_FZERO      (JJ)    =    I%XFZERO      (JI, KPATCH)
      PKI%XP_EPSO       (JJ)    =    I%XEPSO       (JI, KPATCH)
      PKI%XP_GAMM       (JJ)    =    I%XGAMM       (JI, KPATCH)
      PKI%XP_QDGAMM     (JJ)    =    I%XQDGAMM     (JI, KPATCH)
      PKI%XP_GMES       (JJ)    =    I%XGMES       (JI, KPATCH)
      PKI%XP_RE25       (JJ)    =    I%XRE25       (JI, KPATCH)
      PKI%XP_QDGMES     (JJ)    =    I%XQDGMES     (JI, KPATCH)
      PKI%XP_T1GMES     (JJ)    =    I%XT1GMES     (JI, KPATCH)
      PKI%XP_T2GMES     (JJ)    =    I%XT2GMES     (JI, KPATCH)
      PKI%XP_AMAX       (JJ)    =    I%XAMAX       (JI, KPATCH)
      PKI%XP_QDAMAX     (JJ)    =    I%XQDAMAX     (JI, KPATCH)
      PKI%XP_T1AMAX     (JJ)    =    I%XT1AMAX     (JI, KPATCH)
      PKI%XP_T2AMAX     (JJ)    =    I%XT2AMAX     (JI, KPATCH)
      PKI%XP_AN         (JJ)    =    I%XAN         (JI, KPATCH) 
      PKI%XP_ANDAY      (JJ)    =    I%XANDAY      (JI, KPATCH) 
      PKI%XP_ANFM       (JJ)    =    I%XANFM       (JI, KPATCH) 
      PKI%XP_GC         (JJ)    =    I%XGC         (JI, KPATCH)
    ENDDO
    DO JK=1,SIZE(I%XBIOMASS,2)
      DO JJ=1,KSIZE
        JI                    =    KMASK(JJ)
        PKI%XP_BIOMASS        (JJ,JK)  =    I%XBIOMASS        (JI,JK,KPATCH)
        PKI%XP_RESP_BIOMASS   (JJ,JK)  =    I%XRESP_BIOMASS   (JI,JK,KPATCH)
      ENDDO
    END DO
  END IF
  !
  IF (I%CPHOTO=='AST' .OR. I%CPHOTO=='LST' .OR. I%CPHOTO=='NIT' .OR. I%CPHOTO=='NCB') THEN
    DO JJ=1,KSIZE
      JI                    =    KMASK(JJ)
      PKI%LP_STRESS     (JJ)    =    I%LSTRESS     (JI, KPATCH)
      PKI%XP_F2I        (JJ)    =    I%XF2I        (JI, KPATCH)
      PKI%XP_AH         (JJ)    =    I%XAH         (JI, KPATCH)
      PKI%XP_BH         (JJ)    =    I%XBH         (JI, KPATCH)
      PKI%XP_DMAX       (JJ)    =    I%XDMAX       (JI, KPATCH)
    END DO
  END IF
  !
  IF(I%CPHOTO=='LAI' .OR. I%CPHOTO=='LST' .OR. I%CPHOTO=='NIT' .OR. I%CPHOTO=='NCB') THEN
    DO JJ=1,KSIZE
      JI               = KMASK(JJ)
      PKI%TP_SEED     (JJ) = I%TSEED     (JI,KPATCH)
      PKI%TP_REAP     (JJ) = I%TREAP     (JI,KPATCH)
      PKI%XP_IRRIG    (JJ) = I%XIRRIG    (JI,KPATCH)
      PKI%XP_WATSUP   (JJ) = I%XWATSUP   (JI,KPATCH)
    ENDDO
    IF (LAGRIP) THEN
      DO JJ=1,KSIZE
        JI               = KMASK(JJ)
        PKI%XP_LIRRIDAY (JJ) = AG%LIRRIDAY  (JI,KPATCH)
        PKI%XP_THRESHOLD(JJ) = AG%XTHRESHOLDSPT(JI,KPATCH)
        PKI%XP_LIRRIGATE(JJ) = AG%LIRRIGATE (JI,KPATCH)
      ENDDO
    ENDIF
  ENDIF
  !
  IF(I%CPHOTO=='NIT' .OR. I%CPHOTO=='NCB') THEN
    DO JJ=1,KSIZE
      JI                      =    KMASK(JJ)
      PKI%XP_CE_NITRO       (JJ)  =    I%XCE_NITRO       (JI,KPATCH)
      PKI%XP_CF_NITRO       (JJ)  =    I%XCF_NITRO       (JI,KPATCH)
      PKI%XP_CNA_NITRO      (JJ)  =    I%XCNA_NITRO      (JI,KPATCH)
      PKI%XP_BSLAI_NITRO    (JJ)  =    I%XBSLAI_NITRO    (JI,KPATCH)      
    END DO
  END IF
  !
  IF (I%CPHOTO=='NCB') THEN
    DO JK=1,SIZE(I%XINCREASE,2)
      DO JJ=1,KSIZE
        JI                      =    KMASK(JJ)
        PKI%XP_INCREASE   (JJ,JK)   =    I%XINCREASE       (JI,JK,KPATCH)
      ENDDO
    END DO
    DO JJ=1,KSIZE
      JI                      =    KMASK(JJ)
      PKI%XP_TAU_WOOD       (JJ)  =    I%XTAU_WOOD       (JI,KPATCH)
    END DO  
  END IF
  !
  IF (I%CRESPSL=='CNT') THEN
    DO JL=1,SIZE(PKI%XP_LITTER,3)
      DO JK=1,SIZE(PKI%XP_LITTER,2)
        DO JJ=1,KSIZE
          JI                      =    KMASK(JJ)
          PKI%XP_LITTER         (JJ,JK,JL) =    I%XLITTER         (JI,JK,JL,KPATCH)
        ENDDO
      ENDDO
    ENDDO
    DO JK=1,SIZE(PKI%XP_SOILCARB,2)
      DO JJ=1,KSIZE
        JI                      =    KMASK(JJ)
        PKI%XP_SOILCARB       (JJ,JK)   =    I%XSOILCARB       (JI,JK,KPATCH)
      ENDDO
    ENDDO
     DO JK=1,SIZE(PKI%XP_LIGNIN_STRUC,2)
      DO JJ=1,KSIZE
        JI                      =    KMASK(JJ)
        PKI%XP_LIGNIN_STRUC  (JJ,JK)   =    I%XLIGNIN_STRUC  (JI,JK,KPATCH)
      ENDDO
    ENDDO
    DO JK=1,SIZE(PKI%XP_TURNOVER,2)
      DO JJ=1,KSIZE
        JI                      =    KMASK(JJ)
        PKI%XP_TURNOVER      (JJ,JK)   =    I%XTURNOVER       (JI,JK,KPATCH)
      ENDDO
    ENDDO
  END IF
!
  IF (I%CRAIN=='SGH')THEN
    DO JJ=1,KSIZE
       JI         = KMASK(JJ)
       PKI%XP_MUF(JJ) = I%XMUF(JI)
    END DO
  ENDIF
!
!------------------------------------------------------------------------
END IF
IF (LHOOK) CALL DR_HOOK('PACK_ISBA_PATCH_N',1,ZHOOK_HANDLE)
!------------------------------------------------------------------------
END SUBROUTINE PACK_ISBA_PATCH_n
