!     #########
SUBROUTINE PACK_ISBA_PATCH_GET_SIZE_n (I, PKI, &
                                       KPATCH)
!##############################################
!
!
!!****  *PACK_ISBA_PATCH_GET_SIZE_n * - packs ISBA variables
!!
!!    PURPOSE
!!    -------
!
!!**  METHOD
!!    ------
!!
!!    REFERENCE
!!    ---------
!!      
!!
!!    AUTHOR
!!    ------
!!     V. Masson and A. boone
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    01/2004
!!      B. Decharme    2008 floodplains
!!      B. Decharme 01/2009 Good dim for XP_TG
!!      A.L. Gibelin 04/2009 : BIOMASS and RESP_BIOMASS arrays 
!!      A.L. Gibelin 04/2009 : TAU_WOOD for NCB option 
!!      A.L. Gibelin 05/2009 : Add carbon spinup
!!      A.L. Gibelin 06/2009 : Soil carbon variables for CNT option
!!      A.L. Gibelin 07/2009 : Suppress RDK and transform GPP as a diagnostic
!!      A.L. Gibelin 07/2009 : Suppress PPST and PPSTF as outputs
!!      B. Decharme  04/2013 : DIF lateral subsurface drainage
!!                             water table / surface coupling
!!      P Samuelsson 10/2014 : MEB
!!
!!------------------------------------------------------------------
!
!
USE MODD_ISBA_n, ONLY : ISBA_t
USE MODD_PACK_ISBA, ONLY : PACK_ISBA_t
!
USE MODD_DATA_COVER_PAR,  ONLY : NVEGTYPE
!
USE MODD_AGRI,        ONLY : LAGRIP
USE MODD_TREEDRAG,    ONLY : LTREEDRAG
!
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!
TYPE(ISBA_t), INTENT(INOUT) :: I
TYPE(PACK_ISBA_t), INTENT(INOUT) :: PKI
!
INTEGER, INTENT(IN)               :: KPATCH
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!------------------------------------------------------------------------
IF (LHOOK) CALL DR_HOOK('PACK_ISBA_PATCH_GET_SIZE_N',0,ZHOOK_HANDLE)
!
PKI%NSIZE_LSIMPLE=0
PKI%NSIZE_L0=0
!
PKI%NSIZE_NSIMPLE=0
PKI%NSIZE_N0=0
!
PKI%NSIZE_TSIMPLE=0
PKI%NSIZE_T0=0
!
PKI%NSIZE_SIMPLE=67
PKI%NSIZE_GROUND=11
PKI%NSIZE_VEGTYPE=1
PKI%NSIZE_TG=1
PKI%NSIZE_SNOW=2
PKI%NSIZE_ALB=2
PKI%NSIZE_2=0
PKI%NSIZE_BIOMASS=0
PKI%NSIZE_LITTER=0
PKI%NSIZE_SOILCARB=0
PKI%NSIZE_LITTLEVS=0
!
PKI%NSIZE_0=0
PKI%NSIZE_00=0
PKI%NSIZE_000=0
PKI%NSIZE_01=0
!
IF (I%TSNOW%SCHEME=='EBA') THEN
  PKI%NSIZE_SIMPLE=PKI%NSIZE_SIMPLE+1
ELSE 
  PKI%NSIZE_0=PKI%NSIZE_0+1
ENDIF
!
IF (I%TSNOW%SCHEME=='3-L' .OR. I%TSNOW%SCHEME=='CRO') THEN
  PKI%NSIZE_SIMPLE=PKI%NSIZE_SIMPLE+4
  PKI%NSIZE_SNOW=PKI%NSIZE_SNOW+2
ELSE
  PKI%NSIZE_0=PKI%NSIZE_0+4
  PKI%NSIZE_00=PKI%NSIZE_00+2
ENDIF
!
IF(I%TSNOW%SCHEME=='CRO') THEN
  PKI%NSIZE_SNOW=PKI%NSIZE_SNOW+3
ELSE
  PKI%NSIZE_00=PKI%NSIZE_00+3
ENDIF
!
IF(I%LGLACIER) THEN
  PKI%NSIZE_SIMPLE=PKI%NSIZE_SIMPLE+1
ELSE
  PKI%NSIZE_0=PKI%NSIZE_0+1
ENDIF
!
IF (I%CSCOND=='PL98'.OR.I%CISBA=='DIF') THEN
  PKI%NSIZE_GROUND=PKI%NSIZE_GROUND+3
ELSE
  PKI%NSIZE_01=PKI%NSIZE_01+3
ENDIF
!
IF (I%CISBA=='2-L' .OR. I%CISBA=='3-L') THEN
  PKI%NSIZE_SIMPLE=PKI%NSIZE_SIMPLE+7
  PKI%NSIZE_2=PKI%NSIZE_2+1
ELSE
  PKI%NSIZE_0=PKI%NSIZE_0+7
  PKI%NSIZE_00=PKI%NSIZE_00+1
ENDIF
!
IF (I%CISBA=='DIF') THEN
  PKI%NSIZE_GROUND=PKI%NSIZE_GROUND+4
  PKI%NSIZE_NSIMPLE=PKI%NSIZE_NSIMPLE+1
  PKI%NSIZE_SIMPLE=PKI%NSIZE_SIMPLE+2
ELSE
  PKI%NSIZE_01=PKI%NSIZE_01+4
  PKI%NSIZE_N0=PKI%NSIZE_N0+1
  PKI%NSIZE_0=PKI%NSIZE_0+2
ENDIF
!
IF (I%CISBA=='DIF'.AND.I%CRUNOFF=='SGH') THEN
  PKI%NSIZE_GROUND=PKI%NSIZE_GROUND+1
ELSE
  PKI%NSIZE_01=PKI%NSIZE_01+1
ENDIF
!
IF (I%LTR_ML) THEN
  PKI%NSIZE_SIMPLE = PKI%NSIZE_SIMPLE+4
ELSE
  PKI%NSIZE_0 = PKI%NSIZE_0+4
ENDIF
!
IF (I%CPHOTO=='NON') THEN
  PKI%NSIZE_SIMPLE=PKI%NSIZE_SIMPLE+1
ELSE
  PKI%NSIZE_0 = PKI%NSIZE_0+1
ENDIF
!
IF (I%CPHOTO/='NON'.OR.LTREEDRAG) THEN
  PKI%NSIZE_SIMPLE=PKI%NSIZE_SIMPLE+1        
ELSE
  PKI%NSIZE_0 = PKI%NSIZE_0+1        
ENDIF
!
IF (I%CPHOTO/='NON') THEN
  PKI%NSIZE_SIMPLE=PKI%NSIZE_SIMPLE+22
  PKI%NSIZE_BIOMASS=PKI%NSIZE_BIOMASS+2
ELSE
  PKI%NSIZE_0=PKI%NSIZE_0+22
  PKI%NSIZE_00=PKI%NSIZE_00+2
ENDIF
!
IF (I%CPHOTO=='AST' .OR. I%CPHOTO=='LST' .OR. I%CPHOTO=='NIT' .OR. I%CPHOTO=='NCB') THEN
  PKI%NSIZE_LSIMPLE=PKI%NSIZE_LSIMPLE+1
  PKI%NSIZE_SIMPLE=PKI%NSIZE_SIMPLE+4
ELSE
  PKI%NSIZE_L0=PKI%NSIZE_L0+1
  PKI%NSIZE_0=PKI%NSIZE_0+4
ENDIF
!
IF (I%CPHOTO=='LAI' .OR. I%CPHOTO=='LST' .OR. I%CPHOTO=='NIT' .OR. I%CPHOTO=='NCB') THEN
  PKI%NSIZE_SIMPLE=PKI%NSIZE_SIMPLE+2
  PKI%NSIZE_TSIMPLE=PKI%NSIZE_TSIMPLE+2
  IF (LAGRIP) THEN
    PKI%NSIZE_LSIMPLE=PKI%NSIZE_LSIMPLE+2
    PKI%NSIZE_SIMPLE=PKI%NSIZE_SIMPLE+1
  ELSE
    PKI%NSIZE_L0=PKI%NSIZE_L0+2
    PKI%NSIZE_0=PKI%NSIZE_0+1
 ENDIF
ELSE
  PKI%NSIZE_L0=PKI%NSIZE_L0+2
  PKI%NSIZE_0=PKI%NSIZE_0+3
  PKI%NSIZE_T0=PKI%NSIZE_T0+2
ENDIF
!
IF(I%CPHOTO=='NIT' .OR. I%CPHOTO=='NCB') THEN
  PKI%NSIZE_SIMPLE=PKI%NSIZE_SIMPLE+4
ELSE
  PKI%NSIZE_0=PKI%NSIZE_0+4
ENDIF
!
IF (I%CPHOTO=='NCB') THEN
  PKI%NSIZE_BIOMASS=PKI%NSIZE_BIOMASS+1
  PKI%NSIZE_SIMPLE=PKI%NSIZE_SIMPLE+1
ELSE
  PKI%NSIZE_00=PKI%NSIZE_00+1
  PKI%NSIZE_0=PKI%NSIZE_0+1
ENDIF
!
IF (I%CRESPSL=='CNT') THEN
  PKI%NSIZE_LITTER=PKI%NSIZE_LITTER+1
  PKI%NSIZE_SOILCARB=PKI%NSIZE_SOILCARB+1
  PKI%NSIZE_LITTLEVS=PKI%NSIZE_LITTLEVS+1
  PKI%NSIZE_BIOMASS=PKI%NSIZE_BIOMASS+1
ELSE
  PKI%NSIZE_000=PKI%NSIZE_000+1
  PKI%NSIZE_00=PKI%NSIZE_00+3
ENDIF
!
IF (I%CRAIN=='SGH') THEN
  PKI%NSIZE_SIMPLE=PKI%NSIZE_SIMPLE+1
ELSE
  PKI%NSIZE_0=PKI%NSIZE_0+1
ENDIF
! MEB STUFF START
IF (I%LMEB_PATCH(KPATCH))THEN
  PKI%NSIZE_SIMPLE=PKI%NSIZE_SIMPLE+12
!  NSIZE_GROUND=NSIZE_GROUND+1
ELSE
  PKI%NSIZE_0=PKI%NSIZE_0+12
!  NSIZE_01=NSIZE_01+1
ENDIF
! Old MEB varibales now eliminated
PKI%NSIZE_0=PKI%NSIZE_0+7
PKI%NSIZE_01=PKI%NSIZE_01+1
! MEB STUFF END
!
IF (LHOOK) CALL DR_HOOK('PACK_ISBA_PATCH_GET_SIZE_N',1,ZHOOK_HANDLE)
!------------------------------------------------------------------------
END SUBROUTINE PACK_ISBA_PATCH_GET_SIZE_n
