!     #########
SUBROUTINE PACK_DIAG_PATCH_n (DGEI, DGI, DGMI, I, PKDI, &
                              KSIZE,KSW,KPATCH)
!##############################################
!
!!****  *PACK_DIAG_PATCH_n* - packs ISBA diagnostics
!!
!!    PURPOSE
!!    -------
!
!!**  METHOD
!!    ------
!!
!!    REFERENCE
!!    ---------
!!      
!!
!!    AUTHOR
!!    ------
!!     V. Masson 
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    01/2004
!!      Modified    10/2004 by P. Le Moigne: Halstead coefficient
!!      Modified    10/2005 by P. Le Moigne: Allocation (not EBA case)
!!      Modified       2008 by B. Decharme : Allocation for the floodplains
!!      Modified      04-09 by A.L. Gibelin : Add carbon diagnostics
!!      B. Decharme 04/2013 DIF lateral subsurface drainage
!!                          Sublimation diag flux
!!      Modified      10-14 by P. Samuelsson: MEB
!!
!!------------------------------------------------------------------
!
!
!
!
                                  ! End For multi-energy balance


!
!
USE MODD_DIAG_EVAP_ISBA_n, ONLY : DIAG_EVAP_ISBA_t
USE MODD_DIAG_ISBA_n, ONLY : DIAG_ISBA_t
USE MODD_DIAG_MISC_ISBA_n, ONLY : DIAG_MISC_ISBA_t
USE MODD_ISBA_n, ONLY : ISBA_t
USE MODD_PACK_DIAG_ISBA, ONLY : PACK_DIAG_ISBA_t
!
USE MODI_ABOR1_SFX
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!
TYPE(DIAG_EVAP_ISBA_t), INTENT(INOUT) :: DGEI
TYPE(DIAG_ISBA_t), INTENT(INOUT) :: DGI
TYPE(DIAG_MISC_ISBA_t), INTENT(INOUT) :: DGMI
TYPE(ISBA_t), INTENT(INOUT) :: I
TYPE(PACK_DIAG_ISBA_t), INTENT(INOUT) :: PKDI
!
INTEGER, INTENT(IN)               :: KSIZE, KSW, KPATCH
!
INTEGER :: ISIZE_SIMPLE, ISIZE_GROUND, ISIZE_SNOW, ISIZE_KSW, &
           ISIZE_ABC, ISIZE_0, ISIZE_00
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!------------------------------------------------------------------------
IF (LHOOK) CALL DR_HOOK('PACK_DIAG_PATCH_N',0,ZHOOK_HANDLE)
!
! Packed surface module variables:
!
ALLOCATE(PKDI%XBLOCK_SIMPLE(KSIZE,PKDI%NSIZE_SIMPLE))
ALLOCATE(PKDI%XBLOCK_GROUND(KSIZE,I%NGROUND_LAYER,PKDI%NSIZE_GROUND))
ALLOCATE(PKDI%XBLOCK_SNOW(KSIZE,I%TSNOW%NLAYER,PKDI%NSIZE_SNOW))
ALLOCATE(PKDI%XBLOCK_KSW(KSIZE,KSW,PKDI%NSIZE_KSW))
ALLOCATE(PKDI%XBLOCK_ABC(KSIZE,SIZE(I%XABC),PKDI%NSIZE_ABC))
ALLOCATE(PKDI%XBLOCK_0(0,PKDI%NSIZE_0))
ALLOCATE(PKDI%XBLOCK_00(0,0,PKDI%NSIZE_00))
!
ISIZE_SIMPLE=0
ISIZE_GROUND=0
ISIZE_SNOW=0
ISIZE_KSW=0
ISIZE_ABC=0
ISIZE_0=0
ISIZE_00=0
!
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_CH          => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_CE          => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_CD          => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_CDN         => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_RI          => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_HU          => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_HUG         => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_ALBT        => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_RN          => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_H           => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_LEI         => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_LEG         => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_LEGI        => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_LEV         => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_LES         => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_LER         => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_LETR        => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_GFLUX       => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_EVAP        => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_SUBL        => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_RESTORE     => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_DRAIN       => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_QSB         => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_RUNOFF      => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_MELT        => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_MELTADV     => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_SRSFC       => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_RRSFC       => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_SNOWFREE_ALB=> PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
!
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_HORT      => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_DRIP      => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_RRVEG     => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_IRRIG_FLUX=> PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
!
ISIZE_KSW = ISIZE_KSW + 1
PKDI%XP_SWBD       => PKDI%XBLOCK_KSW(:,:,ISIZE_KSW)
ISIZE_KSW = ISIZE_KSW + 1
PKDI%XP_SWBU       => PKDI%XBLOCK_KSW(:,:,ISIZE_KSW)
!
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_SWD         => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_SWU         => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_LWD         => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_LWU         => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_FMU         => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_FMV         => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
!
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_Z0_WITH_SNOW => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_Z0H_WITH_SNOW=> PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_Z0EFF        => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
!
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_CG          => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_C1          => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_C2          => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_WGEQ        => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_CT          => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_RS          => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_HV          => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_QS          => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
!
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_TS            => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_TSRAD         => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
!
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_RESP_AUTO    => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_RESP_ECO     => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_GPP          => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
!
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_IFLOOD   => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_PFLOOD   => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_LE_FLOOD => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ISIZE_SIMPLE = ISIZE_SIMPLE + 1
PKDI%XP_LEI_FLOOD=> PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
!
IF (I%TSNOW%SCHEME=='3-L' .OR. I%TSNOW%SCHEME=='CRO') THEN
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_RNSNOW    => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_HSNOW     => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_HPSNOW    => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_GFLUXSNOW => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_USTARSNOW => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_GRNDFLUX  => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_LESL      => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_SNDRIFT   => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_CDSNOW    => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_CHSNOW    => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_SNOWHMASS => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_RN_ISBA   => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_H_ISBA    => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_LEG_ISBA  => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_LEGI_ISBA => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_LEV_ISBA  => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_LETR_ISBA => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_USTAR_ISBA=> PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_LER_ISBA  => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_LE_ISBA   => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_LEI_ISBA  => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_GFLUX_ISBA=> PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SNOW = ISIZE_SNOW + 1
  PKDI%XP_SNOWLIQ   => PKDI%XBLOCK_SNOW(:,:,ISIZE_SNOW)
  ISIZE_SNOW = ISIZE_SNOW + 1
  PKDI%XP_SNOWDZ    => PKDI%XBLOCK_SNOW(:,:,ISIZE_SNOW)  
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_SWNET_N    => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_SWNET_NS    => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_LWNET_N    => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ELSE
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_RNSNOW    => PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_HSNOW     => PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_HPSNOW    => PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_GFLUXSNOW => PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_USTARSNOW => PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_GRNDFLUX  => PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_LESL      => PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_SNDRIFT   => PKDI%XBLOCK_0(:,ISIZE_0)  
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_CDSNOW    => PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_CHSNOW    => PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_SNOWHMASS => PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_RN_ISBA   => PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_H_ISBA    => PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_LEG_ISBA  => PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_LEGI_ISBA => PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_LEV_ISBA  => PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_LETR_ISBA => PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_USTAR_ISBA=> PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_LER_ISBA  => PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_LE_ISBA   => PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_LEI_ISBA  => PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_GFLUX_ISBA=> PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_00 = ISIZE_00 + 1
  PKDI%XP_SNOWLIQ   => PKDI%XBLOCK_00(:,:,ISIZE_00)
  ISIZE_00 = ISIZE_00 + 1
  PKDI%XP_SNOWDZ    => PKDI%XBLOCK_00(:,:,ISIZE_00)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_SWNET_N  => PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_SWNET_NS  => PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_LWNET_N  => PKDI%XBLOCK_0(:,ISIZE_0)
END IF
!
IF(I%TSNOW%SCHEME/='EBA') THEN
  ISIZE_SNOW = ISIZE_SNOW + 1
  PKDI%XP_SNOWTEMP    => PKDI%XBLOCK_SNOW(:,:,ISIZE_SNOW)
ELSE
  ISIZE_00 = ISIZE_00 + 1
  PKDI%XP_SNOWTEMP    => PKDI%XBLOCK_00(:,:,ISIZE_00)
ENDIF
!
IF(I%TSNOW%SCHEME=='EBA') THEN
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_SNOWFREE_ALB_VEG=> PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_SNOWFREE_ALB_SOIL=> PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ELSE
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_SNOWFREE_ALB_VEG=> PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_SNOWFREE_ALB_SOIL=> PKDI%XBLOCK_0(:,ISIZE_0)
ENDIF
!
IF (I%LTR_ML) THEN
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_FAPAR => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_FAPIR => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_FAPAR_BS => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_FAPIR_BS => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ELSE 
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_FAPAR => PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_FAPIR => PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_FAPAR_BS => PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_FAPIR_BS => PKDI%XBLOCK_0(:,ISIZE_0)
END IF
!
IF (I%CPHOTO/='NON') THEN
  ISIZE_ABC = ISIZE_ABC + 1
  PKDI%XP_IACAN => PKDI%XBLOCK_ABC(:,:,ISIZE_ABC)
ELSE
  ISIZE_00 = ISIZE_00 + 1
  PKDI%XP_IACAN => PKDI%XBLOCK_00(:,:,ISIZE_00)
END IF
!
IF (DGI%N2M>=1) THEN
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_T2M         => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_Q2M         => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_HU2M        => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_ZON10M      => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_MER10M      => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ELSE
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_T2M         => PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_Q2M         => PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_HU2M        => PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_ZON10M      => PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_MER10M      => PKDI%XBLOCK_0(:,ISIZE_0)
END IF
!
IF (DGMI%LSURF_MISC_BUDGET) THEN
  ISIZE_GROUND = ISIZE_GROUND + 1
  PKDI%XP_SWI          => PKDI%XBLOCK_GROUND(:,:,ISIZE_GROUND)
  ISIZE_GROUND = ISIZE_GROUND + 1
  PKDI%XP_TSWI         => PKDI%XBLOCK_GROUND(:,:,ISIZE_GROUND)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_TWSNOW       => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_TDSNOW       => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ELSE
  ISIZE_00 = ISIZE_00 + 1
  PKDI%XP_SWI          => PKDI%XBLOCK_00(:,:,ISIZE_00)
  ISIZE_00 = ISIZE_00 + 1
  PKDI%XP_TSWI         => PKDI%XBLOCK_00(:,:,ISIZE_00)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_TWSNOW       => PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_TDSNOW       => PKDI%XBLOCK_0(:,ISIZE_0)
ENDIF
!
IF(I%LGLACIER)THEN
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_ICEFLUX=> PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ELSE
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_ICEFLUX=> PKDI%XBLOCK_0(:,ISIZE_0)
ENDIF
!
! MEB STUFF START
IF (I%LMEB_PATCH(KPATCH))THEN
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_SWUP    => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_SWNET_V    => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_SWNET_G    => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_LWUP    => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_LWNET_V    => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_LWNET_G    => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_LEVCV    => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_LESC    => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_H_V_C    => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_H_G_C    => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
!  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
!  XP_LETRGV    => XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_LETRCV    => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
!  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
!  XP_LERGV    => XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_LELITTER    => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_LELITTERI    => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_DRIPLIT    => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_RRLIT    => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_LERCV    => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_H_C_A    => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_H_N_C    => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_LE_C_A    => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_LE_V_C    => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_LE_G_C    => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_LE_N_C    => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_EVAP_N_C    => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_EVAP_G_C    => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_SR_GN    => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_MELTCV    => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_FRZCV    => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_SWDOWN_GN    => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_LWDOWN_GN    => PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
ELSE
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_SWUP  => PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_SWNET_V  => PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_SWNET_G  => PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_LWUP  => PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_LWNET_V  => PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_LWNET_G  => PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_LEVCV  => PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_LESC  => PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_H_V_C  => PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_H_G_C  => PKDI%XBLOCK_0(:,ISIZE_0)
!  ISIZE_0 = ISIZE_0 + 1
!  XP_LETRGV  => XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_LETRCV  => PKDI%XBLOCK_0(:,ISIZE_0)
!  ISIZE_0 = ISIZE_0 + 1
!  XP_LERGV  => XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_LELITTER  => PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_LELITTERI  => PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_DRIPLIT  => PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_RRLIT  => PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_LERCV  => PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_H_C_A  => PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_H_N_C  => PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_LE_C_A  => PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_LE_V_C  => PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_LE_G_C  => PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_LE_N_C  => PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_EVAP_N_C  => PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_EVAP_G_C  => PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_SR_GN  => PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_MELTCV  => PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_FRZCV  => PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_SWDOWN_GN  => PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_LWDOWN_GN  => PKDI%XBLOCK_0(:,ISIZE_0)
ENDIF
ISIZE_0 = ISIZE_0 + 1
PKDI%XP_LETRGV  => PKDI%XBLOCK_0(:,ISIZE_0)
ISIZE_0 = ISIZE_0 + 1
PKDI%XP_LERGV  => PKDI%XBLOCK_0(:,ISIZE_0)
!
IF(DGEI%LWATER_BUDGET)THEN
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_DWG=> PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_DWGI=> PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_DWR=> PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_DSWE=> PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)
  ISIZE_SIMPLE = ISIZE_SIMPLE + 1
  PKDI%XP_WATBUD=> PKDI%XBLOCK_SIMPLE(:,ISIZE_SIMPLE)  
ELSE
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_DWG=> PKDI%XBLOCK_0(:,ISIZE_0) 
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_DWGI=> PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_DWR=> PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_DSWE=> PKDI%XBLOCK_0(:,ISIZE_0)
  ISIZE_0 = ISIZE_0 + 1
  PKDI%XP_WATBUD=> PKDI%XBLOCK_0(:,ISIZE_0)
ENDIF
!
!
IF (ISIZE_SIMPLE.GT.PKDI%NSIZE_SIMPLE) & 
  CALL ABOR1_SFX("PACK_DIAG_PATCH_n: PROBLEM DEFINING SIZE_SIMPLE / NUMBER OF FIELDS")
IF (ISIZE_GROUND.GT.PKDI%NSIZE_GROUND) & 
  CALL ABOR1_SFX("PACK_DIAG_PATCH_n: PROBLEM DEFINING SIZE_GROUND / NUMBER OF FIELDS")
IF (ISIZE_SNOW.GT.PKDI%NSIZE_SNOW) & 
  CALL ABOR1_SFX("PACK_DIAG_PATCH_n: PROBLEM DEFINING SIZE_SNOW / NUMBER OF FIELDS")
IF (ISIZE_KSW.GT.PKDI%NSIZE_KSW) & 
  CALL ABOR1_SFX("PACK_DIAG_PATCH_n: PROBLEM DEFINING SIZE_KSW / NUMBER OF FIELDS")
IF (ISIZE_ABC.GT.PKDI%NSIZE_ABC) & 
  CALL ABOR1_SFX("PACK_DIAG_PATCH_n: PROBLEM DEFINING SIZE_3 / NUMBER OF FIELDS")
IF (ISIZE_0.GT.PKDI%NSIZE_0) & 
  CALL ABOR1_SFX("PACK_DIAG_PATCH_n: PROBLEM DEFINING SIZE_0 / NUMBER OF FIELDS")
IF (ISIZE_00.GT.PKDI%NSIZE_00) & 
  CALL ABOR1_SFX("PACK_DIAG_PATCH_n: PROBLEM DEFINING SIZE_00 / NUMBER OF FIELDS") 
!
IF (LHOOK) CALL DR_HOOK('PACK_DIAG_PATCH_N',1,ZHOOK_HANDLE)
!------------------------------------------------------------------------
!
END SUBROUTINE PACK_DIAG_PATCH_n
