!     #########
SUBROUTINE PACK_DIAG_PATCH_GET_SIZE_n (DGEI, DGI, DGMI, I, PKDI, &
                                       KPATCH)
!##############################################
!
!!****  *PACK_DIAG_PATCH_GET_SIZE_n* - packs ISBA diagnostics
!!
!!    PURPOSE
!!    -------
!
!!**  METHOD
!!    ------
!!
!!    REFERENCE
!!    ---------
!!      
!!
!!    AUTHOR
!!    ------
!!     V. Masson 
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    01/2004
!!      Modified    10/2004 by P. Le Moigne: Halstead coefficient
!!      Modified    10/2005 by P. Le Moigne: Allocation (not EBA case)
!!      Modified       2008 by B. Decharme : Allocation for the floodplains
!!      Modified      04-09 by A.L. Gibelin : Add carbon diagnostics
!!      Modified      10-14 by P. Samuelsson: MEB
!!
!!------------------------------------------------------------------
!
!
!
!
USE MODD_DIAG_EVAP_ISBA_n, ONLY : DIAG_EVAP_ISBA_t
USE MODD_DIAG_ISBA_n, ONLY : DIAG_ISBA_t
USE MODD_DIAG_MISC_ISBA_n, ONLY : DIAG_MISC_ISBA_t
USE MODD_ISBA_n, ONLY : ISBA_t
USE MODD_PACK_DIAG_ISBA, ONLY : PACK_DIAG_ISBA_t
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!
TYPE(DIAG_EVAP_ISBA_t), INTENT(INOUT) :: DGEI
TYPE(DIAG_ISBA_t), INTENT(INOUT) :: DGI
TYPE(DIAG_MISC_ISBA_t), INTENT(INOUT) :: DGMI
TYPE(ISBA_t), INTENT(INOUT) :: I
TYPE(PACK_DIAG_ISBA_t), INTENT(INOUT) :: PKDI
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
INTEGER, INTENT(IN)               :: KPATCH
!------------------------------------------------------------------------
IF (LHOOK) CALL DR_HOOK('PACK_DIAG_PATCH_GET_SIZE_N',0,ZHOOK_HANDLE)
!
PKDI%NSIZE_SIMPLE=59
PKDI%NSIZE_GROUND=0
PKDI%NSIZE_SNOW=0
PKDI%NSIZE_KSW=2
PKDI%NSIZE_ABC=0
PKDI%NSIZE_0=0
PKDI%NSIZE_00=0
!
IF (I%TSNOW%SCHEME=='3-L' .OR. I%TSNOW%SCHEME=='CRO') THEN
  PKDI%NSIZE_SIMPLE=PKDI%NSIZE_SIMPLE+25
  PKDI%NSIZE_SNOW=PKDI%NSIZE_SNOW+2
ELSE
  PKDI%NSIZE_0=PKDI%NSIZE_0+25
  PKDI%NSIZE_00=PKDI%NSIZE_00+2 
ENDIF
!
IF(I%TSNOW%SCHEME/='EBA') THEN
  PKDI%NSIZE_SNOW=PKDI%NSIZE_SNOW+1 
ELSE
  PKDI%NSIZE_00=PKDI%NSIZE_00+1 
ENDIF
!
IF(I%TSNOW%SCHEME=='EBA') THEN
  PKDI%NSIZE_SIMPLE=PKDI%NSIZE_SIMPLE+2 
ELSE
  PKDI%NSIZE_0=PKDI%NSIZE_0+2 
ENDIF
!
IF (I%LTR_ML) THEN
  PKDI%NSIZE_SIMPLE=PKDI%NSIZE_SIMPLE+4
ELSE
  PKDI%NSIZE_0=PKDI%NSIZE_0+4
ENDIF
!
IF (I%CPHOTO/='NON') THEN
  PKDI%NSIZE_ABC=PKDI%NSIZE_ABC+1 
ELSE
  PKDI%NSIZE_00=PKDI%NSIZE_00+1
ENDIF
!
IF (DGI%N2M>=1) THEN
  PKDI%NSIZE_SIMPLE=PKDI%NSIZE_SIMPLE+5 
ELSE
  PKDI%NSIZE_0=PKDI%NSIZE_0+5 
ENDIF
!
IF (DGMI%LSURF_MISC_BUDGET) THEN
  PKDI%NSIZE_GROUND=PKDI%NSIZE_GROUND+2 
  PKDI%NSIZE_SIMPLE=PKDI%NSIZE_SIMPLE+2 
ELSE
  PKDI%NSIZE_00=PKDI%NSIZE_00+2 
  PKDI%NSIZE_0=PKDI%NSIZE_0+2 
ENDIF
!
IF(I%LGLACIER)THEN
  PKDI%NSIZE_SIMPLE=PKDI%NSIZE_SIMPLE+1 
ELSE
  PKDI%NSIZE_0=PKDI%NSIZE_0+1 
ENDIF
!
! MEB STUFF START
IF (I%LMEB_PATCH(KPATCH))THEN
!  NSIZE_SIMPLE=NSIZE_SIMPLE+27
  PKDI%NSIZE_SIMPLE=PKDI%NSIZE_SIMPLE+29
ELSE
!  NSIZE_0=NSIZE_0+27
  PKDI%NSIZE_0=PKDI%NSIZE_0+29
ENDIF
PKDI%NSIZE_0=PKDI%NSIZE_0+2
! MEB STUFF END
!
IF(DGEI%LWATER_BUDGET)THEN
  PKDI%NSIZE_SIMPLE=PKDI%NSIZE_SIMPLE+5 
ELSE
  PKDI%NSIZE_0=PKDI%NSIZE_0+5 
ENDIF
!
IF (LHOOK) CALL DR_HOOK('PACK_DIAG_PATCH_GET_SIZE_N',1,ZHOOK_HANDLE)
!------------------------------------------------------------------------
!
END SUBROUTINE PACK_DIAG_PATCH_GET_SIZE_n
