!##################
MODULE MODN_TEB_VEG_n
!##################
!
!!****  *MODN_TEB_VEG_n* - declaration of namelist NAM_TEB_VEG_n
!!
!!    PURPOSE
!!    -------
!       The purpose of this module is to specify  the namelist NAM_TEB_VEG_n
!     which concern the surface configuration of one nested  model.
!
!!
!!**  IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!       
!!    AUTHOR
!!    ------
!!      V. Masson    *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    01/2004                    
!-------------------------------------------------------------------------------
!
!*       0.   DECLARATIONS
!             ------------
!
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
LOGICAL           :: LPERTSURF
!
LOGICAL           :: LCH_BIO_FLUX
LOGICAL           :: LCH_NO_FLUX
LOGICAL           :: LGLACIER
LOGICAL           :: LVEGUPD
LOGICAL           :: LNITRO_DILU
LOGICAL           :: LCANOPY_DRAG
!
CHARACTER(LEN=4)  :: CC1DRY
CHARACTER(LEN=4)  :: CSCOND
CHARACTER(LEN=3)  :: CSOILFRZ
CHARACTER(LEN=4)  :: CDIFSFCOND
CHARACTER(LEN=3)  :: CSNOWRES
CHARACTER(LEN=4)  :: CALBEDO
CHARACTER(LEN=4)  :: CROUGH
CHARACTER(LEN=3)  :: CCPSURF
CHARACTER(LEN=4)  :: CRUNOFF
CHARACTER(LEN=3)  :: CKSAT
LOGICAL           :: LSOC
CHARACTER(LEN=3)  :: CRAIN
CHARACTER(LEN=3)  :: CHORT         
CHARACTER(LEN=28) :: CCHEM_SURF_FILE
CHARACTER(LEN=6)  :: CCH_DRY_DEP
!
REAL              :: XCGMAX
REAL              :: XTSTEP
REAL              :: XCDRAG
!
NAMELIST/NAM_ISBAn/CC1DRY,CSCOND,CSOILFRZ,CDIFSFCOND,CSNOWRES,CALBEDO,CROUGH,CCPSURF, &
                   XTSTEP,XCGMAX,XCDRAG,LGLACIER, LCANOPY_DRAG, LVEGUPD, LPERTSURF  
NAMELIST/NAM_ISBA_AGSn/LNITRO_DILU
NAMELIST/NAM_SGH_ISBAn/CRUNOFF,CKSAT,LSOC,CRAIN,CHORT
NAMELIST/NAM_CH_CONTROLn/CCHEM_SURF_FILE
NAMELIST/NAM_CH_ISBAn/LCH_BIO_FLUX,CCH_DRY_DEP,LCH_NO_FLUX
!
CONTAINS
!
SUBROUTINE INIT_NAM_TEB_VEGn (TVG)
!
  USE MODD_TEB_VEG_n, ONLY : TEB_VEG_OPTIONS_t
!
  IMPLICIT NONE

!
  TYPE(TEB_VEG_OPTIONS_t), INTENT(INOUT) :: TVG
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_TEB_VEG_N:INIT_NAM_TEB_VEGN',0,ZHOOK_HANDLE)
  CC1DRY       = TVG%CC1DRY
  CSCOND       = TVG%CSCOND
  CSOILFRZ     = TVG%CSOILFRZ
  CDIFSFCOND   = TVG%CDIFSFCOND
  CSNOWRES     = TVG%CSNOWRES
  CALBEDO      = TVG%CALBEDO
  CROUGH       = TVG%CROUGH
  CCPSURF      = TVG%CCPSURF
  XTSTEP       = TVG%XTSTEP
  XCGMAX       = TVG%XCGMAX
  XCDRAG       = TVG%XCDRAG
  LVEGUPD      = TVG%LVEGUPD  
  LCANOPY_DRAG = TVG%LCANOPY_DRAG
IF (LHOOK) CALL DR_HOOK('MODN_TEB_VEG_N:INIT_NAM_TEB_VEGN',1,ZHOOK_HANDLE)
END SUBROUTINE INIT_NAM_TEB_VEGn

SUBROUTINE INIT_NAM_TEB_VEG_AGSn (TVG)
!
  USE MODD_TEB_VEG_n, ONLY : TEB_VEG_OPTIONS_t
!
  IMPLICIT NONE

!
  TYPE(TEB_VEG_OPTIONS_t), INTENT(INOUT) :: TVG
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_TEB_VEG_N:INIT_NAM_TEB_VEG_AGSN',0,ZHOOK_HANDLE)
  LNITRO_DILU = TVG%LNITRO_DILU
IF (LHOOK) CALL DR_HOOK('MODN_TEB_VEG_N:INIT_NAM_TEB_VEG_AGSN',1,ZHOOK_HANDLE)
END SUBROUTINE INIT_NAM_TEB_VEG_AGSn

SUBROUTINE UPDATE_NAM_TEB_VEGn (TVG)
!
  USE MODD_TEB_VEG_n, ONLY : TEB_VEG_OPTIONS_t
!
  IMPLICIT NONE

!
  TYPE(TEB_VEG_OPTIONS_t), INTENT(INOUT) :: TVG
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_TEB_VEG_N:UPDATE_NAM_TEB_VEGN',0,ZHOOK_HANDLE)
  TVG%CC1DRY       = CC1DRY
  TVG%CSCOND       = CSCOND
  TVG%CSOILFRZ     = CSOILFRZ
  TVG%CDIFSFCOND   = CDIFSFCOND
  TVG%CSNOWRES     = CSNOWRES
  TVG%CALBEDO      = CALBEDO
  TVG%CROUGH       = CROUGH
  TVG%CCPSURF      = CCPSURF
  TVG%XTSTEP       = XTSTEP
  TVG%XCGMAX       = XCGMAX
  TVG%XCDRAG       = XCDRAG
  TVG%LVEGUPD      = LVEGUPD
  TVG%LCANOPY_DRAG = LCANOPY_DRAG
IF (LHOOK) CALL DR_HOOK('MODN_TEB_VEG_N:UPDATE_NAM_TEB_VEGN',1,ZHOOK_HANDLE)
END SUBROUTINE UPDATE_NAM_TEB_VEGn

SUBROUTINE UPDATE_NAM_TEB_VEG_AGSn (TVG)
!
  USE MODD_TEB_VEG_n, ONLY : TEB_VEG_OPTIONS_t
!
  IMPLICIT NONE

!
  TYPE(TEB_VEG_OPTIONS_t), INTENT(INOUT) :: TVG
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_TEB_VEG_N:UPDATE_NAM_TEB_VEG_AGSN',0,ZHOOK_HANDLE)
  TVG%LNITRO_DILU = LNITRO_DILU
IF (LHOOK) CALL DR_HOOK('MODN_TEB_VEG_N:UPDATE_NAM_TEB_VEG_AGSN',1,ZHOOK_HANDLE)
END SUBROUTINE UPDATE_NAM_TEB_VEG_AGSn


SUBROUTINE INIT_NAM_SGH_TEB_VEGn (TVG)
!
  USE MODD_TEB_VEG_n, ONLY : TEB_VEG_OPTIONS_t
!
  IMPLICIT NONE

!
  TYPE(TEB_VEG_OPTIONS_t), INTENT(INOUT) :: TVG
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_TEB_TEB_VEG_N:INIT_NAM_SGH_TEB_VEGN',0,ZHOOK_HANDLE)
  CRUNOFF = TVG%CRUNOFF
  CKSAT   = TVG%CKSAT
  LSOC    = TVG%LSOC
  CRAIN   = TVG%CRAIN
  CHORT   = TVG%CHORT
IF (LHOOK) CALL DR_HOOK('MODN_TEB_VEG_N:INIT_NAM_SGH_TEB_VEGN',1,ZHOOK_HANDLE)
END SUBROUTINE INIT_NAM_SGH_TEB_VEGn

SUBROUTINE UPDATE_NAM_SGH_TEB_VEGn (TVG)
!
  USE MODD_TEB_VEG_n, ONLY : TEB_VEG_OPTIONS_t
!
  IMPLICIT NONE

!
  TYPE(TEB_VEG_OPTIONS_t), INTENT(INOUT) :: TVG
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_TEB_VEG_N:UPDATE_NAM_SGH_TEB_VEGN',0,ZHOOK_HANDLE)
  TVG%CRUNOFF  = CRUNOFF
  TVG%CKSAT    = CKSAT
  TVG%LSOC     = LSOC
  TVG%CRAIN    = CRAIN
  TVG%CHORT    = CHORT
IF (LHOOK) CALL DR_HOOK('MODN_TEB_VEG_N:UPDATE_NAM_SGH_TEB_VEGN',1,ZHOOK_HANDLE)
END SUBROUTINE UPDATE_NAM_SGH_TEB_VEGn

SUBROUTINE INIT_NAM_CH_CONTROLn (CHT)
!
  USE MODD_CH_TEB_n, ONLY : CH_TEB_t
!
  IMPLICIT NONE

!
  TYPE(CH_TEB_t), INTENT(INOUT) :: CHT
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_TEB_VEG_N:INIT_NAM_CH_CONTROLN',0,ZHOOK_HANDLE)
  CCHEM_SURF_FILE = CHT%CCHEM_SURF_FILE
IF (LHOOK) CALL DR_HOOK('MODN_TEB_VEG_N:INIT_NAM_CH_CONTROLN',1,ZHOOK_HANDLE)
END SUBROUTINE INIT_NAM_CH_CONTROLn

SUBROUTINE UPDATE_NAM_CH_CONTROLn (CHT)
!
  USE MODD_CH_TEB_n, ONLY : CH_TEB_t
!
  IMPLICIT NONE

!
  TYPE(CH_TEB_t), INTENT(INOUT) :: CHT
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_TEB_VEG_N:UPDATE_NAM_CH_CONTROLN',0,ZHOOK_HANDLE)
  CHT%CCHEM_SURF_FILE = CCHEM_SURF_FILE
IF (LHOOK) CALL DR_HOOK('MODN_TEB_VEG_N:UPDATE_NAM_CH_CONTROLN',1,ZHOOK_HANDLE)
END SUBROUTINE UPDATE_NAM_CH_CONTROLn

SUBROUTINE INIT_NAM_CH_TEB_VEGn (CHT)
!
  USE MODD_CH_TEB_n, ONLY : CH_TEB_t
!
  IMPLICIT NONE

!
  TYPE(CH_TEB_t), INTENT(INOUT) :: CHT
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_TEB_VEG_N:INIT_NAM_CH_TEB_VEGN',0,ZHOOK_HANDLE)
  LCH_BIO_FLUX = CHT%LCH_BIO_FLUX
  LCH_NO_FLUX  = CHT%LCH_NO_FLUX
IF (LHOOK) CALL DR_HOOK('MODN_TEB_VEG_N:INIT_NAM_CH_TEB_VEGN',1,ZHOOK_HANDLE)
END SUBROUTINE INIT_NAM_CH_TEB_VEGn

SUBROUTINE UPDATE_NAM_CH_TEB_VEGn (CHT)
!
  USE MODD_CH_TEB_n, ONLY : CH_TEB_t
!
  IMPLICIT NONE

!
  TYPE(CH_TEB_t), INTENT(INOUT) :: CHT
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_TEB_VEG_N:UPDATE_NAM_CH_TEB_VEGN',0,ZHOOK_HANDLE)
  CHT%LCH_BIO_FLUX = LCH_BIO_FLUX
  CHT%LCH_NO_FLUX  = LCH_NO_FLUX
  IF (LHOOK) CALL DR_HOOK('MODN_TEB_VEG_N:UPDATE_NAM_CH_TEB_VEGN',1,ZHOOK_HANDLE)
END SUBROUTINE UPDATE_NAM_CH_TEB_VEGn

END MODULE MODN_TEB_VEG_n
