!     ##################
MODULE MODN_FLAKE_n
!     ##################
!
!!****  *MODN_FLAKE_n* - declaration of namelist NAM_FLAKEn
!!
!!    PURPOSE
!!    -------
!       The purpose of this module is to specify  the namelist NAM_FLAKEn
!
!!
!!**  IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!       
!!    AUTHOR
!!    ------
!!      V. Masson    *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    01/2004                    
!!      Modified    04/2013, P. Le Moigne: FLake chemistry
!-------------------------------------------------------------------------------
!
!*       0.   DECLARATIONS
!             ------------
!

         

!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
REAL     :: XTSTEP
REAL     :: XOUT_TSTEP
REAL     :: XDIAG_TSTEP
INTEGER  :: N2M
LOGICAL  :: L2M_MIN_ZS
LOGICAL  :: LSURF_BUDGET
LOGICAL  :: LRAD_BUDGET
LOGICAL  :: LSURF_BUDGETC
LOGICAL  :: LRESET_BUDGETC
LOGICAL  :: LCOEF
LOGICAL  :: LSURF_VARS
 CHARACTER(LEN=6)  :: CCH_DRY_DEP
!
LOGICAL          :: LSEDIMENTS
LOGICAL          :: LSKINTEMP
 CHARACTER(LEN=3) :: CSNOW_FLK
 CHARACTER(LEN=5) :: CFLK_FLUX
 CHARACTER(LEN=4) :: CFLK_ALB
!
LOGICAL  :: LWATER_PROFILE
REAL,DIMENSION(100) :: XZWAT_PROFILE
!
NAMELIST/NAM_DIAG_FLAKEn/LWATER_PROFILE,XZWAT_PROFILE
NAMELIST/NAM_FLAKEn/LSEDIMENTS,CSNOW_FLK, CFLK_FLUX, CFLK_ALB,   &
                    LSKINTEMP
NAMELIST/NAM_DIAG_SURFn/N2M,L2M_MIN_ZS,LSURF_BUDGET,LRAD_BUDGET, &
                          LSURF_BUDGETC,LRESET_BUDGETC,LCOEF,LSURF_VARS  
NAMELIST/NAM_CH_FLAKEn/CCH_DRY_DEP
!
CONTAINS
!
SUBROUTINE INIT_NAM_FLAKEn (F)
!
  USE MODD_FLAKE_n, ONLY : FLAKE_t
!
  IMPLICIT NONE

!
  TYPE(FLAKE_t), INTENT(INOUT) :: F
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_FLAKE_N:INIT_NAM_FLAKEN',0,ZHOOK_HANDLE)
  XTSTEP=F%XTSTEP
  XOUT_TSTEP=F%XOUT_TSTEP
  LSEDIMENTS=F%LSEDIMENTS
  LSKINTEMP=F%LSKINTEMP
  CFLK_FLUX=F%CFLK_FLUX
  CFLK_ALB=F%CFLK_ALB
  CSNOW_FLK=F%CSNOW_FLK
IF (LHOOK) CALL DR_HOOK('MODN_FLAKE_N:INIT_NAM_FLAKEN',1,ZHOOK_HANDLE)
END SUBROUTINE INIT_NAM_FLAKEn
!
SUBROUTINE UPDATE_NAM_FLAKEn (F)
!
  USE MODD_FLAKE_n, ONLY : FLAKE_t
!
  IMPLICIT NONE

!
  TYPE(FLAKE_t), INTENT(INOUT) :: F
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_FLAKE_N:UPDATE_NAM_FLAKEN',0,ZHOOK_HANDLE)
  F%XTSTEP = XOUT_TSTEP
  F%XOUT_TSTEP = XOUT_TSTEP
  F%LSEDIMENTS = LSEDIMENTS
  F%LSKINTEMP  = LSKINTEMP
  F%CFLK_FLUX=CFLK_FLUX
  F%CFLK_ALB=CFLK_ALB
  F%CSNOW_FLK=CSNOW_FLK
IF (LHOOK) CALL DR_HOOK('MODN_FLAKE_N:UPDATE_NAM_FLAKEN',1,ZHOOK_HANDLE)
END SUBROUTINE UPDATE_NAM_FLAKEn
!
SUBROUTINE INIT_NAM_DIAG_SURFn (DGF)
!
  USE MODD_DIAG_FLAKE_n, ONLY : DIAG_FLAKE_t
!
  IMPLICIT NONE

!
  TYPE(DIAG_FLAKE_t), INTENT(INOUT) :: DGF
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_FLAKE_N:INIT_NAM_DIAG_SURFN',0,ZHOOK_HANDLE)
  XDIAG_TSTEP = DGF%XDIAG_TSTEP
  N2M = DGF%N2M
  L2M_MIN_ZS = DGF%L2M_MIN_ZS
  LSURF_BUDGET = DGF%LSURF_BUDGET
  LRAD_BUDGET = DGF%LRAD_BUDGET
  LSURF_BUDGETC = DGF%LSURF_BUDGETC
  LRESET_BUDGETC = DGF%LRESET_BUDGETC  
  LCOEF = DGF%LCOEF
  LSURF_VARS = DGF%LSURF_VARS
IF (LHOOK) CALL DR_HOOK('MODN_FLAKE_N:INIT_NAM_DIAG_SURFN',1,ZHOOK_HANDLE)
END SUBROUTINE INIT_NAM_DIAG_SURFn

SUBROUTINE UPDATE_NAM_DIAG_SURFn (DGF)
!
  USE MODD_DIAG_FLAKE_n, ONLY : DIAG_FLAKE_t
!
  IMPLICIT NONE

!
  TYPE(DIAG_FLAKE_t), INTENT(INOUT) :: DGF
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_FLAKE_N:UPDATE_NAM_DIAG_SURFN',0,ZHOOK_HANDLE)
  DGF%XDIAG_TSTEP = XDIAG_TSTEP  
  DGF%N2M = N2M
  DGF%L2M_MIN_ZS = L2M_MIN_ZS
  DGF%LSURF_BUDGET = LSURF_BUDGET
  DGF%LRAD_BUDGET = LRAD_BUDGET 
  DGF%LSURF_BUDGETC = LSURF_BUDGETC
  DGF%LRESET_BUDGETC = LRESET_BUDGETC  
  DGF%LCOEF = LCOEF
  DGF%LSURF_VARS = LSURF_VARS
IF (LHOOK) CALL DR_HOOK('MODN_FLAKE_N:UPDATE_NAM_DIAG_SURFN',1,ZHOOK_HANDLE)
END SUBROUTINE UPDATE_NAM_DIAG_SURFn
!
SUBROUTINE INIT_NAM_DIAG_FLAKEn (DGMF)
!
  USE MODD_DIAG_MISC_FLAKE_n, ONLY : DIAG_MISC_FLAKE_t
!
  IMPLICIT NONE

!
  TYPE(DIAG_MISC_FLAKE_t), INTENT(INOUT) :: DGMF
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_FLAKE_N:INIT_NAM_DIAG_FLAKEN',0,ZHOOK_HANDLE)
  LWATER_PROFILE = DGMF%LWATER_PROFILE
  XZWAT_PROFILE = DGMF%XZWAT_PROFILE
IF (LHOOK) CALL DR_HOOK('MODN_FLAKE_N:INIT_NAM_DIAG_FLAKEN',1,ZHOOK_HANDLE)
END SUBROUTINE INIT_NAM_DIAG_FLAKEn

SUBROUTINE UPDATE_NAM_DIAG_FLAKEn (DGMF)
!
  USE MODD_DIAG_MISC_FLAKE_n, ONLY : DIAG_MISC_FLAKE_t
!
  IMPLICIT NONE

!
  TYPE(DIAG_MISC_FLAKE_t), INTENT(INOUT) :: DGMF
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_FLAKE_N:UPDATE_NAM_DIAG_FLAKEN',0,ZHOOK_HANDLE)
  DGMF%LWATER_PROFILE = LWATER_PROFILE
  DGMF%XZWAT_PROFILE = XZWAT_PROFILE
IF (LHOOK) CALL DR_HOOK('MODN_FLAKE_N:UPDATE_NAM_DIAG_FLAKEN',1,ZHOOK_HANDLE)
END SUBROUTINE UPDATE_NAM_DIAG_FLAKEn

SUBROUTINE INIT_NAM_CH_FLAKEn (CHF)
!
  USE MODD_CH_FLAKE_n, ONLY : CH_FLAKE_t
!
  IMPLICIT NONE

!
  TYPE(CH_FLAKE_t), INTENT(INOUT) :: CHF
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_FLAKE_N:INIT_NAM_CH_FLAKEN',0,ZHOOK_HANDLE)
  CCH_DRY_DEP = CHF%CCH_DRY_DEP
IF (LHOOK) CALL DR_HOOK('MODN_FLAKE_N:INIT_NAM_CH_FLAKEN',1,ZHOOK_HANDLE)
END SUBROUTINE INIT_NAM_CH_FLAKEn

SUBROUTINE UPDATE_NAM_CH_FLAKEn (CHF)
!
  USE MODD_CH_FLAKE_n, ONLY : CH_FLAKE_t
!
  IMPLICIT NONE

!
  TYPE(CH_FLAKE_t), INTENT(INOUT) :: CHF
  REAL(KIND=JPRB) :: ZHOOK_HANDLE

  IF (LHOOK) CALL DR_HOOK('MODN_FLAKE_N:UPDATE_NAM_CH_FLAKEn',0,ZHOOK_HANDLE)
  CHF%CCH_DRY_DEP = CCH_DRY_DEP
IF (LHOOK) CALL DR_HOOK('MODN_FLAKE_N:UPDATE_NAM_CH_FLAKEn',1,ZHOOK_HANDLE)
END SUBROUTINE UPDATE_NAM_CH_FLAKEn

END MODULE MODN_FLAKE_n
