!##########################
MODULE MODE_CRODEBUG
!##########################
!
!! *MODE_CRODEBUG*
!!
!! PURPOSE
!! -------
! CROCUS debugging mode

!!
!!**  IMPLICIT ARGUMENTS
!!    ------------------
!!       NONE          
!!
!!    REFERENCE
!!    ---------
!!
!!    AUTHOR
!!    ------
!!      M. Lafaysse       * Meteo France *
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    11/06/2012
!!      Modification M Lafaysse 03/10/2012 : add energy balance control
!--------------------------------------------------------------------------------
!
IMPLICIT NONE
!
! To stop simulation if mass/energy balances not closed
LOGICAL,PARAMETER :: LPSTOPBALANCE = .FALSE.
!
LOGICAL :: LCRODAILYINFO = .FALSE.
LOGICAL :: LCRODEBUG = .FALSE.
LOGICAL :: LCRODEBUGDETAILS = .FALSE.
LOGICAL :: LCRODEBUGATM = .FALSE.
LOGICAL :: LPRINTGRAN = .FALSE.
LOGICAL :: LCONTROLBALANCE = .FALSE.
!
INTEGER :: NPOINTCRODEBUG = 1
INTEGER :: NTIMECRODEBUG = 0
INTEGER :: NENDCRODEBUG = 99999999
INTEGER :: NHOURCRODEBUG = 0
!
REAL :: XLATCRODEBUG = -999.
REAL :: XLONCRODEBUG = -999.
!
REAL :: XWARNING_MASSBALANCE=1.E-4
REAL :: XWARNING_ENERGYBALANCE=1.E-4
!
CONTAINS
!
SUBROUTINE INIT_CRODEBUG (I)
! Check environment variables to activate crocus debugging mode if required
!
!
!
USE MODD_ISBA_n, ONLY : ISBA_t
!
!
TYPE(ISBA_t), INTENT(INOUT) :: I
!
 CHARACTER(1) :: YCROCUS_INFO,YCROCUS_DEBUG,YCROCUS_BALANCE
 CHARACTER(8) :: YCROCUS_DEBUG_TIME
 CHARACTER(2) :: YCROCUS_DEBUG_HOUR
 CHARACTER(6) :: YCROCUS_DEBUG_POINT
 CHARACTER(12) :: YCROCUS_DEBUG_LAT,YCROCUS_DEBUG_LON
!
IF (I%TSNOW%SCHEME=='CRO') THEN
  !
  CALL GETENV("CROCUS_INFO",YCROCUS_INFO)
  SELECT CASE (YCROCUS_INFO)
    CASE ("1")
      PRINT*,"CROCUS : print daily informations."
      LCRODAILYINFO=.TRUE.
    CASE DEFAULT
      LCRODAILYINFO=.FALSE.
  END SELECT
  !
  CALL GETENV("CROCUS_DEBUG",YCROCUS_DEBUG)
  SELECT CASE (YCROCUS_DEBUG)
    CASE ("1")
      PRINT*,"CROCUS DEBUGGING MODE : print snow profile at the end of each time step"
      LCRODEBUG=.TRUE.
      LCRODEBUGDETAILS=.FALSE.
      LCRODEBUGATM=.FALSE.
      LPRINTGRAN=.FALSE.
    CASE ("2")
      PRINT*,"CROCUS DEBUGGING MODE : print snow profile after each CROCUS routine"
      LCRODEBUG=.TRUE.
      LCRODEBUGDETAILS=.TRUE.
      LCRODEBUGATM=.FALSE.
      LPRINTGRAN=.FALSE.
    CASE ("3")
      PRINT*,"CROCUS DEBUGGING MODE : print snow profile at the end of each &
            & time step and forcing data"
      LCRODEBUG=.TRUE.
      LCRODEBUGDETAILS=.FALSE.
      LCRODEBUGATM=.TRUE.
      LPRINTGRAN=.FALSE.
    CASE ("4")
      PRINT*,"CROCUS DEBUGGING MODE : print snow profile after each CROCUS routine &
            & and forcing data"
      LCRODEBUG=.TRUE.
      LCRODEBUGDETAILS=.TRUE.
      LCRODEBUGATM=.TRUE.
      LPRINTGRAN=.FALSE.
    CASE ("5")
      PRINT*,"CROCUS DEBUGGING MODE : print everything"
      LCRODEBUG=.TRUE.
      LCRODEBUGDETAILS=.TRUE.
      LCRODEBUGATM=.TRUE.
      LPRINTGRAN=.TRUE.
    CASE DEFAULT
      LCRODEBUG=.FALSE.
      LCRODEBUGDETAILS=.FALSE.
      LCRODEBUGATM=.FALSE.
      LPRINTGRAN=.FALSE.
  END SELECT
  !
  CALL GETENV("CROCUS_BALANCE",YCROCUS_BALANCE)
  SELECT CASE (YCROCUS_BALANCE)
    CASE ("1")
      PRINT*,"CROCUS DEBUGGING MODE : print mass and energy balance diagnostics."
      LCONTROLBALANCE=.TRUE.
    CASE DEFAULT
      LCONTROLBALANCE=.FALSE.
  END SELECT
  !
  IF (LCRODEBUG .OR. LCONTROLBALANCE) THEN
    !
    CALL GETENV("CROCUS_DEBUG_DATE",YCROCUS_DEBUG_TIME)
    IF ( LEN_TRIM(YCROCUS_DEBUG_TIME)>0 ) THEN
      READ(YCROCUS_DEBUG_TIME,'(I8)')NTIMECRODEBUG
      PRINT*,"after the date : ",NTIMECRODEBUG
    ELSE
      NTIMECRODEBUG = 0
    END IF
    !
    CALL GETENV("CROCUS_DEBUG_DATE_END",YCROCUS_DEBUG_TIME)
    IF (LEN_TRIM(YCROCUS_DEBUG_TIME)>0) THEN
      READ(YCROCUS_DEBUG_TIME,'(I8)')NENDCRODEBUG
      PRINT*,"before the date : ",NENDCRODEBUG
    ELSE
      NENDCRODEBUG = 99999999
    END IF
    !
    CALL GETENV("CROCUS_DEBUG_HOUR",YCROCUS_DEBUG_HOUR)
    IF (LEN_TRIM(YCROCUS_DEBUG_HOUR)>0) THEN
      READ(YCROCUS_DEBUG_HOUR,'(I2)')NHOURCRODEBUG
      PRINT*,"after the hour : ",NHOURCRODEBUG
    ELSE
      NHOURCRODEBUG = 0
    END IF
    !
    CALL GETENV("CROCUS_DEBUG_POINT",YCROCUS_DEBUG_POINT)
    IF (LEN_TRIM(YCROCUS_DEBUG_POINT)>0) THEN
      READ(YCROCUS_DEBUG_POINT,'(I6)')NPOINTCRODEBUG
    ELSE
      NPOINTCRODEBUG = 1
    END IF
    !
    CALL GETENV("CROCUS_DEBUG_LAT",YCROCUS_DEBUG_LAT)
    IF (LEN_TRIM(YCROCUS_DEBUG_LAT)>0) THEN
      READ(YCROCUS_DEBUG_LAT,*)XLATCRODEBUG
    ELSE 
      XLATCRODEBUG = -999.
    END IF
    !
    CALL GETENV("CROCUS_DEBUG_LON",YCROCUS_DEBUG_LON)
    IF (LEN_TRIM(YCROCUS_DEBUG_LON)>0) THEN
      READ(YCROCUS_DEBUG_LON,*)XLONCRODEBUG
    ELSE
      XLONCRODEBUG=-999.
    END IF
    !
  END IF
  !
END IF
!
END SUBROUTINE INIT_CRODEBUG
!
SUBROUTINE GETPOINT_CRODEBUG(PLAT,PLON,KDEBUG)
! gives the point to output for debugging
REAL,DIMENSION(:),INTENT(IN) :: PLAT,PLON
INTEGER,INTENT(OUT) :: KDEBUG
!
KDEBUG=MINLOC( (PLAT-XLATCRODEBUG)**2 + (PLON-XLONCRODEBUG)**2, 1 )
!
END SUBROUTINE GETPOINT_CRODEBUG
!
END MODULE MODE_CRODEBUG
