!##################
MODULE MODD_TEB_GARDEN_PGD_EVOL_n
!##################
!
!!****  *MODD_TEB_GARDEN - declaration of packed surface parameters for ISBA scheme
!!
!!    PURPOSE
!!    -------
!
!!
!!**  IMPLICIT ARGUMENTS
!!    ------------------
!!      None 
!!
!!    REFERENCE
!!    ---------
!!
!!    AUTHOR
!!    ------
!!      A. Lemonsu   *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original       01/2011
!!      V. Masson      06/2013 splits module in 4
!!
!-------------------------------------------------------------------------------
!
!*       0.   DECLARATIONS
!             ------------
!
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE

!-------------------------------------------------------------------------------
TYPE TEB_GARDEN_PGD_EVOL_1P_t
!!-------------------------------------------------------------------------------
!
! - Vegetation: Ags Prognostic (YPHOTO = ('LAI', 'LST', or 'NIT') or prescribed (YPHOTO='NON', 'AGS' or 'LST')
!
  REAL, POINTER, DIMENSION(:) :: XLAI          ! Leaf Area Index                         (m2/m2)
  REAL, POINTER, DIMENSION(:) :: XVEG          ! vegetation cover fraction               (-)
  REAL, POINTER, DIMENSION(:) :: XALBNIR       ! near-infra-red albedo                   (-)
  REAL, POINTER, DIMENSION(:) :: XALBVIS       ! visible albedo                          (-)
  REAL, POINTER, DIMENSION(:) :: XALBUV        ! UV albedo                               (-)
  REAL, POINTER, DIMENSION(:) :: XEMIS         ! surface emissivity                      (-)
  REAL, POINTER, DIMENSION(:) :: XZ0           ! surface roughness length                (m)
!
!-------------------------------------------------------------------------------
END TYPE TEB_GARDEN_PGD_EVOL_1P_t
!
TYPE TEB_GARDEN_PGD_EVOL_t
  !
  TYPE(TEB_GARDEN_PGD_EVOL_1P_t), POINTER :: ALP(:) => NULL()
  TYPE(TEB_GARDEN_PGD_EVOL_1P_t), POINTER :: CUR => NULL()
  !
END TYPE TEB_GARDEN_PGD_EVOL_t
!


CONTAINS
!
!
SUBROUTINE TEB_GARDEN_PGD_EVOL_GOTO_PATCH(YTEB_GARDEN_PGD_EVOL,KTO_PATCH)
TYPE(TEB_GARDEN_PGD_EVOL_t), INTENT(INOUT) :: YTEB_GARDEN_PGD_EVOL
INTEGER, INTENT(IN) :: KTO_PATCH
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
! Current patch is set to patch KTO_PATCH
IF (LHOOK) CALL DR_HOOK('MODD_TEB_GARDEN_PGD_EVOL_N:TEB_GARDEN_PGD_EVOL_GOTO_PATCH',0,ZHOOK_HANDLE)

YTEB_GARDEN_PGD_EVOL%CUR => YTEB_GARDEN_PGD_EVOL%ALP(KTO_PATCH)

IF (LHOOK) CALL DR_HOOK('MODD_TEB_GARDEN_PGD_EVOL_N:TEB_GARDEN_PGD_EVOL_GOTO_PATCH',1,ZHOOK_HANDLE)
!
END SUBROUTINE TEB_GARDEN_PGD_EVOL_GOTO_PATCH
!
SUBROUTINE TEB_GARDEN_PGD_EVOL_INIT(YTEB_GARDEN_PGD_EVOL,KPATCH)
TYPE(TEB_GARDEN_PGD_EVOL_t), INTENT(INOUT) :: YTEB_GARDEN_PGD_EVOL
INTEGER, INTENT(IN) :: KPATCH
INTEGER :: JP
REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK("MODD_TEB_GARDEN_PGD_EVOL_N:TEB_GARDEN_PGD_EVOL_INIT",0,ZHOOK_HANDLE)
 ALLOCATE(YTEB_GARDEN_PGD_EVOL%ALP(KPATCH))
 YTEB_GARDEN_PGD_EVOL%CUR => YTEB_GARDEN_PGD_EVOL%ALP(1)
DO JP=1,KPATCH
  NULLIFY(YTEB_GARDEN_PGD_EVOL%ALP(JP)%XALBNIR)
  NULLIFY(YTEB_GARDEN_PGD_EVOL%ALP(JP)%XALBVIS)
  NULLIFY(YTEB_GARDEN_PGD_EVOL%ALP(JP)%XALBUV)
  NULLIFY(YTEB_GARDEN_PGD_EVOL%ALP(JP)%XEMIS)
  NULLIFY(YTEB_GARDEN_PGD_EVOL%ALP(JP)%XZ0)
  NULLIFY(YTEB_GARDEN_PGD_EVOL%ALP(JP)%XVEG)
  NULLIFY(YTEB_GARDEN_PGD_EVOL%ALP(JP)%XLAI)
ENDDO 
IF (LHOOK) CALL DR_HOOK("MODD_TEB_GARDEN_PGD_EVOL_N:TEB_GARDEN_PGD_EVOL_INIT",1,ZHOOK_HANDLE)
END SUBROUTINE TEB_GARDEN_PGD_EVOL_INIT




END MODULE MODD_TEB_GARDEN_PGD_EVOL_n
