!     ######################
      MODULE MODD_SURFEX_MPI
!     ######################
!
!!****  *MODD_SURFEX_MPI
!!
!!    PURPOSE
!!    -------
!
!!
!!**  IMPLICIT ARGUMENTS
!!    ------------------
!!      None 
!!
!!    REFERENCE
!!    ---------
!!
!!    AUTHOR
!!    ------
!!      S. Faroux   *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original       04/06/12
!!      B. Decharme    04/2013  Delete NWG_LAYER_TOT, NWG_SIZE
!!      J.Escobar      10/06/2013: replace DOUBLE PRECISION by REAL to handle problem for promotion of real on IBM SP
!
!-------------------------------------------------------------------------------
!
!*       0.   DECLARATIONS
!             ------------
!
USE MODD_SURFEX_OMP, ONLY : NBLOCK
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!-------------------------------------------------------------------------------
!
INTEGER, DIMENSION(:), ALLOCATABLE :: NINDEX
INTEGER, DIMENSION(:), ALLOCATABLE :: NSIZE_TASK
!
INTEGER :: NPROC = 1
INTEGER :: NRANK = 0
INTEGER :: NCOMM = -1
INTEGER :: NPIO  = 0
INTEGER :: NSIZE = 0
INTEGER :: MYPROC = 0
!
INTEGER :: IDX_R = 0
INTEGER :: IDX_W = 0
!
REAL, DIMENSION(5) :: XTIME_WRITE
!$OMP THREADPRIVATE(XTIME_WRITE)
REAL, DIMENSION(6) :: XTIME_CALC
!$OMP THREADPRIVATE(XTIME_CALC)
REAL :: XTIME_NPIO_READ=0
!$OMP THREADPRIVATE(XTIME_NPIO_READ)
REAL :: XTIME_NPIO_WRITE=0
!$OMP THREADPRIVATE(XTIME_NPIO_WRITE)
REAL :: XTIME_COMM_READ=0
!$OMP THREADPRIVATE(XTIME_COMM_READ)
REAL :: XTIME_CALC_READ=0
!$OMP THREADPRIVATE(XTIME_CALC_READ)
REAL :: XTIME_COMM_WRITE=0
!$OMP THREADPRIVATE(XTIME_COMM_WRITE)
REAL :: XTIME_CALC_WRITE=0
!$OMP THREADPRIVATE(XTIME_CALC_WRITE)
REAL :: XTIME_OMP_BARR=0
!$OMP THREADPRIVATE(XTIME_OMP_BARR)
!
REAL :: XTIME_INIT_SEA=0
!$OMP THREADPRIVATE(XTIME_INIT_SEA)
REAL :: XTIME_INIT_WATER=0
!$OMP THREADPRIVATE(XTIME_INIT_WATER)
REAL :: XTIME_INIT_NATURE=0
!$OMP THREADPRIVATE(XTIME_INIT_NATURE)
REAL :: XTIME_INIT_TOWN=0
!$OMP THREADPRIVATE(XTIME_INIT_TOWN)
!
REAL :: XTIME_SEA=0
!$OMP THREADPRIVATE(XTIME_SEA)
REAL :: XTIME_WATER=0
!$OMP THREADPRIVATE(XTIME_WATER)
REAL :: XTIME_NATURE=0
!$OMP THREADPRIVATE(XTIME_NATURE)
REAL :: XTIME_TOWN=0
!$OMP THREADPRIVATE(XTIME_TOWN)
!
CONTAINS
!
SUBROUTINE WLOG_MPI(HLOG,PLOG,KLOG,KLOG2,OLOG)
!
IMPLICIT NONE
!
 CHARACTER(LEN=*), INTENT(IN) :: HLOG
REAL, INTENT(IN),OPTIONAL :: PLOG
INTEGER, INTENT(IN), OPTIONAL :: KLOG
INTEGER, INTENT(IN), OPTIONAL :: KLOG2
LOGICAL, INTENT(IN), OPTIONAL :: OLOG
!
INTEGER :: IUNIT
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('MODD_SURFEX_MPI:WLOG_MPI',0,ZHOOK_HANDLE)
!
IUNIT=100000+NRANK
!
!$OMP CRITICAL
!
IF (PRESENT(OLOG)) THEN
  IF (PRESENT(PLOG)) THEN
    IF (PRESENT(KLOG)) THEN
      IF (PRESENT(KLOG2)) THEN
        WRITE(IUNIT,*) NBLOCK, HLOG, KLOG, KLOG2, PLOG, OLOG
      ELSE
        WRITE(IUNIT,*) NBLOCK, HLOG, KLOG, PLOG, OLOG
      ENDIF
    ELSE
      WRITE(IUNIT,*) NBLOCK, HLOG, PLOG, OLOG
    ENDIF
  ELSEIF (PRESENT(KLOG)) THEN
    IF (PRESENT(KLOG2)) THEN
      WRITE(IUNIT,*) NBLOCK, HLOG, KLOG, KLOG2, OLOG
    ELSE
      WRITE(IUNIT,*) NBLOCK, HLOG, KLOG, OLOG
    ENDIF
  ELSE
    WRITE(IUNIT,*) NBLOCK, HLOG, OLOG
  ENDIF
ELSEIF (PRESENT(PLOG)) THEN
  IF (PRESENT(KLOG)) THEN
    IF (PRESENT(KLOG2)) THEN
      WRITE(IUNIT,*) NBLOCK, HLOG, KLOG, KLOG2, PLOG
    ELSE
      WRITE(IUNIT,*) NBLOCK, HLOG, KLOG, PLOG
    ENDIF
  ELSE
    WRITE(IUNIT,*) NBLOCK, HLOG, PLOG
  ENDIF
ELSEIF (PRESENT(KLOG)) THEN
  IF (PRESENT(KLOG2)) THEN
    WRITE(IUNIT,*) NBLOCK, HLOG, KLOG, KLOG2
  ELSE
    WRITE(IUNIT,*) NBLOCK, HLOG, KLOG
  ENDIF
ELSE
  WRITE(IUNIT,*) NBLOCK, HLOG
ENDIF
!
!$OMP END CRITICAL
!
IF (LHOOK) CALL DR_HOOK('MODD_SURFEX_MPI:WLOG_MPI',1,ZHOOK_HANDLE)
!
END SUBROUTINE WLOG_MPI
!
SUBROUTINE PREP_LOG_MPI
!
CHARACTER(LEN=100) :: YNAME
CHARACTER(LEN=10)  :: YRANK
INTEGER :: IUNIT
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('MODD_SURFEX_MPI:PREP_LOG_MPI',0,ZHOOK_HANDLE)
!
WRITE(YRANK,FMT='(I10)') NRANK
YNAME='log'//ADJUSTL(YRANK)
!
IUNIT=100000+NRANK
!
!$OMP SINGLE
OPEN(UNIT=IUNIT,FILE=TRIM(YNAME),FORM='FORMATTED')
WRITE(IUNIT,*) "Log offline pour proc ",NRANK
!$OMP END SINGLE
!
IF (LHOOK) CALL DR_HOOK('MODD_SURFEX_MPI:PREP_LOG_MPI',1,ZHOOK_HANDLE)
!
END SUBROUTINE PREP_LOG_MPI
!
SUBROUTINE END_LOG_MPI
!
INTEGER :: IUNIT
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('MODD_SURFEX_MPI:END_LOG_MPI',0,ZHOOK_HANDLE)
!
IUNIT=100000+NRANK
!
!$OMP SINGLE
WRITE(IUNIT,*) "End log offline pour proc ",NRANK
CLOSE(UNIT=IUNIT)
!$OMP END SINGLE
!
IF (LHOOK) CALL DR_HOOK('MODD_SURFEX_MPI:END_LOG_MPI',1,ZHOOK_HANDLE)
!
END SUBROUTINE END_LOG_MPI
!-------------------------------------------------------------------------------
!
END MODULE MODD_SURFEX_MPI

