!     ##################
      MODULE MODD_DATA_ISBA_n
!     ##################
!
!!****  *MODD_DATA_ISBA - declaration of DATA surface parameters for ISBA scheme
!!
!!    PURPOSE
!!    -------
!
!!
!!**  IMPLICIT ARGUMENTS
!!    ------------------
!!      None 
!!
!!    REFERENCE
!!    ---------
!!
!!    AUTHOR
!!    ------
!!      V. Masson  *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original       05/2005
!!      P Samuelsson   02/2012  MEB
!
!*       0.   DECLARATIONS
!             ------------
!
!
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE

TYPE DATA_ISBA_t
!-------------------------------------------------------------------------------
!
! Mask and number of grid elements containing patches/tiles:
!
  REAL, POINTER, DIMENSION(:,:)  :: XPAR_VEGTYPE       ! fraction of each vegetation type for
!                                                  ! each grid mesh                          (-)
!
!-------------------------------------------------------------------------------
!
  INTEGER                       :: NTIME               ! number of time data
!                                                      ! for VEG, LAI, EMIS, Z0
  LOGICAL                        :: LDATA_MIXPAR
!
  LOGICAL                        :: LDATA_VEGTYPE
  LOGICAL                        :: LDATA_LAI
  LOGICAL                        :: LDATA_H_TREE
  LOGICAL                        :: LDATA_DG
  LOGICAL                        :: LDATA_DICE  
  LOGICAL                        :: LDATA_ROOTFRAC
  LOGICAL                        :: LDATA_GROUND_DEPTH
  LOGICAL                        :: LDATA_ROOT_DEPTH
  LOGICAL                        :: LDATA_ROOT_EXTINCTION
  LOGICAL                        :: LDATA_ROOT_LIN
  LOGICAL                        :: LDATA_VEG
  LOGICAL                        :: LDATA_Z0
  LOGICAL                        :: LDATA_EMIS
  LOGICAL                        :: LDATA_ALBNIR_VEG
  LOGICAL                        :: LDATA_ALBVIS_VEG
  LOGICAL                        :: LDATA_ALBUV_VEG
  LOGICAL                        :: LDATA_RSMIN
  LOGICAL                        :: LDATA_GAMMA
  LOGICAL                        :: LDATA_WRMAX_CF
  LOGICAL                        :: LDATA_CV
  LOGICAL                        :: LDATA_Z0_O_Z0H
  LOGICAL                        :: LDATA_RGL
  LOGICAL                        :: LDATA_BSLAI
  LOGICAL                        :: LDATA_LAIMIN
  LOGICAL                        :: LDATA_SEFOLD
  LOGICAL                        :: LDATA_GMES
  LOGICAL                        :: LDATA_RE25
  LOGICAL                        :: LDATA_STRESS
  LOGICAL                        :: LDATA_F2I
  LOGICAL                        :: LDATA_GC
  LOGICAL                        :: LDATA_DMAX
  LOGICAL                        :: LDATA_CE_NITRO
  LOGICAL                        :: LDATA_CF_NITRO
  LOGICAL                        :: LDATA_CNA_NITRO
  LOGICAL                        :: LDATA_ALBNIR_SOIL
  LOGICAL                        :: LDATA_ALBVIS_SOIL
  LOGICAL                        :: LDATA_ALBUV_SOIL
  LOGICAL                        :: LDATA_IRRIG
  LOGICAL                        :: LDATA_WATSUP
! - For multi-energy balance (MEB)
!
  LOGICAL                        :: LDATA_GNDLITTER
  LOGICAL                        :: LDATA_LAIGV
  LOGICAL                        :: LDATA_Z0LITTER
  LOGICAL                        :: LDATA_RSMINGV
  LOGICAL                        :: LDATA_GAMMAGV
  LOGICAL                        :: LDATA_WRMAX_CFGV
  LOGICAL                        :: LDATA_RGLGV
  LOGICAL                        :: LDATA_ROOTFRACGV
  LOGICAL                        :: LDATA_ROOT_DEPTHGV
  LOGICAL                        :: LDATA_ROOT_EXTINCTIONGV
  LOGICAL                        :: LDATA_H_VEG
!
!  
! Input Parameters, per patch:
!
! - vegetation + bare soil:
!
  REAL, POINTER, DIMENSION(:,:) :: XPAR_Z0_O_Z0H         ! ratio of surface roughness lengths
!                                                      ! (momentum to heat)                      (-)
  REAL, POINTER, DIMENSION(:,:,:) :: XPAR_EMIS             ! surface emissivity                      (-)
  REAL, POINTER, DIMENSION(:,:,:) :: XPAR_Z0               ! surface roughness length                (m)
!
! - vegetation:
!
  REAL, POINTER, DIMENSION(:,:) :: XPAR_ALBNIR_VEG       ! vegetation near-infra-red albedo        (-)
  REAL, POINTER, DIMENSION(:,:) :: XPAR_ALBVIS_VEG       ! vegetation visible albedo               (-)
  REAL, POINTER, DIMENSION(:,:) :: XPAR_ALBUV_VEG        ! vegetation UV albedo                    (-)
!
! - vegetation: default option (Jarvis) and general parameters:
!
  REAL, POINTER, DIMENSION(:,:,:) :: XPAR_VEG            ! vegetation cover fraction               (-)
  REAL, POINTER, DIMENSION(:,:) :: XPAR_WRMAX_CF         ! coefficient for maximum water 
!                                                      ! interception 
!                                                      ! storage capacity on the vegetation      (-)
  REAL, POINTER, DIMENSION(:,:) :: XPAR_RSMIN            ! minimum stomatal resistance             (s/m)
  REAL, POINTER, DIMENSION(:,:) :: XPAR_GAMMA            ! coefficient for the calculation
!                                                      ! of the surface stomatal
!                                                      ! resistance
  REAL, POINTER, DIMENSION(:,:) :: XPAR_CV               ! vegetation thermal inertia coefficient  (K m2/J)
  REAL, POINTER, DIMENSION(:,:) :: XPAR_RGL              ! maximum solar radiation
!                                                      ! usable in photosynthesis                (W/m2)
  REAL, POINTER, DIMENSION(:,:,:) :: XPAR_ROOTFRAC       ! root fraction profile ('DIF' option)
!
  REAL, POINTER, DIMENSION(:,:) :: XPAR_ROOT_DEPTH       ! root depth ('DIF' option)
  REAL, POINTER, DIMENSION(:,:) :: XPAR_ROOT_EXTINCTION  ! root extinction parameter ('DIF' option)
  REAL, POINTER, DIMENSION(:,:) :: XPAR_ROOT_LIN         ! root linear parameter ('DIF' option)
!
! - For multi-energy balance (MEB)
!
  REAL, POINTER, DIMENSION(:,:,:) :: XPAR_GNDLITTER      ! ground litter fraction
  REAL, POINTER, DIMENSION(:,:,:) :: XPAR_LAIGV          ! understory LAI
  REAL, POINTER, DIMENSION(:,:,:) :: XPAR_Z0LITTER       ! ground litter roughness length
  REAL, POINTER, DIMENSION(:,:)   :: XPAR_RSMINGV        ! understory minimum surface resistance
  REAL, POINTER, DIMENSION(:,:)   :: XPAR_GAMMAGV        !
  REAL, POINTER, DIMENSION(:,:)   :: XPAR_WRMAX_CFGV     !
  REAL, POINTER, DIMENSION(:,:)   :: XPAR_RGLGV          !
  REAL, POINTER, DIMENSION(:,:,:) :: XPAR_ROOTFRACGV     ! understory root fraction profile
  REAL, POINTER, DIMENSION(:,:,:) :: XPAR_H_VEG          ! height of canopy vegetation
  REAL, POINTER, DIMENSION(:,:) :: XPAR_ROOT_DEPTHGV       ! root depth ('DIF' option)
  REAL, POINTER, DIMENSION(:,:) :: XPAR_ROOT_EXTINCTIONGV  ! root extinction parameter ('DIF' option)
!
!  
!-------------------------------------------------------------------------------
!
! - vegetation: Ags parameters ('AGS', 'LAI', 'AST', 'LST', 'NIT', 'NCB' options)
!
  REAL, POINTER, DIMENSION(:,:)    :: XPAR_BSLAI        ! ratio d(biomass)/d(lai)                 (kg/m2)
  REAL, POINTER, DIMENSION(:,:)    :: XPAR_LAIMIN       ! minimum LAI (Leaf Area Index)           (m2/m2)
  REAL, POINTER, DIMENSION(:,:)    :: XPAR_SEFOLD       ! e-folding time for senescence           (s)
  REAL, POINTER, DIMENSION(:,:)    :: XPAR_H_TREE       ! height of trees                         (m)
  REAL, POINTER, DIMENSION(:,:)    :: XPAR_GMES         ! mesophyll conductance                   (m s-1)
  REAL, POINTER, DIMENSION(:,:)    :: XPAR_RE25         ! Ecosystem respiration parameter         (kg m2 s-1)
!
!-------------------------------------------------------------------------------
!
! - vegetation: Ags Stress parameters ('AST', 'LST', 'NIT', 'NCB' options)
!
  LOGICAL, POINTER, DIMENSION(:,:) :: LPAR_STRESS       ! vegetation response type to water
!                                                     ! stress (true:defensive false:offensive) (-)
  REAL, POINTER, DIMENSION(:,:)    :: XPAR_F2I          ! critical normilized soil water 
!                                                     ! content for stress parameterisation
  REAL, POINTER, DIMENSION(:,:)    :: XPAR_GC           ! cuticular conductance                   (m s-1)
  REAL, POINTER, DIMENSION(:,:)    :: XPAR_DMAX         ! maximum air saturation deficit
!                                                     ! tolerate by vegetation                  (kg/kg)
!
!-------------------------------------------------------------------------------
!
! - vegetation: Ags Nitrogen-model parameters ('NIT', 'NCB' option)
!
  REAL, POINTER, DIMENSION(:,:)    :: XPAR_CE_NITRO       ! leaf aera ratio sensitivity to 
!                                                       ! nitrogen concentration                (m2/kg)
  REAL, POINTER, DIMENSION(:,:)    :: XPAR_CF_NITRO       ! lethal minimum value of leaf area
!                                                       ! ratio                                 (m2/kg)
  REAL, POINTER, DIMENSION(:,:)    :: XPAR_CNA_NITRO      ! nitrogen concentration of active 
!                                                       ! biomass                               (kg/kg)
!
!-------------------------------------------------------------------------------
!
! - soil: primary parameters
!
  REAL, POINTER, DIMENSION(:,:,:)  :: XPAR_DG          ! soil layer depth                        (m)
!                                                      ! NOTE: in Force-Restore mode, the 
!                                                      ! uppermost layer thickness is superficial
!                                                      ! and is only explicitly used for soil 
!                                                      ! water phase changes                     (m)
!
  REAL, POINTER,DIMENSION(:,:)     :: XPAR_GROUND_DEPTH ! ground depth (DIF option)
!
  REAL, POINTER,DIMENSION(:,:)     :: XPAR_DICE        ! depth of the soil column for the calculation
!                                                        of the frozen soil fraction (m) (Force restore)
!
! - bare soil albedo
!
  REAL, POINTER, DIMENSION(:,:) :: XPAR_ALBNIR_SOIL      ! soil near-infra-red albedo        (-)
  REAL, POINTER, DIMENSION(:,:) :: XPAR_ALBVIS_SOIL      ! soil visible albedo               (-)
  REAL, POINTER, DIMENSION(:,:) :: XPAR_ALBUV_SOIL       ! soil UV albedo                    (-)
!
!-------------------------------------------------------------------------------
!
! - Vegetation: Ags Prognostic (YPHOTO = ('LAI', 'LST', 'NIT', or 'NCB') or prescribed (YPHOTO='NON', 'AGS' or 'AST')
!
  REAL, POINTER, DIMENSION(:,:,:)     :: XPAR_LAI          ! Leaf Area Index                         (m2/m2)
!
  REAL, POINTER, DIMENSION(:,:,:)     :: XPAR_IRRIG
  REAL, POINTER, DIMENSION(:,:,:)     :: XPAR_WATSUP
!
!-------------------------------------------------------------------------------
!

END TYPE DATA_ISBA_t



CONTAINS

!




SUBROUTINE DATA_ISBA_INIT(YDATA_ISBA)
TYPE(DATA_ISBA_t), INTENT(INOUT) :: YDATA_ISBA
REAL(KIND=JPRB) :: ZHOOK_HANDLE
IF (LHOOK) CALL DR_HOOK("MODD_DATA_ISBA_N:DATA_ISBA_INIT",0,ZHOOK_HANDLE)
  NULLIFY(YDATA_ISBA%XPAR_VEGTYPE)
  NULLIFY(YDATA_ISBA%XPAR_Z0_O_Z0H)
  NULLIFY(YDATA_ISBA%XPAR_EMIS)
  NULLIFY(YDATA_ISBA%XPAR_Z0)
  NULLIFY(YDATA_ISBA%XPAR_ALBNIR_VEG)
  NULLIFY(YDATA_ISBA%XPAR_ALBVIS_VEG)
  NULLIFY(YDATA_ISBA%XPAR_ALBUV_VEG)
  NULLIFY(YDATA_ISBA%XPAR_VEG)
  NULLIFY(YDATA_ISBA%XPAR_WRMAX_CF)
  NULLIFY(YDATA_ISBA%XPAR_RSMIN)
  NULLIFY(YDATA_ISBA%XPAR_GAMMA)
  NULLIFY(YDATA_ISBA%XPAR_CV)
  NULLIFY(YDATA_ISBA%XPAR_RGL)
  NULLIFY(YDATA_ISBA%XPAR_ROOTFRAC)
  NULLIFY(YDATA_ISBA%XPAR_BSLAI)
  NULLIFY(YDATA_ISBA%XPAR_LAIMIN)
  NULLIFY(YDATA_ISBA%XPAR_SEFOLD)
  NULLIFY(YDATA_ISBA%XPAR_H_TREE)
  NULLIFY(YDATA_ISBA%XPAR_GMES)
  NULLIFY(YDATA_ISBA%XPAR_RE25)
  NULLIFY(YDATA_ISBA%LPAR_STRESS)
  NULLIFY(YDATA_ISBA%XPAR_F2I)
  NULLIFY(YDATA_ISBA%XPAR_GC)
  NULLIFY(YDATA_ISBA%XPAR_DMAX)
  NULLIFY(YDATA_ISBA%XPAR_CE_NITRO)
  NULLIFY(YDATA_ISBA%XPAR_CF_NITRO)
  NULLIFY(YDATA_ISBA%XPAR_CNA_NITRO)
  NULLIFY(YDATA_ISBA%XPAR_DG)
  NULLIFY(YDATA_ISBA%XPAR_DICE)
  NULLIFY(YDATA_ISBA%XPAR_GROUND_DEPTH)  
  NULLIFY(YDATA_ISBA%XPAR_ROOT_DEPTH)  
  NULLIFY(YDATA_ISBA%XPAR_ROOT_EXTINCTION)  
  NULLIFY(YDATA_ISBA%XPAR_ROOT_LIN)
  NULLIFY(YDATA_ISBA%XPAR_ALBNIR_SOIL)
  NULLIFY(YDATA_ISBA%XPAR_ALBVIS_SOIL)
  NULLIFY(YDATA_ISBA%XPAR_ALBUV_SOIL)
  NULLIFY(YDATA_ISBA%XPAR_LAI)
  NULLIFY(YDATA_ISBA%XPAR_IRRIG)
  NULLIFY(YDATA_ISBA%XPAR_WATSUP)  
  NULLIFY(YDATA_ISBA%XPAR_GNDLITTER)
  NULLIFY(YDATA_ISBA%XPAR_LAIGV)
  NULLIFY(YDATA_ISBA%XPAR_Z0LITTER)
  NULLIFY(YDATA_ISBA%XPAR_RSMINGV)
  NULLIFY(YDATA_ISBA%XPAR_GAMMAGV)
  NULLIFY(YDATA_ISBA%XPAR_WRMAX_CFGV)
  NULLIFY(YDATA_ISBA%XPAR_RGLGV)
  NULLIFY(YDATA_ISBA%XPAR_ROOTFRACGV)
  NULLIFY(YDATA_ISBA%XPAR_ROOT_DEPTHGV)
  NULLIFY(YDATA_ISBA%XPAR_ROOT_EXTINCTIONGV)
  NULLIFY(YDATA_ISBA%XPAR_H_VEG)
YDATA_ISBA%NTIME=0
YDATA_ISBA%LDATA_MIXPAR=.FALSE.
YDATA_ISBA%LDATA_VEGTYPE=.FALSE.
YDATA_ISBA%LDATA_LAI=.FALSE.
YDATA_ISBA%LDATA_H_TREE=.FALSE.
YDATA_ISBA%LDATA_DG=.FALSE.
YDATA_ISBA%LDATA_DICE=.FALSE.
YDATA_ISBA%LDATA_GROUND_DEPTH=.FALSE.
YDATA_ISBA%LDATA_ROOT_DEPTH=.FALSE.
YDATA_ISBA%LDATA_ROOT_EXTINCTION=.FALSE.
YDATA_ISBA%LDATA_ROOT_LIN=.FALSE.
YDATA_ISBA%LDATA_ROOTFRAC=.FALSE.
YDATA_ISBA%LDATA_VEG=.FALSE.
YDATA_ISBA%LDATA_Z0=.FALSE.
YDATA_ISBA%LDATA_EMIS=.FALSE.
YDATA_ISBA%LDATA_ALBNIR_VEG=.FALSE.
YDATA_ISBA%LDATA_ALBVIS_VEG=.FALSE.
YDATA_ISBA%LDATA_ALBUV_VEG=.FALSE.
YDATA_ISBA%LDATA_RSMIN=.FALSE.
YDATA_ISBA%LDATA_GAMMA=.FALSE.
YDATA_ISBA%LDATA_WRMAX_CF=.FALSE.
YDATA_ISBA%LDATA_CV=.FALSE.
YDATA_ISBA%LDATA_RGL=.FALSE.
YDATA_ISBA%LDATA_Z0_O_Z0H=.FALSE.
YDATA_ISBA%LDATA_BSLAI=.FALSE.
YDATA_ISBA%LDATA_LAIMIN=.FALSE.
YDATA_ISBA%LDATA_SEFOLD=.FALSE.
YDATA_ISBA%LDATA_GMES=.FALSE.
YDATA_ISBA%LDATA_RE25=.FALSE.
YDATA_ISBA%LDATA_STRESS=.FALSE.
YDATA_ISBA%LDATA_F2I=.FALSE.
YDATA_ISBA%LDATA_GC=.FALSE.
YDATA_ISBA%LDATA_DMAX=.FALSE.
YDATA_ISBA%LDATA_CE_NITRO=.FALSE.
YDATA_ISBA%LDATA_CF_NITRO=.FALSE.
YDATA_ISBA%LDATA_CNA_NITRO=.FALSE.
YDATA_ISBA%LDATA_ALBNIR_SOIL=.FALSE.
YDATA_ISBA%LDATA_ALBVIS_SOIL=.FALSE.
YDATA_ISBA%LDATA_ALBUV_SOIL=.FALSE.
YDATA_ISBA%LDATA_IRRIG=.FALSE.
YDATA_ISBA%LDATA_WATSUP=.FALSE.
YDATA_ISBA%LDATA_GNDLITTER=.FALSE.
YDATA_ISBA%LDATA_LAIGV=.FALSE.
YDATA_ISBA%LDATA_Z0LITTER=.FALSE.
YDATA_ISBA%LDATA_RSMINGV=.FALSE.
YDATA_ISBA%LDATA_GAMMAGV=.FALSE.
YDATA_ISBA%LDATA_WRMAX_CFGV=.FALSE.
YDATA_ISBA%LDATA_RGLGV=.FALSE.
YDATA_ISBA%LDATA_ROOTFRACGV=.FALSE.
YDATA_ISBA%LDATA_ROOT_DEPTHGV=.FALSE.
YDATA_ISBA%LDATA_ROOT_EXTINCTIONGV=.FALSE.
YDATA_ISBA%LDATA_H_VEG=.FALSE.
IF (LHOOK) CALL DR_HOOK("MODD_DATA_ISBA_N:DATA_ISBA_INIT",1,ZHOOK_HANDLE)
END SUBROUTINE DATA_ISBA_INIT


END MODULE MODD_DATA_ISBA_n
