MODULE MODD_CONST_TARTES

!##########################
!
!! *MODD_CONST_TARTES*
!!
!! Constants for TARTES model (Radiative transfer in snowpack)

!!
!!**  IMPLICIT ARGUMENTS
!!    ------------------
!!       NONE          
!!
!!    REFERENCE
!!    ---------
!!
!!    AUTHOR
!!    ------
!!    M. Lafaysse       * Meteo France *
!!    translated from python codes of G. Picard, Q. Libois, LGGE.
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    19/07/2013
!!      M Lafaysse  22/08/2013 Spectral distribution of radiation
!--------------------------------------------------------------------------------
!
IMPLICIT NONE
!
INTEGER, PARAMETER :: NPNIMP = 1 ! number of impurities types
!
! INTEGER,PARAMETER::JPNBANDS=106 ! number of bands
!Wavelength of each band (nanometers)
!from Q Libois
! REAL,DIMENSION(JPNBANDS),PARAMETER::PPWAVELENGTHS=(/400,420,440,460,480,500,520,540,560,580,600,&
! 620,640,660,680,700,720,740,760,780,800,820,840,860,880,900,920,940,960,980,1000,1020,1040,1060,&
! 1080,1100,1120,1140,1160,1180,1200,1220,1240,1260,1280,1300,1320,1340,1360,1380,1400,1420,1440,&
! 1460,1480,1500,1520,1540,1560,1580,1600,1620,1640,1660,1680,1700,1720,1740,1760,1780,1800,1820,&
! 1840,1860,1880,1900,1920,1940,1960,1980,2000,2020,2040,2060,2080,2100,2120,2140,2160,2180,2200,&
! 2220,2240,2260,2280,2300,2320,2340,2360,2380,2400,2420,2440,2460,2480,2500/)
!
INTEGER, PARAMETER :: NPNBANDS = 111 ! number of bands
!Wavelength of each band (nanometers)
REAL, DIMENSION(NPNBANDS), PARAMETER :: XPWAVELENGTHS = (/300,320,340,360,380,400,420,440,460,480,500,520,540,560,580,600, &
620,640,660,680,700,720,740,760,780,800,820,840,860,880,900,920,940,960,980,1000,1020,1040,1060,                           &
1080,1100,1120,1140,1160,1180,1200,1220,1240,1260,1280,1300,1320,1340,1360,1380,1400,1420,1440,                            &
1460,1480,1500,1520,1540,1560,1580,1600,1620,1640,1660,1680,1700,1720,1740,1760,1780,1800,1820,                            &
1840,1860,1880,1900,1920,1940,1960,1980,2000,2020,2040,2060,2080,2100,2120,2140,2160,2180,2200,                            &
2220,2240,2260,2280,2300,2320,2340,2360,2380,2400,2420,2440,2460,2480,2500/)
!
!same in meters
REAL, DIMENSION(NPNBANDS), PARAMETER :: XPWAVELENGTHS_M = 1.0E-9*XPWAVELENGTHS
!
!Spectral repartition coefficients for direct and diffuse radiations
!from M Dumont
!
!W-1 m2 band-1
REAL, DIMENSION(NPNBANDS), PARAMETER :: XPRATIO_DIR= (/5.3620478055e-06 , 0.00265368651509 , 0.00770988673622,     &
0.0088185884535 , 0.0103331270383 , 0.0171505781649 , 0.0198451186994 , 0.0221263882188 , 0.0269183720813,         &
0.0284714330666 , 0.0278466267651 , 0.0271991801054 , 0.0269396607763 , 0.0279091411868 , 0.028135882684,          &
0.0276124511204 , 0.0279912547245 , 0.0274326799185 , 0.0272133725687 , 0.0266618939943 , 0.0243775832327,         &
0.0204537050428 , 0.0233222722108 , 0.00840700701746 , 0.0228948087324 , 0.0215367251598 , 0.0194838867165,        &
0.0201489049974 , 0.0198150441938 , 0.0191493500813 , 0.0148987073194 , 0.0155873797058 , 0.0119493782769,         &
0.0115959183573 , 0.0146043826636 , 0.0152616288813 , 0.0146057343268 , 0.0142522744072 , 0.0132686015333,         &
0.0124782164932 , 0.0102101256896 , 0.00408303652848 , 0.0068100169791 , 0.00916495214147 , 0.0098428112225,       &
0.0095721406722 , 0.0099806808661 , 0.0101215917518 , 0.0089963321607 , 0.00900545588711 , 0.00859556403003,       &
0.00641803465906 , 0.00517382870873 , 5.01804952809e-06 , 2.1841863121e-05 , 0.000124052266819 , 0.00124015096081, &
0.00188915203311 , 0.00308652285452 , 0.00287708264593 ,0.00554722566014 , 0.0060121977915 , 0.00591791928521,     &
0.00595407627508 , 0.00543368595365 , 0.00517112538238 , 0.00532048416295 , 0.0051207759292 , 0.00510151472899,    &
0.004864635758 , 0.00471054615633 , 0.00443582061651 , 0.00389110035798 , 0.00371808747189 , 0.00274461965502,     &
0.00140461457733 , 0.000168146898665 , 2.19929114805e-06 , 6.71945554654e-06 , 2.41930812097e-05,                  &
4.64938339778e-06 , 9.67993581021e-05 , 0.000500622247533 , 0.000862800394618 , 0.00208804926895,                  &
0.00123667042814 , 0.00129908347514 , 0.00206726744768 , 0.00156698311594 , 0.00194092073262,                      &
0.00199302734792 , 0.00188678662256 , 0.00187786564562 , 0.00171482127543 , 0.00162006968704,                      &
0.00151109184375 , 0.00164301416939 , 0.00156603695172 , 0.00147020403278 , 0.00143884544718,                      &
0.00131293802266 , 0.00107230818636 , 0.00104040893549 , 0.00120118926987 , 0.000960289100938,                     &
0.000937885283853 , 0.000887231706461 , 0.000785688010624 , 0.000758891288228 , 0.000442399356375,                 &
0.000309470041671 /)

! Fraction of direct solar radiation between 2520 and 4000 nanometers 
REAL, PARAMETER :: XPCOEFNIR_DIR = 0.001000684

REAL, DIMENSION(NPNBANDS), PARAMETER :: XPRATIO_DIF = (/4.68915470846e-05, 0.023565193397, 0.0541992631727, 0.0466197761774,   &
0.0432062627631, 0.0587857291996, 0.0571975956246, 0.054718018064, 0.0582315644181, 0.054304607596, 0.0478679748066,           &
0.0423404909479, 0.0382223207188, 0.0362313996428, 0.0331675588941, 0.0302188002885, 0.0287218471807, 0.0263785976973,         &
0.0245275456876, 0.0227765266177, 0.019069996362, 0.0144118253075, 0.016463828444, 0.00460771196103, 0.0146897929455,          &
0.0128697245897, 0.0108637543104, 0.0109460823051, 0.0104113929632, 0.00955624411514, 0.00664378064698, 0.00681374811989,      &
0.00465285957102, 0.00437223619126, 0.00556466424342, 0.00575676289771, 0.00534158193522, 0.00507600775879, 0.0045280397081,   &
0.00405000619053, 0.00308597193009, 0.000998558903369, 0.00170852720169, 0.00240964302746, 0.00253269239587, 0.00236626591197, &
0.00243177420883, 0.00242734797255, 0.00204403591124, 0.00200065879576, 0.00184662577343, 0.00128803475568, 0.00096137851867,  &
8.71083298684e-07, 3.41705440337e-06, 1.77846173481e-05, 0.000176872401501, 0.000269469264349, 0.000442003954302,              &
0.000402079303112,0.000809115990851, 0.000872853793194, 0.000850722611825, 0.000846296375551, 0.000757771650075,               &
0.000709968298318, 0.000725902748903, 0.000687837116949, 0.000676328902637, 0.000640033765192, 0.00060993535853,               &
0.000563017254027, 0.000483345001099, 0.000454131841692, 0.000323734921066, 0.00015164285474, 1.64124841033e-05,               &
2.41406926373e-07, 6.8429612793e-07, 2.30783959316e-06, 4.65640056004e-07, 8.73739040448e-06, 4.57672830711e-05,               &
8.06460249087e-05, 0.000203075720242, 0.000115436242021, 0.000120836250275, 0.000197410137812,0.000145711698134,               &
0.000182449459206, 0.000186344547127, 0.000175633055344, 0.000174924857541, 0.000157839585524, 0.000148278915172,              &
0.000137124799762, 0.000148987112976, 0.000141108412409, 0.000131370692606, 0.000126767406882, 0.000113311648609,              &
9.11804672403e-05, 8.71083298684e-05, 9.93247419841e-05, 7.80788078698e-05, 7.54230661056e-05, 7.00230578515e-05,              &
6.11705853039e-05, 5.81607446377e-05,3.26656237007e-05, 2.23436407101e-05 /)
!
! Fraction of diffuse solar radiation between 2520 and 4000 nanometers 
REAL, PARAMETER :: XPCOEFNIR_DIF = 0.01216941
!
REAL, PARAMETER :: XP_MUDIFF = 0.601815023 ! =cos(53./180.*XPI) : diffuse incident flux is treated as direct flux at incident angle 53deg
!
REAL, PARAMETER :: XPMAX_OPTICALDEPTH = 200. !maximum optical depth per layer
REAL, PARAMETER :: XPTAUMAX = 30. !above this optical depth, absorbed energy can be neglected
!
! Real and imaginary components of ice refractive index in the chosen bands
REAL, DIMENSION(NPNBANDS) :: XREFICE_R
REAL, DIMENSION(NPNBANDS) :: XREFICE_I
!
REAL, DIMENSION(NPNBANDS) :: XREFICE_NORM !XREFICE_R-1.3
REAL, DIMENSION(NPNBANDS) :: XGINF ! parameter used for assymetry parameter, function of XREFICE_NORM
REAL, DIMENSION(NPNBANDS) :: XCONST_C ! constant used for assymetry parameter
!
! Imaginary component of impurities refractive index
REAL, DIMENSION(NPNBANDS,NPNIMP) :: XREFIMP_I

INTEGER, PARAMETER :: NPNBANDS_REF = 191 ! number of reference bands

! wl in nm corresponding to the refractive index below
REAL, DIMENSION(NPNBANDS_REF), PARAMETER :: XPWAVELENGTHS_REF= &
       (/ 199. ,  201. ,   201.9,   210. ,   250. ,   300. ,   350. ,&
         390. ,   400. ,   410. ,   420. ,   430. ,   440. ,   450. ,&
         460. ,   470. ,   480. ,   490. ,   500. ,   510. ,   520. ,&
         530. ,   540. ,   550. ,   560. ,   570. ,   580. ,   590. ,&
         600. ,   610. ,   620. ,   630. ,   640. ,   650. ,   660. ,&
         670. ,   680. ,   690. ,   700. ,   710. ,   720. ,   730. ,&
         740. ,   750. ,   760. ,   770. ,   780. ,   790. ,   800. ,&
         810. ,   820. ,   830. ,   840. ,   850. ,   860. ,   870. ,&
         880. ,   890. ,   900. ,   910. ,   920. ,   930. ,   940. ,&
         950. ,   960. ,   970. ,   980. ,   990. ,  1000. ,  1010. ,&
        1020. ,  1030. ,  1040. ,  1050. ,  1060. ,  1070. ,  1080. ,&
        1090. ,  1100. ,  1110. ,  1120. ,  1130. ,  1140. ,  1150. ,&
        1160. ,  1170. ,  1180. ,  1190. ,  1200. ,  1210. ,  1220. ,&
        1230. ,  1240. ,  1250. ,  1260. ,  1270. ,  1280. ,  1290. ,&
        1300. ,  1310. ,  1320. ,  1330. ,  1340. ,  1350. ,  1360. ,&
        1370. ,  1380. ,  1390. ,  1400. ,  1410. ,  1420. ,  1430. ,&
        1440. ,  1449. ,  1460. ,  1471. ,  1481. ,  1493. ,  1504. ,&
        1515. ,  1527. ,  1538. ,  1563. ,  1587. ,  1613. ,  1650. ,&
        1680. ,  1700. ,  1730. ,  1760. ,  1800. ,  1830. ,  1840. ,&
        1850. ,  1855. ,  1860. ,  1870. ,  1890. ,  1905. ,  1923. ,&
        1942. ,  1961. ,  1980. ,  2000. ,  2020. ,  2041. ,  2062. ,&
        2083. ,  2105. ,  2130. ,  2150. ,  2170. ,  2190. ,  2220. ,&
        2240. ,  2245. ,  2250. ,  2260. ,  2270. ,  2290. ,  2310. ,&
        2330. ,  2350. ,  2370. ,  2390. ,  2410. ,  2430. ,  2460. ,&
        2500. ,  2520. ,  2550. ,  2565. ,  2580. ,  2590. ,  2600. ,&
        2620. ,  2675. ,  2725. ,  2778. ,  2817. ,  2833. ,  2849. ,&
        2865. ,  2882. ,  2899. ,  2915. ,  2933. ,  2950. ,  2967. ,&
        2985. ,  3003. /)
!
! Real and imaginary components of ice refractive index in reference bands from Warren (2008)
REAL, DIMENSION(NPNBANDS_REF), SAVE :: XPREFICE_R=(/1.3943, 1.3914 , 1.3901, 1.3801, 1.3509, 1.3339, &
1.3249, 1.3203, 1.3194, 1.3185, 1.3177, 1.3170, 1.3163, 1.3157, 1.3151, 1.3145, 1.3140, 1.3135, &
1.3130, 1.3126, 1.3121, 1.3117, 1.3114, 1.3110, 1.3106, 1.3103, 1.3100, 1.3097, 1.3094, 1.3091, &
1.3088, 1.3085, 1.3083, 1.3080, 1.3078, 1.3076, 1.3073, 1.3071, 1.3069, 1.3067, 1.3065, 1.3062, &
1.3060, 1.3059, 1.3057, 1.3055, 1.3053, 1.3051, 1.3049, 1.3047, 1.3046, 1.3044, 1.3042, 1.3040, &
1.3039, 1.3037, 1.3035, 1.3033, 1.3032, 1.3030, 1.3028, 1.3027, 1.3025, 1.3023, 1.3022, 1.3020, &
1.3019, 1.3017, 1.3015, 1.3014, 1.3012, 1.3010, 1.3009, 1.3007, 1.3005, 1.3003, 1.3002, 1.3000, &
1.2998, 1.2997, 1.2995, 1.2993, 1.2991, 1.2990, 1.2988, 1.2986, 1.2984, 1.2982, 1.2980, 1.2979, &
1.2977, 1.2975, 1.2973, 1.2971, 1.2969, 1.2967, 1.2965, 1.2963, 1.2961, 1.2959, 1.2957, 1.2955, &
1.2953, 1.2951, 1.2949, 1.2946, 1.2944, 1.2941, 1.2939, 1.2937, 1.2934, 1.2931, 1.2929, 1.2927, &
1.2924, 1.2921, 1.2920, 1.2918, 1.2916, 1.2914, 1.2912, 1.2909, 1.2903, 1.2897, 1.2890, 1.2879, &
1.2870, 1.2863, 1.2853, 1.2843, 1.2828, 1.2816, 1.2811, 1.2807, 1.2805, 1.2802, 1.2797, 1.2788, &
1.2780, 1.2771, 1.2762, 1.2756, 1.2750, 1.2744, 1.2736, 1.2728, 1.2718, 1.2707, 1.2694, 1.2677, &
1.2663, 1.2648, 1.2633, 1.2609, 1.2591, 1.2587, 1.2582, 1.2573, 1.2564, 1.2545, 1.2525, 1.2504, &
1.2482, 1.2459, 1.2435, 1.2409, 1.2382, 1.2337, 1.2270, 1.2232, 1.2169, 1.2135, 1.2097, 1.2071, &
1.2043, 1.1983, 1.1776, 1.1507, 1.1083, 1.0657, 1.0453, 1.0236, 1.0001, 0.9747, 0.9563, 0.9538, &
0.9678, 0.9873, 1.0026, 1.0180, 1.0390/)
!
REAL, DIMENSION(NPNBANDS_REF), SAVE:: XPREFICE_I=(/9.565E-011, 3.249E-011, 2.0E-011  , 2.0E-011, &
2.0E-011  , 2.0E-011  , 2.0E-011  , 2.0E-011  , 2.365E-011, 2.669E-011, 3.135E-011, 4.140E-011, &
6.268E-011, 9.239E-011, 1.325E-010, 1.956E-010, 2.861E-010, 4.172E-010, 5.889E-010, 8.036E-010, &
1.076E-009, 1.409E-009, 1.813E-009, 2.289E-009, 2.839E-009, 3.461E-009, 4.159E-009, 4.930E-009, &
5.730E-009, 6.890E-009, 8.580E-009, 1.040E-008, 1.220E-008, 1.430E-008, 1.660E-008, 1.890E-008, &
2.090E-008, 2.400E-008, 2.900E-008, 3.440E-008, 4.030E-008, 4.300E-008, 4.920E-008, 5.870E-008, &
7.080E-008, 8.580E-008, 1.020E-007, 1.180E-007, 1.340E-007, 1.400E-007, 1.430E-007, 1.450E-007, &
1.510E-007, 1.830E-007, 2.150E-007, 2.650E-007, 3.350E-007, 3.920E-007, 4.200E-007, 4.440E-007, &
4.740E-007, 5.110E-007, 5.530E-007, 6.020E-007, 7.550E-007, 9.260E-007, 1.120E-006, 1.330E-006, &
1.620E-006, 2.000E-006, 2.250E-006, 2.330E-006, 2.330E-006, 2.170E-006, 1.960E-006, 1.810E-006, &
1.740E-006, 1.730E-006, 1.700E-006, 1.760E-006, 1.820E-006, 2.040E-006, 2.250E-006, 2.290E-006, &
3.040E-006, 3.840E-006, 4.770E-006, 5.760E-006, 6.710E-006, 8.660E-006, 1.020E-005, 1.130E-005, &
1.220E-005, 1.290E-005, 1.320E-005, 1.350E-005, 1.330E-005, 1.320E-005, 1.320E-005, 1.310E-005, &
1.320E-005, 1.320E-005, 1.340E-005, 1.390E-005, 1.420E-005, 1.480E-005, 1.580E-005, 1.740E-005, &
1.980E-005, 3.442E-005, 5.959E-005, 1.028E-004, 1.516E-004, 2.030E-004, 2.942E-004, 3.987E-004, &
4.941E-004, 5.532E-004, 5.373E-004, 5.143E-004, 4.908E-004, 4.594E-004, 3.858E-004, 3.105E-004, &
2.659E-004, 2.361E-004, 2.046E-004, 1.875E-004, 1.650E-004, 1.522E-004, 1.411E-004, 1.302E-004, &
1.310E-004, 1.339E-004, 1.377E-004, 1.432E-004, 1.632E-004, 2.566E-004, 4.081E-004, 7.060E-004, &
1.108E-003, 1.442E-003, 1.614E-003, 1.640E-003, 1.566E-003, 1.458E-003, 1.267E-003, 1.023E-003, &
7.586E-004, 5.255E-004, 4.025E-004, 3.235E-004, 2.707E-004, 2.228E-004, 2.037E-004, 2.026E-004, &
2.035E-004, 2.078E-004, 2.171E-004, 2.538E-004, 3.138E-004, 3.858E-004, 4.591E-004, 5.187E-004, &
5.605E-004, 5.956E-004, 6.259E-004, 6.820E-004, 7.530E-004, 7.685E-004, 7.647E-004, 7.473E-004, &
7.392E-004, 7.437E-004, 7.543E-004, 8.059E-004, 1.367E-003, 3.508E-003, 1.346E-002, 3.245E-002, &
4.572E-002, 6.287E-002, 8.548E-002, 1.198E-001, 1.690E-001, 2.210E-001, 2.760E-001, 3.120E-001, &
3.470E-001, 3.880E-001, 4.380E-001/)
!
!Values from Kokha 2004 p. 61,69
REAL, PARAMETER :: XPSNOWG0 = 0.8961 ! asymmetry parameter of snow grains at nr=1.3 and at non absorbing wavelengths (no unit) (npoints,nlayer)
REAL, PARAMETER :: XPSNOWY0 = 0.728 ! Value of y of snow grains at nr=1.3 (no unit
REAL, PARAMETER :: XPSNOWW0 = 0.0611 ! Value of W of snow grains at nr=1.3 (no unit)
REAL, PARAMETER :: XPSNOWB0 = 1.225 ! absorption enhancement parameter of snow grains at nr=1.3 and at non absorbing wavelengths (no unit)
!
END MODULE MODD_CONST_TARTES
