!     ######################
      MODULE MODD_ALBEDO_RS14_PAR
!     ######################
!
!!****  *MOD_DALBEDO_RS14* - declaration of ISBA parameters
!!
!!    PURPOSE
!!    -------
!       The purpose of this declarative module is to specify  the 
!     parameters related to direct & diffuse albedo over open water 
!
!!
!!      
!!
!!    AUTHOR
!!    ------
!!	R. Séférian           * Meteo-France *
!!
!!    MODIFICATIONS
!!    -------------
!-------------------------------------------------------------------------------
!
!*       0.   DECLARATIONS
!             ------------
!
IMPLICIT NONE
!
! number of wavelength (200nm - 4000nm by 10nm apart)
INTEGER, PARAMETER   :: NNWL = 381                
!
! absorption coefficients for seawater et 440 nm
REAL, PARAMETER      :: XAW440 =  0.00635
!
! table of wavelength discretization (by 10nm apart)
REAL, PARAMETER, DIMENSION(NNWL)::  XAKWL= &
    (/ 200.0, 210.0, 220.0, 230.0, 240.0, 250.0, 260.0, 270.0, 280.0,  &
    290.0, 300.0, 310.0, 320.0, 330.0, 340.0, 350.0, 360.0, 370.0,            &
    380.0, 390.0, 400.0, 410.0, 420.0, 430.0, 440.0, 450.0, 460.0,            &
    470.0, 480.0, 490.0, 500.0, 510.0, 520.0, 530.0, 540.0, 550.0,            &
    560.0, 570.0, 580.0, 590.0, 600.0, 610.0, 620.0, 630.0, 640.0,            &
    650.0, 660.0, 670.0, 680.0, 690.0, 700.0, 710.0, 720.0, 730.0,            &
    740.0, 750.0, 760.0, 770.0, 780.0, 790.0, 800.0, 810.0, 820.0,            &
    830.0, 840.0, 850.0, 860.0, 870.0, 880.0, 890.0, 900.0, 910.0,            &
    920.0, 930.0, 940.0, 950.0, 960.0, 970.0, 980.0,  990.0, 1000.0, 1010.0,  &
    1020.0, 1030.0, 1040.0, 1050.0, 1060.0, 1070.0, 1080.0, 1090.0, 1100.0,   &
    1110.0, 1120.0, 1130.0, 1140.0, 1150.0, 1160.0, 1170.0, 1180.0, 1190.0,   &
    1200.0, 1210.0, 1220.0, 1230.0, 1240.0, 1250.0, 1260.0, 1270.0, 1280.0,   &
    1290.0, 1300.0, 1310.0, 1320.0, 1330.0, 1340.0, 1350.0, 1360.0, 1370.0,   &
    1380.0, 1390.0, 1400.0, 1410.0, 1420.0, 1430.0, 1440.0, 1450.0, 1460.0,   &
    1470.0, 1480.0, 1490.0, 1500.0, 1510.0, 1520.0, 1530.0, 1540.0, 1550.0,   &
    1560.0, 1570.0, 1580.0, 1590.0, 1600.0, 1610.0, 1620.0, 1630.0, 1640.0,   &
    1650.0, 1660.0, 1670.0, 1680.0, 1690.0, 1700.0, 1710.0, 1720.0, 1730.0,   &
    1740.0, 1750.0, 1760.0, 1770.0, 1780.0, 1790.0, 1800.0, 1810.0, 1820.0,   &
    1830.0, 1840.0, 1850.0, 1860.0, 1870.0, 1880.0, 1890.0, 1900.0, 1910.0,   &
1920.0, 1930.0, 1940.0, 1950.0, 1960.0, 1970.0, 1980.0, 1990.0, 2000.0, 2010.0,& 
2020.0, 2030.0, 2040.0, 2050.0, 2060.0, 2070.0, 2080.0, 2090.0, 2100.0, 2110.0,&
2120.0, 2130.0, 2140.0, 2150.0, 2160.0, 2170.0, 2180.0, 2190.0, 2200.0, 2210.0,&
2220.0, 2230.0, 2240.0, 2250.0, 2260.0, 2270.0, 2280.0, 2290.0, 2300.0, 2310.0,&
2320.0, 2330.0, 2340.0, 2350.0, 2360.0, 2370.0, 2380.0, 2390.0, 2400.0, 2410.0,&
2420.0, 2430.0, 2440.0, 2450.0, 2460.0, 2470.0, 2480.0, 2490.0, 2500.0, 2510.0,&
2520.0, 2530.0, 2540.0, 2550.0, 2560.0, 2570.0, 2580.0, 2590.0, 2600.0, 2610.0,&
2620.0, 2630.0, 2640.0, 2650.0, 2660.0, 2670.0, 2680.0, 2690.0, 2700.0, 2710.0,&
2720.0, 2730.0, 2740.0, 2750.0, 2760.0, 2770.0, 2780.0, 2790.0, 2800.0, 2810.0,&
2820.0, 2830.0, 2840.0, 2850.0, 2860.0, 2870.0, 2880.0, 2890.0, 2900.0, 2910.0,&
2920.0, 2930.0, 2940.0, 2950.0, 2960.0, 2970.0, 2980.0, 2990.0, 3000.0, 3010.0,&
3020.0, 3030.0, 3040.0, 3050.0, 3060.0, 3070.0, 3080.0, 3090.0, 3100.0, 3110.0,&
3120.0, 3130.0, 3140.0, 3150.0, 3160.0, 3170.0, 3180.0, 3190.0, 3200.0, 3210.0,&
3220.0, 3230.0, 3240.0, 3250.0, 3260.0, 3270.0, 3280.0, 3290.0, 3300.0, 3310.0,&
3320.0, 3330.0, 3340.0, 3350.0, 3360.0, 3370.0, 3380.0, 3390.0, 3400.0, 3410.0,&
3420.0, 3430.0, 3440.0, 3450.0, 3460.0, 3470.0, 3480.0, 3490.0, 3500.0, 3510.0,&
3520.0, 3530.0, 3540.0, 3550.0, 3560.0, 3570.0, 3580.0, 3590.0, 3600.0, 3610.0,&
3620.0, 3630.0, 3640.0, 3650.0, 3660.0, 3670.0, 3680.0, 3690.0, 3700.0, 3710.0,&
3720.0, 3730.0, 3740.0, 3750.0, 3760.0, 3770.0, 3780.0, 3790.0, 3800.0, 3810.0,&
3820.0, 3830.0, 3840.0, 3850.0, 3860.0, 3870.0, 3880.0, 3890.0, 3900.0, 3910.0,&
3920.0, 3930.0, 3940.0, 3950.0, 3960.0, 3970.0, 3980.0, 3990.0, 4000.0 /) 
!
! proportion of each wavelength
REAL, PARAMETER, DIMENSION(NNWL)::  XFRWL= &
(/0.5399519E-04, 0.2057802E-03, 0.3488387E-03, 0.3841427E-03, 0.2915711E-03, &
0.4429581E-03, 0.6302387E-03, 0.1970095E-02, 0.6974564E-03, 0.4431792E-02,   &
0.3095547E-02, 0.4587307E-02, 0.5933870E-02, 0.7488277E-02, 0.7421943E-02,   &
0.7738869E-02, 0.7155137E-02, 0.8394831E-02, 0.8859162E-02, 0.9190828E-02,   &
0.1239693E-01, 0.1129138E-01, 0.1294971E-01, 0.8365349E-02, 0.1262541E-01,&
0.1580203E-01, 0.1503552E-01, 0.1383415E-01, 0.1499867E-01, 0.1479230E-01,&
0.1368674E-01, 0.1435007E-01, 0.1349511E-01, 0.1438693E-01, 0.1303815E-01,&
0.1372359E-01, 0.1358356E-01, 0.1303815E-01, 0.1354671E-01, 0.1336245E-01,&
0.1286863E-01, 0.1255171E-01, 0.1278019E-01, 0.1208001E-01, 0.1189575E-01,&
0.1183678E-01, 0.1157882E-01, 0.1117345E-01, 0.1099656E-01, 0.1067227E-01,&
0.1021531E-01, 0.1020794E-01, 0.9809937E-02, 0.9773086E-02, 0.9271902E-02,&
0.9301383E-02, 0.9117125E-02, 0.8873903E-02, 0.8748608E-02, 0.8534866E-02,&
0.8416941E-02, 0.8210571E-02, 0.7959980E-02, 0.7834683E-02, 0.7665165E-02,&
0.7119759E-02, 0.7347503E-02, 0.7183881E-02, 0.7041634E-02, 0.7023945E-02,&
0.6749768E-02, 0.6571406E-02, 0.6565509E-02, 0.6395254E-02, 0.6219103E-02,&
0.6168247E-02, 0.6007574E-02, 0.5866062E-02, 0.5709074E-02, 0.5557982E-02,&
0.5512286E-02, 0.5389938E-02, 0.5189464E-02, 0.5112813E-02, 0.4983095E-02,&
0.4880646E-02, 0.4728080E-02, 0.4599837E-02, 0.4604259E-02, 0.4568881E-02,&
0.4453166E-02, 0.4352930E-02, 0.4231319E-02, 0.4166460E-02, 0.4075804E-02,&
0.4045586E-02, 0.3921027E-02, 0.3888597E-02, 0.3861327E-02, 0.3747823E-02,&
0.3687387E-02, 0.3598206E-02, 0.3593046E-02, 0.3531872E-02, 0.3429424E-02,&
0.3408050E-02, 0.3338769E-02, 0.3282018E-02, 0.3210525E-02, 0.3136085E-02,&
0.3085229E-02, 0.3026266E-02, 0.2959933E-02, 0.2858222E-02, 0.2793363E-02,&
0.2744719E-02, 0.2707130E-02, 0.2652589E-02, 0.2637849E-02, 0.2584045E-02,&
0.2525819E-02, 0.2519186E-02, 0.2474227E-02, 0.2400524E-02, 0.2349668E-02,&
0.2348931E-02, 0.2326083E-02, 0.2286283E-02, 0.2261224E-02, 0.2222161E-02,&
0.2219213E-02, 0.2172043E-02, 0.2112343E-02, 0.2037902E-02, 0.2012106E-02,&
0.1999576E-02, 0.1977465E-02, 0.1949458E-02, 0.1953143E-02, 0.1772569E-02,&
0.1851432E-02, 0.1768884E-02, 0.1746036E-02, 0.1763725E-02, 0.1667173E-02,&
0.1674544E-02, 0.1654644E-02, 0.1639903E-02, 0.1533033E-02, 0.1551459E-02,&
0.1520504E-02, 0.1483652E-02, 0.1468911E-02, 0.1462278E-02, 0.1404052E-02,&
0.1369411E-02, 0.1349511E-02, 0.1320030E-02, 0.1294234E-02, 0.1277282E-02,&
0.1252223E-02, 0.1242641E-02, 0.1176308E-02, 0.1183679E-02, 0.1151249E-02,&
0.1139456E-02, 0.1107764E-02, 0.1111449E-02, 0.1077545E-02, 0.1049538E-02,&
0.1029638E-02, 0.1015634E-02, 0.9824679E-03, 0.9677272E-03, 0.9574086E-03,&
0.9294013E-03, 0.9294013E-03, 0.9131865E-03, 0.8814940E-03, 0.8829681E-03,&
0.8623311E-03, 0.8468534E-03, 0.8225312E-03, 0.8004201E-03, 0.7945239E-03,&
0.7805202E-03, 0.7576721E-03, 0.7392463E-03, 0.7280433E-03, 0.7214100E-03,&
0.7079960E-03, 0.6925183E-03, 0.6836001E-03, 0.6787357E-03, 0.6694490E-03,&
0.6601624E-03, 0.6471906E-03, 0.6306809E-03, 0.6262587E-03, 0.6120340E-03,&
0.6091595E-03, 0.5955244E-03, 0.5894070E-03, 0.5771722E-03, 0.5630211E-03,&
0.5557982E-03, 0.5469538E-03, 0.5378146E-03, 0.5280857E-03, 0.5240319E-03,&
0.5124605E-03, 0.5063431E-03, 0.4988254E-03, 0.4876225E-03, 0.4805469E-03,&
0.4756088E-03, 0.4649218E-03, 0.4577725E-03, 0.4548981E-03, 0.4443585E-03,&
0.4380937E-03, 0.4349982E-03, 0.4252693E-03, 0.4209945E-03, 0.4156141E-03,&
0.4025686E-03, 0.4022001E-03, 0.3895231E-03, 0.3815631E-03, 0.3851009E-03,&
0.3799416E-03, 0.3736400E-03, 0.3673383E-03, 0.3610735E-03, 0.3548087E-03,&
0.3495758E-03, 0.3443428E-03, 0.3398469E-03, 0.3353510E-03, 0.3319237E-03,&
0.3284966E-03, 0.3228951E-03, 0.3172936E-03, 0.3138296E-03, 0.3103655E-03,&
0.3055011E-03, 0.3006366E-03, 0.2965461E-03, 0.2924555E-03, 0.2887335E-03,&
0.2850115E-03, 0.2811789E-03, 0.2773463E-03, 0.2736611E-03, 0.2699760E-03,&
0.2656643E-03, 0.2613527E-03, 0.2584782E-03, 0.2556038E-03, 0.2525451E-03,&
0.2494864E-03, 0.2462434E-03, 0.2430005E-03, 0.2397575E-03, 0.2365146E-03,&
0.2331979E-03, 0.2298813E-03, 0.2266752E-03, 0.2234690E-03, 0.2211474E-03,&
0.2188257E-03, 0.2159144E-03, 0.2130031E-03, 0.2103130E-03, 0.2076228E-03,&
0.2051537E-03, 0.2026847E-03, 0.2001787E-03, 0.1976728E-03, 0.1950932E-03,&
0.1925136E-03, 0.1901182E-03, 0.1877228E-03, 0.1847010E-03, 0.1816792E-03,&
0.1800945E-03, 0.1785099E-03, 0.1763725E-03, 0.1742351E-03, 0.1720977E-03,&
0.1699603E-03, 0.1677492E-03, 0.1655381E-03, 0.1637692E-03, 0.1620003E-03,&
0.1600103E-03, 0.1580203E-03, 0.1562514E-03, 0.1544826E-03, 0.1527137E-03,&
0.1509448E-03, 0.1491759E-03, 0.1474070E-03, 0.1456013E-03, 0.1437956E-03,&
0.1421741E-03, 0.1405526E-03, 0.1387469E-03, 0.1369411E-03, 0.1348774E-03,&
0.1328137E-03, 0.1315608E-03, 0.1303078E-03, 0.1291654E-03, 0.1280230E-03,&
0.1265489E-03, 0.1250749E-03, 0.1236745E-03, 0.1222741E-03, 0.1206526E-03,&
0.1190312E-03, 0.1178888E-03, 0.1167464E-03, 0.1156408E-03, 0.1145353E-03,&
0.1132823E-03, 0.1120294E-03, 0.1107764E-03, 0.1095234E-03, 0.1084179E-03,&
0.1073123E-03, 0.1061699E-03, 0.1050275E-03, 0.1038483E-03, 0.1026690E-03,&
0.1015266E-03, 0.1003842E-03, 0.9935234E-04, 0.9832049E-04, 0.9732549E-04,&
0.9633049E-04, 0.9537235E-04, 0.9441420E-04, 0.9330864E-04, 0.9220310E-04,&
0.9113440E-04, 0.9006570E-04, 0.8899700E-04, 0.8792829E-04, 0.8678589E-04,&
0.8564349E-04, 0.8501700E-04, 0.8439052E-04, 0.8302701E-04, 0.8166349E-04,&
0.8122127E-04, 0.8077905E-04, 0.8011572E-04, 0.7945239E-04, 0.7867850E-04,&
0.7790462E-04, 0.7720443E-04, 0.7650425E-04, 0.7580406E-04, 0.7510388E-04,&
0.7434105E-04, 0.7357822E-04, 0.7283750E-04, 0.7209678E-04, 0.7142239E-04,&
0.7074801E-04, 0.7011415E-04, 0.6948030E-04, 0.6876537E-04, 0.6805045E-04,&
0.6730973E-04, 0.6656901E-04, 0.6592411E-04, 0.6527920E-04, 0.6458639E-04,&
0.6389357E-04 /) 
!
! Table for computing Reflectance just below ocean surface (bounded to 200-800 nm)
! table of refractive index as function of wavelength
REAL, PARAMETER, DIMENSION(NNWL)::  XAKREFM= &
(/ 1.4517,  1.4345,  1.4214,  1.4108,  1.4022,  1.3950,  1.3889,  1.3836,      &
1.3790,  1.3750,  1.3714,  1.3682,  1.3653,  1.3627,  1.3604,  1.3582,  1.3562,&
1.3544,  1.3528,  1.3512,  1.3498,  1.3484,  1.3472,  1.3460,  1.3449,  1.3439,&
1.3429,  1.3420,  1.3411,  1.3402,  1.3394,  1.3387,  1.3379,  1.3372,  1.3366,&
1.3359,  1.3353,  1.3347,  1.3342,  1.3336,  1.3331,  1.3326,  1.3321,  1.3316,&
1.3311,  1.3307,  1.3303,  1.3299,  1.3295,  1.3291,  1.3288,  1.3284,  1.3281,&
1.3278,  1.3275,  1.3272,  1.3269,  1.3266,  1.3264,  1.3261,  1.3259,  1.3256,&
1.3254,  1.3252,  1.3249,  1.3247,  1.3245,  1.3243,  1.3241,  1.3238,  1.3236,&
1.3234,  1.3232,  1.3230,  1.3228,  1.3226,  1.3225,  1.3223,  1.3221,  1.3219,&
1.3217,  1.3215,  1.3213,  1.3211,  1.3210,  1.3208,  1.3206,  1.3204,  1.3202,&
1.3200,  1.3198,  1.3197,  1.3195,  1.3193,  1.3191,  1.3189,  1.3187,  1.3186,&
1.3184,  1.3182,  1.3180,  1.3178,  1.3176,  1.3174,  1.3172,  1.3170,  1.3169,&
1.3167,  1.3165,  1.3163,  1.3161,  1.3159,  1.3156,  1.3154,  1.3152,  1.3150,&
1.3148,  1.3146,  1.3143,  1.3141,  1.3139,  1.3137,  1.3135,  1.3134,  1.3132,&
1.3130,  1.3129,  1.3127,  1.3125,  1.3123,  1.3121,  1.3119,  1.3116,  1.3114,&
1.3111,  1.3109,  1.3106,  1.3104,  1.3101,  1.3099,  1.3096,  1.3094,  1.3091,&
1.3088,  1.3086,  1.3083,  1.3080,  1.3077,  1.3074,  1.3071,  1.3068,  1.3065,&
1.3061,  1.3058,  1.3055,  1.3051,  1.3048,  1.3044,  1.3041,  1.3037,  1.3034,&
1.3030,  1.3026,  1.3022,  1.3017,  1.3013,  1.3007,  1.3002,  1.2998,  1.2995,&
1.2990,  1.2988,  1.2988,  1.2987,  1.2986,  1.2985,  1.2983,  1.2980,  1.2977,&
1.2973,  1.2969,  1.2965,  1.2960,  1.2955,  1.2950,  1.2945,  1.2940,  1.2935,&
1.2929,  1.2924,  1.2918,  1.2913,  1.2907,  1.2901,  1.2895,  1.2889,  1.2883,&
1.2876,  1.2870,  1.2863,  1.2856,  1.2849,  1.2842,  1.2835,  1.2828,  1.2820,&
1.2812,  1.2804,  1.2796,  1.2788,  1.2779,  1.2770,  1.2761,  1.2751,  1.2741,&
1.2731,  1.2721,  1.2711,  1.2699,  1.2688,  1.2676,  1.2664,  1.2652,  1.2639,&
1.2625,  1.2612,  1.2597,  1.2582,  1.2567,  1.2552,  1.2535,  1.2518,  1.2499,&
1.2480,  1.2459,  1.2436,  1.2413,  1.2388,  1.2361,  1.2331,  1.2299,  1.2263,&
1.2223,  1.2182,  1.2140,  1.2091,  1.2034,  1.1973,  1.1910,  1.1850,  1.1780,&
1.1691,  1.1564,  1.1489,  1.1430,  1.1351,  1.1318,  1.1323,  1.1308,  1.1277,&
1.1294,  1.1286,  1.1255,  1.1271,  1.1348,  1.1417,  1.1480,  1.1612,  1.1736,&
1.1847,  1.2008,  1.2177,  1.2336,  1.2505,  1.2678,  1.2840,  1.3007,  1.3149,&
1.3281,  1.3407,  1.3539,  1.3661,  1.3782,  1.3903,  1.4024,  1.4136,  1.4217,&
1.4299,  1.4380,  1.4461,  1.4528,  1.4557,  1.4587,  1.4616,  1.4645,  1.4665,&
1.4655,  1.4645,  1.4634,  1.4624,  1.4613,  1.4589,  1.4566,  1.4543,  1.4519,&
1.4496,  1.4465,  1.4433,  1.4401,  1.4369,  1.4338,  1.4304,  1.4271,  1.4237,&
1.4203,  1.4170,  1.4144,  1.4117,  1.4091,  1.4065,  1.4041,  1.4020,  1.3999,&
1.3977,  1.3956,  1.3936,  1.3916,  1.3897,  1.3879,  1.3860,  1.3841,  1.3824,&
1.3808,  1.3791,  1.3774,  1.3758,  1.3743,  1.3729,  1.3714,  1.3700,  1.3685,&
1.3673,  1.3660,  1.3647,  1.3635,  1.3623,  1.3612,  1.3601,  1.3589,  1.3578,&
1.3568,  1.3558,  1.3548,  1.3538,  1.3528,  1.3519,  1.3510,  1.3501,  1.3493,&
1.3484,  1.3476,  1.3468,  1.3460,  1.3452,  1.3444,  1.3437,  1.3430,  1.3422,&
1.3415,  1.3408,  1.3401,  1.3395,  1.3388,  1.3382,  1.3375,  1.3369,  1.3363,&
1.3357,  1.3351,  1.3345,  1.3339 /)
!
! table of chlorophyll absorption coefficient as function of wavelength
REAL, PARAMETER, DIMENSION(NNWL)::  XAKACHL= &
(/0.4629505E+00, 0.4694205E+00, 0.4758904E+00, 0.4823604E+00, 0.4888304E+00,&
0.4953003E+00, 0.5017703E+00, 0.5082403E+00, 0.5147102E+00, 0.5211802E+00,&
0.5276502E+00, 0.5341201E+00, 0.5405901E+00, 0.5470601E+00, 0.5535300E+00,&
0.5600000E+00, 0.5700000E+00, 0.5900000E+00, 0.6100000E+00, 0.6600000E+00,&
0.6870000E+00, 0.8280000E+00, 0.9130000E+00, 0.9730000E+00, 0.1000000E+01,&
0.9440000E+00, 0.9170000E+00, 0.8700000E+00, 0.7980000E+00, 0.7500000E+00,&
0.6680000E+00, 0.6180000E+00, 0.5280000E+00, 0.4740000E+00, 0.4160000E+00,&
0.3570000E+00, 0.2940000E+00, 0.2760000E+00, 0.2910000E+00, 0.2820000E+00,&
0.2360000E+00, 0.2520000E+00, 0.2760000E+00, 0.3170000E+00, 0.3340000E+00,&
0.3560000E+00, 0.4410000E+00, 0.5950000E+00, 0.5020000E+00, 0.3290000E+00,&
0.2150000E+00, 0.2150000E+00, 0.2083276E+00, 0.2016552E+00, 0.1949828E+00,&
0.1883103E+00, 0.1816379E+00, 0.1749655E+00, 0.1682931E+00, 0.1616207E+00,&
0.1549483E+00, 0.1482759E+00, 0.1416035E+00, 0.1349310E+00, 0.1282586E+00,&
0.1215862E+00, 0.1149138E+00, 0.1082414E+00, 0.1015690E+00, 0.9489655E-01,&
0.8822414E-01, 0.8155172E-01, 0.7487931E-01, 0.6820690E-01, 0.6153448E-01,&
0.5486207E-01, 0.4818965E-01, 0.4151724E-01, 0.3484483E-01, 0.2817241E-01,&
0.2150000E-01, 0.2143550E-01, 0.2137100E-01, 0.2130650E-01, 0.2124200E-01,&
0.2117750E-01, 0.2111300E-01, 0.2104850E-01, 0.2098400E-01, 0.2091950E-01,&
0.2085500E-01, 0.2079050E-01, 0.2072600E-01, 0.2066150E-01, 0.2059700E-01,&
0.2053250E-01, 0.2046800E-01, 0.2040350E-01, 0.2033900E-01, 0.2027450E-01,&
0.2021000E-01, 0.2014550E-01, 0.2008100E-01, 0.2001650E-01, 0.1995200E-01,&
0.1988750E-01, 0.1982300E-01, 0.1975850E-01, 0.1969400E-01, 0.1962950E-01,&
0.1956500E-01, 0.1950050E-01, 0.1943600E-01, 0.1937150E-01, 0.1930700E-01,&
0.1924250E-01, 0.1917800E-01, 0.1911350E-01, 0.1904900E-01, 0.1898450E-01,&
0.1892000E-01, 0.1885550E-01, 0.1879100E-01, 0.1872650E-01, 0.1866200E-01,&
0.1859750E-01, 0.1853300E-01, 0.1846850E-01, 0.1840400E-01, 0.1833950E-01,&
0.1827500E-01, 0.1821050E-01, 0.1814600E-01, 0.1808150E-01, 0.1801700E-01,&
0.1795250E-01, 0.1788800E-01, 0.1782350E-01, 0.1775900E-01, 0.1769450E-01,&
0.1763000E-01, 0.1756550E-01, 0.1750100E-01, 0.1743650E-01, 0.1737200E-01,&
0.1730750E-01, 0.1724300E-01, 0.1717850E-01, 0.1711400E-01, 0.1704950E-01,&
0.1698500E-01, 0.1692050E-01, 0.1685600E-01, 0.1679150E-01, 0.1672700E-01,&
0.1666250E-01, 0.1659800E-01, 0.1653350E-01, 0.1646900E-01, 0.1640450E-01,&
0.1634000E-01, 0.1627550E-01, 0.1621100E-01, 0.1614650E-01, 0.1608200E-01,&
0.1601750E-01, 0.1595300E-01, 0.1588850E-01, 0.1582400E-01, 0.1575950E-01,&
0.1569500E-01, 0.1563050E-01, 0.1556600E-01, 0.1550150E-01, 0.1543700E-01,&
0.1537250E-01, 0.1530800E-01, 0.1524350E-01, 0.1517900E-01, 0.1511450E-01,&
0.1505000E-01, 0.1498550E-01, 0.1492100E-01, 0.1485650E-01, 0.1479200E-01,&
0.1472750E-01, 0.1466300E-01, 0.1459850E-01, 0.1453400E-01, 0.1446950E-01,&
0.1440500E-01, 0.1434050E-01, 0.1427600E-01, 0.1421150E-01, 0.1414700E-01,&
0.1408250E-01, 0.1401800E-01, 0.1395350E-01, 0.1388900E-01, 0.1382450E-01,&
0.1376000E-01, 0.1369550E-01, 0.1363100E-01, 0.1356650E-01, 0.1350200E-01,&
0.1343750E-01, 0.1337300E-01, 0.1330850E-01, 0.1324400E-01, 0.1317950E-01,&
0.1311500E-01, 0.1305050E-01, 0.1298600E-01, 0.1292150E-01, 0.1285700E-01,&
0.1279250E-01, 0.1272800E-01, 0.1266350E-01, 0.1259900E-01, 0.1253450E-01,&
0.1247000E-01, 0.1240550E-01, 0.1234100E-01, 0.1227650E-01, 0.1221200E-01,&
0.1214750E-01, 0.1208300E-01, 0.1201850E-01, 0.1195400E-01, 0.1188950E-01,&
0.1182500E-01, 0.1176050E-01, 0.1169600E-01, 0.1163150E-01, 0.1156700E-01,&
0.1150250E-01, 0.1143800E-01, 0.1137350E-01, 0.1130900E-01, 0.1124450E-01,&
0.1118000E-01, 0.1111550E-01, 0.1105100E-01, 0.1098650E-01, 0.1092200E-01,&
0.1085750E-01, 0.1079300E-01, 0.1072850E-01, 0.1066400E-01, 0.1059950E-01,&
0.1053500E-01, 0.1047050E-01, 0.1040600E-01, 0.1034150E-01, 0.1027700E-01,&
0.1021250E-01, 0.1014800E-01, 0.1008350E-01, 0.1001900E-01, 0.9954500E-02,&
0.9890000E-02, 0.9825500E-02, 0.9761000E-02, 0.9696500E-02, 0.9632000E-02,&
0.9567500E-02, 0.9503000E-02, 0.9438500E-02, 0.9374000E-02, 0.9309500E-02,&
0.9245000E-02, 0.9180500E-02, 0.9116000E-02, 0.9051500E-02, 0.8987000E-02,&
0.8922500E-02, 0.8858000E-02, 0.8793500E-02, 0.8729000E-02, 0.8664500E-02,&
0.8600000E-02, 0.8535500E-02, 0.8471000E-02, 0.8406500E-02, 0.8342000E-02,&
0.8277500E-02, 0.8213000E-02, 0.8148500E-02, 0.8084000E-02, 0.8019500E-02,&
0.7955000E-02, 0.7890500E-02, 0.7826000E-02, 0.7761500E-02, 0.7697000E-02,&
0.7632500E-02, 0.7568000E-02, 0.7503500E-02, 0.7439000E-02, 0.7374500E-02,&
0.7310000E-02, 0.7245500E-02, 0.7181000E-02, 0.7116500E-02, 0.7052000E-02,&
0.6987500E-02, 0.6923000E-02, 0.6858500E-02, 0.6794000E-02, 0.6729500E-02,&
0.6665000E-02, 0.6600500E-02, 0.6536000E-02, 0.6471500E-02, 0.6407000E-02,&
0.6342500E-02, 0.6278000E-02, 0.6213500E-02, 0.6149000E-02, 0.6084500E-02,&
0.6020000E-02, 0.5955500E-02, 0.5891000E-02, 0.5826500E-02, 0.5762000E-02,&
0.5697500E-02, 0.5633000E-02, 0.5568500E-02, 0.5504000E-02, 0.5439500E-02,&
0.5375000E-02, 0.5310500E-02, 0.5246000E-02, 0.5181500E-02, 0.5117000E-02,&
0.5052500E-02, 0.4988000E-02, 0.4923500E-02, 0.4859000E-02, 0.4794500E-02,&
0.4730000E-02, 0.4665500E-02, 0.4601000E-02, 0.4536500E-02, 0.4472000E-02,&
0.4407500E-02, 0.4343000E-02, 0.4278500E-02, 0.4214000E-02, 0.4149500E-02,&
0.4085000E-02, 0.4020500E-02, 0.3956000E-02, 0.3891500E-02, 0.3827000E-02,&
0.3762500E-02, 0.3698000E-02, 0.3633500E-02, 0.3569000E-02, 0.3504500E-02,&
0.3440000E-02, 0.3375500E-02, 0.3311000E-02, 0.3246500E-02, 0.3182000E-02,&
0.3117500E-02, 0.3053000E-02, 0.2988500E-02, 0.2924000E-02, 0.2859500E-02,&
0.2795000E-02, 0.2730500E-02, 0.2666000E-02, 0.2601500E-02, 0.2537000E-02,&
0.2472500E-02, 0.2408000E-02, 0.2343500E-02, 0.2279000E-02, 0.2214500E-02,&
0.2150000E-02 /)
!
REAL, PARAMETER, DIMENSION(NNWL)::  XAKACHL2= &
(/0.7745835E+00,  0.7522619E+00,  0.7299404E+00,  0.7076188E+00, 0.6852972E+00,&
0.6629756E+00,  0.5767828E+00,  0.5011461E+00,  0.4285168E+00,  0.3946458E+00,&
0.4330427E+00,  0.5309876E+00,  0.6371105E+00,  0.7297136E+00,  0.7904093E+00,&
0.8097131E+00,  0.8760642E+00,  0.9381161E+00,  0.9457293E+00,  0.9258360E+00,&
0.9025422E+00,  0.9252829E+00,  0.9270173E+00,  0.9995731E+00,  0.8171211E+00,&
0.5353835E+00,  0.5329482E+00,  0.5348938E+00,  0.3804893E+00,  0.2089162E+00,&
0.1108572E+00,  0.7056972E-01,  0.6340462E-01,  0.7044097E-01,  0.8182860E-01,&
0.9896376E-01,  0.1267309E+00,  0.1598070E+00,  0.1993082E+00,  0.2502128E+00,&
0.3026099E+00,  0.3196909E+00,  0.2917686E+00,  0.2666667E+00,  0.3314760E+00,&
0.5711130E+00,  0.7452133E+00,  0.5497976E+00,  0.2406984E+00,  0.1315954E+00,&
0.1197734E+00,  0.1258391E+00,  0.1367452E+00,  0.1552781E+00,  0.1936057E+00,&
0.2571016E+00,  0.3363165E+00,  0.4064784E+00,  0.4289439E+00,  0.3819179E+00,&
0.2987019E+00,  0.2160145E+00,  0.1343931E+00,  0.6321464E-01,  0.2241001E-01,&
0.5134957E-02, -0.1242093E-02, -0.2531676E-02, -0.4085609E-02, -0.4713067E-02,&
-0.5693497E-02, -0.1090849E-01, -0.1407841E-01, -0.1816251E-01, -0.2587014E-01,&
-0.3565745E-01, -0.4546714E-01, -0.5446691E-01, -0.5650476E-01, -0.5981312E-01,&
-0.5981312E-01, -0.6451318E-01, -0.4835265E-01, -0.4864828E-01, -0.4876773E-01,&
-0.4840301E-01, -0.4866588E-01, -0.4836091E-01, -0.4851014E-01, -0.4860595E-01,&
-0.4852568E-01, -0.4805798E-01, -0.4859427E-01, -0.4795901E-01, -0.4846919E-01,&
-0.4850669E-01, -0.4854093E-01, -0.4849193E-01, -0.4841270E-01, -0.4855558E-01,&
-0.4827924E-01, -0.4906723E-01, -0.4822920E-01, -0.4818162E-01, -0.4854826E-01,&
-0.4875536E-01, -0.4863250E-01, -0.4843162E-01, -0.4836087E-01, -0.4913286E-01,&
-0.4884187E-01, -0.4864121E-01, -0.4865143E-01, -0.4821299E-01, -0.4880581E-01,&
-0.4887014E-01, -0.4868441E-01, -0.4861962E-01, -0.4806854E-01, -0.4918258E-01,&
-0.4813463E-01, -0.4876416E-01, -0.4831872E-01, -0.4867297E-01, -0.4862849E-01,&
-0.4836460E-01, -0.4858448E-01, -0.4886762E-01, -0.4875397E-01, -0.4863992E-01,&
-0.4862744E-01, -0.4887019E-01, -0.4816946E-01, -0.4892569E-01, -0.4864310E-01,&
-0.4881326E-01, -0.4819329E-01, -0.4852681E-01, -0.4803719E-01, -0.4831237E-01,&
-0.4866472E-01, -0.4815419E-01, -0.4873738E-01, -0.4851730E-01, -0.4848577E-01,&
-0.4881878E-01, -0.4878175E-01, -0.4839409E-01, -0.4850954E-01, -0.4846783E-01,&
-0.4847389E-01, -0.4833271E-01, -0.4859281E-01, -0.4863393E-01, -0.4839972E-01,&
-0.4851298E-01, -0.4831513E-01, -0.4842690E-01, -0.4784760E-01, -0.4914954E-01,&
-0.4866549E-01, -0.4890948E-01, -0.4834954E-01, -0.4830681E-01, -0.4859897E-01,&
-0.4838582E-01, -0.4851704E-01, -0.4866422E-01, -0.4881537E-01, -0.4851842E-01,&
-0.4877209E-01, -0.4873482E-01, -0.4825956E-01, -0.4852063E-01, -0.4867407E-01,&
-0.4878135E-01, -0.4830102E-01, -0.4826979E-01, -0.4870005E-01, -0.4902764E-01,&
-0.4871316E-01, -0.4853799E-01, -0.4867663E-01, -0.4823785E-01, -0.4855946E-01,&
-0.4875993E-01, -0.4846177E-01, -0.4886679E-01, -0.4859700E-01, -0.4809872E-01,&
-0.4822881E-01, -0.4837712E-01, -0.4855768E-01, -0.4867230E-01, -0.4838317E-01,&
-0.4876311E-01, -0.4812689E-01, -0.4820772E-01, -0.4904227E-01, -0.4871970E-01,&
-0.4853304E-01, -0.4859587E-01, -0.4845879E-01, -0.4837155E-01, -0.4874718E-01,&
-0.4873789E-01, -0.4851343E-01, -0.4851316E-01, -0.4901856E-01, -0.4836449E-01,&
-0.4880954E-01, -0.4853077E-01, -0.4898909E-01, -0.4812662E-01, -0.4832583E-01,&
-0.4847423E-01, -0.4846226E-01, -0.4844360E-01, -0.4835512E-01, -0.4893025E-01,&
-0.4853777E-01, -0.4873621E-01, -0.4832436E-01, -0.4854396E-01, -0.4848187E-01,&
-0.4850079E-01, -0.4843526E-01, -0.4818938E-01, -0.4874043E-01, -0.4847353E-01,&
-0.4865320E-01, -0.4853667E-01, -0.4859223E-01, -0.4872705E-01, -0.4821515E-01,&
-0.4844453E-01, -0.4870005E-01, -0.4881809E-01, -0.4865348E-01, -0.4871232E-01,&
-0.4859998E-01, -0.4833980E-01, -0.4860161E-01, -0.4839900E-01, -0.4853466E-01,&
-0.4864573E-01, -0.4863669E-01, -0.4901951E-01, -0.4832310E-01, -0.4890333E-01,&
-0.4880714E-01, -0.4855986E-01, -0.4852934E-01, -0.4818182E-01, -0.4795438E-01,&
-0.4834752E-01, -0.4810626E-01, -0.4861891E-01, -0.4872801E-01, -0.4814039E-01,&
-0.4894429E-01, -0.4881275E-01, -0.4903332E-01, -0.4835438E-01, -0.4865217E-01,&
-0.4853667E-01, -0.4841790E-01, -0.4869760E-01, -0.4900452E-01, -0.4856053E-01,&
-0.4825166E-01, -0.4837719E-01, -0.4872088E-01, -0.4873605E-01, -0.4868101E-01,&
-0.4883375E-01, -0.4870022E-01, -0.4875332E-01, -0.4836111E-01, -0.4863061E-01,&
-0.4875719E-01, -0.4874192E-01, -0.4847357E-01, -0.4867528E-01, -0.4836407E-01,&
-0.4828474E-01, -0.4860063E-01, -0.4861546E-01, -0.4864795E-01, -0.4844943E-01,&
-0.4904242E-01, -0.4843469E-01, -0.4866992E-01, -0.4900254E-01, -0.4864337E-01,&
-0.4844130E-01, -0.4837940E-01, -0.4855977E-01, -0.4874923E-01, -0.4906257E-01,&
-0.4864537E-01, -0.4834532E-01, -0.4869347E-01, -0.4858449E-01, -0.4877963E-01,&
-0.4863986E-01, -0.4848931E-01, -0.4836552E-01, -0.4849740E-01, -0.4887220E-01,&
-0.4904565E-01, -0.4872388E-01, -0.4810480E-01, -0.4806256E-01, -0.4874242E-01,&
-0.4819115E-01, -0.4862189E-01, -0.4871701E-01, -0.4839065E-01, -0.4877597E-01,&
-0.4905847E-01, -0.4861049E-01, -0.4812144E-01, -0.4872767E-01, -0.4891870E-01,&
-0.4890406E-01, -0.4818467E-01, -0.4847043E-01, -0.4841457E-01, -0.4821321E-01,&
-0.4847127E-01, -0.4868549E-01, -0.4910397E-01, -0.4863713E-01, -0.4831791E-01,&
-0.4807175E-01, -0.4877013E-01, -0.4882632E-01, -0.4808306E-01, -0.4848078E-01,&
-0.4849469E-01, -0.4864521E-01, -0.4823979E-01, -0.4866831E-01, -0.4870176E-01,&
-0.4837111E-01, -0.4899544E-01, -0.4904284E-01, -0.4913362E-01, -0.4821655E-01,&
-0.4833322E-01, -0.4831560E-01, -0.4840073E-01, -0.4852060E-01, -0.4897843E-01,&
-0.4829322E-01, -0.4884781E-01, -0.4827255E-01, -0.4827960E-01, -0.4864042E-01,&
-0.4828514E-01, -0.4897902E-01, -0.4855954E-01, -0.4855975E-01, -0.4858216E-01,&
-0.4827806E-01, -0.4847189E-01, -0.4860275E-01, -0.4906456E-01, -0.4853636E-01,&
-0.4862808E-01, -0.4848551E-01, -0.4869109E-01, -0.4848604E-01, -0.4866388E-01,&
-0.4846765E-01, -0.4875867E-01, -0.4807435E-01, -0.4867530E-01, -0.4888080E-01,&
-0.4844930E-01 /)
!
! table of seawater absorption coefficient as function of wavelength
REAL, PARAMETER, DIMENSION(NNWL)::  XAKAW3= &
(/0.3067439E+01, 0.1993737E+01, 0.1309263E+01, 0.9275307E+00, 0.7183294E+00,&
0.5608010E+00, 0.4552411E+00, 0.3738498E+00, 0.2879400E+00, 0.2145172E+00,&
0.1415658E+00, 0.1048958E+00, 0.8411996E-01, 0.6814662E-01, 0.5585442E-01,&
0.4638546E-01, 0.3791143E-01, 0.2984669E-01, 0.2234093E-01, 0.1870175E-01,&
0.1737227E-01, 0.1609624E-01, 0.1530537E-01, 0.1443961E-01, 0.1437088E-01,&
0.1480803E-01, 0.1517563E-01, 0.1592806E-01, 0.1743279E-01, 0.1967369E-01,&
0.2564243E-01, 0.3598580E-01, 0.4703195E-01, 0.5145027E-01, 0.5534469E-01,&
0.6400512E-01, 0.7030880E-01, 0.8172981E-01, 0.1033439E+00, 0.1638825E+00,&
0.2387544E+00, 0.2908335E+00, 0.3086321E+00, 0.3193000E+00, 0.3277702E+00,&
0.3523264E+00, 0.3957919E+00, 0.4326377E+00, 0.4485145E+00, 0.5016078E+00,&
0.6481431E+00, 0.8408502E+00, 0.1165249E+01, 0.1810640E+01, 0.2364421E+01,&
0.2479177E+01, 0.2547112E+01, 0.2511108E+01, 0.2356959E+01, 0.2164139E+01,&
0.2068389E+01, 0.2334173E+01, 0.3101571E+01, 0.3715746E+01, 0.4069374E+01,&
0.4055130E+01, 0.3662220E+01, 0.3265983E+01, 0.3338288E+01, 0.4351006E+01,&
0.6776006E+01, 0.1092508E+02, 0.1646968E+02, 0.2292120E+02, 0.2979101E+02,&
0.3659049E+02, 0.4255537E+02, 0.4581877E+02, 0.4488433E+02, 0.4084045E+02,&
0.3542173E+02, 0.3008784E+02, 0.2519888E+02, 0.2084002E+02, 0.1709645E+02,&
0.1405336E+02, 0.1179592E+02, 0.1051821E+02, 0.1084989E+02, 0.1352949E+02,&
0.1929556E+02, 0.2856379E+02, 0.4045844E+02, 0.5378094E+02, 0.6733270E+02,&
0.7991512E+02, 0.9045451E+02, 0.9837671E+02, 0.1032324E+03, 0.1045724E+03,&
0.1024582E+03, 0.9870555E+02, 0.9448188E+02, 0.9066481E+02, 0.8813195E+02,&
0.8776093E+02, 0.9009315E+02, 0.9432506E+02, 0.9931691E+02, 0.1039289E+03,&
0.1070213E+03, 0.1091415E+03, 0.1175854E+03, 0.1413362E+03, 0.1893769E+03,&
0.2706907E+03, 0.3927593E+03, 0.5570592E+03, 0.7635654E+03, 0.1012253E+04,&
0.1303097E+04, 0.1629710E+04, 0.1960254E+04, 0.2256530E+04, 0.2480335E+04,&
0.2593472E+04, 0.2570322E+04, 0.2435603E+04, 0.2226617E+04, 0.1980665E+04,&
0.1735048E+04, 0.1520186E+04, 0.1338970E+04, 0.1187410E+04, 0.1061517E+04,&
0.9572996E+03, 0.8707689E+03, 0.7979346E+03, 0.7348066E+03, 0.6773950E+03,&
0.6217097E+03, 0.5658621E+03, 0.5163686E+03, 0.4818471E+03, 0.4709154E+03,&
0.4921914E+03, 0.5339673E+03, 0.5283995E+03, 0.4879842E+03, 0.4503842E+03,&
0.4532622E+03, 0.5219655E+03, 0.6325787E+03, 0.7488713E+03, 0.8346125E+03,&
0.8535717E+03, 0.7823218E+03, 0.6486514E+03, 0.4931527E+03, 0.3564180E+03,&
0.2790396E+03, 0.2973530E+03, 0.4306661E+03, 0.6940303E+03, 0.1102497E+04,&
0.1671116E+04, 0.2414941E+04, 0.3349021E+04, 0.4488408E+04, 0.5848154E+04,&
0.7443309E+04, 0.9216590E+04, 0.1082137E+05, 0.1183869E+05, 0.1184960E+05,&
0.1078493E+05, 0.9686200E+04, 0.8790378E+04, 0.8045845E+04, 0.7400985E+04,&
0.6804181E+04, 0.6214741E+04, 0.5635665E+04, 0.5080881E+04, 0.4564313E+04,&
0.4099888E+04, 0.3697940E+04, 0.3354440E+04, 0.3061767E+04, 0.2812299E+04,&
0.2598416E+04, 0.2413350E+04, 0.2253741E+04, 0.2117085E+04, 0.2000874E+04,&
0.1902603E+04, 0.1819767E+04, 0.1749858E+04, 0.1690372E+04, 0.1638801E+04,&
0.1592640E+04, 0.1555394E+04, 0.1548293E+04, 0.1573317E+04, 0.1626133E+04,&
0.1702405E+04, 0.1797857E+04, 0.1908438E+04, 0.2030156E+04, 0.2159016E+04,&
0.2291026E+04, 0.2423482E+04, 0.2558843E+04, 0.2700856E+04, 0.2853272E+04,&
0.3019837E+04, 0.3204129E+04, 0.3409039E+04, 0.3637285E+04, 0.3891587E+04,&
0.4174664E+04, 0.4489235E+04, 0.4838020E+04, 0.5223737E+04, 0.5649106E+04,&
0.6116846E+04, 0.6622627E+04, 0.7133928E+04, 0.7611180E+04, 0.8014812E+04,&
0.8305254E+04, 0.8466704E+04, 0.8578431E+04, 0.8743467E+04, 0.9064849E+04,&
0.9645611E+04, 0.1051240E+05, 0.1138630E+05, 0.1191200E+05, 0.1173420E+05,&
0.1049759E+05, 0.8305364E+04, 0.7094721E+04, 0.9142031E+04, 0.1397930E+05,&
0.1839416E+05, 0.1986234E+05, 0.1908920E+05, 0.1758752E+05, 0.1687005E+05,&
0.1844957E+05, 0.2383885E+05, 0.3455066E+05, 0.5209777E+05, 0.7799295E+05,&
0.1137490E+06, 0.1602886E+06, 0.2161751E+06, 0.2793814E+06, 0.3478807E+06,&
0.4196461E+06, 0.4928405E+06, 0.5663854E+06, 0.6393920E+06, 0.7109715E+06,&
0.7802351E+06, 0.8462941E+06, 0.9082596E+06, 0.9652429E+06, 0.1016355E+07,&
0.1060708E+07, 0.1097549E+07, 0.1126679E+07, 0.1148035E+07, 0.1161554E+07,&
0.1167173E+07, 0.1164996E+07, 0.1155796E+07, 0.1140514E+07, 0.1120088E+07,&
0.1095461E+07, 0.1067479E+07, 0.1036628E+07, 0.1003298E+07, 0.9678839E+06,&
0.9307769E+06, 0.8923695E+06, 0.8530543E+06, 0.8132238E+06, 0.7732703E+06,&
0.7335864E+06, 0.6945089E+06, 0.6561521E+06, 0.6185746E+06, 0.5818354E+06,&
0.5459929E+06, 0.5111060E+06, 0.4772333E+06, 0.4444336E+06, 0.4127655E+06,&
0.3822878E+06, 0.3530592E+06, 0.3251383E+06, 0.2985839E+06, 0.2734547E+06,&
0.2498094E+06, 0.2277067E+06, 0.2072053E+06, 0.1883639E+06, 0.1712413E+06,&
0.1558960E+06, 0.1423474E+06, 0.1304565E+06, 0.1200447E+06, 0.1109338E+06,&
0.1029451E+06, 0.9590033E+05, 0.8962092E+05, 0.8392845E+05, 0.7864446E+05,&
0.7359050E+05, 0.6862405E+05, 0.6374646E+05, 0.5899502E+05, 0.5440700E+05,&
0.5001969E+05, 0.4587039E+05, 0.4199638E+05, 0.3843495E+05, 0.3522339E+05,&
0.3239897E+05, 0.2998538E+05, 0.2795181E+05, 0.2625384E+05, 0.2484704E+05,&
0.2368700E+05, 0.2272929E+05, 0.2192950E+05, 0.2124319E+05, 0.2062596E+05,&
0.2003338E+05, 0.1942931E+05, 0.1881074E+05, 0.1818297E+05, 0.1755126E+05,&
0.1692090E+05, 0.1629717E+05, 0.1568535E+05, 0.1509072E+05, 0.1451856E+05,&
0.1397415E+05, 0.1346277E+05, 0.1298970E+05, 0.1256022E+05, 0.1217961E+05,&
0.1185315E+05, 0.1158473E+05, 0.1137272E+05, 0.1121409E+05, 0.1110580E+05,&
0.1104483E+05, 0.1102816E+05, 0.1105274E+05, 0.1111556E+05, 0.1121359E+05,&
0.1134380E+05, 0.1150316E+05, 0.1168864E+05, 0.1189722E+05, 0.1212586E+05,&
0.1237155E+05, 0.1263124E+05, 0.1290192E+05, 0.1318056E+05, 0.1346412E+05,&
0.1374958E+05, 0.1403392E+05, 0.1431409E+05, 0.1458709E+05, 0.1484987E+05,&
0.1509941E+05 /)
!
! table of seawater backscattering coefficient as function of wavelength
REAL, PARAMETER, DIMENSION(NNWL)::  XAKBW= &
(/0.1510000E+00, 0.1190000E+00, 0.9950015E-01, 0.8199944E-01, 0.6850207E-01,&
0.5749506E-01, 0.4850663E-01, 0.4149505E-01, 0.3530210E-01, 0.3049935E-01,&
0.2620052E-01, 0.2289856E-01, 0.2000336E-01, 0.1749553E-01, 0.1530325E-01,&
0.1339897E-01, 0.1199900E-01, 0.1060502E-01, 0.9387780E-02, 0.8416411E-02,&
0.7587748E-02, 0.6805146E-02, 0.6098530E-02, 0.5500733E-02, 0.4898538E-02,&
0.4503288E-02, 0.4095613E-02, 0.3703303E-02, 0.3398477E-02, 0.3100964E-02,&
0.2897666E-02, 0.2608371E-02, 0.2380034E-02, 0.2226757E-02, 0.2080041E-02,&
0.1908345E-02, 0.1797763E-02, 0.1700603E-02, 0.1599833E-02, 0.1500036E-02,&
0.1400066E-02, 0.1299673E-02, 0.1201250E-02, 0.1095326E-02, 0.1017446E-02,&
0.9582712E-03, 0.8559384E-03, 0.7582711E-03, 0.7174466E-03, 0.6953252E-03,&
0.7012525E-03, 0.6996646E-03, 0.6000893E-03, 0.5999768E-03, 0.6000058E-03,&
0.4999986E-03, 0.5000004E-03, 0.4999999E-03, 0.4000000E-03, 0.4000000E-03,&
0.4000000E-03, 0.4000000E-03, 0.3987586E-03, 0.3975172E-03, 0.3962759E-03,&
0.3950345E-03, 0.3937931E-03, 0.3925517E-03, 0.3913103E-03, 0.3900690E-03,&
0.3888276E-03, 0.3875862E-03, 0.3863448E-03, 0.3851035E-03, 0.3838621E-03,&
0.3826207E-03, 0.3813793E-03, 0.3801379E-03, 0.3788965E-03, 0.3776552E-03,&
0.3764138E-03, 0.3751724E-03, 0.3739310E-03, 0.3726897E-03, 0.3714483E-03,&
0.3702069E-03, 0.3689655E-03, 0.3677241E-03, 0.3664828E-03, 0.3652414E-03,&
0.3640000E-03, 0.3627586E-03, 0.3615172E-03, 0.3602759E-03, 0.3590345E-03,&
0.3577931E-03, 0.3565517E-03, 0.3553103E-03, 0.3540690E-03, 0.3528276E-03,&
0.3515862E-03, 0.3503448E-03, 0.3491034E-03, 0.3478621E-03, 0.3466207E-03,&
0.3453793E-03, 0.3441379E-03, 0.3428966E-03, 0.3416552E-03, 0.3404138E-03,&
0.3391724E-03, 0.3379310E-03, 0.3366896E-03, 0.3354483E-03, 0.3342069E-03,&
0.3329655E-03, 0.3317241E-03, 0.3304828E-03, 0.3292414E-03, 0.3280000E-03,&
0.3267586E-03, 0.3255172E-03, 0.3242759E-03, 0.3230345E-03, 0.3217931E-03,&
0.3205517E-03, 0.3193103E-03, 0.3180690E-03, 0.3168276E-03, 0.3155862E-03,&
0.3143448E-03, 0.3131035E-03, 0.3118621E-03, 0.3106207E-03, 0.3093793E-03,&
0.3081379E-03, 0.3068965E-03, 0.3056552E-03, 0.3044138E-03, 0.3031724E-03,&
0.3019310E-03, 0.3006897E-03, 0.2994483E-03, 0.2982069E-03, 0.2969655E-03,&
0.2957241E-03, 0.2944828E-03, 0.2932414E-03, 0.2920000E-03, 0.2907586E-03,&
0.2895173E-03, 0.2882759E-03, 0.2870345E-03, 0.2857931E-03, 0.2845517E-03,&
0.2833103E-03, 0.2820690E-03, 0.2808276E-03, 0.2795862E-03, 0.2783448E-03,&
0.2771034E-03, 0.2758621E-03, 0.2746207E-03, 0.2733793E-03, 0.2721379E-03,&
0.2708966E-03, 0.2696552E-03, 0.2684138E-03, 0.2671724E-03, 0.2659310E-03,&
0.2646896E-03, 0.2634483E-03, 0.2622069E-03, 0.2609655E-03, 0.2597241E-03,&
0.2584828E-03, 0.2572414E-03, 0.2560000E-03, 0.2547586E-03, 0.2535172E-03,&
0.2522759E-03, 0.2510345E-03, 0.2497931E-03, 0.2485517E-03, 0.2473104E-03,&
0.2460690E-03, 0.2448276E-03, 0.2435862E-03, 0.2423448E-03, 0.2411035E-03,&
0.2398621E-03, 0.2386207E-03, 0.2373793E-03, 0.2361379E-03, 0.2348965E-03,&
0.2336552E-03, 0.2324138E-03, 0.2311724E-03, 0.2299310E-03, 0.2286896E-03,&
0.2274483E-03, 0.2262069E-03, 0.2249655E-03, 0.2237241E-03, 0.2224828E-03,&
0.2212414E-03, 0.2200000E-03, 0.2187586E-03, 0.2175172E-03, 0.2162759E-03,&
0.2150345E-03, 0.2137931E-03, 0.2125517E-03, 0.2113103E-03, 0.2100690E-03,&
0.2088276E-03, 0.2075862E-03, 0.2063448E-03, 0.2051035E-03, 0.2038621E-03,&
0.2026207E-03, 0.2013793E-03, 0.2001379E-03, 0.1988966E-03, 0.1976552E-03,&
0.1964138E-03, 0.1951724E-03, 0.1939310E-03, 0.1926897E-03, 0.1914483E-03,&
0.1902069E-03, 0.1889655E-03, 0.1877241E-03, 0.1864828E-03, 0.1852414E-03,&
0.1840000E-03, 0.1827586E-03, 0.1815172E-03, 0.1802759E-03, 0.1790345E-03,&
0.1777931E-03, 0.1765517E-03, 0.1753103E-03, 0.1740690E-03, 0.1728276E-03,&
0.1715862E-03, 0.1703448E-03, 0.1691034E-03, 0.1678621E-03, 0.1666207E-03,&
0.1653793E-03, 0.1641379E-03, 0.1628966E-03, 0.1616552E-03, 0.1604138E-03,&
0.1591724E-03, 0.1579310E-03, 0.1566897E-03, 0.1554483E-03, 0.1542069E-03,&
0.1529655E-03, 0.1517241E-03, 0.1504828E-03, 0.1492414E-03, 0.1480000E-03,&
0.1467586E-03, 0.1455172E-03, 0.1442759E-03, 0.1430345E-03, 0.1417931E-03,&
0.1405517E-03, 0.1393103E-03, 0.1380690E-03, 0.1368276E-03, 0.1355862E-03,&
0.1343448E-03, 0.1331034E-03, 0.1318621E-03, 0.1306207E-03, 0.1293793E-03,&
0.1281379E-03, 0.1268966E-03, 0.1256552E-03, 0.1244138E-03, 0.1231724E-03,&
0.1219310E-03, 0.1206897E-03, 0.1194483E-03, 0.1182069E-03, 0.1169655E-03,&
0.1157241E-03, 0.1144828E-03, 0.1132414E-03, 0.1120000E-03, 0.1107586E-03,&
0.1095172E-03, 0.1082759E-03, 0.1070345E-03, 0.1057931E-03, 0.1045517E-03,&
0.1033103E-03, 0.1020690E-03, 0.1008276E-03, 0.9958621E-04, 0.9834483E-04,&
0.9710345E-04, 0.9586207E-04, 0.9462069E-04, 0.9337931E-04, 0.9213793E-04,&
0.9089655E-04, 0.8965517E-04, 0.8841379E-04, 0.8717241E-04, 0.8593103E-04,&
0.8468966E-04, 0.8344828E-04, 0.8220690E-04, 0.8096552E-04, 0.7972414E-04,&
0.7848276E-04, 0.7724138E-04, 0.7600000E-04, 0.7475862E-04, 0.7351724E-04,&
0.7227586E-04, 0.7103448E-04, 0.6979310E-04, 0.6855172E-04, 0.6731034E-04,&
0.6606896E-04, 0.6482759E-04, 0.6358621E-04, 0.6234483E-04, 0.6110345E-04,&
0.5986207E-04, 0.5862069E-04, 0.5737931E-04, 0.5613793E-04, 0.5489655E-04,&
0.5365517E-04, 0.5241379E-04, 0.5117241E-04, 0.4993103E-04, 0.4868966E-04,&
0.4744828E-04, 0.4620690E-04, 0.4496552E-04, 0.4372414E-04, 0.4248276E-04,&
0.4124138E-04, 0.4000000E-04, 0.3875862E-04, 0.3751724E-04, 0.3627586E-04,&
0.3503448E-04, 0.3379311E-04, 0.3255172E-04, 0.3131034E-04, 0.3006897E-04,&
0.2882759E-04, 0.2758621E-04, 0.2634483E-04, 0.2510345E-04, 0.2386207E-04,&
0.2262069E-04, 0.2137931E-04, 0.2013793E-04, 0.1889655E-04, 0.1765517E-04,&
0.1641379E-04, 0.1517241E-04, 0.1393103E-04, 0.1268965E-04, 0.1144828E-04,&
0.1020690E-04, 0.8965517E-05, 0.7724138E-05, 0.6482759E-05, 0.5241379E-05,&
0.4000000E-05 /)

! white-caps reflectance (Koepke and Whitlock)
! Whitlock fit varid 400nm - 2.4nm. set whitecap's albedo 0 otherwise 
REAL, PARAMETER, DIMENSION(NNWL)::  XRWC   = &
(/0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00,&
0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00,&
0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00,&
0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00,&
0.1986623E+00, 0.1968392E+00, 0.1955961E+00, 0.1941208E+00, 0.1939980E+00,&
0.1947642E+00, 0.1953830E+00, 0.1965826E+00, 0.1987437E+00, 0.2014820E+00,&
0.2068586E+00, 0.2125197E+00, 0.2160829E+00, 0.2171109E+00, 0.2178881E+00,&
0.2192886E+00, 0.2200949E+00, 0.2212391E+00, 0.2227055E+00, 0.2247944E+00,&
0.2262073E+00, 0.2270383E+00, 0.2273185E+00, 0.2274869E+00, 0.2276210E+00,&
0.2280129E+00, 0.2287211E+00, 0.2293381E+00, 0.2296089E+00, 0.2305354E+00,&
0.2332379E+00, 0.2370188E+00, 0.2373674E+00, 0.2314480E+00, 0.2291741E+00,&
0.2288465E+00, 0.2286684E+00, 0.2287614E+00, 0.2291967E+00, 0.2298426E+00,&
0.2302154E+00, 0.2292666E+00, 0.2275362E+00, 0.2266957E+00, 0.2263213E+00,&
0.2263353E+00, 0.2267580E+00, 0.2272800E+00, 0.2271755E+00, 0.2260595E+00,&
0.2243821E+00, 0.2219912E+00, 0.2188027E+00, 0.2151597E+00, 0.2114653E+00,&
0.2080255E+00, 0.2051811E+00, 0.2036894E+00, 0.2041120E+00, 0.2059829E+00,&
0.2086015E+00, 0.2113106E+00, 0.2139111E+00, 0.2163195E+00, 0.2184435E+00,&
0.2201926E+00, 0.2214916E+00, 0.2222242E+00, 0.2220343E+00, 0.2204943E+00,&
0.2171906E+00, 0.2121093E+00, 0.2061633E+00, 0.2002262E+00, 0.1948388E+00,&
0.1903174E+00, 0.1868275E+00, 0.1843590E+00, 0.1829052E+00, 0.1825115E+00,&
0.1831341E+00, 0.1842591E+00, 0.1855570E+00, 0.1867604E+00, 0.1875755E+00,&
0.1876960E+00, 0.1869431E+00, 0.1856059E+00, 0.1840741E+00, 0.1827001E+00,&
0.1818000E+00, 0.1811922E+00, 0.1788437E+00, 0.1727826E+00, 0.1624180E+00,&
0.1487052E+00, 0.1334511E+00, 0.1185638E+00, 0.1049801E+00, 0.9298412E-01,&
0.8257660E-01, 0.7379698E-01, 0.6696978E-01, 0.6208307E-01, 0.5897739E-01,&
0.5756657E-01, 0.5784728E-01, 0.5956322E-01, 0.6253327E-01, 0.6660015E-01,&
0.7143353E-01, 0.7647427E-01, 0.8148541E-01, 0.8635699E-01, 0.9099500E-01,&
0.9533520E-01, 0.9935633E-01, 0.1030906E+00, 0.1066306E+00, 0.1101345E+00,&
0.1138333E+00, 0.1178890E+00, 0.1218228E+00, 0.1247853E+00, 0.1257652E+00,&
0.1238772E+00, 0.1203841E+00, 0.1208343E+00, 0.1242444E+00, 0.1276640E+00,&
0.1273930E+00, 0.1213602E+00, 0.1130860E+00, 0.1058152E+00, 0.1011666E+00,&
0.1002071E+00, 0.1039381E+00, 0.1120040E+00, 0.1237937E+00, 0.1375058E+00,&
0.1474928E+00, 0.1449352E+00, 0.1295643E+00, 0.1090889E+00, 0.8941860E-01,&
0.7284467E-01, 0.5983944E-01, 0.5022947E-01, 0.4366299E-01, 0.3977196E-01,&
0.3822227E-01, 0.3867308E-01, 0.4026759E-01, 0.4166813E-01, 0.4168444E-01,&
0.4022229E-01, 0.3904642E-01, 0.3841435E-01, 0.3817649E-01, 0.3823472E-01,&
0.3855810E-01, 0.3919018E-01, 0.4018588E-01, 0.4157600E-01, 0.4335490E-01,&
0.4545942E-01, 0.4776782E-01, 0.5018748E-01, 0.5264894E-01, 0.5509888E-01,&
0.5750712E-01, 0.5986086E-01, 0.6212466E-01, 0.6426051E-01, 0.6623940E-01,&
0.6804333E-01, 0.6966664E-01, 0.7111643E-01, 0.7241227E-01, 0.7358521E-01,&
0.7467659E-01, 0.7558735E-01, 0.7576417E-01, 0.7514564E-01, 0.7388073E-01,&
0.7214532E-01, 0.7011285E-01, 0.6793264E-01, 0.6572567E-01, 0.6358425E-01,&
0.6157472E-01, 0.5972482E-01, 0.5798797E-01, 0.5631501E-01, 0.5467161E-01,&
0.5303634E-01, 0.5140076E-01, 0.4977145E-01, 0.4816243E-01, 0.4659231E-01,&
0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00,&
0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00,&
0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00,&
0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00,&
0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00,&
0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00,&
0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00,&
0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00,&
0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00,&
0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00,&
0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00,&
0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00,&
0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00,&
0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00,&
0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00,&
0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00,&
0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00,&
0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00,&
0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00,&
0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00,&
0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00,&
0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00,&
0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00,&
0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00,&
0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00,&
0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00,&
0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00,&
0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00,&
0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00,&
0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00,&
0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00,&
0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00,&
0.0000000E+00 /)
!
!--------------------------------------------------------------------------------
!
END MODULE MODD_ALBEDO_RS14_PAR












