!     #########
SUBROUTINE MKFLAG_SNOW(TPSNOW)
!          ###################
!
!!****  *MKFLAG_SNOW* - puts undefined value on some snow quantities
!!                      where snow is not present
!!
!!    PURPOSE
!!    -------
!
!!**  METHOD
!!    ------
!!
!!    REFERENCE
!!    ---------
!!      
!!
!!    AUTHOR
!!    ------
!!     V. Masson 
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    01/2004
!!     A. Bogatchev 09/2005 EBA snow option
!!     B. Decharme  01/2009 Limit snow mass if Density=undef
!!     P. Samuelsson 10/2014 Additional snow albedos
!!------------------------------------------------------------------
!
USE MODD_TYPE_SNOW
USE MODD_SURF_PAR,   ONLY : XUNDEF
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
TYPE(SURF_SNOW)  :: TPSNOW ! snow state vector
!
INTEGER :: JLAYER
INTEGER :: JPATCH
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!--------------------------------------------------
!
IF (LHOOK) CALL DR_HOOK('MKFLAG_SNOW',0,ZHOOK_HANDLE)
IF (TPSNOW%SCHEME=='NON' .AND. LHOOK) CALL DR_HOOK('MKFLAG_SNOW',1,ZHOOK_HANDLE)
IF (TPSNOW%SCHEME=='NON') RETURN
!
DO JPATCH =1,SIZE(TPSNOW%WSNOW,3)
!
 IF (TPSNOW%SCHEME=='D95' .OR. TPSNOW%SCHEME=='EBA' .OR. TPSNOW%SCHEME=='1-L' .OR. TPSNOW%SCHEME=='3-L' &
          .OR. TPSNOW%SCHEME=='CRO') THEN  
  DO JLAYER=1,TPSNOW%NLAYER
    WHERE ( TPSNOW%RHO(:,1,JPATCH)== XUNDEF .AND. TPSNOW%WSNOW(:,JLAYER,JPATCH) > 0.0 .AND. TPSNOW%WSNOW(:,1,JPATCH)/= XUNDEF )
      TPSNOW%WSNOW(:,JLAYER,JPATCH) = 0.0
    END WHERE
  END DO
 END IF
! 
 IF (TPSNOW%SCHEME=='1-L') THEN
  DO JLAYER=1,TPSNOW%NLAYER
    WHERE ( TPSNOW%WSNOW(:,1,JPATCH)==0. .OR. TPSNOW%WSNOW(:,1,JPATCH)== XUNDEF )
      TPSNOW%T(:,JLAYER,JPATCH) = XUNDEF
    END WHERE
   END DO
 END IF
!
 IF (TPSNOW%SCHEME=='D95' .OR. TPSNOW%SCHEME=='EBA' .OR. TPSNOW%SCHEME=='1-L' .OR. TPSNOW%SCHEME=='3-L' &
           .OR. TPSNOW%SCHEME=='CRO') THEN  
  DO JLAYER=1,TPSNOW%NLAYER
    WHERE ( TPSNOW%WSNOW(:,1,JPATCH)==0. .OR. TPSNOW%WSNOW(:,1,JPATCH)== XUNDEF )
      TPSNOW%RHO(:,JLAYER,JPATCH) = XUNDEF
    END WHERE
  END DO
 END IF
!
 IF (TPSNOW%SCHEME=='3-L' .OR. TPSNOW%SCHEME=='CRO') THEN
  DO JLAYER=1,TPSNOW%NLAYER
    WHERE ( TPSNOW%WSNOW(:,1,JPATCH)==0. .OR. TPSNOW%WSNOW(:,1,JPATCH)== XUNDEF )
      TPSNOW%HEAT(:,JLAYER,JPATCH) = XUNDEF
      TPSNOW%AGE (:,JLAYER,JPATCH) = XUNDEF
     END WHERE
   END DO
 END IF
!
IF (TPSNOW%SCHEME=='CRO') THEN
  DO JLAYER=1,TPSNOW%NLAYER
    WHERE ( TPSNOW%WSNOW(:,1,JPATCH)==0. .OR. TPSNOW%WSNOW(:,1,JPATCH)== XUNDEF )
      TPSNOW%GRAN1(:,JLAYER,JPATCH) = XUNDEF
      TPSNOW%GRAN2(:,JLAYER,JPATCH) = XUNDEF
      TPSNOW%HIST(:,JLAYER,JPATCH) = XUNDEF
     END WHERE
   END DO
 END IF
!
 IF (TPSNOW%SCHEME=='D95' .OR. TPSNOW%SCHEME=='EBA' .OR. TPSNOW%SCHEME=='1-L' .OR. TPSNOW%SCHEME=='3-L' &
          .OR. TPSNOW%SCHEME=='CRO') THEN  
   WHERE ( TPSNOW%WSNOW(:,1,JPATCH)==0. .OR. TPSNOW%WSNOW(:,1,JPATCH)== XUNDEF )
    TPSNOW%ALB(:,JPATCH) = XUNDEF
    TPSNOW%ALBVIS(:,JPATCH) = XUNDEF
    TPSNOW%ALBNIR(:,JPATCH) = XUNDEF
    TPSNOW%ALBFIR(:,JPATCH) = XUNDEF
   END WHERE
 END IF
!
 IF (TPSNOW%SCHEME=='1-L') THEN
   WHERE ( TPSNOW%WSNOW(:,1,JPATCH)==0. .OR. TPSNOW%WSNOW(:,1,JPATCH)== XUNDEF )
    TPSNOW%EMIS(:,JPATCH) = XUNDEF
   END WHERE
 END IF
!
 IF (TPSNOW%SCHEME=='1-L') THEN
   WHERE ( TPSNOW%WSNOW(:,1,JPATCH)==0. .OR. TPSNOW%WSNOW(:,1,JPATCH)== XUNDEF )
    TPSNOW%TS(:,JPATCH) = XUNDEF
   END WHERE
 END IF

END DO
IF (LHOOK) CALL DR_HOOK('MKFLAG_SNOW',1,ZHOOK_HANDLE)
!
!--------------------------------------------------
!
END SUBROUTINE MKFLAG_SNOW
