!     #########
      SUBROUTINE INIT_ISBA_MIXPAR (DTCO, DTI, IG, I, &
                                   HISBA,KDECADE,KDECADE2,PCOVER,OCOVER,HPHOTO,HSFTYPE)
!     ##############################################################
!
!!**** *INIT_ISBA_MIXPAR* 
!!
!!    PURPOSE
!!    -------
!!   This routine makes pre-calculations relative to dependances between
!!    parameters. 
!! 
!!    METHOD
!!    ------
!!   First are treated parameters varying in time. Then, other ones. 
!!   * XPAR_VEGTYPE is needed as soon as 1 LDATA_ is true to use av_pgd_param. 
!!   * XPAR_LAI is needed as soon as av_pgd_param is called with YLAI
!!   * XPAR_VEG is needed as soon as av_pgd_param is called with YVEG
!!   * XPAR_H_TREE is needed as soon as Z0 is calculated by ini_data_param by point
!!
!!    EXTERNAL
!!    --------
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!    AUTHOR
!!    ------
!!
!!    S. Faroux        Meteo-France
!!
!!    MODIFICATION
!!    ------------
!!
!!    Original    16/11/10
!!    P. Samuelsson  10/2014  MEB
!!
!----------------------------------------------------------------------------
!
!*    0.     DECLARATION
!            -----------
!
!
USE MODD_DATA_COVER_n, ONLY : DATA_COVER_t
USE MODD_DATA_ISBA_n, ONLY : DATA_ISBA_t
USE MODD_ISBA_GRID_n, ONLY : ISBA_GRID_t
USE MODD_ISBA_n, ONLY : ISBA_t
!
USE MODD_SURF_PAR,       ONLY : XUNDEF
USE MODD_DATA_COVER_PAR, ONLY : NVEGTYPE
!
!
USE MODD_DATA_COVER,     ONLY : XDATA_LAI, XDATA_H_TREE, XDATA_VEG,         &
                                XDATA_IRRIG, XDATA_WATSUP
!     
USE MODI_INI_DATA_PARAM
USE MODI_AV_PGD
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*    0.1    Declaration of arguments
!            ------------------------
!
!
TYPE(DATA_COVER_t), INTENT(INOUT) :: DTCO
TYPE(DATA_ISBA_t), INTENT(INOUT) :: DTI
TYPE(ISBA_GRID_t), INTENT(INOUT) :: IG
TYPE(ISBA_t), INTENT(INOUT) :: I
!
CHARACTER(LEN=*), INTENT(IN)          :: HISBA 
INTEGER,                INTENT(IN)    :: KDECADE
INTEGER,                INTENT(OUT)   :: KDECADE2
REAL, DIMENSION(:,:),   INTENT(IN)    :: PCOVER
LOGICAL, DIMENSION(:),  INTENT(IN)    :: OCOVER
CHARACTER(LEN=*),       INTENT(IN)    :: HPHOTO  ! type of photosynthesis
CHARACTER(LEN=*),       INTENT(IN)    :: HSFTYPE ! nature / garden
!
!
!*    0.2    Declaration of local variables
!            ------------------------------
!
REAL, DIMENSION(19)   :: XSTRESS   ! 1. if defensive /0. if offensive
REAL, DIMENSION(19)   :: XSTRESS_NOAGRI   ! 1. if defensive /0. if offensive
!
CHARACTER(LEN=3)  :: YTREE, YNAT, YVEG
!
INTEGER               :: JVEGTYPE
!
INTEGER               :: ISIZE_LMEB_PATCH  ! Number of patches with MEB=true
!
!*    0.3    Declaration of namelists
!            ------------------------
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
DATA XSTRESS        /1.,1.,1.,0.,1.,0.,1.,0.,1.,0.,0.,0.,0.,0.,1.,0.,1.,0.,0./
DATA XSTRESS_NOAGRI /1.,1.,1.,0.,1.,0.,0.,0.,0.,0.,0.,0.,0.,0.,1.,0.,1.,0.,0./
!-------------------------------------------------------------------------------
!
!*    1.      Initializations
!             ---------------
!
IF (LHOOK) CALL DR_HOOK('INIT_ISBA_MIXPAR',0,ZHOOK_HANDLE)
!
ISIZE_LMEB_PATCH=COUNT(I%LMEB_PATCH(:))
!
IF (.NOT.DTI%LDATA_MIXPAR) THEN
  IF (LHOOK) CALL DR_HOOK('INIT_ISBA_MIXPAR',1,ZHOOK_HANDLE)
  RETURN
ENDIF
!
IF (HSFTYPE=='NAT') THEN
  YNAT='NAT'
  YTREE='TRE'
  YVEG='VEG'
ELSEIF (HSFTYPE=='GRD') THEN
  YNAT='GRD'
  YTREE='GRT'
  YVEG='GRV'
ENDIF
!
KDECADE2 = KDECADE
IF (DTI%NTIME==2) KDECADE2 = KDECADE2 + 10 
KDECADE2 = (KDECADE2-1) * DTI%NTIME / 36 + 1
IF (DTI%NTIME==2 .AND. KDECADE2==3) KDECADE2 = 1
!
!          1. Arrays needed further
!          ------------------------
!
!XPAR_VEGTYPE will be needed to use ini_data_param by point
IF (.NOT.DTI%LDATA_VEGTYPE) THEN
  ALLOCATE(DTI%XPAR_VEGTYPE   (IG%NDIM,NVEGTYPE))
  DO JVEGTYPE=1,NVEGTYPE
    CALL AV_PGD(DTCO, &
                 DTI%XPAR_VEGTYPE(:,JVEGTYPE),PCOVER ,DTCO%XDATA_VEGTYPE(:,JVEGTYPE),YNAT,'ARI',OCOVER)
  END DO
ENDIF
!
!xpar_lai: needed for av_pgd_param with YLAI
IF (.NOT.DTI%LDATA_LAI) THEN
  ALLOCATE(DTI%XPAR_LAI(IG%NDIM,DTI%NTIME,NVEGTYPE))
  CALL AV_PGD(DTCO, &
                 DTI%XPAR_LAI(:,KDECADE2,:),PCOVER,XDATA_LAI(:,KDECADE,:),YVEG,'ARI',OCOVER,KDECADE=KDECADE2)
ENDIF
!veg
IF (.NOT.DTI%LDATA_VEG) THEN
  ALLOCATE(DTI%XPAR_VEG(IG%NDIM,DTI%NTIME,NVEGTYPE))
  IF (DTI%LDATA_LAI) THEN
    CALL INI_DATA_PARAM(DTI%XPAR_VEGTYPE,OAGRI_TO_GRASS=I%LAGRI_TO_GRASS,PLAI=DTI%XPAR_LAI,PVEG_OUT=DTI%XPAR_VEG)
    DTI%LDATA_VEG=.TRUE.
  ELSE
    CALL AV_PGD(DTCO, &
                 DTI%XPAR_VEG(:,KDECADE2,:),PCOVER,XDATA_VEG(:,KDECADE,:),YNAT,'ARI',OCOVER,KDECADE=KDECADE2)
  ENDIF
ENDIF
!ht: needed to calculate z0, if not calculated yet during extrapolation 
IF (.NOT.DTI%LDATA_H_TREE .AND. .NOT.DTI%LDATA_Z0 .AND. DTI%LDATA_LAI) THEN
  ALLOCATE(DTI%XPAR_H_TREE(IG%NDIM,NVEGTYPE))
  CALL AV_PGD(DTCO, &
                 DTI%XPAR_H_TREE,PCOVER,XDATA_H_TREE,YTREE,'ARI',OCOVER,KDECADE=KDECADE2)
  DTI%LDATA_H_TREE = .TRUE.
ENDIF
!
!dg: initialization for ROOTFRAC
!ROOTFRAC depends on ROOT_DEPTH, DG, ROOT_EXT, ROOT_LIN
IF (.NOT.DTI%LDATA_ROOTFRAC .AND. HISBA=='DIF' .AND. DTI%LDATA_ROOT_DEPTH) THEN
  !
  IF (.NOT.DTI%LDATA_ROOT_EXTINCTION) THEN
    ALLOCATE(DTI%XPAR_ROOT_EXTINCTION(IG%NDIM,NVEGTYPE))
    CALL INI_DATA_PARAM(DTI%XPAR_VEGTYPE,OAGRI_TO_GRASS=I%LAGRI_TO_GRASS,PROOT_EXTINCTION=DTI%XPAR_ROOT_EXTINCTION)
    DTI%LDATA_ROOT_EXTINCTION = .TRUE.
  ENDIF
  !
  IF (.NOT.DTI%LDATA_ROOT_LIN) THEN
    ALLOCATE(DTI%XPAR_ROOT_LIN(IG%NDIM,NVEGTYPE))
    CALL INI_DATA_PARAM(DTI%XPAR_VEGTYPE,OAGRI_TO_GRASS=I%LAGRI_TO_GRASS,PROOT_LIN=DTI%XPAR_ROOT_LIN)
    DTI%LDATA_ROOT_LIN = .TRUE.
  ENDIF
  !
ENDIF
!
! MEB roots
IF (.NOT.DTI%LDATA_ROOTFRACGV .AND. HISBA=='DIF' .AND. DTI%LDATA_ROOT_DEPTHGV) THEN
  !
  IF (.NOT.DTI%LDATA_ROOT_EXTINCTIONGV) THEN
    ALLOCATE(DTI%XPAR_ROOT_EXTINCTIONGV(IG%NDIM,NVEGTYPE))
    CALL INI_DATA_PARAM(DTI%XPAR_VEGTYPE,PROOT_EXTINCTIONGV=DTI%XPAR_ROOT_EXTINCTIONGV)
    DTI%LDATA_ROOT_EXTINCTIONGV = .TRUE.
  ENDIF
  !
ENDIF
!
!dice: depth of the soil column for the calculation of the frozen soil fraction (m)
IF (DTI%LDATA_DG .AND. .NOT.DTI%LDATA_DICE) THEN
  !
  ALLOCATE(DTI%XPAR_DICE(IG%NDIM,NVEGTYPE))
  !
  IF(HISBA/='DIF')THEN
    DTI%XPAR_DICE(:,:)=MAX(0.2,0.8*DTI%XPAR_DG(:,2,:))
    DTI%LDATA_DICE=.TRUE.
  ENDIF
!
ENDIF
!
!          2. Calculations of parameters dependant on others
!          -------------------------------------------------
!
!emis
IF (.NOT.DTI%LDATA_EMIS .AND. DTI%LDATA_VEG) THEN
  ALLOCATE(DTI%XPAR_EMIS(IG%NDIM,DTI%NTIME,NVEGTYPE))
  CALL INI_DATA_PARAM(DTI%XPAR_VEGTYPE,OAGRI_TO_GRASS=I%LAGRI_TO_GRASS,PVEG_IN=DTI%XPAR_VEG,PEMIS_ECO=DTI%XPAR_EMIS)
  DTI%LDATA_EMIS=.TRUE.
ENDIF
!z0
IF (.NOT.DTI%LDATA_Z0 .AND. (DTI%LDATA_LAI .OR.DTI%LDATA_H_TREE)) THEN
  ALLOCATE(DTI%XPAR_Z0(IG%NDIM,DTI%NTIME,NVEGTYPE))
  CALL INI_DATA_PARAM(DTI%XPAR_VEGTYPE,OAGRI_TO_GRASS=I%LAGRI_TO_GRASS,PLAI=DTI%XPAR_LAI,PH_TREE=DTI%XPAR_H_TREE,PZ0=DTI%XPAR_Z0)
  DTI%LDATA_Z0=.TRUE.
ENDIF

!RSMIN
IF (DTI%LDATA_LAI) THEN
  IF (.NOT.DTI%LDATA_RSMIN) THEN
    ALLOCATE(DTI%XPAR_RSMIN(IG%NDIM,NVEGTYPE))
    CALL INI_DATA_PARAM(DTI%XPAR_VEGTYPE,OAGRI_TO_GRASS=I%LAGRI_TO_GRASS,PRSMIN=DTI%XPAR_RSMIN)
  ENDIF
  DTI%LDATA_RSMIN=.TRUE.
ENDIF

!parameters calculated on veg fraction
IF (DTI%LDATA_VEG) THEN
  !
  IF (.NOT.DTI%LDATA_GAMMA) ALLOCATE(DTI%XPAR_GAMMA     (IG%NDIM,NVEGTYPE))
  IF (.NOT.DTI%LDATA_WRMAX_CF) ALLOCATE(DTI%XPAR_WRMAX_CF  (IG%NDIM,NVEGTYPE))
  IF (.NOT.DTI%LDATA_RGL) ALLOCATE(DTI%XPAR_RGL       (IG%NDIM,NVEGTYPE))
  IF (.NOT.DTI%LDATA_CV) ALLOCATE(DTI%XPAR_CV        (IG%NDIM,NVEGTYPE))
  IF (.NOT.DTI%LDATA_ALBNIR_VEG) ALLOCATE(DTI%XPAR_ALBNIR_VEG(IG%NDIM,NVEGTYPE))
  IF (.NOT.DTI%LDATA_ALBVIS_VEG) ALLOCATE(DTI%XPAR_ALBVIS_VEG(IG%NDIM,NVEGTYPE))
  IF (.NOT.DTI%LDATA_ALBUV_VEG) ALLOCATE(DTI%XPAR_ALBUV_VEG (IG%NDIM,NVEGTYPE))
  IF (.NOT.DTI%LDATA_GMES) ALLOCATE(DTI%XPAR_GMES      (IG%NDIM,NVEGTYPE))
  IF (.NOT.DTI%LDATA_BSLAI) ALLOCATE(DTI%XPAR_BSLAI     (IG%NDIM,NVEGTYPE))
  IF (.NOT.DTI%LDATA_SEFOLD) ALLOCATE(DTI%XPAR_SEFOLD    (IG%NDIM,NVEGTYPE))
  IF (.NOT.DTI%LDATA_GC) ALLOCATE(DTI%XPAR_GC        (IG%NDIM,NVEGTYPE))
  IF (.NOT.DTI%LDATA_LAIMIN) ALLOCATE(DTI%XPAR_LAIMIN    (IG%NDIM,NVEGTYPE))
  IF (.NOT.DTI%LDATA_F2I) ALLOCATE(DTI%XPAR_F2I       (IG%NDIM,NVEGTYPE))
  IF (.NOT.DTI%LDATA_CE_NITRO) ALLOCATE(DTI%XPAR_CE_NITRO  (IG%NDIM,NVEGTYPE))
  IF (.NOT.DTI%LDATA_CF_NITRO) ALLOCATE(DTI%XPAR_CF_NITRO  (IG%NDIM,NVEGTYPE))
  IF (.NOT.DTI%LDATA_CNA_NITRO) ALLOCATE(DTI%XPAR_CNA_NITRO (IG%NDIM,NVEGTYPE))
  !
  IF (.NOT.DTI%LDATA_GAMMA) CALL INI_DATA_PARAM(DTI%XPAR_VEGTYPE,OAGRI_TO_GRASS=I%LAGRI_TO_GRASS,PGAMMA=DTI%XPAR_GAMMA)
  IF (.NOT.DTI%LDATA_WRMAX_CF) CALL INI_DATA_PARAM(DTI%XPAR_VEGTYPE,OAGRI_TO_GRASS=I%LAGRI_TO_GRASS,PWRMAX_CF=DTI%XPAR_WRMAX_CF)
  IF (.NOT.DTI%LDATA_RGL) CALL INI_DATA_PARAM(DTI%XPAR_VEGTYPE,OAGRI_TO_GRASS=I%LAGRI_TO_GRASS,PRGL=DTI%XPAR_RGL)
  IF (.NOT.DTI%LDATA_CV) CALL INI_DATA_PARAM(DTI%XPAR_VEGTYPE,OAGRI_TO_GRASS=I%LAGRI_TO_GRASS,PCV=DTI%XPAR_CV)
  IF (.NOT.DTI%LDATA_ALBNIR_VEG) &
     CALL INI_DATA_PARAM(DTI%XPAR_VEGTYPE,OAGRI_TO_GRASS=I%LAGRI_TO_GRASS,PALBNIR_VEG=DTI%XPAR_ALBNIR_VEG)
  IF (.NOT.DTI%LDATA_ALBVIS_VEG) &
     CALL INI_DATA_PARAM(DTI%XPAR_VEGTYPE,OAGRI_TO_GRASS=I%LAGRI_TO_GRASS,PALBVIS_VEG=DTI%XPAR_ALBVIS_VEG)
  IF (.NOT.DTI%LDATA_ALBUV_VEG) CALL INI_DATA_PARAM(DTI%XPAR_VEGTYPE,OAGRI_TO_GRASS=I%LAGRI_TO_GRASS,PALBUV_VEG=DTI%XPAR_ALBUV_VEG)
  IF (ISIZE_LMEB_PATCH>0)  THEN
    IF (.NOT.DTI%LDATA_BSLAI) CALL INI_DATA_PARAM(DTI%XPAR_VEGTYPE,PBSLAI=DTI%XPAR_BSLAI)
  ENDIF
  IF (HPHOTO == 'AST' .OR. HPHOTO == 'LST' .OR. HPHOTO == 'NIT' .OR. HPHOTO=='NCB')  THEN
    IF (.NOT.DTI%LDATA_GMES) CALL INI_DATA_PARAM(DTI%XPAR_VEGTYPE,OAGRI_TO_GRASS=I%LAGRI_TO_GRASS,PGMES_ST=DTI%XPAR_GMES)
    IF (.NOT.DTI%LDATA_BSLAI) CALL INI_DATA_PARAM(DTI%XPAR_VEGTYPE,OAGRI_TO_GRASS=I%LAGRI_TO_GRASS,PBSLAI_ST=DTI%XPAR_BSLAI)
    IF (.NOT.DTI%LDATA_SEFOLD) CALL INI_DATA_PARAM(DTI%XPAR_VEGTYPE,OAGRI_TO_GRASS=I%LAGRI_TO_GRASS,PSEFOLD_ST=DTI%XPAR_SEFOLD)
    IF (.NOT.DTI%LDATA_GC) CALL INI_DATA_PARAM(DTI%XPAR_VEGTYPE,OAGRI_TO_GRASS=I%LAGRI_TO_GRASS,PGC_ST=DTI%XPAR_GC)
  ELSE
    IF (.NOT.DTI%LDATA_GMES) CALL INI_DATA_PARAM(DTI%XPAR_VEGTYPE,OAGRI_TO_GRASS=I%LAGRI_TO_GRASS,PGMES=DTI%XPAR_GMES)
    IF (.NOT.DTI%LDATA_BSLAI) CALL INI_DATA_PARAM(DTI%XPAR_VEGTYPE,OAGRI_TO_GRASS=I%LAGRI_TO_GRASS,PBSLAI=DTI%XPAR_BSLAI)
    IF (.NOT.DTI%LDATA_SEFOLD) CALL INI_DATA_PARAM(DTI%XPAR_VEGTYPE,OAGRI_TO_GRASS=I%LAGRI_TO_GRASS,PSEFOLD=DTI%XPAR_SEFOLD)
    IF (.NOT.DTI%LDATA_GC) CALL INI_DATA_PARAM(DTI%XPAR_VEGTYPE,OAGRI_TO_GRASS=I%LAGRI_TO_GRASS,PGC=DTI%XPAR_GC)
  ENDIF
  IF (.NOT.DTI%LDATA_LAIMIN) CALL INI_DATA_PARAM(DTI%XPAR_VEGTYPE,OAGRI_TO_GRASS=I%LAGRI_TO_GRASS,PLAIMIN_OUT=DTI%XPAR_LAIMIN)
  IF (.NOT.DTI%LDATA_F2I) CALL INI_DATA_PARAM(DTI%XPAR_VEGTYPE,OAGRI_TO_GRASS=I%LAGRI_TO_GRASS,PF2I=DTI%XPAR_F2I)
  IF (.NOT.DTI%LDATA_CE_NITRO) CALL INI_DATA_PARAM(DTI%XPAR_VEGTYPE,OAGRI_TO_GRASS=I%LAGRI_TO_GRASS,PCE_NITRO=DTI%XPAR_CE_NITRO)
  IF (.NOT.DTI%LDATA_CF_NITRO) CALL INI_DATA_PARAM(DTI%XPAR_VEGTYPE,OAGRI_TO_GRASS=I%LAGRI_TO_GRASS,PCF_NITRO=DTI%XPAR_CF_NITRO)
  IF (.NOT.DTI%LDATA_CNA_NITRO) CALL INI_DATA_PARAM(DTI%XPAR_VEGTYPE,OAGRI_TO_GRASS=I%LAGRI_TO_GRASS,PCNA_NITRO=DTI%XPAR_CNA_NITRO)
  !
  DTI%LDATA_GAMMA=.TRUE.
  DTI%LDATA_WRMAX_CF=.TRUE.
  DTI%LDATA_RGL=.TRUE.
  DTI%LDATA_CV=.TRUE.
  DTI%LDATA_ALBNIR_VEG=.TRUE.
  DTI%LDATA_ALBVIS_VEG=.TRUE.
  DTI%LDATA_ALBUV_VEG=.TRUE.
  DTI%LDATA_GMES=.TRUE.
  DTI%LDATA_BSLAI=.TRUE.
  DTI%LDATA_SEFOLD=.TRUE.
  DTI%LDATA_GC=.TRUE.
  DTI%LDATA_LAIMIN=.TRUE.
  DTI%LDATA_F2I=.TRUE.
  DTI%LDATA_CE_NITRO=.TRUE.
  DTI%LDATA_CF_NITRO=.TRUE.
  DTI%LDATA_CNA_NITRO=.TRUE.
  !
  DTI%LDATA_STRESS=.TRUE.
  !
  ALLOCATE(DTI%LPAR_STRESS   (IG%NDIM,NVEGTYPE))  
  DTI%LPAR_STRESS(:,:) = .TRUE.
  IF(I%LAGRI_TO_GRASS)THEN
    DO JVEGTYPE=1,NVEGTYPE
      IF(XSTRESS_NOAGRI(JVEGTYPE)<1.) DTI%LPAR_STRESS(:,JVEGTYPE) = .FALSE.
    ENDDO 
  ELSE
    DO JVEGTYPE=1,NVEGTYPE
      IF(XSTRESS(JVEGTYPE)<1.) DTI%LPAR_STRESS(:,JVEGTYPE) = .FALSE.
    ENDDO
  ENDIF
  !
  IF (.NOT.DTI%LDATA_IRRIG) THEN
    ALLOCATE(DTI%XPAR_IRRIG     (IG%NDIM,DTI%NTIME,NVEGTYPE))
    CALL AV_PGD(DTCO, &
                 DTI%XPAR_IRRIG(:,KDECADE2,:),PCOVER,XDATA_IRRIG(:,:),YVEG,'ARI',OCOVER,KDECADE=KDECADE2)
    DTI%LDATA_IRRIG=.TRUE.
  ENDIF
  !
  IF (.NOT.DTI%LDATA_WATSUP) THEN
    ALLOCATE(DTI%XPAR_WATSUP     (IG%NDIM,DTI%NTIME,NVEGTYPE))
    CALL AV_PGD(DTCO, &
                 DTI%XPAR_WATSUP(:,KDECADE2,:),PCOVER,XDATA_WATSUP(:,:),YVEG,'ARI',OCOVER,KDECADE=KDECADE2)
    DTI%LDATA_WATSUP=.TRUE.
  ENDIF
!
! MEB stuff
!
  IF (.NOT.DTI%LDATA_GAMMAGV) ALLOCATE(DTI%XPAR_GAMMAGV     (IG%NDIM,NVEGTYPE))
  IF (.NOT.DTI%LDATA_WRMAX_CFGV) ALLOCATE(DTI%XPAR_WRMAX_CFGV  (IG%NDIM,NVEGTYPE))
  IF (.NOT.DTI%LDATA_RGLGV) ALLOCATE(DTI%XPAR_RGLGV       (IG%NDIM,NVEGTYPE))
  IF (.NOT.DTI%LDATA_RSMINGV) ALLOCATE(DTI%XPAR_RSMINGV     (IG%NDIM,NVEGTYPE))
  !
  IF (.NOT.DTI%LDATA_GAMMAGV) CALL INI_DATA_PARAM(DTI%XPAR_VEGTYPE,PGAMMAGV=DTI%XPAR_GAMMAGV)
  IF (.NOT.DTI%LDATA_WRMAX_CFGV) CALL INI_DATA_PARAM(DTI%XPAR_VEGTYPE,PWRMAX_CFGV=DTI%XPAR_WRMAX_CFGV)
  IF (.NOT.DTI%LDATA_RGLGV) CALL INI_DATA_PARAM(DTI%XPAR_VEGTYPE,PRGLGV=DTI%XPAR_RGLGV)
  IF (.NOT.DTI%LDATA_RSMINGV) CALL INI_DATA_PARAM(DTI%XPAR_VEGTYPE,PRSMINGV=DTI%XPAR_RSMINGV)
  !
  DTI%LDATA_GAMMAGV=.TRUE.
  DTI%LDATA_WRMAX_CFGV=.TRUE.
  DTI%LDATA_RGLGV=.TRUE.
  DTI%LDATA_RSMINGV=.TRUE.
!
!LAIGV
  IF (.NOT.DTI%LDATA_LAIGV) THEN
    ALLOCATE(DTI%XPAR_LAIGV(IG%NDIM,DTI%NTIME,NVEGTYPE))
    CALL INI_DATA_PARAM(DTI%XPAR_VEGTYPE,PLAI=DTI%XPAR_LAI,PLAIMIN_IN=DTI%XPAR_LAIMIN,PLAIGV_OUT=DTI%XPAR_LAIGV)
    DTI%LDATA_LAIGV=.TRUE.
  ENDIF
!
!Z0LITTER
  IF (.NOT.DTI%LDATA_Z0LITTER) THEN
    ALLOCATE(DTI%XPAR_Z0LITTER(IG%NDIM,DTI%NTIME,NVEGTYPE))
    CALL INI_DATA_PARAM(DTI%XPAR_VEGTYPE,PLAI=DTI%XPAR_LAI,PLAIGV_IN=DTI%XPAR_LAIGV,  &
                        PZ0LITTER=DTI%XPAR_Z0LITTER)
    DTI%LDATA_Z0LITTER=.TRUE.
  ENDIF
!
!H_VEG
  IF (.NOT.DTI%LDATA_H_VEG .AND. DTI%LDATA_LAI .AND. DTI%LDATA_H_TREE) THEN
    ALLOCATE(DTI%XPAR_H_VEG(IG%NDIM,DTI%NTIME,NVEGTYPE))
    CALL INI_DATA_PARAM(DTI%XPAR_VEGTYPE,PH_VEG=DTI%XPAR_H_VEG,PLAI=DTI%XPAR_LAI,  &
                        PH_TREE=DTI%XPAR_H_TREE)
    DTI%LDATA_H_VEG=.TRUE.
  ENDIF
!
!GNDLITTER
  IF (.NOT.DTI%LDATA_GNDLITTER .AND. DTI%LDATA_LAIGV) THEN
    ALLOCATE(DTI%XPAR_GNDLITTER(IG%NDIM,DTI%NTIME,NVEGTYPE))
    CALL INI_DATA_PARAM(DTI%XPAR_VEGTYPE,PLAI=DTI%XPAR_LAI,PLAIGV_IN=DTI%XPAR_LAIGV, &
                        PGNDLITTER=DTI%XPAR_GNDLITTER)
    DTI%LDATA_GNDLITTER=.TRUE.
  ENDIF
  !
ENDIF
!
!
IF (DTI%LDATA_VEGTYPE) THEN
  IF (.NOT.DTI%LDATA_Z0_O_Z0H) ALLOCATE(DTI%XPAR_Z0_O_Z0H  (IG%NDIM,NVEGTYPE))
  IF (.NOT.DTI%LDATA_DMAX) ALLOCATE(DTI%XPAR_DMAX      (IG%NDIM,NVEGTYPE))
  IF (.NOT.DTI%LDATA_RE25) ALLOCATE(DTI%XPAR_RE25      (IG%NDIM,NVEGTYPE))
  IF (.NOT.DTI%LDATA_Z0_O_Z0H) CALL INI_DATA_PARAM(DTI%XPAR_VEGTYPE,OAGRI_TO_GRASS=I%LAGRI_TO_GRASS,PZ0_O_Z0H=DTI%XPAR_Z0_O_Z0H)
  IF (HPHOTO == 'AST' .OR. HPHOTO == 'LST' .OR. HPHOTO == 'NIT' .OR. HPHOTO=='NCB')  THEN
    IF (.NOT.DTI%LDATA_DMAX) CALL INI_DATA_PARAM(DTI%XPAR_VEGTYPE,OAGRI_TO_GRASS=I%LAGRI_TO_GRASS,PDMAX_ST=DTI%XPAR_DMAX)
  ELSE
    IF (.NOT.DTI%LDATA_DMAX) CALL INI_DATA_PARAM(DTI%XPAR_VEGTYPE,OAGRI_TO_GRASS=I%LAGRI_TO_GRASS,PDMAX=DTI%XPAR_DMAX)
  ENDIF
  IF (.NOT.DTI%LDATA_RE25) CALL INI_DATA_PARAM(DTI%XPAR_VEGTYPE,OAGRI_TO_GRASS=I%LAGRI_TO_GRASS,PRE25=DTI%XPAR_RE25)
  !
  DTI%LDATA_Z0_O_Z0H=.TRUE.
  DTI%LDATA_DMAX=.TRUE.
  DTI%LDATA_RE25=.TRUE.
ENDIF
!
IF (LHOOK) CALL DR_HOOK('INIT_ISBA_MIXPAR',1,ZHOOK_HANDLE)
!
!-------------------------------------------------------------------------------
!
END SUBROUTINE INIT_ISBA_MIXPAR
