MODULE MODI_GATHER_AND_WRITE_MPI_K4
!----------------------------------------------------
!!    MODIFICATIONS
!!    -------------
!!      Original       
!!      J.Escobar      10/06/2013: replace DOUBLE PRECISION by REAL to handle problem for promotion of real on IBM SP
!----------------------------------------------------
!
INTERFACE GATHER_AND_WRITE_MPI_K4
!
SUBROUTINE GATHER_AND_WRITE_MPI_X1D0(PWORK,PWORK2,KMASK)
!
REAL, DIMENSION(:), INTENT(IN) :: PWORK
REAL, DIMENSION(:), INTENT(OUT) :: PWORK2
!
INTEGER, DIMENSION(:), INTENT(IN), OPTIONAL :: KMASK
!
END SUBROUTINE GATHER_AND_WRITE_MPI_X1D0
!
SUBROUTINE GATHER_AND_WRITE_MPI_X2D0(PWORK,PWORK2,KMASK)
!
REAL, DIMENSION(:,:), INTENT(IN) :: PWORK
REAL, DIMENSION(:,:), INTENT(OUT) :: PWORK2
!
INTEGER, DIMENSION(:), INTENT(IN), OPTIONAL :: KMASK
!
END SUBROUTINE GATHER_AND_WRITE_MPI_X2D0
!
END INTERFACE
!
END MODULE MODI_GATHER_AND_WRITE_MPI_K4
!
!**************************************************************************
!
SUBROUTINE GATHER_AND_WRITE_MPI_X1D0(PWORK,PWORK2,KMASK)
!
USE MODD_SURFEX_MPI, ONLY : NINDEX, NPROC, NRANK, NCOMM, NPIO, NSIZE, &
                            XTIME_COMM_WRITE, XTIME_CALC_WRITE, &
                            XTIME_OMP_BARR, IDX_W, WLOG_MPI
USE MODD_SURFEX_OMP, ONLY : NINDX1SFX, NINDX2SFX, XWORK, XWORK_FULL
!
USE MODD_SURF_PAR, ONLY : XUNDEF
!
USE MODI_UNPACK_SAME_RANK
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
#ifdef SFX_MPI
INCLUDE "mpif.h"
#endif
!
REAL, DIMENSION(:), INTENT(IN) :: PWORK
REAL, DIMENSION(:), INTENT(OUT) :: PWORK2
!
INTEGER, DIMENSION(:), INTENT(IN), OPTIONAL :: KMASK
!
REAL, DIMENSION(NSIZE) :: ZINTER
REAL   :: XTIME0
!
#ifdef SFX_MPI
INTEGER, DIMENSION(MPI_STATUS_SIZE) :: ISTATUS
#endif
INTEGER :: ICPT
INTEGER :: I,J, IP1, IS1
INTEGER :: INFOMPI
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!
IF (LHOOK) CALL DR_HOOK('GATHER_AND_WRITE_MPI_X1D0',0,ZHOOK_HANDLE)
!
XWORK(NINDX1SFX:NINDX2SFX) = XUNDEF
!
#ifdef SFX_MPI
XTIME0 = MPI_WTIME()
#endif
!
IF (SIZE(PWORK)>0) THEN
  IF (PRESENT(KMASK)) THEN
    CALL UNPACK_SAME_RANK(KMASK,PWORK,XWORK(NINDX1SFX:NINDX2SFX))
  ELSE
    XWORK(NINDX1SFX:NINDX2SFX) = PWORK(:)
  ENDIF
ENDIF
!
#ifdef SFX_MPI
XTIME_CALC_WRITE = XTIME_CALC_WRITE + (MPI_WTIME() - XTIME0)
!
XTIME0 = MPI_WTIME()
#endif
!
!$OMP BARRIER
!
#ifdef SFX_MPI
XTIME_OMP_BARR = XTIME_OMP_BARR + (MPI_WTIME() - XTIME0)
#endif
!
IF (NRANK/=NPIO) THEN
  !
!$OMP SINGLE
  !
  IDX_W = IDX_W + 1
  !
#ifdef SFX_MPI
  XTIME0 = MPI_WTIME()
  CALL MPI_SEND(XWORK,SIZE(XWORK)*KIND(XWORK)/4,MPI_REAL,NPIO,IDX_W,NCOMM,INFOMPI)
  XTIME_COMM_WRITE = XTIME_COMM_WRITE + (MPI_WTIME() - XTIME0)
#endif
  !
!$OMP END SINGLE
  !
ELSE
  !
  IP1 = SIZE(PWORK2)
  !
!$OMP SINGLE
  ! 
  IS1 = SIZE(XWORK_FULL)
  !
  IF (IP1>IS1) THEN
    DEALLOCATE(XWORK_FULL)
    ALLOCATE(XWORK_FULL(IP1))
  ENDIF
  !
  XWORK_FULL(:) = 0.
  !
  IDX_W = IDX_W + 1
  !
  DO I=1,NPROC
    !
#ifdef SFX_MPI
    XTIME0 = MPI_WTIME()
#endif
    !
    IF (I<NPROC) THEN
#ifdef SFX_MPI
      CALL MPI_RECV(ZINTER,SIZE(ZINTER)*KIND(ZINTER)/4,MPI_REAL,I,IDX_W,NCOMM,ISTATUS,INFOMPI)
#endif
    ELSE
      ZINTER(1:SIZE(XWORK)) = XWORK(:)
    ENDIF
    !
#ifdef SFX_MPI
    XTIME_COMM_WRITE = XTIME_COMM_WRITE + (MPI_WTIME() - XTIME0)
    !
    XTIME0 = MPI_WTIME()
#endif
    !
    ICPT = 0
    !
    DO J=1,SIZE(NINDEX)
      !
      IF ( NINDEX(J)==MOD(I,NPROC) ) THEN
        ICPT = ICPT + 1
        XWORK_FULL(J) = ZINTER(ICPT)
      ENDIF
      !
    ENDDO
    !
#ifdef SFX_MPI
    XTIME_CALC_WRITE = XTIME_CALC_WRITE + (MPI_WTIME() - XTIME0)
#endif
    !
  ENDDO
  !
!$OMP END SINGLE
  !
  PWORK2 = XWORK_FULL(1:IP1)
  !
ENDIF
!

IF (LHOOK) CALL DR_HOOK('GATHER_AND_WRITE_MPI_X1D0',1,ZHOOK_HANDLE)
!
END SUBROUTINE GATHER_AND_WRITE_MPI_X1D0
!
!**************************************************************************
!
SUBROUTINE GATHER_AND_WRITE_MPI_X2D0(PWORK,PWORK2,KMASK)
!
USE MODD_SURF_PAR, ONLY : XUNDEF
!
USE MODD_SURFEX_MPI, ONLY : NINDEX, NPROC, NRANK, NCOMM, NPIO, NSIZE, &
                            XTIME_COMM_WRITE, XTIME_OMP_BARR,  &
                            XTIME_CALC_WRITE, IDX_W, WLOG_MPI
USE MODD_SURFEX_OMP, ONLY : NINDX1SFX, NINDX2SFX, XWORK2, XWORK2_FULL, NBLOCK
!
USE MODI_UNPACK_SAME_RANK
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
#ifdef SFX_MPI
INCLUDE "mpif.h"
#endif
!
REAL, DIMENSION(:,:), INTENT(IN) :: PWORK
REAL, DIMENSION(:,:), INTENT(OUT) :: PWORK2
!
INTEGER, DIMENSION(:), INTENT(IN), OPTIONAL :: KMASK
!
REAL, DIMENSION(NSIZE,SIZE(PWORK2,2)) :: ZINTER
REAL:: XTIME0
!
#ifdef SFX_MPI
INTEGER, DIMENSION(MPI_STATUS_SIZE) :: ISTATUS
#endif
INTEGER :: ICPT, IX2, IS1, IS2, IP1, IP2
INTEGER :: I,J
INTEGER :: INFOMPI
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!
IF (LHOOK) CALL DR_HOOK('GATHER_AND_WRITE_MPI_X2D0',0,ZHOOK_HANDLE)
!
IP2 = SIZE(PWORK,2)
IX2 = SIZE(XWORK2,2)
!
!$OMP SINGLE
!
IF (IP2>IX2) THEN
  DEALLOCATE(XWORK2)
  ALLOCATE(XWORK2(NSIZE,IP2))
ENDIF
!
!$OMP END SINGLE
!
XWORK2(NINDX1SFX:NINDX2SFX,1:IP2) = XUNDEF
!
#ifdef SFX_MPI
XTIME0 = MPI_WTIME()
#endif
!
IF (SIZE(PWORK,1)>0) THEN
  IF (PRESENT(KMASK)) THEN
    CALL UNPACK_SAME_RANK(KMASK,PWORK,XWORK2(NINDX1SFX:NINDX2SFX,1:IP2))
  ELSE
    XWORK2(NINDX1SFX:NINDX2SFX,1:IP2) = PWORK(:,:)
  ENDIF
ENDIF
!
#ifdef SFX_MPI
XTIME_CALC_WRITE = XTIME_CALC_WRITE + (MPI_WTIME() - XTIME0)
!
XTIME0 = MPI_WTIME()
#endif
!
!$OMP BARRIER
!
#ifdef SFX_MPI
XTIME_OMP_BARR = XTIME_OMP_BARR + (MPI_WTIME() - XTIME0)
#endif
!
IF (NRANK/=NPIO) THEN
  !
!$OMP SINGLE
  !  
  IDX_W = IDX_W + 1
  !
#ifdef SFX_MPI
  XTIME0 = MPI_WTIME()
  CALL MPI_SEND(XWORK2(:,1:IP2),NSIZE*IP2*KIND(XWORK2)/4,MPI_REAL,NPIO,IDX_W,NCOMM,INFOMPI)
  XTIME_COMM_WRITE = XTIME_COMM_WRITE + (MPI_WTIME() - XTIME0)
#endif
  !
!$OMP END SINGLE
  !
ELSE
  !
  IP1 = SIZE(PWORK2,1)
  !
!$OMP SINGLE
  !
  IS1 = SIZE(XWORK2_FULL,1)
  IS2 = SIZE(XWORK2_FULL,2)
  !
  IF (IP1>IS1 .OR. IP2>IS2) THEN
    DEALLOCATE(XWORK2_FULL)
    ALLOCATE(XWORK2_FULL(MAX(IP1,IS1),MAX(IP2,IS2)))
  ENDIF
  !
  XWORK2_FULL(1:IP1,1:IP2) = 0.
  !
  IDX_W = IDX_W + 1
  !
  DO I=1,NPROC
    !
#ifdef SFX_MPI
    XTIME0 = MPI_WTIME()
#endif
    !
    IF (I<NPROC) THEN
#ifdef SFX_MPI
      CALL MPI_RECV(ZINTER,SIZE(ZINTER)*KIND(ZINTER)/4,MPI_REAL,I,IDX_W,NCOMM,ISTATUS,INFOMPI)
#endif
    ELSE
      ZINTER(:,:) = XWORK2(:,1:IP2)
    ENDIF
!    !
#ifdef SFX_MPI
    XTIME_COMM_WRITE = XTIME_COMM_WRITE + (MPI_WTIME() - XTIME0)
    !
    XTIME0 = MPI_WTIME()
#endif
    !
    ICPT = 0
    !
    DO J=1,SIZE(NINDEX)
      !
      IF ( NINDEX(J)==MOD(I,NPROC) ) THEN
        ICPT = ICPT + 1
        XWORK2_FULL(J,1:IP2) = ZINTER(ICPT,:)
      ENDIF
      !
    ENDDO
     !
#ifdef SFX_MPI
    XTIME_CALC_WRITE = XTIME_CALC_WRITE + (MPI_WTIME() - XTIME0)
#endif
     !
  ENDDO
  !
!$OMP END SINGLE
  !
  PWORK2(:,:) = XWORK2_FULL(1:IP1,1:IP2)
  !
ENDIF
!
IF (LHOOK) CALL DR_HOOK('GATHER_AND_WRITE_MPI_X2D0',1,ZHOOK_HANDLE)
!
!
END SUBROUTINE GATHER_AND_WRITE_MPI_X2D0
!
!**************************************************************************
