MODULE MODI_GATHER_AND_WRITE_MPI
!----------------------------------------------------
!!    MODIFICATIONS
!!    -------------
!!      Original       
!!      J.Escobar      10/06/2013: replace DOUBLE PRECISION by REAL to handle problem for promotion of real on IBM SP
!----------------------------------------------------
!
INTERFACE GATHER_AND_WRITE_MPI
!
SUBROUTINE GATHER_AND_WRITE_MPI_N1D(KWORK,KWORK2,KMASK)
!
INTEGER, DIMENSION(:), INTENT(IN) :: KWORK
INTEGER, DIMENSION(:), INTENT(OUT) :: KWORK2
!
INTEGER, DIMENSION(:), INTENT(IN), OPTIONAL :: KMASK
!
END SUBROUTINE GATHER_AND_WRITE_MPI_N1D
!
SUBROUTINE GATHER_AND_WRITE_MPI_N2D(KWORK,KWORK2,KMASK)
!
INTEGER, DIMENSION(:,:), INTENT(IN) :: KWORK
INTEGER, DIMENSION(:,:), INTENT(OUT) :: KWORK2
!
INTEGER, DIMENSION(:), INTENT(IN), OPTIONAL :: KMASK
!
END SUBROUTINE GATHER_AND_WRITE_MPI_N2D
!
SUBROUTINE GATHER_AND_WRITE_MPI_X1D(PWORK,PWORK2,KMASK)
!
REAL, DIMENSION(:), INTENT(IN) :: PWORK
REAL(KIND=8), DIMENSION(:), INTENT(OUT) :: PWORK2
!
INTEGER, DIMENSION(:), INTENT(IN), OPTIONAL :: KMASK
!
END SUBROUTINE GATHER_AND_WRITE_MPI_X1D
!
SUBROUTINE GATHER_AND_WRITE_MPI_X2D(PWORK,PWORK2,KMASK)
!
REAL, DIMENSION(:,:), INTENT(IN) :: PWORK
REAL(KIND=8), DIMENSION(:,:), INTENT(OUT) :: PWORK2
!
INTEGER, DIMENSION(:), INTENT(IN), OPTIONAL :: KMASK
!
END SUBROUTINE GATHER_AND_WRITE_MPI_X2D
!
SUBROUTINE GATHER_AND_WRITE_MPI_X1DK4(PWORK,PWORK2,KMASK)
!
REAL, DIMENSION(:), INTENT(IN) :: PWORK
REAL(KIND=4), DIMENSION(:), INTENT(OUT) :: PWORK2
!
INTEGER, DIMENSION(:), INTENT(IN), OPTIONAL :: KMASK
!
END SUBROUTINE GATHER_AND_WRITE_MPI_X1DK4
!
SUBROUTINE GATHER_AND_WRITE_MPI_X2DK4(PWORK,PWORK2,KMASK)
!
REAL, DIMENSION(:,:), INTENT(IN) :: PWORK
REAL(KIND=4), DIMENSION(:,:), INTENT(OUT) :: PWORK2
!
INTEGER, DIMENSION(:), INTENT(IN), OPTIONAL :: KMASK
!
END SUBROUTINE GATHER_AND_WRITE_MPI_X2DK4
!
END INTERFACE
!
END MODULE MODI_GATHER_AND_WRITE_MPI
!
SUBROUTINE GATHER_AND_WRITE_MPI_N1D(KWORK,KWORK2,KMASK)
!
USE MODD_SURFEX_MPI, ONLY : NINDEX, NPROC, NRANK, NCOMM, NPIO, NSIZE, &
                            XTIME_CALC_WRITE, XTIME_COMM_WRITE, &
                            XTIME_OMP_BARR, IDX_W, WLOG_MPI
USE MODD_SURFEX_OMP, ONLY : NINDX1SFX, NINDX2SFX, NWORK, NWORK_FULL
!
USE MODI_UNPACK_SAME_RANK
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
#ifdef SFX_MPI
INCLUDE "mpif.h"
#endif
!
INTEGER, DIMENSION(:), INTENT(IN) :: KWORK
INTEGER, DIMENSION(:), INTENT(OUT) :: KWORK2
!
INTEGER, DIMENSION(:), INTENT(IN), OPTIONAL :: KMASK
!
INTEGER, DIMENSION(NSIZE) :: IINTER
REAL   :: XTIME0
!
#ifdef SFX_MPI
INTEGER, DIMENSION(MPI_STATUS_SIZE) :: ISTATUS
#endif
INTEGER :: ICPT
INTEGER :: I,J, IP1, IS1
INTEGER :: INFOMPI
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('GATHER_AND_WRITE_MPI_N1D',0,ZHOOK_HANDLE)
!
!$OMP BARRIER
!
NWORK(NINDX1SFX:NINDX2SFX) = 0
!
#ifdef SFX_MPI
XTIME0 = MPI_WTIME()
#endif
!
IF (PRESENT(KMASK)) THEN
  CALL UNPACK_SAME_RANK(KMASK,KWORK,NWORK(NINDX1SFX:NINDX2SFX))
ELSE
  NWORK(NINDX1SFX:NINDX2SFX) = KWORK(:)
ENDIF
!
#ifdef SFX_MPI
XTIME_CALC_WRITE = XTIME_CALC_WRITE + (MPI_WTIME() - XTIME0)
!
XTIME0 = MPI_WTIME()
#endif
!
!$OMP BARRIER
!
#ifdef SFX_MPI
XTIME_OMP_BARR = XTIME_OMP_BARR + (MPI_WTIME() - XTIME0)
#endif
!
IF (NRANK/=NPIO) THEN
  !
!$OMP SINGLE
  !
  IDX_W = IDX_W + 1
  !  
#ifdef SFX_MPI
  XTIME0 = MPI_WTIME()
  CALL MPI_SEND(NWORK,SIZE(NWORK)*KIND(NWORK)/4,MPI_INTEGER,NPIO,IDX_W,NCOMM,INFOMPI)
  XTIME_COMM_WRITE = XTIME_COMM_WRITE + (MPI_WTIME() - XTIME0)
#endif
  !
!$OMP END SINGLE
  !  
ELSE
  !
  IP1 = SIZE(KWORK2)
  !
!$OMP SINGLE
  !
  IS1 = SIZE(NWORK_FULL)
  !
  IF (IP1>IS1) THEN
    DEALLOCATE(NWORK_FULL)
    ALLOCATE(NWORK_FULL(IP1))
  ENDIF
  !
  NWORK_FULL(:) = 0
  !
  IDX_W = IDX_W + 1 
  !
  DO I=1,NPROC
    !
#ifdef SFX_MPI
    XTIME0 = MPI_WTIME()
#endif
    !
    IF (I<NPROC) THEN
#ifdef SFX_MPI
      CALL MPI_RECV(IINTER,SIZE(IINTER)*KIND(IINTER)/4,MPI_INTEGER,I,IDX_W,NCOMM,ISTATUS,INFOMPI)
#endif
    ELSE
      IINTER(1:SIZE(NWORK)) = NWORK(:)
    ENDIF
    !
#ifdef SFX_MPI
    XTIME_COMM_WRITE = XTIME_COMM_WRITE + (MPI_WTIME() - XTIME0)
    !
    XTIME0 = MPI_WTIME()
#endif
    !
    ICPT = 0
    !    
    DO J=1,SIZE(NINDEX)
      !
      IF ( NINDEX(J)==MOD(I,NPROC) ) THEN
        ICPT = ICPT + 1
        NWORK_FULL(J) = IINTER(ICPT)
      ENDIF
      !
    ENDDO
    !
#ifdef SFX_MPI
    XTIME_CALC_WRITE = XTIME_CALC_WRITE + (MPI_WTIME() - XTIME0)
#endif
    !
  ENDDO
  !
!$OMP END SINGLE
  !
  KWORK2(:) = NWORK_FULL(1:IP1)
  !
ENDIF
!
IF (LHOOK) CALL DR_HOOK('GATHER_AND_WRITE_MPI_N1D',1,ZHOOK_HANDLE)
!
!
END SUBROUTINE GATHER_AND_WRITE_MPI_N1D
!
!**************************************************************************
!
SUBROUTINE GATHER_AND_WRITE_MPI_N2D(KWORK,KWORK2,KMASK)
!
USE MODD_SURFEX_MPI, ONLY : NINDEX, NPROC, NRANK, NCOMM, NPIO, NSIZE, &
                            XTIME_CALC_WRITE, XTIME_COMM_WRITE, &
                            XTIME_OMP_BARR, IDX_W, WLOG_MPI
USE MODD_SURFEX_OMP, ONLY : NINDX1SFX, NINDX2SFX, NWORK2, NWORK2_FULL
!
USE MODI_UNPACK_SAME_RANK
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
#ifdef SFX_MPI
INCLUDE "mpif.h"
#endif
!
INTEGER, DIMENSION(:,:), INTENT(IN) :: KWORK
INTEGER, DIMENSION(:,:), INTENT(OUT) :: KWORK2
!
INTEGER, DIMENSION(:), INTENT(IN), OPTIONAL :: KMASK
!
INTEGER, DIMENSION(NSIZE,SIZE(KWORK2,2)) :: IINTER
REAL   :: XTIME0
!
#ifdef SFX_MPI
INTEGER, DIMENSION(MPI_STATUS_SIZE) :: ISTATUS
#endif
INTEGER :: ICPT, IX2, IS1, IS2, IP1, IP2
INTEGER :: I,J
INTEGER :: INFOMPI
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('GATHER_AND_WRITE_MPI_N2D',0,ZHOOK_HANDLE)
!
IP2 = SIZE(KWORK,2)
IX2 = SIZE(NWORK2,2)
!
!$OMP SINGLE
!
IF (IP2>IX2) THEN
  DEALLOCATE(NWORK2)
  ALLOCATE(NWORK2(NSIZE,IP2))
ENDIF
!
!$OMP END SINGLE
!
NWORK2(NINDX1SFX:NINDX2SFX,1:IP2) = 0
!
#ifdef SFX_MPI
XTIME0 = MPI_WTIME()
#endif
!
IF (SIZE(KWORK,1)>0) THEN
  IF (PRESENT(KMASK)) THEN
    CALL UNPACK_SAME_RANK(KMASK,KWORK,NWORK2(NINDX1SFX:NINDX2SFX,1:IP2))
  ELSE
    NWORK2(NINDX1SFX:NINDX2SFX,1:IP2) = KWORK(:,:)
  ENDIF
ENDIF
!
#ifdef SFX_MPI
XTIME_CALC_WRITE = XTIME_CALC_WRITE + (MPI_WTIME() - XTIME0)
!
XTIME0 = MPI_WTIME()
#endif
!
!$OMP BARRIER
!
#ifdef SFX_MPI
XTIME_OMP_BARR = XTIME_OMP_BARR + (MPI_WTIME() - XTIME0)
#endif
!
IF (NRANK/=NPIO) THEN
  !
!$OMP SINGLE
  !
  IDX_W = IDX_W + 1
  !  
#ifdef SFX_MPI
  XTIME0 = MPI_WTIME()
  CALL MPI_SEND(NWORK2(:,1:IP2),NSIZE*IP2*KIND(NWORK2)/4,MPI_INTEGER,NPIO,IDX_W,NCOMM,INFOMPI)
  XTIME_COMM_WRITE = XTIME_COMM_WRITE + (MPI_WTIME() - XTIME0)
#endif
  !
!$OMP END SINGLE
  !  
ELSE
  !
  IP1 = SIZE(KWORK2,1)
  !
!$OMP SINGLE
  !
  IS1 = SIZE(NWORK2_FULL,1)
  IS2 = SIZE(NWORK2_FULL,2)  
  !
  IF (IP1>IS1 .OR. IP2>IS2) THEN
    DEALLOCATE(NWORK2_FULL)
    ALLOCATE(NWORK2_FULL(MAX(IP1,IS1),MAX(IP2,IS2)))
  ENDIF  
  !
  NWORK2_FULL(:,:) = 0
  !
  IDX_W = IDX_W + 1 
  !
  DO I=1,NPROC
    !
#ifdef SFX_MPI
    XTIME0 = MPI_WTIME()
#endif
    !
    IF (I<NPROC) THEN
#ifdef SFX_MPI
      CALL MPI_RECV(IINTER,SIZE(IINTER)*KIND(IINTER)/4,MPI_INTEGER,I,IDX_W,NCOMM,ISTATUS,INFOMPI)
#endif
    ELSE
      IINTER(:,:) = NWORK2(:,1:IP2)
    ENDIF
    !
#ifdef SFX_MPI
    XTIME_COMM_WRITE = XTIME_COMM_WRITE + (MPI_WTIME() - XTIME0)
    !
    XTIME0 = MPI_WTIME()
#endif
    !
    ICPT = 0
    !  
    DO J=1,SIZE(NINDEX)
      !
      IF ( NINDEX(J)==MOD(I,NPROC) ) THEN
        ICPT = ICPT + 1
        NWORK2_FULL(J,1:IP2) = IINTER(ICPT,:)
      ENDIF
      !
    ENDDO
    !
#ifdef SFX_MPI
    XTIME_CALC_WRITE = XTIME_CALC_WRITE + (MPI_WTIME() - XTIME0)
#endif
    !
  ENDDO
  !
!$OMP END SINGLE
  !
  KWORK2(:,:) = NWORK2_FULL(1:IP1,1:IP2)
  !
ENDIF
!
IF (LHOOK) CALL DR_HOOK('GATHER_AND_WRITE_MPI_N2D',1,ZHOOK_HANDLE)
!
!
END SUBROUTINE GATHER_AND_WRITE_MPI_N2D
!
!**************************************************************************
!
SUBROUTINE GATHER_AND_WRITE_MPI_X1D(PWORK,PWORK2,KMASK)
!
USE MODI_GATHER_AND_WRITE_MPI_K4
!
USE MODD_SURFEX_MPI, ONLY : NRANK, NPIO
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
REAL, DIMENSION(:), INTENT(IN) :: PWORK
REAL(KIND=8), DIMENSION(:), INTENT(OUT) :: PWORK2
INTEGER, DIMENSION(:), INTENT(IN), OPTIONAL :: KMASK
!
REAL, DIMENSION(SIZE(PWORK2)) :: ZINTER
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('GATHER_AND_WRITE_MPI_X1D',0,ZHOOK_HANDLE)
!
IF (PRESENT(KMASK)) THEN
  CALL GATHER_AND_WRITE_MPI_K4(PWORK,ZINTER,KMASK)
ELSE
  CALL GATHER_AND_WRITE_MPI_K4(PWORK,ZINTER)
ENDIF
!
IF (NRANK==NPIO) THEN
  PWORK2(:) = ZINTER(:)
ENDIF
!
IF (LHOOK) CALL DR_HOOK('GATHER_AND_WRITE_MPI_X1D',1,ZHOOK_HANDLE)
!
END SUBROUTINE GATHER_AND_WRITE_MPI_X1D
!
!**************************************************************************
!
SUBROUTINE GATHER_AND_WRITE_MPI_X2D(PWORK,PWORK2,KMASK)
!
USE MODI_GATHER_AND_WRITE_MPI_K4
!
USE MODD_SURFEX_MPI, ONLY : NRANK, NPIO
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
REAL, DIMENSION(:,:), INTENT(IN) :: PWORK
REAL(KIND=8), DIMENSION(:,:), INTENT(OUT) :: PWORK2
INTEGER, DIMENSION(:), INTENT(IN), OPTIONAL :: KMASK
!
REAL, DIMENSION(SIZE(PWORK2,1),SIZE(PWORK2,2)) :: ZINTER
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('GATHER_AND_WRITE_MPI_X2D',0,ZHOOK_HANDLE)
!
IF (PRESENT(KMASK)) THEN
  CALL GATHER_AND_WRITE_MPI_K4(PWORK,ZINTER,KMASK)
ELSE
  CALL GATHER_AND_WRITE_MPI_K4(PWORK,ZINTER)
ENDIF
!
IF (NRANK==NPIO) THEN
  PWORK2(:,:) = ZINTER(:,:)
ENDIF
!
IF (LHOOK) CALL DR_HOOK('GATHER_AND_WRITE_MPI_X2D',1,ZHOOK_HANDLE)
!
END SUBROUTINE GATHER_AND_WRITE_MPI_X2D
!
!**************************************************************************
!
SUBROUTINE GATHER_AND_WRITE_MPI_X1DK4(PWORK,PWORK2,KMASK)
!
USE MODI_GATHER_AND_WRITE_MPI_K4
!
USE MODD_SURFEX_MPI, ONLY : NRANK, NPIO
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
REAL, DIMENSION(:), INTENT(IN) :: PWORK
REAL(KIND=4), DIMENSION(:), INTENT(OUT) :: PWORK2
INTEGER, DIMENSION(:), INTENT(IN), OPTIONAL :: KMASK
!
REAL, DIMENSION(SIZE(PWORK2)) :: ZINTER
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('GATHER_AND_WRITE_MPI_X1DK4',0,ZHOOK_HANDLE)
!
IF (PRESENT(KMASK)) THEN
  CALL GATHER_AND_WRITE_MPI_K4(PWORK,ZINTER,KMASK)
ELSE
  CALL GATHER_AND_WRITE_MPI_K4(PWORK,ZINTER)
ENDIF
!
IF (NRANK==NPIO) THEN
  PWORK2(:) = ZINTER(:)
ENDIF
!
IF (LHOOK) CALL DR_HOOK('GATHER_AND_WRITE_MPI_X1DK4',1,ZHOOK_HANDLE)
!
END SUBROUTINE GATHER_AND_WRITE_MPI_X1DK4
!
!**************************************************************************
!
SUBROUTINE GATHER_AND_WRITE_MPI_X2DK4(PWORK,PWORK2,KMASK)
!
USE MODI_GATHER_AND_WRITE_MPI_K4
!
USE MODD_SURFEX_MPI, ONLY : NRANK, NPIO
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
REAL, DIMENSION(:,:), INTENT(IN) :: PWORK
REAL(KIND=4), DIMENSION(:,:), INTENT(OUT) :: PWORK2
INTEGER, DIMENSION(:), INTENT(IN), OPTIONAL :: KMASK
!
REAL, DIMENSION(SIZE(PWORK2,1),SIZE(PWORK2,2)) :: ZINTER
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('GATHER_AND_WRITE_MPI_X2DK4',0,ZHOOK_HANDLE)
!
IF (PRESENT(KMASK)) THEN
  CALL GATHER_AND_WRITE_MPI_K4(PWORK,ZINTER,KMASK)
ELSE
  CALL GATHER_AND_WRITE_MPI_K4(PWORK,ZINTER)
ENDIF
!
IF (NRANK==NPIO) THEN
  PWORK2(:,:) = ZINTER(:,:)
ENDIF
!
IF (LHOOK) CALL DR_HOOK('GATHER_AND_WRITE_MPI_X2DK4',1,ZHOOK_HANDLE)
!
END SUBROUTINE GATHER_AND_WRITE_MPI_X2DK4

