!     #########
SUBROUTINE FLAG_DIAG_UPDATE (CHF, CHI, CHS, CHT, CHW, DGEI, DGF, DGI, DGMF, DGMI, DGMTO, &
                             DGO, DGS, DGSI, DGU, DGT, DGW, I, U, &
                             OFRAC, ODIAG_GRID, K2M, OSURF_BUDGET, ORAD_BUDGET, OCOEF,  &
                            OSURF_VARS, KBEQ, KDSTEQ, ODIAG_OCEAN, ODIAG_SEAICE,       &
                            OWATER_PROFILE,                                            &
                            OSURF_EVAP_BUDGET, OFLOOD,  OPGD_ISBA, OCH_NO_FLUX_ISBA,   &
                            OSURF_MISC_BUDGET_ISBA, OPGD_TEB, OSURF_MISC_BUDGET_TEB    )
!     ############################################################
!
!!****  *FLAG_DIAG_UPDATE* - routine to modify selection of output fields
!!
!!    PURPOSE
!!    -------
!!
!!**  METHOD
!!    ------
!!
!!    EXTERNAL
!!    --------
!!
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!
!!    AUTHOR
!!    ------
!!	P. Le Moigne   *Meteo France*	
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    02/2008 
!
!       B.Decharme  10/2009 flag to desactivate writing of pgd 
!!      Modified    04/2013, P. Le Moigne: FLake chemistry
!!      Modified    01/2014, S. Senesi   : introduce sea-ice model
!-------------------------------------------------------------------------------
!
!*       0.    DECLARATIONS
!              ------------
!
!
!
!
USE MODD_CH_FLAKE_n, ONLY : CH_FLAKE_t
USE MODD_CH_ISBA_n, ONLY : CH_ISBA_t
USE MODD_CH_SEAFLUX_n, ONLY : CH_SEAFLUX_t
USE MODD_CH_TEB_n, ONLY : CH_TEB_t
USE MODD_CH_WATFLUX_n, ONLY : CH_WATFLUX_t
USE MODD_DIAG_EVAP_ISBA_n, ONLY : DIAG_EVAP_ISBA_t
USE MODD_DIAG_FLAKE_n, ONLY : DIAG_FLAKE_t
USE MODD_DIAG_ISBA_n, ONLY : DIAG_ISBA_t
USE MODD_DIAG_MISC_FLAKE_n, ONLY : DIAG_MISC_FLAKE_t
USE MODD_DIAG_MISC_ISBA_n, ONLY : DIAG_MISC_ISBA_t
USE MODD_DIAG_MISC_TEB_OPTION_n, ONLY : DIAG_MISC_TEB_OPTIONS_t
USE MODD_DIAG_OCEAN_n, ONLY : DIAG_OCEAN_t
USE MODD_DIAG_SEAFLUX_n, ONLY : DIAG_SEAFLUX_t
USE MODD_DIAG_SEAICE_n, ONLY : DIAG_SEAICE_t
USE MODD_DIAG_SURF_ATM_n, ONLY : DIAG_SURF_ATM_t
USE MODD_DIAG_TEB_n, ONLY : DIAG_TEB_t
USE MODD_DIAG_WATFLUX_n, ONLY : DIAG_WATFLUX_t
USE MODD_ISBA_n, ONLY : ISBA_t
USE MODD_SURF_ATM_n, ONLY : SURF_ATM_t
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*       0.1   Declarations of arguments
!              -------------------------
!
!
TYPE(CH_FLAKE_t), INTENT(INOUT) :: CHF
TYPE(CH_ISBA_t), INTENT(INOUT) :: CHI
TYPE(CH_SEAFLUX_t), INTENT(INOUT) :: CHS
TYPE(CH_TEB_t), INTENT(INOUT) :: CHT
TYPE(CH_WATFLUX_t), INTENT(INOUT) :: CHW
TYPE(DIAG_EVAP_ISBA_t), INTENT(INOUT) :: DGEI
TYPE(DIAG_FLAKE_t), INTENT(INOUT) :: DGF
TYPE(DIAG_ISBA_t), INTENT(INOUT) :: DGI
TYPE(DIAG_MISC_FLAKE_t), INTENT(INOUT) :: DGMF
TYPE(DIAG_MISC_ISBA_t), INTENT(INOUT) :: DGMI
TYPE(DIAG_MISC_TEB_OPTIONS_t), INTENT(INOUT) :: DGMTO
TYPE(DIAG_OCEAN_t), INTENT(INOUT) :: DGO
TYPE(DIAG_SEAFLUX_t), INTENT(INOUT) :: DGS
TYPE(DIAG_SEAICE_t), INTENT(INOUT) :: DGSI
TYPE(DIAG_SURF_ATM_t), INTENT(INOUT) :: DGU
TYPE(DIAG_TEB_t), INTENT(INOUT) :: DGT
TYPE(DIAG_WATFLUX_t), INTENT(INOUT) :: DGW
TYPE(ISBA_t), INTENT(INOUT) :: I
TYPE(SURF_ATM_t), INTENT(INOUT) :: U
!
LOGICAL, INTENT(IN) :: OFRAC
LOGICAL, INTENT(IN) :: ODIAG_GRID
INTEGER, INTENT(IN) :: K2M
LOGICAL, INTENT(IN) :: OSURF_BUDGET
LOGICAL, INTENT(IN) :: ORAD_BUDGET
LOGICAL, INTENT(IN) :: OCOEF
LOGICAL, INTENT(IN) :: OSURF_VARS
!
INTEGER, INTENT(IN) :: KBEQ
INTEGER, INTENT(IN) :: KDSTEQ
!
LOGICAL, INTENT(IN) :: ODIAG_OCEAN
LOGICAL, INTENT(IN) :: ODIAG_SEAICE
LOGICAL, INTENT(IN) :: OWATER_PROFILE
LOGICAL, INTENT(IN) :: OSURF_EVAP_BUDGET
LOGICAL, INTENT(IN) :: OFLOOD
LOGICAL, INTENT(IN) :: OSURF_MISC_BUDGET_ISBA
LOGICAL, INTENT(IN) :: OCH_NO_FLUX_ISBA
LOGICAL, INTENT(IN) :: OPGD_ISBA
LOGICAL, INTENT(IN) :: OSURF_MISC_BUDGET_TEB
LOGICAL, INTENT(IN) :: OPGD_TEB
!
!*       0.2   Declarations of local variables
!              -------------------------------
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!-------------------------------------------------------------------------------
IF (LHOOK) CALL DR_HOOK('FLAG_DIAG_UPDATE',0,ZHOOK_HANDLE)
!
DGU%LFRAC = OFRAC
DGU%LDIAG_GRID = ODIAG_GRID
DGU%N2M = K2M
DGU%LSURF_BUDGET = OSURF_BUDGET
DGU%LRAD_BUDGET = ORAD_BUDGET
DGU%LCOEF = OCOEF
DGU%LSURF_VARS = OSURF_VARS
!
DGU%LSURF_BUDGETC = .FALSE.
IF (.NOT.DGU%LRESET_BUDGETC) DGU%LSURF_BUDGETC = .TRUE.
!
IF (U%CSEA   =='SEAFLX') CALL FLAG_SEA_UPDATE(KBEQ, ODIAG_OCEAN, ODIAG_SEAICE, &
                                            DGU%LSURF_BUDGETC, DGU%LRAD_BUDGET, K2M)
IF (U%CWATER =='FLAKE ') CALL FLAG_FLAKE_UPDATE(KBEQ, OWATER_PROFILE, DGU%LSURF_BUDGETC, DGU%LRAD_BUDGET, K2M)
IF (U%CWATER =='WATFLX') CALL FLAG_WATER_UPDATE(KBEQ, DGU%LSURF_BUDGETC, DGU%LRAD_BUDGET, K2M)
IF (U%CNATURE=='ISBA  ') CALL FLAG_ISBA_UPDATE(KBEQ, KDSTEQ, OSURF_EVAP_BUDGET, OFLOOD, &
                                OPGD_ISBA, OCH_NO_FLUX_ISBA, OSURF_MISC_BUDGET_ISBA,&
                                DGU%LSURF_BUDGETC, DGU%LRAD_BUDGET, K2M)
IF (U%CTOWN  =='TEB   ') CALL FLAG_TEB_UPDATE(KBEQ, OPGD_TEB, OSURF_MISC_BUDGET_TEB, DGU%LRAD_BUDGET, K2M)
!
IF (LHOOK) CALL DR_HOOK('FLAG_DIAG_UPDATE',1,ZHOOK_HANDLE)
!-------------------------------------------------------------------------------
CONTAINS
!
SUBROUTINE FLAG_SEA_UPDATE(KBEQ, ODIAG_OCEAN, ODIAG_SEAICE, OSURF_BUDGETC, ORAD_BUDGET, K2M)
!
!
IMPLICIT NONE
!
INTEGER, INTENT(IN) :: KBEQ
LOGICAL, INTENT(IN) :: ODIAG_OCEAN
LOGICAL, INTENT(IN) :: ODIAG_SEAICE
LOGICAL, INTENT(IN) :: OSURF_BUDGETC
LOGICAL, INTENT(IN) :: ORAD_BUDGET
INTEGER, INTENT(IN) :: K2M
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('FLAG_DIAG_UPDATE:FLAG_SEA_UPDATE',0,ZHOOK_HANDLE)
CHS%SVS%NBEQ = KBEQ
DGO%LDIAG_OCEAN = ODIAG_OCEAN
DGSI%LDIAG_SEAICE = ODIAG_SEAICE
DGS%LSURF_BUDGETC = OSURF_BUDGETC
DGS%LRAD_BUDGET = ORAD_BUDGET
DGS%N2M = K2M
IF (LHOOK) CALL DR_HOOK('FLAG_DIAG_UPDATE:FLAG_SEA_UPDATE',1,ZHOOK_HANDLE)
!
END SUBROUTINE FLAG_SEA_UPDATE
!
SUBROUTINE FLAG_WATER_UPDATE(KBEQ, OSURF_BUDGETC, ORAD_BUDGET, K2M)
!
!
IMPLICIT NONE
!
INTEGER, INTENT(IN) :: KBEQ
LOGICAL, INTENT(IN) :: OSURF_BUDGETC
LOGICAL, INTENT(IN) :: ORAD_BUDGET
INTEGER, INTENT(IN) :: K2M
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('FLAG_DIAG_UPDATE:FLAG_WATER_UPDATE',0,ZHOOK_HANDLE)
CHW%SVW%NBEQ = KBEQ
DGW%LSURF_BUDGETC = OSURF_BUDGETC
DGW%LRAD_BUDGET = ORAD_BUDGET
DGW%N2M = K2M
IF (LHOOK) CALL DR_HOOK('FLAG_DIAG_UPDATE:FLAG_WATER_UPDATE',1,ZHOOK_HANDLE)
!
END SUBROUTINE FLAG_WATER_UPDATE
!
SUBROUTINE FLAG_FLAKE_UPDATE(KBEQ, OWATER_PROFILE, OSURF_BUDGETC, ORAD_BUDGET, K2M)
!
!
IMPLICIT NONE
!
INTEGER, INTENT(IN) :: KBEQ
LOGICAL, INTENT(IN) :: OWATER_PROFILE
LOGICAL, INTENT(IN) :: OSURF_BUDGETC
LOGICAL, INTENT(IN) :: ORAD_BUDGET
INTEGER, INTENT(IN) :: K2M
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('FLAG_DIAG_UPDATE:FLAG_FLAKE_UPDATE',0,ZHOOK_HANDLE)
CHF%SVF%NBEQ = KBEQ
DGMF%LWATER_PROFILE = OWATER_PROFILE
DGF%LSURF_BUDGETC = OSURF_BUDGETC
DGF%LRAD_BUDGET = ORAD_BUDGET
DGF%N2M = K2M
IF (LHOOK) CALL DR_HOOK('FLAG_DIAG_UPDATE:FLAG_FLAKE_UPDATE',1,ZHOOK_HANDLE)
!
END SUBROUTINE FLAG_FLAKE_UPDATE
!
!
SUBROUTINE FLAG_ISBA_UPDATE(KBEQ, KDSTEQ, OSURF_EVAP_BUDGET, OFLOOD, &
                            OPGD, OCH_NO_FLUX, OSURF_MISC_BUDGET, &
                            OSURF_BUDGETC, ORAD_BUDGET, K2M)
!
!
IMPLICIT NONE
!
INTEGER, INTENT(IN) :: KBEQ
INTEGER, INTENT(IN) :: KDSTEQ
LOGICAL, INTENT(IN) :: OSURF_EVAP_BUDGET
LOGICAL, INTENT(IN) :: OFLOOD
LOGICAL, INTENT(IN) :: OPGD
LOGICAL, INTENT(IN) :: OCH_NO_FLUX
LOGICAL, INTENT(IN) :: OSURF_MISC_BUDGET
LOGICAL, INTENT(IN) :: OSURF_BUDGETC
LOGICAL, INTENT(IN) :: ORAD_BUDGET
INTEGER, INTENT(IN) :: K2M
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('FLAG_DIAG_UPDATE:FLAG_ISBA_UPDATE',0,ZHOOK_HANDLE)
CHI%SVI%NBEQ = KBEQ
CHI%SVI%NDSTEQ = KDSTEQ
DGEI%LSURF_EVAP_BUDGET = OSURF_EVAP_BUDGET
I%LFLOOD = OFLOOD
DGI%LPGD = OPGD
CHI%LCH_NO_FLUX = OCH_NO_FLUX
DGMI%LSURF_MISC_BUDGET = OSURF_MISC_BUDGET
DGEI%LSURF_BUDGETC = OSURF_BUDGETC
DGI%LPATCH_BUDGET = OSURF_BUDGETC
DGI%LRAD_BUDGET = ORAD_BUDGET
DGI%N2M = K2M
IF (LHOOK) CALL DR_HOOK('FLAG_DIAG_UPDATE:FLAG_ISBA_UPDATE',1,ZHOOK_HANDLE)
!
END SUBROUTINE FLAG_ISBA_UPDATE
!
SUBROUTINE FLAG_TEB_UPDATE(KBEQ, OPGD, OSURF_MISC_BUDGET, ORAD_BUDGET, K2M)
!
!
IMPLICIT NONE
!
INTEGER, INTENT(IN) :: KBEQ
LOGICAL, INTENT(IN) :: OPGD
LOGICAL, INTENT(IN) :: OSURF_MISC_BUDGET
LOGICAL, INTENT(IN) :: ORAD_BUDGET
INTEGER, INTENT(IN) :: K2M
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('FLAG_DIAG_UPDATE:FLAG_TEB_UPDATE',0,ZHOOK_HANDLE)
CHT%SVT%NBEQ = KBEQ
DGT%LPGD = OPGD
DGMTO%LSURF_MISC_BUDGET = OSURF_MISC_BUDGET
DGT%LRAD_BUDGET = ORAD_BUDGET
DGT%N2M = K2M
IF (LHOOK) CALL DR_HOOK('FLAG_DIAG_UPDATE:FLAG_TEB_UPDATE',1,ZHOOK_HANDLE)
!
END SUBROUTINE FLAG_TEB_UPDATE
!
END SUBROUTINE FLAG_DIAG_UPDATE

