!     #########
      SUBROUTINE DIAG_SEAFLUX_INIT_n (&
                                       DGO, DGS, DGSI, DGU, S, &
                                      HPROGRAM,KLU,KSW)
!     #####################
!
!!****  *DIAG_SEAFLUX_INIT_n* - routine to initialize SEAFLUX diagnostic variables
!!
!!    PURPOSE
!!    -------
!!
!!**  METHOD
!!    ------
!!
!!    EXTERNAL
!!    --------
!!
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!
!!    AUTHOR
!!    ------
!!      V. Masson   *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    01/2004 
!!      Modified    01/2006 : sea flux parameterization.
!!      Modified    08/2009 : cumulative sea flux 
!!      B. decharme 04/2013 : Add EVAP and SUBL diag
!!      S.Senesi    01/2014 : introduce fractional seaice 
!-------------------------------------------------------------------------------
!
!*       0.    DECLARATIONS
!              ------------
!
!
!
USE MODD_DIAG_OCEAN_n, ONLY : DIAG_OCEAN_t
USE MODD_DIAG_SEAFLUX_n, ONLY : DIAG_SEAFLUX_t
USE MODD_DIAG_SEAICE_n, ONLY : DIAG_SEAICE_t
USE MODD_DIAG_SURF_ATM_n, ONLY : DIAG_SURF_ATM_t
USE MODD_SEAFLUX_n, ONLY : SEAFLUX_t
!
!
!
#ifdef SFX_OL
USE MODN_IO_OFFLINE,     ONLY : LRESTART
#endif
USE MODD_SURF_PAR,       ONLY : XUNDEF
USE MODD_SFX_OASIS,      ONLY : LCPL_SEA,LCPL_SEAICE

!                                
!
!
!
USE MODI_READ_SURF
!
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*       0.1   Declarations of arguments
!              -------------------------
!
!
!
!
TYPE(DIAG_OCEAN_t), INTENT(INOUT) :: DGO
TYPE(DIAG_SEAFLUX_t), INTENT(INOUT) :: DGS
TYPE(DIAG_SEAICE_t), INTENT(INOUT) :: DGSI
TYPE(DIAG_SURF_ATM_t), INTENT(INOUT) :: DGU
TYPE(SEAFLUX_t), INTENT(INOUT) :: S
!
INTEGER, INTENT(IN) :: KLU   ! size of arrays
INTEGER, INTENT(IN) :: KSW   ! number of SW spectral bands
 CHARACTER(LEN=6), INTENT(IN):: HPROGRAM  ! program calling
!
!*       0.2   Declarations of local variables
!              -------------------------------
!
INTEGER           :: IVERSION
INTEGER           :: IRESP          ! IRESP  : return-code if a problem appears
CHARACTER(LEN=12) :: YREC           ! Name of the article to be read
!
REAL(KIND=JPRB)   :: ZHOOK_HANDLE
!
!-------------------------------------------------------------------------------
!
!* surface energy budget
!
IF (LHOOK) CALL DR_HOOK('DIAG_SEAFLUX_INIT_N',0,ZHOOK_HANDLE)
ALLOCATE(DGS%XTS   (KLU))
ALLOCATE(DGS%XTSRAD(KLU))
DGS%XTS    = XUNDEF
DGS%XTSRAD = XUNDEF
!
IF (DGS%LSURF_BUDGET.OR.DGS%LSURF_BUDGETC) THEN
  ALLOCATE(DGS%XRN     (KLU))
  ALLOCATE(DGS%XRN_ICE (KLU))
  ALLOCATE(DGS%XH      (KLU))
  ALLOCATE(DGS%XH_ICE  (KLU))
  ALLOCATE(DGS%XLE     (KLU))
  ALLOCATE(DGS%XLE_ICE (KLU))
  ALLOCATE(DGS%XGFLUX  (KLU))
  ALLOCATE(DGS%XGFLUX_ICE(KLU))
  ALLOCATE(DGS%XEVAP   (KLU))
  ALLOCATE(DGS%XSUBL   (KLU))
  ALLOCATE(DGS%XSWD    (KLU))
  ALLOCATE(DGS%XSWU    (KLU))
  ALLOCATE(DGS%XSWU_ICE(KLU))
  ALLOCATE(DGS%XLWD    (KLU))
  ALLOCATE(DGS%XLWU    (KLU))
  ALLOCATE(DGS%XLWU_ICE(KLU))
  ALLOCATE(DGS%XSWBD   (KLU,KSW))
  ALLOCATE(DGS%XSWBU   (KLU,KSW))
  ALLOCATE(DGS%XSWBU_ICE(KLU,KSW))
  ALLOCATE(DGS%XFMU    (KLU))
  ALLOCATE(DGS%XFMU_ICE(KLU))
  ALLOCATE(DGS%XFMV    (KLU))
  ALLOCATE(DGS%XFMV_ICE(KLU))
  ALLOCATE(DGS%XALBT   (KLU))  
  !
  DGS%XRN      = XUNDEF
  DGS%XRN_ICE  = XUNDEF
  DGS%XH       = XUNDEF
  DGS%XH_ICE   = XUNDEF
  DGS%XLE      = XUNDEF
  DGS%XLE_ICE  = XUNDEF
  DGS%XGFLUX   = XUNDEF
  DGS%XGFLUX_ICE=XUNDEF
  DGS%XEVAP    = XUNDEF
  DGS%XSUBL    = XUNDEF  
  DGS%XSWD     = XUNDEF
  DGS%XSWU     = XUNDEF
  DGS%XSWU_ICE = XUNDEF
  DGS%XLWD     = XUNDEF
  DGS%XLWU     = XUNDEF
  DGS%XLWU_ICE = XUNDEF
  DGS%XSWBD    = XUNDEF
  DGS%XSWBU    = XUNDEF
  DGS%XSWBU_ICE= XUNDEF
  DGS%XFMU     = XUNDEF
  DGS%XFMU_ICE = XUNDEF
  DGS%XFMV     = XUNDEF
  DGS%XFMV_ICE = XUNDEF
  DGS%XALBT    = XUNDEF  
  !
ELSE
  ALLOCATE(DGS%XRN     (0))
  ALLOCATE(DGS%XRN_ICE (0))
  ALLOCATE(DGS%XH      (0))
  ALLOCATE(DGS%XH_ICE  (0))
  ALLOCATE(DGS%XLE     (0))
  ALLOCATE(DGS%XLE_ICE (0))
  ALLOCATE(DGS%XGFLUX  (0))
  ALLOCATE(DGS%XGFLUX_ICE(0))
  ALLOCATE(DGS%XEVAP   (0))
  ALLOCATE(DGS%XSUBL   (0))  
  ALLOCATE(DGS%XSWD    (0))
  ALLOCATE(DGS%XSWU    (0))
  ALLOCATE(DGS%XSWU_ICE(0))
  ALLOCATE(DGS%XLWD    (0))
  ALLOCATE(DGS%XLWU    (0))
  ALLOCATE(DGS%XLWU_ICE(0))
  ALLOCATE(DGS%XSWBD   (0,0))
  ALLOCATE(DGS%XSWBU   (0,0))
  ALLOCATE(DGS%XSWBU_ICE(0,0))
  ALLOCATE(DGS%XFMU    (0))
  ALLOCATE(DGS%XFMU_ICE(0))
  ALLOCATE(DGS%XFMV    (0))
  ALLOCATE(DGS%XFMV_ICE(0))
  ALLOCATE(DGS%XALBT   (0))  
ENDIF
!
!* cumulative surface energy budget
!
#ifdef SFX_OL
IF (DGS%LSURF_BUDGETC .OR. (LRESTART .AND. .NOT.DGS%LRESET_BUDGETC)) THEN
#else
IF (DGS%LSURF_BUDGETC .OR. .NOT.DGS%LRESET_BUDGETC) THEN
#endif
!        
  ALLOCATE(DGS%XRNC    (KLU))
  ALLOCATE(DGS%XRNC_ICE(KLU))
  ALLOCATE(DGS%XHC     (KLU))
  ALLOCATE(DGS%XHC_ICE (KLU))
  ALLOCATE(DGS%XLEC    (KLU))
  ALLOCATE(DGS%XLEC_ICE(KLU))
  ALLOCATE(DGS%XGFLUXC (KLU))
  ALLOCATE(DGS%XGFLUXC_ICE(KLU))
  ALLOCATE(DGS%XEVAPC  (KLU))
  ALLOCATE(DGS%XSUBLC  (KLU))  
  ALLOCATE(DGS%XSWDC   (KLU))
  ALLOCATE(DGS%XSWUC   (KLU))
  ALLOCATE(DGS%XSWUC_ICE(KLU))
  ALLOCATE(DGS%XLWDC   (KLU))
  ALLOCATE(DGS%XLWUC   (KLU))
  ALLOCATE(DGS%XLWUC_ICE(KLU))
  ALLOCATE(DGS%XFMUC   (KLU))
  ALLOCATE(DGS%XFMUC_ICE(KLU))
  ALLOCATE(DGS%XFMVC   (KLU))
  ALLOCATE(DGS%XFMVC_ICE(KLU))
!
  IF (.NOT. DGU%LREAD_BUDGETC) THEN        
     DGS%XRNC    = 0.0
     DGS%XRNC_ICE =0.0
     DGS%XHC     = 0.0
     DGS%XHC_ICE  =0.0
     DGS%XLEC    = 0.0
     DGS%XLEC_ICE= 0.0
     DGS%XGFLUXC = 0.0
     DGS%XGFLUXC_ICE=0.0
     DGS%XEVAPC  = 0.0
     DGS%XSUBLC  = 0.0
     DGS%XSWDC   = 0.0
     DGS%XSWUC   = 0.0
     DGS%XSWUC_ICE=0.0
     DGS%XLWDC   = 0.0
     DGS%XLWUC   = 0.0
     DGS%XLWUC_ICE=0.0
     DGS%XFMUC   = 0.0
     DGS%XFMUC_ICE=0.0
     DGS%XFMVC   = 0.0
     DGS%XFMVC_ICE=0.0
  ELSEIF (DGU%LREAD_BUDGETC.AND.DGS%LRESET_BUDGETC) THEN
     DGS%XRNC    = 0.0
     DGS%XRNC_ICE= 0.0
     DGS%XHC     = 0.0
     DGS%XHC_ICE = 0.0
     DGS%XLEC    = 0.0
     DGS%XLEC_ICE= 0.0
     DGS%XGFLUXC = 0.0
     DGS%XGFLUXC_ICE=0.0
     DGS%XEVAPC  = 0.0
     DGS%XSUBLC  = 0.0     
     DGS%XSWDC   = 0.0
     DGS%XSWUC   = 0.0
     DGS%XSWUC_ICE=0.0
     DGS%XLWDC   = 0.0
     DGS%XLWUC   = 0.0
     DGS%XLWUC_ICE=0.0
     DGS%XFMUC   = 0.0
     DGS%XFMUC_ICE=0.0
     DGS%XFMVC   = 0.0
     DGS%XFMVC_ICE=0.0
  ELSE
     CALL READ_SURF(&
                    HPROGRAM,'VERSION',IVERSION,IRESP)    
     YREC='RNC_SEA'
     CALL READ_SURF(&
                    HPROGRAM,YREC,DGS%XRNC,IRESP)
     YREC='HC_SEA'
     CALL READ_SURF(&
                    HPROGRAM,YREC,DGS%XHC ,IRESP)
     YREC='LEC_SEA'
     CALL READ_SURF(&
                    HPROGRAM,YREC,DGS%XLEC,IRESP)
     YREC='LEIC_SEA'
     CALL READ_SURF(&
                    HPROGRAM,YREC,DGS%XLEC_ICE,IRESP) 
     YREC='GFLUXC_SEA'
     CALL READ_SURF(&
                    HPROGRAM,YREC,DGS%XGFLUXC ,IRESP)
     YREC='SWDC_SEA'
     CALL READ_SURF(&
                    HPROGRAM,YREC,DGS%XSWDC,IRESP)
     YREC='SWUC_SEA'
     CALL READ_SURF(&
                    HPROGRAM,YREC,DGS%XSWUC,IRESP)
     YREC='LWDC_SEA'
     CALL READ_SURF(&
                    HPROGRAM,YREC,DGS%XLWDC,IRESP)
     YREC='LWUC_SEA'
     CALL READ_SURF(&
                    HPROGRAM,YREC,DGS%XLWUC,IRESP)
     YREC='FMUC_SEA'
     CALL READ_SURF(&
                    HPROGRAM,YREC,DGS%XFMUC,IRESP)
     YREC='FMVC_SEA'
     CALL READ_SURF(&
                    HPROGRAM,YREC,DGS%XFMVC,IRESP)
     IF (IVERSION<8)THEN
        DGS%XEVAPC      = 0.0
        DGS%XSUBLC      = 0.0              
     ELSE
        !
        YREC='EVAPC_SEA'
        CALL READ_SURF(&
                    HPROGRAM,YREC,DGS%XEVAPC,IRESP)
        YREC='SUBLC_SEA'
        CALL READ_SURF(&
                    HPROGRAM,YREC,DGS%XSUBLC,IRESP)
     ENDIF
     DGS%XRNC_ICE    = 0.0
     DGS%XHC_ICE     = 0.0
     DGS%XGFLUXC_ICE = 0.0
     DGS%XSWUC_ICE   = 0.0
     DGS%XLWUC_ICE   = 0.0
     DGS%XFMUC_ICE   = 0.0
     DGS%XFMVC_ICE   = 0.0
  ENDIF   
ELSE
  ALLOCATE(DGS%XRNC    (0))
  ALLOCATE(DGS%XRNC_ICE(0))
  ALLOCATE(DGS%XHC     (0))
  ALLOCATE(DGS%XHC_ICE (0))
  ALLOCATE(DGS%XLEC    (0))
  ALLOCATE(DGS%XLEC_ICE(0))
  ALLOCATE(DGS%XGFLUXC (0))
  ALLOCATE(DGS%XGFLUXC_ICE(0))
  ALLOCATE(DGS%XEVAPC  (0))
  ALLOCATE(DGS%XSUBLC  (0))  
  ALLOCATE(DGS%XSWDC   (0))
  ALLOCATE(DGS%XSWUC   (0))
  ALLOCATE(DGS%XSWUC_ICE(0))
  ALLOCATE(DGS%XLWDC   (0))
  ALLOCATE(DGS%XLWUC   (0))
  ALLOCATE(DGS%XLWUC_ICE(0))
  ALLOCATE(DGS%XFMUC   (0))
  ALLOCATE(DGS%XFMUC_ICE(0))
  ALLOCATE(DGS%XFMVC   (0))
  ALLOCATE(DGS%XFMVC_ICE(0))
ENDIF
!
!* parameters at 2m
!
IF (DGS%N2M>=1) THEN
  ALLOCATE(DGS%XRI      (KLU))
  ALLOCATE(DGS%XRI_ICE  (KLU))
  ALLOCATE(DGS%XT2M     (KLU))
  ALLOCATE(DGS%XT2M_ICE (KLU))
  ALLOCATE(DGS%XT2M_MIN (KLU))
  ALLOCATE(DGS%XT2M_MAX (KLU))
  ALLOCATE(DGS%XQ2M     (KLU))
  ALLOCATE(DGS%XQ2M_ICE (KLU))
  ALLOCATE(DGS%XHU2M    (KLU))
  ALLOCATE(DGS%XHU2M_ICE(KLU))
  ALLOCATE(DGS%XHU2M_MIN(KLU))
  ALLOCATE(DGS%XHU2M_MAX(KLU))
  ALLOCATE(DGS%XZON10M  (KLU))
  ALLOCATE(DGS%XZON10M_ICE(KLU))
  ALLOCATE(DGS%XMER10M  (KLU))
  ALLOCATE(DGS%XMER10M_ICE(KLU))
  ALLOCATE(DGS%XWIND10M (KLU))
  ALLOCATE(DGS%XWIND10M_ICE(KLU))
  ALLOCATE(DGS%XWIND10M_MAX(KLU))
  !
  DGS%XRI      = XUNDEF
  DGS%XRI_ICE  = XUNDEF
  DGS%XT2M     = XUNDEF
  DGS%XT2M_ICE = XUNDEF
  DGS%XT2M_MIN = XUNDEF
  DGS%XT2M_MAX = 0.0
  DGS%XQ2M     = XUNDEF
  DGS%XQ2M_ICE = XUNDEF
  DGS%XHU2M    = XUNDEF
  DGS%XHU2M_ICE= XUNDEF
  DGS%XHU2M_MIN= XUNDEF
  DGS%XHU2M_MAX=-XUNDEF
  DGS%XZON10M  = XUNDEF
  DGS%XZON10M_ICE=XUNDEF
  DGS%XMER10M  = XUNDEF
  DGS%XMER10M_ICE=XUNDEF
  DGS%XWIND10M = XUNDEF
  DGS%XWIND10M_ICE=XUNDEF
  DGS%XWIND10M_MAX = 0.0
ELSE
  ALLOCATE(DGS%XRI      (0))
  ALLOCATE(DGS%XRI_ICE  (0))
  ALLOCATE(DGS%XT2M     (0))
  ALLOCATE(DGS%XT2M_ICE (0))
  ALLOCATE(DGS%XT2M_MIN (0))
  ALLOCATE(DGS%XT2M_MAX (0))
  ALLOCATE(DGS%XQ2M     (0))
  ALLOCATE(DGS%XQ2M_ICE (0))
  ALLOCATE(DGS%XHU2M    (0))
  ALLOCATE(DGS%XHU2M_ICE(0))
  ALLOCATE(DGS%XHU2M_MIN(0))
  ALLOCATE(DGS%XHU2M_MAX(0))
  ALLOCATE(DGS%XZON10M  (0))
  ALLOCATE(DGS%XZON10M_ICE(0))
  ALLOCATE(DGS%XMER10M  (0))
  ALLOCATE(DGS%XMER10M_ICE(0))
  ALLOCATE(DGS%XWIND10M (0))
  ALLOCATE(DGS%XWIND10M_ICE(0))
  ALLOCATE(DGS%XWIND10M_MAX(0))
END IF
!
!* transfer coefficients
!
IF (DGS%LCOEF) THEN
  ALLOCATE(DGS%XCD     (KLU))
  ALLOCATE(DGS%XCD_ICE (KLU))
  ALLOCATE(DGS%XCH     (KLU))
  ALLOCATE(DGS%XCH_ICE (KLU))
  ALLOCATE(DGS%XCE     (KLU))
  ALLOCATE(DGS%XZ0     (KLU))
  ALLOCATE(DGS%XZ0_ICE (KLU))
  ALLOCATE(DGS%XZ0H    (KLU))
  ALLOCATE(DGS%XZ0H_ICE(KLU))
  !
  DGS%XCD      = XUNDEF
  DGS%XCD_ICE  = XUNDEF
  DGS%XCH      = XUNDEF
  DGS%XCH_ICE  = XUNDEF
  DGS%XCE      = XUNDEF
  DGS%XZ0      = XUNDEF
  DGS%XZ0_ICE  = XUNDEF
  DGS%XZ0H     = XUNDEF
  DGS%XZ0H_ICE = XUNDEF
ELSE
  ALLOCATE(DGS%XCD     (0))
  ALLOCATE(DGS%XCD_ICE (0))
  ALLOCATE(DGS%XCH     (0))
  ALLOCATE(DGS%XCH_ICE (0))
  ALLOCATE(DGS%XCE     (0))
  ALLOCATE(DGS%XZ0     (0))
  ALLOCATE(DGS%XZ0_ICE (0))
  ALLOCATE(DGS%XZ0H    (0))
  ALLOCATE(DGS%XZ0H_ICE(0))
END IF
!
!
!* surface humidity
!
IF (DGS%LSURF_VARS) THEN
  ALLOCATE(DGS%XQS     (KLU))
  ALLOCATE(DGS%XQS_ICE (KLU))
  !
  DGS%XQS      = XUNDEF
  DGS%XQS_ICE  = XUNDEF
ELSE
  ALLOCATE(DGS%XQS     (0))
  ALLOCATE(DGS%XQS_ICE (0))
END IF
!
!* ocean diag
!
IF (DGO%LDIAG_OCEAN) THEN
  ALLOCATE(DGO%XTOCMOY  (KLU))
  ALLOCATE(DGO%XSOCMOY  (KLU))
  ALLOCATE(DGO%XUOCMOY  (KLU))
  ALLOCATE(DGO%XVOCMOY  (KLU))
  ALLOCATE(DGO%XDOCMOY  (KLU))
  !
  DGO%XTOCMOY(:)=XUNDEF
  DGO%XSOCMOY(:)=XUNDEF
  DGO%XUOCMOY(:)=XUNDEF
  DGO%XVOCMOY(:)=XUNDEF
  DGO%XDOCMOY(:)=XUNDEF
ELSE
  ALLOCATE(DGO%XTOCMOY  (0))
  ALLOCATE(DGO%XSOCMOY  (0))
  ALLOCATE(DGO%XUOCMOY  (0))
  ALLOCATE(DGO%XVOCMOY  (0))
  ALLOCATE(DGO%XDOCMOY  (0))
ENDIF
!
!* Seaice model diagnostics init 
!
IF (DGSI%LDIAG_SEAICE) THEN
  ALLOCATE(DGSI%XSIT(KLU))
  DGSI%XSIT=XUNDEF
  ALLOCATE(DGSI%XSND(KLU))
  DGSI%XSND=XUNDEF
  ALLOCATE(DGSI%XMLT(KLU))
  DGSI%XMLT=XUNDEF
ELSE
  ALLOCATE(DGSI%XSIT  (0))
  ALLOCATE(DGSI%XSND  (0))
  ALLOCATE(DGSI%XMLT  (0))
ENDIF
!
!* Earth system model coupling variables
!
IF(LCPL_SEA.OR.S%LHANDLE_SIC)THEN
!        
  ALLOCATE(S%XCPL_SEA_WIND(KLU))
  ALLOCATE(S%XCPL_SEA_FWSU(KLU))
  ALLOCATE(S%XCPL_SEA_FWSV(KLU))
  ALLOCATE(S%XCPL_SEA_SNET(KLU))
  ALLOCATE(S%XCPL_SEA_HEAT(KLU))
  ALLOCATE(S%XCPL_SEA_EVAP(KLU))
  ALLOCATE(S%XCPL_SEA_RAIN(KLU))
  ALLOCATE(S%XCPL_SEA_SNOW(KLU))
  ALLOCATE(S%XCPL_SEA_FWSM(KLU))
  S%XCPL_SEA_WIND(:) = 0.0
  S%XCPL_SEA_FWSU(:) = 0.0
  S%XCPL_SEA_FWSV(:) = 0.0
  S%XCPL_SEA_SNET(:) = 0.0
  S%XCPL_SEA_HEAT(:) = 0.0
  S%XCPL_SEA_EVAP(:) = 0.0
  S%XCPL_SEA_RAIN(:) = 0.0
  S%XCPL_SEA_SNOW(:) = 0.0
  S%XCPL_SEA_FWSM(:) = 0.0
!
ELSE
  ALLOCATE(S%XCPL_SEA_WIND(0))
  ALLOCATE(S%XCPL_SEA_FWSU(0))
  ALLOCATE(S%XCPL_SEA_FWSV(0))
  ALLOCATE(S%XCPL_SEA_SNET(0))
  ALLOCATE(S%XCPL_SEA_HEAT(0))
  ALLOCATE(S%XCPL_SEA_EVAP(0))
  ALLOCATE(S%XCPL_SEA_RAIN(0))
  ALLOCATE(S%XCPL_SEA_SNOW(0))
  ALLOCATE(S%XCPL_SEA_FWSM(0))
ENDIF
!
IF(LCPL_SEAICE.OR.S%LHANDLE_SIC)THEN
  ALLOCATE(S%XCPL_SEAICE_SNET(KLU))
  ALLOCATE(S%XCPL_SEAICE_HEAT(KLU))
  ALLOCATE(S%XCPL_SEAICE_EVAP(KLU))
  S%XCPL_SEAICE_SNET(:) = 0.0
  S%XCPL_SEAICE_HEAT(:) = 0.0
  S%XCPL_SEAICE_EVAP(:) = 0.0
ELSE
  ALLOCATE(S%XCPL_SEAICE_SNET(0))
  ALLOCATE(S%XCPL_SEAICE_HEAT(0))
  ALLOCATE(S%XCPL_SEAICE_EVAP(0))        
ENDIF
!
IF (LHOOK) CALL DR_HOOK('DIAG_SEAFLUX_INIT_N',1,ZHOOK_HANDLE)
!
!-------------------------------------------------------------------------------
!
END SUBROUTINE DIAG_SEAFLUX_INIT_n
