!     ######spl
      SUBROUTINE DIAG_MISC_TEB_INIT_n (DGCT, DGMT, DGMTO, TOP, &
                                       HPROGRAM,KLU,KSW)
!     #####################
!
!!****  *DIAG_MISC_TEB_INIT_n* - routine to initialize TEB diagnostic variables
!!
!!    PURPOSE
!!    -------
!!
!!**  METHOD
!!    ------
!!
!!    EXTERNAL
!!    --------
!!
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!
!!    AUTHOR
!!    ------
!!      V. Masson   *Meteo France*
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    01/2004 
!-------------------------------------------------------------------------------
!
!*       0.    DECLARATIONS
!              ------------
!
!
USE MODD_DIAG_CUMUL_TEB_n, ONLY : DIAG_CUMUL_TEB_t
USE MODD_DIAG_MISC_TEB_n, ONLY : DIAG_MISC_TEB_t
USE MODD_DIAG_MISC_TEB_OPTION_n, ONLY : DIAG_MISC_TEB_OPTIONS_t
USE MODD_TEB_OPTION_n, ONLY : TEB_OPTIONS_t
!
USE MODD_SURF_PAR,   ONLY : XUNDEF
USE MODD_TYPE_DATE_SURF
!


!
USE MODI_READ_SURF
!
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*       0.1   Declarations of arguments
!              -------------------------
!
!
TYPE(DIAG_CUMUL_TEB_t), INTENT(INOUT) :: DGCT
TYPE(DIAG_MISC_TEB_t), INTENT(INOUT) :: DGMT
TYPE(DIAG_MISC_TEB_OPTIONS_t), INTENT(INOUT) :: DGMTO
TYPE(TEB_OPTIONS_t), INTENT(INOUT) :: TOP
!
INTEGER, INTENT(IN) :: KLU   ! size of arrays
INTEGER, INTENT(IN) :: KSW   ! spectral bands
 CHARACTER(LEN=6), INTENT(IN):: HPROGRAM  ! program calling
!
!*       0.2   Declarations of local variables
!              -------------------------------
!
INTEGER           :: IRESP          ! IRESP  : return-code if a problem appears
 CHARACTER(LEN=12) :: YREC           ! Name of the article to be read
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!-------------------------------------------------------------------------------
!
!* surface energy budget
!
IF (LHOOK) CALL DR_HOOK('DIAG_MISC_TEB_INIT_N',0,ZHOOK_HANDLE)
!
!* miscellaneous fields
!
IF (DGMTO%LSURF_MISC_BUDGET) THEN
  ALLOCATE(DGMT%CUR%XQF_BLD           (KLU))
  ALLOCATE(DGMT%CUR%XFLX_BLD          (KLU))
  ALLOCATE(DGMT%CUR%XQF_TOWN          (KLU))
  ALLOCATE(DGMT%CUR%XDQS_TOWN         (KLU))
  ALLOCATE(DGMT%CUR%XRN_ROAD          (KLU))
  ALLOCATE(DGMT%CUR%XH_ROAD           (KLU))
  ALLOCATE(DGMT%CUR%XLE_ROAD          (KLU))
  ALLOCATE(DGMT%CUR%XGFLUX_ROAD       (KLU))
  ALLOCATE(DGMT%CUR%XRN_WALL_A        (KLU))
  ALLOCATE(DGMT%CUR%XH_WALL_A         (KLU))
  ALLOCATE(DGMT%CUR%XGFLUX_WALL_A     (KLU))
  ALLOCATE(DGMT%CUR%XRN_WALL_B        (KLU))
  ALLOCATE(DGMT%CUR%XH_WALL_B         (KLU))
  ALLOCATE(DGMT%CUR%XGFLUX_WALL_B     (KLU))
  ALLOCATE(DGMT%CUR%XRN_ROOF          (KLU))
  ALLOCATE(DGMT%CUR%XH_ROOF           (KLU))
  ALLOCATE(DGMT%CUR%XLE_ROOF          (KLU))
  ALLOCATE(DGMT%CUR%XGFLUX_ROOF       (KLU))
  ALLOCATE(DGMT%CUR%XRN_GARDEN        (KLU))
  ALLOCATE(DGMT%CUR%XH_GARDEN         (KLU))
  ALLOCATE(DGMT%CUR%XLE_GARDEN        (KLU))
  ALLOCATE(DGMT%CUR%XGFLUX_GARDEN     (KLU))
  ALLOCATE(DGMT%CUR%XRN_BLT           (KLU))
  ALLOCATE(DGMT%CUR%XH_BLT            (KLU))
  ALLOCATE(DGMT%CUR%XLE_BLT           (KLU))
  ALLOCATE(DGMT%CUR%XGFLUX_BLT        (KLU))
  ALLOCATE(DGMT%CUR%XRN_STRLROOF      (KLU))
  ALLOCATE(DGMT%CUR%XH_STRLROOF       (KLU))
  ALLOCATE(DGMT%CUR%XLE_STRLROOF      (KLU))
  ALLOCATE(DGMT%CUR%XGFLUX_STRLROOF   (KLU))
  ALLOCATE(DGMT%CUR%XRN_GREENROOF     (KLU))
  ALLOCATE(DGMT%CUR%XH_GREENROOF      (KLU))
  ALLOCATE(DGMT%CUR%XLE_GREENROOF     (KLU))
  ALLOCATE(DGMT%CUR%XGFLUX_GREENROOF  (KLU))
  ALLOCATE(DGMT%CUR%XG_GREENROOF_ROOF (KLU))
  ALLOCATE(DGMT%CUR%XRUNOFF_TOWN      (KLU))
  ALLOCATE(DGMT%CUR%XRUNOFF_GARDEN    (KLU))
  ALLOCATE(DGMT%CUR%XRUNOFF_ROAD      (KLU))
  ALLOCATE(DGMT%CUR%XRUNOFF_STRLROOF  (KLU))
  ALLOCATE(DGMT%CUR%XRUNOFF_ROOF      (KLU))
  ALLOCATE(DGMT%CUR%XRUNOFF_GREENROOF (KLU))
  ALLOCATE(DGMT%CUR%XDRAIN_GREENROOF  (KLU))
  ALLOCATE(DGMT%CUR%XDRAIN_GARDEN     (KLU))
  ALLOCATE(DGMT%CUR%XIRRIG_GREENROOF  (KLU))
  ALLOCATE(DGMT%CUR%XIRRIG_GARDEN     (KLU))
  ALLOCATE(DGMT%CUR%XIRRIG_ROAD       (KLU))
  !
  ALLOCATE(DGMT%CUR%XABS_SW_ROOF      (KLU))
  ALLOCATE(DGMT%CUR%XABS_SW_SNOW_ROOF (KLU))
  ALLOCATE(DGMT%CUR%XABS_LW_ROOF      (KLU))
  ALLOCATE(DGMT%CUR%XABS_LW_SNOW_ROOF (KLU))
  ALLOCATE(DGMT%CUR%XABS_SW_ROAD      (KLU))
  ALLOCATE(DGMT%CUR%XABS_SW_SNOW_ROAD (KLU))
  ALLOCATE(DGMT%CUR%XABS_LW_ROAD      (KLU))
  ALLOCATE(DGMT%CUR%XABS_LW_SNOW_ROAD (KLU))
  ALLOCATE(DGMT%CUR%XABS_SW_WALL_A    (KLU))
  ALLOCATE(DGMT%CUR%XABS_SW_WALL_B    (KLU))
  ALLOCATE(DGMT%CUR%XABS_LW_WALL_A    (KLU))
  ALLOCATE(DGMT%CUR%XABS_LW_WALL_B    (KLU))
  ALLOCATE(DGMT%CUR%XABS_SW_GARDEN    (KLU))
  ALLOCATE(DGMT%CUR%XABS_LW_GARDEN    (KLU))
  ALLOCATE(DGMT%CUR%XABS_SW_GREENROOF (KLU))
  ALLOCATE(DGMT%CUR%XABS_LW_GREENROOF (KLU))
  !
  ALLOCATE(DGMT%CUR%XREF_SW_FAC       (KLU))  
  ALLOCATE(DGMT%CUR%XREF_SW_GRND      (KLU))
  !
  ALLOCATE(DGMT%CUR%XEMIT_LW_FAC      (KLU))
  ALLOCATE(DGMT%CUR%XEMIT_LW_GRND     (KLU))
  !
  ALLOCATE(DGMT%CUR%XTCOOL_CUR_TARGET (KLU))
  ALLOCATE(DGMT%CUR%XTHEAT_CUR_TARGET (KLU))
  ALLOCATE(DGMT%CUR%XCUR_QIN          (KLU))
  !
  IF (TOP%CBEM=='BEM') THEN
    ALLOCATE(DGMT%CUR%XH_BLD_COOL    (KLU))
    ALLOCATE(DGMT%CUR%XT_BLD_COOL    (KLU))
    ALLOCATE(DGMT%CUR%XH_BLD_HEAT    (KLU))
    ALLOCATE(DGMT%CUR%XLE_BLD_COOL   (KLU))
    ALLOCATE(DGMT%CUR%XLE_BLD_HEAT   (KLU))
    ALLOCATE(DGMT%CUR%XH_WASTE       (KLU))
    ALLOCATE(DGMT%CUR%XLE_WASTE      (KLU))
    ALLOCATE(DGMT%CUR%XHVAC_COOL     (KLU))
    ALLOCATE(DGMT%CUR%XHVAC_HEAT     (KLU))
    ALLOCATE(DGMT%CUR%XCAP_SYS       (KLU))
    ALLOCATE(DGMT%CUR%XM_SYS         (KLU))
    ALLOCATE(DGMT%CUR%XCOP           (KLU))
    ALLOCATE(DGMT%CUR%XQ_SYS         (KLU))
    ALLOCATE(DGMT%CUR%XT_SYS         (KLU))
    ALLOCATE(DGMT%CUR%XTR_SW_WIN     (KLU))
    ALLOCATE(DGMT%CUR%XFAN_POWER     (KLU))
    ALLOCATE(DGMT%CUR%XT_RAD_IND     (KLU))
    ALLOCATE(DGMT%CUR%XHU_BLD        (KLU))
    ALLOCATE(DGMT%CUR%XABS_SW_WIN    (KLU)) 
    ALLOCATE(DGMT%CUR%XABS_LW_WIN    (KLU))    
  ENDIF
  !
  IF (TOP%LSOLAR_PANEL) THEN
    ALLOCATE(DGMT%CUR%XABS_SW_PANEL   (KLU))
    ALLOCATE(DGMT%CUR%XABS_LW_PANEL   (KLU))
    ALLOCATE(DGMT%CUR%XRN_PANEL       (KLU))
    ALLOCATE(DGMT%CUR%XH_PANEL        (KLU))
    ALLOCATE(DGMT%CUR%XTHER_PROD_PANEL(KLU))
    ALLOCATE(DGMT%CUR%XPHOT_PROD_PANEL(KLU))
    ALLOCATE(DGMT%CUR%XPROD_PANEL     (KLU))
    ALLOCATE(DGMT%CUR%XTHER_PROD_BLD  (KLU))
    ALLOCATE(DGMT%CUR%XPHOT_PROD_BLD  (KLU))
  END IF
  !
    ALLOCATE(DGCT%CUR%XRUNOFFC_TOWN      (KLU))
    ALLOCATE(DGCT%CUR%XRUNOFFC_GARDEN    (KLU))
    ALLOCATE(DGCT%CUR%XDRAINC_GARDEN     (KLU))
    ALLOCATE(DGCT%CUR%XIRRIGC_GARDEN     (KLU))
    ALLOCATE(DGCT%CUR%XRUNOFFC_ROAD      (KLU))
    ALLOCATE(DGCT%CUR%XIRRIGC_ROAD       (KLU))
    ALLOCATE(DGCT%CUR%XRUNOFFC_STRLROOF  (KLU))
    ALLOCATE(DGCT%CUR%XRUNOFFC_ROOF      (KLU))
    ALLOCATE(DGCT%CUR%XRUNOFFC_GREENROOF (KLU))
    ALLOCATE(DGCT%CUR%XDRAINC_GREENROOF  (KLU))
    ALLOCATE(DGCT%CUR%XIRRIGC_GREENROOF  (KLU))
    IF (TOP%CBEM=='BEM') THEN
      ALLOCATE(DGCT%CUR%XHVACC_COOL       (KLU))
      ALLOCATE(DGCT%CUR%XHVACC_HEAT       (KLU))
    END IF
  IF (TOP%LSOLAR_PANEL) THEN
    ALLOCATE(DGCT%CUR%XTHER_PROD_BLDC(KLU))
    ALLOCATE(DGCT%CUR%XPHOT_PROD_BLDC(KLU))
  END IF
  DGMT%CUR%XQF_BLD            = XUNDEF
  DGMT%CUR%XFLX_BLD           = XUNDEF
  DGMT%CUR%XQF_TOWN           = XUNDEF
  DGMT%CUR%XDQS_TOWN          = XUNDEF
  DGMT%CUR%XRN_ROAD           = XUNDEF
  DGMT%CUR%XH_ROAD            = XUNDEF
  DGMT%CUR%XLE_ROAD           = XUNDEF
  DGMT%CUR%XGFLUX_ROAD        = XUNDEF
  DGMT%CUR%XRN_WALL_A         = XUNDEF
  DGMT%CUR%XH_WALL_A          = XUNDEF
  DGMT%CUR%XGFLUX_WALL_A      = XUNDEF
  DGMT%CUR%XRN_WALL_B         = XUNDEF
  DGMT%CUR%XH_WALL_B          = XUNDEF
  DGMT%CUR%XGFLUX_WALL_B      = XUNDEF
  DGMT%CUR%XRN_ROOF           = XUNDEF
  DGMT%CUR%XH_ROOF            = XUNDEF
  DGMT%CUR%XLE_ROOF           = XUNDEF
  DGMT%CUR%XGFLUX_ROOF        = XUNDEF 
  DGMT%CUR%XRN_GARDEN         = XUNDEF
  DGMT%CUR%XH_GARDEN          = XUNDEF
  DGMT%CUR%XLE_GARDEN         = XUNDEF
  DGMT%CUR%XGFLUX_GARDEN      = XUNDEF  
  DGMT%CUR%XRN_BLT            = XUNDEF
  DGMT%CUR%XH_BLT             = XUNDEF
  DGMT%CUR%XLE_BLT            = XUNDEF
  DGMT%CUR%XGFLUX_BLT         = XUNDEF  
  DGMT%CUR%XRN_STRLROOF       = XUNDEF
  DGMT%CUR%XH_STRLROOF        = XUNDEF
  DGMT%CUR%XLE_STRLROOF       = XUNDEF
  DGMT%CUR%XGFLUX_STRLROOF    = XUNDEF  
  DGMT%CUR%XRN_GREENROOF      = XUNDEF
  DGMT%CUR%XH_GREENROOF       = XUNDEF
  DGMT%CUR%XLE_GREENROOF      = XUNDEF
  DGMT%CUR%XGFLUX_GREENROOF   = XUNDEF  
  DGMT%CUR%XG_GREENROOF_ROOF  = XUNDEF  
  DGMT%CUR%XRUNOFF_TOWN       = XUNDEF  
  DGMT%CUR%XRUNOFF_GARDEN     = XUNDEF  
  DGMT%CUR%XRUNOFF_ROAD       = XUNDEF  
  DGMT%CUR%XRUNOFF_ROOF       = XUNDEF  
  DGMT%CUR%XRUNOFF_STRLROOF   = XUNDEF
  DGMT%CUR%XRUNOFF_GREENROOF  = XUNDEF  
  DGMT%CUR%XDRAIN_GREENROOF   = XUNDEF  
  DGMT%CUR%XDRAIN_GARDEN      = XUNDEF  
  DGMT%CUR%XIRRIG_GREENROOF   = XUNDEF  
  DGMT%CUR%XIRRIG_GARDEN      = XUNDEF  
  DGMT%CUR%XIRRIG_ROAD        = XUNDEF  
!
  DGMT%CUR%XABS_SW_ROOF       = XUNDEF  
  DGMT%CUR%XABS_SW_SNOW_ROOF  = XUNDEF  
  DGMT%CUR%XABS_LW_ROOF       = XUNDEF  
  DGMT%CUR%XABS_LW_SNOW_ROOF  = XUNDEF  
  DGMT%CUR%XABS_SW_ROAD       = XUNDEF  
  DGMT%CUR%XABS_SW_SNOW_ROAD  = XUNDEF  
  DGMT%CUR%XABS_LW_ROAD       = XUNDEF  
  DGMT%CUR%XABS_LW_SNOW_ROAD  = XUNDEF  
  DGMT%CUR%XABS_SW_WALL_A     = XUNDEF  
  DGMT%CUR%XABS_SW_WALL_B     = XUNDEF  
  DGMT%CUR%XABS_LW_WALL_A     = XUNDEF  
  DGMT%CUR%XABS_LW_WALL_B     = XUNDEF  
  DGMT%CUR%XABS_SW_GARDEN     = XUNDEF  
  DGMT%CUR%XABS_LW_GARDEN     = XUNDEF 
  DGMT%CUR%XABS_SW_GREENROOF  = XUNDEF  
  DGMT%CUR%XABS_LW_GREENROOF  = XUNDEF 
  !
  DGMT%CUR%XREF_SW_FAC        = XUNDEF
  DGMT%CUR%XREF_SW_GRND       = XUNDEF
  !
  DGMT%CUR%XEMIT_LW_FAC       = XUNDEF
  DGMT%CUR%XEMIT_LW_GRND      = XUNDEF
  !
  DGMT%CUR%XTCOOL_CUR_TARGET  = XUNDEF
  DGMT%CUR%XTHEAT_CUR_TARGET  = XUNDEF
  DGMT%CUR%XCUR_QIN           = XUNDEF
  !
  IF (TOP%CBEM=='BEM') THEN
    DGMT%CUR%XH_BLD_COOL     = XUNDEF
    DGMT%CUR%XT_BLD_COOL     = XUNDEF
    DGMT%CUR%XH_BLD_HEAT     = XUNDEF
    DGMT%CUR%XLE_BLD_COOL    = XUNDEF
    DGMT%CUR%XLE_BLD_HEAT    = XUNDEF
    DGMT%CUR%XH_WASTE        = XUNDEF
    DGMT%CUR%XLE_WASTE       = XUNDEF
    DGMT%CUR%XHVAC_COOL      = XUNDEF
    DGMT%CUR%XHVAC_HEAT      = XUNDEF
    DGMT%CUR%XCAP_SYS        = XUNDEF
    DGMT%CUR%XM_SYS          = XUNDEF
    DGMT%CUR%XCOP            = XUNDEF
    DGMT%CUR%XQ_SYS          = XUNDEF
    DGMT%CUR%XT_SYS          = XUNDEF
    DGMT%CUR%XTR_SW_WIN      = XUNDEF
    DGMT%CUR%XFAN_POWER      = XUNDEF
    DGMT%CUR%XT_RAD_IND      = XUNDEF
    DGMT%CUR%XHU_BLD         = XUNDEF
    DGMT%CUR%XABS_SW_WIN     = XUNDEF 
    DGMT%CUR%XABS_LW_WIN     = XUNDEF    
  ENDIF

  IF (TOP%LSOLAR_PANEL) THEN
    DGMT%CUR%XABS_SW_PANEL   = XUNDEF
    DGMT%CUR%XABS_LW_PANEL   = XUNDEF
    DGMT%CUR%XRN_PANEL       = XUNDEF
    DGMT%CUR%XH_PANEL        = XUNDEF
    DGMT%CUR%XTHER_PROD_PANEL= XUNDEF
    DGMT%CUR%XPHOT_PROD_PANEL= XUNDEF
    DGMT%CUR%XPROD_PANEL     = XUNDEF
    DGMT%CUR%XTHER_PROD_BLD  = XUNDEF
    DGMT%CUR%XPHOT_PROD_BLD  = XUNDEF
  END IF
!  
    DGCT%CUR%XRUNOFFC_TOWN       = 0.0  
    DGCT%CUR%XRUNOFFC_GARDEN     = 0.0  
    DGCT%CUR%XRUNOFFC_ROAD       = 0.0  
    DGCT%CUR%XRUNOFFC_ROOF       = 0.0  
    DGCT%CUR%XRUNOFFC_STRLROOF   = 0.0  
    DGCT%CUR%XRUNOFFC_GREENROOF  = 0.0  
    DGCT%CUR%XDRAINC_GREENROOF   = 0.0  
    DGCT%CUR%XDRAINC_GARDEN      = 0.0  
    DGCT%CUR%XIRRIGC_GREENROOF   = 0.0  
    DGCT%CUR%XIRRIGC_GARDEN      = 0.0  
    DGCT%CUR%XIRRIGC_ROAD        = 0.0  
    IF (TOP%CBEM=='BEM') THEN
      DGCT%CUR%XHVACC_COOL       = 0.0
      DGCT%CUR%XHVACC_HEAT       = 0.0
    END IF
  IF (TOP%LSOLAR_PANEL) THEN
    DGCT%CUR%XTHER_PROD_BLDC = 0.
    DGCT%CUR%XPHOT_PROD_BLDC = 0.
  END IF
ENDIF
!
IF (LHOOK) CALL DR_HOOK('DIAG_MISC_TEB_INIT_N',1,ZHOOK_HANDLE)
!
!-------------------------------------------------------------------------------
!
END SUBROUTINE DIAG_MISC_TEB_INIT_n
