!     #########
SUBROUTINE DIAG_IDEAL_n (DGL, &
                         HPROGRAM, PQS, PZ0, PZ0H, PH, PLE, PRN, PGFLUX)
!     ###############################################################################
!
!!****  *DIAG_IDEAL_n * - Stores IDEAL_n diagnostics
!!
!!    PURPOSE
!!    -------
!
!!**  METHOD
!!    ------
!!
!!    REFERENCE
!!    ---------
!!      
!!
!!    AUTHOR
!!    ------
!!     P. Le Moigne 
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    04/2009
!!------------------------------------------------------------------
!

!
!
USE MODD_DIAG_IDEAL_n, ONLY : DIAG_IDEAL_t
!
USE MODD_SURF_PAR,    ONLY : XUNDEF
!
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*      0.1    declarations of arguments
!
!
TYPE(DIAG_IDEAL_t), INTENT(INOUT) :: DGL
!
 CHARACTER(LEN=6),   INTENT(IN)  :: HPROGRAM ! program calling surf. schemes
!
REAL, DIMENSION(:), INTENT(OUT) :: PQS
REAL, DIMENSION(:), INTENT(OUT) :: PZ0      ! rough. length wind  (m)
REAL, DIMENSION(:), INTENT(OUT) :: PZ0H     ! rough. length heat  (m)
REAL, DIMENSION(:), INTENT(OUT) :: PH       ! Sensible heat flux  (W/m2)
REAL, DIMENSION(:), INTENT(OUT) :: PLE      ! Latent heat flux    (W/m2)
REAL, DIMENSION(:), INTENT(OUT) :: PRN      ! net flux    (W/m2)
REAL, DIMENSION(:), INTENT(OUT) :: PGFLUX   ! net flux    (W/m2)
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!
!*      0.2    declarations of local variables
!
!-------------------------------------------------------------------------------------
!
IF (LHOOK) CALL DR_HOOK('DIAG_IDEAL_N',0,ZHOOK_HANDLE)
!
IF (DGL%LSURF_BUDGET) THEN
  PH       = DGL%XH
  PLE      = DGL%XLE
  PRN      = DGL%XRN
  PGFLUX   = DGL%XGFLUX
END IF
!
IF (DGL%LCOEF) THEN
  PZ0  = DGL%XZ0
  PZ0H = DGL%XZ0H
ENDIF
!
IF (DGL%LSURF_VARS) THEN
  PQS = DGL%XQS
ENDIF
!
IF (LHOOK) CALL DR_HOOK('DIAG_IDEAL_N',1,ZHOOK_HANDLE)
!
!-------------------------------------------------------------------------------------
!
END SUBROUTINE DIAG_IDEAL_n
