!     #########
SUBROUTINE DIAG_EVAP_ISBA_n (DGEI, DGI, I, PKDI, PKI, &
                             HPHOTO,PTSTEP,KMASK,KSIZE,KPATCH,PRHOA)
!     ###############################################################################
!
!!****  *DIAG_EVAP-ISBA_n * - additional diagnostics for ISBA
!!
!!    PURPOSE
!!    -------
!
!!**  METHOD
!!    ------
!!
!!    REFERENCE
!!    ---------
!!      
!!
!!    AUTHOR
!!    ------
!!     P. LeMoigne 
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    01/2004
!!                     2008      New diag
!!      B. Decharme    2012      New snow diag LESL
!!                               Add carbon fluxes diag
!!                               Add isba water budget diag
!!      B. Decharme  04/2013     add Subsurface runoff if SGH (DIF option only) 
!!                               add sublimation
!!      P Samuelsson   04/2012   MEB
!!------------------------------------------------------------------
!
!

!
!
!
!
USE MODD_DIAG_EVAP_ISBA_n, ONLY : DIAG_EVAP_ISBA_t
USE MODD_DIAG_ISBA_n, ONLY : DIAG_ISBA_t
USE MODD_ISBA_n, ONLY : ISBA_t
USE MODD_PACK_DIAG_ISBA, ONLY : PACK_DIAG_ISBA_t
USE MODD_PACK_ISBA, ONLY : PACK_ISBA_t
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*      0.1    declarations of arguments
!
!
TYPE(DIAG_EVAP_ISBA_t), INTENT(INOUT) :: DGEI
TYPE(DIAG_ISBA_t), INTENT(INOUT) :: DGI
TYPE(ISBA_t), INTENT(INOUT) :: I
TYPE(PACK_DIAG_ISBA_t), INTENT(INOUT) :: PKDI
TYPE(PACK_ISBA_t), INTENT(INOUT) :: PKI
!
 CHARACTER(LEN=*), INTENT(IN)      :: HPHOTO        ! type of photosynthesis
REAL,    INTENT(IN)               :: PTSTEP        ! time step
INTEGER, INTENT(IN)               :: KSIZE, KPATCH   
!
INTEGER, DIMENSION(:), INTENT(IN) :: KMASK
REAL,    DIMENSION(:), INTENT(IN) :: PRHOA         ! air density for unit change
!
INTEGER :: JJ
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!*      0.2    declarations of local variables
!
!-------------------------------------------------------------------------------------
!
IF (LHOOK) CALL DR_HOOK('DIAG_EVAP_ISBA_N',0,ZHOOK_HANDLE)
!
IF (DGEI%LSURF_EVAP_BUDGET) THEN
!cdir nodep
  DO JJ=1,KSIZE
     !
     DGEI%XLEG       (KMASK(JJ), KPATCH)  =  PKDI%XP_LEG        (JJ)
     DGEI%XLEGI      (KMASK(JJ), KPATCH)  =  PKDI%XP_LEGI       (JJ)
     DGEI%XLEV       (KMASK(JJ), KPATCH)  =  PKDI%XP_LEV        (JJ)
     DGEI%XLES       (KMASK(JJ), KPATCH)  =  PKDI%XP_LES        (JJ)
     DGEI%XLER       (KMASK(JJ), KPATCH)  =  PKDI%XP_LER        (JJ)
     DGEI%XLETR      (KMASK(JJ), KPATCH)  =  PKDI%XP_LETR       (JJ)
     DGEI%XEVAP      (KMASK(JJ), KPATCH)  =  PKDI%XP_EVAP       (JJ)
     DGEI%XSUBL      (KMASK(JJ), KPATCH)  =  PKDI%XP_SUBL       (JJ)
     DGEI%XDRAIN     (KMASK(JJ), KPATCH)  =  PKDI%XP_DRAIN      (JJ)
     DGEI%XQSB       (KMASK(JJ), KPATCH)  =  PKDI%XP_QSB        (JJ)
     DGEI%XRUNOFF    (KMASK(JJ), KPATCH)  =  PKDI%XP_RUNOFF     (JJ)
     DGEI%XHORT      (KMASK(JJ), KPATCH)  =  PKDI%XP_HORT       (JJ)
     DGEI%XDRIP      (KMASK(JJ), KPATCH)  =  PKDI%XP_DRIP       (JJ)
     DGEI%XRRVEG     (KMASK(JJ), KPATCH)  =  PKDI%XP_RRVEG      (JJ)
     DGEI%XMELT      (KMASK(JJ), KPATCH)  =  PKDI%XP_MELT       (JJ)
     DGEI%XIFLOOD    (KMASK(JJ), KPATCH)  =  PKDI%XP_IFLOOD     (JJ)
     DGEI%XPFLOOD    (KMASK(JJ), KPATCH)  =  PKDI%XP_PFLOOD     (JJ)
     DGEI%XLE_FLOOD  (KMASK(JJ), KPATCH)  =  PKDI%XP_LE_FLOOD   (JJ)
     DGEI%XLEI_FLOOD (KMASK(JJ), KPATCH)  =  PKDI%XP_LEI_FLOOD  (JJ)
     DGEI%XIRRIG_FLUX(KMASK(JJ), KPATCH)  =  PKDI%XP_IRRIG_FLUX (JJ)
     !
     IF (I%LMEB_PATCH(KPATCH)) THEN
       DGEI%XLEVCV  (KMASK(JJ), KPATCH)  =  PKDI%XP_LEVCV    (JJ)
       DGEI%XLESC   (KMASK(JJ), KPATCH)  =  PKDI%XP_LESC     (JJ)
       DGEI%XLETRCV (KMASK(JJ), KPATCH)  =  PKDI%XP_LETRCV   (JJ)
       DGEI%XLELITTER (KMASK(JJ), KPATCH) = PKDI%XP_LELITTER (JJ)
       DGEI%XLELITTERI(KMASK(JJ), KPATCH) = PKDI%XP_LELITTERI(JJ)
       DGEI%XDRIPLIT  (KMASK(JJ), KPATCH) = PKDI%XP_DRIPLIT  (JJ)
       DGEI%XRRLIT  (KMASK(JJ), KPATCH)  =  PKDI%XP_RRLIT    (JJ)
       DGEI%XLERCV  (KMASK(JJ), KPATCH)  =  PKDI%XP_LERCV    (JJ)
       DGEI%XLE_C_A (KMASK(JJ), KPATCH)  =  PKDI%XP_LE_C_A   (JJ)
       DGEI%XLE_V_C (KMASK(JJ), KPATCH)  =  PKDI%XP_LE_V_C   (JJ)
       DGEI%XLE_G_C (KMASK(JJ), KPATCH)  =  PKDI%XP_LE_G_C   (JJ)
       DGEI%XLE_N_C (KMASK(JJ), KPATCH)  =  PKDI%XP_LE_N_C   (JJ)
       !
       DGEI%XSWNET_V    (KMASK(JJ), KPATCH)  =  PKDI%XP_SWNET_V    (JJ)
       DGEI%XSWNET_G    (KMASK(JJ), KPATCH)  =  PKDI%XP_SWNET_G    (JJ)
       DGEI%XSWNET_N    (KMASK(JJ), KPATCH)  =  PKDI%XP_SWNET_N    (JJ)
       DGEI%XSWNET_NS   (KMASK(JJ), KPATCH)  =  PKDI%XP_SWNET_NS   (JJ)
       DGEI%XLWNET_V    (KMASK(JJ), KPATCH)  =  PKDI%XP_LWNET_V    (JJ)
       DGEI%XLWNET_G    (KMASK(JJ), KPATCH)  =  PKDI%XP_LWNET_G    (JJ)
       DGEI%XLWNET_N    (KMASK(JJ), KPATCH)  =  PKDI%XP_LWNET_N    (JJ)
       DGEI%XSWDOWN_GN  (KMASK(JJ), KPATCH)  =  PKDI%XP_SWDOWN_GN  (JJ)
       DGEI%XLWDOWN_GN  (KMASK(JJ), KPATCH)  =  PKDI%XP_LWDOWN_GN  (JJ)
       DGEI%XH_V_C      (KMASK(JJ), KPATCH)  =  PKDI%XP_H_V_C      (JJ)
       DGEI%XH_G_C      (KMASK(JJ), KPATCH)  =  PKDI%XP_H_G_C      (JJ)
       DGEI%XH_C_A      (KMASK(JJ), KPATCH)  =  PKDI%XP_H_C_A      (JJ)
       DGEI%XH_N_C      (KMASK(JJ), KPATCH)  =  PKDI%XP_H_N_C      (JJ)
       DGEI%XSR_GN      (KMASK(JJ), KPATCH)  =  PKDI%XP_SR_GN      (JJ)
       DGEI%XMELTCV     (KMASK(JJ), KPATCH)  =  PKDI%XP_MELTCV     (JJ)
       DGEI%XFRZCV      (KMASK(JJ), KPATCH)  =  PKDI%XP_FRZCV      (JJ)
     ENDIF
     !
  END DO
  !
  IF (I%TSNOW%SCHEME=='3-L' .OR. I%TSNOW%SCHEME=='CRO') THEN
!cdir nodep
     DO JJ=1,KSIZE
        DGEI%XLESL    (KMASK(JJ), KPATCH)  =  PKDI%XP_LESL       (JJ)
        DGEI%XSNDRIFT (KMASK(JJ), KPATCH)  =  PKDI%XP_SNDRIFT    (JJ)
     END DO
  END IF
  !
  IF(HPHOTO/='NON')THEN
!cdir nodep
     DO JJ=1,KSIZE
        ! Transform units from kgCO2/kgair m/s to kgCO2/m2/s
        DGEI%XGPP       (KMASK(JJ), KPATCH)  =  PKDI%XP_GPP       (JJ) * PRHOA(JJ)
        DGEI%XRESP_AUTO (KMASK(JJ), KPATCH)  =  PKDI%XP_RESP_AUTO (JJ) * PRHOA(JJ)
        DGEI%XRESP_ECO  (KMASK(JJ), KPATCH)  =  PKDI%XP_RESP_ECO  (JJ) * PRHOA(JJ)
        !
     END DO
  ELSE  
     DGEI%XGPP      (:,:)=0.0
     DGEI%XRESP_AUTO(:,:)=0.0
     DGEI%XRESP_ECO (:,:)=0.0
  ENDIF
  !
  IF(DGEI%LWATER_BUDGET)THEN
!cdir nodep
     DO JJ=1,KSIZE
        DGEI%XDWG   (KMASK(JJ), KPATCH)  =  PKDI%XP_DWG   (JJ)
        DGEI%XDWGI  (KMASK(JJ), KPATCH)  =  PKDI%XP_DWGI  (JJ)
        DGEI%XDWR   (KMASK(JJ), KPATCH)  =  PKDI%XP_DWR   (JJ)
        DGEI%XDSWE  (KMASK(JJ), KPATCH)  =  PKDI%XP_DSWE  (JJ)
        DGEI%XWATBUD(KMASK(JJ), KPATCH)  =  PKDI%XP_WATBUD(JJ)
     END DO
  ENDIF
  !
END IF
!
IF (DGEI%LSURF_BUDGETC) THEN
!cdir nodep
  DO JJ=1,KSIZE
     !
     DGEI%XRNC        (KMASK(JJ), KPATCH)  =  DGEI%XRNC        (KMASK(JJ), KPATCH) + PKDI%XP_RN        (JJ) * PTSTEP
     DGEI%XHC         (KMASK(JJ), KPATCH)  =  DGEI%XHC         (KMASK(JJ), KPATCH) + PKDI%XP_H         (JJ) * PTSTEP
     DGEI%XLEC        (KMASK(JJ), KPATCH)  =  DGEI%XLEC        (KMASK(JJ), KPATCH) + PKI%XP_LE        (JJ) * PTSTEP
     DGEI%XLEIC       (KMASK(JJ), KPATCH)  =  DGEI%XLEIC       (KMASK(JJ), KPATCH) + PKDI%XP_LEI       (JJ) * PTSTEP
     DGEI%XGFLUXC     (KMASK(JJ), KPATCH)  =  DGEI%XGFLUXC     (KMASK(JJ), KPATCH) + PKDI%XP_GFLUX     (JJ) * PTSTEP
     DGEI%XLEGC       (KMASK(JJ), KPATCH)  =  DGEI%XLEGC       (KMASK(JJ), KPATCH) + PKDI%XP_LEG       (JJ) * PTSTEP
     DGEI%XLEGIC      (KMASK(JJ), KPATCH)  =  DGEI%XLEGIC      (KMASK(JJ), KPATCH) + PKDI%XP_LEGI      (JJ) * PTSTEP
     DGEI%XLEVC       (KMASK(JJ), KPATCH)  =  DGEI%XLEVC       (KMASK(JJ), KPATCH) + PKDI%XP_LEV       (JJ) * PTSTEP
     DGEI%XLESAC      (KMASK(JJ), KPATCH)  =  DGEI%XLESAC      (KMASK(JJ), KPATCH) + PKDI%XP_LES       (JJ) * PTSTEP
     DGEI%XLERC       (KMASK(JJ), KPATCH)  =  DGEI%XLERC       (KMASK(JJ), KPATCH) + PKDI%XP_LER       (JJ) * PTSTEP
     DGEI%XLETRC      (KMASK(JJ), KPATCH)  =  DGEI%XLETRC      (KMASK(JJ), KPATCH) + PKDI%XP_LETR      (JJ) * PTSTEP
     DGEI%XEVAPC      (KMASK(JJ), KPATCH)  =  DGEI%XEVAPC      (KMASK(JJ), KPATCH) + PKDI%XP_EVAP      (JJ) * PTSTEP
     DGEI%XSUBLC      (KMASK(JJ), KPATCH)  =  DGEI%XSUBLC      (KMASK(JJ), KPATCH) + PKDI%XP_SUBL      (JJ) * PTSTEP
     DGEI%XDRAINC     (KMASK(JJ), KPATCH)  =  DGEI%XDRAINC     (KMASK(JJ), KPATCH) + PKDI%XP_DRAIN     (JJ) * PTSTEP
     DGEI%XQSBC       (KMASK(JJ), KPATCH)  =  DGEI%XQSBC       (KMASK(JJ), KPATCH) + PKDI%XP_QSB       (JJ) * PTSTEP
     DGEI%XRUNOFFC    (KMASK(JJ), KPATCH)  =  DGEI%XRUNOFFC    (KMASK(JJ), KPATCH) + PKDI%XP_RUNOFF    (JJ) * PTSTEP
     DGEI%XHORTC      (KMASK(JJ), KPATCH)  =  DGEI%XHORTC      (KMASK(JJ), KPATCH) + PKDI%XP_HORT      (JJ) * PTSTEP
     DGEI%XDRIPC      (KMASK(JJ), KPATCH)  =  DGEI%XDRIPC      (KMASK(JJ), KPATCH) + PKDI%XP_DRIP      (JJ) * PTSTEP
     DGEI%XRRVEGC     (KMASK(JJ), KPATCH)  =  DGEI%XRRVEGC     (KMASK(JJ), KPATCH) + PKDI%XP_RRVEG     (JJ) * PTSTEP
     DGEI%XMELTC      (KMASK(JJ), KPATCH)  =  DGEI%XMELTC      (KMASK(JJ), KPATCH) + PKDI%XP_MELT      (JJ) * PTSTEP
     DGEI%XIFLOODC    (KMASK(JJ), KPATCH)  =  DGEI%XIFLOODC    (KMASK(JJ), KPATCH) + PKDI%XP_IFLOOD    (JJ) * PTSTEP
     DGEI%XPFLOODC    (KMASK(JJ), KPATCH)  =  DGEI%XPFLOODC    (KMASK(JJ), KPATCH) + PKDI%XP_PFLOOD    (JJ) * PTSTEP
     DGEI%XLE_FLOODC  (KMASK(JJ), KPATCH)  =  DGEI%XLE_FLOODC  (KMASK(JJ), KPATCH) + PKDI%XP_LE_FLOOD  (JJ) * PTSTEP
     DGEI%XLEI_FLOODC (KMASK(JJ), KPATCH)  =  DGEI%XLEI_FLOODC (KMASK(JJ), KPATCH) + PKDI%XP_LEI_FLOOD (JJ) * PTSTEP
     DGEI%XIRRIG_FLUXC(KMASK(JJ), KPATCH)  =  DGEI%XIRRIG_FLUXC(KMASK(JJ), KPATCH) + PKDI%XP_IRRIG_FLUX(JJ) * PTSTEP
     !
     IF (I%LMEB_PATCH(KPATCH)) THEN
       DGEI%XLEVCVC  (KMASK(JJ), KPATCH)  = DGEI%XLEVCVC  (KMASK(JJ), KPATCH) + PKDI%XP_LEVCV    (JJ) * PTSTEP
       DGEI%XLESCC   (KMASK(JJ), KPATCH)  = DGEI%XLESCC   (KMASK(JJ), KPATCH) + PKDI%XP_LESC     (JJ) * PTSTEP
!       XLETRGVC (KMASK(JJ), KPATCH)  = XLETRGVC (KMASK(JJ), KPATCH) + XP_LETRGV   (JJ) * PTSTEP
       DGEI%XLETRCVC (KMASK(JJ), KPATCH)  = DGEI%XLETRCVC (KMASK(JJ), KPATCH) + PKDI%XP_LETRCV   (JJ) * PTSTEP
!       XLERGVC  (KMASK(JJ), KPATCH)  = XLERGVC  (KMASK(JJ), KPATCH) + XP_LERGV    (JJ) * PTSTEP
       DGEI%XLERCVC  (KMASK(JJ), KPATCH)  = DGEI%XLERCVC  (KMASK(JJ), KPATCH) + PKDI%XP_LERCV    (JJ) * PTSTEP
       DGEI%XLE_C_AC (KMASK(JJ), KPATCH)  = DGEI%XLE_C_AC (KMASK(JJ), KPATCH) + PKDI%XP_LE_C_A   (JJ) * PTSTEP
       DGEI%XLE_V_CC (KMASK(JJ), KPATCH)  = DGEI%XLE_V_CC (KMASK(JJ), KPATCH) + PKDI%XP_LE_V_C   (JJ) * PTSTEP
       DGEI%XLE_G_CC (KMASK(JJ), KPATCH)  = DGEI%XLE_G_CC (KMASK(JJ), KPATCH) + PKDI%XP_LE_G_C   (JJ) * PTSTEP
       DGEI%XLE_N_CC (KMASK(JJ), KPATCH)  = DGEI%XLE_N_CC (KMASK(JJ), KPATCH) + PKDI%XP_LE_N_C   (JJ) * PTSTEP
       !
       DGEI%XSWNET_VC    (KMASK(JJ), KPATCH)  = DGEI%XSWNET_VC    (KMASK(JJ), KPATCH)  + PKDI%XP_SWNET_V    (JJ) * PTSTEP
       DGEI%XSWNET_GC    (KMASK(JJ), KPATCH)  = DGEI%XSWNET_GC    (KMASK(JJ), KPATCH)  + PKDI%XP_SWNET_G    (JJ) * PTSTEP
       DGEI%XSWNET_NC    (KMASK(JJ), KPATCH)  = DGEI%XSWNET_NC    (KMASK(JJ), KPATCH)  + PKDI%XP_SWNET_N    (JJ) * PTSTEP
       DGEI%XSWNET_NSC   (KMASK(JJ), KPATCH)  = DGEI%XSWNET_NSC   (KMASK(JJ), KPATCH)  + PKDI%XP_SWNET_NS   (JJ) * PTSTEP
       DGEI%XLWNET_VC    (KMASK(JJ), KPATCH)  = DGEI%XLWNET_VC    (KMASK(JJ), KPATCH)  + PKDI%XP_LWNET_V    (JJ) * PTSTEP
       DGEI%XLWNET_GC    (KMASK(JJ), KPATCH)  = DGEI%XLWNET_GC    (KMASK(JJ), KPATCH)  + PKDI%XP_LWNET_G    (JJ) * PTSTEP
       DGEI%XLWNET_NC    (KMASK(JJ), KPATCH)  = DGEI%XLWNET_NC    (KMASK(JJ), KPATCH)  + PKDI%XP_LWNET_N    (JJ) * PTSTEP
       DGEI%XSWDOWN_GNC  (KMASK(JJ), KPATCH)  = DGEI%XSWDOWN_GNC  (KMASK(JJ), KPATCH)  + PKDI%XP_SWDOWN_GN  (JJ) * PTSTEP
       DGEI%XLWDOWN_GNC  (KMASK(JJ), KPATCH)  = DGEI%XLWDOWN_GNC  (KMASK(JJ), KPATCH)  + PKDI%XP_LWDOWN_GN  (JJ) * PTSTEP
       DGEI%XH_V_CC      (KMASK(JJ), KPATCH)  = DGEI%XH_V_CC      (KMASK(JJ), KPATCH)  + PKDI%XP_H_V_C      (JJ) * PTSTEP
       DGEI%XH_G_CC      (KMASK(JJ), KPATCH)  = DGEI%XH_G_CC      (KMASK(JJ), KPATCH)  + PKDI%XP_H_G_C      (JJ) * PTSTEP
       DGEI%XH_C_AC      (KMASK(JJ), KPATCH)  = DGEI%XH_C_AC      (KMASK(JJ), KPATCH)  + PKDI%XP_H_C_A      (JJ) * PTSTEP
       DGEI%XH_N_CC      (KMASK(JJ), KPATCH)  = DGEI%XH_N_CC      (KMASK(JJ), KPATCH)  + PKDI%XP_H_N_C      (JJ) * PTSTEP
       DGEI%XSR_GNC      (KMASK(JJ), KPATCH)  = DGEI%XSR_GNC      (KMASK(JJ), KPATCH)  + PKDI%XP_SR_GN      (JJ) * PTSTEP
       DGEI%XMELTCVC     (KMASK(JJ), KPATCH)  = DGEI%XMELTCVC     (KMASK(JJ), KPATCH)  + PKDI%XP_MELTCV     (JJ) * PTSTEP
       DGEI%XFRZCVC      (KMASK(JJ), KPATCH)  = DGEI%XFRZCVC      (KMASK(JJ), KPATCH)  + PKDI%XP_FRZCV      (JJ) * PTSTEP
     ENDIF
     !
     DGI%XSWDC(KMASK(JJ), KPATCH)  = DGI%XSWDC(KMASK(JJ), KPATCH) + PKDI%XP_SWD(JJ) * PTSTEP
     DGI%XSWUC(KMASK(JJ), KPATCH)  = DGI%XSWUC(KMASK(JJ), KPATCH) + PKDI%XP_SWU(JJ) * PTSTEP
     DGI%XLWDC(KMASK(JJ), KPATCH)  = DGI%XLWDC(KMASK(JJ), KPATCH) + PKDI%XP_LWD(JJ) * PTSTEP
     DGI%XLWUC(KMASK(JJ), KPATCH)  = DGI%XLWUC(KMASK(JJ), KPATCH) + PKDI%XP_LWU(JJ) * PTSTEP
     DGI%XFMUC(KMASK(JJ), KPATCH)  = DGI%XFMUC(KMASK(JJ), KPATCH) + PKDI%XP_FMU(JJ) * PTSTEP
     DGI%XFMVC(KMASK(JJ), KPATCH)  = DGI%XFMVC(KMASK(JJ), KPATCH) + PKDI%XP_FMV(JJ) * PTSTEP
     !
  END DO
  !
  IF (I%TSNOW%SCHEME=='3-L' .OR. I%TSNOW%SCHEME=='CRO') THEN
!cdir nodep
     DO JJ=1,KSIZE
        DGEI%XLESLC    (KMASK(JJ), KPATCH) = DGEI%XLESLC    (KMASK(JJ), KPATCH) + PKDI%XP_LESL    (JJ) * PTSTEP
        DGEI%XSNDRIFTC (KMASK(JJ), KPATCH) = DGEI%XSNDRIFTC (KMASK(JJ), KPATCH) + PKDI%XP_SNDRIFT (JJ) * PTSTEP
     END DO
  END IF
  !
  IF(HPHOTO/='NON')THEN
!cdir nodep
     DO JJ=1,KSIZE
        !Transform units from kgCO2/kgair m/s to kgCO2/m2
        DGEI%XGPPC       (KMASK(JJ), KPATCH)  =  DGEI%XGPPC       (KMASK(JJ), KPATCH)+  PKDI%XP_GPP       (JJ) * PRHOA(JJ) * PTSTEP
        DGEI%XRESPC_AUTO (KMASK(JJ), KPATCH)  =  DGEI%XRESPC_AUTO (KMASK(JJ), KPATCH)+  PKDI%XP_RESP_AUTO (JJ) * PRHOA(JJ) * PTSTEP
        DGEI%XRESPC_ECO  (KMASK(JJ), KPATCH)  =  DGEI%XRESPC_ECO  (KMASK(JJ), KPATCH)+  PKDI%XP_RESP_ECO  (JJ) * PRHOA(JJ) * PTSTEP
     END DO
  ELSE  
     DGEI%XGPPC      (:,:)=0.0
     DGEI%XRESPC_AUTO(:,:)=0.0
     DGEI%XRESPC_ECO (:,:)=0.0       
  ENDIF
  !
  IF(I%LGLACIER)THEN
!cdir nodep
    DO JJ=1,KSIZE
       DGEI%XICEFLUXC(KMASK(JJ), KPATCH)  = DGEI%XICEFLUXC(KMASK(JJ), KPATCH) + PKDI%XP_ICEFLUX(JJ) * PTSTEP
    END DO  
  END IF
  !  
  IF(DGEI%LWATER_BUDGET)THEN
!cdir nodep
     DO JJ=1,KSIZE
        DGEI%XDWGC   (KMASK(JJ), KPATCH)  =  DGEI%XDWGC   (KMASK(JJ), KPATCH) + PKDI%XP_DWG   (JJ) * PTSTEP
        DGEI%XDWGIC  (KMASK(JJ), KPATCH)  =  DGEI%XDWGIC  (KMASK(JJ), KPATCH) + PKDI%XP_DWGI  (JJ) * PTSTEP
        DGEI%XDWRC   (KMASK(JJ), KPATCH)  =  DGEI%XDWRC   (KMASK(JJ), KPATCH) + PKDI%XP_DWR   (JJ) * PTSTEP
        DGEI%XDSWEC  (KMASK(JJ), KPATCH)  =  DGEI%XDSWEC  (KMASK(JJ), KPATCH) + PKDI%XP_DSWE  (JJ) * PTSTEP
        DGEI%XWATBUDC(KMASK(JJ), KPATCH)  =  DGEI%XWATBUDC(KMASK(JJ), KPATCH) + PKDI%XP_WATBUD(JJ) * PTSTEP
     END DO
  ENDIF
  !  
END IF
IF (LHOOK) CALL DR_HOOK('DIAG_EVAP_ISBA_N',1,ZHOOK_HANDLE)
!
!-------------------------------------------------------------------------------------
!
END SUBROUTINE DIAG_EVAP_ISBA_n
