!     #########
       SUBROUTINE DIAG_CPL_ESM_WATER (W, &
                                       PTSTEP,PZON10M,PMER10M,PSFU,PSFV,   &
                                        PSWD,PSWU,PGFLUX,PSFTQ,PRAIN,PSNOW, &
                                        PLW,PTICE,PSFTH_ICE,PSFTQ_ICE,      &
                                        PDIR_SW,PSCA_SW                     )  
!     #####################################################################
!
!!****  *DIAG_CPL_ESM_WATER * - Computes diagnostics over sea for 
!!                                Earth system model coupling
!!
!!    PURPOSE
!!    -------
!
!!**  METHOD
!!    ------
!!
!!    REFERENCE
!!    ---------
!!      
!!
!!    AUTHOR
!!    ------
!!     B. Decharme 
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    08/2009
!!------------------------------------------------------------------
!
!
USE MODD_WATFLUX_n, ONLY : WATFLUX_t
!
USE MODD_CSTS,      ONLY : XSTEFAN, XLSTT
USE MODD_WATER_PAR, ONLY : XEMISWATICE
!
! 
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*      0.1    declarations of arguments
!
!
TYPE(WATFLUX_t), INTENT(INOUT) :: W
!
REAL,               INTENT(IN) :: PTSTEP    ! atmospheric time-step
REAL, DIMENSION(:), INTENT(IN) :: PZON10M   ! zonal wind
REAL, DIMENSION(:), INTENT(IN) :: PMER10M   ! meridian wind
REAL, DIMENSION(:), INTENT(IN) :: PSFU      ! zonal wind stress
REAL, DIMENSION(:), INTENT(IN) :: PSFV      ! meridian wind stress
REAL, DIMENSION(:), INTENT(IN) :: PSWD      ! total incoming short wave radiation
REAL, DIMENSION(:), INTENT(IN) :: PSWU      ! total upward short wave radiation
REAL, DIMENSION(:), INTENT(IN) :: PGFLUX    ! storage flux
REAL, DIMENSION(:), INTENT(IN) :: PSFTQ     ! water flux
REAL, DIMENSION(:), INTENT(IN) :: PRAIN     ! Rainfall
REAL, DIMENSION(:), INTENT(IN) :: PSNOW     ! Snowfall
REAL, DIMENSION(:), INTENT(IN) :: PLW       ! longwave radiation (on horizontal surf.)
REAL, DIMENSION(:), INTENT(IN) :: PSFTH_ICE ! heat flux  (W/m2)
REAL, DIMENSION(:), INTENT(IN) :: PSFTQ_ICE ! water flux (kg/m2/s)
REAL, DIMENSION(:), INTENT(IN) :: PTICE     ! Ice Surface Temperature
REAL, DIMENSION(:,:),INTENT(IN):: PDIR_SW   ! direct  solar radiation (on horizontal surf.)
REAL, DIMENSION(:,:),INTENT(IN):: PSCA_SW   ! diffuse solar radiation (on horizontal surf.)
!
!*      0.2    declarations of local variables
!
REAL, DIMENSION(SIZE(W%XICE_ALB)) :: ZSWU, ZTICE4
!
INTEGER                      :: ISWB ! number of SW bands
INTEGER                      :: JSWB ! loop counter on number of SW bands
INTEGER                      :: INI  ! number of points
INTEGER                      :: JI   ! loop counter on number of points
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
IF (LHOOK) CALL DR_HOOK('DIAG_CPL_ESM_WATER',0,ZHOOK_HANDLE)
!
!-------------------------------------------------------------------------------------
! Total or free-ice water flux
!-------------------------------------------------------------------------------------
!
!* 10m wind speed (m)
!
W%XCPL_WATER_WIND(:) = W%XCPL_WATER_WIND(:) + PTSTEP * SQRT(PZON10M(:)**2+PMER10M(:)**2)
! 
!* wind stress (Pa.s)
!
W%XCPL_WATER_FWSU(:) = W%XCPL_WATER_FWSU(:) + PTSTEP * PSFU(:)
W%XCPL_WATER_FWSV(:) = W%XCPL_WATER_FWSV(:) + PTSTEP * PSFV(:)
W%XCPL_WATER_FWSM(:) = W%XCPL_WATER_FWSM(:) + PTSTEP * SQRT(PSFU(:)**2+PSFV(:)**2)
!
!* Solar net heat flux (J/m2)
!
W%XCPL_WATER_SNET(:) = W%XCPL_WATER_SNET(:) + PTSTEP * (PSWD(:) - PSWU(:))
!
!* Non solar heat flux (J/m2)
!
W%XCPL_WATER_HEAT(:) = W%XCPL_WATER_HEAT(:) + PTSTEP * (PGFLUX(:) + PSWU(:) - PSWD(:)) 
!
!* Evaporation (kg/m2)
!
W%XCPL_WATER_EVAP(:) = W%XCPL_WATER_EVAP(:) + PTSTEP * PSFTQ(:)
!
!* Precip (kg/m2)
! 
W%XCPL_WATER_RAIN(:) = W%XCPL_WATER_RAIN(:) + PTSTEP * PRAIN(:) 
W%XCPL_WATER_SNOW(:) = W%XCPL_WATER_SNOW(:) + PTSTEP * PSNOW(:)
!
!-------------------------------------------------------------------------------------
! Ice flux
!-------------------------------------------------------------------------------------
!
INI  = SIZE(PDIR_SW,1)
ISWB = SIZE(PDIR_SW,2)
!
!* Solar net heat flux (J/m2)
!
ZSWU(:)=0.0
DO JSWB=1,ISWB
   DO JI=1,INI
      ZSWU(JI) = ZSWU(JI) + (PDIR_SW(JI,JSWB)+PSCA_SW(JI,JSWB)) * W%XICE_ALB(JI)
   ENDDO
ENDDO
!
W%XCPL_WATERICE_SNET(:) = W%XCPL_WATERICE_SNET(:) + PTSTEP * (PSWD(:) - ZSWU(:))
!
!* Non solar heat flux (J/m2)
!
ZTICE4(:)=PTICE(:)**4
!
W%XCPL_WATERICE_HEAT(:) = W%XCPL_WATERICE_HEAT(:) + PTSTEP * ( XEMISWATICE*(PLW(:)-XSTEFAN*ZTICE4(:)) &
                                                             - PSFTH_ICE(:) - XLSTT*PSFTQ_ICE(:)  )  
!
!* Sublimation (kg/m2)
!
W%XCPL_WATERICE_EVAP(:) = W%XCPL_WATERICE_EVAP(:) + PTSTEP * PSFTQ_ICE(:)
!
IF (LHOOK) CALL DR_HOOK('DIAG_CPL_ESM_WATER',1,ZHOOK_HANDLE)
!
!-------------------------------------------------------------------------------------
!
END SUBROUTINE DIAG_CPL_ESM_WATER
