!######################################################################
!######################################################################
!
!       THIS ROUTINE COMPUTE THE INCOMPLETE AND THE COMPLEMENTARY
! INCOMPLETE GAMMA FUNCTION REAL*8 IN BRIEF, THIS
! FUNCTION HELP TO COMPUTE THE DIFFERENT FRACTION PRESENT IN THE
! TOPMODEL FRAMEWORK.
!       MORE EXPLANATION ON THE SUBROUTINE USE ARE GIVEN IN THE NEXT
! COMMENTARY
!
! THIS ROUTINE WAS FOUND ON http://www.netlib.org WEB SITE.
!
! REFERENCE - W. GAUTSCHI, :: A COMPUTATIONAL PROCEDURE FOR INCOMPLETE
! GAMMA FUNCTIONS, ACM TRANS. MATH. SOFTWARE., (1979) 482-489
!
!######################################################################
!######################################################################
!
!     LET  GAMMA(A)  DENOTE THE GAMMA FUNCTION AND  GAM(A,X)  THE
! (COMPLEMENTARY) INCOMPLETE GAMMA FUNCTION,
!
!    GAM(A,X)=INTEGRAL FROM T=X TO T=INFINITY OF EXP(-T)*T**(A-1).
!
! LET  GAMSTAR(A,X)  DENOTE TRICOMI:S FORM OF THE INCOMPLETE GAMMA
! FUNCTION, WHICH FOR A.GT.0. IS DEFINED BY
!
!  GAMSTAR(A,X)=(X**(-A)/GAMMA(A))*INTEGRAL FROM T=0 TO T=X OF
!                EXP(-T)*T**(A-1),
!
! AND FOR A.LE.0. BY ANALYTIC CONTINUATION. FOR THE PURPOSE OF
! THIS SUBROUTINE, THESE FUNCTIONS ARE NORMALIZED AS FOLLOWS&
!
!             GAM(A,X)/GAMMA(A),  IF A.GT.0.,
!     G(A,X)=
!             EXP(X)*X**(-A)*GAM(A,X),  IF A.LE.0.,
!
!     GSTAR(A,X)=(X**A)*GAMSTAR(A,X)
!               =(1/GAMMA(A))*INTEGRAL FROM T=0 TO T=X OF EXP(-T)*T**(A-1)
!
! THE PROGRAM BELOW ATTEMPTS TO EVALUATE  G(A,X)  AND  GSTAR(A,X),
! BOTH TO AN ACCURACY OF ACC SIGNIFICANT DECIMAL DIGITS, FOR ARBI-
! TRARY REAL VALUES OF  A  AND NONNEGATIVE VALUES OF  X. THE SUB-
! ROUTINE AUTOMATICALLY CHECKS FOR UNDERFLOW AND OVERFLOW CONDI-
! TIONS AND RETURNS APPROPRIATE WARNINGS THROUGH THE OUTPUT PARA-
! METERS  IFLG, IFLGST. A RESULT THAT UNDERFLOWS IS RETURNED WITH
! THE VALUE 0., ONE THAT OVERFLOWS WITH THE VALUE OF THE LARGEST
! MACHINE-REPRESENTABLE NUMBER.
!
!     NEAR LINES IN THE (A,X)-PLANE, A.LT.0., ALONG WHICH  GSTAR
! VANISHES, THE ACCURACY SPECIFIED WILL BE ATTAINED ONLY IN TERMS
! OF ABSOLUTE ERROR, NOT RELATIVE ERROR. THERE ARE OTHER (RARE)
! INSTANCES IN WHICH THE ACCURACY ATTAINED IS SOMEWHAT LESS THAN
! THE ACCURACY SPECIFIED. THE DISCREPANCY, HOWEVER, SHOULD NEVER
! EXCEED ONE OR TWO (DECIMAL) ORDERS OF ACCURACY# NO INDICATION
! OF THIS IS GIVEN THROUGH ERROR FLAGS.
!
!     PARAMETER LIST&
!
!        A - - THE FIRST ARGUMENT OF G AND GSTAR. TYPE REAL.
!        X - - THE SECOND ARGUMENT OF G AND GSTAR. TYPE REAL.
!      ACC - - THE NUMBER OF CORRECT SIGNIFICANT DECIMAL DIGITS
!              DESIRED IN THE RESULTS. TYPE REAL.
!        G - - AN OUTPUT VARIABLE RETURNING THE VALUE OF G(A,X).
!              TYPE REAL.
!    GSTAR - - AN OUTPUT VARIABLE RETURNING THE VALUE OF
!              GSTAR(A,X). TYPE REAL.
!     IFLG - - AN ERROR FLAG INDICATING A NUMBER OF ERROR CONDI-
!              TIONS IN G UPON EXECUTION. TYPE INTEGER.
!   IFLGST - - AN ERROR FLAG INDICATING A NUMBER OF ERROR CONDI-
!              TIONS IN GSTAR UPON EXECUTION. TYPE INTEGER.
!              THE VALUES OF IFLG AND IFLGST HAVE THE FOLLOWING
!              MEANINGS&
!              0 - NO ERROR CONDITION.
!              1 - ILLEGAL NEGATIVE ARGUMENT X. THE ROUTINE EXITS
!                  WITH THE VALUES ZERO FOR G AND GSTAR.
!              2 - INFINITELY LARGE RESULT AT X=0. THE ROUTINE
!                  RETURNS THE LARGEST MACHINE-REPRESENTABLE NUMBER.
!              3 - (ONLY FOR IFLGST) GSTAR IS INDETERMINATE AT
!                  A=0. AND X=0. THE ROUTINE RETURNS THE VALUE 1.,
!                  WHICH IS THE LIMIT VALUE AS X TENDS TO ZERO FOR
!                  FIXED A=0.
!              4 - THE RESULT UNDERFLOWS. IT IS SET EQUAL TO 0.
!              5 - THE RESULT OVERFLOWS. IT IS SET EQUAL TO THE
!                  LARGEST MACHINE-REPRESENTABLE NUMBER, WITH
!                  PROPER SIGN.
!              6 - CONVERGENCE FAILS WITHIN 600 ITERATIONS, EITHER
!                  IN TAYLOR:S SERIES OR IN LEGENDRE:S CONTINUED
!                  FRACTION. REASON UNKNOWN. THE COMPUTATION IS
!                  ABORTED AND THE ROUTINE RETURNS WITH ZERO
!                  VALUES FOR G AND GSTAR.
!
!     ALL MACHINE-DEPENDENT PARAMETERS ARE COLLECTED IN THE FIRST
! DATA DECLARATION. THEY ARE AS FOLLOWS&
!
! IN THE PROGRAM BELOW THESE PARAMETERS ARE SET TO CORRESPOND TO
! THE MACHINE CHARACTERISTICS OF THE CDC 6500 COMPUTER.
!
!     THE SECOND DATA DECLARATION CONTAINS THE SINGLE PRECISION
! VALUE OF ALOG(10.). THE NEXT DATA DECLARATION CONTAINS THE SUCCES-
! SIVE COEFFICIENTS IN THE MACLAURIN EXPANSION OF (1/GAMMA(A+1))-1.
! THEY ARE GIVEN TO AS MANY DECIMAL PLACES AS IS NECESSARY TO ACHIEVE
! MACHINE PRECISION (ON THE CDC 6500 COMPUTER) IN THE RANGE
! ABS(A).LE..5. MORE ACCURATE VALUES OF THESE COEFFICIENTS (TO
! 31 DECIMAL PLACES) CAN BE FOUND IN TABLE 5 OF J.W.WRENCH,JR.,
! CONCERNING TWO SERIES FOR THE GAMMA FUNCTION, MATH. COMPUT.
! 22, 1968, 617-626.
!
!     THE SUBROUTINE CALLS ON A FUNCTION SUBROUTINE, NAMED  ALGA,
! WHICH IS TO PROVIDE SINGLE PRECISION VALUES OF THE LOGARITHM OF
! THE GAMMA FUNCTION FOR ARGUMENTS LARGER THAN OR EQUAL TO .5.
! A POSSIBLE VERSION OF SUCH A FUNCTION SUBROUTINE IS APPENDED
! TO THE PRESENT SUBROUTINE. IT IS TAYLORED TO THE ACCURACY RE-
! QUIREMENTS OF THE CDC 6500 COMPUTER, AND USES RATIONAL APPROXI-
! MATIONS DUE TO CODY AND HILLSTROM (MATH. COMPUT. 21, 1967, 198-
! 203).
!
!     REFERENCE - W. GAUTSCHI, ::A COMPUTATIONAL PROCEDURE FOR
! INCOMPLETE GAMMA FUNCTIONS, ACM TRANS. MATH. SOFTWARE.
!
!----------------------------------------------------
!!    MODIFICATIONS
!!    -------------
!!      J.Escobar      10/06/2013: replace DOUBLE PRECISION by REAL to handle problem for promotion of real on IBM SP
!----------------------------------------------------
!################################################################
!
      SUBROUTINE DGAM(A, X, ACC, G, GSTAR, IFLG, IFLGST)
!
!################################################################

      USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
      USE PARKIND1  ,ONLY : JPRB

      IMPLICIT NONE

      REAL(KIND=JPRB) :: ZHOOK_HANDLE

      INTEGER,PARAMETER :: JDBL=8
      REAL :: A, X, ACC, G, GSTAR
      INTEGER :: IFLG, IFLGST, I, K, K1, MA

      REAL(KIND=JDBL) :: ALX, ALPHA, ALPREC
      REAL(KIND=JDBL) :: TOP, BOT, AINF, EPS, EPS1, ES, SGA
      REAL(KIND=JDBL) :: AE, AA, AP1, AM1, AEP1
      REAL(KIND=JDBL) :: AEM1, FMA, AEPS, SGAE, AAEPS, ALGP1
      REAL(KIND=JDBL) :: SGGA, ALGEP1, SGGS, ALGS
      REAL(KIND=JDBL) :: ALG, SUMM, GA, Y, TERM, U, P, Q, R, V, T, H
      REAL(KIND=JDBL) :: SGT, A1X, RHO, XPA
      REAL(KIND=JDBL) :: XMA, S, TEMP

!RJ       REAL(KIND=JDBL),SAVE::AL10=2.3025850929940456840179914547e0_JDBL
      REAL(KIND=JDBL),DIMENSION(29),PARAMETER :: C=(/                   &
     &   .57721566490153286060651209008e0_JDBL,                         &
     &  -.65587807152025388107701951515e0_JDBL,                         &
     & -4.200263503409523552900393488e-2_JDBL,                          &
     &   .1665386113822914895017007951e0_JDBL,                          &
     & -4.21977345555443367482083013e-2_JDBL,                           &
     & -9.6219715278769735621149217e-3_JDBL,                            &
     &  7.2189432466630995423950103e-3_JDBL,                            &
     & -1.165167591859065112113971e-3_JDBL,                             &
     & -2.15241674114950972815730e-4_JDBL,                              &
     &  1.2805028238811618615320e-4_JDBL,                               &
     & -2.013485478078823865569e-5_JDBL,                                &
     & -1.2504934821426706573e-6_JDBL,                                  &
     &  1.1330272319816958824e-6_JDBL,                                  &
     & -2.056338416977607103e-7_JDBL,                                   &
     &  6.1160951044814158e-9_JDBL,                                     &
     &  5.0020076444692229e-9_JDBL,                                     &
     & -1.181274570487020e-9_JDBL,                                      &
     &  1.04342671169110e-10_JDBL,                                      &
     &  7.782263439905e-12_JDBL,                                        &
     & -3.696805618642e-12_JDBL,                                        &
     &  5.1003702875e-13_JDBL,                                          &
     & -2.058326054e-14_JDBL,                                           &
     & -5.34812254e-15_JDBL,                                            &
     &  1.2267786e-15_JDBL,                                             &
     & -1.181259e-16_JDBL,                                              &
     &  1.187e-18_JDBL,                                                 &
     &  1.412e-18_JDBL,                                                 &
     & -2.30e-19_JDBL,                                                  &
     &  1.7e-20_JDBL/)

      IF (LHOOK) CALL DR_HOOK('DGAM',0,ZHOOK_HANDLE)

      G = 0.e0_JDBL
      GSTAR = 0.e0_JDBL
      IF (X<0.e0_JDBL) GO TO 290
!
! INITIALIZATION
!
      IFLG = 0
      IFLGST = 0
      I = 0
      IF (X>0.e0_JDBL) ALX = LOG(X*1.e0_JDBL)
      ALPHA = X + .25e0_JDBL
      IF (X<0.25e0_JDBL .AND. X>0.e0_JDBL) ALPHA = LOG(0.5e0_JDBL)/ALX
      ALPREC = DIGITS(1.e0_JDBL)*LOG(2.e0_JDBL)
      TOP    = LOG10(HUGE(1.e0_JDBL))
      BOT    = LOG10(TINY(1.e0_JDBL))
      AINF   = HUGE(1.e0_JDBL)
      EPS = 0.5e0_JDBL*10.e0_JDBL**(-ACC)
      EPS1 = EPS/1.e2_JDBL
      SGA = 1.e0_JDBL
      IF (A<0.e0_JDBL) SGA = -SGA
      AE = A
      AA = ABS(A*1.e0_JDBL)
      AP1 = A + 1.e0_JDBL
      AEP1 = AP1
      MA = INT(0.5e0_JDBL-A)
      FMA = MA
      AEPS = A + FMA
      SGAE = 1.e0_JDBL
      IF (AEPS<0.e0_JDBL) SGAE = -SGAE
      AAEPS = ABS(AEPS)
      ALGP1 = 0.e0_JDBL
!
! EVALUATION OF THE LOGARITHM OF THE ABSOLUTE VALUE OF
! GAMMA(A+1.) AND DETERMINATION OF THE SIGN OF GAMMA(A+1.)
!
      SGGA = 1.e0_JDBL
      IF (MA<=0) GO TO 10
      IF (AEPS==0.e0_JDBL) GO TO 20
      SGGA = SGAE
      IF (MA==2*(MA/2)) SGGA = -SGGA
      ALGP1 = DLGA(AEPS+1.e0_JDBL) - LOG(AAEPS)
      IF (MA==1) GO TO 20
      ALGP1 = ALGP1 + DLGA(1.e0_JDBL-AEPS) - DLGA(FMA-AEPS)
      GO TO 20
   10 ALGP1 = DLGA(AP1)
   20 ALGEP1 = ALGP1
      IF (X>0.e0_JDBL) GO TO 60
!
! EVALUATION OF GSTAR(A,0.) AND G(A,0.)
!
      IF (A) 30, 40, 50
   30 IFLGST = 2
      GSTAR = AINF
      G = 1.e0_JDBL/AA
      IF (LHOOK) CALL DR_HOOK('DGAM',1,ZHOOK_HANDLE)
      RETURN
   40 IFLGST = 3
      GSTAR = 1.e0_JDBL
      IFLG = 2
      G = AINF
      IF (LHOOK) CALL DR_HOOK('DGAM',1,ZHOOK_HANDLE)
      RETURN
   50 G = 1.e0_JDBL
      IF (LHOOK) CALL DR_HOOK('DGAM',1,ZHOOK_HANDLE)
      RETURN
   60 IF (A>ALPHA) GO TO 220
      IF (X>1.5e0_JDBL) GO TO 240
      IF (A<-.5e0_JDBL) GO TO 170
!
! DIRECT EVALUATION OF G(A,X) AND GSTAR(A,X) FOR X.LE.1.5
! AND -.5.LE.A.LE.ALPHA(X)
!
      GSTAR = 1.e0_JDBL
      IF (A>=0.5e0_JDBL) GO TO 110
   70 SUMM = C(29)
      DO 80 K=1,28
        K1 = 29 - K
        SUMM = AE*SUMM + C(K1)
   80 CONTINUE
      GA = -SUMM/(1.e0_JDBL+AE*SUMM)
      Y = AE*ALX
      IF (ABS(Y)>=1.e0_JDBL) GO TO 100
      SUMM = 1.e0_JDBL
      TERM = 1.e0_JDBL
      K = 1
   90 K = K + 1
      IF (K>600) GO TO 330
      TERM = Y*TERM/K
      SUMM = SUMM + TERM
      IF (ABS(TERM)>EPS1*SUMM) GO TO 90
      U = GA - SUMM*ALX
      GO TO 120
  100 U = GA - (EXP(Y)-1.e0_JDBL)/AE
      GO TO 120
  110 TEMP=DLGA(A*1.e0_JDBL)
      U = DEXP(TEMP) - (X**A)/A
  120 P = AE*X
      Q = AEP1
      R = AE + 3.e0_JDBL
      TERM = 1.e0_JDBL
      SUMM = 1.e0_JDBL
      K = 1
  130 K = K + 1
      IF (K>600) GO TO 330
      P = P + X
      Q = Q + R
      R = R + 2.e0_JDBL
      TERM = -P*TERM/Q
      SUMM = SUMM + TERM
      IF (ABS(TERM)>EPS1*SUMM) GO TO 130
      V = (X**AEP1)*SUMM/AEP1
      G = U + V
      IF (I==1) GO TO 180
      IF (A) 140, 150, 160
  140 T = EXP(X*1.e0_JDBL)*X**(-A)
      G = T*G
      GSTAR = 1.e0_JDBL - A*G*DEXP(-ALGP1)/T
      IF (LHOOK) CALL DR_HOOK('DGAM',1,ZHOOK_HANDLE)
      RETURN
  150 G = EXP(X*1.e0_JDBL)*G
      IF (LHOOK) CALL DR_HOOK('DGAM',1,ZHOOK_HANDLE)
      RETURN
  160 G = A*G*EXP(-ALGP1)
      GSTAR = 1.e0_JDBL - G
      IF (LHOOK) CALL DR_HOOK('DGAM',1,ZHOOK_HANDLE)
      RETURN
!
! RECURSIVE EVALUATION OF G(A,X) FOR X.LE.1.5 AND A.LT.-.5
!
  170 I = 1
      AE = AEPS
      AEP1 = AEPS + 1.e0_JDBL
      IF (X<0.25e0_JDBL .AND. AE>ALPHA) GO TO 210
      GO TO 70
  180 G = G*EXP(X*1.e0_JDBL)*X**(-AE)
      DO 190 K=1,MA
        G = (1.e0_JDBL-X*G)/(K-AE)
  190 CONTINUE
      ALG = LOG(G*1.e0_JDBL)
!
! EVALUATION OF GSTAR(A,X) IN TERMS OF G(A,X)
!
  200 GSTAR = 1.e0_JDBL
      IF (MA>=0 .AND. AEPS==0.e0_JDBL .AND. LHOOK)                       &
     &      CALL DR_HOOK('DGAM',1,ZHOOK_HANDLE)
      IF (MA>=0 .AND. AEPS==0.0_JDBL) RETURN
      SGT = SGA*SGGA
      T = LOG(AA) - X + A*ALX + ALG - ALGP1
      IF (T<-ALPREC .AND. LHOOK) CALL DR_HOOK('DGAM',1,ZHOOK_HANDLE)
      IF (T<-ALPREC) RETURN
      IF (T>=TOP) GO TO 320
      GSTAR = 1.e0_JDBL - SGT*EXP(T)
      IF (LHOOK) CALL DR_HOOK('DGAM',1,ZHOOK_HANDLE)
      RETURN
  210 I = 2
      ALGEP1 = DLGA(AEP1)
!
! EVALUATION OF GSTAR(A,X) FOR A.GT.ALPHA(X) BY TAYLOR
! EXPANSION
!
  220 G = 1.e0_JDBL
      TERM = 1.e0_JDBL
      SUMM = 1.e0_JDBL
      K = 0
  230 K = K + 1
      IF (K>600) GO TO 340
      TERM = X*TERM/(AE+K)
      SUMM = SUMM + TERM
      IF (ABS(TERM)>EPS*SUMM) GO TO 230
      ALGS = AE*ALX - X + LOG(SUMM) - ALGEP1
      IF (ALGS<=BOT) GO TO 310
      GSTAR = EXP(ALGS)
      G = 1.e0_JDBL - GSTAR
      IF (I/=2 .AND. LHOOK) CALL DR_HOOK('DGAM',1,ZHOOK_HANDLE)
      IF (I/=2) RETURN
      G = G*EXP(ALGEP1)/AE
      GO TO 180
!
! EVALUATION OF G(A,X) FOR X.GT.1.5 AND A.LE.ALPHA(X) BY
! MEANS OF THE LEGENDRE CONTINUED FRACTION
!
  240 GSTAR = 1.e0_JDBL
      XPA = X + 1.e0_JDBL - A
      XMA = X - 1.e0_JDBL - A
      P = 0.e0_JDBL
      Q = XPA*XMA
      R = 4.e0_JDBL*XPA
      S = -A + 1.e0_JDBL
      TERM = 1.e0_JDBL
      SUMM = 1.e0_JDBL
      RHO = 0.e0_JDBL
      K = 1
  250 K = K + 1
      IF (K>600) GO TO 330
      P = P + S
      Q = Q + R
      R = R + 8.e0_JDBL
      S = S + 2.e0_JDBL
      T = P*(1.e0_JDBL+RHO)
      RHO = T/(Q-T)
      TERM = RHO*TERM
      SUMM = SUMM + TERM
      IF (ABS(TERM)>EPS*SUMM) GO TO 250
      IF (A) 260, 270, 280
  260 G = SUMM/XPA
      ALG = LOG(G*1.e0_JDBL)
      GO TO 200
  270 G = SUMM/XPA
      IF (LHOOK) CALL DR_HOOK('DGAM',1,ZHOOK_HANDLE)
      RETURN
  280 ALG = A*ALX - X + LOG(A*SUMM/XPA) - ALGP1
      IF (ALG<=BOT) GO TO 300
      G = EXP(ALG)
      GSTAR = 1.e0_JDBL - G
      IF (LHOOK) CALL DR_HOOK('DGAM',1,ZHOOK_HANDLE)
      RETURN
  290 IFLG = 1
      IFLGST = 1
      IF (LHOOK) CALL DR_HOOK('DGAM',1,ZHOOK_HANDLE)
      RETURN
  300 IFLG = 4
      IF (LHOOK) CALL DR_HOOK('DGAM',1,ZHOOK_HANDLE)
      RETURN
  310 IFLGST = 4
      IF (LHOOK) CALL DR_HOOK('DGAM',1,ZHOOK_HANDLE)
      RETURN
  320 IFLGST = 5
      GSTAR = -SGT*AINF
      IF (LHOOK) CALL DR_HOOK('DGAM',1,ZHOOK_HANDLE)
      RETURN
  330 IFLG = 6
      IF (LHOOK) CALL DR_HOOK('DGAM',1,ZHOOK_HANDLE)
      RETURN
  340 IFLGST = 6
      IF (LHOOK) CALL DR_HOOK('DGAM',1,ZHOOK_HANDLE)
      RETURN

      CONTAINS

      FUNCTION DLGA(DX) RESULT(DLGAR)

      USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
      USE PARKIND1  ,ONLY : JPRB

      IMPLICIT NONE

      REAL(KIND=JPRB) :: ZHOOK_HANDLE

      REAL(KIND=JDBL) :: DLGAR
      REAL(KIND=JDBL) :: DX, DC, DP, DY, DT, DS
      REAL(KIND=JDBL),DIMENSION(8),PARAMETER :: DBNUM=(/                &
     & -3.617e3_JDBL,1.e0_JDBL,-6.91e2_JDBL,1.e0_JDBL,                  &
     & -1.e0_JDBL,   1.e0_JDBL,-1.e0_JDBL,  1.e0_JDBL/)
      REAL(KIND=JDBL),DIMENSION(8),PARAMETER :: DBDEN=(/                &
     &  1.224e5_JDBL,1.56e2_JDBL,3.6036e5_JDBL,1.188e3_JDBL,            &
     &  1.68e3_JDBL, 1.26e3_JDBL,3.6e2_JDBL,   1.2e1_JDBL/)

      IF (LHOOK) CALL DR_HOOK('DLGA',0,ZHOOK_HANDLE)

      DC = 0.5e0_JDBL*LOG(8.e0_JDBL*ATAN(1.e0_JDBL))
      DP = 1.e0_JDBL
      DY = DX
      Y = DY
!
! THE CONDITIONAL CLAUSE IN THE NEXT STATEMENT EXPRESSES THE
! INEQUALITY Y.GT.EXP(.121189*DPREC+.053905), WHERE DPREC IS THE
! NUMBER OF DECIMAL DIGITS CARRIED IN REAL*8 FLOATING-POINT
! ARITHMETIC.
!
!RJ-remark this magic number is for 53 significant bit prec only +/-!!!!
   10 IF (Y>35.027_JDBL) GO TO 20
      DP = DY*DP
      DY = DY + 1.e0_JDBL
      Y = DY
      GO TO 10
   20 DT = 1.e0_JDBL/(DY*DY)
      DS = 4.3867e4_JDBL/2.44188e5_JDBL
      DO 30 I=1,8
        DS = DT*DS + DBNUM(I)/DBDEN(I)
   30 CONTINUE
      DLGAR = (DY-0.5e0_JDBL)*LOG(DY) - DY + DC + DS/DY - LOG(DP)
      IF (LHOOK) CALL DR_HOOK('DLGA',1,ZHOOK_HANDLE)
      RETURN
      END FUNCTION DLGA

      END SUBROUTINE DGAM
