!     #################################################################################
SUBROUTINE DEALLOC_ISBA_n (CHI, DTI, GB, IG, I)
!     #################################################################################
!
!!****  *DEALLOC_ISBA_n * - Deallocate all arrays
!!
!!    PURPOSE
!!    -------
!
!!**  METHOD
!!    ------
!!
!!    REFERENCE
!!    ---------
!!      
!!
!!    AUTHOR
!!    ------
!!     V. Masson 
!!
!!    MODIFICATIONS
!!    -------------
!!      Original    01/2004
!!      P Samuelsson 10/2014  MEB
!!------------------------------------------------------------------
!
!
USE MODD_CH_ISBA_n, ONLY : CH_ISBA_t
USE MODD_DATA_ISBA_n, ONLY : DATA_ISBA_t
USE MODD_GR_BIOG_n, ONLY : GR_BIOG_t
USE MODD_ISBA_GRID_n, ONLY : ISBA_GRID_t
USE MODD_ISBA_n, ONLY : ISBA_t
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
IMPLICIT NONE
!
!*      0.1    declarations of arguments
!
!
!*      0.2    declarations of local variables
!
!-------------------------------------------------------------------------------------
!

!
TYPE(CH_ISBA_t), INTENT(INOUT) :: CHI
TYPE(DATA_ISBA_t), INTENT(INOUT) :: DTI
TYPE(GR_BIOG_t), INTENT(INOUT) :: GB
TYPE(ISBA_GRID_t), INTENT(INOUT) :: IG
TYPE(ISBA_t), INTENT(INOUT) :: I
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE

IF (LHOOK) CALL DR_HOOK('DEALLOC_ISBA_N',0,ZHOOK_HANDLE)
IF (ASSOCIATED(I%LCOVER     )) DEALLOCATE(I%LCOVER )
IF (ASSOCIATED(I%XCOVER     )) DEALLOCATE(I%XCOVER )
IF (ASSOCIATED(I%XZS        )) DEALLOCATE(I%XZS    )
IF (ASSOCIATED(I%XZ0EFFJPDIR)) DEALLOCATE(I%XZ0EFFJPDIR)
IF (ASSOCIATED(I%XCLAY      )) DEALLOCATE(I%XCLAY  )
IF (ASSOCIATED(I%XSAND      )) DEALLOCATE(I%XSAND  )
IF (ASSOCIATED(I%XSOC       )) DEALLOCATE(I%XSOC   )
IF (ASSOCIATED(I%XRUNOFFB   )) DEALLOCATE(I%XRUNOFFB)
!
IF (ASSOCIATED(I%XAOSIP))     DEALLOCATE( I%XAOSIP)
IF (ASSOCIATED(I%XAOSIM))     DEALLOCATE( I%XAOSIM)
IF (ASSOCIATED(I%XAOSJP))     DEALLOCATE( I%XAOSJP)
IF (ASSOCIATED(I%XAOSJM))     DEALLOCATE( I%XAOSJM)
IF (ASSOCIATED(I%XHO2IP))     DEALLOCATE( I%XHO2IP)
IF (ASSOCIATED(I%XHO2IM))     DEALLOCATE( I%XHO2IM)
IF (ASSOCIATED(I%XHO2JP))     DEALLOCATE( I%XHO2JP)
IF (ASSOCIATED(I%XHO2JM))     DEALLOCATE( I%XHO2JM)
IF (ASSOCIATED(I%XZ0EFFIP))   DEALLOCATE( I%XZ0EFFIP)
IF (ASSOCIATED(I%XZ0EFFIM))   DEALLOCATE( I%XZ0EFFIM)
IF (ASSOCIATED(I%XZ0EFFJP))   DEALLOCATE( I%XZ0EFFJP)
IF (ASSOCIATED(I%XZ0EFFJM))   DEALLOCATE( I%XZ0EFFJM)
IF (ASSOCIATED(I%XZ0REL))     DEALLOCATE( I%XZ0REL)
IF (ASSOCIATED(I%XSSO_SLOPE)) DEALLOCATE( I%XSSO_SLOPE)
!
!-------------------------------------------------------------------------------------
!
IF (ASSOCIATED(IG%XGRID_PAR )) DEALLOCATE(IG%XGRID_PAR )
IF (ASSOCIATED(IG%XLAT      )) DEALLOCATE(IG%XLAT      )
IF (ASSOCIATED(IG%XLON      )) DEALLOCATE(IG%XLON      )
IF (ASSOCIATED(IG%XMESH_SIZE)) DEALLOCATE(IG%XMESH_SIZE)
!
!-------------------------------------------------------------------------------------
!
IF (ASSOCIATED(GB%XMONOPOT)) DEALLOCATE(GB%XMONOPOT)
IF (ASSOCIATED(GB%XISOPOT))  DEALLOCATE(GB%XISOPOT)
!
!-------------------------------------------------------------------------------------
!
IF (ASSOCIATED(I%XLAI       )) DEALLOCATE(I%XLAI       )
IF (ASSOCIATED(I%XVEG       )) DEALLOCATE(I%XVEG       )
IF (ASSOCIATED(I%XRSMIN     )) DEALLOCATE(I%XRSMIN     )
IF (ASSOCIATED(I%XGAMMA     )) DEALLOCATE(I%XGAMMA     )
IF (ASSOCIATED(I%XWRMAX_CF  )) DEALLOCATE(I%XWRMAX_CF  )
IF (ASSOCIATED(I%XRGL       )) DEALLOCATE(I%XRGL       )
IF (ASSOCIATED(I%XCV        )) DEALLOCATE(I%XCV        )
IF (ASSOCIATED(I%XDG        )) DEALLOCATE(I%XDG        )
IF (ASSOCIATED(I%XDZG       )) DEALLOCATE(I%XDZG       )
IF (ASSOCIATED(I%XDZDIF     )) DEALLOCATE(I%XDZDIF     )
IF (ASSOCIATED(I%XDG_OLD    )) DEALLOCATE(I%XDG_OLD    )
IF (ASSOCIATED(I%NWG_LAYER  )) DEALLOCATE(I%NWG_LAYER  )
IF (ASSOCIATED(I%XDROOT     )) DEALLOCATE(I%XDROOT     )
IF (ASSOCIATED(I%XDG2       )) DEALLOCATE(I%XDG2       )
IF (ASSOCIATED(I%XROOTFRAC  )) DEALLOCATE(I%XROOTFRAC  )
IF (ASSOCIATED(I%XZ0        )) DEALLOCATE(I%XZ0        )
IF (ASSOCIATED(I%XZ0_O_Z0H  )) DEALLOCATE(I%XZ0_O_Z0H  )
IF (ASSOCIATED(I%XALBNIR_VEG)) DEALLOCATE(I%XALBNIR_VEG)
IF (ASSOCIATED(I%XALBVIS_VEG)) DEALLOCATE(I%XALBVIS_VEG)
IF (ASSOCIATED(I%XALBUV_VEG )) DEALLOCATE(I%XALBUV_VEG )
IF (ASSOCIATED(I%XEMIS      )) DEALLOCATE(I%XEMIS      )
IF (ASSOCIATED(I%XVEGTYPE   )) DEALLOCATE(I%XVEGTYPE   )
IF (ASSOCIATED(I%XGMES      )) DEALLOCATE(I%XGMES      )
IF (ASSOCIATED(I%XRE25      )) DEALLOCATE(I%XRE25      )
IF (ASSOCIATED(I%XBSLAI     )) DEALLOCATE(I%XBSLAI     )
IF (ASSOCIATED(I%XLAIMIN    )) DEALLOCATE(I%XLAIMIN    )
IF (ASSOCIATED(I%XSEFOLD    )) DEALLOCATE(I%XSEFOLD    )
IF (ASSOCIATED(I%XGC        )) DEALLOCATE(I%XGC        )
IF (ASSOCIATED(I%XDMAX      )) DEALLOCATE(I%XDMAX      )
IF (ASSOCIATED(I%XF2I       )) DEALLOCATE(I%XF2I       )
IF (ASSOCIATED(I%LSTRESS    )) DEALLOCATE(I%LSTRESS    )
IF (ASSOCIATED(I%XH_TREE    )) DEALLOCATE(I%XH_TREE    )
IF (ASSOCIATED(I%XCE_NITRO  )) DEALLOCATE(I%XCE_NITRO  )
IF (ASSOCIATED(I%XCF_NITRO  )) DEALLOCATE(I%XCF_NITRO  )
IF (ASSOCIATED(I%XCNA_NITRO )) DEALLOCATE(I%XCNA_NITRO )
IF (ASSOCIATED(I%XBSLAI_NITRO)) DEALLOCATE(I%XBSLAI_NITRO)
IF (ASSOCIATED(I%XPATCH        )) DEALLOCATE(I%XPATCH        )
IF (ASSOCIATED(I%XVEGTYPE_PATCH)) DEALLOCATE(I%XVEGTYPE_PATCH)
IF (ASSOCIATED(I%XPATCH_OLD  )) DEALLOCATE(I%XPATCH_OLD  )
IF (ASSOCIATED(I%NSIZE_NATURE_P)) DEALLOCATE(I%NSIZE_NATURE_P)
IF (ASSOCIATED(I%NR_NATURE_P)) DEALLOCATE(I%NR_NATURE_P)
IF (ASSOCIATED(I%XWDRAIN)) DEALLOCATE(I%XWDRAIN)
IF (ASSOCIATED(I%XTDEEP )) DEALLOCATE(I%XTDEEP )
IF (ASSOCIATED(I%XGAMMAT)) DEALLOCATE(I%XGAMMAT)
IF (ASSOCIATED(I%XWWILT)) DEALLOCATE(I%XWWILT)
IF (ASSOCIATED(I%XWFC  )) DEALLOCATE(I%XWFC  )
IF (ASSOCIATED(I%XWSAT )) DEALLOCATE(I%XWSAT )
IF (ASSOCIATED(I%XWD0)) DEALLOCATE(I%XWD0)
IF (ASSOCIATED(I%XKANISO)) DEALLOCATE(I%XKANISO)
IF (ASSOCIATED(I%XTAUICE)) DEALLOCATE(I%XTAUICE)
IF (ASSOCIATED(I%XBCOEF)) DEALLOCATE(I%XBCOEF)
IF (ASSOCIATED(I%XRUNOFFD)) DEALLOCATE(I%XRUNOFFD)
IF (ASSOCIATED(I%XSOILWGHT)) DEALLOCATE(I%XSOILWGHT)
IF (ASSOCIATED(I%XHCAPSOIL)) DEALLOCATE(I%XHCAPSOIL)
IF (ASSOCIATED(I%XCONDDRY )) DEALLOCATE(I%XCONDDRY )
IF (ASSOCIATED(I%XCONDSLD )) DEALLOCATE(I%XCONDSLD )
IF (ASSOCIATED(I%XCGSAT )) DEALLOCATE(I%XCGSAT )
IF (ASSOCIATED(I%XC1SAT)) DEALLOCATE(I%XC1SAT)
IF (ASSOCIATED(I%XC2REF)) DEALLOCATE(I%XC2REF)
IF (ASSOCIATED(I%XC3   )) DEALLOCATE(I%XC3   )
IF (ASSOCIATED(I%XC4B  )) DEALLOCATE(I%XC4B  )
IF (ASSOCIATED(I%XACOEF)) DEALLOCATE(I%XACOEF)
IF (ASSOCIATED(I%XPCOEF)) DEALLOCATE(I%XPCOEF)
IF (ASSOCIATED(I%XC4REF)) DEALLOCATE(I%XC4REF)
IF (ASSOCIATED(I%XCONDSAT)) DEALLOCATE(I%XCONDSAT)
IF (ASSOCIATED(I%XMPOTSAT)) DEALLOCATE(I%XMPOTSAT)
IF (ASSOCIATED(I%XALBNIR_DRY)) DEALLOCATE(I%XALBNIR_DRY)
IF (ASSOCIATED(I%XALBVIS_DRY)) DEALLOCATE(I%XALBVIS_DRY)
IF (ASSOCIATED(I%XALBUV_DRY )) DEALLOCATE(I%XALBUV_DRY )
IF (ASSOCIATED(I%XALBNIR_WET)) DEALLOCATE(I%XALBNIR_WET)
IF (ASSOCIATED(I%XALBVIS_WET)) DEALLOCATE(I%XALBVIS_WET)
IF (ASSOCIATED(I%XALBUV_WET )) DEALLOCATE(I%XALBUV_WET )
IF (ASSOCIATED(I%XABC)) DEALLOCATE(I%XABC)
IF (ASSOCIATED(I%XPOI)) DEALLOCATE(I%XPOI)
!
IF (ASSOCIATED(I%XGNDLITTER  )) DEALLOCATE(I%XGNDLITTER  )
IF (ASSOCIATED(I%XRGLGV      )) DEALLOCATE(I%XRGLGV      )
IF (ASSOCIATED(I%XGAMMAGV    )) DEALLOCATE(I%XGAMMAGV    )
IF (ASSOCIATED(I%XRSMINGV    )) DEALLOCATE(I%XRSMINGV    )
IF (ASSOCIATED(I%XROOTFRACGV )) DEALLOCATE(I%XROOTFRACGV )
IF (ASSOCIATED(I%XWRMAX_CFGV )) DEALLOCATE(I%XWRMAX_CFGV )
IF (ASSOCIATED(I%XLAIGV      )) DEALLOCATE(I%XLAIGV      )
IF (ASSOCIATED(I%XZ0LITTER   )) DEALLOCATE(I%XZ0LITTER   )
IF (ASSOCIATED(I%XH_VEG      )) DEALLOCATE(I%XH_VEG      )
!
!-------------------------------------------------------------------------------------
!
IF(ASSOCIATED(CHI%XDEP))      DEALLOCATE(CHI%XDEP)
IF(ASSOCIATED(CHI%CCH_NAMES)) DEALLOCATE(CHI%CCH_NAMES)
IF(ASSOCIATED(CHI%SVI%CSV))       DEALLOCATE(CHI%SVI%CSV)
!
!-------------------------------------------------------------------------------------
!
IF(ASSOCIATED(I%XTI_MIN))      DEALLOCATE(I%XTI_MIN)
IF(ASSOCIATED(I%XTI_MAX))      DEALLOCATE(I%XTI_MAX)
IF(ASSOCIATED(I%XTI_MEAN))     DEALLOCATE(I%XTI_MEAN)
IF(ASSOCIATED(I%XTI_STD))      DEALLOCATE(I%XTI_STD)
IF(ASSOCIATED(I%XTI_SKEW))     DEALLOCATE(I%XTI_SKEW)
IF(ASSOCIATED(I%XTAB_FSAT))    DEALLOCATE(I%XTAB_FSAT)
IF(ASSOCIATED(I%XTAB_WTOP))    DEALLOCATE(I%XTAB_WTOP)
IF(ASSOCIATED(I%XTAB_QTOP))    DEALLOCATE(I%XTAB_QTOP)
IF(ASSOCIATED(I%XMUF))         DEALLOCATE(I%XMUF)
IF(ASSOCIATED(I%XFSAT))        DEALLOCATE(I%XFSAT)
IF(ASSOCIATED(I%XD_ICE))       DEALLOCATE(I%XD_ICE)
IF(ASSOCIATED(I%XKSAT_ICE))    DEALLOCATE(I%XKSAT_ICE)
IF(ASSOCIATED(I%XFRACSOC))     DEALLOCATE(I%XFRACSOC)
IF(ASSOCIATED(I%XTOPQS))       DEALLOCATE(I%XTOPQS)
IF(ASSOCIATED(I%XFWTD))        DEALLOCATE(I%XFWTD)
IF(ASSOCIATED(I%XWTD))         DEALLOCATE(I%XWTD)
!
IF(ASSOCIATED(I%XFFLOOD))      DEALLOCATE(I%XFFLOOD)
IF(ASSOCIATED(I%XPIFLOOD))     DEALLOCATE(I%XPIFLOOD)
!
IF(ASSOCIATED(I%XPSNG))        DEALLOCATE(I%XPSNG)
IF(ASSOCIATED(I%XPSNV))        DEALLOCATE(I%XPSNV)
IF(ASSOCIATED(I%XPSNV_A))      DEALLOCATE(I%XPSNV_A)
IF(ASSOCIATED(I%XPSN))         DEALLOCATE(I%XPSN)
IF(ASSOCIATED(I%XDIR_ALB_WITH_SNOW))    DEALLOCATE(I%XDIR_ALB_WITH_SNOW)
IF(ASSOCIATED(I%XSCA_ALB_WITH_SNOW))    DEALLOCATE(I%XSCA_ALB_WITH_SNOW)
IF(ASSOCIATED(I%XFFG))         DEALLOCATE(I%XFFG)
IF(ASSOCIATED(I%XFFV))         DEALLOCATE(I%XFFV)
IF(ASSOCIATED(I%XFF))          DEALLOCATE(I%XFF)
IF(ASSOCIATED(I%XFFROZEN))     DEALLOCATE(I%XFFROZEN)
IF(ASSOCIATED(I%XALBF))        DEALLOCATE(I%XALBF)
IF(ASSOCIATED(I%XEMISF))       DEALLOCATE(I%XEMISF)
!-------------------------------------------------------------------------------------
IF(ASSOCIATED(I%XCPL_EFLOOD))  DEALLOCATE(I%XCPL_EFLOOD)
IF(ASSOCIATED(I%XCPL_PFLOOD))  DEALLOCATE(I%XCPL_PFLOOD)
IF(ASSOCIATED(I%XCPL_IFLOOD))  DEALLOCATE(I%XCPL_IFLOOD)
IF(ASSOCIATED(I%XCPL_DRAIN))   DEALLOCATE(I%XCPL_DRAIN)
IF(ASSOCIATED(I%XCPL_RUNOFF))  DEALLOCATE(I%XCPL_RUNOFF)
IF(ASSOCIATED(I%XCPL_ICEFLUX)) DEALLOCATE(I%XCPL_ICEFLUX)
IF(ASSOCIATED(I%XCPL_RECHARGE)) DEALLOCATE(I%XCPL_RECHARGE)
!-------------------------------------------------------------------------------------
IF(ASSOCIATED(I%XICE_STO))     DEALLOCATE(I%XICE_STO)
!-------------------------------------------------------------------------------------
IF(ASSOCIATED(DTI%XPAR_VEGTYPE    )) DEALLOCATE(DTI%XPAR_VEGTYPE    )
IF(ASSOCIATED(DTI%XPAR_LAI        )) DEALLOCATE(DTI%XPAR_LAI        )
IF(ASSOCIATED(DTI%XPAR_H_TREE     )) DEALLOCATE(DTI%XPAR_H_TREE     )
IF(ASSOCIATED(DTI%XPAR_DG         )) DEALLOCATE(DTI%XPAR_DG         )
IF(ASSOCIATED(DTI%XPAR_ROOTFRAC   )) DEALLOCATE(DTI%XPAR_ROOTFRAC   )
IF(ASSOCIATED(DTI%XPAR_VEG        )) DEALLOCATE(DTI%XPAR_VEG        )
IF(ASSOCIATED(DTI%XPAR_Z0         )) DEALLOCATE(DTI%XPAR_Z0         )
IF(ASSOCIATED(DTI%XPAR_EMIS       )) DEALLOCATE(DTI%XPAR_EMIS       )
IF(ASSOCIATED(DTI%XPAR_DICE       )) DEALLOCATE(DTI%XPAR_DICE       )
IF(ASSOCIATED(DTI%XPAR_RSMIN      )) DEALLOCATE(DTI%XPAR_RSMIN      )
IF(ASSOCIATED(DTI%XPAR_GAMMA      )) DEALLOCATE(DTI%XPAR_GAMMA      )
IF(ASSOCIATED(DTI%XPAR_WRMAX_CF   )) DEALLOCATE(DTI%XPAR_WRMAX_CF   )
IF(ASSOCIATED(DTI%XPAR_RGL        )) DEALLOCATE(DTI%XPAR_RGL        )
IF(ASSOCIATED(DTI%XPAR_CV         )) DEALLOCATE(DTI%XPAR_CV         )
IF(ASSOCIATED(DTI%XPAR_Z0_O_Z0H   )) DEALLOCATE(DTI%XPAR_Z0_O_Z0H   )
IF(ASSOCIATED(DTI%XPAR_ALBNIR_VEG )) DEALLOCATE(DTI%XPAR_ALBNIR_VEG )
IF(ASSOCIATED(DTI%XPAR_ALBVIS_VEG )) DEALLOCATE(DTI%XPAR_ALBVIS_VEG )
IF(ASSOCIATED(DTI%XPAR_ALBUV_VEG  )) DEALLOCATE(DTI%XPAR_ALBUV_VEG  )
IF(ASSOCIATED(DTI%XPAR_ALBNIR_SOIL)) DEALLOCATE(DTI%XPAR_ALBNIR_SOIL)
IF(ASSOCIATED(DTI%XPAR_ALBVIS_SOIL)) DEALLOCATE(DTI%XPAR_ALBVIS_SOIL)
IF(ASSOCIATED(DTI%XPAR_ALBUV_SOIL )) DEALLOCATE(DTI%XPAR_ALBUV_SOIL )
IF(ASSOCIATED(DTI%XPAR_GMES       )) DEALLOCATE(DTI%XPAR_GMES       )
IF(ASSOCIATED(DTI%XPAR_BSLAI      )) DEALLOCATE(DTI%XPAR_BSLAI      )
IF(ASSOCIATED(DTI%XPAR_SEFOLD     )) DEALLOCATE(DTI%XPAR_SEFOLD     )
IF(ASSOCIATED(DTI%XPAR_GC         )) DEALLOCATE(DTI%XPAR_GC         )
IF(ASSOCIATED(DTI%XPAR_DMAX       )) DEALLOCATE(DTI%XPAR_DMAX       )
IF(ASSOCIATED(DTI%XPAR_RE25       )) DEALLOCATE(DTI%XPAR_RE25       )
IF(ASSOCIATED(DTI%XPAR_LAIMIN     )) DEALLOCATE(DTI%XPAR_LAIMIN     )
IF(ASSOCIATED(DTI%XPAR_F2I        )) DEALLOCATE(DTI%XPAR_F2I        )
IF(ASSOCIATED(DTI%XPAR_CE_NITRO   )) DEALLOCATE(DTI%XPAR_CE_NITRO   )
IF(ASSOCIATED(DTI%XPAR_CF_NITRO   )) DEALLOCATE(DTI%XPAR_CF_NITRO   )
IF(ASSOCIATED(DTI%XPAR_CNA_NITRO  )) DEALLOCATE(DTI%XPAR_CNA_NITRO  )
IF(ASSOCIATED(DTI%LPAR_STRESS     )) DEALLOCATE(DTI%LPAR_STRESS     )
IF(ASSOCIATED(DTI%XPAR_IRRIG      )) DEALLOCATE(DTI%XPAR_IRRIG      )
IF(ASSOCIATED(DTI%XPAR_WATSUP     )) DEALLOCATE(DTI%XPAR_WATSUP     )
!
IF(ASSOCIATED(I%XRED_NOISE      )) DEALLOCATE(I%XRED_NOISE)
IF(ASSOCIATED(I%XINCR      )) DEALLOCATE(I%XINCR)
!
!-------------------------------------------------------------------------------------
IF (LHOOK) CALL DR_HOOK('DEALLOC_ISBA_N',1,ZHOOK_HANDLE)
!-------------------------------------------------------------------------------------
!
END SUBROUTINE DEALLOC_ISBA_n
