!     #########
      SUBROUTINE CONVERT_PATCH_TEB (BDD, DTB, DTCO, DTT, TOP, &
                                    PCOVER,OCOVER,PDEF_ROAD_DIR,        &
                                   PZ0_TOWN,                           &
                                   PALB_ROOF,                          &
                                   PEMIS_ROOF,PHC_ROOF,PTC_ROOF,       &
                                   PD_ROOF,                            &
                                   PALB_ROAD,                          &
                                   PEMIS_ROAD,PHC_ROAD,PTC_ROAD,       &
                                   PD_ROAD,                            &
                                   PALB_WALL,                          &
                                   PEMIS_WALL,PHC_WALL,PTC_WALL,       &
                                   PD_WALL,                            &
                                   PBLD_HEIGHT,                        &
                                   PWALL_O_HOR,PBLD,                   &
                                   PGARDEN, PROAD_DIR,                 &
                                   PH_TRAFFIC,  PLE_TRAFFIC,           &
                                   PH_INDUSTRY, PLE_INDUSTRY,          &
                                   PHC_FLOOR, PTC_FLOOR, PD_FLOOR,     &
                                   PTCOOL_TARGET, PTHEAT_TARGET,       &
                                   PF_WASTE_CAN, PEFF_HEAT, PQIN,      &
                                   PQIN_FRAD, PSHGC, PU_WIN, PGR,      &
                                   PSHGC_SH, PFLOOR_HEIGHT, PINF,      &
                                   PF_WATER_COND, PQIN_FLAT,           &
                                   PHR_TARGET, PV_VENT, PCAP_SYS_HEAT, &
                                   PCAP_SYS_RAT, PT_ADP, PM_SYS_RAT,   &
                                   PCOP_RAT, PT_SIZE_MAX, PT_SIZE_MIN, &
                                   PSHADE, PNATVENT, PROUGH_ROOF,      &
                                   PRESIDENTIAL,                       &
                                   PROUGH_WALL, PGREENROOF,            &
                                   PEMIS_PANEL, PALB_PANEL, PEFF_PANEL,&
                                   PFRAC_PANEL                         )
!     ##############################################################
!
!!**** *CONVERT_PATCH_TEB* compilation of conver_cover_isba, pgd_isba_par and
!!      init_from_data_isba_parn
!!
!!    PURPOSE
!!    -------
!!
!!    METHOD
!!    ------
!!   
!
!!    EXTERNAL
!!    --------
!!
!!    IMPLICIT ARGUMENTS
!!    ------------------
!!
!!    REFERENCE
!!    ---------
!!
!!    AUTHOR
!!    ------
!!
!!    S. Faroux        Meteo-France
!!
!!    MODIFICATION
!!    ------------
!!
!!    Original    16/11/10
!!    G. Pigeon     /09/12: add ROUGH_ROOF and ROUGH_WALL coef for outdoor conv. coef
!!    V. Masson      08/13  adds solar panels
!!
!----------------------------------------------------------------------------
!
!*    0.     DECLARATION
!            -----------
!
!
USE MODD_BLD_DESCRIPTION_n, ONLY : BLD_DESC_t
USE MODD_DATA_BEM_n, ONLY : DATA_BEM_t
USE MODD_DATA_COVER_n, ONLY : DATA_COVER_t
USE MODD_DATA_TEB_n, ONLY : DATA_TEB_t
USE MODD_TEB_OPTION_n, ONLY : TEB_OPTIONS_t
!
USE MODD_SURF_PAR,       ONLY : XUNDEF
!
USE MODD_DATA_COVER_PAR, ONLY : NDATA_ROAD_LAYER, NDATA_WALL_LAYER,               &
                                NDATA_ROOF_LAYER, NDATA_FLOOR_LAYER
USE MODD_DATA_COVER,     ONLY : XDATA_Z0_TOWN, XDATA_ALB_ROOF,                    &
                                XDATA_EMIS_ROOF, XDATA_HC_ROOF, XDATA_TC_ROOF,    &
                                XDATA_D_ROOF, XDATA_ALB_ROAD, XDATA_EMIS_ROAD,    &
                                XDATA_HC_ROAD, XDATA_TC_ROAD, XDATA_D_ROAD,       &
                                XDATA_ALB_WALL, XDATA_EMIS_WALL, XDATA_HC_WALL,   &
                                XDATA_TC_WALL, XDATA_D_WALL, XDATA_BLD_HEIGHT,    &
                                XDATA_H_TRAFFIC, XDATA_LE_TRAFFIC,                &
                                XDATA_H_INDUSTRY, XDATA_LE_INDUSTRY,              &
                                XDATA_HC_FLOOR, XDATA_TC_FLOOR, XDATA_D_FLOOR,    &
                                XDATA_TCOOL_TARGET, XDATA_THEAT_TARGET,           &
                                XDATA_F_WASTE_CAN, XDATA_EFF_HEAT, XDATA_QIN,     &
                                XDATA_QIN_FRAD, XDATA_SHGC, XDATA_U_WIN, XDATA_GR,&
                                XDATA_SHGC_SH, XDATA_FLOOR_HEIGHT, XDATA_INF,     &
                                XDATA_F_WATER_COND, XDATA_QIN_FLAT,               &   
                                XDATA_HR_TARGET, XDATA_V_VENT, XDATA_CAP_SYS_HEAT,&
                                XDATA_CAP_SYS_RAT, XDATA_T_ADP, XDATA_M_SYS_RAT,  &
                                XDATA_COP_RAT, XDATA_T_SIZE_MAX, XDATA_T_SIZE_MIN,&
                                XDATA_SHADE, XDATA_NATVENT, XDATA_ROUGH_ROOF,     &
                                XDATA_ROUGH_WALL, XDATA_RESIDENTIAL,XDATA_FRAC_GR,&
                                XDATA_EMIS_PANEL,XDATA_ALB_PANEL, XDATA_EFF_PANEL,&
                                XDATA_FRAC_PANEL
!
!
USE MODI_THERMAL_LAYERS_CONF
USE MODI_INI_DATA_PARAM_TEB
USE MODI_AV_PGD
!
USE YOMHOOK   ,ONLY : LHOOK,   DR_HOOK
USE PARKIND1  ,ONLY : JPRB
!
USE MODI_ABOR1_SFX
!
IMPLICIT NONE
!
!*    0.1    Declaration of arguments
!            ------------------------
!
!
TYPE(BLD_DESC_t), INTENT(INOUT) :: BDD
TYPE(DATA_BEM_t), INTENT(INOUT) :: DTB
TYPE(DATA_COVER_t), INTENT(INOUT) :: DTCO
TYPE(DATA_TEB_t), INTENT(INOUT) :: DTT
TYPE(TEB_OPTIONS_t), INTENT(INOUT) :: TOP
!
REAL, DIMENSION(:,:),   INTENT(IN)    :: PCOVER
LOGICAL, DIMENSION(:),  INTENT(IN)    :: OCOVER
REAL,                   INTENT(IN)    :: PDEF_ROAD_DIR ! default road direction
!
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PZ0_TOWN
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PALB_ROOF
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PEMIS_ROOF
REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL   :: PHC_ROOF
REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL   :: PTC_ROOF
REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL   :: PD_ROOF
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PALB_ROAD
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PEMIS_ROAD
REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL   :: PHC_ROAD
REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL   :: PTC_ROAD
REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL   :: PD_ROAD
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PALB_WALL
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PEMIS_WALL
REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL   :: PHC_WALL
REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL   :: PTC_WALL
REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL   :: PD_WALL
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PBLD_HEIGHT
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PWALL_O_HOR
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PBLD
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PGARDEN
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PROAD_DIR
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PH_TRAFFIC
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PLE_TRAFFIC
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PH_INDUSTRY
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PLE_INDUSTRY
REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL   :: PHC_FLOOR
REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL   :: PTC_FLOOR
REAL, DIMENSION(:,:), INTENT(OUT), OPTIONAL   :: PD_FLOOR
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PTCOOL_TARGET
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PTHEAT_TARGET
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PF_WASTE_CAN
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PEFF_HEAT
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PQIN
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PQIN_FRAD
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PSHGC
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PU_WIN
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PGR
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PSHGC_SH
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PFLOOR_HEIGHT
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PINF
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PF_WATER_COND
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PQIN_FLAT
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PHR_TARGET
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PV_VENT
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PCAP_SYS_HEAT
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PCAP_SYS_RAT
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PT_ADP
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PM_SYS_RAT
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PCOP_RAT
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PT_SIZE_MAX
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PT_SIZE_MIN
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PSHADE
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PNATVENT
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PROUGH_ROOF
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PROUGH_WALL
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PRESIDENTIAL
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PGREENROOF
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PEMIS_PANEL
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PALB_PANEL
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PEFF_PANEL
REAL, DIMENSION(:),   INTENT(OUT), OPTIONAL   :: PFRAC_PANEL
!
!*    0.2    Declaration of local variables
!            ------------------------------
!
REAL, DIMENSION(:,:), ALLOCATABLE :: ZTC, ZHC, ZD
INTEGER               :: JLAYER    ! loop counter on layers
INTEGER               :: IL        ! number of points
!
 CHARACTER(LEN=3)      :: YAVG      ! Type of averaging for buildings
 CHARACTER(LEN=4)      :: YAREA     ! Area where parameter is averaged
!
!*    0.3    Declaration of namelists
!            ------------------------
!
REAL(KIND=JPRB) :: ZHOOK_HANDLE
!
!-------------------------------------------------------------------------------
!
!*    1.      Initializations
!             ---------------
!
IF (LHOOK) CALL DR_HOOK('CONVERT_PATCH_TEB',0,ZHOOK_HANDLE)
!
IF (TOP%CBLD_ATYPE=='ARI') THEN
  YAVG=TOP%CBLD_ATYPE
  YAREA='BLD'
ELSE
  YAVG=TOP%CBLD_ATYPE
  YAREA='BLV'
END IF
!
IL = SIZE(PCOVER,1)
!-------------------------------------------------------------------------------
!
!       ROAD DIRECTION 
!       --------------
IF (PRESENT(PROAD_DIR)) THEN
  IF (DTT%LDATA_ROAD_DIR) THEN
    PROAD_DIR=DTT%XPAR_ROAD_DIR
  ELSE
    PROAD_DIR=PDEF_ROAD_DIR
  ENDIF
ENDIF
!
!
!       GARDEN fraction
!       ---------------
IF (PRESENT(PGARDEN)) THEN
  IF (DTT%LDATA_GARDEN) THEN
    PGARDEN=DTT%XPAR_GARDEN
  ELSE
    CALL AV_PGD(DTCO, &
                 PGARDEN, PCOVER, DTCO%XDATA_GARDEN(:),'TWN','ARI',OCOVER)
  ENDIF
ENDIF
!
!
!       BLD fraction
!       -------------
IF (PRESENT(PBLD)) THEN
  IF (DTT%LDATA_BLD) THEN
    PBLD=DTT%XPAR_BLD  
  ELSE
    CALL AV_PGD(DTCO, &
                 PBLD, PCOVER, DTCO%XDATA_BLD(:),'TWN','ARI',OCOVER)
  ENDIF
ENDIF
!
!
!      Z0_TOWN
!      ----------
IF (PRESENT(PZ0_TOWN)) THEN 
  IF (DTT%LDATA_Z0_TOWN) THEN
    PZ0_TOWN=DTT%XPAR_Z0_TOWN  
  ELSE
    CALL AV_PGD(DTCO, &
                 PZ0_TOWN ,PCOVER ,XDATA_Z0_TOWN (:),'TWN','CDN',OCOVER)  
  ENDIF  
ENDIF
!
!      BLD Height
!      ----------
IF (PRESENT(PBLD_HEIGHT)) THEN 
  IF (DTT%LDATA_BLD_HEIGHT) THEN
    PBLD_HEIGHT=DTT%XPAR_BLD_HEIGHT
  ELSE
    CALL AV_PGD(DTCO, &
                 PBLD_HEIGHT ,PCOVER ,XDATA_BLD_HEIGHT (:),'BLD','ARI',OCOVER)  
  ENDIF  
ENDIF
!
!      WALL O HOR
!      ----------
IF (PRESENT(PWALL_O_HOR)) THEN
  IF (DTT%LDATA_WALL_O_HOR) THEN
    PWALL_O_HOR=DTT%XPAR_WALL_O_HOR 
  ELSE
    CALL AV_PGD(DTCO, &
                 PWALL_O_HOR ,PCOVER ,DTCO%XDATA_WALL_O_HOR (:),'BLD','ARI',OCOVER)  
  ENDIF  
ENDIF
!
!      ALB_ROOF
!      ----------
IF (PRESENT(PALB_ROOF)) THEN 
  IF (DTT%LDATA_ALB_ROOF) THEN
    PALB_ROOF=DTT%XPAR_ALB_ROOF
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, &
                            DTT%NPAR_BLDCODE,PALB_ROOF=PALB_ROOF)
  ELSE
    CALL AV_PGD(DTCO, &
                 PALB_ROOF ,PCOVER ,XDATA_ALB_ROOF (:),YAREA,YAVG,OCOVER)  
  ENDIF  
ENDIF
!
!      EMIS_ROOF
!      ----------
IF (PRESENT(PEMIS_ROOF)) THEN 
  IF (DTT%LDATA_EMIS_ROOF) THEN
    PEMIS_ROOF=DTT%XPAR_EMIS_ROOF
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, &
                            DTT%NPAR_BLDCODE,PEMIS_ROOF=PEMIS_ROOF)
  ELSE
    CALL AV_PGD(DTCO, &
                 PEMIS_ROOF ,PCOVER ,XDATA_EMIS_ROOF (:),YAREA,YAVG,OCOVER)  
  ENDIF  
ENDIF
!
!      HC_ROOF, TC_ROOF, D_ROOF
!      ------------------------
!
IF (PRESENT(PHC_ROOF) .AND. PRESENT(PTC_ROOF) .AND. PRESENT(PD_ROOF)) THEN
  IF (DTT%LDATA_HC_ROOF) THEN
    CALL ALLOCATE_THERMAL_WORK(DTT%NPAR_ROOF_LAYER)
    ZHC=DTT%XPAR_HC_ROOF
    ZTC=DTT%XPAR_TC_ROOF
    ZD =DTT%XPAR_D_ROOF
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL ALLOCATE_THERMAL_WORK(BDD%NDESC_ROOF_LAYER)
    CALL INI_DATA_PARAM_TEB(BDD, &
                            DTT%NPAR_BLDCODE,PHC_ROOF=ZHC)
    CALL INI_DATA_PARAM_TEB(BDD, &
                            DTT%NPAR_BLDCODE,PTC_ROOF=ZTC)
    CALL INI_DATA_PARAM_TEB(BDD, &
                            DTT%NPAR_BLDCODE,PD_ROOF =ZD )
  ELSE
    CALL ALLOCATE_THERMAL_WORK(NDATA_ROOF_LAYER)
    DO JLAYER=1,NDATA_ROOF_LAYER
      CALL AV_PGD(DTCO, &
                 ZHC(:,JLAYER), PCOVER, XDATA_HC_ROOF (:,JLAYER),YAREA,YAVG,OCOVER)
      CALL AV_PGD(DTCO, &
                 ZTC(:,JLAYER), PCOVER ,XDATA_TC_ROOF (:,JLAYER),YAREA,YAVG,OCOVER)
      CALL AV_PGD(DTCO, &
                 ZD (:,JLAYER), PCOVER ,XDATA_D_ROOF  (:,JLAYER),YAREA,YAVG,OCOVER)
    ENDDO
  ENDIF  
  CALL THERMAL_LAYERS_CONF('ROOF ',ZHC,ZTC,ZD,PHC_ROOF,PTC_ROOF,PD_ROOF)
  CALL DEALLOCATE_THERMAL_WORK
ENDIF
!
!      ALB_ROAD
!      ----------
IF (PRESENT(PALB_ROAD)) THEN 
  IF (DTT%LDATA_ALB_ROAD) THEN
    PALB_ROAD=DTT%XPAR_ALB_ROAD
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, &
                            DTT%NPAR_BLDCODE,PALB_ROAD=PALB_ROAD)
  ELSE
    CALL AV_PGD(DTCO, &
                 PALB_ROAD ,PCOVER ,XDATA_ALB_ROAD (:),'STR','ARI',OCOVER)  
  ENDIF  
ENDIF
!
!      EMIS_ROAD
!      ----------
IF (PRESENT(PEMIS_ROAD)) THEN 
  IF (DTT%LDATA_EMIS_ROAD) THEN
    PEMIS_ROAD=DTT%XPAR_EMIS_ROAD
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, &
                            DTT%NPAR_BLDCODE,PEMIS_ROAD=PEMIS_ROAD)
  ELSE
    CALL AV_PGD(DTCO, &
                 PEMIS_ROAD ,PCOVER ,XDATA_EMIS_ROAD (:),'STR','ARI',OCOVER)  
  ENDIF  
ENDIF
!
!      HC_ROAD, TC_ROAD, D_ROAD
!      ------------------------
!
IF (PRESENT(PHC_ROAD) .AND. PRESENT(PTC_ROAD) .AND. PRESENT(PD_ROAD)) THEN
  IF (DTT%LDATA_HC_ROAD) THEN
    CALL ALLOCATE_THERMAL_WORK(DTT%NPAR_ROAD_LAYER)
    ZHC=DTT%XPAR_HC_ROAD
    ZTC=DTT%XPAR_TC_ROAD
    ZD =DTT%XPAR_D_ROAD
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL ALLOCATE_THERMAL_WORK(BDD%NDESC_ROAD_LAYER)
    CALL INI_DATA_PARAM_TEB(BDD, &
                            DTT%NPAR_BLDCODE,PHC_ROAD=ZHC)
    CALL INI_DATA_PARAM_TEB(BDD, &
                            DTT%NPAR_BLDCODE,PTC_ROAD=ZTC)
    CALL INI_DATA_PARAM_TEB(BDD, &
                            DTT%NPAR_BLDCODE,PD_ROAD =ZD )
  ELSE
    CALL ALLOCATE_THERMAL_WORK(NDATA_ROAD_LAYER)
    DO JLAYER=1,NDATA_ROAD_LAYER
      CALL AV_PGD(DTCO, &
                 ZHC(:,JLAYER), PCOVER, XDATA_HC_ROAD (:,JLAYER),YAREA,YAVG,OCOVER)
      CALL AV_PGD(DTCO, &
                 ZTC(:,JLAYER), PCOVER ,XDATA_TC_ROAD (:,JLAYER),YAREA,YAVG,OCOVER)
      CALL AV_PGD(DTCO, &
                 ZD (:,JLAYER), PCOVER ,XDATA_D_ROAD  (:,JLAYER),YAREA,YAVG,OCOVER)
      !CALL AV_PGD (PHC_ROAD(:,JLAYER), PCOVER, XDATA_HC_ROAD (:,JLAYER),YAREA,YAVG)
      !CALL AV_PGD (PTC_ROAD(:,JLAYER), PCOVER ,XDATA_TC_ROAD (:,JLAYER),YAREA,YAVG)
      !CALL AV_PGD (PD_ROAD(:,JLAYER), PCOVER ,XDATA_D_ROAD  (:,JLAYER),YAREA,YAVG)
    ENDDO
  ENDIF  
  CALL THERMAL_LAYERS_CONF('ROAD ',ZHC,ZTC,ZD,PHC_ROAD,PTC_ROAD,PD_ROAD)
  CALL DEALLOCATE_THERMAL_WORK
ENDIF
!
!      ALB_WALL
!      ----------
IF (PRESENT(PALB_WALL)) THEN
  IF (DTT%LDATA_ALB_WALL) THEN
    PALB_WALL=DTT%XPAR_ALB_WALL
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, &
                            DTT%NPAR_BLDCODE,PALB_WALL=PALB_WALL)
  ELSE
    CALL AV_PGD(DTCO, &
                 PALB_WALL ,PCOVER ,XDATA_ALB_WALL (:),YAREA,YAVG,OCOVER)  
  ENDIF  
ENDIF
!
!      EMIS_WALL
!      ----------
IF (PRESENT(PEMIS_WALL)) THEN
  IF (DTT%LDATA_EMIS_WALL) THEN
    PEMIS_WALL=DTT%XPAR_EMIS_WALL
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, &
                            DTT%NPAR_BLDCODE,PEMIS_WALL=PEMIS_WALL)
  ELSE
    CALL AV_PGD(DTCO, &
                 PEMIS_WALL ,PCOVER ,XDATA_EMIS_WALL (:),YAREA,YAVG,OCOVER)  
  ENDIF  
ENDIF
!
!      HC_WALL, TC_WALL, D_WALL
!      ------------------------
!
IF (PRESENT(PHC_WALL) .AND. PRESENT(PTC_WALL) .AND. PRESENT(PD_WALL)) THEN
  IF (DTT%LDATA_HC_WALL) THEN
    CALL ALLOCATE_THERMAL_WORK(DTT%NPAR_WALL_LAYER)
    ZHC=DTT%XPAR_HC_WALL
    ZTC=DTT%XPAR_TC_WALL
    ZD =DTT%XPAR_D_WALL
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL ALLOCATE_THERMAL_WORK(BDD%NDESC_WALL_LAYER)
    CALL INI_DATA_PARAM_TEB(BDD, &
                            DTT%NPAR_BLDCODE,PHC_WALL=ZHC)
    CALL INI_DATA_PARAM_TEB(BDD, &
                            DTT%NPAR_BLDCODE,PTC_WALL=ZTC)
    CALL INI_DATA_PARAM_TEB(BDD, &
                            DTT%NPAR_BLDCODE,PD_WALL =ZD )
  ELSE
    CALL ALLOCATE_THERMAL_WORK(NDATA_WALL_LAYER)
    DO JLAYER=1,NDATA_WALL_LAYER
      CALL AV_PGD(DTCO, &
                 ZHC(:,JLAYER), PCOVER, XDATA_HC_WALL (:,JLAYER),YAREA,YAVG,OCOVER)
      CALL AV_PGD(DTCO, &
                 ZTC(:,JLAYER), PCOVER ,XDATA_TC_WALL (:,JLAYER),YAREA,YAVG,OCOVER)
      CALL AV_PGD(DTCO, &
                 ZD (:,JLAYER), PCOVER ,XDATA_D_WALL  (:,JLAYER),YAREA,YAVG,OCOVER)
    ENDDO
  ENDIF  
  CALL THERMAL_LAYERS_CONF('WALL ',ZHC,ZTC,ZD,PHC_WALL,PTC_WALL,PD_WALL)
  CALL DEALLOCATE_THERMAL_WORK
ENDIF
!
!      HC_FLOOR, TC_FLOOR, D_FLOOR
!      ------------------------
!
IF (PRESENT(PHC_FLOOR) .AND. PRESENT(PTC_FLOOR) .AND. PRESENT(PD_FLOOR)) THEN
  IF (DTB%LDATA_HC_FLOOR) THEN
    CALL ALLOCATE_THERMAL_WORK(DTB%NPAR_FLOOR_LAYER)
    ZHC=DTB%XPAR_HC_FLOOR
    ZTC=DTB%XPAR_TC_FLOOR
    ZD =DTB%XPAR_D_FLOOR
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL ALLOCATE_THERMAL_WORK(BDD%NDESC_FLOOR_LAYER)
    CALL INI_DATA_PARAM_TEB(BDD, &
                            DTT%NPAR_BLDCODE,PHC_FLOOR=ZHC)
    CALL INI_DATA_PARAM_TEB(BDD, &
                            DTT%NPAR_BLDCODE,PTC_FLOOR=ZTC)
    CALL INI_DATA_PARAM_TEB(BDD, &
                            DTT%NPAR_BLDCODE,PD_FLOOR =ZD )
  ELSE
    CALL ALLOCATE_THERMAL_WORK(NDATA_FLOOR_LAYER)
    DO JLAYER=1,NDATA_FLOOR_LAYER
      CALL AV_PGD(DTCO, &
                 ZHC(:,JLAYER), PCOVER, XDATA_HC_FLOOR (:,JLAYER),YAREA,YAVG,OCOVER)
      CALL AV_PGD(DTCO, &
                 ZTC(:,JLAYER), PCOVER ,XDATA_TC_FLOOR (:,JLAYER),YAREA,YAVG,OCOVER)
      CALL AV_PGD(DTCO, &
                 ZD (:,JLAYER), PCOVER ,XDATA_D_FLOOR  (:,JLAYER),YAREA,YAVG,OCOVER)
    ENDDO
  ENDIF  
  CALL THERMAL_LAYERS_CONF('FLOOR',ZHC,ZTC,ZD,PHC_FLOOR,PTC_FLOOR,PD_FLOOR)
  CALL DEALLOCATE_THERMAL_WORK
ENDIF
!
!     H_TRAFFIC
!     ---------
IF (PRESENT(PH_TRAFFIC)) THEN
  IF (DTT%LDATA_H_TRAFFIC) THEN
    PH_TRAFFIC=DTT%XPAR_H_TRAFFIC
  ELSE
    CALL AV_PGD(DTCO, &
                 PH_TRAFFIC ,PCOVER ,XDATA_H_TRAFFIC(:),'TWN','ARI',OCOVER)
  ENDIF  
ENDIF
!
!     LE_TRAFFIC
!     ----------
IF (PRESENT(PLE_TRAFFIC)) THEN
  IF (DTT%LDATA_LE_TRAFFIC) THEN
    PLE_TRAFFIC=DTT%XPAR_LE_TRAFFIC
  ELSE
    CALL AV_PGD(DTCO, &
                 PLE_TRAFFIC ,PCOVER ,XDATA_LE_TRAFFIC(:),'TWN','ARI',OCOVER)
  ENDIF  
ENDIF
!
!     H_INDUSTRY
!     ----------
IF (PRESENT(PH_INDUSTRY)) THEN
  IF (DTT%LDATA_H_INDUSTRY) THEN
    PH_INDUSTRY=DTT%XPAR_H_INDUSTRY
  ELSE
    CALL AV_PGD(DTCO, &
                 PH_INDUSTRY ,PCOVER ,XDATA_H_INDUSTRY(:),'TWN','ARI',OCOVER)
  ENDIF  
ENDIF
!
!     SOLAR PANELS
!     ------------
IF (PRESENT(PEMIS_PANEL)) THEN
  IF (DTT%LDATA_EMIS_PANEL) THEN
    PEMIS_PANEL=DTT%XPAR_EMIS_PANEL
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, &
                            DTT%NPAR_BLDCODE,PEMIS_PANEL=PEMIS_PANEL)
  ELSE
    CALL AV_PGD(DTCO, &
                 PEMIS_PANEL ,PCOVER ,XDATA_EMIS_PANEL(:),'BLD','ARI',OCOVER)
  ENDIF  
ENDIF
!
IF (PRESENT(PALB_PANEL)) THEN
  IF (DTT%LDATA_ALB_PANEL) THEN
    PALB_PANEL=DTT%XPAR_ALB_PANEL
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, &
                            DTT%NPAR_BLDCODE,PALB_PANEL=PALB_PANEL)
  ELSE
    CALL AV_PGD(DTCO, &
                 PALB_PANEL ,PCOVER ,XDATA_ALB_PANEL(:),'BLD','ARI',OCOVER)
  ENDIF  
ENDIF
!
IF (PRESENT(PEFF_PANEL)) THEN
  IF (DTT%LDATA_EFF_PANEL) THEN
    PEFF_PANEL=DTT%XPAR_EFF_PANEL
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, &
                            DTT%NPAR_BLDCODE,PEFF_PANEL=PEFF_PANEL)
  ELSE
    CALL AV_PGD(DTCO, &
                 PEFF_PANEL ,PCOVER ,XDATA_EFF_PANEL(:),'BLD','ARI',OCOVER)
  ENDIF  
ENDIF
!
IF (PRESENT(PFRAC_PANEL)) THEN
  IF (DTT%LDATA_FRAC_PANEL) THEN
    PFRAC_PANEL=DTT%XPAR_FRAC_PANEL
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, &
                            DTT%NPAR_BLDCODE,PFRAC_PANEL=PFRAC_PANEL)
  ELSE
    CALL AV_PGD(DTCO, &
                 PFRAC_PANEL ,PCOVER ,XDATA_FRAC_PANEL(:),'BLD','ARI',OCOVER)
  ENDIF  
ENDIF
!
!     LE_INDUSTRY
!     -----------
IF (PRESENT(PLE_INDUSTRY)) THEN
  IF (DTT%LDATA_LE_INDUSTRY) THEN
    PLE_INDUSTRY=DTT%XPAR_LE_INDUSTRY
  ELSE
    CALL AV_PGD(DTCO, &
                 PLE_INDUSTRY ,PCOVER ,XDATA_LE_INDUSTRY(:),'TWN','ARI',OCOVER)
  ENDIF  
ENDIF
!
!     TCOOL_TARGET
!     -----------
IF (PRESENT(PTCOOL_TARGET)) THEN
  IF (DTB%LDATA_TCOOL_TARGET) THEN
    PTCOOL_TARGET=DTB%XPAR_TCOOL_TARGET
  ELSEIF (DTT%LDATA_USETYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, &
                            DTT%NPAR_USETYPE,PTCOOL_TARGET=PTCOOL_TARGET)
  ELSE
    CALL AV_PGD(DTCO, &
                 PTCOOL_TARGET ,PCOVER ,XDATA_TCOOL_TARGET(:),'TWN','ARI',OCOVER)
  ENDIF  
ENDIF
!
!     THEAT_TARGET
!     -----------
IF (PRESENT(PTHEAT_TARGET)) THEN
  IF (DTB%LDATA_THEAT_TARGET) THEN
    PTHEAT_TARGET=DTB%XPAR_THEAT_TARGET
  ELSEIF (DTT%LDATA_USETYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, &
                            DTT%NPAR_USETYPE,PTHEAT_TARGET=PTHEAT_TARGET)
  ELSE
    CALL AV_PGD(DTCO, &
                 PTHEAT_TARGET ,PCOVER ,XDATA_THEAT_TARGET(:),'TWN','ARI',OCOVER)
  ENDIF  
ENDIF
!
!     -----------
IF (PRESENT(PF_WASTE_CAN)) THEN
  IF (DTB%LDATA_F_WASTE_CAN) THEN
    PF_WASTE_CAN=DTB%XPAR_F_WASTE_CAN
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, &
                            DTT%NPAR_BLDCODE,PF_WASTE_CAN=PF_WASTE_CAN)
  ELSE
    CALL AV_PGD(DTCO, &
                 PF_WASTE_CAN ,PCOVER ,XDATA_F_WASTE_CAN(:),'TWN','ARI',OCOVER)
  ENDIF  
ENDIF
!
!     EFF_HEAT
!     -----------
IF (PRESENT(PEFF_HEAT)) THEN
  IF (DTB%LDATA_EFF_HEAT) THEN
    PEFF_HEAT=DTB%XPAR_EFF_HEAT
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, &
                            DTT%NPAR_BLDCODE,PEFF_HEAT=PEFF_HEAT)
  ELSE
    CALL AV_PGD(DTCO, &
                 PEFF_HEAT ,PCOVER ,XDATA_EFF_HEAT(:),'TWN','ARI',OCOVER)
  ENDIF  
ENDIF
!
!     QIN
!     -----------
IF (PRESENT(PQIN)) THEN
  IF (DTB%LDATA_QIN) THEN
    PQIN=DTB%XPAR_QIN
  ELSEIF (DTT%LDATA_USETYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, &
                            DTT%NPAR_USETYPE,PQIN=PQIN)
  ELSE
    CALL AV_PGD(DTCO, &
                 PQIN ,PCOVER ,XDATA_QIN(:),'TWN','ARI',OCOVER)
  ENDIF  
ENDIF
!
!     QIN_FRAD
!     -----------
IF (PRESENT(PQIN_FRAD)) THEN
  IF (DTB%LDATA_QIN_FRAD) THEN
    PQIN_FRAD=DTB%XPAR_QIN_FRAD
  ELSEIF (DTT%LDATA_USETYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, &
                            DTT%NPAR_USETYPE,PQIN_FRAD=PQIN_FRAD)
  ELSE
    CALL AV_PGD(DTCO, &
                 PQIN_FRAD ,PCOVER ,XDATA_QIN_FRAD(:),'TWN','ARI',OCOVER)
  ENDIF  
ENDIF
!
!     SHGC
!     -----------
IF (PRESENT(PSHGC)) THEN
  IF (DTB%LDATA_SHGC) THEN
    PSHGC=DTB%XPAR_SHGC
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, &
                            DTT%NPAR_BLDCODE,PSHGC=PSHGC)
  ELSE
    CALL AV_PGD(DTCO, &
                 PSHGC ,PCOVER ,XDATA_SHGC(:),'TWN','ARI',OCOVER)
  ENDIF  
ENDIF
!
!     U_WIN
!     -----------
IF (PRESENT(PU_WIN)) THEN
  IF (DTB%LDATA_U_WIN) THEN
    PU_WIN=DTB%XPAR_U_WIN
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, &
                            DTT%NPAR_BLDCODE,PU_WIN=PU_WIN)
  ELSE
    CALL AV_PGD(DTCO, &
                 PU_WIN ,PCOVER ,XDATA_U_WIN(:),'TWN','ARI',OCOVER)
  ENDIF  
ENDIF
!
!     GR
!     -----------
IF (PRESENT(PGR)) THEN
  IF (DTB%LDATA_GR) THEN
    PGR=DTB%XPAR_GR
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, &
                            DTT%NPAR_BLDCODE,PGR=PGR)
  ELSE
    CALL AV_PGD(DTCO, &
                 PGR ,PCOVER ,XDATA_GR(:),'TWN','ARI',OCOVER)
  ENDIF  
ENDIF
!
!     SHGC_SH
!     -----------
IF (PRESENT(PSHGC_SH)) THEN
  IF (DTB%LDATA_SHGC_SH) THEN
    PSHGC_SH=DTB%XPAR_SHGC_SH
  ELSEIF (DTT%LDATA_USETYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, &
                            DTT%NPAR_USETYPE,PSHGC_SH=PSHGC_SH)
  ELSE
    CALL AV_PGD(DTCO, &
                 PSHGC_SH ,PCOVER ,XDATA_SHGC_SH(:),'TWN','ARI',OCOVER)
  ENDIF  
ENDIF
!
!     FLOOR_HEIGHT
!     -----------
IF (PRESENT(PFLOOR_HEIGHT)) THEN
  IF (DTB%LDATA_FLOOR_HEIGHT) THEN
    PFLOOR_HEIGHT=DTB%XPAR_FLOOR_HEIGHT
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, &
                            DTT%NPAR_BLDCODE,PFLOOR_HEIGHT=PFLOOR_HEIGHT)
  ELSE
    CALL AV_PGD(DTCO, &
                 PFLOOR_HEIGHT ,PCOVER ,XDATA_FLOOR_HEIGHT(:),'TWN','ARI',OCOVER)
  ENDIF  
ENDIF
!
!     INF
!     -----------
IF (PRESENT(PINF)) THEN
  IF (DTB%LDATA_INF) THEN
    PINF=DTB%XPAR_INF
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, &
                            DTT%NPAR_BLDCODE,PINF=PINF)
  ELSE
    CALL AV_PGD(DTCO, &
                 PINF ,PCOVER ,XDATA_INF(:),'TWN','ARI',OCOVER)
  ENDIF  
ENDIF
!
!     F_WATER_COND
!     -----------
IF (PRESENT(PF_WATER_COND)) THEN
  IF (DTB%LDATA_F_WATER_COND) THEN
    PF_WATER_COND=DTB%XPAR_F_WATER_COND
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, &
                            DTT%NPAR_BLDCODE,PF_WATER_COND=PF_WATER_COND)
  ELSE
    CALL AV_PGD(DTCO, &
                 PF_WATER_COND ,PCOVER ,XDATA_F_WATER_COND(:),'TWN','ARI',OCOVER)
  ENDIF  
ENDIF
!
!     QIN_FLAT
!     -----------
IF (PRESENT(PQIN_FLAT)) THEN
  IF (DTB%LDATA_QIN_FLAT) THEN
    PQIN_FLAT=DTB%XPAR_QIN_FLAT
  ELSEIF (DTT%LDATA_USETYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, &
                            DTT%NPAR_USETYPE,PQIN_FLAT=PQIN_FLAT)
  ELSE
    CALL AV_PGD(DTCO, &
                 PQIN_FLAT ,PCOVER ,XDATA_QIN_FLAT(:),'TWN','ARI',OCOVER)
  ENDIF  
ENDIF
!
!     HR_TARGET
!     -----------
IF (PRESENT(PHR_TARGET)) THEN
  IF (DTB%LDATA_HR_TARGET) THEN
    PHR_TARGET=DTB%XPAR_HR_TARGET
  ELSEIF (DTT%LDATA_USETYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, &
                            DTT%NPAR_USETYPE,PHR_TARGET=PHR_TARGET)
  ELSE
    CALL AV_PGD(DTCO, &
                 PHR_TARGET ,PCOVER ,XDATA_HR_TARGET(:),'TWN','ARI',OCOVER)
  ENDIF  
ENDIF
!
!     V_VENT
!     -----------
IF (PRESENT(PV_VENT)) THEN
  IF (DTB%LDATA_V_VENT) THEN
    PV_VENT=DTB%XPAR_V_VENT
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, &
                            DTT%NPAR_BLDCODE,PV_VENT=PV_VENT)
  ELSE
    CALL AV_PGD(DTCO, &
                 PV_VENT ,PCOVER ,XDATA_V_VENT(:),'TWN','ARI',OCOVER)
  ENDIF  
ENDIF
!
!     CAP_SYS_HEAT
!     -----------
IF (PRESENT(PCAP_SYS_HEAT)) THEN
  IF (DTB%LDATA_CAP_SYS_HEAT) THEN
    PCAP_SYS_HEAT=DTB%XPAR_CAP_SYS_HEAT
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, &
                            DTT%NPAR_BLDCODE,PCAP_SYS_HEAT=PCAP_SYS_HEAT)
  ELSE
    CALL AV_PGD(DTCO, &
                 PCAP_SYS_HEAT ,PCOVER ,XDATA_CAP_SYS_HEAT(:),'TWN','ARI',OCOVER)
  ENDIF  
ENDIF
!
!     CAP_SYS_RAT
!     -----------
IF (PRESENT(PCAP_SYS_RAT)) THEN
  IF (DTB%LDATA_CAP_SYS_RAT) THEN
    PCAP_SYS_RAT=DTB%XPAR_CAP_SYS_RAT
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, &
                            DTT%NPAR_BLDCODE,PCAP_SYS_RAT=PCAP_SYS_RAT)
  ELSE
    CALL AV_PGD(DTCO, &
                 PCAP_SYS_RAT ,PCOVER ,XDATA_CAP_SYS_RAT(:),'TWN','ARI',OCOVER)
  ENDIF  
ENDIF
!
!     T_ADP
!     -----------
IF (PRESENT(PT_ADP)) THEN
  IF (DTB%LDATA_T_ADP) THEN
    PT_ADP=DTB%XPAR_T_ADP
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, &
                            DTT%NPAR_BLDCODE,PT_ADP=PT_ADP)
  ELSE
    CALL AV_PGD(DTCO, &
                 PT_ADP ,PCOVER ,XDATA_T_ADP(:),'TWN','ARI',OCOVER)
  ENDIF  
ENDIF
!
!     M_SYS_RAT
!     -----------
IF (PRESENT(PM_SYS_RAT)) THEN
  IF (DTB%LDATA_M_SYS_RAT) THEN
    PM_SYS_RAT=DTB%XPAR_M_SYS_RAT
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, &
                            DTT%NPAR_BLDCODE,PM_SYS_RAT=PM_SYS_RAT)
  ELSE
    CALL AV_PGD(DTCO, &
                 PM_SYS_RAT ,PCOVER ,XDATA_M_SYS_RAT(:),'TWN','ARI',OCOVER)
  ENDIF  
ENDIF
!
!     COP_RAT
!     -----------
IF (PRESENT(PCOP_RAT)) THEN
  IF (DTB%LDATA_COP_RAT) THEN
    PCOP_RAT=DTB%XPAR_COP_RAT
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, &
                            DTT%NPAR_BLDCODE,PCOP_RAT=PCOP_RAT)
  ELSE
    CALL AV_PGD(DTCO, &
                 PCOP_RAT ,PCOVER ,XDATA_COP_RAT(:),'TWN','ARI',OCOVER)
  ENDIF  
ENDIF
!
!     GREENROOF FRACTION
!     ------------------
IF (PRESENT(PGREENROOF)) THEN
  IF (DTT%LDATA_GREENROOF) THEN
    PGREENROOF=DTT%XPAR_GREENROOF
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, &
                            DTT%NPAR_BLDCODE,PGREENROOF=PGREENROOF)
  ELSE
    CALL AV_PGD(DTCO, &
                 PGREENROOF,PCOVER ,XDATA_FRAC_GR(:),'BLD','ARI',OCOVER)
  ENDIF  
ENDIF
!
!     T_SIZE_MAX
!     -----------
IF (PRESENT(PT_SIZE_MAX)) THEN
  IF (DTB%LDATA_T_SIZE_MAX) THEN
    PT_SIZE_MAX=DTB%XPAR_T_SIZE_MAX
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, &
                            DTT%NPAR_BLDCODE,PT_SIZE_MAX=PT_SIZE_MAX)
  ELSE
    CALL AV_PGD(DTCO, &
                 PT_SIZE_MAX ,PCOVER ,XDATA_T_SIZE_MAX(:),'TWN','ARI',OCOVER)
  ENDIF  
ENDIF
!
!     T_SIZE_MIN
!     -----------
IF (PRESENT(PT_SIZE_MIN)) THEN
  IF (DTB%LDATA_T_SIZE_MIN) THEN
    PT_SIZE_MIN=DTB%XPAR_T_SIZE_MIN
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, &
                            DTT%NPAR_BLDCODE,PT_SIZE_MIN=PT_SIZE_MIN)
  ELSE
    CALL AV_PGD(DTCO, &
                 PT_SIZE_MIN ,PCOVER ,XDATA_T_SIZE_MIN(:),'TWN','ARI',OCOVER)
  ENDIF  
ENDIF
!
!     SHADE
!     -----
IF (PRESENT(PSHADE)) THEN
  IF (DTB%LDATA_SHADE) THEN
    PSHADE(:) = DTB%XPAR_SHADE(:)
  ELSEIF (DTT%LDATA_USETYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, &
                            DTT%NPAR_USETYPE,PSHADE=PSHADE)
  ELSE
    CALL AV_PGD(DTCO, &
                 PSHADE,PCOVER ,XDATA_SHADE(:),'TWN','ARI',OCOVER)
  ENDIF  
ENDIF
!
!     NATVENT
!     -------
IF (PRESENT(PNATVENT)) THEN
  IF (DTB%LDATA_NATVENT) THEN
    PNATVENT(:) = DTB%XPAR_NATVENT(:)
  ELSEIF (DTT%LDATA_USETYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, &
                            DTT%NPAR_USETYPE,PNATVENT=PNATVENT)
  ELSE
    CALL AV_PGD(DTCO, &
                 PNATVENT,PCOVER,XDATA_NATVENT(:),'TWN','ARI',OCOVER)
  ENDIF  
ENDIF
!
!
!      ROUGH_ROOF
!      ----------
IF (PRESENT(PROUGH_ROOF)) THEN 
  IF (DTT%LDATA_ROUGH_ROOF) THEN
    PROUGH_ROOF=DTT%XPAR_ROUGH_ROOF
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, &
                            DTT%NPAR_BLDCODE,PROUGH_ROOF=PROUGH_ROOF)
  ELSE
    CALL AV_PGD(DTCO, &
                 PROUGH_ROOF ,PCOVER ,XDATA_ROUGH_ROOF (:),YAREA,YAVG,OCOVER)  
  ENDIF  
ENDIF
!
!      ROUGH_WALL
!      ----------
IF (PRESENT(PROUGH_WALL)) THEN 
  IF (DTT%LDATA_ROUGH_WALL) THEN
    PROUGH_WALL=DTT%XPAR_ROUGH_WALL
  ELSEIF (DTT%LDATA_BLDTYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, &
                            DTT%NPAR_BLDCODE,PROUGH_WALL=PROUGH_WALL)
  ELSE
    CALL AV_PGD(DTCO, &
                 PROUGH_WALL ,PCOVER ,XDATA_ROUGH_WALL (:),YAREA,YAVG,OCOVER)  
  ENDIF  
ENDIF
!
!      RESIDENTIAL use fraction
!      ------------------------
IF (PRESENT(PRESIDENTIAL)) THEN 
  IF (DTT%LDATA_RESIDENTIAL) THEN
    PRESIDENTIAL=DTT%XPAR_RESIDENTIAL
  ELSEIF (DTT%LDATA_USETYPE) THEN
    CALL INI_DATA_PARAM_TEB(BDD, &
                            DTT%NPAR_USETYPE,PRESIDENTIAL=PRESIDENTIAL)
  ELSE
    CALL AV_PGD(DTCO, &
                 PRESIDENTIAL ,PCOVER ,XDATA_RESIDENTIAL (:),YAREA,YAVG,OCOVER)  
  ENDIF  
ENDIF
! 
!
IF (LHOOK) CALL DR_HOOK('CONVERT_PATCH_TEB',1,ZHOOK_HANDLE)
!
!-------------------------------------------------------------------------------
CONTAINS
!
SUBROUTINE ALLOCATE_THERMAL_WORK(KPAR)
INTEGER, INTENT(IN) :: KPAR
ALLOCATE(ZD(IL,KPAR))
ALLOCATE(ZHC(IL,KPAR))
ALLOCATE(ZTC(IL,KPAR))
END SUBROUTINE ALLOCATE_THERMAL_WORK
SUBROUTINE DEALLOCATE_THERMAL_WORK
DEALLOCATE(ZD)
DEALLOCATE(ZHC)
DEALLOCATE(ZTC)
END SUBROUTINE DEALLOCATE_THERMAL_WORK
!-------------------------------------------------------------------------------
!
END SUBROUTINE CONVERT_PATCH_TEB
